/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class Debug {
    Engine engine;
    Map m;
    private int dTime;
    private static final byte D_MENU = 0;
    private static final byte D_SCRIPT = 1;
    private static final byte D_MAP = 2;
    private static final byte D_SPRTIE = 3;
    private static final byte D_MORE = 4;
    private static final byte D_SPRTIEPROPERTY = 5;
    private static final byte D_SYSTEMINFO = 6;
    private static final byte D_RANK = 7;
    private static final byte D_MAPINFO = 8;
    private static final byte D_SETSPRTIE = 9;
    private static final byte D_BATTLESCRIPT = 10;
    private static final byte D_MONITOR = 11;
    private int strHeight = GCanvas.FONT_SMALL.getHeight();
    private static final String version = "[#] 1.0";
    private int index;
    private int debugST;
    public static boolean isDebug;
    private String[] debugMenu = new String[]{"\u811a\u672c\u4e8b\u4ef6", "\u8bbe\u7f6e\u5173\u5361", "\u5730\u56fe\u5c5e\u6027", "\u7cbe\u7075\u5c5e\u6027", "\u7cfb\u7edf\u4fe1\u606f", "\u5e38\u7528\u529f\u80fd", "\u589e\u52a0\u91d1\u94b1", "\u589e\u52a0\u7ecf\u9a8c", "\u66f4\u6539\u79fb\u901f", "\u5185\u5b58\u76d1\u63a7"};
    private int[] rank = new int[]{0, 0, 0};
    int lastX;
    int lastY;
    boolean b1 = true;
    boolean b2 = true;
    boolean b3 = true;
    int px;
    int py;
    private int rowNumber = 14;
    private boolean pressedUp;
    private boolean pressedDown;
    private boolean pressedLeft;
    private boolean pressedRight;
    byte spriteIndex;
    String[] moreMenu = new String[]{"\u5185\u5b58\u76d1\u89c6", "\u7cbe\u7075\u6807\u8bb0", "\u6e38\u620f\u901f\u5ea6", "\u5730\u56fe\u7f51\u683c", "\u89e6\u96f7\u5f00\u5173"};
    String[] moreInfo = new String[]{"\u6253\u5370\u5185\u5b58\u4f7f\u7528\u60c5\u51b5\u548c\u7ed8\u56fe\u6b21\u6570", "\u5728\u6bcf\u4e2a\u7cbe\u7075\u8eab\u4e0a\u6807\u8bb0\u51fa\u7cbe\u7075\u7684ID", "\u53ef\u4ee5\u63091\uff0c3\u952e\u6539\u53d8\u6e38\u620f\u901f\u5ea6", "\u663e\u793a\u5730\u56fe\u7f51\u683c", "\u5173\u95ed/\u5f00\u542f\u5730\u56fe\u4e0a\u7684\u660e\u96f7"};
    boolean[] more = new boolean[this.moreMenu.length];
    private short[] sleepTime = new short[]{30, 45, 60, 90, 120, 300, 500, 1000};
    private byte sleepIndex = 1;
    int delay = 8;
    static Vector memory;
    static long[] monitor;

    public Debug(Engine en) {
        this.engine = en;
        this.m = Engine.map;
    }

    private void drawDebugMenu(int x2, int y2, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        String[] info = new String[]{"\u67e5\u770b\u3001\u8bbe\u7f6e\u3001\u811a\u672c\u4e8b\u4ef6", "\u8bbe\u7f6e\u5f00\u59cb\u6e38\u620f\u7684\u5173\u5361\uff0c\u8df3\u5173", "\u67e5\u770b\u5730\u56fe\u5c5e\u6027\uff0c\u88c5\u9970\uff0c\u5207\u7247\u5c5e\u6027\u7b49", "\u67e5\u770b\u3001\u8bbe\u7f6e\u7cbe\u7075\u5c5e\u6027", "\u67e5\u770b\u5e38\u89c1\u7684\u7cfb\u7edf\u53d8\u91cf\u503c", "\u5e38\u7528\u529f\u80fd\u5408\u96c6", "\u6bcf\u6b21\u70b9\u51fb\u589e\u52a0\u4e00\u4e07\u91d1\u94b1", "\u6bcf\u6b21\u70b9\u51fb\u589e\u52a0\u4e00\u4e07\u7ecf\u9a8c", "\u6bcf\u6b21\u70b9\u51fb\u66f4\u6539\u5f53\u524d\u63a7\u5236\u7cbe\u7075nextSpeed", "\u67e5\u770b\u6e38\u620f\u5404\u90e8\u5206\u5185\u5b58\u4f7f\u7528\u72b6\u51b5"};
        int dis = this.strHeight + 2;
        int i2 = 0;
        while (i2 < this.debugMenu.length) {
            int color = i2 == 3 && !this.spriteIsInit() ? 0x999999 : (i2 != this.index ? 0xFFFFFF : 0xFFFF33);
            Tools.addString(this.debugMenu[i2], x2 + 20, y2 + 30 + i2 * dis, (byte)2, color, drawLevel);
            ++i2;
        }
        Tools.addString(info[this.index], x2 + 20, y2 + 320 - 60, (byte)2, 16775337, drawLevel);
        Tools.addRect(x2 + 18, y2 + 32 + this.index * dis, this.strHeight * this.debugMenu[this.index].length(), 1, true, (byte)2, 0xFFFFFF, drawLevel);
        this.drawYesNo("\u786e\u5b9a", "\u9000\u51fa", drawLevel);
    }

    private boolean spriteIsInit() {
        return Engine.sprite != null;
    }

    private void drawSetGameRank(int x2, int y2, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        String[] setGameRank = new String[]{"\u8bf7\u9009\u62e9\u521d\u59cb\u5316\u5173\u5361"};
        int i2 = 0;
        while (i2 < setGameRank.length) {
            Tools.addString(setGameRank[i2], x2 + 120, y2 + 30 + i2 * 15, (byte)4, 16775337, drawLevel);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.rank.length) {
            Tools.addString(this.rank[i3] + "", x2 + Map.screenWidth / 2 - 30 + i3 * 20, y2 + 100, (byte)2, 0xFFFFFF, drawLevel);
            ++i3;
        }
        Tools.addString("*", x2 + Map.screenWidth / 2 - 30 + this.index * 20, y2 + 80 + (this.dTime % 2 == 0 ? -1 : 0), (byte)2, 0xFFFFFF, drawLevel);
        Tools.addString("*", x2 + Map.screenWidth / 2 - 30 + this.index * 20, y2 + 105 + (this.dTime % 2 == 0 ? 1 : 0), (byte)0, 0xFFFFFF, drawLevel);
        this.drawYesNo(GCanvas.gameStatus > 0 ? "\u8df3\u81f3\u6b64\u5173" : "", "\u66f4\u6539", drawLevel);
    }

    private int getRank(int[] dat) {
        int rank = 0;
        int i2 = 0;
        while (i2 < dat.length) {
            rank += dat[i2] * Debug.square(10, dat.length - 1 - i2);
            ++i2;
        }
        return rank;
    }

    static int square(int base, int exponent) {
        int pro = 1;
        int i2 = 0;
        while (i2 < exponent) {
            pro *= base;
            ++i2;
        }
        return pro;
    }

    private void drawMapProperty(int x2, int y2, int drawLevel) {
        String[] stringArray = new String[6];
        stringArray[0] = "\u5730\u56fe\u5e8f\u53f7 \uff1a " + this.m.mapID;
        stringArray[1] = "\u5730\u56fe\u540d\u79f0 \uff1a " + this.m.mapName;
        stringArray[2] = "\u5730\u56fe\u6587\u4ef6 \uff1a " + (Engine.map.fileName == null ? "null" : this.m.fileName + "a.dat");
        stringArray[3] = "\u6218\u6597\u80cc\u666f \uff1a " + this.m.battleBg;
        stringArray[4] = "\u654c\u4eba\u7b49\u7ea7 \uff1a " + this.m.mfLevel;
        stringArray[5] = "\u654c\u4eba\u7c7b\u578b \uff1a " + this.toString(this.m.enemys);
        String[] mapProperty = stringArray;
        this.drawColorScreenBG(0, drawLevel);
        int i2 = 0;
        while (i2 < mapProperty.length) {
            Tools.addString(mapProperty[i2], x2 + 20, y2 + 30 + i2 * 15, (byte)2, 0xFFFFFF, drawLevel);
            ++i2;
        }
        this.drawYesNo(Map.mData[0] == null ? "" : "\u5168\u5c40\u5730\u56fe", "\u8fd4\u56de", drawLevel);
    }

    private String toString(short[] dat) {
        String str = null;
        if (dat != null) {
            str = new String("");
            int i2 = 0;
            while (i2 < dat.length) {
                str = str + dat[i2] + ",";
                ++i2;
            }
        }
        return str;
    }

    private void initMap() {
        this.lastX = Map.setOffX;
        this.lastY = Map.setOffY;
        this.px = 0;
        this.py = 0;
    }

    private void drawMapInfoUI(int drawLevel) {
        Tools.addColorString("\u5750\u6807 (" + this.px + "," + this.py + ")", Map.setOffX + 2, Map.setOffY + 2, (byte)0, 0, 15062383, drawLevel);
        Tools.addColorString("\u683c\u5b50 (" + this.px / Map.tileWidth + "," + this.py / Map.tileHight + ")", Map.setOffX + Map.screenWidth - 2, Map.setOffY + 2, (byte)6, 0, 15062383, drawLevel);
        String[] str = new String[]{"[#] \u88c5\u9970", "[0] \u963b\u6321", "[*] \u7f51\u683c"};
        int i2 = 0;
        while (i2 < str.length) {
            Tools.addColorString(str[i2], Map.setOffX + 2, Map.setOffY + Map.screenHeight - 2 - 15 * i2, (byte)2, 0, 15062383, drawLevel);
            ++i2;
        }
    }

    private void drawCanNotMove(int drawLevel) {
        int n2 = Map.setOffX / Map.tileWidth * Map.mapSize[1] + Map.setOffY / Map.tileHight;
        int nw = Map.screenWidth / Map.tileWidth + 2;
        int nh = Map.screenHeight / Map.tileHight + 2;
        int j2 = 0;
        while (j2 < nw) {
            int s2;
            int i2 = s2 = n2 + j2 * Map.mapSize[1];
            while (i2 < s2 + nh) {
                if (i2 < Map.mData[0].length && i2 >= 0) {
                    int x2 = i2 / Map.mapSize[1] * Map.tileHight;
                    int y2 = i2 % Map.mapSize[1] * Map.tileWidth;
                    if (!this.m.canRun(x2 + Map.tileWidth / 2, y2 + Map.tileHight / 2)) {
                        Tools.addRect(x2, y2, Map.tileWidth, Map.tileHight, false, (byte)0, this.dTime % 10 < 5 ? 0xFF0000 : 0xFFFF99, drawLevel);
                    }
                }
                ++i2;
            }
            ++j2;
        }
    }

    private void drawDecorations() {
    }

    private void drawMapInfo(Graphics g2) {
        Engine.map.drawMap(g2, Map.setOffX, Map.setOffY);
        this.drawMapInfoUI(9999);
        if (this.b3) {
            this.drawGrid(30);
        }
        if (this.b2) {
            this.drawCanNotMove(30);
        }
        if (this.b1) {
            this.drawDecorations();
        }
        this.drawCursor(9999);
        this.m.moveSrceen(this.px, this.py);
        if (this.pressedUp) {
            if (--this.delay <= 0) {
                this.py -= Map.tileHight;
            }
            this.py = Math.max(0, this.py);
        }
        if (this.pressedDown) {
            if (--this.delay <= 0) {
                this.py += Map.tileHight;
            }
            this.py = Math.min(this.py, (Map.mapSize[1] - 1) * Map.tileHight);
        }
        if (this.pressedLeft) {
            if (--this.delay <= 0) {
                this.px -= Map.tileWidth;
            }
            this.px = Math.max(0, this.px);
        }
        if (this.pressedRight) {
            if (--this.delay <= 0) {
                this.px += Map.tileWidth;
            }
            this.px = Math.min(this.px, (Map.mapSize[0] - 1) * Map.tileWidth);
        }
        this.drawYesNo("", "\u8fd4\u56de", 9999);
    }

    private void drawCursor(int drawLevel) {
        Tools.addARC(this.px + 4, this.py + 4, 8, 8, 0, 360, true, (byte)0, this.dTime % 4 < 2 ? 0xFF0000 : 0xFFFF99, drawLevel);
    }

    private void drawScript(int x2, int y2, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        String[] title = new String[]{"\u4e8b\u4ef6ID", "\u4e8b\u4ef6\u503c"};
        int dis = 15;
        int i2 = 0;
        while (i2 < title.length) {
            Tools.addString(title[i2], x2 + 60 + i2 * 240 / 2, y2 + 30, (byte)4, 15062383, drawLevel);
            ++i2;
        }
        int i3 = this.index / this.rowNumber * this.rowNumber;
        while (i3 < Math.min(this.index / this.rowNumber * this.rowNumber + this.rowNumber, Variable.scriptVar.length)) {
            Tools.addString("event[" + i3 + "] : ", x2 + 60, y2 + 50 + i3 % this.rowNumber * dis, (byte)4, 0xFFFFFF, drawLevel);
            Tools.addString(Variable.scriptVar[i3] + "", x2 + 180, y2 + 50 + i3 % this.rowNumber * dis, (byte)4, Variable.scriptVar[i3] == 0 ? 0xFFFFFF : 0x33FF33, drawLevel);
            ++i3;
        }
        Tools.addRect(x2 + 10, y2 + 58 + this.index % this.rowNumber * dis, 200, 1, true, (byte)2, 0xFFFFFF, drawLevel);
        Tools.addString(this.index + " / " + Variable.scriptVar.length, x2 + 120, y2 + 320 - 10, (byte)4, 0xFFFFFF, drawLevel);
        if (this.index >= this.rowNumber) {
            Tools.addString("<<", x2 + 60, y2 + 320 - 10, (byte)4, this.dTime % 3 == 0 ? 0xFFFFFF : 0xFF0000, drawLevel);
        }
        if (this.index <= Variable.scriptVar.length / this.rowNumber * this.rowNumber) {
            Tools.addString(">>", x2 + 180, y2 + 320 - 10, (byte)4, this.dTime % 3 == 0 ? 0xFFFFFF : 0xFF0000, drawLevel);
        }
        if (this.pressedUp) {
            if (--this.delay <= 0) {
                --this.index;
            }
            this.index = Math.max(0, this.index);
        }
        if (this.pressedDown) {
            if (--this.delay <= 0) {
                ++this.index;
            }
            this.index = Math.min(this.index, Variable.scriptVar.length - 1);
        }
        this.drawYesNo("\u4fee\u6539", "\u8fd4\u56de", drawLevel);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawSprite(int x2, int y2, int drawLevel) {
        if (Engine.sprite == null) {
            return;
        }
        this.drawColorScreenBG(0, drawLevel);
        int dis = 15;
        String[] title = new String[]{"\u7cbe\u7075ID", "\u540d\u79f0", "\u53ef\u89c1", "\u6574\u683c"};
        int i2 = 0;
        while (i2 < title.length) {
            Tools.addString(title[i2], x2 + 50 + i2 * 50, y2 + 30, (byte)4, 15062383, drawLevel);
            ++i2;
        }
        int i3 = 0;
        while (i3 < Engine.sprite.length) {
            Tools.addString(i3 + "", x2 + 50, y2 + 50 + i3 * dis, (byte)4, 0xFFFFFF, drawLevel);
            Tools.addString(Engine.sprite[i3].name, x2 + 100, y2 + 50 + i3 * dis, (byte)4, 0xFFFFFF, drawLevel);
            Tools.addString(Engine.sprite[i3].visible + "", x2 + 150, y2 + 50 + i3 * dis, (byte)4, 0xFFFFFF, drawLevel);
            Tools.addString(this.isFullTile(Engine.sprite[i3]) + "", x2 + 200, y2 + 50 + i3 * dis, (byte)4, this.isFullTile(Engine.sprite[i3]) ? 0xFFFFFF : 0xFF0000, drawLevel);
            ++i3;
        }
        Tools.addString("[0]\u8bbe\u7f6e\u5f53\u524d\u63a7\u5236\u7cbe\u7075", x2 + 120, y2 + 320 - this.strHeight / 2 - 2, (byte)4, 0xFFFFFF, drawLevel);
        Tools.addString("*", x2 + 30, y2 + 50 + Engine.spriteIndex * dis, (byte)4, this.dTime % 2 == 0 ? 0xFFFFFF : 0xFF0000, drawLevel);
        Tools.addRect(x2 + 10, y2 + 58 + this.index * dis, 220, 1, true, (byte)2, 0xFFFFFF, drawLevel);
        this.drawYesNo("\u67e5\u770b", "\u8fd4\u56de", drawLevel);
    }

    boolean isFullTile(Sprite s2) {
        return s2.x % Map.tileWidth == 0 && s2.y % Map.tileHight == 0;
    }

    private void drawSpriteProperty(Sprite s2, int x2, int y2, int drawLevel) {
        String[] DIR = new String[]{"\u4e0a", "\u53f3", "\u4e0b", "\u5de6"};
        String[] stringArray = new String[8];
        stringArray[0] = "\u5e8f\u53f7 \uff1a " + s2.ID;
        stringArray[1] = "\u5750\u6807 \uff1a (" + s2.x + " , " + s2.y + ")" + "(" + s2.x / Map.tileWidth + " , " + s2.y / Map.tileHight + ")";
        stringArray[2] = "\u9762\u5411 \uff1a " + DIR[s2.dir];
        stringArray[3] = "\u72b6\u6001 \uff1a " + s2.curStates;
        stringArray[4] = "\u6b65\u957f \uff1a " + s2.STEP + " \u50cf\u7d20" + (s2.STEP >= Map.tileWidth ? "\uff08\u503c\u8fc7\u5927\uff09" : "");
        stringArray[5] = "\u884c\u52a8 \uff1a " + s2.aiMode;
        stringArray[6] = "\u56fe\u7247 \uff1a s" + s2.modle + ".png";
        stringArray[7] = "\u7d22\u5f15 \uff1a " + s2.index;
        String[] spriteProperty = stringArray;
        this.drawColorScreenBG(0, drawLevel);
        int i2 = 0;
        while (i2 < spriteProperty.length) {
            Tools.addString(spriteProperty[i2], x2 + 20, y2 + 30 + i2 * 15, (byte)2, 0xFFFFFF, drawLevel);
            ++i2;
        }
        this.drawYesNo("\u8bbe\u7f6e", "\u8fd4\u56de", drawLevel);
    }

    private void drawSetSprite(Graphics g2) {
        Engine.map.drawMap(g2, Map.setOffX, Map.setOffY);
        Tools.addColorString("\u5750\u6807 (" + this.px + "," + this.py + ")", Map.setOffX + 2, Map.setOffY + 2, (byte)0, 0, 15062383, 9999);
        Tools.addColorString("\u683c\u5b50 (" + this.px / Map.tileWidth + "," + this.py / Map.tileHight + ")", Map.setOffX + Map.screenWidth - 2, Map.setOffY + 2, (byte)6, 0, 15062383, 9999);
        Tools.addColorString("[0] " + (Engine.sprite[this.spriteIndex].visible ? "\u53ef\u89c1" : "\u9690\u85cf"), Map.setOffX + Map.screenWidth / 2, Map.setOffY + Map.screenHeight - this.strHeight / 2 - 2, (byte)4, 0, 15062383, 9999);
        this.drawGrid(30);
        this.drawCanNotMove(30);
        this.drawDecorations();
        this.drawCursor(9999);
        this.m.moveSrceen(this.px, this.py);
        if (this.pressedUp) {
            if (--this.delay <= 0) {
                this.py -= Map.tileHight;
            }
            this.py = Math.max(0, this.py);
        }
        if (this.pressedDown) {
            if (--this.delay <= 0) {
                this.py += Map.tileHight;
            }
            this.py = Math.min(this.py, (Map.mapSize[1] - 1) * Map.tileHight);
        }
        if (this.pressedLeft) {
            if (--this.delay <= 0) {
                this.px -= Map.tileWidth;
            }
            this.px = Math.max(0, this.px);
        }
        if (this.pressedRight) {
            if (--this.delay <= 0) {
                this.px += Map.tileWidth;
            }
            this.px = Math.min(this.px, (Map.mapSize[0] - 1) * Map.tileWidth);
        }
        this.drawYesNo("\u786e\u5b9a\u653e\u7f6e", "\u8fd4\u56de", 9999);
    }

    private void drawSystemInfo(int x2, int y2, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        String[] systemInfo = new String[]{"\u73a9\u5bb6\u63a7\u5236\u6743: " + Script.isUserCtrl, "\u7cfb\u7edf\u4e8b\u4ef6: " + GCanvas.systemEvent, "\u5f53\u524d\u811a\u672c\u4e8b\u4ef6: " + Script.curEvent, "\u5f53\u524d\u5168\u5c40\u4e8b\u4ef6: " + Script.curGEvent, "temp : " + Variable.temp, "\u7126\u70b9\u7cbe\u7075ID: " + Engine.spriteIndex, "\u5176\u4ed61: "};
        int i2 = 0;
        while (i2 < systemInfo.length) {
            Tools.addString(systemInfo[i2], x2 + 20, y2 + 30 + i2 * 15, (byte)2, 0xFFFFFF, drawLevel);
            ++i2;
        }
        this.drawYesNo("", "\u8fd4\u56de", drawLevel);
    }

    private void drawMore(int x2, int y2, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        int dis = 15;
        int i2 = 0;
        while (i2 < this.moreMenu.length) {
            Tools.addString(this.moreMenu[i2], x2 + 80, y2 + 50 + i2 * dis, (byte)4, 0xFFFFFF, drawLevel);
            Tools.addString(this.more[i2] ? "\u5f00\u542f" : "\u5173\u95ed", x2 + 160, y2 + 50 + i2 * dis, (byte)4, 0xFFFFFF, drawLevel);
            ++i2;
        }
        Tools.addRect(x2 + 10, y2 + 58 + this.index * dis, 220, 1, true, (byte)2, 0xFFFFFF, drawLevel);
        Tools.addString(this.moreInfo[this.index], x2 + 20, y2 + 240, (byte)2, 16775337, drawLevel);
        this.drawYesNo("\u786e\u5b9a", "\u8fd4\u56de", drawLevel);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void screenPrint(int x2, int y2, int drawLevel) {
        ++this.dTime;
        if (this.more[0]) {
            Tools.addString("\u603b\u5185\u5b58: " + Runtime.getRuntime().totalMemory(), x2 + 5, y2 + 10, (byte)0, 0xFF0000, drawLevel);
            Tools.addString("\u5269\u4f59\u5185\u5b58: " + Runtime.getRuntime().freeMemory(), x2 + 5, y2 + 30, (byte)0, 0xFF0000, drawLevel);
            Tools.addString("\u7ed8\u56fe\u6b21\u6570: " + Tools.max_obj, x2 + 5, y2 + 50, (byte)0, 0xFF0000, drawLevel);
        }
        if (this.more[1]) {
            if (Engine.sprite != null && GCanvas.gameStatus == 7) {
                int i2 = 0;
                while (i2 < Engine.sprite.length) {
                    Tools.addColorString(i2 + "", Engine.sprite[i2].x + 4, Engine.sprite[i2].y, (byte)2, 0, this.dTime % 4 < 2 ? 0xFF0000 : 0xFFFF99, drawLevel);
                    ++i2;
                }
            }
        }
        if (this.more[2]) {
            // empty if block
        }
        if (this.more[3] && GCanvas.gameStatus == 7) {
            this.drawGrid(30);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawGrid(int drawLevel) {
        int i2 = 0;
        while (i2 < Map.mapSize[0]) {
            Tools.addRect(Map.tileWidth * i2, 0, Map.tileWidth, Map.mapSize[1] * Map.tileHight, false, (byte)0, 255, drawLevel);
            i2 += 2;
        }
        int i3 = 0;
        while (i3 < Map.mapSize[1]) {
            Tools.addRect(0, Map.tileHight * i3, Map.mapSize[0] * Map.tileWidth, Map.tileHight, false, (byte)0, 255, drawLevel);
            i3 += 2;
        }
    }

    public void setGameSleepTime(int keyCode) {
        if (this.more[2]) {
            // empty if block
        }
    }

    public void paint(Graphics g2, int x2, int y2, int drawLevel) {
        ++this.dTime;
        switch (this.debugST) {
            case 0: {
                this.drawDebugMenu(x2, y2, drawLevel);
                break;
            }
            case 1: {
                this.drawScript(x2, y2, drawLevel);
                break;
            }
            case 2: {
                this.drawMapProperty(x2, y2, drawLevel);
                break;
            }
            case 3: {
                this.drawSprite(x2, y2, drawLevel);
                break;
            }
            case 5: {
                this.drawSpriteProperty(Engine.sprite[this.spriteIndex], x2, y2, drawLevel);
                break;
            }
            case 4: {
                this.drawMore(x2, y2, drawLevel);
                break;
            }
            case 6: {
                this.drawSystemInfo(x2, y2, drawLevel);
                break;
            }
            case 7: {
                this.drawSetGameRank(x2, y2, drawLevel);
                break;
            }
            case 8: {
                this.drawMapInfo(g2);
                break;
            }
            case 9: {
                this.drawSetSprite(g2);
                break;
            }
            case 11: {
                this.drawMonitor(x2, y2, drawLevel);
            }
        }
    }

    public void ctrlReleased(int keyCode) {
        block0 : switch (this.debugST) {
            case 1: 
            case 10: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.pressedUp = false;
                        this.delay = 8;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.pressedDown = false;
                        this.delay = 8;
                    }
                }
                break;
            }
            case 8: 
            case 9: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.pressedUp = false;
                        this.delay = 8;
                        break block0;
                    }
                    case -2: 
                    case 56: {
                        this.pressedDown = false;
                        this.delay = 8;
                        break block0;
                    }
                    case -3: 
                    case 52: {
                        this.pressedLeft = false;
                        this.delay = 8;
                        break block0;
                    }
                    case -4: 
                    case 54: {
                        this.pressedRight = false;
                        this.delay = 8;
                    }
                }
            }
        }
    }

    public void ctrl(int keyCode) {
        block0 : switch (this.debugST) {
            case 11: {
                int len = memory.size();
                switch (keyCode) {
                    case -3: 
                    case 52: {
                        this.index = Math.max(0, this.index - this.rowNumber);
                        break;
                    }
                    case -4: 
                    case 54: {
                        this.index = Math.min(len - 1, this.index + this.rowNumber);
                        break;
                    }
                    case -7: {
                        this.setDebugST((byte)0);
                    }
                }
                break;
            }
            case 9: {
                switch (keyCode) {
                    case 48: {
                        Engine.sprite[this.spriteIndex].visible = !Engine.sprite[this.spriteIndex].visible;
                        break;
                    }
                    case -1: 
                    case 50: {
                        this.pressedUp = true;
                        if (this.delay == 0) break;
                        this.py = this.py == 0 ? 0 : this.py - Map.tileHight;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.pressedDown = true;
                        if (this.delay == 0) break;
                        this.py = this.py == (Map.mapSize[1] - 1) * Map.tileHight ? (Map.mapSize[1] - 1) * Map.tileHight : this.py + Map.tileHight;
                        break;
                    }
                    case -3: 
                    case 52: {
                        this.pressedLeft = true;
                        if (this.delay == 0) break;
                        this.px = this.px == 0 ? 0 : this.px - Map.tileWidth;
                        break;
                    }
                    case -4: 
                    case 54: {
                        this.pressedRight = true;
                        if (this.delay == 0) break;
                        this.px = this.px == (Map.mapSize[0] - 1) * Map.tileWidth ? (Map.mapSize[0] - 1) * Map.tileWidth : this.px + Map.tileWidth;
                        break;
                    }
                    case -7: {
                        this.setDebugST((byte)3);
                        Map.setOff(this.lastX, this.lastY);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        Engine.sprite[this.spriteIndex].x = this.px;
                        Engine.sprite[this.spriteIndex].y = this.py + Map.tileHight;
                        this.setDebugST((byte)3);
                        this.m.adjustScreen(this.px, this.py + Map.tileHight);
                    }
                }
                break;
            }
            case 8: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.pressedUp = true;
                        if (this.delay == 0) break;
                        this.py = this.py == 0 ? 0 : this.py - Map.tileHight;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.pressedDown = true;
                        if (this.delay == 0) break;
                        this.py = this.py == (Map.mapSize[1] - 1) * Map.tileHight ? (Map.mapSize[1] - 1) * Map.tileHight : this.py + Map.tileHight;
                        break;
                    }
                    case -3: 
                    case 52: {
                        this.pressedLeft = true;
                        if (this.delay == 0) break;
                        this.px = this.px == 0 ? 0 : this.px - Map.tileWidth;
                        break;
                    }
                    case -4: 
                    case 54: {
                        this.pressedRight = true;
                        if (this.delay == 0) break;
                        this.px = this.px == (Map.mapSize[0] - 1) * Map.tileWidth ? (Map.mapSize[0] - 1) * Map.tileWidth : this.px + Map.tileWidth;
                        break;
                    }
                    case -7: {
                        this.setDebugST((byte)2);
                        Map.setOff(this.lastX, this.lastY);
                        break;
                    }
                    case 42: {
                        this.b3 = !this.b3;
                        break;
                    }
                    case 48: {
                        this.b2 = !this.b2;
                        break;
                    }
                    case 35: {
                        this.b1 = !this.b1;
                    }
                }
                break;
            }
            case 7: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.rank[this.index] = this.rank[this.index] == 9 ? 0 : this.rank[this.index] + 1;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.rank[this.index] = this.rank[this.index] == 0 ? 9 : this.rank[this.index] - 1;
                        break;
                    }
                    case -3: 
                    case 52: {
                        this.index = this.index == 0 ? this.rank.length - 1 : this.index - 1;
                        break;
                    }
                    case -4: 
                    case 54: {
                        this.index = this.index == this.rank.length - 1 ? 0 : this.index + 1;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        Engine.playX = (short)-1;
                        Engine.playY = (short)-1;
                        Engine.playDir = (short)-1;
                        Engine.setRankEnd(this.getRank(this.rank));
                        isDebug = false;
                        break;
                    }
                    case -7: {
                        this.setDebugST((byte)0);
                    }
                }
                break;
            }
            case 0: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.index = this.index == 0 ? this.debugMenu.length - 1 : this.index - 1;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.index = this.index == this.debugMenu.length - 1 ? 0 : this.index + 1;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        switch (this.index) {
                            case 0: {
                                this.setDebugST((byte)1);
                                break;
                            }
                            case 1: {
                                this.setDebugST((byte)7);
                                break;
                            }
                            case 2: {
                                this.setDebugST((byte)2);
                                break;
                            }
                            case 3: {
                                if (!this.spriteIsInit()) break;
                                this.setDebugST((byte)3);
                                break;
                            }
                            case 4: {
                                this.setDebugST((byte)6);
                                break;
                            }
                            case 5: {
                                this.setDebugST((byte)4);
                                break;
                            }
                            case 6: {
                                this.drawColorScreenBG(0xFFFFFF, 10000);
                                Engine.money += 10000;
                                break;
                            }
                            case 7: {
                                break;
                            }
                            case 8: {
                                this.setSpriteNextSpeed();
                                break;
                            }
                            case 9: {
                                this.setDebugST((byte)11);
                            }
                        }
                        break;
                    }
                    case -7: {
                        isDebug = false;
                    }
                }
                break;
            }
            case 1: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.pressedUp = true;
                        if (this.delay == 0) break;
                        this.index = this.index == 0 ? 0 : this.index - 1;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.pressedDown = true;
                        if (this.delay == 0) break;
                        this.index = this.index == Variable.scriptVar.length - 1 ? Variable.scriptVar.length - 1 : this.index + 1;
                        break;
                    }
                    case -3: 
                    case 52: {
                        this.index -= this.rowNumber;
                        this.index = Math.max(0, this.index);
                        break;
                    }
                    case -4: 
                    case 54: {
                        this.index += this.rowNumber;
                        this.index = Math.min(Variable.scriptVar.length - 1, this.index);
                        break;
                    }
                    case -5: 
                    case 53: {
                        Variable.scriptVar[this.index] = (byte)(Variable.scriptVar[this.index] == 0 ? 1 : 0);
                        break;
                    }
                    case -7: {
                        this.setDebugST((byte)0);
                    }
                }
                break;
            }
            case 6: {
                switch (keyCode) {
                    case -7: {
                        this.setDebugST((byte)0);
                    }
                }
                break;
            }
            case 2: {
                switch (keyCode) {
                    case -7: {
                        this.setDebugST((byte)0);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        if (Map.mData[0] == null) break;
                        this.initMap();
                        this.setDebugST((byte)8);
                    }
                }
                break;
            }
            case 3: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.index = this.index == 0 ? Engine.sprite.length - 1 : this.index - 1;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.index = this.index == Engine.sprite.length - 1 ? 0 : this.index + 1;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        this.spriteIndex = (byte)this.index;
                        this.setDebugST((byte)5);
                        break;
                    }
                    case 48: {
                        Engine.spriteIndex = (byte)this.index;
                        break;
                    }
                    case -7: {
                        this.setDebugST((byte)0);
                    }
                }
                break;
            }
            case 5: {
                switch (keyCode) {
                    case -7: {
                        this.setDebugST((byte)3);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        this.initMap();
                        this.px = Engine.sprite[this.spriteIndex].x / Map.tileWidth * Map.tileWidth;
                        this.py = Engine.sprite[this.spriteIndex].y / Map.tileHight * Map.tileHight - Map.tileHight;
                        this.setDebugST((byte)9);
                    }
                }
                break;
            }
            case 4: {
                switch (keyCode) {
                    case -7: {
                        this.setDebugST((byte)0);
                        break block0;
                    }
                    case -1: 
                    case 50: {
                        this.index = this.index == 0 ? this.moreMenu.length - 1 : this.index - 1;
                        break block0;
                    }
                    case -2: 
                    case 56: {
                        this.index = this.index == this.moreMenu.length - 1 ? 0 : this.index + 1;
                        break block0;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        this.more[this.index] = !this.more[this.index];
                    }
                }
            }
        }
    }

    public void setDebugST(byte st) {
        isDebug = true;
        this.debugST = st;
        this.index = 0;
    }

    private void drawColorScreenBG(int color, int drawLevel) {
        Tools.addRect(Map.setOffX, Map.setOffY - 20, Map.screenWidth, Map.screenHeight + 40, true, (byte)0, color, drawLevel);
    }

    private void drawYesNo(String str1, String str2, int drawLevel) {
        if (str1 != null) {
            Tools.addString(str1, Map.setOffX + 2, Map.setOffY + 320 - 2, (byte)2, 16775337, drawLevel);
        }
        if (str2 != null) {
            Tools.addString(str2, Map.setOffX + 240 - 2, Map.setOffY + 320 - 2, (byte)8, 16775337, drawLevel);
        }
    }

    private void setSpriteNextSpeed() {
        if (Engine.sprite == null) {
            return;
        }
        this.drawColorScreenBG(0xFFFFFF, 10000);
        Engine.sprite[Engine.spriteIndex].nextSpeed = Engine.sprite[Engine.spriteIndex].nextSpeed == 4 ? 2 : 4;
    }

    static void saveMemory(String key, boolean end) {
        System.gc();
        GMIDlet gMIDlet = GMIDlet.instance;
        gMIDlet.thread.yield();
        long m2 = GMIDlet.r.freeMemory();
        Debug.monitor[end ? 1 : 0] = m2;
        if (end) {
            memory.addElement(new String[]{key, "" + (monitor[0] - monitor[1])});
        }
    }

    static void saveUsedMemory(String key) {
        System.gc();
        long total = Runtime.getRuntime().freeMemory();
        long used = total - Runtime.getRuntime().freeMemory();
        memory.addElement(new String[]{"*" + key, "" + used});
    }

    private void drawMonitor(int x2, int y2, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        long total = Runtime.getRuntime().totalMemory();
        long used = total - Runtime.getRuntime().freeMemory();
        Tools.addString(used + " / " + total, x2, y2 + 320, (byte)2, 0xFF0000, drawLevel);
        String[] title = new String[]{"\u76d1\u63a7\u9879", "\u5185\u5b58\u4f7f\u7528"};
        int dis = 17;
        int i2 = 0;
        while (i2 < title.length) {
            Tools.addString(title[i2], x2 + 60 + i2 * 240 / 2, y2 + 30, (byte)4, 15062383, drawLevel);
            ++i2;
        }
        int i3 = this.index / this.rowNumber * this.rowNumber;
        while (i3 < Math.min(this.index / this.rowNumber * this.rowNumber + this.rowNumber, memory.size())) {
            String[] str = (String[])memory.elementAt(i3);
            Tools.addString(str[0] + " : ", x2 + 60, y2 + 50 + i3 % this.rowNumber * dis, (byte)4, 0xFFFFFF, drawLevel);
            Tools.addString(str[1], x2 + 180, y2 + 50 + i3 % this.rowNumber * dis, (byte)4, Variable.scriptVar[i3] == 0 ? 0xFFFFFF : 0x33FF33, drawLevel);
            ++i3;
        }
        if (this.index >= this.rowNumber) {
            Tools.addString("<<", x2 + 60, y2 + 320 - 25, (byte)4, this.dTime % 3 == 0 ? 0xFFFFFF : 0xFF0000, drawLevel);
        }
        if (this.index < memory.size() / this.rowNumber * this.rowNumber) {
            Tools.addString(">>", x2 + 180, y2 + 320 - 25, (byte)4, this.dTime % 3 == 0 ? 0xFFFFFF : 0xFF0000, drawLevel);
        }
        if (this.pressedUp) {
            if (--this.delay <= 0) {
                --this.index;
            }
            this.index = Math.max(0, this.index);
        }
        if (this.pressedDown) {
            if (--this.delay <= 0) {
                ++this.index;
            }
            this.index = Math.min(this.index, memory.size() - 1);
        }
        this.drawYesNo("", "\u8fd4\u56de", drawLevel);
    }

    static void classTest() {
        Debug.saveMemory("Tools", false);
        int a2 = Tools.max_obj;
        Debug.saveMemory("Tools", true);
        Debug.saveMemory("UI", false);
        a2 = UI.lvPosx;
        Debug.saveMemory("UI", true);
        Debug.saveMemory("Variable", false);
        a2 = Variable.temp;
        Debug.saveMemory("Variable", true);
        Debug.saveMemory("Event", false);
        a2 = Event.waitTime;
        Debug.saveMemory("Event", true);
    }

    static {
        memory = new Vector();
        monitor = new long[2];
    }
}

