/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    static int screenWidth;
    static int screenHeight;
    static byte tileWidth;
    static byte tileHight;
    static int[] mapSize;
    static int mapW;
    static int mapH;
    static int setOffX;
    static int setOffY;
    static Engine engine;
    static final short L_BG = 0;
    static final short L_ROLE = 1000;
    static final short L_EFECT = 2000;
    static final short L_FG = 3000;
    static final short L_MASK = 5000;
    static final short L_INTERFACE = 10000;
    static final short L_TALK = 11000;
    static final short L_HIT = 11500;
    static final short L_INFO = 12000;
    static final short L_MAX = 20000;
    byte mapID;
    byte mapName;
    String fileName;
    String decName;
    static int curMusic;
    short[] enemys;
    String[] enemyNames;
    byte mfLevel;
    short battleBg;
    static byte[][] mData;
    static short[][] mProperties;
    static String[][] mName;
    static int layer;
    static Vector cgV;
    byte[] mapNameY = new byte[]{-30, -24, -20, -16, -12, -8, -4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, -8, -12, -16, -20, -24, -30};
    byte showIndex;
    boolean showMapName;
    public static final byte ITEM_TYPE = 0;
    public static final byte ITEM_X = 1;
    public static final byte ITEM_Y = 2;
    public static final byte ITEM_TR = 3;
    public static final byte OBJ_ID = 0;
    public static final byte OBJ_IMG = 1;
    public static final byte OBJ_DL = 2;
    public static final byte OBJ_ADDX = 3;
    public static final byte OBJ_ADDY = 4;
    public static final byte OBJ_W = 5;
    public static final byte OBJ_H = 6;
    static short[][] objData;
    static short[][] decData;
    public static int SCEEN_MOVE;
    int adjustX;
    int adjustY;
    static boolean isMoveScreen;
    Event event;
    short pathIndex;
    Image mapBuff;
    int buffWidth;
    int buffHeight;
    Graphics buffG;
    boolean isBuffNull;
    int lastStartX;
    int lastStartY;
    int lastEndX;
    int lastEndY;

    public static short getLayer(int dl) {
        switch (dl) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1000;
            }
            case 2: {
                return 2000;
            }
        }
        return 20000;
    }

    public Map(Engine en, int sw, int sh) {
        screenWidth = sw;
        screenHeight = sh;
        Map.setOff(0, 0);
        engine = en;
    }

    public void free() {
        cgV.removeAllElements();
        mData = null;
        mProperties = null;
        mName = null;
        System.gc();
    }

    public void init(short[] dat) {
        this.mapID = (byte)Variable.getInt(dat[0], Script.exp, Script.bInt);
        curMusic = Integer.parseInt(Variable.getString(dat[1], Script.exp));
        this.fileName = Variable.getString(dat[2], Script.exp);
        this.decName = Variable.getString(dat[3], Script.exp);
        this.battleBg = (short)Variable.getInt(dat[4], Script.exp, Script.bInt);
        this.mfLevel = (byte)Variable.getInt(dat[5], Script.exp, Script.bInt);
        this.enemys = Variable.getArray(dat[6], Script.array);
        this.enemyNames = Variable.getString(dat[7], Script.exp).equals("null") ? null : Variable.splitString(Variable.getString(dat[7], Script.exp), ",");
        this.enemys = new short[]{3};
        this.enemyNames = new String[]{"\u86c7"};
    }

    public void initMap() {
        this.free();
        decData = null;
        this.adjustX = screenWidth / 2;
        this.adjustY = screenHeight / 2 + 40;
        GCanvas.monitor("\u5730\u56fe\u6570\u636e", false);
        this.loadMapDat();
        GCanvas.monitor("\u5730\u56fe\u6570\u636e", false);
        GCanvas.monitor("\u88c5\u9970\u7269", false);
        this.loadDecorationDat();
        GCanvas.monitor("\u88c5\u9970\u7269", true);
        this.initWeather();
    }

    void loadDecorationDat() {
        decData = null;
        decData = Data.readArray("/data/deck.pak", this.decName);
        this.loadDeckImg();
    }

    void loadMapDat() {
        System.out.println("mapDat  " + this.fileName);
        this.loadMap(this.fileName);
        mapW = mapSize[0] * tileWidth;
        mapH = mapSize[1] * tileHight;
    }

    public void loadMap(String file) {
        DataInputStream dis = Tools.openFile("/data/map.pak");
        int fileLen = Data.searchFile(dis, file);
        try {
            if (fileLen == -1) {
                dis.close();
                return;
            }
            layer = Map.bToi(dis.readByte());
            mData = new byte[layer][];
            mProperties = new short[layer][];
            mName = new String[layer][];
            int i2 = 0;
            while (i2 < layer) {
                Map.mapSize[0] = Map.bToi(dis.readByte());
                Map.mapSize[1] = Map.bToi(dis.readByte());
                tileWidth = dis.readByte();
                tileHight = dis.readByte();
                int size = mapSize[0] * mapSize[1];
                Map.mData[i2] = new byte[size];
                dis.read(mData[i2]);
                int len = dis.readShort();
                Map.mName[i2] = new String[len];
                Map.mProperties[i2] = new short[len];
                int j2 = 0;
                while (j2 < len) {
                    byte nameLen = dis.readByte();
                    byte[] names = new byte[nameLen];
                    dis.read(names);
                    Map.mName[i2][j2] = new String(names);
                    Map.mProperties[i2][j2] = dis.readShort();
                    ++j2;
                }
                ++i2;
            }
            dis.close();
        }
        catch (IOException ex) {
            System.out.println("************* Read Map Error !!! ******************");
        }
    }

    public void setMap(Graphics g2) {
        if (mData != null) {
            this.drawMapBG((byte)this.battleBg, 0, 80, 0);
            this.drawMapFG();
        }
    }

    static void addCG(int img, int x2, int y2, int trans, int flag) {
        cgV.addElement(new short[]{(short)img, (short)x2, (short)y2, (short)trans, (short)flag});
    }

    static void removeCG(int flag) {
        int size = cgV.size();
        short cgImage = -1;
        boolean canRemove = true;
        int i2 = size - 1;
        while (i2 >= 0) {
            short[] temp = (short[])cgV.elementAt(i2);
            if (temp[0] == cgImage) {
                canRemove = false;
            }
            if (temp[4] == flag) {
                cgV.removeElementAt(i2);
                cgImage = temp[0];
            }
            --i2;
        }
        if (canRemove) {
            Tools.removeImage(1, cgImage);
        }
    }

    void drawCG() {
        int size = cgV.size();
        int i2 = 0;
        while (i2 < size) {
            short[] temp = (short[])cgV.elementAt(i2);
            Tools.addImage(1, temp[0], setOffX + temp[1], setOffY + temp[2], (byte)0, (byte)temp[3], 3000);
            ++i2;
        }
    }

    public void drawMapBG(byte imgIndex, int y2, int speed, int lev) {
        if (imgIndex == 5) {
            Engine.drawColorScreenBG(0, 0);
            return;
        }
        int w2 = 0;
        switch (imgIndex) {
            case 0: {
                w2 = 190;
                break;
            }
            case 1: {
                w2 = 178;
                break;
            }
            case 2: 
            case 3: {
                w2 = 160;
                break;
            }
            case 4: {
                w2 = 156;
                break;
            }
        }
        int times = screenWidth / w2 + 2;
        int startPos = setOffX * speed * 10 / 1000;
        while (setOffX - startPos >= w2) {
            startPos += w2;
        }
        int i2 = 0;
        while (i2 < times) {
            if (imgIndex == 0 || imgIndex == 1) {
                Tools.addImage(1, imgIndex, startPos + i2 * w2, y2, (byte)6, (byte)1, lev);
            }
            Tools.addImage(1, imgIndex, startPos + i2 * w2, y2, (byte)0, (byte)0, lev);
            ++i2;
        }
    }

    void showMapName() {
        this.showMapName = true;
        this.showIndex = 0;
    }

    public void drawMapFG() {
        this.drawDecorations();
        int w2 = mapSize[0] * tileWidth;
        int h2 = mapSize[1] * tileHight;
        int tempw = (screenWidth - w2) / 2;
        int temph = (screenHeight - h2) / 2;
        if (tempw > 0) {
            Tools.addRect(setOffX, setOffY, tempw, screenHeight, true, (byte)0, 0, 1111);
            Tools.addRect(setOffX + w2 + tempw, setOffY, tempw, screenHeight, true, (byte)0, 0, 1111);
        }
        if (temph > 0) {
            Tools.addRect(setOffX, setOffY, screenWidth, temph, true, (byte)0, 0, 1111);
            Tools.addRect(setOffX, setOffY + h2 + temph, screenWidth, temph, true, (byte)0, 0, 1111);
        }
    }

    int getObjIndex(int id) {
        int i2 = 0;
        while (i2 < objData.length) {
            if (objData[i2][0] == id) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public void drawDecorations() {
        if (decData == null) {
            return;
        }
        int i2 = 0;
        while (i2 < decData.length) {
            short type = decData[i2][0];
            short x2 = decData[i2][1];
            int y2 = decData[i2][2];
            byte trans = (byte)decData[i2][3];
            int id = this.getObjIndex(type);
            if (id != -1) {
                short addx = objData[id][3];
                short addy = objData[id][4];
                short img = objData[id][1];
                short dl = objData[id][2];
                int drawLevel = y2;
                switch (dl) {
                    case -2: {
                        drawLevel = 0;
                        break;
                    }
                    case -1: {
                        drawLevel = 2;
                        break;
                    }
                    case 0: {
                        drawLevel = (short)(y2 + 0);
                        break;
                    }
                    case 1: {
                        drawLevel = (short)(y2 + 1000);
                    }
                }
                switch (id) {
                    case 9: {
                        Tools.addImage(2, img, x2 + addx, y2 + addy, GCanvas.gameTime % 6 / 2 * 33, 0, 33, 35, (byte)2, trans, drawLevel);
                        break;
                    }
                    case 10: {
                        Tools.addImage(2, img, x2 + addx, y2 + addy, GCanvas.gameTime % 6 / 2 * 48, 0, 48, 90, (byte)2, trans, drawLevel);
                        break;
                    }
                    case 42: {
                        Tools.addImage(2, img, x2 + addx, y2 + addy, GCanvas.gameTime % 4 / 2 * 51, 0, 51, 59, (byte)2, trans, drawLevel);
                        break;
                    }
                    case 50: {
                        Tools.addImage(2, img, x2 + addx, y2 + addy, GCanvas.gameTime % 8 / 2 * 36, 0, 36, 47, (byte)2, trans, drawLevel);
                        break;
                    }
                    case 51: {
                        Tools.addImage(2, img, x2 + addx, y2 + addy, GCanvas.gameTime % 8 / 2 * 38, 0, 38, 31, (byte)2, trans, drawLevel);
                        break;
                    }
                    case 62: {
                        Tools.addImage(2, img, x2 + addx, y2 + addy, GCanvas.gameTime % 8 / 2 * 38, 0, 38, 78, (byte)2, trans, drawLevel);
                        break;
                    }
                    default: {
                        Tools.addImage(2, img, x2 + addx, y2 + addy, (byte)2, trans, drawLevel);
                    }
                }
            }
            ++i2;
        }
    }

    void loadDeckImg() {
        if (decData == null) {
            return;
        }
        Vector<String> v2 = new Vector<String>();
        int i2 = 0;
        while (i2 < decData.length) {
            String type;
            int index = this.getObjIndex(decData[i2][0]);
            if (index >= 0 && !v2.contains(type = objData[index][1] + "")) {
                v2.addElement(type);
            }
            ++i2;
        }
        Object[] str = new String[v2.size()];
        v2.copyInto(str);
        v2 = null;
        Tools.loadImages(2, (String[])str);
    }

    void initWeather() {
    }

    public static void setOff(int x2, int y2) {
        setOffX = x2;
        setOffY = y2;
    }

    public void adjustScreen(int x2, int y2) {
        setOffX = (short)(x2 - this.adjustX);
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = mapW >= screenWidth ? (int)((short)Math.min(setOffX, mapW - screenWidth)) : (mapW - screenWidth) / 2;
        setOffY = (short)(y2 - this.adjustY);
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = mapH >= screenHeight ? (int)((short)Math.min(setOffY, mapH - screenHeight)) : (mapH - screenHeight) / 2;
    }

    public void moveSrceen(int x2, int y2) {
        setOffX = Math.abs(x2 - setOffX - this.adjustX) > SCEEN_MOVE ? (x2 - setOffX >= this.adjustX ? (setOffX += SCEEN_MOVE) : (setOffX -= SCEEN_MOVE)) : (int)((short)(x2 - this.adjustX));
        setOffX = (short)Math.max(setOffX, 0);
        int w2 = mapSize[0] * tileWidth;
        setOffX = w2 >= screenWidth ? (int)((short)Math.min(setOffX, w2 - screenWidth)) : (w2 - screenWidth) / 2;
        setOffY = Math.abs(y2 - setOffY - this.adjustY) > SCEEN_MOVE ? (y2 - setOffY >= this.adjustY ? (setOffY += SCEEN_MOVE) : (setOffY -= SCEEN_MOVE)) : (int)((short)(y2 - this.adjustY));
        setOffY = (short)Math.max(setOffY, 0);
        int h2 = mapSize[1] * tileHight;
        setOffY = h2 >= screenHeight ? (int)((short)Math.min(setOffY, h2 - screenHeight)) : (h2 - screenHeight) / 2;
        if (isMoveScreen && this.checkMoveScreen(x2, y2)) {
            isMoveScreen = false;
            this.finish();
        }
    }

    public boolean checkMoveScreen(int x2, int y2) {
        int tempx = x2 - this.adjustX;
        tempx = (short)Math.max(tempx, 0);
        int w2 = mapSize[0] * tileWidth;
        tempx = w2 >= screenWidth ? (int)Math.min(tempx, w2 - screenWidth) : (short)(w2 - screenWidth) / 2;
        int tempy = y2 - this.adjustY;
        tempy = (short)Math.max(tempy, 0);
        int h2 = mapSize[1] * tileHight;
        tempy = h2 > screenHeight ? (int)((short)Math.min(tempy, mapSize[1] * tileHight - screenHeight)) : (h2 - screenHeight) / 2;
        return setOffX == tempx && setOffY == tempy;
    }

    public void sender(Event event, short pathIndex) {
        this.event = event;
        this.pathIndex = pathIndex;
    }

    public void finish() {
        if (this.event != null) {
            this.event.setEnd(this.pathIndex);
            this.event = null;
        }
    }

    public boolean canRun(int x2, int y2) {
        if (x2 < 0 || x2 >= tileWidth * mapSize[0] || y2 < 0 || y2 >= tileHight * mapSize[1]) {
            return false;
        }
        int i2 = 0;
        while (i2 < layer) {
            if (Map.inMapData(x2, y2, i2) == -1 ? i2 == 0 : !this.canRun(x2, y2, i2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean canRun(int x2, int y2, int lay) {
        byte temp = Map.inMapData(x2, y2, lay);
        if (temp == -1) {
            return false;
        }
        return Tools.getProperties(mProperties[lay][Map.getLow(temp)], (byte)15);
    }

    public static byte inMapData(int x2, int y2, int index) {
        int n2 = x2 / tileWidth * mapSize[1] + y2 / tileHight;
        if (n2 < 0 || n2 >= mData[index].length) {
            return -1;
        }
        return mData[index][n2];
    }

    public static int getTrans(int v2) {
        return v2 >> 6 & 3;
    }

    public static int get2nd(int v2) {
        return v2 << 1 >> 7 & 1;
    }

    public static int getLow(int v2) {
        return v2 & 0x3F;
    }

    static int bToi(byte byte0) {
        int i2 = byte0;
        if (byte0 < 0) {
            i2 += 256;
        }
        return i2;
    }

    public int hitDecorations(int x2, int y2) {
        if (decData == null) {
            return -1;
        }
        int i2 = 0;
        while (i2 < decData.length) {
            short id = decData[i2][0];
            int objIndex = this.getObjIndex(id);
            if (objIndex != -1) {
                short dw = objData[objIndex][5];
                short dh = objData[objIndex][6];
                if (dw != 0 && dh != 0 && Tools.hit(x2, y2, decData[i2][1], decData[i2][2], dw, dh)) {
                    return i2;
                }
            }
            ++i2;
        }
        return -1;
    }

    public static int getIndex(int v2) {
        return v2 & 0x3F;
    }

    public int getIndex(int x2, int y2, int index) {
        return Map.getIndex(Map.inMapData(x2, y2, index));
    }

    private int repaint(int data, int layer) {
        if (data == -1) {
            return -1;
        }
        if (Tools.getProperties(mProperties[layer][Map.getLow(data)], (byte)14)) {
            return 1;
        }
        if (Tools.getProperties(mProperties[layer][Map.getLow(data)], (byte)13)) {
            return 2;
        }
        return 0;
    }

    public void setTile(Graphics g2) {
        int n2 = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = screenWidth / tileWidth + 2;
        int nh = screenHeight / tileHight + 2;
        int j2 = 0;
        while (j2 < nw) {
            int s2;
            int i2 = s2 = n2 + j2 * mapSize[1];
            while (i2 < s2 + nh) {
                block7: {
                    if (i2 >= mData[0].length || i2 < 0) break block7;
                    int x2 = i2 / mapSize[1] * tileHight;
                    int y2 = i2 % mapSize[1] * tileWidth;
                    int k2 = 1;
                    while (k2 < layer) {
                        block8: {
                            int dataTemp = Map.getLow(mData[k2][i2]);
                            int temp = this.repaint(mData[k2][i2], k2);
                            int lev = 0;
                            switch (temp) {
                                case 1: {
                                    lev = 3000;
                                    break;
                                }
                                case 2: {
                                    lev = y2 + 1000 + 32;
                                    break;
                                }
                                default: {
                                    break block8;
                                }
                            }
                            Tools.addImage(Tools.mapGroup + k2, dataTemp, x2, y2, 0, 0, tileWidth, tileHight, (byte)0, (byte)Map.getTrans(mData[k2][i2]), lev);
                        }
                        ++k2;
                    }
                }
                ++i2;
            }
            ++j2;
        }
    }

    void initMapBuff() {
        this.isBuffNull = true;
        if (this.mapBuff == null) {
            tileWidth = (byte)16;
            tileHight = (byte)16;
            this.buffWidth = ((screenWidth + tileWidth - 1) / tileWidth + 1) * tileWidth;
            this.buffHeight = ((screenHeight + tileHight - 1) / tileHight + 1) * tileHight;
            this.mapBuff = Image.createImage((int)this.buffWidth, (int)this.buffHeight);
            this.buffG = this.mapBuff.getGraphics();
        }
    }

    void drawBuff(Graphics g2, int clipX, int clipY, int clipW, int clipH, int x2, int y2) {
        g2.setClip(x2, y2, clipW, clipH);
        g2.drawImage(this.mapBuff, x2 - clipX, y2 - clipY, 20);
        g2.setClip(0, 0, screenWidth, screenHeight);
    }

    void drawMap(Graphics g2, int setOffX, int setOffY) {
        int startX = setOffX / tileWidth;
        int endX = startX + (screenWidth + tileWidth - 1) / tileWidth;
        int startY = setOffY / tileHight;
        int endY = startY + (screenHeight + tileHight - 1) / tileHight;
        if (this.isBuffNull) {
            this.isBuffNull = false;
            this.updateBuff(this.buffG, startX, startY, endX, endY);
            this.lastStartX = startX;
            this.lastStartY = startY;
            this.lastEndX = endX;
            this.lastEndY = endY;
        }
        if (this.lastStartX != startX) {
            int tmp2;
            int tmp1;
            if (this.lastStartX < startX) {
                tmp1 = this.lastEndX + 1;
                tmp2 = endX;
            } else {
                tmp1 = startX;
                tmp2 = this.lastStartX - 1;
            }
            this.updateBuff(this.buffG, tmp1, startY, tmp2, endY);
            this.lastStartX = startX;
            this.lastEndX = endX;
        }
        if (this.lastStartY != startY) {
            int tmp4;
            int tmp3;
            if (this.lastStartY < startY) {
                tmp3 = this.lastEndY + 1;
                tmp4 = endY;
            } else {
                tmp3 = startY;
                tmp4 = this.lastStartY - 1;
            }
            this.updateBuff(this.buffG, startX, tmp3, endX, tmp4);
            this.lastStartY = startY;
            this.lastEndY = endY;
        }
        int t1 = setOffX % this.buffWidth;
        int t2 = setOffY % this.buffHeight;
        int t3 = (setOffX + screenWidth) % this.buffWidth;
        int t4 = (setOffY + screenHeight) % this.buffHeight;
        if (t3 > t1) {
            if (t4 > t2) {
                this.drawBuff(g2, t1, t2, screenWidth, screenHeight, 0, 0);
            } else {
                this.drawBuff(g2, t1, t2, screenWidth, screenHeight - t4, 0, 0);
                this.drawBuff(g2, t1, 0, screenWidth, t4, 0, screenHeight - t4);
            }
        } else if (t4 > t2) {
            this.drawBuff(g2, t1, t2, screenWidth - t3, screenHeight, 0, 0);
            this.drawBuff(g2, 0, t2, t3, screenHeight, screenWidth - t3, 0);
        } else {
            this.drawBuff(g2, t1, t2, screenWidth - t3, screenHeight - t4, 0, 0);
            this.drawBuff(g2, t1, 0, screenWidth - t3, t4, 0, screenHeight - t4);
            this.drawBuff(g2, 0, t2, t3, screenHeight - t4, screenWidth - t3, 0);
            this.drawBuff(g2, 0, 0, t3, t4, screenWidth - t3, screenHeight - t4);
        }
    }

    void updateBuff(Graphics g2, int startX, int startY, int endX, int endY) {
        int y2 = startY * tileHight % this.buffHeight;
        int i2 = startY;
        while (i2 <= endY) {
            int x2 = startX * tileWidth % this.buffWidth;
            int j2 = startX;
            while (j2 <= endX) {
                int k2 = 0;
                while (k2 < layer) {
                    byte mapIndex = Map.inMapData(j2 * tileWidth, i2 * tileHight, k2);
                    int dataTemp = Map.getIndex(mapIndex);
                    int transData = Map.getTrans(mapIndex);
                    if ((byte)mapIndex != -1) {
                        g2.setClip(x2, y2, (int)tileWidth, (int)tileHight);
                        Tools.drawClipImage(g2, (Tools.mapGroup + k2) * 1000 + dataTemp, x2, y2, 0, 0, tileWidth, tileHight, (byte)0, transData);
                        g2.setClip(0, 0, this.buffWidth, this.buffHeight);
                    } else if (k2 == 0) {
                        g2.setClip(x2, y2, (int)tileWidth, (int)tileHight);
                        g2.setColor(0);
                        g2.fillRect(x2, y2, (int)tileWidth, (int)tileHight);
                        g2.setClip(0, 0, this.buffWidth, this.buffHeight);
                    }
                    ++k2;
                }
                if ((x2 += tileWidth) >= this.buffWidth) {
                    x2 -= this.buffWidth;
                }
                ++j2;
            }
            if ((y2 += tileHight) >= this.buffHeight) {
                y2 -= this.buffHeight;
            }
            ++i2;
        }
    }

    static {
        mapSize = new int[2];
        cgV = new Vector();
        SCEEN_MOVE = 16;
    }
}

