/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Sprite {
    public static final byte SK_ID = 0;
    public static final byte EQU_ID = 1;
    public static final byte EQU_ADD = 2;
    byte camp;
    public static final byte CAMP_NEUTRAL = 0;
    public static final byte CAMP_SELF = 1;
    public static final byte CAMP_FRIEND = 2;
    public static final byte CAMP_ENEMY = 3;
    short type;
    short level = 1;
    short level_max = (short)100;
    int hp_max;
    int hp;
    short mp_max;
    short mp;
    int exp_max;
    int exp;
    short atk;
    short def;
    byte critical;
    byte miss;
    byte absorb;
    byte hpRecover;
    byte mpRecover;
    byte luck;
    byte fire;
    byte light;
    short exHp;
    short exMp;
    short exCri;
    short exAtk;
    short exDef;
    static byte FALLTIME = (byte)30;
    static byte STUNTIME = (byte)35;
    short damage;
    short skillPoints;
    boolean isBoss;
    int hpBuffIndex;
    int showHpBarIndex;
    short[][] passiveSkill;
    short[][] initiativeSkill;
    short skillDamgePer;
    short skillReducePer;
    short getExpPer;
    short getMoneyPer;
    short[][] itemData = new short[4][];
    int getMoney;
    Engine engine;
    int frequency;
    int speed;
    int nextSpeed;
    int STEP;
    int faceDir;
    int nextFaceDir;
    int x;
    int y;
    int dir;
    int nextDir;
    int sx;
    int sy;
    short w;
    short h;
    byte curStates;
    byte nextStates;
    byte curIndex;
    int index;
    byte aiMode;
    boolean isPass;
    int ID;
    String name;
    short modle;
    boolean visible = true;
    boolean isDrawShandow;
    byte frameTimes = 0;
    byte trans;
    short[][] path;
    short flashTime;
    short flashFreq;
    static final byte a = -3;
    byte skillType = (byte)-1;
    int z;
    int speedx;
    int speedy;
    int speedz;
    boolean superSkill;
    Vector vHitEffect = new Vector();
    boolean[] superArmor = new boolean[5];
    boolean pause;
    public static final byte ST_STOP = 0;
    public static final byte ST_MOVE = 1;
    public static final byte ST_ATTACK = 2;
    public static final byte ST_CARE = 3;
    public static final byte ST_SKILL1 = 4;
    public static final byte ST_SKILL1_END = 5;
    public static final byte ST_SKILL2 = 6;
    public static final byte ST_INJURECOMMOM = 7;
    public static final byte ST_DEAD = 8;
    public static final byte ST_FALL1 = 9;
    public static final byte ST_FALL2 = 10;
    public static final byte ST_REBORN = 11;
    public static final byte ST_INJUREHOLD = 12;
    public static final byte ST_INJUREFLOAT = 13;
    public static final byte ST_INJUREREPEL = 14;
    public static final byte ST_RUSH = 15;
    public static final byte ST_RUSHATTACK = 16;
    public static final byte ST_STUN = 17;
    public static final byte ST_DEADEND = 18;
    public static final byte ST_FALLDOWN = 19;
    public static final byte ST_SKILL3 = 20;
    public static final byte ST_RUSHUP = 21;
    public static final byte ST_RUSHDOWN = 22;
    public static final byte ST_SKILL4 = 23;
    public static final byte ST_DEAD2 = 24;
    public static final byte ST_RUSHMOVE = 25;
    public static final byte ST_ADDHP = 26;
    public static final byte ST_SKILLFIRE = 27;
    public static final byte M_CURINDEX = 0;
    public static final byte M_TRANS = 1;
    public static final byte M_FRAMETIMES = 2;
    public static final byte M_ADJUSTX = 3;
    public static final byte M_ADJUSTXDGX = 4;
    public static final byte M_ADJUSTY = 5;
    public static final byte M_ADJUSTYDGX = 6;
    public static final byte DIR_UP = 0;
    public static final byte DIR_RIGHT = 1;
    public static final byte DIR_DOWN = 2;
    public static final byte DIR_LEFT = 3;
    public static final byte DIR_LEFT_UP = 4;
    public static final byte DIR_RIGHT_UP = 5;
    public static final byte DIR_LEFT_DOWN = 6;
    public static final byte DIR_RIGHT_DOWN = 7;
    static int lastKey;
    static byte keyDelay;
    static final byte KEYDELAYTIME = 5;
    boolean keyIsRelease;
    boolean autoMove;
    private int motionLen;
    boolean isInBase = true;
    byte walkTime;
    byte toStep;
    static boolean sayFlag;
    boolean noFrame;
    int faceID = -1;
    int faceIndex;
    byte faceFrame;
    static byte[] faceMotion;
    static byte[] faceOffY;
    byte showLifeTime;
    Event event;
    short pathIndex;
    int steps;
    boolean isStep;
    boolean isAction;
    int waitTime;
    static byte[] speeds;
    static byte[] Freq;
    byte attMode;
    public static final byte ATM_NORMAL = 0;
    public static final byte ATM_FALL = 1;
    public static final byte ATM_STUN = 2;
    public static final byte ATM_HOLD = 3;
    public static final byte ATM_FLOAT = 4;
    int ax;
    int ay;
    int aw;
    int ah;
    int dx;
    int dy;
    int dw;
    int dh;
    short alarmX;
    short alarmY;
    short alarmW = (short)200;
    short alarmH = (short)200;
    short attX;
    short attY;
    short attW = (short)30;
    short attH = (short)30;
    int aimX;
    int aimY;
    public static final byte AI_STOP = 0;
    public static final byte AI_RANDOM = 1;
    public static final byte AI_PATH = 2;
    public static final byte AI_0 = 3;
    public static final byte AI_1 = 4;
    int order;
    Sprite obj;
    int doTime;
    int sleepTime;
    static Sprite rebornS;
    int injureTime;
    short rndY;
    boolean pressed;
    boolean isCombo;
    static Vector VhitNum;
    public static final byte NUMTYPE_COMHIT = 0;
    public static final byte NUMTYPE_CRUE = 1;
    public static final byte NUMTYPE_CTRHIT = 2;
    public static final byte NUMTYPE_MISS = 5;
    static byte[][] adNum;
    static int[] proAdd;
    boolean reduceHp = false;
    static int tempAtk;
    static int tempDef;
    static int tempCri;
    static int tempLuck;
    static int tempHp_max;
    static int tempMp_max;

    public Sprite(Engine eg, int id) {
        this.ID = (byte)id;
        this.engine = eg;
    }

    public void init(short[] dat) {
        this.name = Variable.getString(dat[0], Script.exp);
        this.visible = Variable.getBool(dat[1], Script.exp);
        this.aiMode = (byte)Variable.getInt(dat[2], Script.exp, Script.bInt);
        this.isPass = true;
        this.isDrawShandow = Variable.getBool(dat[4], Script.exp);
        short[] pos = Variable.getArray(dat[5], Script.array);
        this.modle = pos[0];
        if (Engine.bigGameRank > 3 && this.aiMode == 0) {
            this.aiMode = 1;
        }
        if (this.ID != 0) {
            if (this.modle == 24) {
                this.aiMode = (byte)15;
            }
        } else {
            this.modle = UI.heroIndex;
        }
        if (Engine.gameRank == 46 && UI.heroIndex == 1 && this.ID == 16) {
            this.modle = 0;
        }
        if (Engine.gameRank == 58 && UI.heroIndex == 1 && this.ID == 20) {
            this.modle = 0;
        }
        if (Engine.gameRank == 83 && UI.heroIndex == 1 && this.ID == 1) {
            this.name = "\u7537\u4e3b";
            this.modle = 0;
        }
        this.x = pos[1] + pos[3] / 2;
        this.y = pos[2] - pos[4] + 16 - pos[4] / 2;
        this.w = pos[3];
        this.h = pos[4];
        this.dir = this.nextDir = pos[5];
        this.faceDir = this.nextDir;
        this.nextFaceDir = this.nextDir;
        this.type = (short)Variable.getInt(dat[6], Script.exp, Script.bInt);
        this.level = (byte)dat[7];
        this.exp = Data.fighterVauleData[this.type][4];
        this.initProp();
        this.initPS();
        this.initIS();
        Engine.bag.removeAllElements();
        Engine.store.removeAllElements();
        this.camp = (byte)dat[8];
        this.hp = this.hp_max;
        this.mp = this.mp_max;
        this.curStates = 0;
        this.nextStates = 0;
        this.index = 0;
        this.frameTimes = 0;
        this.toStep = 0;
        this.path = null;
        this.frequency = 1;
        this.injureTime = 0;
        this.z = 0;
    }

    void setDefaultArea() {
        if (Data.defaultArea[this.modle] == null) {
            return;
        }
        this.alarmX = Data.defaultArea[this.modle][1][0];
        this.alarmY = Data.defaultArea[this.modle][1][1];
        this.alarmW = (short)Map.mapW;
        this.alarmH = Data.defaultArea[this.modle][1][3];
        this.attX = Data.defaultArea[this.modle][2][0];
        this.attY = Data.defaultArea[this.modle][2][1];
        this.attW = (short)(Data.defaultArea[this.modle][2][2] / 2);
        this.attH = Data.defaultArea[this.modle][2][3];
    }

    public void initPS() {
        switch (this.type) {
            case 0: 
            case 1: {
                this.passiveSkill = new short[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 0, 0, 0, 0, 0, 0, 0}};
                break;
            }
        }
    }

    public void initIS() {
        switch (this.type) {
            case 0: 
            case 1: {
                this.initiativeSkill = new short[][]{{0, 1, 2, 3}, {0, 0, 0, 0}, {0, 0, 0, 0}};
                break;
            }
        }
    }

    public void initProp() {
        this.getFighterVaule();
        this.hp = this.hp_max;
        this.mp = this.mp_max;
    }

    boolean canNotCtrl() {
        return this.autoMove || this.isAction || this.isStep || this.curStates == 7 || this.curStates == 13 || this.curStates == 12 || this.curStates == 14 || this.curStates == 9 || this.curStates == 10 || this.curStates == 8 || this.curStates == 24 || this.curStates == 18;
    }

    void standUpfast() {
        if (this.curStates == 10) {
            this.index += 5;
        }
    }

    public void ctrl(int keyCode) {
        this.standUpfast();
        if (this.canNotCtrl()) {
            return;
        }
        switch (keyCode) {
            case -3: {
                switch (this.curStates) {
                    case 0: {
                        if ((lastKey == -3 || lastKey == 52) && keyDelay > 0) {
                            this.setStates(15);
                            break;
                        }
                        this.setStates(1);
                    }
                }
                this.setDir(3);
                this.resetKey();
                break;
            }
            case -4: {
                switch (this.curStates) {
                    case 0: {
                        if ((lastKey == -4 || lastKey == 54) && keyDelay > 0) {
                            this.setStates(15);
                            break;
                        }
                        this.setStates(1);
                    }
                }
                this.setDir(1);
                this.resetKey();
                break;
            }
            case -1: {
                switch (this.curStates) {
                    case 0: {
                        if ((lastKey == -1 || lastKey == 50) && keyDelay > 0) {
                            this.setStates(21);
                            break;
                        }
                        this.setStates(1);
                    }
                }
                this.setDir(0);
                this.resetKey();
                break;
            }
            case -2: {
                switch (this.curStates) {
                    case 0: {
                        if ((lastKey == -2 || lastKey == 52) && keyDelay > 0) {
                            this.setStates(22);
                            break;
                        }
                        this.setStates(1);
                    }
                }
                this.setDir(2);
                this.resetKey();
                break;
            }
            case -5: {
                this.attack();
                break;
            }
            case 51: {
                this.numAfterSkillUse(1);
                break;
            }
            case 55: {
                this.numAfterSkillUse(2);
                break;
            }
            case 57: {
                this.numAfterSkillUse(3);
                break;
            }
            case 42: {
                if (Engine.sprite != null && Engine.sprite[0] != null && Engine.sprite[0].hp == Engine.sprite[0].hp_max) {
                    GCanvas.setInfo(new String[]{"\u8840\u91cf\u5df2\u6ee1\uff0c\u65e0\u9700\u52a0\u8840"}, true);
                    return;
                }
                if (Engine.defaultItem[0][1] <= 0) break;
                Engine.defaultUseItem(Engine.creatItem(0, Engine.defaultItem[0][0], 1), Engine.sprite[0]);
                break;
            }
            case 49: {
                this.numAfterSkillUse(0);
                break;
            }
            case 35: {
                if (Engine.sprite != null && Engine.sprite[0] != null && Engine.sprite[0].mp == Engine.sprite[0].mp_max) {
                    GCanvas.setInfo(new String[]{"\u9b54\u6cd5\u5df2\u6ee1\uff0c\u65e0\u9700\u52a0\u9b54"}, true);
                    return;
                }
                if (Engine.defaultItem[1][1] <= 0) break;
                Engine.defaultUseItem(Engine.creatItem(0, Engine.defaultItem[1][0], 1), Engine.sprite[0]);
            }
        }
    }

    public void resetKey() {
        this.keyIsRelease = false;
    }

    public void ctrlRelease(int key) {
        if (!Script.isUserCtrl) {
            return;
        }
        this.keyIsRelease = true;
        lastKey = key;
        keyDelay = (byte)5;
    }

    private int getMotionLength(byte st) {
        if (Data.spriteMotionData[this.modle] == null) {
            return 0;
        }
        if (Data.spriteMotionData[this.modle][st] == null) {
            return Data.spriteMotionData[this.modle][0].length;
        }
        return Data.spriteMotionData[this.modle][st].length;
    }

    private int getMotinVaule(byte st, byte quality, int index) {
        if (Data.spriteMotionData[this.modle] == null) {
            return 0;
        }
        if (Data.spriteMotionData[this.modle][st] == null) {
            int temp = index % Data.spriteMotionData[this.modle][0].length;
            return Tools.getMotionValue(Data.spriteMotionData[this.modle][0][temp], quality);
        }
        return Tools.getMotionValue(Data.spriteMotionData[this.modle][st][index], quality);
    }

    private void setMotionVaules(byte state, boolean mir, int index) {
        this.curIndex = (byte)this.getMotinVaule(state, (byte)0, index);
        this.trans = (byte)(mir ? this.getMotinVaule(state, (byte)1, index) ^ 1 : this.getMotinVaule(state, (byte)1, index));
        this.sx += this.getMotinVaule(state, mir ? (byte)4 : 3, index) * -1;
        this.sy += this.getMotinVaule(state, (byte)5, index) * -1;
        if (this.frameTimes <= 0) {
            this.noFrame = false;
            switch (state) {
                case 1: {
                    this.frameTimes = (byte)this.frequency;
                    break;
                }
                default: {
                    this.frameTimes = (byte)this.getMotinVaule(state, (byte)2, index);
                    if (this.frameTimes >= 0) break;
                    this.noFrame = true;
                    this.frameTimes = -this.frameTimes;
                }
            }
        }
        this.motionLen = this.getMotionLength(state);
        this.runFrameEvent(state, index, mir);
    }

    public void run() {
        if (this.pause) {
            return;
        }
        if (this.injureTime > 0) {
            --this.injureTime;
        }
        if (this.flashTime > 0) {
            if (this.flashTime / this.flashFreq % 2 == 0) {
                boolean bl = this.visible = !this.visible;
            }
            if ((this.flashTime = (short)(this.flashTime - 1)) == 0) {
                this.finish();
            }
        }
        this.runHpBar();
        this.runSkillCD();
        if (!this.visible) {
            return;
        }
        if (this.isStep) {
            if (this.steps == 0) {
                this.setStates(0);
                this.isStep = false;
                this.nextDir = this.faceDir;
                this.finish();
            }
        } else if (this.autoMove) {
            this.autoMove();
        }
        this.dealKey();
        if (this.ID != Engine.spriteIndex) {
            this.AI();
        }
        this.damage = (short)this.getAttack();
        this.runPhysical();
        this.move();
        this.checkLevelUp();
        this.recover();
    }

    void runPhysical() {
        if (this.speedx != 0 || this.speedy != 0) {
            this.spriteMove(this.speedx, this.speedy);
        }
        this.z += this.speedz + -1;
        this.speedz += -3;
        if (this.z <= 0) {
            this.z = 0;
            this.speedx = 0;
            this.speedy = 0;
            this.speedz = 0;
        }
    }

    public void autoMove() {
        short toX = this.path[this.toStep][0];
        short toY = this.path[this.toStep][1];
        if (this.x < toX - this.STEP) {
            this.setDir(1);
        } else if (this.x > toX + this.STEP) {
            this.setDir(3);
        } else if (this.y < toY - this.STEP) {
            this.setDir(2);
        } else if (this.y > toY + this.STEP) {
            this.setDir(0);
        } else {
            this.toStep = (byte)(this.toStep + 1);
            if (this.toStep >= this.path.length) {
                this.setStates(0);
                this.autoMove = false;
                this.finish();
            } else {
                this.autoMove();
            }
        }
    }

    int getMx(int dir) {
        switch (dir) {
            case 3: 
            case 4: 
            case 6: {
                return -1;
            }
            case 0: 
            case 2: {
                return 0;
            }
            case 1: 
            case 5: 
            case 7: {
                return 1;
            }
        }
        return 0;
    }

    int getMy(int dir) {
        switch (dir) {
            case 0: 
            case 4: 
            case 5: {
                return -1;
            }
            case 1: 
            case 3: {
                return 0;
            }
            case 2: 
            case 6: 
            case 7: {
                return 1;
            }
        }
        return 0;
    }

    public void move() {
        this.sx = 0;
        this.sy = 0;
        if (this.keyIsRelease && !this.autoMove && !this.isStep) {
            switch (this.curStates) {
                case 1: {
                    this.setStates(0);
                    this.keyIsRelease = false;
                    this.index = 0;
                    break;
                }
                case 15: {
                    if (Engine.sprite == null || Engine.sprite[Engine.spriteIndex].modle != 1) break;
                    this.setStates(0);
                    this.keyIsRelease = false;
                    this.index = 0;
                }
            }
        }
        if (this.curStates != this.nextStates) {
            this.curStates = this.nextStates;
            this.frameTimes = 0;
            this.index = 0;
        }
        if (this.dir != this.nextDir) {
            this.dir = this.nextDir;
        }
        this.faceDir = this.nextFaceDir;
        this.speed = this.nextSpeed;
        if (Engine.sprite != null && Engine.sprite[Engine.spriteIndex].modle == 1 && Engine.sprite[Engine.spriteIndex].curStates == 15) {
            Engine.sprite[Engine.spriteIndex].speed = 1;
        }
        this.STEP = Map.tileWidth / this.speed;
        switch (this.curStates) {
            case 18: {
                this.visible = false;
                break;
            }
            case 1: {
                if (this.hp <= 0) {
                    if (this.modle == 12) {
                        this.dead(0);
                        Engine.sprite[2].hp = 0;
                        Engine.sprite[3].hp = 0;
                    } else {
                        this.dead(0);
                    }
                }
                this.setMotionVaules((byte)1, this.faceDir == 1, this.index);
                if (this.steps > 0) {
                    --this.steps;
                }
                if ((this.frameTimes = (byte)(this.frameTimes - 1)) > 0) break;
                this.spriteMove(this.getMx(this.dir) * this.STEP, this.getMy(this.dir) * this.STEP);
                if (++this.index < this.motionLen) break;
                this.index = 0;
                this.frameTimes = 0;
                break;
            }
            case 0: {
                if (this.hp <= 0) {
                    if (this.modle == 12) {
                        this.dead(0);
                        Engine.sprite[2].hp = 0;
                        Engine.sprite[3].hp = 0;
                    } else {
                        this.dead(0);
                    }
                }
                if (this.isBox() && this.hp <= this.hp_max / 2) {
                    this.setMotionVaules((byte)1, this.faceDir == 1, this.index);
                } else {
                    this.setMotionVaules((byte)0, this.faceDir == 1, this.index);
                }
                this.keyIsRelease = false;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes <= 0 && ++this.index >= this.motionLen) {
                    this.index = 0;
                    this.frameTimes = 0;
                }
                if (this.waitTime <= 0 || --this.waitTime != 0) break;
                this.isAction = false;
                this.finish();
                break;
            }
            case 2: {
                this.skillType = (byte)-1;
                this.setMotionVaules((byte)2, this.faceDir == 1, this.index);
                this.keyIsRelease = false;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0) break;
                if (++this.index >= this.motionLen) {
                    this.index = 0;
                    this.isCombo = true;
                    if (this.isAction) {
                        this.finish();
                        this.isAction = false;
                    }
                }
                this.breakCombo(0);
                break;
            }
            case 13: {
                this.setMotionVaules((byte)13, this.faceDir == 1, 0);
                this.keyIsRelease = false;
                if (this.z > 0 || this.speedz > 0) break;
                this.injureEnd(10, 1);
                break;
            }
            case 12: {
                this.setMotionVaules((byte)12, this.faceDir == 1, this.index);
                this.keyIsRelease = false;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.injureEnd(0, 0);
                break;
            }
            case 7: {
                this.setMotionVaules((byte)7, this.faceDir == 1, this.index);
                this.keyIsRelease = false;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.injureEnd(0, 0);
                break;
            }
            case 4: {
                this.setMotionVaules((byte)4, this.faceDir == 1, this.index);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.index = 0;
                this.frameTimes = 0;
                this.skill1ReduceMp();
                if (GCanvas.isPressed(51)) break;
                this.setStates(5);
                break;
            }
            case 9: {
                this.setMotionVaules((byte)9, this.faceDir == 1, this.index);
                this.spriteMove(0, this.rndY);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                if (this.hp > 0) {
                    this.setStates(10);
                    break;
                }
                if (this.modle == 12) {
                    this.dead(1);
                    Engine.sprite[2].hp = 0;
                    Engine.sprite[3].hp = 0;
                    break;
                }
                this.dead(1);
                break;
            }
            case 10: {
                this.setMotionVaules((byte)10, this.faceDir == 1, 0);
                if (++this.index < FALLTIME) break;
                this.index = 0;
                this.frameTimes = 0;
                if (this.camp == 0) break;
                this.setStates(0);
                break;
            }
            case 11: {
                this.setMotionVaules((byte)11, this.faceDir == 1, this.index);
                this.skillType = (byte)-1;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.index = 0;
                this.frameTimes = 0;
                Sprite.rebornS.hp = Sprite.rebornS.hp_max;
                Sprite.rebornS.visible = true;
                rebornS.setStates(0);
                Effect.addEffect(Sprite.rebornS.x, Sprite.rebornS.y, 21, 0, 0, 2000);
                this.setStates(0);
                if (!this.isAction) break;
                this.finish();
                this.isAction = false;
                break;
            }
            case 26: {
                this.setMotionVaules((byte)11, this.faceDir == 1, this.index);
                this.skillType = (byte)-1;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.index = 0;
                this.frameTimes = 0;
                Sprite.rebornS.hp += Sprite.rebornS.hp_max / 2;
                if (Sprite.rebornS.hp > Sprite.rebornS.hp_max) {
                    Sprite.rebornS.hp = Sprite.rebornS.hp_max;
                }
                rebornS.setStates(0);
                Effect.addEffect(Sprite.rebornS.x, Sprite.rebornS.y, 31, 0, 0, 2000);
                this.setStates(0);
                if (!this.isAction) break;
                this.finish();
                this.isAction = false;
                break;
            }
            case 27: {
                this.setMotionVaules((byte)27, this.faceDir == 1, this.index);
                this.skillType = (byte)-1;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.index = 0;
                this.frameTimes = 0;
                this.visible = false;
                Engine.fireIndex = 0;
                switch (Engine.SKILLDIF) {
                    case 0: {
                        Engine.fireXY = new short[][]{{-1, -1}, {-2, -2}, {-2, -2}};
                        Engine.tempfireXY = new short[][]{{-1, -1}, {-2, -2}, {-2, -2}};
                        break;
                    }
                    case 1: {
                        Engine.fireXY = new short[][]{{-1, -1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}};
                        Engine.tempfireXY = new short[][]{{-1, -1}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}, {-2, -2}};
                        break;
                    }
                    case 2: {
                        Engine.fireXY = new short[][]{{-3, -3}, {-4, -4}};
                        Engine.tempfireXY = new short[][]{{-3, -3}, {-4, -4}};
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                if (!this.isAction) break;
                this.finish();
                this.isAction = false;
                break;
            }
            case 17: {
                this.setMotionVaules((byte)17, this.faceDir == 1, 0);
                if (this.hp < 0) {
                    if (this.modle == 12) {
                        this.dead(0);
                        Engine.sprite[2].hp = 0;
                        Engine.sprite[3].hp = 0;
                    } else {
                        this.dead(0);
                    }
                }
                if (GCanvas.gameTime % 3 == 0) {
                    Effect.addEffect(this.x, this.y - 50, 26, 0, 0, this.y + 1000);
                }
                if (++this.index < STUNTIME) break;
                this.index = 0;
                this.frameTimes = 0;
                this.setStates(0);
                break;
            }
            case 24: {
                this.setMotionVaules((byte)24, this.faceDir == 1, this.index);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.toDeadEnd();
                break;
            }
            case 8: {
                this.setMotionVaules((byte)8, this.faceDir == 1, this.index);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.toDeadEnd();
                break;
            }
            case 3: {
                this.setMotionVaules(this.curStates, this.faceDir == 1, this.index);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.index = 0;
                this.frameTimes = 0;
                switch (this.skillType) {
                    case 0: {
                        this.setStates(20);
                        break;
                    }
                    case 1: {
                        this.setStates(4);
                        break;
                    }
                    case 2: {
                        this.setStates(6);
                        break;
                    }
                    case 3: {
                        this.setStates(23);
                    }
                }
                break;
            }
            case 16: {
                this.skillType = (byte)-1;
                this.setMotionVaules(this.curStates, this.faceDir == 1, this.index);
                this.keyIsRelease = false;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0) break;
                this.breakCombo(19);
                if (++this.index < this.motionLen) break;
                this.isCombo = true;
                this.setStates(0);
                break;
            }
            case 15: {
                if (Engine.sprite != null && Engine.sprite[Engine.spriteIndex].modle == 1) {
                    this.setMotionVaules((byte)15, this.faceDir == 1, this.index);
                    if (this.steps > 0) {
                        --this.steps;
                    }
                    if ((this.frameTimes = (byte)(this.frameTimes - 1)) > 0) break;
                    this.spriteMove(this.getMx(this.dir) * this.STEP, this.getMy(this.dir) * this.STEP);
                    if (++this.index < this.motionLen) break;
                    this.index = 0;
                    this.frameTimes = 0;
                    break;
                }
                this.setMotionVaules(this.curStates, this.faceDir == 1, this.index);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.index = 0;
                this.setStates(0);
                this.frameTimes = 0;
                if (!this.isAction) break;
                this.finish();
                this.isAction = false;
                break;
            }
            default: {
                if (this.curStates != 20 && this.curStates != 5 && this.curStates != 4 && this.curStates != 6 && this.curStates != 23) {
                    this.skillType = (byte)-1;
                }
                this.setMotionVaules(this.curStates, this.faceDir == 1, this.index);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0 || ++this.index < this.motionLen) break;
                this.index = 0;
                this.setStates(0);
                this.frameTimes = 0;
                if (!this.isAction) break;
                this.finish();
                this.isAction = false;
            }
        }
        this.sx += this.x;
        this.sy += this.y - this.z;
    }

    void injureEnd(int toStatus, int deadType) {
        if (this.hp > 0) {
            this.setStates(toStatus);
        } else if (this.modle == 12) {
            this.dead(deadType);
            Engine.sprite[2].hp = 0;
            Engine.sprite[3].hp = 0;
        } else {
            this.dead(deadType);
        }
    }

    void toDeadEnd() {
        this.setStates(18);
    }

    int getExp(int e2) {
        return e2 * Engine.sprite[Engine.spriteIndex].getExpPer / 100;
    }

    public void dead(int deadType) {
        this.killScore();
        if (!this.isRole()) {
            Engine.sprite[Engine.spriteIndex].exp = GCanvas.doubleExp ? (Engine.sprite[Engine.spriteIndex].exp += this.getExp(this.exp) * 2) : (Engine.sprite[Engine.spriteIndex].exp += this.getExp(this.exp));
        }
        switch (deadType) {
            case 0: {
                this.setStates(8);
                break;
            }
            case 1: {
                this.setStates(24);
            }
        }
        if (!this.isRole()) {
            Sprite.dropItem(this);
        }
    }

    void randowWalk() {
        this.walkTime = (byte)(this.walkTime - 1);
        if (this.walkTime <= 0) {
            if (this.isInBase) {
                byte[] rndDir = new byte[]{0, 2, 3, 1};
                this.setDir(Tools.nextInt(rndDir.length - 1));
                this.step(false, 8);
                this.isInBase = false;
            } else {
                this.setDir(this.dir ^ 2);
                this.step(false, 8);
                this.isInBase = true;
            }
            this.walkTime = (byte)Tools.nextInt(20, 40);
        }
    }

    void pathWalk() {
        short toX = this.path[this.toStep][0];
        short toY = this.path[this.toStep][1];
        if (this.x < toX) {
            this.setDir(1);
        } else if (this.x > toX) {
            this.setDir(3);
        } else if (this.y < toY) {
            this.setDir(2);
        } else if (this.y > toY) {
            this.setDir(0);
        } else {
            this.setStates(0);
            this.toStep = (byte)((this.toStep + 1) % this.path.length);
        }
        if (this.curStates != 1) {
            this.setStates(1);
        }
    }

    void checkLevelUp() {
        if (!this.isRole()) {
            return;
        }
        if (this.exp >= this.exp_max && this.level >= this.level_max && this.level_max != 999 && !sayFlag) {
            GCanvas.setInfo(new String[]{"\u5230\u7b49\u7ea7\u4e0a\u9650\uff0c\u8bf7\u81f3\u5546\u57ce\u8d2d\u4e70\u7a81\u7834\u7b49\u7ea7\u4e0a\u9650"}, true);
            sayFlag = true;
        }
        if (this.exp >= this.exp_max && this.level < this.level_max) {
            GCanvas.setST((byte)40);
        }
    }

    public void paint(int lev) {
        if (!this.visible || this.modle == -1 || this.noFrame) {
            return;
        }
        int drawLevel = lev;
        if (this.isArrow()) {
            drawLevel = 1000;
        }
        if (this.isDrawShandow) {
            this.drawRoleShandow(drawLevel);
            this.drawBossShandow(drawLevel);
        }
        this.drawSprite(this.modle, drawLevel);
        this.drawFace(this.x, this.y - 40, drawLevel);
        this.drawLife(this.x, this.y - 65, drawLevel);
    }

    void drawSprite(int modle, int lev) {
        int imageDir = -1;
        switch (modle) {
            case 3: {
                imageDir = 18;
                break;
            }
            case 2: {
                imageDir = 19;
                break;
            }
            case 4: {
                imageDir = 20;
            }
        }
        if (imageDir == -1) {
            Tools.addSpFrame(modle, Data.spriteClipData[modle], Data.spriteFrameData[modle], Data.spriteExFrameData[modle], this.sx, this.sy, this.curIndex, this.trans, (byte)2, lev);
            if (Engine.bigGameRank != 0 && modle == 22 && this.visible && GCanvas.gameTime % 10 / 8 == 0) {
                Tools.addString("\u70b9\u51fb\u653b\u51fb\u56fe\u6807\u8fdb\u5165", this.x, this.y - 110, (byte)4, 0xFFFFFF, lev);
            }
            if (Engine.bigGameRank != 0 && modle == 24 && Engine.gameRank != 13 && this.visible && GCanvas.gameTime % 10 / 8 == 0) {
                Tools.addString("\u70b9\u51fb\u653b\u51fb\u56fe\u6807\u8fdb\u5165", this.x, this.y - 110, (byte)4, 0xFFFFFF, lev);
            }
        } else {
            Tools.addImage(imageDir, this.curIndex, this.sx, this.sy, (byte)2, this.trans, lev);
        }
    }

    public void showFace(int face) {
        this.faceID = face;
        this.faceIndex = 0;
    }

    public void drawFace(int x2, int y2, int lev) {
        if (this.faceID == -1) {
            return;
        }
        if (Tools.getImage(13, this.faceID) != null) {
            Tools.addImage(13, this.faceID, x2 - 11, y2 + faceOffY[this.faceIndex], 21 * faceMotion[this.faceIndex], 0, 21, 19, (byte)2, (byte)0, lev);
        }
        if (++this.faceIndex >= faceMotion.length) {
            this.faceIndex = 0;
            this.faceID = -1;
            this.finish();
        }
    }

    public void drawLife(int x2, int y2, int layer) {
    }

    public void roleMove(int mx, int my) {
        int tx = this.x + (mx > 0 ? this.w / 2 : -this.w / 2) + mx;
        int ty = this.y + (my < 0 ? -this.h / 2 : this.h / 2) + my;
        if (!this.canRun(tx, this.y + this.h / 2 - 1) || !this.canRun(tx, this.y - this.h / 2 + 1)) {
            if (mx < 0) {
                this.x = this.getGridValue(tx, Map.tileWidth) + Map.tileWidth + this.w / 2;
            } else if (mx > 0) {
                this.x = this.getGridValue(tx, Map.tileWidth) - this.w / 2;
            }
        } else {
            this.x += mx;
        }
        if (!this.canRun(this.x - this.w / 2 + 1, ty) || !this.canRun(this.x + this.w / 2 - 1, ty)) {
            if (my < 0) {
                this.y = this.getGridValue(ty, Map.tileHight) + Map.tileHight + this.h / 2;
            } else if (my > 0) {
                this.y = this.getGridValue(ty, Map.tileHight) - this.h / 2;
            }
        } else {
            this.y += my;
        }
        this.x = Math.min(Map.mapW, this.x);
        this.x = Math.max(0, this.x);
        this.y = Math.min(Map.mapH, this.y);
        this.y = Math.max(0, this.y);
    }

    void spriteMove(int mx, int my) {
        if (GCanvas.gameStatus != 7) {
            return;
        }
        int px = mx;
        int tx = mx > 0 ? Map.tileWidth - 1 : -Map.tileWidth + 1;
        int py = my;
        int ty = my > 0 ? Map.tileHight - 1 : -Map.tileHight + 1;
        do {
            int moveX = mx > 0 ? Math.min(tx, px) : Math.max(tx, px);
            this.roleMove(moveX, 0);
        } while (Math.abs(px -= tx) >= Map.tileWidth);
        do {
            int moveY = my > 0 ? Math.min(ty, py) : Math.max(ty, py);
            this.roleMove(0, moveY);
        } while (Math.abs(py -= ty) >= Map.tileHight);
    }

    private int getGridValue(int v2, int tileW) {
        return (v2 + tileW) / tileW * tileW - tileW;
    }

    public boolean canRun(int x2, int y2) {
        if (this.autoMove) {
            return true;
        }
        Map map = Engine.map;
        return map.canRun(x2, y2);
    }

    public void sender(Event event, short pathIndex) {
        this.event = event;
        this.pathIndex = pathIndex;
    }

    public void finish() {
        if (this.event != null) {
            this.event.setEnd(this.pathIndex);
            this.event = null;
        }
    }

    public void setNextPoint(short[] pos) {
        this.path = new short[pos.length / 2][2];
        int i2 = 0;
        while (i2 < this.path.length) {
            this.path[i2][0] = (short)(pos[i2 * 2] + 8);
            this.path[i2][1] = (short)(pos[1 + i2 * 2] - 8);
            ++i2;
        }
        this.toStep = 0;
        this.setStates(1);
        this.autoMove = true;
    }

    public void step(boolean isBack, int steps) {
        if (isBack) {
            this.nextDir = (this.dir + 2) % 4;
        }
        this.steps = steps;
        this.setStates(1);
        this.isStep = true;
    }

    public void showAction(int state) {
        this.isAction = true;
        this.setStates(state);
    }

    public void roleWait(int time) {
        this.isAction = true;
        this.waitTime = time;
        this.setStates(0);
    }

    public void changeSpeed(int speedLev) {
        if (speedLev >= speeds.length) {
            return;
        }
        this.nextSpeed = speeds[speedLev];
    }

    public void changeFreq(int freqLev) {
        if (freqLev >= Freq.length) {
            return;
        }
        this.frequency = Freq[freqLev];
    }

    void changeModle(int modle) {
        this.modle = (short)modle;
    }

    public void setVisible(int x2, int y2, int dir) {
        this.visible = true;
        this.x = x2;
        this.y = y2;
        this.nextFaceDir = this.dir = dir;
        this.nextDir = this.dir;
        this.faceDir = this.dir;
    }

    public void show(boolean visible) {
        this.visible = visible;
    }

    void setPath(short[] dat) {
        this.aiMode = (byte)2;
        this.path = new short[dat.length / 2][2];
        int i2 = 0;
        while (i2 < this.path.length) {
            this.path[i2][0] = dat[i2 * 2];
            this.path[i2][1] = dat[1 + i2 * 2];
            ++i2;
        }
    }

    public void setDir(int direct) {
        this.nextDir = direct;
        switch (direct) {
            case 3: 
            case 4: 
            case 6: {
                this.nextFaceDir = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                this.nextFaceDir = 1;
            }
        }
    }

    public void setStates(int state) {
        this.nextStates = (byte)state;
        this.superArmor = new boolean[5];
        this.superSkill = false;
    }

    void runFrameEvent(int state, int index, boolean isMirror) {
        if (Data.defaultArea[this.modle] == null) {
            return;
        }
        this.vHitEffect = new Vector();
        this.aw = 0;
        this.dx = Data.defaultArea[this.modle][0][0];
        this.dy = Data.defaultArea[this.modle][0][1];
        this.dw = Data.defaultArea[this.modle][0][2];
        this.dh = Data.defaultArea[this.modle][0][3];
        this.isCombo = false;
        this.attMode = 0;
        if (Data.frameScript[this.modle][state] == null) {
            return;
        }
        short[][] fEvent = Data.frameScript[this.modle][state][index];
        if (fEvent == null) {
            return;
        }
        int i2 = 0;
        while (i2 < fEvent.length) {
            switch (fEvent[i2][0]) {
                case 15: {
                    break;
                }
                case 13: {
                    int j2 = 0;
                    while (j2 < this.superArmor.length) {
                        this.superArmor[j2] = fEvent[i2][j2 + 1] == 1;
                        ++j2;
                    }
                    break;
                }
                case 12: {
                    GMIDlet.setSleepTime(fEvent[i2][1], fEvent[i2][2]);
                    break;
                }
                case 11: {
                    this.superSkill = fEvent[i2][1] == 0;
                    break;
                }
                case 10: {
                    if (GCanvas.gameStatus == 33 || GCanvas.gameStatus == 48) break;
                    Engine.blackTime = fEvent[i2][1];
                    switch (fEvent[i2][2]) {
                        case 0: {
                            Engine.blackColor = 0;
                            break;
                        }
                        case 1: {
                            Engine.blackColor = 0xFF0000;
                            break;
                        }
                        case 2: {
                            Engine.blackColor = 0xFFFFFF;
                        }
                    }
                    break;
                }
                case 2: {
                    this.aw = fEvent[i2][3];
                    this.ah = fEvent[i2][4];
                    this.ax = isMirror ? -fEvent[i2][1] - this.aw : fEvent[i2][1];
                    this.ay = fEvent[i2][2];
                    this.attMode = (byte)fEvent[i2][5];
                    break;
                }
                case 1: {
                    this.dw = fEvent[i2][3];
                    this.dh = fEvent[i2][4];
                    this.dx = isMirror ? -fEvent[i2][1] - this.dw : fEvent[i2][1];
                    this.dy = fEvent[i2][2];
                    break;
                }
                case 3: {
                    if (this.ID != Engine.spriteIndex || !Script.isUserCtrl) break;
                    this.isCombo = true;
                    break;
                }
                case 4: {
                    this.spriteMove(isMirror ? -fEvent[i2][1] : fEvent[i2][1], fEvent[i2][2]);
                    break;
                }
                case 14: {
                    if (fEvent[i2][1] == -1 && fEvent[i2][2] == -1) {
                        this.x = (short)Engine.sprite[0].x;
                        if (this.x > 240 && this.modle == 19) {
                            this.x = 240;
                        }
                        if (this.x < 240 && this.modle == 20) {
                            this.x = 240;
                        }
                        this.y = (short)Engine.sprite[0].y;
                        break;
                    }
                    this.x = fEvent[i2][1];
                    this.y = fEvent[i2][2];
                    break;
                }
                case 6: {
                    if (GCanvas.gameStatus == 33 || GCanvas.gameStatus == 48) break;
                    Engine.shakeTime = fEvent[i2][1];
                    Engine.shakeWave = fEvent[i2][2];
                    break;
                }
                case 7: {
                    int index1 = fEvent[i2][1];
                    int index2 = fEvent[i2][2];
                    int offsetX = this.x + (isMirror ? -fEvent[i2][3] : fEvent[i2][3]);
                    int offsetY = this.y + fEvent[i2][4];
                    int mir = isMirror ? 1 - fEvent[i2][5] : fEvent[i2][5];
                    short dl = Map.getLayer(fEvent[i2][6]);
                    if (GCanvas.gameStatus == 33 || GCanvas.gameStatus == 48) break;
                    Effect.addEffect(offsetX, offsetY, index1, index2, mir, this.y + dl);
                    break;
                }
                case 8: {
                    int index1 = fEvent[i2][1];
                    int index2 = fEvent[i2][2];
                    int offsetX = this.x + (isMirror ? -fEvent[i2][3] : fEvent[i2][3]);
                    int offsetY = this.y + fEvent[i2][4];
                    int mir = isMirror ? 1 - fEvent[i2][5] : fEvent[i2][5];
                    short time = fEvent[i2][6];
                    int speedX = fEvent[i2][7] * (isMirror ? -1 : 1);
                    short speedY = fEvent[i2][8];
                    short shotW = fEvent[i2][9];
                    short shotH = fEvent[i2][10];
                    short attMode = fEvent[i2][11];
                    if (GCanvas.gameStatus == 33 || GCanvas.gameStatus == 48) break;
                    Engine.addShot(index1, index2, offsetX, offsetY, mir, time, speedX, speedY, shotW, shotH, attMode, this.camp, this.damage);
                    break;
                }
                case 9: {
                    int index1 = fEvent[i2][1];
                    int index2 = fEvent[i2][2];
                    int offsetX = isMirror ? -fEvent[i2][3] : fEvent[i2][3];
                    int offsetY = fEvent[i2][4];
                    int mir = isMirror ? 1 - fEvent[i2][5] : fEvent[i2][5];
                    short dl = Map.getLayer(fEvent[i2][6]);
                    this.vHitEffect.addElement(new int[]{index1, index2, offsetX, offsetY, mir, dl});
                }
            }
            ++i2;
        }
    }

    public void search(int px, int py) {
        int yDir;
        int xDir = this.x < px ? 1 : -1;
        int n2 = yDir = this.y < py ? 1 : -1;
        if (Math.abs(this.x - px) > Math.abs(this.y - py)) {
            yDir = 0;
        }
        if (Math.abs(this.x - px) < 10) {
            xDir = 0;
        }
        if (Math.abs(this.y - py) < 10) {
            yDir = 0;
        }
        block0 : switch (xDir) {
            case -1: {
                switch (yDir) {
                    case -1: {
                        this.setDir(4);
                        break;
                    }
                    case 0: {
                        this.setDir(3);
                        break;
                    }
                    case 1: {
                        this.setDir(6);
                    }
                }
                break;
            }
            case 0: {
                switch (yDir) {
                    case -1: {
                        this.setDir(0);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.setDir(2);
                    }
                }
                break;
            }
            case 1: {
                switch (yDir) {
                    case -1: {
                        this.setDir(5);
                        break block0;
                    }
                    case 0: {
                        this.setDir(1);
                        break block0;
                    }
                    case 1: {
                        this.setDir(7);
                    }
                }
            }
        }
    }

    public void simpleSearch(int px, int py) {
        int yDir;
        int xDir = this.x < px ? 1 : 3;
        int n2 = yDir = this.y < py ? 2 : 0;
        if (Math.abs(this.x - px) < 10) {
            xDir = -1;
        }
        if (Math.abs(this.y - py) < 10) {
            yDir = -1;
        }
        if (yDir >= 0 && yDir != (this.dir + 2) % 4) {
            if (this.checkCanPass(yDir)) {
                this.setDir(yDir);
                return;
            }
        } else if (xDir >= 0 && xDir != (this.dir + 2) % 4 && this.checkCanPass(xDir)) {
            this.setDir(xDir);
            return;
        }
        if (!this.checkCanPass(this.dir)) {
            if (this.dir == xDir || this.dir == yDir) {
                byte d2 = this.turn(this.x, this.y, px, py, this.dir);
                if (this.checkCanPass(d2)) {
                    this.setDir(d2);
                } else {
                    this.setDir((d2 + 2) % 4);
                }
            } else {
                this.setDir((this.dir + 2) % 4);
            }
        }
    }

    public void setOrder(int order, Sprite s2, int doTime, int sleepTime) {
        this.order = order;
        this.obj = s2;
        this.doTime = doTime;
        if (sleepTime == -1) {
            doTime = 0;
        }
        this.sleepTime = sleepTime + doTime;
    }

    public void wake() {
        this.sleepTime = 0;
    }

    public void rest() {
        this.order = -1;
    }

    public void AI() {
        if (this.isBox() || this.hp <= 0 || GCanvas.gameStatus != 7 || !Script.isUserCtrl || this.camp == 0) {
            return;
        }
        if (this.speedx != 0 || this.speedy != 0 || this.speedz != 0) {
            return;
        }
        if (this.curStates != 0 && this.curStates != 1) {
            return;
        }
        if (this.sleepTime > 0) {
            --this.sleepTime;
        }
        if (this.sleepTime == 0) {
            Engine.ai[this.aiMode].run(this);
        }
        this.runOrder();
    }

    public void runOrder() {
        switch (this.order) {
            case 165: {
                Sprite.skill(this, this.obj);
                break;
            }
            case 160: {
                Sprite.stop(this);
                break;
            }
            case 164: {
                if (this.modle == 12) {
                    if (Engine.sprite[0].x < 240 && Engine.sprite[0].x > 120) {
                        Sprite.attack(Engine.sprite[3], this.obj);
                        break;
                    }
                    if (Engine.sprite[0].x < 240 || Engine.sprite[0].x >= 360) break;
                    Sprite.attack(Engine.sprite[2], this.obj);
                    break;
                }
                Sprite.attack(this, this.obj);
                break;
            }
            case 162: {
                Sprite.closeTo(this, this.obj);
                break;
            }
            case 163: {
                Sprite.farAway(this, this.obj);
                break;
            }
            case 173: {
                Sprite.reborn(this, this.obj);
                break;
            }
            case 174: {
                Sprite.skillAddHp(this, this.obj);
                break;
            }
            case 175: {
                Sprite.skillFire(this, this.doTime);
                break;
            }
            case 161: {
                this.walkFree(this);
            }
        }
    }

    void walkFree(Sprite s1) {
        int yy;
        int xx;
        System.out.println("walk");
        do {
            xx = Tools.nextInt(32, Map.mapW);
            yy = Tools.nextInt(192, 256);
        } while (!this.canRun(this.x, this.y));
        if (AI.checkAreaXY(s1, s1.attW, s1.attH, xx, yy)) {
            s1.wake();
            s1.setStates(0);
            return;
        }
        s1.search(xx, yy);
        s1.setStates(1);
        if (s1.doTime > 0) {
            --s1.doTime;
        }
        if (s1.doTime == 0) {
            s1.setStates(0);
            s1.rest();
        }
    }

    public static void stop(Sprite s1) {
        switch (s1.curStates) {
            case 0: 
            case 1: {
                s1.setStates(0);
                s1.rest();
            }
        }
    }

    public static void reborn(Sprite s1, Sprite s2) {
        switch (s1.curStates) {
            case 0: 
            case 1: {
                if (s2 != null) {
                    s1.setStates(11);
                    rebornS = s2;
                }
                s1.rest();
            }
        }
    }

    public static void skillAddHp(Sprite s1, Sprite s2) {
        switch (s1.curStates) {
            case 0: 
            case 1: {
                if (s2 != null) {
                    s1.setStates(26);
                    rebornS = s2;
                }
                s1.rest();
            }
        }
    }

    public static void skillFire(Sprite s1, int s2) {
        switch (s1.curStates) {
            case 0: 
            case 1: {
                Engine.SKILLDIF = s1.hp < s1.hp_max * 35 / 100 ? (byte)2 : (s1.hp < s1.hp_max * 75 / 100 ? (byte)1 : 0);
                s1.setStates(27);
                s1.rest();
            }
        }
    }

    public static void attack(Sprite s1, Sprite s2) {
        switch (s1.curStates) {
            case 0: 
            case 1: {
                int tmpX = s1.x;
                int tmpY = s1.y;
                int px = s2.x;
                int py = s2.y;
                if (s1.modle != 20) {
                    s1.setDir(tmpX < px ? 1 : 3);
                }
                if (!s2.isProtect()) {
                    s1.setStates(2);
                }
                s1.rest();
            }
        }
    }

    public static void skill(Sprite s1, Sprite s2) {
        switch (s1.curStates) {
            case 0: 
            case 1: {
                int tmpX = s1.x;
                int tmpY = s1.y;
                int px = s2.x;
                int py = s2.y;
                s1.setDir(tmpX < px ? 1 : 3);
                switch (s1.doTime) {
                    case 0: {
                        s1.setStates(6);
                        break;
                    }
                    case 1: {
                        s1.setStates(20);
                        break;
                    }
                    case 2: {
                        s1.setStates(23);
                        break;
                    }
                    default: {
                        s1.setStates(6);
                    }
                }
                s1.rest();
            }
        }
    }

    public static void closeTo(Sprite s1, Sprite s2) {
        int tmpX = s1.x;
        int tmpY = s1.y;
        int px = s2.x;
        int py = s2.y;
        if (AI.checkArea(s1, s1.attW, s1.attH, s2)) {
            s1.wake();
            s1.setStates(0);
            return;
        }
        s1.search(px, py);
        s1.setStates(1);
        if (s1.doTime > 0) {
            --s1.doTime;
        }
        if (s1.doTime == 0) {
            s1.setStates(0);
            s1.rest();
        }
    }

    public static void moveTo(Sprite s1) {
        if (Tools.hit(s1.x - s1.w / 2, s1.y + s1.h / 2, s1.w, s1.h, s1.aimX, s1.aimY, Map.tileWidth, Map.tileHight)) {
            s1.wake();
            s1.setStates(0);
        }
        s1.search(s1.aimX, s1.aimY);
        s1.setStates(1);
        if (s1.doTime > 0) {
            --s1.doTime;
        }
        if (s1.doTime == 0) {
            s1.setStates(0);
            s1.rest();
        }
    }

    public static void farAway(Sprite s1, Sprite s2) {
        int tmpX = s1.x;
        int tmpY = s2.y;
        int px = s2.x;
        int py = s2.y;
        s1.nextDir = tmpX < px ? 3 : 1;
        s1.setStates(1);
        if (s1.doTime > 0) {
            --s1.doTime;
        }
        if (s1.doTime == 0) {
            s1.setStates(0);
            s1.setDir(s1.faceDir);
            s1.rest();
        }
    }

    public byte turn(int x2, int y2, int px, int py, int dir) {
        switch (dir) {
            case 0: 
            case 2: {
                return x2 < px ? (byte)1 : 3;
            }
            case 1: 
            case 3: {
                return y2 < py ? (byte)2 : 0;
            }
        }
        return 0;
    }

    boolean checkCanPass(int dir) {
        switch (dir) {
            case 0: {
                if (!this.canRun(this.x - this.w / 2, this.y - this.h / 2 - 1) || !this.canRun(this.x + this.w / 2 - 1, this.y - this.h / 2 - 1)) break;
                return true;
            }
            case 2: {
                if (!this.canRun(this.x - this.w / 2, this.y + this.h / 2) || !this.canRun(this.x + this.w / 2 - 1, this.y + this.h / 2)) break;
                return true;
            }
            case 3: {
                if (!this.canRun(this.x - this.w / 2 - 1, this.y + this.h / 2 - 1) || !this.canRun(this.x - this.w / 2 - 1, this.y - this.h / 2)) break;
                return true;
            }
            case 1: {
                if (!this.canRun(this.x + this.w / 2, this.y + this.h / 2 - 1) || !this.canRun(this.x + this.w / 2, this.y - this.h / 2)) break;
                return true;
            }
        }
        return false;
    }

    public void injure(int attackMode, int damage, int criticalRate, int spx, int spy, int time, Sprite s2, Vector vHitEffect) {
        boolean isCritical;
        if (Event.isSkiping) {
            return;
        }
        if (this.hp <= 0 || this.injureTime > 0 || this.isInvincible(attackMode)) {
            return;
        }
        if (spx != 0) {
            this.setDir(spx > 0 ? 3 : 1);
        } else if (spy != 0) {
            this.setDir(spy > 0 ? 0 : 2);
        }
        if (!this.isRole()) {
            this.showLifeTime = (byte)30;
            this.showHpBarIndex = 30;
        }
        if (this.camp == 3) {
            this.engine.hitCount();
        }
        if (!this.isRole()) {
            damage = Tools.nextInt(damage - 10, damage + 10);
        }
        int value = Math.max(1, damage * ((isCritical = Tools.percent(criticalRate)) ? 2 : 1) - this.getDefend());
        if (!this.isRole() && GCanvas.doubleAtk) {
            value *= 2;
        }
        if (this.isRole()) {
            Engine.reduceHp += value;
            UI.roleInjure = true;
        }
        this.hp = Math.max(0, this.hp - value);
        this.injureTime = time;
        switch (attackMode) {
            case 0: {
                if (this.superArmor[0]) break;
                this.nextStates = (byte)7;
                this.curStates = (byte)7;
                this.index = 0;
                this.frameTimes = 0;
                break;
            }
            case 1: {
                if (this.superArmor[1]) break;
                this.nextStates = (byte)9;
                this.curStates = (byte)9;
                this.index = 0;
                this.frameTimes = 0;
                this.rndY = (short)Tools.nextInt(-2, 2);
                break;
            }
            case 2: {
                if (this.superArmor[2]) break;
                this.injureTime = 0;
                this.setStates(17);
                break;
            }
            case 3: {
                if (this.superArmor[2]) break;
                this.injureTime = 0;
                this.nextStates = (byte)12;
                this.curStates = (byte)12;
                this.index = 0;
                this.frameTimes = 0;
                break;
            }
            case 4: {
                if (this.superArmor[3]) break;
                this.setStates(13);
                this.speedx = s2.x < this.x ? 3 : -3;
                this.speedz = this.curStates == 13 ? 6 : 18;
            }
        }
        this.move();
        if (!this.isBox()) {
            if (this.isRole()) {
                Sprite.addHitNum(value, 1, this.x + this.w / 2, this.y - 30, this.y + 2000);
            } else {
                Sprite.addHitNum(value, isCritical ? 2 : 0, this.x + this.w / 2, this.y - 30, this.y + 2000);
            }
        }
        if (vHitEffect != null && vHitEffect.size() > 0) {
            int i2 = 0;
            while (i2 < vHitEffect.size()) {
                int[] temp = (int[])vHitEffect.elementAt(i2);
                int index1 = temp[0];
                int index2 = temp[1];
                int offsetX = temp[2];
                int offsetY = temp[3];
                int mir = temp[4];
                int dl = temp[5];
                Effect.addEffect(this.x + offsetX, this.y + offsetY, index1, index2, mir, this.y + dl);
                ++i2;
            }
        }
        if (isCritical && this.camp == 3) {
            Engine.critFlashTime = 1;
            Engine.shakeTime = 2;
            Engine.shakeWave = 3;
        }
    }

    void recover() {
        if (!this.isRole()) {
            return;
        }
        this.hpRecover = (byte)80;
        this.mpRecover = (byte)80;
        if (Message.PPData[0] != 0) {
            this.hpRecover = 1;
            this.mpRecover = 1;
        }
        if (GCanvas.gameTime % (this.hpRecover * 12) == 0) {
            this.hp += Math.max(1, this.hp_max / 20);
            this.hp = Math.min(this.hp, this.hp_max);
        }
        if (GCanvas.gameTime % (this.mpRecover * 12) == 0) {
            this.mp = (short)(this.mp + Math.max(1, this.mp_max / 20));
            this.mp = (short)Math.min(this.mp, this.mp_max);
        }
    }

    public void attack() {
        switch (this.curStates) {
            case 0: 
            case 1: {
                this.setStates(2);
                this.index = 0;
                break;
            }
            case 2: 
            case 16: {
                this.pressed = true;
                break;
            }
            case 15: 
            case 21: 
            case 22: {
                this.setStates(16);
                this.index = 0;
            }
        }
    }

    public void breakCombo(int st) {
        if (this.isCombo) {
            if (!this.pressed) {
                if (this.ID != Engine.spriteIndex || !Script.isUserCtrl || !GCanvas.isPressed(53) && !GCanvas.isPressed(-5)) {
                    this.setStates((byte)st);
                    this.index = 0;
                    this.frameTimes = 0;
                }
            } else {
                this.pressed = false;
            }
        }
    }

    public void dealKey() {
        if (this.ID != Engine.spriteIndex || !Script.isUserCtrl) {
            return;
        }
        if (this.curStates == 0 || this.curStates == 1) {
            if (GCanvas.isPressed(-5)) {
                this.ctrl(-5);
            } else if (GCanvas.isPressed(-1)) {
                this.ctrl(-1);
            } else if (GCanvas.isPressed(-3)) {
                this.ctrl(-3);
            } else if (GCanvas.isPressed(-4)) {
                this.ctrl(-4);
            } else if (GCanvas.isPressed(-2)) {
                this.ctrl(-2);
            }
        }
    }

    public static void addHitNum(int num, int type, int x2, int y2, int layer) {
        if (Event.isSkiping) {
            return;
        }
        if (num == 0) {
            return;
        }
        VhitNum.addElement(new int[]{num, type, x2, y2, 0, layer});
    }

    static void drawHitNum() {
        int i2 = 0;
        while (i2 < VhitNum.size()) {
            int[] temp = (int[])VhitNum.elementAt(i2);
            int img = 0;
            int finishIndex = adNum[0].length;
            switch (temp[1]) {
                case 0: {
                    img = 6;
                    temp[0] = Math.min(99999, temp[0]);
                    Tools.addNum(temp[0], 15, img, temp[2] + adNum[0][temp[4]], temp[3] + adNum[1][temp[4]], 10, 0, (byte)5, temp[5]);
                    break;
                }
                case 1: {
                    img = 4;
                    temp[0] = Math.min(99999, temp[0]);
                    Tools.addNum(temp[0], 16, img, temp[2] + adNum[0][temp[4]], temp[3] + adNum[1][temp[4]], 10, -2, (byte)5, temp[5]);
                    break;
                }
                case 2: {
                    img = 7;
                    temp[0] = Math.min(99999, temp[0]);
                    Tools.addNum(temp[0], 15, img, temp[2] + adNum[0][temp[4]], temp[3] + adNum[1][temp[4]], 10, 0, (byte)5, temp[5]);
                }
            }
            temp[4] = temp[4] + 1;
            if (temp[4] >= finishIndex) {
                VhitNum.removeElementAt(i2);
                --i2;
            }
            ++i2;
        }
    }

    public void getFighterVaule() {
        this.getFighterBaseVaule();
        this.getExProp();
        this.equipmentAddition();
        this.passiveSkillAddition();
        this.achievementAddition();
        this.hp = Math.min(this.hp, this.hp_max);
        this.mp = (short)Math.min(this.mp, this.mp_max);
    }

    private void passiveSkillAddition() {
        if (this.passiveSkill == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.passiveSkill[0].length) {
            if (this.passiveSkill[1][i2] != 0) {
                short id = this.passiveSkill[0][i2];
                switch (Engine.ps[id].type) {
                    case 0: {
                        this.atk = (short)(this.atk + Engine.ps[id].getVaule(this.passiveSkill[1][i2]));
                        break;
                    }
                    case 1: {
                        this.def = (short)(this.def + Engine.ps[id].getVaule(this.passiveSkill[1][i2]));
                        break;
                    }
                    case 2: {
                        this.hp_max += Engine.ps[id].getVaule(this.passiveSkill[1][i2]);
                        break;
                    }
                    case 3: {
                        this.critical = (byte)(this.critical + Engine.ps[id].getVaule(this.passiveSkill[1][i2]));
                        break;
                    }
                    case 4: {
                        this.skillDamgePer = (short)(this.skillDamgePer + Engine.ps[id].getVaule(this.passiveSkill[1][i2]));
                        break;
                    }
                    case 5: {
                        this.skillReducePer = (short)(this.skillReducePer - Engine.ps[id].getVaule(this.passiveSkill[1][i2]));
                        break;
                    }
                    case 6: {
                        this.getExpPer = (short)(this.getExpPer + Engine.ps[id].getVaule(this.passiveSkill[1][i2]));
                        break;
                    }
                    case 7: {
                        this.getMoneyPer = (short)(this.getMoneyPer + Engine.ps[id].getVaule(this.passiveSkill[1][i2]));
                    }
                }
            }
            ++i2;
        }
    }

    private void achievementAddition() {
        if (Engine.achIsGet == null || !this.isRole()) {
            return;
        }
        int i2 = 0;
        while (i2 < Engine.achIsGet.length) {
            if (Engine.achIsGet[i2]) {
                this.def = (short)(this.def + Engine.ach[i2].addDef);
                this.atk = (short)(this.atk + Engine.ach[i2].addAtk);
                this.mp_max = (short)(this.mp_max + Engine.ach[i2].addMp);
                this.hp_max += Engine.ach[i2].addHp;
            }
            ++i2;
        }
    }

    private void getFighterBaseVaule() {
        this.hp_max = Data.fighterVauleData[this.type][0];
        this.mp_max = (short)Data.fighterVauleData[this.type][1];
        this.atk = (short)Data.fighterVauleData[this.type][2];
        this.def = (short)Data.fighterVauleData[this.type][3];
        if (this.camp == 3 && Engine.bigGameRank > 2) {
            this.hp_max = this.hp_max * 6 / 5;
            this.atk = (short)(this.atk * 11 / 10);
        }
        this.speed = this.nextSpeed = Data.fighterVauleData[this.type][5] + 1;
        this.isBoss = Data.fighterVauleData[this.type][6] == 1;
        this.critical = 0;
        this.skillDamgePer = (short)100;
        this.skillReducePer = (short)100;
        this.getExpPer = (short)100;
        this.getMoneyPer = (short)100;
        this.hpBuffIndex = this.isBoss ? 120 : 75;
        this.showHpBarIndex = 0;
        this.roleVauleAddtion();
    }

    private void roleVauleAddtion() {
        switch (this.type) {
            case 0: 
            case 1: {
                this.exp_max = Engine.getExpmax(this.level);
                this.hp_max += this.roleFormula_hp();
                this.mp_max = (short)(this.mp_max + this.roleFormula_mp());
                this.atk = (short)(this.atk + this.roleFormula_attack());
                this.def = (short)(this.def + this.roleFormula_defend());
                if (UI.test) {
                    this.atk = (short)9999;
                }
                this.critical = (byte)5;
                this.luck = (byte)5;
                break;
            }
        }
    }

    private int roleFormula_attack() {
        return (this.level - 1) * proAdd[0];
    }

    private int roleFormula_defend() {
        return (this.level - 1) * proAdd[1];
    }

    private int roleFormula_hp() {
        return (this.level - 1) * proAdd[2];
    }

    private int roleFormula_mp() {
        return (this.level - 1) * proAdd[3];
    }

    public void addFighterVaule(int pos) {
        if (this.itemData == null) {
            return;
        }
        Equipment e2 = Engine.getEquObj(this.itemData[pos]);
        short[] temp = this.itemData[pos];
        this.atk = (short)(this.atk + e2.getAttack(temp[3], temp[4]));
        this.def = (short)(this.def + e2.getDefense(temp[3], temp[4]));
        this.critical = (byte)(this.critical + e2.getCritical(temp[3], temp[4]));
        this.luck = (byte)(this.luck + e2.getLuck(temp[3], temp[4]));
        this.hp_max += e2.getHp(temp[3]);
        this.mp_max = (short)(this.mp_max + e2.getMp(temp[3]));
    }

    private void getExProp() {
        this.hp_max += this.exHp;
        this.mp_max = (short)(this.mp_max + this.exMp);
        this.critical = (byte)(this.critical + this.exCri);
        this.atk = (short)(this.atk + this.exAtk);
        this.def = (short)(this.def + this.exDef);
    }

    public void ReduceFighterVaule(int pos) {
        if (this.itemData[pos] != null) {
            Equipment e2 = Engine.getEquObj(this.itemData[pos]);
            short[] temp = this.itemData[pos];
            this.atk = (short)(this.atk - e2.getAttack(temp[3], temp[4]));
            this.def = (short)(this.def - e2.getDefense(temp[3], temp[4]));
            this.critical = (byte)(this.critical - e2.getCritical(temp[3], temp[4]));
            this.luck = (byte)(this.luck - e2.getLuck(temp[3], temp[4]));
            this.hp_max -= e2.getHp(temp[3]);
            this.mp_max = (short)(this.mp_max - e2.getMp(temp[3]));
        }
    }

    private void equipmentAddition() {
        if (this.itemData == null) {
            return;
        }
        int i2 = 0;
        while (i2 < 4) {
            if (this.itemData[i2] != null) {
                Equipment e2 = Engine.getEquObj(this.itemData[i2]);
                short[] temp = this.itemData[i2];
                this.atk = (short)(this.atk + e2.getAttack(temp[3], temp[4]));
                this.def = (short)(this.def + e2.getDefense(temp[3], temp[4]));
                this.critical = (byte)(this.critical + e2.getCritical(temp[3], temp[4]));
                this.luck = (byte)(this.luck + e2.getLuck(temp[3], temp[4]));
                this.hp_max += e2.getHp(temp[3]);
                this.mp_max = (short)(this.mp_max + e2.getMp(temp[3]));
            }
            ++i2;
        }
    }

    int getAttack() {
        switch (this.skillType) {
            case -1: {
                return this.atk * (Engine.hitAddTempAtk + 100) / 100;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return (this.atk * (Engine.is[this.skillType].getVaule(this.initiativeSkill[1][this.skillType]) + this.skillDamgePer) / 100 + Engine.is[this.skillType].getAtkValue(this.initiativeSkill[1][this.skillType])) * (Engine.hitAddTempAtk + 100) / 100;
            }
        }
        return this.atk;
    }

    int getDefend() {
        return this.def;
    }

    int getCritical() {
        return this.critical;
    }

    void drawRoleShandow(int lev) {
        Tools.addImage(16, 7, this.x - 25, this.y + 9, (byte)2, (byte)0, lev);
    }

    void drawBossShandow(int lev) {
        if (!this.isBoss) {
            return;
        }
        Effect.drawEffectFrame(29, 0, this.x, this.y, 0, lev);
        if (this.modle != 8 && this.modle != 9 && this.modle != 25) {
            Effect.drawEffectFrame(28, 0, this.x, this.y - 15, 0, 2000);
            Effect.drawEffectFrame(28, 1, this.x, this.y - 15, 0, lev);
        }
    }

    void runHpBar() {
        int hpLineMax = this.isBoss ? 120 : 75;
        int curHpLine = this.hp * hpLineMax / this.hp_max;
        if (this.hpBuffIndex > curHpLine) {
            --this.hpBuffIndex;
        } else {
            this.reduceHp = false;
        }
        if (this.showHpBarIndex > 0) {
            --this.showHpBarIndex;
        }
    }

    void drawHpBar(int dx, int dy, int lev) {
        int hpLineMax = this.isBoss ? 120 : 75;
        int curHpLine = this.hp * hpLineMax / this.hp_max;
        int temp = 0;
        if (this.isBoss) {
            Tools.addImage(15, 1, dx - 3, dy + 14, 0, 0, 118, 16, (byte)6, (byte)0, lev);
            Tools.addImage(15, 1, dx, dy + 16, 0, 44, this.hpBuffIndex, 12, (byte)6, (byte)1, lev);
            Tools.addImage(15, 1, dx, dy + 16, 0, 32, curHpLine, 12, (byte)6, (byte)1, lev);
        } else {
            Tools.addImage(15, 1, dx - 1, dy + 14, 0, 16, 75, 16, (byte)6, (byte)0, lev);
            Tools.addImage(15, 1, dx, dy + 16, 0, 44, this.hpBuffIndex, 12, (byte)6, (byte)1, lev);
            Tools.addImage(15, 1, dx, dy + 16, 0, 32, curHpLine, 12, (byte)6, (byte)1, lev);
        }
        if (this.showHpBarIndex > 0) {
            if (!this.isBoss) {
                if (!this.reduceHp || GCanvas.gameStatus != 7) {
                    Tools.addImage(15, 1, dx, dy, 147, 0, 40, 40, (byte)0, (byte)0, lev);
                    Tools.addImage(15, 1, dx - 7, dy, 120, 0, 7, 40, (byte)0, (byte)0, lev);
                    if (this.modle < 10) {
                        Tools.addImage(15, 3, dx + 7, dy + 7, this.modle * 30, 0, 30, 30, (byte)0, (byte)0, lev);
                    }
                    this.reduceHp = true;
                } else if (this.reduceHp && GCanvas.gameStatus == 7) {
                    temp = Tools.nextInt(-1, 1);
                    Tools.addImage(15, 1, dx + temp, dy + temp, 186, 0, 40, 40, (byte)0, (byte)0, lev);
                    Tools.addImage(15, 1, dx - 7 + temp, dy + temp, 120, 0, 7, 40, (byte)0, (byte)0, lev);
                    if (this.modle < 10) {
                        Tools.addImage(15, 3, dx + 7 + temp, dy + 7 + temp, this.modle * 30, 0, 30, 30, (byte)0, (byte)0, lev);
                    }
                }
            } else if (!this.reduceHp || GCanvas.gameStatus != 7) {
                Tools.addImage(15, 1, dx - 20, dy, 127, 0, 60, 40, (byte)0, (byte)0, lev);
                if (this.modle < 10) {
                    Tools.addImage(15, 3, dx + 7, dy + 7, this.modle * 30, 0, 30, 30, (byte)0, (byte)0, lev);
                }
                this.reduceHp = true;
            } else if (this.reduceHp && GCanvas.gameStatus == 7) {
                temp = Tools.nextInt(-1, 1);
                Tools.addImage(15, 1, dx - 20, dy + temp, 127, 0, 20, 40, (byte)0, (byte)0, lev);
                Tools.addImage(15, 1, dx, dy + temp, 186, 0, 40, 40, (byte)0, (byte)0, lev);
                if (this.modle < 10) {
                    Tools.addImage(15, 3, dx + 7, dy + 7 + temp, this.modle * 30, 0, 30, 30, (byte)0, (byte)0, lev);
                }
            }
            if (this.hp <= 0 && this.showHpBarIndex % 2 == 1) {
                Tools.addImage(15, 2, dx, dy, (byte)0, (byte)0, lev);
            }
        }
    }

    public void compareProp(int pos, short[] tmp) {
        Equipment e1 = Engine.getEquObj(tmp);
        if (this.itemData[pos] != null) {
            Equipment e2 = Engine.getEquObj(this.itemData[pos]);
            short[] temp = this.itemData[pos];
            tempAtk = this.atk - e2.getAttack(temp[3], temp[4]) + e1.getAttack(tmp[3], tmp[4]);
            tempDef = this.def - e2.getDefense(temp[3], temp[4]) + e1.getDefense(tmp[3], tmp[4]);
            tempCri = this.critical - e2.getCritical(temp[3], temp[4]) + e1.getCritical(tmp[3], tmp[4]);
            tempLuck = this.luck - e2.getLuck(temp[3], temp[4]) + e1.getLuck(tmp[3], tmp[4]);
            tempHp_max = this.hp_max - e2.getHp(temp[3]) + e1.getHp(tmp[3]);
            tempMp_max = this.mp_max - e2.getMp(temp[3]) + e1.getMp(tmp[3]);
        } else {
            tempAtk = this.atk + e1.getAttack(tmp[3], tmp[4]);
            tempDef = this.def + e1.getDefense(tmp[3], tmp[4]);
            tempCri = this.critical + e1.getCritical(tmp[3], tmp[4]);
            tempLuck = this.luck + e1.getLuck(tmp[3], tmp[4]);
            tempHp_max = this.hp_max + e1.getHp(tmp[3]);
            tempMp_max = this.mp_max + e1.getMp(tmp[3]);
        }
    }

    boolean isBox() {
        return this.modle == 13 || this.modle == 14 || this.isArrow();
    }

    boolean isArrow() {
        return this.modle == 15 || this.modle == 16 || this.modle == 17 || this.modle == 18;
    }

    boolean isRole() {
        return this.ID == 0;
    }

    boolean isProtect() {
        return this.curStates == 9 || this.curStates == 10 || this.curStates == 12 || this.curStates == 13;
    }

    boolean isInvincible(int atkMode) {
        if (this.curStates == 8 || this.curStates == 18 || this.curStates == 24 || this.curStates == 10 && atkMode != 1) {
            return true;
        }
        if (this.modle == 12 && this.curStates == 6) {
            return true;
        }
        return this.isRole() && (this.curStates == 3 || this.curStates == 4 || this.curStates == 5 || this.curStates == 6 || this.curStates == 20 || this.curStates == 23);
    }

    byte checkCanUseSkill(int skillIndex) {
        if (this.initiativeSkill[1][skillIndex] == 0) {
            return -3;
        }
        if (this.initiativeSkill[2][skillIndex] != 0) {
            return -1;
        }
        if (this.mp < Engine.is[skillIndex].getMpValue(this.initiativeSkill[1][skillIndex]) * this.skillReducePer / 100) {
            if (Engine.defaultItem[1][1] > 0) {
                Engine.defaultUseItem(Engine.creatItem(0, Engine.defaultItem[1][0], 1), Engine.sprite[0]);
                if (Engine.sprite[0].mp >= Engine.is[skillIndex].getMpValue(this.initiativeSkill[1][skillIndex]) * this.skillReducePer / 100) {
                    return 0;
                }
            }
            return -2;
        }
        return 0;
    }

    void runSkillCD() {
        if (this.initiativeSkill == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.initiativeSkill[0].length) {
            if (this.initiativeSkill[2][i2] > 0) {
                short[] sArray = this.initiativeSkill[2];
                int n2 = i2;
                sArray[n2] = (short)(sArray[n2] - 1);
            }
            ++i2;
        }
    }

    void numAfterSkillUse(int st) {
        if (this.curStates != 0) {
            return;
        }
        byte re = this.checkCanUseSkill(st);
        switch (re) {
            case 0: {
                this.initiativeSkill[2][st] = Engine.is[st].cdTime;
                if (Message.PPData[0] == 0) {
                    this.mp = (short)(this.mp - Engine.is[st].getMpValue(this.initiativeSkill[1][st]) * this.skillReducePer / 100);
                }
                this.skillType = (byte)st;
                this.setStates(3);
                break;
            }
            case -1: {
                GetItem.addIFData(0, 1, 0, 0, 0, 1, 3);
                break;
            }
            case -2: {
                GetItem.addIFData(0, 1, 0, 0, 0, 1, 2);
                return;
            }
        }
    }

    void skill1ReduceMp() {
        if (this.initiativeSkill == null) {
            return;
        }
        if (this.mp < Engine.is[1].getMpValue(this.initiativeSkill[1][1]) * this.skillReducePer / 100) {
            this.setStates(5);
            return;
        }
        if (Message.PPData[0] == 0) {
            this.mp = (short)(this.mp - Engine.is[1].getMpValue(this.initiativeSkill[1][1]) * this.skillReducePer / 100);
        }
    }

    static void dropItem(Sprite s2) {
        int second;
        if (Tools.percent(30)) {
            int num = Tools.nextInt(Engine.rmm[Engine.map.mfLevel].goldDrop[0], Engine.rmm[Engine.map.mfLevel].goldDrop[1]);
            GetItem.addMFData(s2.x, s2.y, 6, num);
        }
        if (Tools.percent(10) && Engine.bigGameRank != 0) {
            second = GCanvas.gameTime % Engine.rmm[Engine.map.mfLevel].conDrop.length;
            GetItem.addMFData(s2.x, s2.y, 0, Engine.rmm[Engine.map.mfLevel].conDrop[second]);
        }
        if (Tools.percent(5) && Engine.bigGameRank != 0) {
            second = GCanvas.gameTime % Engine.rmm[Engine.map.mfLevel].equipDrop.length;
            GetItem.addMFData(s2.x, s2.y, 1, Engine.rmm[Engine.map.mfLevel].equipDrop[second]);
        }
        if (Tools.percent(20) && Engine.bigGameRank != 0) {
            GetItem.addMFData(s2.x, s2.y, 2, Tools.nextInt(0, 9));
        }
    }

    void killScore() {
        if (!this.isRole() && !this.isBox()) {
            Engine.killEnemyCount = (short)(Engine.killEnemyCount + 1);
        }
    }

    static {
        sayFlag = false;
        faceMotion = new byte[]{0, 1, 2, 2, 2, 2, 2, 2, 2};
        faceOffY = new byte[]{0, 1, 0, 1, 0, 0, 0, 0, 0};
        speeds = new byte[]{16, 8, 4, 2, 1};
        Freq = new byte[]{5, 4, 3, 2, 1};
        VhitNum = new Vector();
        adNum = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, -12, -18, -26, -30, -32, -35, -35, -35}};
        proAdd = new int[]{3, 2, 20, 2};
    }
}

