/*
 * Decompiled with CFR 0.152.
 */
public class Paddle {
    public static final int PADDLE_LOW = -1;
    public static final int PADDLE_CENTER = 0;
    public static final int PADDLE_HIGH = 1;
    public static final int PADDLEMODE_ANALOG = 0;
    public static final int PADDLEMODE_DIGITAL = 1;
    private EmAppleII apple;
    private int[] buttonRegister = new int[4];
    private int paddleMode;
    private int[] paddleClockInc = new int[4];
    private int[] paddleClock = new int[4];
    private static final int PADDLE_CONSTANT = 10000;
    private int[] paddleState = new int[4];
    private long[] paddleTime = new long[4];
    private int[] paddleValue = new int[4];
    private int[] paddleVel = new int[4];

    public Paddle(EmAppleII emAppleII) {
        this.apple = emAppleII;
        this.setPaddleMode(0);
    }

    private void initPaddle(int n) {
        this.setPaddleDigital(n, 0);
    }

    public void setPaddleMode(int n) {
        this.paddleMode = n;
        this.initPaddle(0);
        this.initPaddle(1);
        this.initPaddle(2);
        this.initPaddle(3);
    }

    public int getPaddleMode() {
        return this.paddleMode;
    }

    public void setButton(int n, boolean bl) {
        this.buttonRegister[n] = bl ? 128 : 0;
    }

    public int getButtonRegister(int n) {
        return this.buttonRegister[n];
    }

    public void setPaddle(int n, int n2) {
        switch (this.paddleMode) {
            case 0: {
                this.setPaddleAnalog(n, n2);
                break;
            }
            case 1: {
                this.setPaddleDigital(n, n2);
            }
        }
    }

    private final void setPaddleDigital(int n, int n2) {
        switch (n2) {
            case -1: {
                this.paddleValue[n] = 0;
                break;
            }
            case 0: {
                this.paddleValue[n] = 128;
                break;
            }
            case 1: {
                this.paddleValue[n] = 255;
            }
        }
        this.setPaddleValue(n, this.paddleValue[n]);
        this.paddleState[n] = n2;
        this.paddleVel[n] = 0;
    }

    private final void setPaddleAnalog(int n, int n2) {
        this.updatePaddleAnalog(n, System.currentTimeMillis());
        this.paddleState[n] = n2;
        this.paddleVel[n] = 0;
    }

    private void updatePaddleAnalog(int n, long l) {
        long l2 = l - this.paddleTime[n];
        this.paddleTime[n] = l;
        if (l2 > 10000L) {
            l2 = 10000L;
        }
        switch (this.paddleState[n]) {
            case -1: {
                int n2 = n;
                this.paddleVel[n2] = (int)((long)this.paddleVel[n2] - l2 * 256L / 10000L);
                int n3 = n;
                this.paddleValue[n3] = this.paddleValue[n3] + this.paddleVel[n];
                if (this.paddleValue[n] < 0) {
                    this.paddleValue[n] = 0;
                }
                this.setPaddleValue(n, this.paddleValue[n]);
                break;
            }
            case 1: {
                int n4 = n;
                this.paddleVel[n4] = (int)((long)this.paddleVel[n4] + l2 * 256L / 10000L);
                int n5 = n;
                this.paddleValue[n5] = this.paddleValue[n5] + this.paddleVel[n];
                if (this.paddleValue[n] > 255) {
                    this.paddleValue[n] = 255;
                }
                this.setPaddleValue(n, this.paddleValue[n]);
            }
        }
    }

    private final void setPaddleValue(int n, int n2) {
        this.paddleClockInc[n] = n2 * 11 + 8;
    }

    public void triggerRegister() {
        if (this.paddleMode == 0) {
            long l = System.currentTimeMillis();
            this.updatePaddleAnalog(0, l);
            this.updatePaddleAnalog(1, l);
            this.updatePaddleAnalog(2, l);
            this.updatePaddleAnalog(3, l);
        }
        this.paddleClock[0] = this.apple.clock + this.paddleClockInc[0];
        this.paddleClock[1] = this.apple.clock + this.paddleClockInc[1];
        this.paddleClock[2] = this.apple.clock + this.paddleClockInc[2];
        this.paddleClock[3] = this.apple.clock + this.paddleClockInc[3];
    }

    public int getPaddleRegister(int n) {
        return this.apple.clock < this.paddleClock[n] ? 128 : 0;
    }
}

