/*
 * Decompiled with CFR 0.152.
 */
package athan.src.microfloat;

public final class Real {
    public long mantissa;
    public int exponent;
    public byte sign;
    public static boolean magicRounding = true;
    public static final Real ZERO = new Real(0, 0, 0L);
    public static final Real ONE = new Real(0, 0x40000000, 0x4000000000000000L);
    public static final Real TWO = new Real(0, 0x40000001, 0x4000000000000000L);
    public static final Real THREE = new Real(0, 0x40000001, 0x6000000000000000L);
    public static final Real FIVE = new Real(0, 0x40000002, 0x5000000000000000L);
    public static final Real TEN = new Real(0, 0x40000003, 0x5000000000000000L);
    public static final Real HUNDRED = new Real(0, 0x40000006, 0x6400000000000000L);
    public static final Real HALF = new Real(0, 0x3FFFFFFF, 0x4000000000000000L);
    public static final Real THIRD = new Real(0, 0x3FFFFFFE, 0x5555555555555555L);
    public static final Real TENTH = new Real(0, 0x3FFFFFFC, 0x6666666666666666L);
    public static final Real PERCENT = new Real(0, 0x3FFFFFF9, 5902958103587056517L);
    public static final Real SQRT2 = new Real(0, 0x40000000, 6521908912666391106L);
    public static final Real SQRT1_2 = new Real(0, 0x3FFFFFFF, 6521908912666391106L);
    public static final Real PI2 = new Real(0, 0x40000002, 7244019458077122842L);
    public static final Real PI = new Real(0, 0x40000001, 7244019458077122842L);
    public static final Real PI_2 = new Real(0, 0x40000000, 7244019458077122842L);
    public static final Real PI_4 = new Real(0, 0x3FFFFFFF, 7244019458077122842L);
    public static final Real PI_8 = new Real(0, 0x3FFFFFFE, 7244019458077122842L);
    public static final Real E = new Real(0, 0x40000001, 6267931151224907085L);
    public static final Real LN2 = new Real(0, 0x3FFFFFFF, 6393154322601327830L);
    public static final Real LN10 = new Real(0, 0x40000001, 5309399739799983627L);
    public static final Real LOG2E = new Real(0, 0x40000000, 6653256548922161246L);
    public static final Real LOG10E = new Real(0, 0x3FFFFFFE, 8011319160293570763L);
    public static final Real MAX = new Real(0, Integer.MAX_VALUE, Long.MAX_VALUE);
    public static final Real MIN = new Real(0, 0, 0x4000000000000000L);
    public static final Real NAN = new Real(0, Integer.MIN_VALUE, 0x4000000000000000L);
    public static final Real INF = new Real(0, Integer.MIN_VALUE, 0L);
    public static final Real INF_N = new Real(1, Integer.MIN_VALUE, 0L);
    public static final Real ZERO_N = new Real(1, 0, 0L);
    public static final Real ONE_N = new Real(1, 0x40000000, 0x4000000000000000L);
    private static final int clz_magic = 130329821;
    private static final byte[] clz_tab = new byte[]{31, 22, 30, 21, 18, 10, 29, 2, 20, 17, 15, 13, 9, 6, 28, 1, 23, 19, 11, 3, 16, 14, 7, 24, 12, 4, 8, 25, 5, 26, 27, 0};
    private static Real tmp0 = new Real();
    private static Real recipTmp = new Real();
    private static Real recipTmp2 = new Real();
    private static Real sqrtTmp = new Real();
    private static Real expTmp = new Real();
    private static Real expTmp2 = new Real();
    private static Real expTmp3 = new Real();
    private static Real tmp1 = new Real();
    private static Real tmp2 = new Real();
    private static Real tmp3 = new Real();
    private static Real tmp4 = new Real();
    private static Real tmp5 = new Real();
    public static long randSeedA = 7244019458077122842L;
    public static long randSeedB = 6267931151224907085L;
    private static byte[] ftoaDigits = new byte[65];
    private static StringBuffer ftoaBuf = new StringBuffer(40);
    private static StringBuffer ftoaExp = new StringBuffer(15);
    public static final String hexChar = "0123456789ABCDEF";
    private static NumberFormat tmpFormat = new NumberFormat();

    public Real() {
    }

    public Real(Real a) {
        this.mantissa = a.mantissa;
        this.exponent = a.exponent;
        this.sign = a.sign;
    }

    public Real(int a) {
        this.assign(a);
    }

    public Real(long a) {
        this.assign(a);
    }

    public Real(String a) {
        this.assign(a, 10);
    }

    public Real(String a, int base) {
        this.assign(a, base);
    }

    public Real(int s, int e, long m) {
        this.sign = (byte)s;
        this.exponent = e;
        this.mantissa = m;
    }

    public Real(byte[] data, int offset) {
        this.assign(data, offset);
    }

    public void assign(Real a) {
        if (a == null) {
            this.makeZero();
            return;
        }
        this.sign = a.sign;
        this.exponent = a.exponent;
        this.mantissa = a.mantissa;
    }

    public void assign(int a) {
        if (a == 0) {
            this.makeZero();
            return;
        }
        this.sign = 0;
        if (a < 0) {
            this.sign = 1;
            a = -a;
        }
        int t = a;
        t |= t >> 1;
        t |= t >> 2;
        t |= t >> 4;
        t |= t >> 8;
        t |= t >> 16;
        t = clz_tab[t * 130329821 >>> 27] - 1;
        this.exponent = 1073741854 - t;
        this.mantissa = (long)a << 32 + t;
    }

    public void assign(long a) {
        this.sign = 0;
        if (a < 0L) {
            this.sign = 1;
            a = -a;
        }
        this.exponent = 1073741886;
        this.mantissa = a;
        this.normalize();
    }

    public void assign(String a) {
        this.assign(a, 10);
    }

    public void assign(String a, int base) {
        if (a == null || a.length() == 0) {
            this.assign(ZERO);
            return;
        }
        this.atof(a, base);
    }

    public void assign(int s, int e, long m) {
        this.sign = (byte)s;
        this.exponent = e;
        this.mantissa = m;
    }

    public void assign(byte[] data, int offset) {
        this.sign = (byte)(data[offset + 4] >> 7 & 1);
        this.exponent = ((data[offset] & 0xFF) << 24) + ((data[offset + 1] & 0xFF) << 16) + ((data[offset + 2] & 0xFF) << 8) + (data[offset + 3] & 0xFF);
        this.mantissa = ((long)(data[offset + 4] & 0x7F) << 56) + ((long)(data[offset + 5] & 0xFF) << 48) + ((long)(data[offset + 6] & 0xFF) << 40) + ((long)(data[offset + 7] & 0xFF) << 32) + ((long)(data[offset + 8] & 0xFF) << 24) + ((long)(data[offset + 9] & 0xFF) << 16) + ((long)(data[offset + 10] & 0xFF) << 8) + (long)(data[offset + 11] & 0xFF);
    }

    public void toBytes(byte[] data, int offset) {
        data[offset] = (byte)(this.exponent >> 24);
        data[offset + 1] = (byte)(this.exponent >> 16);
        data[offset + 2] = (byte)(this.exponent >> 8);
        data[offset + 3] = (byte)this.exponent;
        data[offset + 4] = (byte)((long)(this.sign << 7) + (this.mantissa >> 56));
        data[offset + 5] = (byte)(this.mantissa >> 48);
        data[offset + 6] = (byte)(this.mantissa >> 40);
        data[offset + 7] = (byte)(this.mantissa >> 32);
        data[offset + 8] = (byte)(this.mantissa >> 24);
        data[offset + 9] = (byte)(this.mantissa >> 16);
        data[offset + 10] = (byte)(this.mantissa >> 8);
        data[offset + 11] = (byte)this.mantissa;
    }

    public void assignFloatBits(int bits) {
        this.sign = (byte)(bits >>> 31);
        this.exponent = bits >> 23 & 0xFF;
        this.mantissa = (long)(bits & 0x7FFFFF) << 39;
        if (this.exponent == 0 && this.mantissa == 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa != 0L) {
            this.exponent = 1073741698;
            this.normalize();
            return;
        }
        if (this.exponent <= 254) {
            this.exponent += 1073741697;
            this.mantissa |= 0x4000000000000000L;
            return;
        }
        if (this.mantissa == 0L) {
            this.makeInfinity(this.sign);
        } else {
            this.makeNan();
        }
    }

    public void assignDoubleBits(long bits) {
        this.sign = (byte)(bits >> 63 & 1L);
        this.exponent = (int)(bits >> 52 & 0x7FFL);
        this.mantissa = (bits & 0xFFFFFFFFFFFFFL) << 10;
        if (this.exponent == 0 && this.mantissa == 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa != 0L) {
            this.exponent = 1073740802;
            this.normalize();
            return;
        }
        if (this.exponent <= 2046) {
            this.exponent += 1073740801;
            this.mantissa |= 0x4000000000000000L;
            return;
        }
        if (this.mantissa == 0L) {
            this.makeInfinity(this.sign);
        } else {
            this.makeNan();
        }
    }

    public int toFloatBits() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return Integer.MAX_VALUE;
        }
        int e = this.exponent - 0x40000000 + 127;
        long m = this.mantissa;
        if ((m += 0x4000000000L) < 0L) {
            m >>>= 1;
            ++e;
            if (this.exponent < 0) {
                return this.sign << 31 | 0x7F800000;
            }
        }
        if (this.exponent < 0 && this.mantissa == 0L || e > 254) {
            return this.sign << 31 | 0x7F800000;
        }
        if (this.exponent == 0 && this.mantissa == 0L || e < -22) {
            return this.sign << 31;
        }
        if (e <= 0) {
            return this.sign << 31 | (int)(m >>> 40 - e) & 0x7FFFFF;
        }
        return this.sign << 31 | e << 23 | (int)(m >>> 39) & 0x7FFFFF;
    }

    public long toDoubleBits() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return Long.MAX_VALUE;
        }
        int e = this.exponent - 0x40000000 + 1023;
        long m = this.mantissa;
        if ((m += 512L) < 0L) {
            m >>>= 1;
            ++e;
            if (this.exponent < 0) {
                return (long)this.sign << 63 | 0x7FF0000000000000L;
            }
        }
        if (this.exponent < 0 && this.mantissa == 0L || e > 2046) {
            return (long)this.sign << 63 | 0x7FF0000000000000L;
        }
        if (this.exponent == 0 && this.mantissa == 0L || e < -51) {
            return (long)this.sign << 63;
        }
        if (e <= 0) {
            return (long)this.sign << 63 | m >>> 11 - e & 0xFFFFFFFFFFFFFL;
        }
        return (long)this.sign << 63 | (long)e << 52 | m >>> 10 & 0xFFFFFFFFFFFFFL;
    }

    public void makeZero() {
        this.sign = 0;
        this.mantissa = 0L;
        this.exponent = 0;
    }

    public void makeZero(int s) {
        this.sign = (byte)s;
        this.mantissa = 0L;
        this.exponent = 0;
    }

    public void makeInfinity(int s) {
        this.sign = (byte)s;
        this.mantissa = 0L;
        this.exponent = Integer.MIN_VALUE;
    }

    public void makeNan() {
        this.sign = 0;
        this.mantissa = 0x4000000000000000L;
        this.exponent = Integer.MIN_VALUE;
    }

    public boolean isZero() {
        return this.exponent == 0 && this.mantissa == 0L;
    }

    public boolean isInfinity() {
        return this.exponent < 0 && this.mantissa == 0L;
    }

    public boolean isNan() {
        return this.exponent < 0 && this.mantissa != 0L;
    }

    public boolean isFinite() {
        return this.exponent >= 0;
    }

    public boolean isFiniteNonZero() {
        return this.exponent >= 0 && this.mantissa != 0L;
    }

    public boolean isNegative() {
        return this.sign != 0;
    }

    public void abs() {
        this.sign = 0;
    }

    public void neg() {
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = (byte)(this.sign ^ 1);
        }
    }

    public void copysign(Real a) {
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = a.sign;
    }

    public void normalize() {
        if (this.exponent >= 0) {
            if (this.mantissa > 0L) {
                int clz = 0;
                int t = (int)(this.mantissa >>> 32);
                if (t == 0) {
                    clz = 32;
                    t = (int)this.mantissa;
                }
                t |= t >> 1;
                t |= t >> 2;
                t |= t >> 4;
                t |= t >> 8;
                t |= t >> 16;
                this.mantissa <<= (clz += clz_tab[t * 130329821 >>> 27] - 1);
                this.exponent -= clz;
                if (this.exponent < 0) {
                    this.makeZero(this.sign);
                }
            } else if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
                if (this.mantissa == 0L) {
                    this.mantissa = 0x4000000000000000L;
                    ++this.exponent;
                }
                if (this.exponent < 0) {
                    this.makeInfinity(this.sign);
                }
            } else {
                this.exponent = 0;
            }
        }
    }

    public long normalize128(long extra) {
        if (this.exponent < 0) {
            return 0L;
        }
        if (this.mantissa == 0L) {
            if (extra == 0L) {
                this.exponent = 0;
                return 0L;
            }
            this.mantissa = extra;
            extra = 0L;
            this.exponent -= 64;
            if (this.exponent < 0) {
                this.makeZero(this.sign);
                return 0L;
            }
        }
        if (this.mantissa < 0L) {
            extra = (this.mantissa << 63) + (extra >>> 1);
            this.mantissa >>>= 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
                return 0L;
            }
            return extra;
        }
        int clz = 0;
        int t = (int)(this.mantissa >>> 32);
        if (t == 0) {
            clz = 32;
            t = (int)this.mantissa;
        }
        t |= t >> 1;
        t |= t >> 2;
        t |= t >> 4;
        t |= t >> 8;
        if ((clz += clz_tab[(t |= t >> 16) * 130329821 >>> 27] - 1) == 0) {
            return extra;
        }
        this.mantissa = (this.mantissa << clz) + (extra >>> 64 - clz);
        extra <<= clz;
        this.exponent -= clz;
        if (this.exponent < 0) {
            this.makeZero(this.sign);
            return 0L;
        }
        return extra;
    }

    public void roundFrom128(long extra) {
        this.mantissa += extra >> 63 & 1L;
        this.normalize();
    }

    public boolean equals(Object a) {
        return this == a;
    }

    private int compare(Real a) {
        int s;
        if (this.exponent == 0 && this.mantissa == 0L && a.exponent == 0 && a.mantissa == 0L) {
            return 0;
        }
        if (this.sign != a.sign) {
            return a.sign - this.sign;
        }
        int n = s = this.sign == 0 ? 1 : -1;
        if (this.exponent < 0 && this.mantissa == 0L) {
            return s;
        }
        if (a.exponent < 0 && a.mantissa == 0L) {
            return -s;
        }
        if (this.exponent != a.exponent) {
            return this.exponent < a.exponent ? -s : s;
        }
        if (this.mantissa != a.mantissa) {
            return this.mantissa < a.mantissa ? -s : s;
        }
        return 0;
    }

    private boolean invalidCompare(Real a) {
        return this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L && a.exponent < 0 && a.mantissa == 0L && this.sign == a.sign;
    }

    public boolean equalTo(Real a) {
        if (this.invalidCompare(a)) {
            return false;
        }
        return this.compare(a) == 0;
    }

    public boolean equalTo(int a) {
        tmp0.assign(a);
        return this.equalTo(tmp0);
    }

    public boolean notEqualTo(Real a) {
        if (this.invalidCompare(a)) {
            return false;
        }
        return this.compare(a) != 0;
    }

    public boolean notEqualTo(int a) {
        tmp0.assign(a);
        return this.notEqualTo(tmp0);
    }

    public boolean lessThan(Real a) {
        if (this.invalidCompare(a)) {
            return false;
        }
        return this.compare(a) < 0;
    }

    public boolean lessThan(int a) {
        tmp0.assign(a);
        return this.lessThan(tmp0);
    }

    public boolean lessEqual(Real a) {
        if (this.invalidCompare(a)) {
            return false;
        }
        return this.compare(a) <= 0;
    }

    public boolean lessEqual(int a) {
        tmp0.assign(a);
        return this.lessEqual(tmp0);
    }

    public boolean greaterThan(Real a) {
        if (this.invalidCompare(a)) {
            return false;
        }
        return this.compare(a) > 0;
    }

    public boolean greaterThan(int a) {
        tmp0.assign(a);
        return this.greaterThan(tmp0);
    }

    public boolean greaterEqual(Real a) {
        if (this.invalidCompare(a)) {
            return false;
        }
        return this.compare(a) >= 0;
    }

    public boolean greaterEqual(int a) {
        tmp0.assign(a);
        return this.greaterEqual(tmp0);
    }

    public boolean absLessThan(Real a) {
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L) {
            return false;
        }
        if (a.exponent < 0 && a.mantissa == 0L) {
            return true;
        }
        if (this.exponent != a.exponent) {
            return this.exponent < a.exponent;
        }
        return this.mantissa < a.mantissa;
    }

    public void scalbn(int n) {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        this.exponent += n;
        if (this.exponent < 0) {
            if (n < 0) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
        }
    }

    public void nextafter(Real a) {
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L && a.exponent < 0 && a.mantissa == 0L && this.sign == a.sign) {
            return;
        }
        int dir = -this.compare(a);
        if (dir == 0) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.MIN.mantissa;
            this.exponent = Real.MIN.exponent;
            this.sign = Real.MIN.sign;
            this.sign = (byte)(dir < 0 ? 1 : 0);
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.mantissa = Real.MAX.mantissa;
            this.exponent = Real.MAX.exponent;
            this.sign = Real.MAX.sign;
            this.sign = (byte)(dir >= 0 ? 1 : 0);
            return;
        }
        if (this.sign == 0 ^ dir < 0) {
            ++this.mantissa;
        } else {
            if (this.mantissa == 0x4000000000000000L) {
                this.mantissa <<= 1;
                --this.exponent;
            }
            --this.mantissa;
        }
        this.normalize();
    }

    public void floor() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x40000000) {
            if (this.sign == 0) {
                this.makeZero(this.sign);
            } else {
                this.exponent = Real.ONE.exponent;
                this.mantissa = Real.ONE.mantissa;
            }
            return;
        }
        int shift = 1073741886 - this.exponent;
        if (shift <= 0) {
            return;
        }
        if (this.sign != 0) {
            this.mantissa += (1L << shift) - 1L;
        }
        this.mantissa &= (1L << shift) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        if (this.sign != 0) {
            this.normalize();
        }
    }

    public void ceil() {
        this.neg();
        this.floor();
        this.neg();
    }

    public void round() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x3FFFFFFF) {
            this.makeZero(this.sign);
            return;
        }
        int shift = 1073741886 - this.exponent;
        if (shift <= 0) {
            return;
        }
        this.mantissa += 1L << shift - 1;
        this.mantissa &= (1L << shift) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.normalize();
    }

    public void trunc() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0x40000000) {
            this.makeZero(this.sign);
            return;
        }
        int shift = 1073741886 - this.exponent;
        if (shift <= 0) {
            return;
        }
        this.mantissa &= (1L << shift) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.normalize();
    }

    public void frac() {
        if (this.exponent < 0 || this.mantissa == 0L || this.exponent < 0x40000000) {
            return;
        }
        int shift = 1073741886 - this.exponent;
        if (shift <= 0) {
            this.makeZero(this.sign);
            return;
        }
        this.mantissa &= (1L << shift) - 1L;
        this.normalize();
    }

    public int toInteger() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return 0;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return this.sign == 0 ? Integer.MAX_VALUE : -2147483647;
        }
        if (this.exponent < 0x40000000) {
            return 0;
        }
        int shift = 1073741886 - this.exponent;
        if (shift < 32) {
            return this.sign == 0 ? Integer.MAX_VALUE : -2147483647;
        }
        return this.sign == 0 ? (int)(this.mantissa >>> shift) : -((int)(this.mantissa >>> shift));
    }

    public long toLong() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return this.sign == 0 ? Long.MAX_VALUE : -9223372036854775807L;
        }
        if (this.exponent < 0x40000000) {
            return 0L;
        }
        int shift = 1073741886 - this.exponent;
        if (shift < 0) {
            return this.sign == 0 ? Long.MAX_VALUE : -9223372036854775807L;
        }
        return this.sign == 0 ? this.mantissa >>> shift : -(this.mantissa >>> shift);
    }

    public boolean isIntegral() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return false;
        }
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa == 0L) {
            return true;
        }
        if (this.exponent < 0x40000000) {
            return false;
        }
        int shift = 1073741886 - this.exponent;
        if (shift <= 0) {
            return true;
        }
        return (this.mantissa & (1L << shift) - 1L) == 0L;
    }

    public boolean isOdd() {
        if (this.exponent < 0 || this.mantissa == 0L || this.exponent < 0x40000000 || this.exponent > 1073741886) {
            return false;
        }
        int shift = 1073741886 - this.exponent;
        return (this.mantissa >>> shift & 1L) != 0L;
    }

    public void swap(Real a) {
        long tmpMantissa = this.mantissa;
        this.mantissa = a.mantissa;
        a.mantissa = tmpMantissa;
        int tmpExponent = this.exponent;
        this.exponent = a.exponent;
        a.exponent = tmpExponent;
        byte tmpSign = this.sign;
        this.sign = a.sign;
        a.sign = tmpSign;
    }

    public void add(Real a) {
        long m;
        int e;
        byte s;
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || a.exponent < 0 && a.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L && a.exponent < 0 && a.mantissa == 0L && this.sign != a.sign) {
                this.makeNan();
            } else {
                this.makeInfinity(this.exponent < 0 && this.mantissa == 0L ? this.sign : a.sign);
            }
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || a.exponent == 0 && a.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = a.mantissa;
                this.exponent = a.exponent;
                this.sign = a.sign;
            }
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.sign = 0;
            }
            return;
        }
        if (this.exponent > a.exponent || this.exponent == a.exponent && this.mantissa >= a.mantissa) {
            s = a.sign;
            e = a.exponent;
            m = a.mantissa;
        } else {
            s = this.sign;
            e = this.exponent;
            m = this.mantissa;
            this.sign = a.sign;
            this.exponent = a.exponent;
            this.mantissa = a.mantissa;
        }
        int shift = this.exponent - e;
        if (shift >= 64) {
            return;
        }
        if (this.sign == s) {
            this.mantissa += m >>> shift;
            if (this.mantissa >= 0L && shift > 0 && (m >>> shift - 1 & 1L) != 0L) {
                ++this.mantissa;
            }
            if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
                if (this.exponent < 0) {
                    this.makeInfinity(this.sign);
                    return;
                }
            }
        } else {
            if (shift > 0) {
                this.mantissa <<= 1;
                --this.exponent;
                --shift;
            }
            m = -m;
            this.mantissa += m >> shift;
            if (this.mantissa >= 0L && shift > 0 && (m >>> shift - 1 & 1L) != 0L) {
                ++this.mantissa;
            }
            if (this.mantissa < 0L) {
                this.mantissa = this.mantissa + 1L >>> 1;
                ++this.exponent;
            } else if (shift == 0) {
                if (magicRounding && this.mantissa > 0L && this.mantissa <= 7L) {
                    m = -m;
                    if (this.exponent == 1073741884 || this.exponent == 1073741885 || this.exponent == 1073741886 && this.mantissa + m > 0L) {
                        long mask = (1 << 1073741886 - this.exponent) - 1;
                        if ((this.mantissa & mask) != 0L || (m & mask) != 0L) {
                            this.mantissa = 0L;
                        }
                    } else {
                        this.mantissa = 0L;
                    }
                }
                this.normalize();
            }
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
        }
    }

    public void add(int a) {
        tmp0.assign(a);
        this.add(tmp0);
    }

    public long add128(long extra, Real a, long aExtra) {
        long x;
        long m;
        int e;
        byte s;
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L || a.exponent < 0 && a.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L && a.exponent < 0 && a.mantissa == 0L && this.sign != a.sign) {
                this.makeNan();
            } else {
                this.makeInfinity(this.exponent < 0 && this.mantissa == 0L ? this.sign : a.sign);
            }
            return 0L;
        }
        if (this.exponent == 0 && this.mantissa == 0L || a.exponent == 0 && a.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = a.mantissa;
                this.exponent = a.exponent;
                this.sign = a.sign;
                extra = aExtra;
            }
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.sign = 0;
            }
            return extra;
        }
        if (this.exponent > a.exponent || this.exponent == a.exponent && this.mantissa > a.mantissa || this.exponent == a.exponent && this.mantissa == a.mantissa && extra >>> 1 >= aExtra >>> 1) {
            s = a.sign;
            e = a.exponent;
            m = a.mantissa;
            x = aExtra;
        } else {
            s = this.sign;
            e = this.exponent;
            m = this.mantissa;
            x = extra;
            this.sign = a.sign;
            this.exponent = a.exponent;
            this.mantissa = a.mantissa;
            extra = aExtra;
        }
        int shift = this.exponent - e;
        if (shift >= 127) {
            return extra;
        }
        if (shift >= 64) {
            x = m >>> shift - 64;
            m = 0L;
        } else if (shift > 0) {
            x = (x >>> shift) + (m << 64 - shift);
            m >>>= shift;
        }
        extra >>>= 1;
        x >>>= 1;
        if (this.sign == s) {
            this.mantissa += (extra += x) >> 63 & 1L;
            this.mantissa += m;
        } else {
            this.mantissa -= (extra -= x) >> 63 & 1L;
            this.mantissa -= m;
            if (this.mantissa == 0L && extra > 0L && extra <= 31L) {
                extra = 0L;
            }
        }
        extra <<= 1;
        extra = this.normalize128(extra);
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
        }
        return extra;
    }

    public void sub(Real a) {
        Real.tmp0.mantissa = a.mantissa;
        Real.tmp0.exponent = a.exponent;
        Real.tmp0.sign = (byte)(a.sign ^ 1);
        this.add(tmp0);
    }

    public void sub(int a) {
        tmp0.assign(a);
        this.sub(tmp0);
    }

    public void mul(Real a) {
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = (byte)(this.sign ^ a.sign);
        if (this.exponent == 0 && this.mantissa == 0L || a.exponent == 0 && a.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || a.exponent < 0 && a.mantissa == 0L) {
                this.makeNan();
            } else {
                this.makeZero(this.sign);
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || a.exponent < 0 && a.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        long a0 = this.mantissa & Integer.MAX_VALUE;
        long a1 = this.mantissa >>> 31;
        long b0 = a.mantissa & Integer.MAX_VALUE;
        long b1 = a.mantissa >>> 31;
        this.mantissa = a1 * b1;
        int round = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += a0 * b1 + a1 * b0 + (a0 * b0 >>> 31) + (long)round >>> 31;
        int aExp = a.exponent;
        this.exponent += aExp - 0x40000000;
        if (this.exponent < 0 && (this.exponent != -1 || aExp >= 0x40000000 || this.mantissa >= 0L)) {
            if (aExp < 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return;
        }
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
        }
    }

    public void mul(int a) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (a < 0) {
            this.sign = (byte)(this.sign ^ 1);
            a = -a;
        }
        if (this.exponent == 0 && this.mantissa == 0L || a == 0) {
            if (this.exponent < 0 && this.mantissa == 0L) {
                this.makeNan();
            } else {
                this.makeZero(this.sign);
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        int t = a;
        t |= t >> 1;
        t |= t >> 2;
        t |= t >> 4;
        t |= t >> 8;
        t |= t >> 16;
        t = clz_tab[t * 130329821 >>> 27];
        this.exponent += 31 - t;
        a <<= t;
        if (this.exponent < 0) {
            this.makeInfinity(this.sign);
            return;
        }
        long a0 = this.mantissa & Integer.MAX_VALUE;
        long a1 = this.mantissa >>> 31;
        long b0 = (long)a & 0xFFFFFFFFL;
        this.mantissa = a1 * b0;
        int round = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += a0 * b0 + (long)round >>> 31;
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
        }
    }

    public long mul128(long extra, Real a, long aExtra) {
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return 0L;
        }
        this.sign = (byte)(this.sign ^ a.sign);
        if (this.exponent == 0 && this.mantissa == 0L || a.exponent == 0 && a.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || a.exponent < 0 && a.mantissa == 0L) {
                this.makeNan();
            } else {
                this.makeZero(this.sign);
            }
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L || a.exponent < 0 && a.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return 0L;
        }
        int aExp = a.exponent;
        this.exponent += aExp - 0x40000000;
        if (this.exponent < 0) {
            if (aExp < 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return 0L;
        }
        long ffffffffL = 0xFFFFFFFFL;
        long a0 = extra & ffffffffL;
        long a1 = extra >>> 32;
        long a2 = this.mantissa & ffffffffL;
        long a3 = this.mantissa >>> 32;
        long b0 = aExtra & ffffffffL;
        long b1 = aExtra >>> 32;
        long b2 = a.mantissa & ffffffffL;
        long b3 = a.mantissa >>> 32;
        a0 = (a3 * b0 >>> 2) + (a2 * b1 >>> 2) + (a1 * b2 >>> 2) + (a0 * b3 >>> 2) + 0x60000000L >>> 28;
        b0 = a2 * b2;
        a1 = ((a0 += ((a1 *= b3) << 2 & ffffffffL) + (b0 << 2 & ffffffffL) + ((b1 *= a3) << 2 & ffffffffL)) >>> 32) + (a1 >>> 30) + (b0 >>> 30) + (b1 >>> 30);
        extra = ((a1 += ((a2 *= b3) << 2 & ffffffffL) + ((b2 *= a3) << 2 & ffffffffL)) << 32) + (a0 &= ffffffffL);
        this.mantissa = (a3 * b3 << 2) + (a1 >>> 32) + (a2 >>> 30) + (b2 >>> 30);
        extra = this.normalize128(extra);
        return extra;
    }

    private void mul10() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        this.mantissa += this.mantissa + 2L >>> 2;
        this.exponent += 3;
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
        }
        if (this.exponent < 0) {
            this.makeInfinity(this.sign);
        }
    }

    public void sqr() {
        this.sign = 0;
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        int e = this.exponent;
        this.exponent += this.exponent - 0x40000000;
        if (this.exponent < 0) {
            if (e < 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return;
        }
        long a0 = this.mantissa & Integer.MAX_VALUE;
        long a1 = this.mantissa >>> 31;
        this.mantissa = a1 * a1;
        int round = this.mantissa < 0L ? 0 : 0x40000000;
        this.mantissa += (a0 * a1 << 1) + (a0 * a0 >>> 31) + (long)round >>> 31;
        if (this.mantissa < 0L) {
            this.mantissa = this.mantissa + 1L >>> 1;
            ++this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
        }
    }

    private static long ldiv(long a, long b) {
        int bInv24 = (int)(0x400000000000L / ((b >>> 40) + 1L));
        int aHi24 = (int)(a >> 32) >>> 8;
        a <<= 20;
        int next21 = (int)((long)aHi24 * (long)bInv24 >>> 26);
        long q = next21;
        aHi24 = (int)((a -= (long)next21 * b) >> 32) >>> 7;
        a <<= 21;
        next21 = (int)((long)aHi24 * (long)bInv24 >>> 26);
        q = (q << 21) + (long)next21;
        aHi24 = (int)((a -= (long)next21 * b) >> 32) >>> 7;
        a <<= 21;
        next21 = (int)((long)aHi24 * (long)bInv24 >>> 26);
        q = (q << 21) + (long)next21;
        if ((a -= (long)next21 * b) < 0L || a >= b) {
            ++q;
            a -= b;
        }
        if ((a <<= 1) < 0L || a >= b) {
            ++q;
        }
        return q;
    }

    public void div(Real a) {
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        this.sign = (byte)(this.sign ^ a.sign);
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (a.exponent < 0 && a.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (a.exponent < 0 && a.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (a.exponent == 0 && a.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (a.exponent == 0 && a.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        this.exponent += 0x40000000 - a.exponent;
        if (this.mantissa < a.mantissa) {
            this.mantissa <<= 1;
            --this.exponent;
        }
        if (this.exponent < 0) {
            if (a.exponent >= 0x40000000) {
                this.makeZero(this.sign);
            } else {
                this.makeInfinity(this.sign);
            }
            return;
        }
        if (a.mantissa == 0x4000000000000000L) {
            return;
        }
        this.mantissa = Real.ldiv(this.mantissa, a.mantissa);
    }

    public void div(int a) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (a < 0) {
            this.sign = (byte)(this.sign ^ 1);
            a = -a;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (a == 0) {
                this.makeNan();
            }
            return;
        }
        if (a == 0) {
            this.makeInfinity(this.sign);
            return;
        }
        long denom = (long)a & 0xFFFFFFFFL;
        long remainder = this.mantissa % denom;
        this.mantissa /= denom;
        int clz = 0;
        int t = (int)(this.mantissa >>> 32);
        if (t == 0) {
            clz = 32;
            t = (int)this.mantissa;
        }
        t |= t >> 1;
        t |= t >> 2;
        t |= t >> 4;
        t |= t >> 8;
        t |= t >> 16;
        this.mantissa <<= (clz += clz_tab[t * 130329821 >>> 27] - 1);
        remainder <<= clz;
        this.exponent -= clz;
        remainder = (remainder + denom / 2L) / denom;
        this.mantissa += remainder;
        if (this.exponent < 0) {
            this.makeZero(this.sign);
        }
    }

    public void rdiv(Real a) {
        Real.recipTmp.mantissa = a.mantissa;
        Real.recipTmp.exponent = a.exponent;
        Real.recipTmp.sign = a.sign;
        recipTmp.div(this);
        this.mantissa = Real.recipTmp.mantissa;
        this.exponent = Real.recipTmp.exponent;
        this.sign = Real.recipTmp.sign;
    }

    public void rdiv(int a) {
        tmp0.assign(a);
        this.rdiv(tmp0);
    }

    public void recip() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        this.exponent = Integer.MIN_VALUE - this.exponent;
        if (this.mantissa == 0x4000000000000000L) {
            if (this.exponent < 0) {
                this.makeInfinity(this.sign);
            }
            return;
        }
        --this.exponent;
        this.mantissa = Real.ldiv(Long.MIN_VALUE, this.mantissa);
    }

    public long recip128(long extra) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return 0L;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeZero(this.sign);
            return 0L;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return 0L;
        }
        byte s = this.sign;
        this.sign = 0;
        if (this.mantissa == 0x4000000000000000L && extra == 0L) {
            this.exponent = Integer.MIN_VALUE - this.exponent;
            if (this.exponent < 0) {
                this.makeInfinity(s);
            }
            return 0L;
        }
        int exp = 0x40000000 - this.exponent;
        this.exponent = 0x40000000;
        Real.recipTmp.mantissa = this.mantissa;
        Real.recipTmp.exponent = this.exponent;
        Real.recipTmp.sign = this.sign;
        long recipTmpExtra = extra;
        recipTmp.neg();
        this.recip();
        Real.recipTmp2.mantissa = this.mantissa;
        Real.recipTmp2.exponent = this.exponent;
        Real.recipTmp2.sign = this.sign;
        extra = this.mul128(0L, recipTmp, recipTmpExtra);
        extra = this.add128(extra, ONE, 0L);
        extra = this.mul128(extra, recipTmp2, 0L);
        extra = this.add128(extra, recipTmp2, 0L);
        this.scalbn(exp);
        if (!this.isNan()) {
            this.sign = s;
        }
        return extra;
    }

    public void divf(Real a) {
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (a.exponent < 0 && a.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (a.exponent < 0 && a.mantissa == 0L) {
            this.makeZero(this.sign);
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (a.exponent == 0 && a.mantissa == 0L) {
                this.makeNan();
            }
            return;
        }
        if (a.exponent == 0 && a.mantissa == 0L) {
            this.makeInfinity(this.sign);
            return;
        }
        Real.tmp0.mantissa = a.mantissa;
        Real.tmp0.exponent = a.exponent;
        Real.tmp0.sign = a.sign;
        long extra = tmp0.recip128(0L);
        extra = this.mul128(0L, tmp0, extra);
        if (Real.tmp0.sign != 0 && (extra < 0L || extra > 31L) || Real.tmp0.sign == 0 && extra < 0L && extra > -32L) {
            ++this.mantissa;
            this.normalize();
        }
        this.floor();
    }

    private void modInternal(Real a, long aExtra) {
        Real.tmp0.mantissa = a.mantissa;
        Real.tmp0.exponent = a.exponent;
        Real.tmp0.sign = a.sign;
        long extra = tmp0.recip128(aExtra);
        extra = tmp0.mul128(extra, this, 0L);
        if (Real.tmp0.exponent > 1073741886) {
            this.makeZero(a.sign);
            return;
        }
        if (Real.tmp0.sign != 0 && (extra < 0L || extra > 31L) || Real.tmp0.sign == 0 && extra < 0L && extra > -32L) {
            ++Real.tmp0.mantissa;
            tmp0.normalize();
        }
        tmp0.floor();
        tmp0.neg();
        extra = tmp0.mul128(0L, a, aExtra);
        extra = this.add128(0L, tmp0, extra);
        this.roundFrom128(extra);
    }

    public void mod(Real a) {
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (a.exponent == 0 && a.mantissa == 0L) {
                this.makeNan();
            } else {
                this.sign = a.sign;
            }
            return;
        }
        if (a.exponent < 0 && a.mantissa == 0L) {
            if (this.sign != a.sign) {
                this.makeInfinity(a.sign);
            }
            return;
        }
        if (a.exponent == 0 && a.mantissa == 0L) {
            this.makeZero(a.sign);
            return;
        }
        this.modInternal(a, 0L);
    }

    public void and(Real a) {
        long m;
        int e;
        byte s;
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || a.exponent == 0 && a.mantissa == 0L) {
            this.makeZero();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || a.exponent < 0 && a.mantissa == 0L) {
            if ((this.exponent >= 0 || this.mantissa != 0L) && this.sign != 0) {
                this.mantissa = a.mantissa;
                this.exponent = a.exponent;
                this.sign = a.sign;
            } else if ((a.exponent < 0 && a.mantissa == 0L || a.sign == 0) && (this.exponent >= 0 || this.mantissa != 0L || a.exponent >= 0 || a.mantissa != 0L || this.sign == 0 || a.sign == 0)) {
                this.makeZero();
            }
            return;
        }
        if (this.exponent >= a.exponent) {
            s = a.sign;
            e = a.exponent;
            m = a.mantissa;
        } else {
            s = this.sign;
            e = this.exponent;
            m = this.mantissa;
            this.sign = a.sign;
            this.exponent = a.exponent;
            this.mantissa = a.mantissa;
        }
        int shift = this.exponent - e;
        if (shift >= 64) {
            if (s == 0) {
                this.makeZero(this.sign);
            }
            return;
        }
        if (s != 0) {
            m = -m;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        this.mantissa &= m >> shift;
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    public void or(Real a) {
        long m;
        int e;
        byte s;
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || a.exponent == 0 && a.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = a.mantissa;
                this.exponent = a.exponent;
                this.sign = a.sign;
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || a.exponent < 0 && a.mantissa == 0L) {
            if (this.exponent < 0 && this.mantissa == 0L || this.sign == 0) {
                if ((a.exponent >= 0 || a.mantissa != 0L) && a.sign != 0) {
                    this.mantissa = a.mantissa;
                    this.exponent = a.exponent;
                    this.sign = a.sign;
                } else {
                    this.makeInfinity(this.sign | a.sign);
                }
            }
            return;
        }
        if (this.sign != 0 && this.exponent <= a.exponent || a.sign == 0 && this.exponent >= a.exponent) {
            s = a.sign;
            e = a.exponent;
            m = a.mantissa;
        } else {
            s = this.sign;
            e = this.exponent;
            m = this.mantissa;
            this.sign = a.sign;
            this.exponent = a.exponent;
            this.mantissa = a.mantissa;
        }
        int shift = this.exponent - e;
        if (shift >= 64 || shift <= -64) {
            return;
        }
        if (s != 0) {
            m = -m;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        this.mantissa = shift >= 0 ? (this.mantissa |= m >> shift) : (this.mantissa |= m << -shift);
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    public void xor(Real a) {
        long m;
        int e;
        byte s;
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || a.exponent == 0 && a.mantissa == 0L) {
            if (this.exponent == 0 && this.mantissa == 0L) {
                this.mantissa = a.mantissa;
                this.exponent = a.exponent;
                this.sign = a.sign;
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || a.exponent < 0 && a.mantissa == 0L) {
            this.makeInfinity(this.sign ^ a.sign);
            return;
        }
        if (this.exponent >= a.exponent) {
            s = a.sign;
            e = a.exponent;
            m = a.mantissa;
        } else {
            s = this.sign;
            e = this.exponent;
            m = this.mantissa;
            this.sign = a.sign;
            this.exponent = a.exponent;
            this.mantissa = a.mantissa;
        }
        int shift = this.exponent - e;
        if (shift >= 64) {
            return;
        }
        if (s != 0) {
            m = -m;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        this.mantissa ^= m >> shift;
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    public void bic(Real a) {
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L || a.exponent == 0 && a.mantissa == 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || a.exponent < 0 && a.mantissa == 0L) {
            if (this.exponent >= 0 || this.mantissa != 0L) {
                if (this.sign != 0) {
                    if (a.sign != 0) {
                        this.makeInfinity(0);
                    } else {
                        this.makeInfinity(1);
                    }
                }
            } else if (a.sign != 0) {
                if (a.exponent < 0 && a.mantissa == 0L) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            }
            return;
        }
        int shift = this.exponent - a.exponent;
        if (shift >= 64 || shift <= -64 && this.sign == 0) {
            return;
        }
        long m = a.mantissa;
        if (a.sign != 0) {
            m = -m;
        }
        if (this.sign != 0) {
            this.mantissa = -this.mantissa;
        }
        if (shift < 0) {
            if (this.sign != 0) {
                this.mantissa = shift <= -64 ? m ^ 0xFFFFFFFFFFFFFFFFL : this.mantissa >> -shift & (m ^ 0xFFFFFFFFFFFFFFFFL);
                this.exponent = a.exponent;
            } else {
                this.mantissa &= m << -shift ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } else {
            this.mantissa &= m >> shift ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.sign = 0;
        if (this.mantissa < 0L) {
            this.mantissa = -this.mantissa;
            this.sign = 1;
        }
        this.normalize();
    }

    private int compare(int a) {
        tmp0.assign(a);
        return this.compare(tmp0);
    }

    public void sqrt() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
            return;
        }
        if (this.sign != 0) {
            this.makeNan();
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return;
        }
        Real.recipTmp.mantissa = this.mantissa;
        Real.recipTmp.exponent = this.exponent;
        Real.recipTmp.sign = this.sign;
        int e = this.exponent - 0x3FFFFFFF;
        this.exponent = 0x3FFFFFFF;
        Real.recipTmp2.mantissa = this.mantissa;
        Real.recipTmp2.exponent = this.exponent;
        Real.recipTmp2.sign = this.sign;
        Real.sqrtTmp.sign = 1;
        Real.sqrtTmp.exponent = 0x3FFFFFFD;
        Real.sqrtTmp.mantissa = 7541244123455418907L;
        this.mul(sqrtTmp);
        Real.sqrtTmp.sign = 0;
        Real.sqrtTmp.exponent = 0x3FFFFFFF;
        Real.sqrtTmp.mantissa = 8210591124990847720L;
        this.add(sqrtTmp);
        this.mul(recipTmp2);
        Real.sqrtTmp.sign = 0;
        Real.sqrtTmp.exponent = 0x3FFFFFFE;
        Real.sqrtTmp.mantissa = 5784291442694842234L;
        this.add(sqrtTmp);
        if ((e & 1) != 0) {
            this.mul(SQRT2);
        }
        this.exponent += e >> 1;
        for (int i = 0; i < 3; ++i) {
            Real.recipTmp2.mantissa = Real.recipTmp.mantissa;
            Real.recipTmp2.exponent = Real.recipTmp.exponent;
            Real.recipTmp2.sign = Real.recipTmp.sign;
            recipTmp2.div(this);
            this.add(recipTmp2);
            this.scalbn(-1);
        }
    }

    public void rsqrt() {
        this.sqrt();
        this.recip();
    }

    public void cbrt() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        byte s = this.sign;
        this.sign = 0;
        long start = 5845672316326903808L;
        Real.recipTmp.mantissa = this.mantissa;
        Real.recipTmp.exponent = this.exponent;
        Real.recipTmp.sign = this.sign;
        recipTmp.neg();
        this.mantissa = 5845672316326903808L - (this.mantissa >>> 2);
        int expRmd = this.exponent == 0 ? 2 : (this.exponent - 1) % 3;
        this.exponent = 0x40000000 - (this.exponent - 0x40000000 - expRmd) / 3;
        this.normalize();
        if (expRmd > 0) {
            Real.recipTmp2.sign = 0;
            Real.recipTmp2.exponent = 0x3FFFFFFF;
            Real.recipTmp2.mantissa = 7320595236998672907L;
            this.mul(recipTmp2);
            if (expRmd > 1) {
                this.mul(recipTmp2);
            }
        }
        for (int i = 0; i < 4; ++i) {
            Real.recipTmp2.mantissa = this.mantissa;
            Real.recipTmp2.exponent = this.exponent;
            Real.recipTmp2.sign = this.sign;
            this.sqr();
            this.sqr();
            this.mul(recipTmp);
            recipTmp2.scalbn(2);
            this.add(recipTmp2);
            this.mul(THIRD);
        }
        this.recip();
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = s;
        }
    }

    public void nroot(Real n) {
        if (n.exponent < 0 && n.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (n.compare(THREE) == 0) {
            this.cbrt();
            return;
        }
        if (n.compare(TWO) == 0) {
            this.sqrt();
            return;
        }
        boolean negative = false;
        if (this.sign != 0 && n.isIntegral() && n.isOdd()) {
            negative = true;
            this.abs();
        }
        Real.tmp2.mantissa = n.mantissa;
        Real.tmp2.exponent = n.exponent;
        Real.tmp2.sign = n.sign;
        tmp2.recip();
        this.pow(tmp2);
        if (negative) {
            this.neg();
        }
    }

    public void hypot(Real a) {
        Real.tmp1.mantissa = a.mantissa;
        Real.tmp1.exponent = a.exponent;
        Real.tmp1.sign = a.sign;
        tmp1.sqr();
        this.sqr();
        this.add(tmp1);
        this.sqrt();
    }

    private void exp2Internal(long extra) {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign != 0) {
                this.makeZero(0);
            }
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        expTmp.add(HALF);
        expTmp.floor();
        int exp = expTmp.toInteger();
        if (exp > 0x40000000) {
            this.makeInfinity(this.sign);
            return;
        }
        if (exp < -1073741824) {
            this.makeZero(this.sign);
            return;
        }
        expTmp.neg();
        this.add128(extra, expTmp, 0L);
        Real.expTmp2.mantissa = this.mantissa;
        Real.expTmp2.exponent = this.exponent;
        Real.expTmp2.sign = this.sign;
        expTmp2.sqr();
        Real.expTmp.sign = 0;
        Real.expTmp.exponent = 0x40000005;
        Real.expTmp.mantissa = 8735521019871854572L;
        expTmp.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x4000000E;
        Real.expTmp3.mantissa = 8525024715132279315L;
        expTmp.add(expTmp3);
        expTmp.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000014;
        Real.expTmp3.mantissa = 9149627190283911008L;
        expTmp.add(expTmp3);
        this.mul(expTmp);
        expTmp.assign(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x4000000A;
        Real.expTmp3.mantissa = 7878091433835080621L;
        expTmp.add(expTmp3);
        expTmp.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 1073741842;
        Real.expTmp3.mantissa = 5765401886743753158L;
        expTmp.add(expTmp3);
        expTmp.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 1073741846;
        Real.expTmp3.mantissa = 6600060886702709183L;
        expTmp.add(expTmp3);
        expTmp.sub(this);
        this.div(expTmp);
        this.scalbn(1);
        this.add(ONE);
        this.scalbn(exp);
    }

    public void exp() {
        Real.expTmp.sign = 0;
        Real.expTmp.exponent = 0x40000000;
        Real.expTmp.mantissa = 6653256548922161245L;
        long extra = this.mul128(0L, expTmp, -2358760956788564156L);
        this.exp2Internal(extra);
    }

    public void exp2() {
        this.exp2Internal(0L);
    }

    public void exp10() {
        Real.expTmp.sign = 0;
        Real.expTmp.exponent = 0x40000001;
        Real.expTmp.mantissa = 7659844674706589055L;
        long extra = this.mul128(0L, expTmp, 2636289682573880742L);
        this.exp2Internal(extra);
    }

    private int lnInternal() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return 0;
        }
        if (this.sign != 0) {
            this.makeNan();
            return 0;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(1);
            return 0;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            return 0;
        }
        int e = this.exponent - 0x3FFFFFFF;
        this.exponent = 0x3FFFFFFF;
        if (this.compare(SQRT1_2) < 0) {
            --e;
            ++this.exponent;
        }
        this.sub(ONE);
        Real.expTmp2.mantissa = this.mantissa;
        Real.expTmp2.exponent = this.exponent;
        Real.expTmp2.sign = this.sign;
        this.sign = 0;
        this.exponent = 0x3FFFFFF1;
        this.mantissa = 6841009112073316573L;
        this.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x3FFFFFFE;
        Real.expTmp3.mantissa = 9196458758038490344L;
        this.add(expTmp3);
        this.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000002;
        Real.expTmp3.mantissa = 7584762280918207649L;
        this.add(expTmp3);
        this.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000004;
        Real.expTmp3.mantissa = 8621523759488509294L;
        this.add(expTmp3);
        this.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000005;
        Real.expTmp3.mantissa = 8783772864241025570L;
        this.add(expTmp3);
        this.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000005;
        Real.expTmp3.mantissa = 8230845489426743510L;
        this.add(expTmp3);
        this.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000004;
        Real.expTmp3.mantissa = 5776008042987136607L;
        this.add(expTmp3);
        Real.expTmp.mantissa = Real.expTmp2.mantissa;
        Real.expTmp.exponent = Real.expTmp2.exponent;
        Real.expTmp.sign = Real.expTmp2.sign;
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000003;
        Real.expTmp3.mantissa = 8683175902134721628L;
        expTmp.add(expTmp3);
        expTmp.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000006;
        Real.expTmp3.mantissa = 5984207794357820952L;
        expTmp.add(expTmp3);
        expTmp.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000007;
        Real.expTmp3.mantissa = 7989832432531363702L;
        expTmp.add(expTmp3);
        expTmp.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000008;
        Real.expTmp3.mantissa = 5568227561439401455L;
        expTmp.add(expTmp3);
        expTmp.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000007;
        Real.expTmp3.mantissa = 7797636379160189072L;
        expTmp.add(expTmp3);
        expTmp.mul(expTmp2);
        Real.expTmp3.sign = 0;
        Real.expTmp3.exponent = 0x40000005;
        Real.expTmp3.mantissa = 8664012064480704931L;
        expTmp.add(expTmp3);
        this.div(expTmp);
        Real.expTmp3.mantissa = Real.expTmp2.mantissa;
        Real.expTmp3.exponent = Real.expTmp2.exponent;
        Real.expTmp3.sign = Real.expTmp2.sign;
        expTmp3.sqr();
        this.mul(expTmp3);
        this.mul(expTmp2);
        expTmp3.scalbn(-1);
        this.sub(expTmp3);
        this.add(expTmp2);
        return e;
    }

    public void ln() {
        int exp = this.lnInternal();
        expTmp.assign(exp);
        expTmp.mul(LN2);
        this.add(expTmp);
    }

    public void log2() {
        int exp = this.lnInternal();
        this.mul(LOG2E);
        this.add(exp);
    }

    public void log10() {
        int exp = this.lnInternal();
        expTmp.assign(exp);
        expTmp.mul(LN2);
        this.add(expTmp);
        this.mul(LOG10E);
    }

    public int lowPow10() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return 0;
        }
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        int e = this.exponent - 0x40000000;
        e = e < 0 ? -((int)((long)(-e) * 1292913987L + 0xFFFFFFFFL >> 32)) : (int)((long)e * 1292913987L >> 32);
        this.mantissa = Real.TEN.mantissa;
        this.exponent = Real.TEN.exponent;
        this.sign = Real.TEN.sign;
        this.pow(e);
        if (this.exponent == 0 && this.mantissa == 0L) {
            Real.tmp3.mantissa = Real.TEN.mantissa;
            Real.tmp3.exponent = Real.TEN.exponent;
            Real.tmp3.sign = Real.TEN.sign;
            tmp3.pow(e + 1);
        } else {
            Real.tmp3.mantissa = this.mantissa;
            Real.tmp3.exponent = this.exponent;
            Real.tmp3.sign = this.sign;
            tmp3.mul10();
        }
        if (tmp3.compare(tmp2) <= 0) {
            ++e;
            this.mantissa = Real.tmp3.mantissa;
            this.exponent = Real.tmp3.exponent;
            this.sign = Real.tmp3.sign;
        }
        return e;
    }

    public void pow(Real a) {
        if (a.exponent == 0 && a.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.exponent < 0 && this.mantissa != 0L || a.exponent < 0 && a.mantissa != 0L) {
            this.makeNan();
            return;
        }
        if (a.compare(ONE) == 0) {
            return;
        }
        if (a.exponent < 0 && a.mantissa == 0L) {
            Real.tmp1.mantissa = this.mantissa;
            Real.tmp1.exponent = this.exponent;
            Real.tmp1.sign = this.sign;
            tmp1.abs();
            int test = tmp1.compare(ONE);
            if (test > 0) {
                if (a.sign == 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else if (test < 0) {
                if (a.sign != 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else {
                this.makeNan();
            }
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                if (a.sign == 0) {
                    this.makeZero();
                } else {
                    this.makeInfinity(0);
                }
            } else if (a.isIntegral() && a.isOdd()) {
                if (a.sign == 0) {
                    this.makeZero(1);
                } else {
                    this.makeInfinity(1);
                }
            } else if (a.sign == 0) {
                this.makeZero();
            } else {
                this.makeInfinity(0);
            }
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            if (this.sign == 0) {
                if (a.sign == 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else if (a.isIntegral()) {
                if (a.isOdd()) {
                    if (a.sign == 0) {
                        this.makeInfinity(1);
                    } else {
                        this.makeZero(1);
                    }
                } else if (a.sign == 0) {
                    this.makeInfinity(0);
                } else {
                    this.makeZero();
                }
            } else {
                this.makeNan();
            }
            return;
        }
        if (a.isIntegral() && a.exponent <= 1073741854) {
            this.pow(a.toInteger());
            return;
        }
        byte s = 0;
        if (this.sign != 0) {
            if (a.isIntegral()) {
                if (a.isOdd()) {
                    s = 1;
                }
            } else {
                this.makeNan();
                return;
            }
            this.sign = 0;
        }
        Real.tmp1.mantissa = a.mantissa;
        Real.tmp1.exponent = a.exponent;
        Real.tmp1.sign = a.sign;
        if (Real.tmp1.exponent <= 1073741854) {
            Real.tmp2.mantissa = Real.tmp1.mantissa;
            Real.tmp2.exponent = Real.tmp1.exponent;
            Real.tmp2.sign = Real.tmp1.sign;
            tmp2.floor();
            Real.tmp3.mantissa = this.mantissa;
            Real.tmp3.exponent = this.exponent;
            Real.tmp3.sign = this.sign;
            tmp3.pow(tmp2.toInteger());
            tmp1.sub(tmp2);
        } else {
            Real.tmp3.mantissa = Real.ONE.mantissa;
            Real.tmp3.exponent = Real.ONE.exponent;
            Real.tmp3.sign = Real.ONE.sign;
        }
        int e = this.lnInternal();
        Real.tmp2.sign = 0;
        Real.tmp2.exponent = 0x40000000;
        Real.tmp2.mantissa = 6653256548922161245L;
        long extra = this.mul128(0L, tmp2, -2358760956788564156L);
        tmp2.assign(e);
        extra = this.add128(extra, tmp2, 0L);
        extra = tmp1.mul128(0L, this, extra);
        tmp1.exp2Internal(extra);
        this.mantissa = Real.tmp1.mantissa;
        this.exponent = Real.tmp1.exponent;
        this.sign = Real.tmp1.sign;
        this.mul(tmp3);
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = s;
        }
    }

    public void pow(int a) {
        boolean recp = false;
        if (a < 0) {
            a = -a;
            recp = true;
        }
        long extra = 0L;
        long expTmpExtra = 0L;
        Real.expTmp.mantissa = this.mantissa;
        Real.expTmp.exponent = this.exponent;
        Real.expTmp.sign = this.sign;
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        while (a != 0) {
            if ((a & 1) != 0) {
                extra = this.mul128(extra, expTmp, expTmpExtra);
            }
            expTmpExtra = expTmp.mul128(expTmpExtra, expTmp, expTmpExtra);
            a >>>= 1;
        }
        if (recp) {
            extra = this.recip128(extra);
        }
        this.roundFrom128(extra);
    }

    private void sinInternal() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.sqr();
        this.sign = 1;
        this.exponent = 1073741783;
        this.mantissa = 7685553039149311763L;
        this.mul(tmp2);
        Real.tmp3.sign = 0;
        Real.tmp3.exponent = 0x3FFFFFDF;
        Real.tmp3.mantissa = 6361373033667703404L;
        this.add(tmp3);
        this.mul(tmp2);
        Real.tmp3.sign = 1;
        Real.tmp3.exponent = 1073741798;
        Real.tmp3.mantissa = 7753250925411172568L;
        this.add(tmp3);
        this.mul(tmp2);
        Real.tmp3.sign = 0;
        Real.tmp3.exponent = 1073741805;
        Real.tmp3.mantissa = 6662950943449080955L;
        this.add(tmp3);
        this.mul(tmp2);
        Real.tmp3.sign = 1;
        Real.tmp3.exponent = 0x3FFFFFF3;
        Real.tmp3.mantissa = 7495819814073119370L;
        this.add(tmp3);
        this.mul(tmp2);
        Real.tmp3.sign = 0;
        Real.tmp3.exponent = 0x3FFFFFF9;
        Real.tmp3.mantissa = 4919131752989207373L;
        this.add(tmp3);
        this.mul(tmp2);
        Real.tmp3.sign = 1;
        Real.tmp3.exponent = 0x3FFFFFFD;
        Real.tmp3.mantissa = 0x555555555555554CL;
        this.add(tmp3);
        this.mul(tmp2);
        this.mul(tmp1);
        this.add(tmp1);
    }

    private void cosInternal() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.sqr();
        this.sign = 0;
        this.exponent = 0x3FFFFFD3;
        this.mantissa = 7687440180248885787L;
        this.mul(tmp2);
        Real.tmp3.sign = 1;
        Real.tmp3.exponent = 1073741787;
        Real.tmp3.mantissa = 7270156733278459803L;
        this.add(tmp3);
        this.mul(tmp2);
        Real.tmp3.sign = 0;
        Real.tmp3.exponent = 0x3FFFFFE3;
        Real.tmp3.mantissa = 5168834004460186024L;
        this.add(tmp3);
        this.mul(tmp2);
        Real.tmp3.sign = 1;
        Real.tmp3.exponent = 1073741802;
        Real.tmp3.mantissa = 5330360754940094102L;
        this.add(tmp3);
        this.mul(tmp2);
        Real.tmp3.sign = 0;
        Real.tmp3.exponent = 0x3FFFFFF0;
        Real.tmp3.mantissa = 7495819814073739767L;
        this.add(tmp3);
        this.mul(tmp2);
        Real.tmp3.sign = 1;
        Real.tmp3.exponent = 0x3FFFFFF6;
        Real.tmp3.mantissa = 6558842337318944179L;
        this.add(tmp3);
        this.mul(tmp2);
        Real.tmp3.sign = 0;
        Real.tmp3.exponent = 0x3FFFFFFB;
        Real.tmp3.mantissa = 0x555555555555554DL;
        this.add(tmp3);
        this.mul(tmp2);
        this.sub(HALF);
        this.mul(tmp2);
        this.add(ONE);
    }

    public void sin() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            if (this.exponent != 0 || this.mantissa != 0L) {
                this.makeNan();
            }
            return;
        }
        boolean negative = false;
        if (this.sign != 0) {
            this.abs();
            negative = true;
        }
        if (this.compare(PI2) > 0) {
            this.modInternal(PI2, 7089564414062235241L);
        }
        if (this.compare(PI) > 0) {
            this.sub(PI2);
            this.neg();
            boolean bl = negative = !negative;
        }
        if (this.compare(PI_2) > 0) {
            this.sub(PI);
            this.neg();
        }
        if (this.compare(PI_4) > 0) {
            this.sub(PI_2);
            this.neg();
            this.cosInternal();
        } else {
            this.sinInternal();
        }
        if (negative) {
            this.neg();
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.abs();
        }
    }

    public void cos() {
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.sign != 0) {
            this.abs();
        }
        if (this.compare(PI_4) < 0) {
            this.cosInternal();
        } else {
            this.add(PI_2);
            this.sin();
        }
    }

    public void tan() {
        Real.tmp4.mantissa = this.mantissa;
        Real.tmp4.exponent = this.exponent;
        Real.tmp4.sign = this.sign;
        tmp4.cos();
        this.sin();
        this.div(tmp4);
    }

    public void asin() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        this.sqr();
        this.neg();
        this.add(ONE);
        this.rsqrt();
        this.mul(tmp1);
        this.atan();
    }

    public void acos() {
        boolean negative = this.sign != 0;
        this.abs();
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        this.sqr();
        this.neg();
        this.add(ONE);
        this.sqrt();
        this.div(tmp1);
        this.atan();
        if (negative) {
            this.neg();
            this.add(PI);
        }
    }

    public void atan() {
        if (this.exponent == 0 && this.mantissa == 0L || this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            byte s = this.sign;
            this.mantissa = Real.PI_2.mantissa;
            this.exponent = Real.PI_2.exponent;
            this.sign = Real.PI_2.sign;
            this.sign = s;
            return;
        }
        byte s = this.sign;
        this.sign = 0;
        boolean addPI_2 = false;
        boolean addPI_4 = false;
        Real.tmp1.mantissa = Real.SQRT2.mantissa;
        Real.tmp1.exponent = Real.SQRT2.exponent;
        Real.tmp1.sign = Real.SQRT2.sign;
        tmp1.add(ONE);
        if (this.compare(tmp1) > 0) {
            addPI_2 = true;
            this.recip();
            this.neg();
        } else {
            tmp1.sub(TWO);
            if (this.compare(tmp1) > 0) {
                addPI_4 = true;
                Real.tmp1.mantissa = this.mantissa;
                Real.tmp1.exponent = this.exponent;
                Real.tmp1.sign = this.sign;
                tmp1.add(ONE);
                this.sub(ONE);
                this.div(tmp1);
            }
        }
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.sqr();
        this.mul(tmp2);
        Real.tmp3.sign = 1;
        Real.tmp3.exponent = 0x3FFFFFFF;
        Real.tmp3.mantissa = 8011773115982530407L;
        tmp3.mul(tmp2);
        Real.tmp4.sign = 1;
        Real.tmp4.exponent = 0x40000003;
        Real.tmp4.mantissa = 8464466433134330867L;
        tmp3.add(tmp4);
        tmp3.mul(tmp2);
        Real.tmp4.sign = 1;
        Real.tmp4.exponent = 0x40000005;
        Real.tmp4.mantissa = 9220041341143656951L;
        tmp3.add(tmp4);
        tmp3.mul(tmp2);
        Real.tmp4.sign = 1;
        Real.tmp4.exponent = 0x40000006;
        Real.tmp4.mantissa = 7204949748616494315L;
        tmp3.add(tmp4);
        tmp3.mul(tmp2);
        Real.tmp4.sign = 1;
        Real.tmp4.exponent = 0x40000005;
        Real.tmp4.mantissa = 7334615228943850338L;
        tmp3.add(tmp4);
        this.mul(tmp3);
        Real.tmp3.mantissa = Real.tmp2.mantissa;
        Real.tmp3.exponent = Real.tmp2.exponent;
        Real.tmp3.sign = Real.tmp2.sign;
        Real.tmp4.sign = 0;
        Real.tmp4.exponent = 0x40000004;
        Real.tmp4.mantissa = 6624077857899883114L;
        tmp3.add(tmp4);
        tmp3.mul(tmp2);
        Real.tmp4.sign = 0;
        Real.tmp4.exponent = 0x40000007;
        Real.tmp4.mantissa = 5187821114451245916L;
        tmp3.add(tmp4);
        tmp3.mul(tmp2);
        Real.tmp4.sign = 0;
        Real.tmp4.exponent = 0x40000008;
        Real.tmp4.mantissa = 6511138498204955093L;
        tmp3.add(tmp4);
        tmp3.mul(tmp2);
        Real.tmp4.sign = 0;
        Real.tmp4.exponent = 0x40000008;
        Real.tmp4.mantissa = 7054000737974736352L;
        tmp3.add(tmp4);
        tmp3.mul(tmp2);
        Real.tmp4.sign = 0;
        Real.tmp4.exponent = 0x40000007;
        Real.tmp4.mantissa = 5500961421707887758L;
        tmp3.add(tmp4);
        this.div(tmp3);
        this.add(tmp1);
        if (addPI_2) {
            this.add(PI_2);
        }
        if (addPI_4) {
            this.add(PI_4);
        }
        if (s != 0) {
            this.neg();
        }
    }

    public void atan2(Real x) {
        if (this.exponent < 0 && this.mantissa != 0L || x.exponent < 0 && x.mantissa != 0L || this.exponent < 0 && this.mantissa == 0L && x.exponent < 0 && x.mantissa == 0L) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L && x.exponent == 0 && x.mantissa == 0L) {
            return;
        }
        byte s = this.sign;
        byte s2 = x.sign;
        this.sign = 0;
        x.sign = 0;
        this.div(x);
        this.atan();
        if (s2 != 0) {
            this.neg();
            this.add(PI);
        }
        this.sign = s;
    }

    public void sinh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.neg();
        tmp1.exp();
        this.exp();
        this.sub(tmp1);
        this.scalbn(-1);
    }

    public void cosh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.neg();
        tmp1.exp();
        this.exp();
        this.add(tmp1);
        this.scalbn(-1);
    }

    public void tanh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.neg();
        tmp1.exp();
        this.exp();
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        tmp2.add(tmp1);
        this.sub(tmp1);
        this.div(tmp2);
    }

    public void asinh() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        byte s = this.sign;
        this.sign = 0;
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.sqr();
        tmp1.add(ONE);
        tmp1.sqrt();
        this.add(tmp1);
        this.ln();
        if (this.exponent >= 0 || this.mantissa == 0L) {
            this.sign = s;
        }
    }

    public void acosh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.sqr();
        tmp1.sub(ONE);
        tmp1.sqrt();
        this.add(tmp1);
        this.ln();
    }

    public void atanh() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.neg();
        tmp1.add(ONE);
        this.add(ONE);
        this.div(tmp1);
        this.ln();
        this.scalbn(-1);
    }

    public void fact() {
        if (this.exponent < 0) {
            return;
        }
        if (!this.isIntegral() || this.compare(ZERO) < 0 || this.compare(200) > 0) {
            this.add(ONE);
            this.gamma();
            return;
        }
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        while (tmp1.compare(ONE) > 0) {
            this.mul(tmp1);
            tmp1.sub(ONE);
        }
    }

    public void gamma() {
        if (this.exponent < 0) {
            return;
        }
        boolean negative = this.sign != 0;
        this.abs();
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        Real.tmp2.mantissa = Real.ONE.mantissa;
        Real.tmp2.exponent = Real.ONE.exponent;
        Real.tmp2.sign = Real.ONE.sign;
        boolean divide = false;
        while (this.compare(20) < 0) {
            divide = true;
            tmp2.mul(this);
            this.add(ONE);
        }
        Real.tmp3.mantissa = this.mantissa;
        Real.tmp3.exponent = this.exponent;
        Real.tmp3.sign = this.sign;
        Real.tmp4.mantissa = this.mantissa;
        Real.tmp4.exponent = this.exponent;
        Real.tmp4.sign = this.sign;
        tmp4.sqr();
        this.ln();
        Real.tmp5.mantissa = Real.tmp3.mantissa;
        Real.tmp5.exponent = Real.tmp3.exponent;
        Real.tmp5.sign = Real.tmp3.sign;
        tmp5.sub(HALF);
        this.mul(tmp5);
        this.sub(tmp3);
        Real.tmp5.sign = 0;
        Real.tmp5.exponent = 0x3FFFFFFF;
        Real.tmp5.mantissa = 8475711970748322458L;
        this.add(tmp5);
        tmp5.assign(12);
        tmp5.mul(tmp3);
        tmp5.recip();
        this.add(tmp5);
        tmp3.mul(tmp4);
        tmp5.assign(360);
        tmp5.mul(tmp3);
        tmp5.recip();
        this.sub(tmp5);
        tmp3.mul(tmp4);
        tmp5.assign(1260);
        tmp5.mul(tmp3);
        tmp5.recip();
        this.add(tmp5);
        tmp3.mul(tmp4);
        tmp5.assign(1680);
        tmp5.mul(tmp3);
        tmp5.recip();
        this.sub(tmp5);
        tmp3.mul(tmp4);
        tmp5.assign(1188);
        tmp5.mul(tmp3);
        tmp5.recip();
        this.add(tmp5);
        this.exp();
        if (divide) {
            this.div(tmp2);
        }
        if (negative) {
            Real.tmp5.mantissa = Real.tmp1.mantissa;
            Real.tmp5.exponent = Real.tmp1.exponent;
            Real.tmp5.sign = Real.tmp1.sign;
            this.mul(tmp5);
            tmp5.scalbn(-1);
            tmp5.frac();
            tmp5.mul(PI2);
            tmp5.sin();
            this.mul(tmp5);
            this.recip();
            this.mul(PI);
            this.neg();
        }
    }

    private void erfc1Internal() {
        long extra = 0L;
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        long tmp1Extra = 0L;
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        long tmp2Extra = tmp2.mul128(0L, tmp2, 0L);
        tmp2.neg();
        Real.tmp3.mantissa = Real.ONE.mantissa;
        Real.tmp3.exponent = Real.ONE.exponent;
        Real.tmp3.sign = Real.ONE.sign;
        long tmp3Extra = 0L;
        int i = 1;
        do {
            tmp1Extra = tmp1.mul128(tmp1Extra, tmp2, tmp2Extra);
            tmp4.assign(i);
            tmp3Extra = tmp3.mul128(tmp3Extra, tmp4, 0L);
            tmp4.assign(2 * i + 1);
            long tmp4Extra = tmp4.mul128(0L, tmp3, tmp3Extra);
            tmp4Extra = tmp4.recip128(tmp4Extra);
            tmp4Extra = tmp4.mul128(tmp4Extra, tmp1, tmp1Extra);
            extra = this.add128(extra, tmp4, tmp4Extra);
            ++i;
        } while (this.exponent - Real.tmp4.exponent < 128);
        Real.tmp1.sign = 1;
        Real.tmp1.exponent = 0x40000000;
        Real.tmp1.mantissa = 5203730428379116614L;
        extra = this.mul128(extra, tmp1, -5122205486241848926L);
        extra = this.add128(extra, ONE, 0L);
        this.roundFrom128(extra);
    }

    private void erfc2Internal() {
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.sqr();
        Real.tmp2.sign = 0;
        Real.tmp2.exponent = 0x40000000;
        Real.tmp2.mantissa = 6645080718195083435L;
        tmp2.mul(tmp1);
        tmp2.sub(HALF);
        int digits = tmp2.toInteger();
        if (digits > 64) {
            digits = 64;
        }
        tmp1.scalbn(1);
        int dxq = tmp1.toInteger() + 1;
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        this.recip();
        Real.tmp2.mantissa = this.mantissa;
        Real.tmp2.exponent = this.exponent;
        Real.tmp2.sign = this.sign;
        Real.tmp3.mantissa = this.mantissa;
        Real.tmp3.exponent = this.exponent;
        Real.tmp3.sign = this.sign;
        tmp3.sqr();
        tmp3.neg();
        tmp3.scalbn(-1);
        this.mantissa = Real.ONE.mantissa;
        this.exponent = Real.ONE.exponent;
        this.sign = Real.ONE.sign;
        Real.tmp4.mantissa = Real.ONE.mantissa;
        Real.tmp4.exponent = Real.ONE.exponent;
        Real.tmp4.sign = Real.ONE.sign;
        int i = 1;
        do {
            tmp4.mul(2 * i - 1);
            tmp4.mul(tmp3);
            this.add(tmp4);
        } while (Real.tmp4.exponent - 0x40000000 > -(digits + 2) && 2 * ++i - 1 < dxq);
        this.mul(tmp2);
        tmp1.sqr();
        tmp1.neg();
        tmp1.exp();
        this.mul(tmp1);
        Real.tmp1.sign = 0;
        Real.tmp1.exponent = 0x3FFFFFFF;
        Real.tmp1.mantissa = 5203730428379116615L;
        this.mul(tmp1);
    }

    public void erfc() {
        if (this.exponent < 0 && this.mantissa != 0L) {
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.mantissa = Real.ONE.mantissa;
            this.exponent = Real.ONE.exponent;
            this.sign = Real.ONE.sign;
            return;
        }
        if (this.exponent < 0 && this.mantissa == 0L || this.toInteger() > 27281) {
            if (this.sign != 0) {
                this.mantissa = Real.TWO.mantissa;
                this.exponent = Real.TWO.exponent;
                this.sign = Real.TWO.sign;
            } else {
                this.makeZero(0);
            }
            return;
        }
        byte s = this.sign;
        this.sign = 0;
        Real.tmp1.sign = 0;
        Real.tmp1.exponent = 0x40000002;
        Real.tmp1.mantissa = 6271892985061247549L;
        if (this.lessThan(tmp1)) {
            this.erfc1Internal();
        } else {
            this.erfc2Internal();
        }
        if (s != 0) {
            this.neg();
            this.add(TWO);
        }
    }

    public void inverfc() {
        if (this.exponent < 0 && this.mantissa != 0L || this.sign != 0 || this.greaterThan(TWO)) {
            this.makeNan();
            return;
        }
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.makeInfinity(0);
            return;
        }
        if (this.equalTo(TWO)) {
            this.makeInfinity(1);
            return;
        }
        int sign = ONE.compare(this);
        if (sign == 0) {
            this.makeZero();
            return;
        }
        if (sign < 0) {
            this.neg();
            this.add(TWO);
        }
        this.scalbn(-1);
        Real.tmp1.mantissa = this.mantissa;
        Real.tmp1.exponent = this.exponent;
        Real.tmp1.sign = this.sign;
        tmp1.ln();
        tmp1.mul(-2);
        tmp1.sqrt();
        Real.tmp2.sign = 1;
        Real.tmp2.exponent = 0x3FFFFFF1;
        Real.tmp2.mantissa = 6855247258937034356L;
        tmp2.mul(tmp1);
        Real.tmp3.sign = 1;
        Real.tmp3.exponent = 0x3FFFFFFA;
        Real.tmp3.mantissa = 6027841387605573141L;
        tmp2.add(tmp3);
        tmp2.mul(tmp1);
        Real.tmp3.sign = 1;
        Real.tmp3.exponent = 0x3FFFFFFE;
        Real.tmp3.mantissa = 6313252218678351859L;
        tmp2.add(tmp3);
        tmp2.mul(tmp1);
        tmp2.add(-1);
        tmp2.mul(tmp1);
        Real.tmp3.sign = 1;
        Real.tmp3.exponent = 0x3FFFFFFE;
        Real.tmp3.mantissa = 5944139188529585484L;
        tmp2.add(tmp3);
        Real.tmp3.sign = 0;
        Real.tmp3.exponent = 0x3FFFFFF7;
        Real.tmp3.mantissa = 9104888011498593917L;
        tmp3.mul(tmp1);
        Real.tmp4.sign = 0;
        Real.tmp4.exponent = 0x3FFFFFFC;
        Real.tmp4.mantissa = 7639737715163766952L;
        tmp3.add(tmp4);
        tmp3.mul(tmp1);
        Real.tmp4.sign = 0;
        Real.tmp4.exponent = 0x3FFFFFFF;
        Real.tmp4.mantissa = 4898564823463317188L;
        tmp3.add(tmp4);
        tmp3.mul(tmp1);
        Real.tmp4.sign = 0;
        Real.tmp4.exponent = 0x3FFFFFFF;
        Real.tmp4.mantissa = 5428706798711650965L;
        tmp3.add(tmp4);
        tmp3.mul(tmp1);
        Real.tmp4.sign = 0;
        Real.tmp4.exponent = 0x3FFFFFFC;
        Real.tmp4.mantissa = 7330622655237541986L;
        tmp3.add(tmp4);
        tmp2.div(tmp3);
        tmp1.add(tmp2);
        tmp1.neg();
        Real.sqrtTmp.mantissa = Real.tmp1.mantissa;
        Real.sqrtTmp.exponent = Real.tmp1.exponent;
        Real.sqrtTmp.sign = Real.tmp1.sign;
        Real.tmp5.mantissa = Real.sqrtTmp.mantissa;
        Real.tmp5.exponent = Real.sqrtTmp.exponent;
        Real.tmp5.sign = Real.sqrtTmp.sign;
        tmp5.mul(SQRT1_2);
        tmp5.neg();
        tmp5.erfc();
        tmp5.scalbn(-1);
        tmp5.sub(this);
        Real.tmp3.mantissa = Real.sqrtTmp.mantissa;
        Real.tmp3.exponent = Real.sqrtTmp.exponent;
        Real.tmp3.sign = Real.sqrtTmp.sign;
        tmp3.sqr();
        tmp3.scalbn(-1);
        tmp3.exp();
        tmp5.mul(tmp3);
        Real.tmp3.sign = 0;
        Real.tmp3.exponent = 0x40000001;
        Real.tmp3.mantissa = 5779891283755275865L;
        tmp5.mul(tmp3);
        this.mantissa = Real.sqrtTmp.mantissa;
        this.exponent = Real.sqrtTmp.exponent;
        this.sign = Real.sqrtTmp.sign;
        this.mul(tmp5);
        this.scalbn(-1);
        this.add(ONE);
        this.rdiv(tmp5);
        this.neg();
        this.add(sqrtTmp);
        this.mul(SQRT1_2);
        if (sign > 0) {
            this.neg();
        }
    }

    private static int floorDiv(int a, int b) {
        if (a >= 0) {
            return a / b;
        }
        return -((-a + b - 1) / b);
    }

    private static int floorMod(int a, int b) {
        if (a >= 0) {
            return a % b;
        }
        return a + (-a + b - 1) / b * b;
    }

    private static boolean leap_gregorian(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private static int gregorian_to_jd(int year, int month, int day) {
        return 365 + 365 * (year - 1) + Real.floorDiv(year - 1, 4) + -Real.floorDiv(year - 1, 100) + Real.floorDiv(year - 1, 400) + ((367 * month - 362) / 12 + (month <= 2 ? 0 : (Real.leap_gregorian(year) ? -1 : -2)) + day);
    }

    private static int jd_to_gregorian(int jd) {
        int wjd = jd;
        int depoch = wjd - 366;
        int quadricent = Real.floorDiv(depoch, 146097);
        int dqc = Real.floorMod(depoch, 146097);
        int cent = Real.floorDiv(dqc, 36524);
        int dcent = Real.floorMod(dqc, 36524);
        int quad = Real.floorDiv(dcent, 1461);
        int dquad = Real.floorMod(dcent, 1461);
        int yindex = Real.floorDiv(dquad, 365);
        int year = quadricent * 400 + cent * 100 + quad * 4 + yindex;
        if (cent != 4 && yindex != 4) {
            ++year;
        }
        int yearday = wjd - Real.gregorian_to_jd(year, 1, 1);
        int leapadj = wjd < Real.gregorian_to_jd(year, 3, 1) ? 0 : (Real.leap_gregorian(year) ? 1 : 2);
        int month = Real.floorDiv((yearday + leapadj) * 12 + 373, 367);
        int day = wjd - Real.gregorian_to_jd(year, month, 1) + 1;
        return (year * 100 + month) * 100 + day;
    }

    public void toDHMS() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        boolean negative = this.sign != 0;
        this.abs();
        long h = this.toLong();
        this.frac();
        tmp1.assign(60);
        this.mul(tmp1);
        int m = this.toInteger();
        this.frac();
        this.mul(tmp1);
        Real.tmp2.mantissa = Real.ONE.mantissa;
        Real.tmp2.exponent = Real.ONE.exponent;
        Real.tmp2.sign = Real.ONE.sign;
        tmp2.scalbn(-16);
        this.add(tmp2);
        if (this.compare(tmp1) >= 0) {
            this.mantissa = Real.ZERO.mantissa;
            this.exponent = Real.ZERO.exponent;
            this.sign = Real.ZERO.sign;
            if (++m >= 60) {
                m -= 60;
                ++h;
            }
        } else {
            this.sub(tmp2);
        }
        int D = (int)(h / 24L);
        h %= 24L;
        if (D >= 366) {
            D = Real.jd_to_gregorian(D);
        }
        this.add(m * 100);
        this.div(10000);
        tmp1.assign((long)D * 100L + h);
        this.add(tmp1);
        if (negative) {
            this.neg();
        }
    }

    public void fromDHMS() {
        if (this.exponent < 0 || this.mantissa == 0L) {
            return;
        }
        boolean negative = this.sign != 0;
        this.abs();
        long h = this.toLong();
        this.frac();
        tmp1.assign(100);
        this.mul(tmp1);
        int m = this.toInteger();
        this.frac();
        this.mul(tmp1);
        Real.tmp2.mantissa = Real.ONE.mantissa;
        Real.tmp2.exponent = Real.ONE.exponent;
        Real.tmp2.sign = Real.ONE.sign;
        tmp2.scalbn(-10);
        this.add(tmp2);
        if (this.compare(tmp1) >= 0) {
            this.mantissa = Real.ZERO.mantissa;
            this.exponent = Real.ZERO.exponent;
            this.sign = Real.ZERO.sign;
            if (++m >= 100) {
                m -= 100;
                ++h;
            }
        } else {
            this.sub(tmp2);
        }
        int D = (int)(h / 100L);
        h %= 100L;
        if (D >= 10000) {
            int M = D / 100;
            if ((D %= 100) == 0) {
                D = 1;
            }
            int Y = M / 100;
            if ((M %= 100) == 0) {
                M = 1;
            }
            D = Real.gregorian_to_jd(Y, M, D);
        }
        this.add(m * 60);
        this.div(3600);
        tmp1.assign((long)D * 24L + h);
        this.add(tmp1);
        if (negative) {
            this.neg();
        }
    }

    public void time() {
        long now = System.currentTimeMillis();
        int s = (int)((now /= 1000L) % 60L);
        int m = (int)((now /= 60L) % 60L);
        int h = (int)((now /= 60L) % 24L);
        this.assign((h * 100 + m) * 100 + s);
        this.div(10000);
    }

    public void date() {
        long now = System.currentTimeMillis();
        now /= 86400000L;
        this.assign(now *= 24L);
        this.add(17268672);
        this.toDHMS();
    }

    private static void advanceBit() {
        randSeedA = randSeedA << 1 ^ (long)(randSeedA < 0L ? 27 : 0);
        randSeedB = randSeedB << 1 ^ (randSeedB < 0L ? -5764607523034234879L : 0L);
    }

    private static long nextBits(int bits) {
        long answer = 0L;
        while (bits-- > 0) {
            while (randSeedA >= 0L) {
                Real.advanceBit();
            }
            answer = (answer << 1) + (long)(randSeedB < 0L ? 1 : 0);
            Real.advanceBit();
        }
        return answer;
    }

    public static void accumulateRandomness(long seed) {
        randSeedA ^= seed & 0x5555555555555555L;
        randSeedB ^= seed & 0xAAAAAAAAAAAAAAAAL;
        Real.nextBits(63);
    }

    public void random() {
        this.sign = 0;
        this.exponent = 0x3FFFFFFF;
        while (Real.nextBits(1) == 0L) {
            --this.exponent;
        }
        this.mantissa = 0x4000000000000000L + Real.nextBits(62);
    }

    private int digit(char a, int base, boolean twosComplement) {
        int digit = -1;
        if (a >= '0' && a <= '9') {
            digit = a - 48;
        } else if (a >= 'A' && a <= 'F') {
            digit = a - 65 + 10;
        }
        if (digit >= base) {
            return -1;
        }
        if (twosComplement) {
            digit ^= base - 1;
        }
        return digit;
    }

    private void shiftUp(int base) {
        if (base == 2) {
            this.scalbn(1);
        } else if (base == 8) {
            this.scalbn(3);
        } else if (base == 16) {
            this.scalbn(4);
        } else {
            this.mul10();
        }
    }

    private void atof(String a, int base) {
        int d;
        int index;
        this.makeZero();
        int length = a.length();
        byte tmpSign = 0;
        boolean compl = false;
        for (index = 0; index < length && a.charAt(index) == ' '; ++index) {
        }
        if (index < length && a.charAt(index) == '-') {
            tmpSign = 1;
            ++index;
        } else if (index < length && a.charAt(index) == '+') {
            ++index;
        } else if (index < length && a.charAt(index) == '/') {
            compl = true;
            tmpSign = 1;
            ++index;
        }
        while (index < length && (d = this.digit(a.charAt(index), base, compl)) >= 0) {
            this.shiftUp(base);
            this.add(d);
            ++index;
        }
        int exp = 0;
        if (index < length && (a.charAt(index) == '.' || a.charAt(index) == ',')) {
            ++index;
            while (index < length && (d = this.digit(a.charAt(index), base, compl)) >= 0) {
                this.shiftUp(base);
                this.add(d);
                --exp;
                ++index;
            }
        }
        if (compl) {
            this.add(ONE);
        }
        while (index < length && a.charAt(index) == ' ') {
            ++index;
        }
        if (index < length && (a.charAt(index) == 'e' || a.charAt(index) == 'E')) {
            int exp2 = 0;
            boolean expNeg = false;
            if (++index < length && a.charAt(index) == '-') {
                expNeg = true;
                ++index;
            } else if (index < length && a.charAt(index) == '+') {
                ++index;
            }
            while (index < length && a.charAt(index) >= '0' && a.charAt(index) <= '9') {
                if (exp2 < 400000000) {
                    exp2 = exp2 * 10 + a.charAt(index) - 48;
                }
                ++index;
            }
            if (expNeg) {
                exp2 = -exp2;
            }
            exp += exp2;
        }
        if (base == 2) {
            this.scalbn(exp);
        } else if (base == 8) {
            this.scalbn(exp * 3);
        } else if (base == 16) {
            this.scalbn(exp * 4);
        } else {
            if (exp > 300000000 || exp < -300000000) {
                Real.tmp1.mantissa = Real.TEN.mantissa;
                Real.tmp1.exponent = Real.TEN.exponent;
                Real.tmp1.sign = Real.TEN.sign;
                if (exp < 0) {
                    tmp1.pow(-exp / 2);
                    this.div(tmp1);
                } else {
                    tmp1.pow(exp / 2);
                    this.mul(tmp1);
                }
                exp -= exp / 2;
            }
            Real.tmp1.mantissa = Real.TEN.mantissa;
            Real.tmp1.exponent = Real.TEN.exponent;
            Real.tmp1.sign = Real.TEN.sign;
            if (exp < 0) {
                tmp1.pow(-exp);
                this.div(tmp1);
            } else if (exp > 0) {
                tmp1.pow(exp);
                this.mul(tmp1);
            }
        }
        this.sign = tmpSign;
    }

    private void normalizeDigits(byte[] digits, int nDigits, int base) {
        byte carry = 0;
        boolean isZero = true;
        for (int i = nDigits - 1; i >= 0; --i) {
            if (digits[i] != 0) {
                isZero = false;
            }
            int n = i;
            digits[n] = (byte)(digits[n] + carry);
            carry = 0;
            if (digits[i] < base) continue;
            int n2 = i;
            digits[n2] = (byte)(digits[n2] - base);
            carry = 1;
        }
        if (isZero) {
            this.exponent = 0;
            return;
        }
        if (carry != 0) {
            if (digits[nDigits - 1] >= base / 2) {
                int n = nDigits - 2;
                digits[n] = (byte)(digits[n] + 1);
            }
            System.arraycopy(digits, 0, digits, 1, nDigits - 1);
            digits[0] = carry;
            ++this.exponent;
            if (digits[nDigits - 1] >= base) {
                this.normalizeDigits(digits, nDigits, base);
            }
        }
        while (digits[0] == 0) {
            System.arraycopy(digits, 1, digits, 0, nDigits - 1);
            digits[nDigits - 1] = 0;
            --this.exponent;
        }
    }

    private int getDigits(byte[] digits, int base) {
        int bitsPerDigit;
        if (base == 10) {
            long a;
            Real.tmp1.mantissa = this.mantissa;
            Real.tmp1.exponent = this.exponent;
            Real.tmp1.sign = this.sign;
            tmp1.abs();
            Real.tmp2.mantissa = Real.tmp1.mantissa;
            Real.tmp2.exponent = Real.tmp1.exponent;
            Real.tmp2.sign = Real.tmp1.sign;
            int exp = this.exponent = tmp1.lowPow10();
            boolean exp_neg = (exp -= 18) <= 0;
            exp = Math.abs(exp);
            if (exp > 300000000) {
                Real.tmp1.mantissa = Real.TEN.mantissa;
                Real.tmp1.exponent = Real.TEN.exponent;
                Real.tmp1.sign = Real.TEN.sign;
                tmp1.pow(exp / 2);
                if (exp_neg) {
                    tmp2.mul(tmp1);
                } else {
                    tmp2.div(tmp1);
                }
                Real.tmp1.mantissa = Real.TEN.mantissa;
                Real.tmp1.exponent = Real.TEN.exponent;
                Real.tmp1.sign = Real.TEN.sign;
                tmp1.pow(exp - exp / 2);
            } else {
                Real.tmp1.mantissa = Real.TEN.mantissa;
                Real.tmp1.exponent = Real.TEN.exponent;
                Real.tmp1.sign = Real.TEN.sign;
                tmp1.pow(exp);
            }
            if (exp_neg) {
                tmp2.mul(tmp1);
            } else {
                tmp2.div(tmp1);
            }
            if (Real.tmp2.exponent > 1073741886) {
                --Real.tmp2.exponent;
                tmp2.round();
                a = tmp2.toLong();
                if (a >= 5000000000000000000L) {
                    ++this.exponent;
                    digits[18] = (byte)((a /= 5L) % 10L);
                    a /= 10L;
                } else {
                    digits[18] = (byte)(a % 5L * 2L);
                    a /= 5L;
                }
            } else {
                tmp2.round();
                a = tmp2.toLong();
                digits[18] = (byte)(a % 10L);
                a /= 10L;
            }
            for (int i = 17; i >= 0; --i) {
                digits[i] = (byte)(a % 10L);
                a /= 10L;
            }
            digits[19] = 0;
            return 19;
        }
        int accurateBits = 64;
        int n = base == 2 ? 1 : (bitsPerDigit = base == 8 ? 3 : 4);
        if (this.exponent == 0 && this.mantissa == 0L) {
            this.sign = 0;
        } else {
            if (this.sign != 0) {
                this.mantissa = -this.mantissa;
                if ((this.mantissa >> 62 & 3L) == 3L) {
                    this.mantissa <<= 1;
                    --this.exponent;
                    --accurateBits;
                }
            }
            this.exponent -= 0x3FFFFFFF;
            int shift = bitsPerDigit - 1 - Real.floorMod(this.exponent, bitsPerDigit);
            this.exponent = Real.floorDiv(this.exponent, bitsPerDigit);
            if (shift == bitsPerDigit - 1) {
                this.mantissa <<= 1;
                --this.exponent;
                --accurateBits;
            } else if (shift > 0) {
                this.mantissa = this.mantissa + (1L << shift - 1) >>> shift;
                if (this.sign != 0) {
                    this.mantissa |= Long.MIN_VALUE >> shift - 1;
                }
            }
        }
        int accurateDigits = (accurateBits + bitsPerDigit - 1) / bitsPerDigit;
        for (int i = 0; i < accurateDigits; ++i) {
            digits[i] = (byte)(this.mantissa >>> 64 - bitsPerDigit);
            this.mantissa <<= bitsPerDigit;
        }
        digits[accurateDigits] = 0;
        return accurateDigits;
    }

    private boolean carryWhenRounded(byte[] digits, int nDigits, int base) {
        int i;
        if (digits[nDigits] < base / 2) {
            return false;
        }
        for (i = nDigits - 1; i >= 0; --i) {
            if (digits[i] >= base - 1) continue;
            return false;
        }
        ++this.exponent;
        digits[0] = 1;
        for (i = 1; i < digits.length; ++i) {
            digits[i] = 0;
        }
        return true;
    }

    private void round(byte[] digits, int nDigits, int base) {
        if (digits[nDigits] >= base / 2) {
            int n = nDigits - 1;
            digits[n] = (byte)(digits[n] + 1);
            this.normalizeDigits(digits, nDigits, base);
        }
    }

    private String align(StringBuffer s, NumberFormat format) {
        block4: {
            block5: {
                block3: {
                    if (format.align != 1) break block3;
                    while (s.length() < format.maxwidth) {
                        s.append(' ');
                    }
                    break block4;
                }
                if (format.align != 2) break block5;
                while (s.length() < format.maxwidth) {
                    s.insert(0, ' ');
                }
                break block4;
            }
            if (format.align != 3) break block4;
            while (s.length() < format.maxwidth) {
                s.append(' ');
                if (s.length() >= format.maxwidth) continue;
                s.insert(0, ' ');
            }
        }
        return s.toString();
    }

    private String ftoa(NumberFormat format) {
        char prefixChar;
        int precision;
        int digitsPerThousand;
        ftoaBuf.setLength(0);
        if (this.exponent < 0 && this.mantissa != 0L) {
            ftoaBuf.append("nan");
            return this.align(ftoaBuf, format);
        }
        if (this.exponent < 0 && this.mantissa == 0L) {
            ftoaBuf.append(this.sign != 0 ? "-inf" : "inf");
            return this.align(ftoaBuf, format);
        }
        switch (format.base) {
            case 2: {
                digitsPerThousand = 8;
                break;
            }
            case 8: {
                digitsPerThousand = 1000;
                break;
            }
            case 16: {
                digitsPerThousand = 4;
                break;
            }
            default: {
                digitsPerThousand = 3;
            }
        }
        if (format.thousand == '\u0000') {
            digitsPerThousand = 1000;
        }
        Real.tmp4.mantissa = this.mantissa;
        Real.tmp4.exponent = this.exponent;
        Real.tmp4.sign = this.sign;
        int accurateDigits = tmp4.getDigits(ftoaDigits, format.base);
        if (!(format.base != 10 || this.exponent <= 1073741886 && this.isIntegral())) {
            accurateDigits = 16;
        }
        int pointPos = 0;
        do {
            int width = format.maxwidth - 1;
            int prefix = 0;
            if (format.base != 10) {
                prefix = 1;
            } else if (Real.tmp4.sign != 0) {
                --width;
            }
            boolean useExp = false;
            switch (format.fse) {
                case 2: {
                    precision = format.precision + 1;
                    useExp = true;
                    break;
                }
                case 3: {
                    pointPos = Real.floorMod(Real.tmp4.exponent, 3);
                    precision = format.precision + 1 + pointPos;
                    useExp = true;
                    break;
                }
                default: {
                    precision = 1000;
                    if (format.fse == 1) {
                        precision = format.precision + 1;
                    }
                    if (Real.tmp4.exponent + 1 > width - (Real.tmp4.exponent + prefix) / digitsPerThousand - prefix + (format.removePoint ? 1 : 0) || Real.tmp4.exponent + 1 > accurateDigits || -Real.tmp4.exponent >= width || -Real.tmp4.exponent >= precision) {
                        useExp = true;
                        break;
                    }
                    pointPos = Real.tmp4.exponent;
                    precision += Real.tmp4.exponent;
                    if (Real.tmp4.exponent > 0) {
                        width -= (Real.tmp4.exponent + prefix) / digitsPerThousand;
                    }
                    if (!format.removePoint || Real.tmp4.exponent != width - prefix) break;
                    ++width;
                }
            }
            if (prefix != 0 && pointPos >= 0) {
                width -= prefix;
            }
            ftoaExp.setLength(0);
            if (useExp) {
                ftoaExp.append('e');
                ftoaExp.append(Real.tmp4.exponent - pointPos);
                width -= ftoaExp.length();
            }
            if (precision > accurateDigits) {
                precision = accurateDigits;
            }
            if (precision > width) {
                precision = width;
            }
            if (precision > width + pointPos) {
                precision = width + pointPos;
            }
            if (precision > 0) continue;
            precision = 1;
        } while (tmp4.carryWhenRounded(ftoaDigits, precision, format.base));
        tmp4.round(ftoaDigits, precision, format.base);
        if (Real.tmp4.sign != 0 && format.base == 10) {
            ftoaBuf.append('-');
        }
        int pointPos2 = pointPos < 0 ? 0 : pointPos;
        char c = prefixChar = format.base == 10 || Real.tmp4.sign == 0 ? (char)'0' : hexChar.charAt(format.base - 1);
        if (pointPos < 0) {
            ftoaBuf.append(prefixChar);
            ftoaBuf.append(format.point);
            while (pointPos < -1) {
                ftoaBuf.append(prefixChar);
                ++pointPos;
            }
        }
        for (int i = 0; i < precision; ++i) {
            ftoaBuf.append(hexChar.charAt(ftoaDigits[i]));
            if (pointPos > 0 && pointPos % digitsPerThousand == 0) {
                ftoaBuf.append(format.thousand);
            }
            if (pointPos == 0) {
                ftoaBuf.append(format.point);
            }
            --pointPos;
        }
        if (format.fse == 0) {
            while (ftoaBuf.charAt(ftoaBuf.length() - 1) == '0') {
                ftoaBuf.setLength(ftoaBuf.length() - 1);
            }
        }
        if (format.removePoint && ftoaBuf.charAt(ftoaBuf.length() - 1) == format.point) {
            ftoaBuf.setLength(ftoaBuf.length() - 1);
        }
        ftoaBuf.append((Object)ftoaExp);
        if (format.base != 10) {
            while (ftoaBuf.length() < format.maxwidth) {
                if (++pointPos2 > 0 && pointPos2 % digitsPerThousand == 0) {
                    ftoaBuf.insert(0, format.thousand);
                }
                if (ftoaBuf.length() >= format.maxwidth) continue;
                ftoaBuf.insert(0, prefixChar);
            }
            if (ftoaBuf.charAt(0) == format.thousand) {
                ftoaBuf.deleteCharAt(0);
            }
        }
        return this.align(ftoaBuf, format);
    }

    public String toString() {
        Real.tmpFormat.base = 10;
        return this.ftoa(tmpFormat);
    }

    public String toString(int base) {
        Real.tmpFormat.base = base;
        return this.ftoa(tmpFormat);
    }

    public String toString(NumberFormat format) {
        return this.ftoa(format);
    }

    public static class NumberFormat {
        public int base = 10;
        public int maxwidth = 30;
        public int precision = 16;
        public int fse = 0;
        public char point = (char)46;
        public boolean removePoint = true;
        public char thousand = '\u0000';
        public int align = 0;
        public static final int FSE_NONE = 0;
        public static final int FSE_FIX = 1;
        public static final int FSE_SCI = 2;
        public static final int FSE_ENG = 3;
        public static final int ALIGN_NONE = 0;
        public static final int ALIGN_LEFT = 1;
        public static final int ALIGN_RIGHT = 2;
        public static final int ALIGN_CENTER = 3;
    }
}

