/*
 * Decompiled with CFR 0.152.
 */
package btchat;

import btchat.BTListener;
import btchat.ChatPacket;
import btchat.EndPoint;
import btchat.InputUI;
import btchat.MessageUI;
import btchat.NameUI;
import btchat.NetLayer;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class ChatMain
extends MIDlet
implements BTListener,
CommandListener {
    public static ChatMain instance;
    public static Display display;
    public static boolean isDebug;
    public InputUI inputui;
    public MessageUI messageui;
    public NameUI nameui;
    public NetLayer btnet;

    public ChatMain() {
        instance = this;
    }

    public void startApp() {
        ChatMain.log("invoke startApp()");
        display = Display.getDisplay((MIDlet)this);
        this.inputui = new InputUI();
        this.messageui = new MessageUI();
        this.nameui = new NameUI();
        display.setCurrent((Displayable)this.nameui);
    }

    public void pauseApp() {
        ChatMain.log("invoke pauseApp()");
    }

    public void destroyApp(boolean bl) {
        ChatMain.log("invoke destroyApp()");
    }

    public static void quitApp() {
        instance.destroyApp(true);
        instance.notifyDestroyed();
        instance = null;
        display = null;
    }

    public void handleAction(String string, Object object, Object object2) {
        ChatMain.log("invoke handleAction. action=" + string);
        if (string.equals("join")) {
            EndPoint endPoint = (EndPoint)object;
            String string2 = endPoint.remoteName + " joins the chat room";
            ChatPacket chatPacket = new ChatPacket(0, endPoint.remoteName, string2);
            this.messageui.msgs.addElement(chatPacket);
            this.messageui.repaint();
        } else if (!string.equals("sent")) {
            if (string.equals("received")) {
                EndPoint endPoint = (EndPoint)object;
                ChatPacket chatPacket = (ChatPacket)object2;
                this.messageui.msgs.addElement(chatPacket);
                this.messageui.repaint();
            } else if (string.equals("leave")) {
                EndPoint endPoint = (EndPoint)object;
                String string3 = endPoint.remoteName + " leaves the chat room";
                ChatPacket chatPacket = new ChatPacket(3, endPoint.remoteName, string3);
                this.messageui.msgs.addElement(chatPacket);
                this.messageui.repaint();
            }
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        ChatMain.log("invoke commandAction. command=" + command.getLabel());
        if (displayable == this.inputui && command.getLabel().equals("Send")) {
            String string = this.inputui.getString();
            this.btnet.sendString(string);
            ChatPacket chatPacket = new ChatPacket(1, this.btnet.localName, string);
            this.messageui.msgs.addElement(chatPacket);
            display.setCurrent((Displayable)this.messageui);
            this.messageui.repaint();
        } else if (displayable == this.nameui && (command.getLabel().equals("Chat") || command.getLabel().equals("Chat (Debug)"))) {
            if (command.getLabel().equals("Chat (Debug)")) {
                isDebug = true;
            }
            this.btnet = new NetLayer();
            String string = this.nameui.text.getString();
            ChatMain.log("set local nick name to " + string);
            this.btnet.init(string, this);
            this.btnet.query();
            display.setCurrent((Displayable)this.messageui);
        } else if (displayable == this.inputui && command.getLabel().equals("Back")) {
            display.setCurrent((Displayable)this.messageui);
        } else if (displayable == this.messageui && command.getLabel().equals("Write")) {
            display.setCurrent((Displayable)this.inputui);
            this.inputui.showUI();
        } else if (displayable == this.messageui && command.getLabel().equals("Clear")) {
            this.messageui.msgs.removeAllElements();
            this.messageui.repaint();
        } else if (displayable == this.messageui && command.getLabel().equals("Exit")) {
            this.btnet.disconnect();
            ChatMain.quitApp();
        } else if (displayable == this.messageui && command.getLabel().equals("About BlueChat")) {
            Alert alert = new Alert("About", "BlueChat 1.0. By Ben Hui (c) 2004. Visit www.benhui.net for more mobile dev resources.", null, AlertType.INFO);
            alert.setTimeout(-2);
            display.setCurrent(alert, (Displayable)this.messageui);
        }
    }

    private static void log(String string) {
        System.out.println("ChatMain: " + string);
        if (isDebug) {
            ChatMain.gui_log("M", string);
        }
    }

    public static void gui_log(String string, String string2) {
        ChatPacket chatPacket = new ChatPacket(1, string, string2);
        ChatMain.instance.messageui.msgs.addElement(chatPacket);
        ChatMain.instance.messageui.repaint();
    }

    static {
        isDebug = false;
    }
}

