/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.boun;

import com.nokia.mid.appl.boun.BounceCanvas;
import com.nokia.mid.appl.boun.TileCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ball {
    private static final boolean CD_DEBUG = false;
    private boolean mDebugCD = false;
    public int xPos;
    public int yPos;
    public int globalBallX;
    public int globalBallY;
    public int xOffset;
    public int xSpeed;
    public int ySpeed;
    public int direction;
    public int ballSize;
    public int mHalfBallSize;
    public int respawnX;
    public int respawnY;
    public int ballState;
    public int jumpOffset;
    public int speedBonusCntr;
    public int gravBonusCntr;
    public int jumpBonusCntr;
    public boolean mGroundedFlag;
    public boolean mCDRubberFlag;
    public boolean mCDRampFlag;
    public boolean mCDEdgeFlag;
    public int slideCntr;
    public static final int MOVE_UP = 8;
    public static final int MOVE_DOWN = 4;
    public static final int MOVE_RIGHT = 2;
    public static final int MOVE_LEFT = 1;
    public static final int MOVE_STAT = 0;
    public static final int SMALL_SIZE_STATE = 0;
    public static final int LARGE_SIZE_STATE = 1;
    public static final int NORMAL_SIZE = 12;
    public static final int HALF_NORMAL_SIZE = 6;
    public static final int POPPED_SIZE = 12;
    public static final int HALF_POPPED_SIZE = 6;
    public static final int ENLARGED_SIZE = 16;
    public static final int HALF_ENLARGED_SIZE = 8;
    public static final int BALL_STATE_NORMAL = 0;
    public static final int BALL_STATE_DEAD = 1;
    public static final int BALL_STATE_POPPED = 2;
    public static final int POPPED_FRAMES = 5;
    public static final int BONUS_DURATION = 300;
    public static final int THIN_TILE_SIZE = 4;
    public static final byte[][] TRI_TILE_DATA = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
    public static final byte[][] SMALL_BALL_DATA = new byte[][]{{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0}};
    public static final byte[][] LARGE_BALL_DATA = new byte[][]{{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0}, {0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0}};
    public static final int JUMP_STRENGTH = -67;
    public static final int JUMP_STRENGTH_INC = -10;
    public static final int JUMP_BONUS_STRENGTH = -80;
    public static final int NORMAL_GRAVITY_ACCELL = 4;
    public static final int UWATER_GRAVITY_ACCELL = 6;
    public static final int LARGE_GRAVITY_ACCELL = 3;
    public static final int LARGE_UWATER_GRAVITY_ACCELL = -2;
    public static final int BASE_GRAVITY = 10;
    public static final int BOUNCE_NUMERATOR = -1;
    public static final int BOUNCE_DENOMINATOR = 2;
    public static final int ROOF_COLLISION_SPEED = 6;
    public static final int MIN_BOUNCE_SPEED = 10;
    public static final int MAX_HORZ_SPEED = 50;
    public static final int HORZ_ACCELL = 6;
    public static final int FRICTION_DECELL = 4;
    public static final int NORMAL_MAX_GRAVITY = 80;
    public static final int UWATER_MAX_GRAVITY = 42;
    public static final int LARGE_MAX_GRAVITY = 38;
    public static final int UWATER_LARGE_MAX_GRAVITY = -30;
    public static final int RING_POINTS = 500;
    public static final int GEM_POINTS = 200;
    public static final int LIFE_POINTS = 1000;
    public static final int EXIT_POINTS = 5000;
    public BounceCanvas myParent;
    public Image ballImage;
    public Image poppedImage;
    public Image largeBallImage;
    public Image smallBallImage;
    private int popCntr;

    public Ball(int n, int n2, int n3, BounceCanvas bounceCanvas) {
        this.xPos = n;
        this.yPos = n2;
        this.globalBallX = 0;
        this.globalBallY = 0;
        this.xSpeed = 0;
        this.ySpeed = 0;
        this.xOffset = 0;
        this.myParent = bounceCanvas;
        this.jumpOffset = 0;
        this.mGroundedFlag = false;
        this.mCDRubberFlag = false;
        this.mCDRampFlag = false;
        this.popCntr = 0;
        this.speedBonusCntr = 0;
        this.gravBonusCntr = 0;
        this.jumpBonusCntr = 0;
        this.slideCntr = 0;
        this.ballState = 0;
        this.direction = 0;
        this.myParent.setBallImages(this);
        if (n3 == 0) {
            this.ballSize = 12;
            this.mHalfBallSize = 6;
            this.ballImage = this.smallBallImage;
        } else if (n3 == 1) {
            this.ballSize = 16;
            this.mHalfBallSize = 8;
            this.ballImage = this.largeBallImage;
        }
    }

    public void setRespawn(int n, int n2) {
        this.respawnX = n;
        this.respawnY = n2;
        this.myParent.mBallSize = this.ballSize == 16 ? 1 : 0;
    }

    public void setDirection(int n) {
        if (n == 8 || n == 4 || n == 2 || n == 1) {
            this.direction |= n;
        }
    }

    public void releaseDirection(int n) {
        if (n == 8 || n == 4 || n == 2 || n == 1) {
            this.direction &= ~n;
        }
    }

    public boolean collisionDetection(int n, int n2) {
        int n3 = 0;
        if (n2 < 0) {
            n3 = Math.abs(n2) / 12 + 1;
            n2 = 0;
        }
        int n4 = (n - this.mHalfBallSize) / 12;
        int n5 = (n2 - this.mHalfBallSize) / 12 - n3;
        this.globalBallX = n - this.mHalfBallSize;
        this.globalBallY = n2 - this.mHalfBallSize - n3 * 12;
        if (this.xPos < this.myParent.divisorLine) {
            this.globalBallX += this.myParent.tileX * 12;
            this.globalBallY += this.myParent.tileY * 12;
        } else {
            this.globalBallX += (this.myParent.divTileX - 13) * 12 - this.myParent.divisorLine;
            this.globalBallY += this.myParent.divTileY * 12;
        }
        int n6 = (n - 1 + this.mHalfBallSize) / 12 + 1;
        int n7 = (n2 - 1 + this.mHalfBallSize) / 12 + 1;
        boolean bl = true;
        int n8 = n4;
        while (n8 < n6) {
            int n9 = n5;
            while (n9 < n7) {
                if (n8 * 12 > 156) {
                    bl = this.testTile(this.myParent.tileY + n9, this.myParent.tileX + n8 - 13, bl);
                } else if (this.xPos < this.myParent.divisorLine) {
                    bl = this.testTile(this.myParent.tileY + n9, this.myParent.tileX + n8, bl);
                } else {
                    int n10 = this.myParent.divTileX - 13 - this.myParent.divisorLine / 12;
                    bl = this.testTile(this.myParent.divTileY + n9, n10 + n8, bl);
                }
                ++n9;
            }
            ++n8;
        }
        return bl;
    }

    public void enlargeBall() {
        int n = 2;
        this.ballSize = 16;
        this.mHalfBallSize = 8;
        this.ballImage = this.largeBallImage;
        boolean bl = false;
        while (!bl) {
            bl = true;
            if (this.collisionDetection(this.xPos, this.yPos - n)) {
                this.yPos -= n;
                continue;
            }
            if (this.collisionDetection(this.xPos - n, this.yPos - n)) {
                this.xPos -= n;
                this.yPos -= n;
                continue;
            }
            if (this.collisionDetection(this.xPos + n, this.yPos - n)) {
                this.xPos += n;
                this.yPos -= n;
                continue;
            }
            if (this.collisionDetection(this.xPos, this.yPos + n)) {
                this.yPos += n;
                continue;
            }
            if (this.collisionDetection(this.xPos - n, this.yPos + n)) {
                this.xPos -= n;
                this.yPos += n;
                continue;
            }
            if (this.collisionDetection(this.xPos + n, this.yPos + n)) {
                this.xPos += n;
                this.yPos += n;
                continue;
            }
            bl = false;
            ++n;
        }
    }

    public void shrinkBall() {
        int n = 2;
        this.ballSize = 12;
        this.mHalfBallSize = 6;
        this.ballImage = this.smallBallImage;
        if (this.collisionDetection(this.xPos, this.yPos + n)) {
            this.yPos += n;
        } else if (this.collisionDetection(this.xPos, this.yPos - n)) {
            this.yPos -= n;
        }
    }

    public void popBall() {
        if (!this.myParent.mInvincible) {
            this.popCntr = 5;
            this.ballState = 2;
            this.xOffset = 0;
            --this.myParent.numLives;
            this.speedBonusCntr = 0;
            this.gravBonusCntr = 0;
            this.jumpBonusCntr = 0;
            this.myParent.mPaintUIFlag = true;
            this.myParent.mSoundPop.play(1);
        }
    }

    public void addRing() {
        this.myParent.add2Score(500);
        ++this.myParent.numRings;
        this.myParent.mPaintUIFlag = true;
    }

    public void redirectBall(int n) {
        int n2 = this.xSpeed;
        switch (n) {
            case 31: 
            case 33: 
            case 35: 
            case 37: {
                this.xSpeed = this.ySpeed;
                this.ySpeed = n2;
                break;
            }
            case 30: 
            case 32: 
            case 34: 
            case 36: {
                this.xSpeed = -this.ySpeed;
                this.ySpeed = -n2;
            }
        }
    }

    public boolean squareCollide(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n2 * 12;
        int n8 = n * 12;
        int n9 = this.globalBallX - n7;
        int n10 = this.globalBallY - n8;
        if (n9 >= 0) {
            n6 = n9;
            n5 = 12;
        } else {
            n6 = 0;
            n5 = this.ballSize + n9;
        }
        if (n10 >= 0) {
            n4 = n10;
            n3 = 12;
        } else {
            n4 = 0;
            n3 = this.ballSize + n10;
        }
        byte[][] byArray = this.ballSize == 16 ? LARGE_BALL_DATA : SMALL_BALL_DATA;
        if (n5 > 12) {
            n5 = 12;
        }
        if (n3 > 12) {
            n3 = 12;
        }
        int n11 = n6;
        while (n11 < n5) {
            int n12 = n4;
            while (n12 < n3) {
                if (byArray[n12 - n10][n11 - n9] != 0) {
                    return true;
                }
                ++n12;
            }
            ++n11;
        }
        return false;
    }

    public boolean triangleCollide(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n2 * 12;
        int n9 = n * 12;
        int n10 = this.globalBallX - n8;
        int n11 = this.globalBallY - n9;
        int n12 = 0;
        int n13 = 0;
        switch (n3) {
            case 30: 
            case 34: {
                n13 = 11;
                n12 = 11;
                break;
            }
            case 31: 
            case 35: {
                n13 = 11;
                break;
            }
            case 33: 
            case 37: {
                n12 = 11;
            }
        }
        if (n10 >= 0) {
            n7 = n10;
            n6 = 12;
        } else {
            n7 = 0;
            n6 = this.ballSize + n10;
        }
        if (n11 >= 0) {
            n5 = n11;
            n4 = 12;
        } else {
            n5 = 0;
            n4 = this.ballSize + n11;
        }
        byte[][] byArray = this.ballSize == 16 ? LARGE_BALL_DATA : SMALL_BALL_DATA;
        if (n6 > 12) {
            n6 = 12;
        }
        if (n4 > 12) {
            n4 = 12;
        }
        int n14 = n7;
        while (n14 < n6) {
            int n15 = n5;
            while (n15 < n4) {
                if ((TRI_TILE_DATA[Math.abs(n15 - n13)][Math.abs(n14 - n12)] & byArray[n15 - n11][n14 - n10]) != 0) {
                    if (!this.mGroundedFlag) {
                        this.redirectBall(n3);
                    }
                    return true;
                }
                ++n15;
            }
            ++n14;
        }
        return false;
    }

    public boolean thinCollide(int n, int n2, int n3) {
        int n4 = n2 * 12;
        int n5 = n * 12;
        int n6 = n4 + 12;
        int n7 = n5 + 12;
        switch (n3) {
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 43: 
            case 45: {
                n4 += 4;
                n6 -= 4;
                break;
            }
            case 4: 
            case 6: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 44: 
            case 46: {
                n5 += 4;
                n7 -= 4;
            }
        }
        return TileCanvas.rectCollide(this.globalBallX, this.globalBallY, this.globalBallX + this.ballSize, this.globalBallY + this.ballSize, n4, n5, n6, n7);
    }

    public boolean testTile(int n, int n2, boolean bl) {
        if (n >= this.myParent.mTileMapHeight || n < 0 || n2 >= this.myParent.mTileMapWidth || n2 < 0) {
            bl = false;
            return false;
        }
        if (this.ballState == 2) {
            return false;
        }
        int n3 = this.myParent.tileMap[n][n2] & 0xFFFFFFBF;
        switch (n3) {
            case 0: 
            case 8: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 1: {
                if (this.squareCollide(n, n2)) {
                    bl = false;
                    break;
                }
                this.mCDRampFlag = true;
                break;
            }
            case 2: {
                if (this.squareCollide(n, n2)) {
                    this.mCDRubberFlag = true;
                    bl = false;
                    break;
                }
                this.mCDRampFlag = true;
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                if (!this.triangleCollide(n, n2, n3)) break;
                this.mCDRubberFlag = true;
                bl = false;
                this.mCDRampFlag = true;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                if (!this.triangleCollide(n, n2, n3)) break;
                bl = false;
                this.mCDRampFlag = true;
                break;
            }
            case 10: {
                int n4;
                int n5;
                int n6 = this.myParent.findSpikeIndex(n2, n);
                if (n6 == -1 || !TileCanvas.rectCollide(this.globalBallX, this.globalBallY, this.globalBallX + this.ballSize, this.globalBallY + this.ballSize, n5 = this.myParent.mMOTopLeft[n6][0] * 12 + this.myParent.mMOOffset[n6][0], n4 = this.myParent.mMOTopLeft[n6][1] * 12 + this.myParent.mMOOffset[n6][1], n5 + 24, n4 + 24)) break;
                bl = false;
                this.popBall();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (!this.thinCollide(n, n2, n3)) break;
                bl = false;
                this.popBall();
                break;
            }
            case 7: {
                this.myParent.add2Score(200);
                this.myParent.tileMap[this.respawnY][this.respawnX] = 128;
                this.setRespawn(n2, n);
                this.myParent.tileMap[n][n2] = 136;
                this.myParent.mSoundPickup.play(1);
                break;
            }
            case 23: {
                if (!this.thinCollide(n, n2, n3)) break;
                this.addRing();
                this.myParent.tileMap[n][n2] = 155;
                this.myParent.tileMap[n][n2 + 1] = 156;
                this.myParent.mSoundHoop.play(1);
                break;
            }
            case 15: {
                if (!this.thinCollide(n, n2, n3)) break;
                if (this.ballSize == 16) {
                    bl = false;
                    break;
                }
                this.addRing();
                this.myParent.tileMap[n][n2] = 147;
                this.myParent.tileMap[n][n2 + 1] = 148;
                this.myParent.mSoundHoop.play(1);
                break;
            }
            case 24: {
                if (!this.thinCollide(n, n2, n3)) break;
                this.addRing();
                this.myParent.tileMap[n][n2] = 156;
                this.myParent.tileMap[n][n2 - 1] = 155;
                break;
            }
            case 16: {
                if (!this.thinCollide(n, n2, n3)) break;
                if (this.ballSize == 16) {
                    bl = false;
                    break;
                }
                this.addRing();
                this.myParent.tileMap[n][n2] = 148;
                this.myParent.tileMap[n][n2 - 1] = 147;
                break;
            }
            case 21: {
                if (!this.thinCollide(n, n2, n3)) break;
                this.addRing();
                this.myParent.tileMap[n][n2] = 153;
                this.myParent.tileMap[n + 1][n2] = 154;
                this.myParent.mSoundHoop.play(1);
                break;
            }
            case 13: {
                if (!this.thinCollide(n, n2, n3)) break;
                if (this.ballSize == 16) {
                    bl = false;
                    break;
                }
                this.addRing();
                this.myParent.tileMap[n][n2] = 145;
                this.myParent.tileMap[n + 1][n2] = 146;
                this.myParent.mSoundHoop.play(1);
                break;
            }
            case 22: {
                if (!this.thinCollide(n, n2, n3)) break;
                this.addRing();
                this.myParent.tileMap[n][n2] = 154;
                this.myParent.tileMap[n - 1][n2] = 153;
                break;
            }
            case 14: {
                if (!this.thinCollide(n, n2, n3)) break;
                if (this.ballSize == 16) {
                    bl = false;
                    break;
                }
                this.addRing();
                this.myParent.tileMap[n][n2] = 146;
                this.myParent.tileMap[n - 1][n2] = 145;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                if (!this.thinCollide(n, n2, n3) || this.ballSize != 16) break;
                bl = false;
                break;
            }
            case 9: {
                if (!this.thinCollide(n, n2, n3) || !this.myParent.mOpenFlag) break;
                this.myParent.mExitFlag = true;
                this.myParent.mSoundPickup.play(1);
                break;
            }
            case 29: {
                this.myParent.add2Score(1000);
                if (this.myParent.numLives < 5) {
                    ++this.myParent.numLives;
                    this.myParent.mPaintUIFlag = true;
                }
                this.myParent.tileMap[n][n2] = 128;
                this.myParent.mSoundPickup.play(1);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                bl = false;
                if (this.ballSize != 16) break;
                this.shrinkBall();
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (!this.thinCollide(n, n2, n3)) break;
                bl = false;
                if (this.ballSize != 12) break;
                this.enlargeBall();
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.gravBonusCntr = 300;
                this.myParent.mSoundPickup.play(1);
                bl = false;
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                this.jumpBonusCntr = 300;
                this.myParent.mSoundPickup.play(1);
                bl = false;
                break;
            }
            case 38: {
                this.speedBonusCntr = 300;
                this.myParent.mSoundPickup.play(1);
                bl = false;
            }
        }
        return bl;
    }

    public void update() {
        int n;
        int n2;
        int n3 = this.xPos;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        if (this.ballState == 2) {
            this.xOffset = 0;
            --this.popCntr;
            if (this.popCntr == 0) {
                this.ballState = 1;
                if (this.myParent.numLives < 0) {
                    this.myParent.mExitFlag = true;
                }
            }
            return;
        }
        int n7 = this.xPos / 12;
        int n8 = this.yPos / 12;
        if (this.xPos >= 156) {
            n7 = this.myParent.tileX + n7 - 13;
            n8 = this.myParent.tileY + n8;
        } else if (this.xPos < this.myParent.divisorLine) {
            n7 = this.myParent.tileX + n7;
            n8 = this.myParent.tileY + n8;
        } else {
            n7 = this.myParent.divTileX - 13 - this.myParent.divisorLine / 12 + n7;
            n8 = this.myParent.divTileY + n8;
        }
        if ((this.myParent.tileMap[n8][n7] & 0x40) != 0) {
            if (this.ballSize == 16) {
                n5 = -30;
                n4 = -2;
                if (this.mGroundedFlag) {
                    this.ySpeed = -10;
                }
            } else {
                n5 = 42;
                n4 = 6;
            }
        } else if (this.ballSize == 16) {
            n5 = 38;
            n4 = 3;
        } else {
            n5 = 80;
            n4 = 4;
        }
        if (this.gravBonusCntr != 0) {
            bl = true;
            n5 *= -1;
            n4 *= -1;
            --this.gravBonusCntr;
            if (this.gravBonusCntr == 0) {
                bl = false;
                this.mGroundedFlag = false;
                n5 *= -1;
                n4 *= -1;
            }
        }
        if (this.jumpBonusCntr != 0) {
            if (-1 * Math.abs(this.jumpOffset) > -80) {
                this.jumpOffset = bl ? 80 : -80;
            }
            --this.jumpBonusCntr;
        }
        ++this.slideCntr;
        if (this.slideCntr == 3) {
            this.slideCntr = 0;
        }
        int n9 = 0;
        while (n9 < Math.abs(this.ySpeed) / 10) {
            n2 = 0;
            if (this.ySpeed != 0) {
                n2 = this.ySpeed / Math.abs(this.ySpeed);
            }
            if (this.collisionDetection(this.xPos, this.yPos + n2)) {
                this.yPos += n2;
                this.mGroundedFlag = false;
                if (n5 == -30 && (this.myParent.tileMap[n8 = this.myParent.tileY + this.yPos / 12][n7] & 0x40) == 0) {
                    this.ySpeed /= 2;
                    if (this.ySpeed <= 10 && this.ySpeed >= -10) {
                        this.ySpeed = 0;
                    }
                }
            } else {
                if (this.mCDRampFlag && this.xSpeed < 10 && this.slideCntr == 0) {
                    n = 1;
                    if (this.collisionDetection(this.xPos + n, this.yPos + n2)) {
                        this.xPos += n;
                        this.yPos += n2;
                        this.mCDRampFlag = false;
                    } else if (this.collisionDetection(this.xPos - n, this.yPos + n2)) {
                        this.xPos -= n;
                        this.yPos += n2;
                        this.mCDRampFlag = false;
                    }
                }
                if (n2 > 0 || bl && n2 < 0) {
                    this.ySpeed = this.ySpeed * -1 / 2;
                    this.mGroundedFlag = true;
                    if (this.mCDRubberFlag && (this.direction & 8) != 0) {
                        this.mCDRubberFlag = false;
                        this.jumpOffset = bl ? (this.jumpOffset += 10) : (this.jumpOffset += -10);
                    } else if (this.jumpBonusCntr == 0) {
                        this.jumpOffset = 0;
                    }
                    if (this.ySpeed < 10 && this.ySpeed > -10) {
                        this.ySpeed = bl ? -10 : 10;
                    }
                } else if (n2 < 0 || bl && n2 > 0) {
                    this.ySpeed = bl ? -6 : 6;
                }
            }
            ++n9;
        }
        if (bl) {
            if (n4 == -2 && this.ySpeed < n5) {
                this.ySpeed += n4;
                if (this.ySpeed > n5) {
                    this.ySpeed = n5;
                }
            } else if (!this.mGroundedFlag && this.ySpeed > n5) {
                this.ySpeed += n4;
                if (this.ySpeed < n5) {
                    this.ySpeed = n5;
                }
            }
        } else if (n4 == -2 && this.ySpeed > n5) {
            this.ySpeed += n4;
            if (this.ySpeed < n5) {
                this.ySpeed = n5;
            }
        } else if (!this.mGroundedFlag && this.ySpeed < n5) {
            this.ySpeed += n4;
            if (this.ySpeed > n5) {
                this.ySpeed = n5;
            }
        }
        if (this.speedBonusCntr != 0) {
            n6 = 100;
            --this.speedBonusCntr;
        } else {
            n6 = 50;
        }
        if ((this.direction & 2) != 0 && this.xSpeed < n6) {
            this.xSpeed += 6;
        } else if ((this.direction & 1) != 0 && this.xSpeed > -n6) {
            this.xSpeed -= 6;
        } else if (this.xSpeed > 0) {
            this.xSpeed -= 4;
        } else if (this.xSpeed < 0) {
            this.xSpeed += 4;
        }
        if (this.ballSize == 16 && this.jumpBonusCntr == 0) {
            this.jumpOffset = bl ? (this.jumpOffset += 5) : (this.jumpOffset += -5);
        }
        if (this.mGroundedFlag && (this.direction & 8) != 0) {
            this.ySpeed = bl ? 67 + this.jumpOffset : -67 + this.jumpOffset;
            this.mGroundedFlag = false;
        }
        n2 = Math.abs(this.xSpeed);
        n = n2 / 10;
        int n10 = 0;
        while (n10 < n) {
            int n11 = 0;
            if (this.xSpeed != 0) {
                int n12 = n11 = this.xSpeed < 0 ? -1 : 1;
            }
            if (this.collisionDetection(this.xPos + n11, this.yPos)) {
                this.xPos += n11;
            } else if (this.mCDRampFlag) {
                this.mCDRampFlag = false;
                int n13 = 0;
                n13 = bl ? 1 : -1;
                if (this.collisionDetection(this.xPos + n11, this.yPos + n13)) {
                    this.xPos += n11;
                    this.yPos += n13;
                } else if (this.collisionDetection(this.xPos + n11, this.yPos - n13)) {
                    this.xPos += n11;
                    this.yPos -= n13;
                }
            }
            ++n10;
        }
        this.xOffset = this.xPos - n3;
        if (this.xPos > 156 + this.ballSize) {
            this.xPos -= 156;
        }
        if (this.xPos - this.ballSize < 0) {
            this.xPos += 156;
        }
    }

    public void paint(Graphics graphics) {
        if (this.ballState == 2) {
            graphics.drawImage(this.poppedImage, this.xPos - 6, this.yPos - 6, 20);
            if (this.xPos > 144) {
                graphics.drawImage(this.poppedImage, this.xPos - 156 - 6, this.yPos - 6, 20);
            }
        } else {
            graphics.drawImage(this.ballImage, this.xPos - this.mHalfBallSize, this.yPos - this.mHalfBallSize, 20);
            if (this.xPos > 156 - this.ballSize) {
                graphics.drawImage(this.ballImage, this.xPos - 156 - this.mHalfBallSize, this.yPos - this.mHalfBallSize, 20);
            }
        }
        this.dirtyTiles();
    }

    public void dirtyTiles() {
        int n = (this.xPos - this.mHalfBallSize) / 12;
        int n2 = (this.yPos - this.mHalfBallSize) / 12;
        int n3 = (this.xPos - 1 + this.mHalfBallSize) / 12 + 1;
        int n4 = (this.yPos - 1 + this.mHalfBallSize) / 12 + 1;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n4 > 8) {
            n4 = 8;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        while (n7 < n3) {
            int n8 = n2;
            while (n8 < n4) {
                if (n7 * 12 >= 156) {
                    n5 = this.myParent.tileX + n7 - 13;
                    n6 = this.myParent.tileY + n8;
                } else if (this.xPos < this.myParent.divisorLine) {
                    n5 = this.myParent.tileX + n7;
                    n6 = this.myParent.tileY + n8;
                } else {
                    n5 = this.myParent.divTileX - 13 - this.myParent.divisorLine / 12 + n7;
                    n6 = this.myParent.divTileY + n8;
                }
                short[] sArray = this.myParent.tileMap[n6];
                int n9 = n5;
                sArray[n9] = (short)(sArray[n9] | 0x80);
                ++n8;
            }
            ++n7;
        }
    }
}

