/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.boun;

import com.nokia.mid.appl.boun.Ball;
import com.nokia.mid.appl.boun.BounceUI;
import com.nokia.mid.appl.boun.TileCanvas;
import com.nokia.mid.sound.Sound;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BounceCanvas
extends TileCanvas {
    public int mSplashIndex;
    public Image mSplashImage;
    private int mSplashTimer;
    protected Sound mSoundHoop = this.loadSound("/sounds/up.ott");
    protected Sound mSoundPickup = this.loadSound("/sounds/pickup.ott");
    protected Sound mSoundPop = this.loadSound("/sounds/pop.ott");
    private BounceUI mUI;
    public Ball myBall;
    public int numRings;
    public int numLives;
    public int mScore;
    public int bonusCntrValue;
    public int mLevelDisCntr;
    public boolean mExitFlag;
    public boolean mOpenExitFlag;
    public boolean mPaintUIFlag;
    public Image mFullScreenBuffer;
    public Graphics mFullScreenGraphics = null;
    public boolean mClearScreenFlag;
    private boolean mCheat = false;
    public boolean mInvincible = false;
    private int mCheatSeq = 0;
    private static final boolean MEM_FREE_DISPLAY = false;
    public static final int UI_X_OFFSET = 5;
    public static final int UI_LIVES_Y_OFFSET = 3;
    public static final int UI_RINGS_Y_OFFSET = 16;
    public static final int UI_COLOUR = 545706;
    public static final int BONUS_COLOUR = 16750611;
    public static final int TEXT_COLOUR = 0xFFFFFE;
    public static final Font TEXT_FONT = Font.getFont((int)32, (int)0, (int)8);
    public static final int SCORE_TEXT_POS_X = 64;
    public static final int SCORE_TEXT_POS_Y = 100;
    public static final int LEVEL_TEXT_POS_X = 44;
    public static final int LEVEL_TEXT_POS_Y = 84;
    public static final int BONUS_SEG_SIZE = 30;
    public static final int LEVEL_DISPLAY_TIME = 120;
    public static final int SPLASH_NONE = -1;
    public static final int SPLASH_NOKIA = 0;
    public static final int SPLASH_GAME = 1;
    private static final String[] SPLASH_NAME = new String[]{"/icons/nokiagames.png", "/icons/bouncesplash.png"};
    private static final int SPLASH_TIMER_DELAY = 30;
    public long mRepaintTime = 0L;
    public int mRepaintCount = 0;

    public BounceCanvas(BounceUI bounceUI, int n) {
        super(bounceUI.mDisplay);
        this.mUI = bounceUI;
        this.mFullScreenBuffer = Image.createImage((int)128, (int)128);
        this.mSplashIndex = 1;
        try {
            this.mSplashImage = Image.createImage((String)SPLASH_NAME[this.mSplashIndex]);
        }
        catch (IOException iOException) {
            this.mSplashImage = Image.createImage((int)1, (int)1);
        }
        this.start();
    }

    public void resetGame(int n) {
        this.mLevelNum = n;
        this.numRings = 0;
        this.numLives = 3;
        this.mScore = 0;
        this.mExitFlag = false;
        this.mOpenExitFlag = false;
        this.mClearScreenFlag = false;
        this.createNewLevel();
    }

    public void createNewLevel() {
        this.disposeLevel();
        this.loadLevel(this.mLevelNum);
        this.numRings = 0;
        this.mLevelDisCntr = 120;
        this.mPaintUIFlag = true;
        this.createBufferFocused(this.mStartPosX, this.mStartPosY);
    }

    public void createBufferFocused(int n, int n2) {
        if (n * 12 + 6 < 64) {
            this.scrollFlag = false;
            this.scrollOffset = 64;
            this.rightDrawEdge = 128;
            this.leftDrawEdge = 0;
            this.tileX = 0;
        } else if (n * 12 + 6 > this.mTileMapWidth * 12 - 64) {
            this.scrollFlag = false;
            this.scrollOffset = 92;
            this.rightDrawEdge = 156;
            this.leftDrawEdge = 28;
            this.tileX = this.mTileMapWidth - 13;
        } else {
            this.scrollFlag = true;
            this.scrollOffset = 0;
            this.rightDrawEdge = 143;
            this.leftDrawEdge = 15;
            this.tileX = n - 6;
        }
        this.divisorLine = 156;
        this.tileY = n2 / 7 * 7;
        this.divTileX = this.tileX + 13;
        this.divTileY = this.tileY;
        int n3 = 0;
        n3 = this.mBallSize == 1 ? 16 : 12;
        this.myBall = new Ball((n - this.tileX) * 12 + n3 / 2, (n2 - this.tileY) * 12 + n3 / 2, this.mBallSize, this);
        this.myBall.setRespawn(n, n2);
        if (this.mBallSize == 1 && !this.myBall.collisionDetection(this.myBall.xPos, this.myBall.yPos)) {
            int n4 = 4;
            if (this.myBall.collisionDetection(this.myBall.xPos - n4, this.myBall.yPos)) {
                this.myBall.xPos -= n4;
            } else if (this.myBall.collisionDetection(this.myBall.xPos, this.myBall.yPos - n4)) {
                this.myBall.yPos -= n4;
            } else if (this.myBall.collisionDetection(this.myBall.xPos - n4, this.myBall.yPos - n4)) {
                this.myBall.xPos -= n4;
                this.myBall.yPos -= n4;
            }
        }
        this.createNewBuffer();
    }

    public void checkData() {
        if (this.mLevelNum > this.mUI.mBestLevel) {
            this.mUI.mBestLevel = this.mLevelNum;
            this.mUI.setGameData(1);
        }
        if (this.mScore > this.mUI.mBestScore) {
            this.mUI.mBestScore = this.mScore;
            this.mUI.mNewBestScore = true;
            this.mUI.setGameData(2);
        }
        this.mUI.mLastScore = this.mScore;
    }

    public void screenFlip() {
        int n = this.myBall.xPos / 12;
        int n2 = this.myBall.xPos - n * 12 - 6;
        this.cleanBuffer(false);
        if (this.myBall.yPos < 0) {
            this.tileY -= 7;
            this.divTileY -= 7;
            this.myBall.yPos += 84;
        } else if (this.myBall.yPos > 96) {
            this.tileY += 7;
            this.divTileY += 7;
            this.myBall.yPos -= 84;
        }
        if (!this.scrollFlag && this.tileX - (13 - this.divisorLine / 12) == 0) {
            this.tileX = 0;
            this.leftDrawEdge = 0;
            this.rightDrawEdge = 128;
            if (this.myBall.xPos > this.divisorLine) {
                this.myBall.xPos -= this.divisorLine;
            }
            this.scrollOffset = 64;
        } else if (!this.scrollFlag) {
            this.tileX = this.mTileMapWidth - 13;
            this.leftDrawEdge = 28;
            this.rightDrawEdge = 156;
            this.myBall.xPos = this.myBall.xPos > this.divisorLine ? 156 - (this.divisorLine + 156 - this.myBall.xPos) : 156 - (this.divisorLine - this.myBall.xPos);
            this.scrollOffset = 92;
        } else {
            this.tileX = this.myBall.xPos > this.divisorLine ? this.tileX - 13 + n - 6 : this.tileX + n - 6;
            if (this.tileX < 0) {
                n2 += this.tileX * 12;
                this.tileX = 0;
            } else if (this.tileX > this.mTileMapWidth - 13 - 1) {
                n2 += (this.tileX - this.mTileMapWidth - 13 - 1) * 12;
                this.tileX = this.mTileMapWidth - 13 - 1;
            }
            this.leftDrawEdge = 14 + n2;
            this.rightDrawEdge = 142 + n2;
            this.myBall.xPos = 78 + n2;
        }
        this.divTileX = this.tileX + 13;
        this.divisorLine = 156;
        this.createNewBuffer();
    }

    public void add2Score(int n) {
        this.mScore += n;
        this.mPaintUIFlag = true;
    }

    public void paint2Buffer() {
        if (this.mFullScreenGraphics == null) {
            this.mFullScreenGraphics = this.mFullScreenBuffer.getGraphics();
        }
        if (this.myBall != null) {
            this.myBall.paint(this.bufferGraphics);
        }
        while (!this.hoopImageList.isEmpty()) {
            Image image = (Image)this.hoopImageList.firstElement();
            Integer n = (Integer)this.hoopXPosList.firstElement();
            Integer n2 = (Integer)this.hoopYPosList.firstElement();
            this.bufferGraphics.drawImage(image, n.intValue(), n2.intValue(), 20);
            this.hoopImageList.removeElementAt(0);
            this.hoopXPosList.removeElementAt(0);
            this.hoopYPosList.removeElementAt(0);
        }
        if (this.buffer != null) {
            if (this.leftDrawEdge < this.rightDrawEdge) {
                this.mFullScreenGraphics.drawImage(this.buffer, 0 - this.leftDrawEdge, 0, 20);
            } else {
                this.mFullScreenGraphics.drawImage(this.buffer, 0 - this.leftDrawEdge, 0, 20);
                this.mFullScreenGraphics.drawImage(this.buffer, 156 - this.leftDrawEdge, 0, 20);
            }
        }
        if (this.mLevelDisCntr != 0) {
            this.mFullScreenGraphics.setColor(0xFFFFFE);
            this.mFullScreenGraphics.setFont(TEXT_FONT);
            this.mFullScreenGraphics.drawString(this.mLevelNumStr, 44, 84, 20);
        }
        if (this.mPaintUIFlag) {
            this.mFullScreenGraphics.setColor(545706);
            this.mFullScreenGraphics.fillRect(0, 97, 128, 32);
            int n = 0;
            while (n < this.numLives) {
                this.mFullScreenGraphics.drawImage(this.mUILife, 5 + n * (this.mUILife.getWidth() - 1), 99, 20);
                ++n;
            }
            int n3 = 0;
            while (n3 < this.mTotalNumRings - this.numRings) {
                this.mFullScreenGraphics.drawImage(this.mUIRing, 5 + n3 * (this.mUIRing.getWidth() - 1), 112, 20);
                ++n3;
            }
            this.mFullScreenGraphics.setColor(0xFFFFFE);
            this.mFullScreenGraphics.drawString(BounceCanvas.zeroString(this.mScore), 64, 100, 20);
            if (this.bonusCntrValue != 0) {
                this.mFullScreenGraphics.setColor(16750611);
                this.mFullScreenGraphics.fillRect(1, 128 - 3 * this.bonusCntrValue / 30, 5, 128);
            }
            this.mPaintUIFlag = false;
        }
    }

    public void paint(Graphics graphics) {
        if (this.mSplashIndex != -1) {
            if (this.mSplashImage != null) {
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.mWidth, this.mHeight);
                graphics.drawImage(this.mSplashImage, this.mWidth / 2, this.mHeight / 2, 3);
            }
        } else if (this.mClearScreenFlag) {
            graphics.setColor(0);
            graphics.fillRect(0, 0, this.mWidth, this.mHeight);
            this.mClearScreenFlag = false;
        } else {
            graphics.drawImage(this.mFullScreenBuffer, 0, 0, 20);
        }
    }

    public void run() {
        if (this.mLoadLevelFlag) {
            this.createNewLevel();
            this.repaint();
            return;
        }
        if (this.mSplashIndex != -1) {
            if (this.mSplashImage == null || this.mSplashImage == null) {
                this.mUI.displayMainMenu();
            } else if (this.mSplashTimer > 30) {
                this.mSplashImage = null;
                Runtime.getRuntime().gc();
                switch (this.mSplashIndex) {
                    case 0: {
                        this.mSplashIndex = 1;
                        try {
                            this.mSplashImage = Image.createImage((String)SPLASH_NAME[this.mSplashIndex]);
                        }
                        catch (IOException iOException) {
                            this.mSplashImage = Image.createImage((int)1, (int)1);
                        }
                        this.repaint();
                        break;
                    }
                    case 1: {
                        this.mSplashIndex = -1;
                        this.mUI.displayMainMenu();
                    }
                }
                this.mSplashTimer = 0;
            } else {
                ++this.mSplashTimer;
            }
            this.repaint();
            return;
        }
        if (this.mLevelDisCntr != 0) {
            --this.mLevelDisCntr;
        }
        if (this.myBall.yPos < 0 || this.myBall.yPos > 96) {
            this.screenFlip();
        } else {
            this.cleanBuffer(true);
            this.myBall.update();
            this.testScroll(this.myBall.xPos, this.myBall.xOffset);
        }
        if (this.myBall.ballState == 1) {
            if (this.numLives < 0) {
                this.checkData();
                this.stop();
                this.mUI.displayGameOver();
                return;
            }
            this.createBufferFocused(this.myBall.respawnX, this.myBall.respawnY);
        }
        if (this.mNumMoveObj != 0) {
            this.updateMovingSpikeObj();
        }
        if (this.numRings == this.mTotalNumRings) {
            this.mOpenExitFlag = true;
        }
        if (this.mOpenExitFlag && this.mExitPos != -1) {
            int n = this.leftDrawEdge;
            int n2 = this.rightDrawEdge;
            if (this.mExitPos <= this.divisorLine) {
                if (this.leftDrawEdge > this.divisorLine) {
                    n = this.leftDrawEdge - 156;
                }
                if (this.rightDrawEdge > this.divisorLine) {
                    n2 = this.rightDrawEdge - 156;
                }
            }
            if (this.mExitPos > this.divisorLine) {
                if (this.leftDrawEdge < this.divisorLine) {
                    n = this.leftDrawEdge + 156;
                }
                if (this.rightDrawEdge < this.divisorLine) {
                    n2 = this.rightDrawEdge + 156;
                }
            }
            if (this.mExitPos >= n && this.mExitPos <= n2) {
                if (this.mOpenFlag) {
                    this.mExitPos = -1;
                    this.mOpenExitFlag = false;
                } else {
                    this.openExit();
                }
                short[] sArray = this.tileMap[this.mTopLeftTileRow];
                int n3 = this.mTopLeftTileCol;
                sArray[n3] = (short)(sArray[n3] | 0x80);
                this.cleanBuffer(true);
            }
        }
        this.bonusCntrValue = 0;
        if (this.myBall.speedBonusCntr != 0 || this.myBall.gravBonusCntr != 0 || this.myBall.jumpBonusCntr != 0) {
            if (this.myBall.speedBonusCntr > this.bonusCntrValue) {
                this.bonusCntrValue = this.myBall.speedBonusCntr;
            }
            if (this.myBall.gravBonusCntr > this.bonusCntrValue) {
                this.bonusCntrValue = this.myBall.gravBonusCntr;
            }
            if (this.myBall.jumpBonusCntr > this.bonusCntrValue) {
                this.bonusCntrValue = this.myBall.jumpBonusCntr;
            }
            if (this.bonusCntrValue % 30 == 0 || this.bonusCntrValue == 1) {
                this.mPaintUIFlag = true;
            }
        }
        this.scrollBuffer(this.myBall.xPos, this.myBall.xOffset, 16);
        this.paint2Buffer();
        this.repaint();
        if (this.mExitFlag) {
            this.mExitFlag = false;
            this.mLoadLevelFlag = true;
            ++this.mLevelNum;
            this.add2Score(5000);
            this.checkData();
            if (this.mLevelNum >= 11) {
                this.mUI.displayGameOver();
            } else {
                this.mUI.displayLevelComplete();
                this.mClearScreenFlag = true;
                this.repaint();
            }
        }
    }

    public void keyPressed(int n) {
        if (this.mSplashIndex != -1) {
            this.mSplashTimer = 31;
            return;
        }
        if (this.myBall == null) {
            return;
        }
        block0 : switch (n) {
            case 49: {
                if (!this.mCheat) break;
                this.mLoadLevelFlag = true;
                if (--this.mLevelNum >= 1) break;
                this.mLevelNum = 11;
                break;
            }
            case 51: {
                if (!this.mCheat) break;
                this.mLoadLevelFlag = true;
                if (++this.mLevelNum <= 11) break;
                this.mLevelNum = 1;
                break;
            }
            case 55: {
                if (this.mCheatSeq == 0 || this.mCheatSeq == 2) {
                    ++this.mCheatSeq;
                    break;
                }
                this.mCheatSeq = 0;
                break;
            }
            case 56: {
                if (this.mCheatSeq == 1 || this.mCheatSeq == 3) {
                    ++this.mCheatSeq;
                    break;
                }
                if (this.mCheatSeq == 5) {
                    this.mSoundHoop.play(1);
                    this.mInvincible = true;
                    this.mCheatSeq = 0;
                    break;
                }
                this.mCheatSeq = 0;
                break;
            }
            case 57: {
                if (this.mCheatSeq == 4) {
                    ++this.mCheatSeq;
                    break;
                }
                if (this.mCheatSeq == 5) {
                    this.mSoundPop.play(1);
                    this.mCheat = true;
                    this.mCheatSeq = 0;
                    break;
                }
                this.mCheatSeq = 0;
                break;
            }
            case -6: 
            case -5: {
                break;
            }
            case -7: {
                this.mUI.displayMainMenu();
                break;
            }
            default: {
                switch (this.getGameAction(n)) {
                    case 1: {
                        this.myBall.setDirection(8);
                        break block0;
                    }
                    case 6: {
                        this.myBall.setDirection(4);
                        break block0;
                    }
                    case 2: {
                        this.myBall.setDirection(1);
                        break block0;
                    }
                    case 5: {
                        this.myBall.setDirection(2);
                    }
                }
            }
        }
    }

    public void keyReleased(int n) {
        if (this.myBall == null) {
            return;
        }
        switch (this.getGameAction(n)) {
            case 1: {
                this.myBall.releaseDirection(8);
                break;
            }
            case 6: {
                this.myBall.releaseDirection(4);
                break;
            }
            case 2: {
                this.myBall.releaseDirection(1);
                break;
            }
            case 5: {
                this.myBall.releaseDirection(2);
            }
        }
    }

    public static String zeroString(int n) {
        String string = n < 100 ? "0000000" : (n < 1000 ? "00000" : (n < 10000 ? "0000" : (n < 100000 ? "000" : (n < 1000000 ? "00" : (n < 10000000 ? "0" : "")))));
        return string + n;
    }

    protected Sound loadSound(String string) {
        byte[] byArray = new byte[100];
        Sound sound = null;
        DataInputStream dataInputStream = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(string));
        try {
            int n = dataInputStream.read(byArray);
            dataInputStream.close();
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            sound = new Sound(byArray2, 1);
        }
        catch (IOException iOException) {
            System.out.println("loadSound for " + string + " failed: " + iOException.toString());
            sound = new Sound(1000, 500L);
            sound.play(3);
        }
        return sound;
    }
}

