/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.appl.boun;

import com.nokia.mid.appl.boun.Bounce;
import com.nokia.mid.appl.boun.BounceCanvas;
import com.nokia.mid.appl.boun.Local;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class BounceUI
implements CommandListener {
    public static final String RMS_NAME = "bounceRMS";
    public static final int RMS_LEVEL_DATA_RECORD_ID = 1;
    public static final int RMS_SCORE_DATA_RECORD_ID = 2;
    private static final int STATE_GAME_PLAYING = 1;
    private static final int STATE_START = 2;
    private static final int STATE_GAME_OVER = 3;
    private static final int STATE_GAME_STARTING = 5;
    private static boolean RESTART_IS_REQUIRED = true;
    private static boolean RESTART_NOT_REQUIRED = false;
    private static final boolean OLD_HIGH_SCORE_STYLE = true;
    public Bounce mMidlet;
    public Display mDisplay;
    public BounceCanvas mCanvas;
    public int mState = 2;
    public int mBestLevel;
    public int mBestScore;
    public boolean mNewBestScore;
    public int mLastScore;
    private Command mOkayCmd;
    private Command mBackCmd;
    private Command mContinueCmd;
    private List mMainMenu;
    private Form mTextPage;
    private int mSavedMenuItem;
    private static int MAIN_MENU_CONTINUE = 0;
    private static int MAIN_MENU_NEW_GAME = 1;
    private static int MAIN_MENU_HIGH_SCORE = 2;
    private static int MAIN_MENU_INSTRUCTIONS = 3;
    private static int MAIN_MENU_COUNT = 4;
    private String[] mMainMenuItems = new String[MAIN_MENU_COUNT];

    public BounceUI(Bounce bounce) {
        this.mMidlet = bounce;
        this.getGameData();
        this.mCanvas = new BounceCanvas(this, 1);
        this.mCanvas.start();
        this.mDisplay = Display.getDisplay((MIDlet)this.mMidlet);
        this.mDisplay.setCurrent((Displayable)this.mCanvas);
        this.mMainMenuItems[BounceUI.MAIN_MENU_CONTINUE] = Local.getText(8);
        this.mMainMenuItems[BounceUI.MAIN_MENU_NEW_GAME] = Local.getText(16);
        this.mMainMenuItems[BounceUI.MAIN_MENU_HIGH_SCORE] = Local.getText(12);
        this.mMainMenuItems[BounceUI.MAIN_MENU_INSTRUCTIONS] = Local.getText(13);
    }

    public void displayMainMenu() {
        this.mMainMenu = new List(Local.getText(10), 3);
        if (this.mBackCmd == null) {
            this.mBackCmd = new Command(Local.getText(6), 2, 1);
        }
        if (this.mState == 1 || this.mBestLevel > 1) {
            this.mMainMenu.append(this.mMainMenuItems[0], null);
        }
        int n = 1;
        while (n < this.mMainMenuItems.length) {
            this.mMainMenu.append(this.mMainMenuItems[n], null);
            ++n;
        }
        this.mMainMenu.addCommand(this.mBackCmd);
        this.mMainMenu.setCommandListener((CommandListener)this);
        if (this.mCanvas.mSplashIndex != -1) {
            this.mCanvas.mSplashIndex = -1;
            this.mCanvas.mSplashImage = null;
        }
        this.mMainMenu.setSelectedIndex(this.mSavedMenuItem, true);
        this.mCanvas.stop();
        this.mDisplay.setCurrent((Displayable)this.mMainMenu);
    }

    public void displayGame(boolean bl, int n) {
        this.mDisplay.setCurrent((Displayable)this.mCanvas);
        if (bl) {
            this.mCanvas.resetGame(n);
        }
        this.mCanvas.start();
        this.mState = 1;
    }

    public void displayHighScore() {
        this.mTextPage = new Form(Local.getText(12));
        this.mTextPage.append(String.valueOf(this.mBestScore));
        this.mTextPage.addCommand(this.mBackCmd);
        this.mTextPage.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mTextPage);
    }

    public void displayInstructions() {
        this.mTextPage = new Form(Local.getText(13));
        this.mTextPage.append(Local.getText(0));
        this.mTextPage.append(Local.getText(1));
        this.mTextPage.append(Local.getText(2));
        this.mTextPage.append(Local.getText(3));
        this.mTextPage.append(Local.getText(4));
        this.mTextPage.append(Local.getText(5));
        this.mTextPage.addCommand(this.mBackCmd);
        this.mTextPage.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mTextPage);
        this.mTextPage = null;
    }

    public void displayGameOver() {
        this.mState = 3;
        this.mCanvas.stop();
        if (this.mOkayCmd == null) {
            this.mOkayCmd = new Command(Local.getText(19), 4, 1);
        }
        this.mTextPage = new Form(Local.getText(11));
        this.mTextPage.append(Local.getText(11));
        this.mTextPage.append("\n\n");
        if (this.mNewBestScore) {
            this.mTextPage.append(Local.getText(17));
            this.mTextPage.append("\n\n");
        }
        this.mTextPage.append(String.valueOf(this.mLastScore));
        this.mTextPage.addCommand(this.mOkayCmd);
        this.mTextPage.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mTextPage);
        this.mTextPage = null;
    }

    public void displayLevelComplete() {
        this.mCanvas.stop();
        if (this.mContinueCmd == null) {
            this.mContinueCmd = new Command(Local.getText(8), 4, 1);
        }
        this.mTextPage = new Form("");
        this.mTextPage.append(this.mCanvas.mLevelCompletedStr);
        this.mTextPage.append("\n\n");
        this.mTextPage.append("" + this.mLastScore + "\n");
        this.mTextPage.addCommand(this.mContinueCmd);
        this.mTextPage.setCommandListener((CommandListener)this);
        this.mDisplay.setCurrent((Displayable)this.mTextPage);
        this.mTextPage = null;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND) {
            String string = this.mMainMenu.getString(this.mMainMenu.getSelectedIndex());
            this.mSavedMenuItem = this.mMainMenu.getSelectedIndex();
            if (string.equals(this.mMainMenuItems[MAIN_MENU_CONTINUE])) {
                boolean bl = RESTART_NOT_REQUIRED;
                int n = 0;
                if (this.mState != 1) {
                    bl = RESTART_IS_REQUIRED;
                    n = this.mState == 3 ? this.mCanvas.mLevelNum : this.mBestLevel;
                }
                this.displayGame(bl, n);
            } else if (string.equals(this.mMainMenuItems[MAIN_MENU_NEW_GAME])) {
                if (this.mState != 5) {
                    this.mState = 5;
                    this.mNewBestScore = false;
                    this.displayGame(RESTART_IS_REQUIRED, 1);
                }
            } else if (string.equals(this.mMainMenuItems[MAIN_MENU_HIGH_SCORE])) {
                this.displayHighScore();
            } else if (string.equals(this.mMainMenuItems[MAIN_MENU_INSTRUCTIONS])) {
                this.displayInstructions();
            }
        } else if (command == this.mBackCmd || command == this.mOkayCmd) {
            if (this.mDisplay.getCurrent() == this.mMainMenu) {
                this.mMidlet.destroyApp(true);
            } else {
                this.displayMainMenu();
            }
        } else if (command == this.mContinueCmd) {
            this.displayGame(RESTART_NOT_REQUIRED, 0);
        }
    }

    public void getGameData() {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[8];
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            if (recordStore.getNumRecords() != 2) {
                recordStore.addRecord(byArray, 0, byArray.length);
                recordStore.addRecord(byArray2, 0, byArray2.length);
            }
            byArray = recordStore.getRecord(1);
            byArray2 = recordStore.getRecord(2);
            this.mBestLevel = byArray[0];
            int n = 0;
            while (n < 8) {
                int n2 = 0;
                switch (n) {
                    case 0: {
                        n2 = 10000000;
                        break;
                    }
                    case 1: {
                        n2 = 1000000;
                        break;
                    }
                    case 2: {
                        n2 = 100000;
                        break;
                    }
                    case 3: {
                        n2 = 10000;
                        break;
                    }
                    case 4: {
                        n2 = 1000;
                        break;
                    }
                    case 5: {
                        n2 = 100;
                        break;
                    }
                    case 6: {
                        n2 = 10;
                        break;
                    }
                    case 7: {
                        n2 = 1;
                    }
                }
                this.mBestScore += byArray2[n] * n2;
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGameData(int n) {
        byte[] byArray = null;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)RMS_NAME, (boolean)true);
            if (n == 1) {
                byArray = new byte[]{(byte)this.mBestLevel};
            } else if (n == 2) {
                byArray = new byte[8];
                int n2 = 0;
                while (n2 < 8) {
                    int n3 = 1;
                    switch (n2) {
                        case 0: {
                            n3 = 10000000;
                            break;
                        }
                        case 1: {
                            n3 = 1000000;
                            break;
                        }
                        case 2: {
                            n3 = 100000;
                            break;
                        }
                        case 3: {
                            n3 = 10000;
                            break;
                        }
                        case 4: {
                            n3 = 1000;
                            break;
                        }
                        case 5: {
                            n3 = 100;
                            break;
                        }
                        case 6: {
                            n3 = 10;
                            break;
                        }
                        case 7: {
                            n3 = 1;
                        }
                    }
                    byArray[n2] = (byte)(this.mBestScore / n3 % 10);
                    ++n2;
                }
            }
            recordStore.setRecord(n, byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

