/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.FullCanvas;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class DragonCanvas
extends FullCanvas
implements Runnable {
    protected static final int CLR_WHITE = 0xFFFFFF;
    protected static final int CLR_BLACK = 0;
    protected static final int COLOR_YELLOW = 0xFFFF00;
    protected static final int COLOR_ORANGE = 16753152;
    protected static final int COLOR_RED = 0xFF0000;
    protected static final int COLOR_BROWN = 0x773300;
    protected static final int COLOR_SKY_BLUE = 9231100;
    protected static final int COLOR_WHITE = 0xFFFFFF;
    protected static final int COLOR_BLACK = 0;
    protected static final int COLOR_LIGHT_GRAY = 0xC0C0C0;
    protected static final int COLOR_GRAY = 0x808080;
    protected static final int COLOR_DARK_GRAY = 0x404040;
    protected static final int COLOR_BLUE = 255;
    protected static final int COLOR_LIGHT_BLUE = 0x8080FF;
    protected int SCREEN_WIDTH = this.getWidth();
    protected int SCREEN_HEIGHT = this.getHeight();
    protected int nScreenCenterX = this.SCREEN_WIDTH / 2;
    protected int nScreenCenterY = this.SCREEN_HEIGHT / 2;
    protected final int VIEW_HEIGHT = this.SCREEN_HEIGHT - 15;
    protected Font FONT_LARGE = Font.getFont((int)0, (int)0, (int)16);
    protected Font FONT_MEDIUM = Font.getFont((int)0, (int)0, (int)0);
    protected Font FONT_SMALL = Font.getFont((int)0, (int)0, (int)8);
    protected int LT = 20;
    protected int CT = 17;
    protected int CC = 3;
    private Dragon midlet;
    private Thread thread;
    private int nCurrentIndex;
    protected static final int STATE_PREV = -1;
    protected static final int STATE_INIT = 0;
    protected static final int STATE_NOKIA = 1;
    protected static final int STATE_COM2US = 2;
    protected static final int STATE_TITLE = 3;
    protected static final int STATE_MENU = 4;
    protected static final int STATE_HELP = 6;
    protected static final int STATE_SETUP = 7;
    protected static final int STATE_SCORE = 8;
    protected static final int STATE_ABOUT = 9;
    protected static final int STATE_GAMEOVER = 10;
    protected static final int STATE_GAME = 11;
    protected static final int STATE_PAUSE = 12;
    protected static final int STATE_LOAD = 1000;
    protected static final int STATE_DEMO = 13;
    protected int nState;
    protected int nPreviousState;
    protected int nSecondPreviousState;
    protected static final int KEY_OFF = 0;
    protected static final int KEY_PRESSED = 1;
    protected static final int KEY_RELEASED = 2;
    protected static final int KEY_REPEATED = 3;
    protected int nKeyCode;
    protected int nKeyState;
    private int keyFlag = 0;
    protected long lStopWatchStartTime;
    protected final int HEADER_HEIGHT = this.FONT_LARGE.getHeight() + 7;
    protected static final int IDB_NOKIA = 0;
    protected static final int IDB_COM2US = 1;
    protected static final int IDB_ABOUT = 2;
    protected static final int IDB_ICON = 3;
    protected static final int IDB_TITLE = 4;
    protected static final int IDB_BG = 5;
    protected static final int IDB_UNIT = 6;
    protected static final int IDB_EXPLOSION_B = 7;
    protected static final int IDB_EXPLOSION_U = 8;
    protected static final int IDB_BULIET = 9;
    protected static final int IDB_EBULIET = 10;
    protected static final int IDB_ENEMY = 11;
    protected static final int IDB_BOMB = 12;
    protected static final int IDB_ITEM = 13;
    protected static final int IDB_LIFE_B = 14;
    protected static final int IDB_LIFE_W = 15;
    protected static final int IDB_NUM_B = 16;
    protected static final int IDB_NUM_W = 17;
    protected static final int IDB_BOSS_0 = 18;
    protected static final int IDB_BOSS_1 = 19;
    protected static final int IDB_BOSS_2 = 20;
    protected static final int IDB_BOSS_3 = 21;
    protected static final int IDB_BOSS_4 = 22;
    protected static final int IDB_COUNT = 23;
    protected static final int IDS_TITLE = 0;
    protected static final int IDS_BULIET = 1;
    protected static final int IDS_BOMB = 2;
    protected static final int IDS_GAMEOVER = 3;
    protected static final int IDS_ITEM = 4;
    protected static final int IDS_SHOT = 5;
    protected static final int IDS_BOSSDIE = 6;
    protected static final int IDS_COUNT = 7;
    private static int[] SOUND_SIZES = new int[]{63, 24, 21, 44, 28, 27, 47};
    private Image[] IMAGES = new Image[23];
    private Sound[] SOUNDS = new Sound[7];
    private int nCurrentSoundIndex;
    protected static final byte SETTING_ON = 0;
    protected static final byte SETTING_OFF = 1;
    protected byte[] byGameSetting = new byte[4];
    protected RecordStore rcData;
    protected int[] nRankScore = new int[4];
    private int nTitleAniSeq;
    private int nMenuIndex;
    private int nHelpIndex;
    protected int nSettingIndex;
    private int nPauseIndex;
    private int nDemoFrame;
    private int[][] PATTERN_1 = new int[][]{{43, 4}, {51, 4}, {67, 4}, {59, 12}, {67, 12}, {61, 20}, {11, 106}, {18, 106}, {26, 105}, {8, 183}, {95, 227}, {103, 227}, {112, 226}, {96, 234}, {104, 235}, {96, 322}, {87, 329}, {95, 330}, {103, 330}, {68, 457}, {76, 458}, {23, 479}, {14, 545}, {22, 545}, {30, 545}, {14, 552}, {30, 551}, {38, 551}, {38, 557}, {44, 557}, {45, 563}, {51, 562}, {43, 644}, {51, 644}, {67, 644}, {59, 652}, {67, 652}, {61, 660}, {11, 746}, {18, 746}, {26, 745}};
    private int[][] PATTERN_2 = new int[][]{{15, 36}, {24, 37}, {15, 52}, {24, 53}, {98, 88}, {107, 89}, {14, 163}, {23, 164}, {15, 178}, {15, 196}, {104, 236}, {106, 280}, {89, 302}, {98, 301}, {106, 327}, {115, 327}, {11, 412}, {39, 446}, {108, 446}, {108, 463}, {110, 481}, {50, 555}, {59, 554}, {59, 567}, {15, 676}, {24, 677}, {15, 692}, {24, 693}, {98, 728}, {107, 729}};
    private int[][] PATTERN_3 = new int[][]{{17, 15}, {25, 15}, {33, 15}, {89, 27}, {97, 27}, {105, 27}, {27, 81}, {35, 81}, {43, 81}, {18, 154}, {26, 154}, {34, 154}, {42, 154}, {50, 154}, {26, 179}, {34, 179}, {87, 230}, {95, 230}, {103, 230}, {40, 315}, {48, 315}, {56, 315}, {5, 426}, {75, 479}, {83, 479}, {91, 479}, {28, 564}, {36, 564}, {44, 564}, {17, 655}, {25, 655}, {33, 655}, {89, 667}, {97, 667}, {105, 667}, {27, 721}, {35, 721}, {43, 721}};
    private int[][] PATTERN_4 = new int[][]{{14, 38}, {23, 38}, {31, 38}, {14, 47}, {23, 47}, {86, 88}, {18, 214}, {18, 230}, {96, 355}, {23, 471}, {23, 479}, {31, 479}, {14, 678}, {23, 678}, {31, 678}, {14, 687}, {23, 687}, {86, 728}};
    private int[][] PATTERN_5 = new int[][]{{7, 7}, {64, 35}, {118, 33}, {110, 50}, {19, 74}, {109, 100}, {25, 113}, {12, 148}, {20, 156}, {44, 206}, {106, 223}, {100, 231}, {96, 298}, {61, 307}, {16, 366}, {103, 401}, {113, 413}, {19, 428}, {16, 531}, {95, 546}, {111, 577}, {7, 647}, {64, 675}, {118, 673}, {110, 690}, {19, 714}, {109, 740}, {25, 753}};
    private static final int MAX_ENEMY = 13;
    private static final int MAX_DBULLET = 18;
    private static final int MAX_EBULLET = 20;
    private static final int MAX_LIFE = 50;
    private Unit unitDragon = null;
    private int nDragonFire;
    private Unit[] unitEnemy = null;
    private Unit[] unitDBullet = null;
    private Unit[] unitEBullet = null;
    private Unit unit1 = null;
    private Unit unit2 = null;
    private int nDragonBullet;
    private static final int PATTERN_TYPE1 = 0;
    private static final int PATTERN_TYPE2 = 1;
    private static final int PATTERN_TYPE3 = 2;
    private static final int PATTERN_TYPE4 = 3;
    private static final int PATTERN_TYPE5 = 4;
    private static final int PATTERN_TYPE6 = 5;
    private static final int PATTERN_TYPE7 = 6;
    private static final int PATTERN_TYPE8 = 7;
    private static final int PATTERN_TYPE_STONE1 = 8;
    private static final int PATTERN_TYPE_STONE2 = 9;
    private static final int PATTERN_TYPE_BOSS1 = 10;
    private static final int PATTERN_TYPE_BOSS2 = 11;
    private static final int PATTERN_TYPE_BOSS3 = 12;
    private static final int PATTERN_BULLET1 = 100;
    private static final int PATTERN_BULLET2 = 101;
    private static final int PATTERN_BULLET3 = 102;
    private static final int PATTERN_BULLET4 = 103;
    private static final int PATTERN_BULLET5 = 104;
    private static final int PATTERN_ITEM1 = 30;
    private static final int PATTERN_ITEM2 = 31;
    private static final int PATTERN_ITEM3 = 32;
    private static final int PATTERN_ITEM4 = 33;
    private int nStage;
    private int nClearCnt;
    private int nStageBullet;
    private int nStageUnit;
    private int nStageLife;
    private int nStageAttack;
    private int nStageItem;
    private int nStageClear;
    private int nStageScore;
    private static final int BOMB_CNT = 7;
    private static final int BOMB_GAUGE = 31;
    private int nBombGauge;
    private boolean bBomb;
    private int[] nBombX;
    private int[] nBombY;
    private boolean bBonus;
    private boolean bOver;
    private static final int ITEM_NO = 2;
    private static final int ITEM_POWER = 0;
    private static final int ITEM_LIFE = 1;
    private Unit unitItem = null;
    private Unit unitBoss;
    private boolean bBoss;
    private int nScore;
    private String strScore;
    private int nFrame;
    private int REFRESH_RATE = 200;
    public static final int RUN_STATE_READY = 0;
    public static final int RUN_STATE_ALIVE = 1;
    public static final int RUN_STATE_DEAD = 2;
    public static final int RUN_STATE_CLEAR = 5;
    public static final int RUN_STATE_ALL_CLEAR = 6;
    public static final int RUN_STATE_GAMEOVER = 7;
    private int R_Y = 640;
    private int blink = 0;
    private Random rndRand = new Random();
    private int nDragonIndex = 0;

    public DragonCanvas(Dragon dragon) {
        this.midlet = dragon;
    }

    protected void startCanvas() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    protected void pauseCanvas() {
        if (this.nState == 11) {
            this.setCurrentState(12);
        }
    }

    protected void destroyCanvas() {
        this.midlet.notifyDestroyed();
    }

    protected void setCurrentState(int n) {
        if (n == -1) {
            this.nState = this.nPreviousState;
            this.nPreviousState = this.nSecondPreviousState;
        } else {
            this.nSecondPreviousState = this.nPreviousState;
            this.nPreviousState = this.nState;
            this.nState = n;
        }
        if (this.nState == 3) {
            this.stopSound();
            this.playSound(0);
            this.repaint();
            this.sleep(100);
        } else if (this.nState == 1) {
            this.nCurrentIndex = 0;
            this.resetStopWatch();
        } else if (this.nState == 2) {
            this.resetStopWatch();
        } else if (this.nState == 6) {
            this.nHelpIndex = 0;
        } else if (this.nState == 12) {
            this.nPauseIndex = 1;
        }
        this.repaint();
    }

    protected void doJob(int n) {
        switch (n) {
            case 0: {
                this.initializeStage();
                this.setCurrentState(11);
                break;
            }
            case 1: {
                this.setCurrentState(6);
                break;
            }
            case 2: {
                this.setCurrentState(8);
                break;
            }
            case 3: {
                this.setCurrentState(7);
                break;
            }
            case 4: {
                this.setCurrentState(9);
                break;
            }
            case 5: {
                if (this.nState == 4) {
                    this.destroyCanvas();
                    break;
                }
                this.setCurrentState(3);
            }
        }
    }

    protected void keyPressed(int n) {
        if (this.nState == 11) {
            this.keyPressedPlaying(n);
        } else if (this.nState == 4) {
            this.keyPressedMenu(n);
        } else if (this.nState == 6) {
            this.keyPressedHelp(n);
        } else if (this.nState == 8) {
            this.keyPressedScore(n);
        } else if (this.nState == 7) {
            this.keyPressedSetup(n);
        } else if (this.nState == 9) {
            this.keyPressedAbout(n);
        } else if (this.nState == 10) {
            this.keyPressedGameOver(n);
        } else if (this.nState == 3) {
            this.keyPressedTitle(n);
        } else if (this.nState == 12) {
            this.keyPressedPause(n);
        } else if (this.nState == 1) {
            this.setCurrentState(2);
        } else if (this.nState == 2) {
            this.setCurrentState(1000);
        } else if (this.nState == 13) {
            this.keyPressedDemo(n);
        }
    }

    protected void keyRepeated(int n) {
        if (this.nState != 11) {
            this.keyPressed(n);
        }
    }

    protected void keyReleased(int n) {
        this.keyFlag = 0;
        this.nKeyState = this.nKeyState == 1 ? 2 : 0;
    }

    protected void keyReset() {
        if (this.nKeyState == 1) {
            this.nKeyState = 3;
        } else if (this.nKeyState == 2) {
            this.nKeyState = 0;
        }
    }

    public void run() {
        do {
            this.sleep(100);
        } while (!this.isShown());
        this.setCurrentState(2);
        while (true) {
            if (this.nState == 11) {
                this.repaint();
                this.sleep(80);
                continue;
            }
            if (this.nState == 1) {
                this.waitForID(this.nCurrentIndex);
                this.repaint();
                if (this.getStopWatchTime() < 3000L) continue;
                this.setCurrentState(2);
                continue;
            }
            if (this.nState == 2) {
                this.waitForID(this.nCurrentIndex);
                this.repaint();
                if (this.getStopWatchTime() < 3000L) continue;
                this.setCurrentState(1000);
                continue;
            }
            if (this.nState == 1000) {
                this.repaint();
                if (!this.waitForID(this.nCurrentIndex)) continue;
                this.loadData();
                this.initializeThis();
                this.setCurrentState(3);
                continue;
            }
            if (this.nState == 3) {
                this.sleep(200);
                continue;
            }
            if (this.nState == 13) {
                this.repaint();
                this.sleep(200);
                continue;
            }
            this.sleep(200);
        }
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void paint(Graphics graphics) {
        if (this.nState == 11) {
            this.paintPlaying(graphics);
        } else if (this.nState == 12) {
            this.clearScreen(graphics, 9231100);
            this.paintPause(graphics);
            this.drawCommands(graphics, "Seleziona", "Indietro", 9231100);
        } else if (this.nState == 4) {
            this.paintMenu(graphics);
            this.drawCommands(graphics, "Seleziona", "Indietro", 9231100);
        } else if (this.nState == 10) {
            this.clearScreen(graphics, 9231100);
            this.paintGameOver(graphics);
            this.drawCommands(graphics, "Chiudi", "Riprova", 9231100);
        } else if (this.nState == 6) {
            this.paintHelp(graphics);
            this.drawCommands(graphics, null, "Indietro", 9231100);
        } else if (this.nState == 8) {
            this.paintScore(graphics);
            this.drawCommands(graphics, null, "Indietro", 9231100);
        } else if (this.nState == 7) {
            this.paintSettings(graphics);
            this.drawCommands(graphics, "Cambia", "Indietro", 9231100);
        } else if (this.nState == 3) {
            this.paintTitle(graphics);
            this.drawCommands(graphics, "Opzioni", "Gioca", 9231100);
        } else if (this.nState == 9) {
            this.paintAbout(graphics);
            this.drawCommands(graphics, null, "Indietro", 0xFFFFFF);
        } else if (this.nState == 1) {
            this.clearScreen(graphics, 0);
            this.drawImageCenter(graphics, this.IMAGES[0]);
        } else if (this.nState == 2) {
            this.clearScreen(graphics, 0xFFFFFF);
            this.drawImageCenter(graphics, this.IMAGES[1]);
        } else if (this.nState == 1000) {
            this.paintLoading(graphics);
        } else if (this.nState == 13) {
            this.paintDemo(graphics);
            this.drawCommands(graphics, null, "Chiudi", 9231100);
        }
    }

    protected void resetStopWatch() {
        this.lStopWatchStartTime = System.currentTimeMillis();
    }

    protected long getStopWatchTime() {
        return System.currentTimeMillis() - this.lStopWatchStartTime;
    }

    private int getKeyDirection(int n) {
        if (n == 53) {
            return 8;
        }
        if (n == 50) {
            return 1;
        }
        if (n == 56) {
            return 6;
        }
        if (n == 54) {
            return 5;
        }
        if (n == 52) {
            return 2;
        }
        return this.getGameAction(n);
    }

    protected void clearScreen(Graphics graphics, int n) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.setColor(n);
        graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
    }

    private void setClipImage(Graphics graphics, int n, int n2, Image image, int n3, int n4, int n5, int n6, int n7) {
        graphics.setClip(n, n2, n5, n6);
        graphics.drawImage(image, n - n3, n2 - n4, n7);
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
    }

    private void drawImageCenter(Graphics graphics, Image image) {
        this.drawImageCenter(graphics, image, 0, 0);
    }

    private void drawImageCenter(Graphics graphics, Image image, int n, int n2) {
        if (image != null) {
            graphics.drawImage(image, this.SCREEN_WIDTH / 2 + n, (this.SCREEN_HEIGHT - image.getHeight()) / 2 + n2, this.CT);
        }
    }

    private void drawOutlineString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n4);
        graphics.drawString(string, n - 1, n2, n3);
        graphics.drawString(string, n + 1, n2, n3);
        graphics.drawString(string, n, n2 - 1, n3);
        graphics.drawString(string, n, n2 + 1, n3);
        graphics.setColor(n5);
        graphics.drawString(string, n, n2, n3);
    }

    private void drawBoldString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(n4);
        graphics.drawString(string, n, n2 - 1, n3);
        graphics.drawString(string, n, n2 + 1, n3);
        graphics.setColor(n5);
        graphics.drawString(string, n, n2, n3);
    }

    protected static int drawStringCenter(Graphics graphics, String string, int n) {
        graphics.drawString(string, 7, n, 20);
        return n + 16;
    }

    protected void drawText(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        do {
            n6 = string.indexOf("&", n5);
            if (n2 >= 0 && n2 < this.SCREEN_HEIGHT) {
                graphics.drawSubstring(string, n5, n6 == -1 ? string.length() - n5 : n6 - n5, n, n2, n3);
            }
            n5 = n6 + 1;
            n2 += n4;
        } while (n6 != -1);
    }

    protected void drawSubText(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        do {
            if (n > n7) {
                n8 = string.indexOf("&", n8) + 1;
            } else if (n7 - n < n2) {
                n9 = string.indexOf("&", n8);
                if (n4 >= 0 && n4 < this.SCREEN_HEIGHT) {
                    graphics.drawSubstring(string, n8, n9 == -1 ? string.length() - n8 : n9 - n8, n3, n4, n5);
                }
                n8 = n9 + 1;
                n4 += n6;
            } else {
                n9 = -1;
            }
            ++n7;
        } while (n9 != -1);
    }

    private void drawFrame(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.setColor(n3);
        graphics.fillRect(0, n - n2, this.SCREEN_WIDTH, n2);
        graphics.setColor(n4);
        graphics.fillRect(4, n - n2 + 4, this.SCREEN_WIDTH - 5, n2 - 5);
        graphics.setColor(n5);
        graphics.fillRect(2, n - n2 + 2, this.SCREEN_WIDTH - 5, n2 - 5);
        graphics.setColor(n6);
        graphics.fillRect(3, n - n2 + 3, this.SCREEN_WIDTH - 7, n2 - 7);
    }

    private void drawAlert(Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        this.drawFrame(graphics, n, n2, n3, n4, n5, n6);
        graphics.setColor(n7);
        graphics.setFont(this.FONT_MEDIUM);
        this.drawText(graphics, string, 10, n - n2 + 7, this.LT, this.FONT_MEDIUM.getHeight());
    }

    protected void drawList(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = (n3 - n2) * this.FONT_MEDIUM.getHeight() + 7;
        this.drawFrame(graphics, this.VIEW_HEIGHT, n10, n4, n5, n6, n7);
        graphics.setColor(n9);
        graphics.fillRect(3, this.VIEW_HEIGHT - n10 + 3 + this.FONT_MEDIUM.getHeight() * (n - n2), this.SCREEN_WIDTH - 7, this.FONT_MEDIUM.getHeight());
        graphics.setFont(this.FONT_MEDIUM);
        graphics.setColor(n8);
        this.drawSubText(graphics, string, n2, n3, 10, this.VIEW_HEIGHT - n10 + 3, this.LT, this.FONT_MEDIUM.getHeight());
    }

    protected void drawHeader(Graphics graphics, String string) {
        int n = 0xFFFFFF;
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        int n2 = 10;
        while (n2 >= 0) {
            graphics.setColor(n);
            n -= 0x191900;
            graphics.fillRect(n2 * (this.SCREEN_WIDTH / 10), this.FONT_LARGE.getHeight(), (n2 + 1) * (this.SCREEN_WIDTH / 10), 7);
            --n2;
        }
        graphics.setColor(0xFF0000);
        graphics.setFont(this.FONT_LARGE);
        graphics.drawString(string, this.SCREEN_WIDTH / 2, 0, this.CT);
    }

    private void drawCommands(Graphics graphics, String string, String string2, int n) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        graphics.setColor(n);
        graphics.fillRect(0, this.VIEW_HEIGHT, this.SCREEN_WIDTH, this.SCREEN_HEIGHT - this.VIEW_HEIGHT);
        graphics.setColor(0);
        graphics.setFont(this.FONT_MEDIUM);
        if (string != null) {
            graphics.drawString(string, 2, this.SCREEN_HEIGHT, 36);
        }
        if (string2 != null) {
            graphics.drawString(string2, this.SCREEN_WIDTH - 2, this.SCREEN_HEIGHT, 40);
        }
    }

    private void initializeThis() {
        this.unitDragon = new Unit();
        this.unitDBullet = new Unit[18];
        int n = 0;
        while (n < 18) {
            this.unitDBullet[n] = new Unit();
            ++n;
        }
        this.unitEnemy = new Unit[13];
        n = 0;
        while (n < 13) {
            this.unitEnemy[n] = new Unit();
            ++n;
        }
        this.unitEBullet = new Unit[20];
        n = 0;
        while (n < 20) {
            this.unitEBullet[n] = new Unit();
            ++n;
        }
        this.unitBoss = null;
        this.nBombX = new int[7];
        this.nBombY = new int[7];
        this.unitItem = new Unit();
    }

    private boolean waitForID(int n) {
        block4: {
            try {
                if (n < 23) {
                    this.IMAGES[n] = Image.createImage((String)("/image/" + n + ".png"));
                    break block4;
                }
                if (n < 30) {
                    this.SOUNDS[n - 23] = new Sound(DragonCanvas.readFile("/sound/" + (n - 23) + ".ott", SOUND_SIZES[n - 23]), 1);
                    break block4;
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ++this.nCurrentIndex;
        return false;
    }

    private static byte[] readFile(String string, int n) {
        byte[] byArray = new byte[n];
        try {
            InputStream inputStream = string.getClass().getResourceAsStream(string);
            inputStream.read(byArray);
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return byArray;
    }

    private void playSound(int n) {
        if (this.byGameSetting[0] == 0) {
            try {
                this.SOUNDS[n].play(1);
                this.nCurrentSoundIndex = n;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopSound() {
        try {
            if (this.nCurrentSoundIndex != -1) {
                this.SOUNDS[this.nCurrentSoundIndex].stop();
                this.nCurrentSoundIndex = -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void vibrate(int n, int n2) {
        if (this.byGameSetting[1] == 0) {
            try {
                DeviceControl.startVibra((int)n, (long)n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void flashLights(long l) {
        if (this.byGameSetting[2] == 0) {
            this.flashLights(l);
        }
    }

    private void setBacklight() {
        try {
            DeviceControl.setLights((int)0, (int)(this.byGameSetting[2] == 0 ? 100 : 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void paintLoading(Graphics graphics) {
        int n = this.SCREEN_WIDTH - 30;
        int n2 = this.nCurrentIndex * n / 29;
        if (n2 > n) {
            n2 = n;
        }
        this.drawAlert(graphics, this.SCREEN_HEIGHT, 45, "Carica...", 0xFFFFFF, 0xC0C0C0, 0, 0xFFFFFF, 0x404040);
        graphics.setColor(0x404040);
        graphics.fillRect((this.SCREEN_WIDTH - n) / 2 - 1, this.SCREEN_HEIGHT - 18, n + 2, 11);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect((this.SCREEN_WIDTH - n) / 2, this.SCREEN_HEIGHT - 17, n, 9);
        graphics.setColor(0xC0C0C0);
        graphics.fillRect((this.SCREEN_WIDTH - n) / 2, this.SCREEN_HEIGHT - 17, n2, 9);
    }

    private boolean loadData() {
        byte[] byArray = null;
        this.nRankScore = new int[4];
        try {
            this.rcData = RecordStore.openRecordStore((String)"Dragon", (boolean)false);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            try {
                this.rcData = RecordStore.openRecordStore((String)"Dragon", (boolean)true);
                byArray = new byte[]{0, 0, 0, 0};
                int n = 0;
                while (n < 4) {
                    this.rcData.addRecord(byArray, 0, byArray.length);
                    ++n;
                }
                this.closeRms(this.rcData);
                return true;
            }
            catch (RecordStoreException recordStoreException) {
                return false;
            }
        }
        catch (RecordStoreException recordStoreException) {
            return false;
        }
        try {
            int n = 0;
            while (n < 4) {
                byArray = this.rcData.getRecord(n + 1);
                this.nRankScore[n] = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
                byArray = null;
                ++n;
            }
        }
        catch (Exception exception) {
            return false;
        }
        byArray = null;
        this.closeRms(this.rcData);
        return true;
    }

    private boolean saveData(int n) {
        boolean bl = false;
        RecordStore recordStore = null;
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            if (this.nRankScore[n2] < n) {
                int n3 = 3;
                while (n3 > n2) {
                    this.nRankScore[n3] = this.nRankScore[n3 - 1];
                    --n3;
                }
                this.nRankScore[n2] = n;
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            return false;
        }
        try {
            recordStore = RecordStore.openRecordStore((String)"Dragon", (boolean)false);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            return false;
        }
        catch (RecordStoreException recordStoreException) {
            return false;
        }
        n2 = 0;
        while (n2 < 4) {
            byArray[0] = (byte)(0xFF & this.nRankScore[n2] >>> 24);
            byArray[1] = (byte)(0xFF & this.nRankScore[n2] >>> 16);
            byArray[2] = (byte)(0xFF & this.nRankScore[n2] >>> 8);
            byArray[3] = (byte)(0xFF & this.nRankScore[n2]);
            try {
                recordStore.setRecord(n2 + 1, byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                return false;
            }
            ++n2;
        }
        this.closeRms(recordStore);
        return true;
    }

    private boolean closeRms(RecordStore recordStore) {
        try {
            recordStore.closeRecordStore();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            return false;
        }
        catch (RecordStoreException recordStoreException) {
            return false;
        }
        return true;
    }

    protected void keyPressedTitle(int n) {
        if (n == -6) {
            this.setCurrentState(4);
        } else if (this.getGameAction(n) == 8 || n == -7) {
            this.initializeStage();
            this.setCurrentState(11);
        }
    }

    private void paintTitle(Graphics graphics) {
        graphics.setClip(0, 0, this.SCREEN_WIDTH, this.VIEW_HEIGHT);
        graphics.drawImage(this.IMAGES[4], this.SCREEN_WIDTH / 2, 0, this.CT);
    }

    protected void keyPressedMenu(int n) {
        if (this.getKeyDirection(n) == 1) {
            this.nMenuIndex = this.nMenuIndex > 0 ? --this.nMenuIndex : 5;
            this.repaint();
        } else if (this.getKeyDirection(n) == 6) {
            this.nMenuIndex = this.nMenuIndex < 5 ? ++this.nMenuIndex : 0;
            this.repaint();
        } else if (this.getKeyDirection(n) == 8 || n == -6) {
            this.doJob(this.nMenuIndex);
        } else if (n == -7) {
            this.setCurrentState(3);
        }
    }

    private void paintMenu(Graphics graphics) {
        this.clearScreen(graphics, 9231100);
        this.drawList(graphics, "Gioca&Istruzione&Punteggi piu\u2019 alti&Installazione&Intorno&Smetti", this.nMenuIndex, 0, 6, 9231100, 0x404040, 0, 0xFFFFFF, 0, 0x8080FF);
    }

    protected void keyPressedHelp(int n) {
        int n2 = (this.VIEW_HEIGHT - 20) / this.FONT_MEDIUM.getHeight();
        if (this.getKeyDirection(n) == 1 && this.nHelpIndex > 0) {
            --this.nHelpIndex;
            this.repaint();
        } else if (this.getKeyDirection(n) == 6 && this.nHelpIndex < 4 - n2) {
            ++this.nHelpIndex;
            this.repaint();
        } else if (n == -7 || this.getGameAction(n) == 8) {
            this.setCurrentState(-1);
        }
    }

    private void paintHelp(Graphics graphics) {
        int n = this.nHelpIndex * this.FONT_MEDIUM.getHeight();
        this.clearScreen(graphics, 9231100);
        graphics.setColor(0);
        graphics.setFont(this.FONT_MEDIUM);
        this.drawText(graphics, "4, 6 : sinistra, destra&2, 8 : su\u2019, giu\u2019&5 : fuoco&3 : bomba", 6, 30 - n, this.LT, this.FONT_MEDIUM.getHeight());
        this.drawHeader(graphics, "Istruzione");
    }

    protected void keyPressedScore(int n) {
        if (n == -7 || this.getGameAction(n) == 8) {
            this.setCurrentState(-1);
        }
    }

    protected void paintScore(Graphics graphics) {
        int n = this.FONT_MEDIUM.getHeight() + 2;
        this.clearScreen(graphics, 9231100);
        graphics.setColor(0);
        graphics.drawLine(20, this.HEADER_HEIGHT, 20, this.VIEW_HEIGHT - 2);
        graphics.drawLine(20, this.VIEW_HEIGHT - 2, this.getWidth(), this.VIEW_HEIGHT - 2);
        int n2 = 0;
        while (n2 < 4) {
            if (this.HEADER_HEIGHT + (n2 + 1) * n < this.VIEW_HEIGHT) {
                graphics.setFont(this.FONT_MEDIUM);
                graphics.drawString(String.valueOf(n2 + 1), 16, 4 + this.HEADER_HEIGHT + n2 * n, 24);
                graphics.drawString(this.nRankScore[n2] + " " + "Punto", 26, 4 + this.HEADER_HEIGHT + n2 * n, this.LT);
            }
            ++n2;
        }
        this.drawHeader(graphics, "Punteggio");
    }

    protected void changeSetting() {
        this.byGameSetting[this.nSettingIndex] = (byte)((this.byGameSetting[this.nSettingIndex] + 1) % 2);
        this.repaint();
    }

    protected void keyPressedSetup(int n) {
        if (n == -6 || this.getGameAction(n) == 8) {
            this.changeSetting();
        }
        if (n == -7) {
            this.setCurrentState(-1);
        } else {
            switch (this.getGameAction(n)) {
                case 1: {
                    if (this.nSettingIndex <= 0) break;
                    --this.nSettingIndex;
                    this.repaint();
                    break;
                }
                case 6: {
                    if (this.nSettingIndex >= Dragon.SETTING_ITEMS.length - 1) break;
                    ++this.nSettingIndex;
                    this.repaint();
                }
            }
        }
    }

    protected void paintSettings(Graphics graphics) {
        int n = this.FONT_MEDIUM.getHeight() + this.FONT_MEDIUM.getHeight() + 7;
        this.clearScreen(graphics, 9231100);
        graphics.setColor(0);
        graphics.drawLine(5, this.HEADER_HEIGHT, 5, this.HEADER_HEIGHT + n * Dragon.SETTING_ITEMS.length);
        graphics.setColor(0xC0C0C0);
        graphics.fillRect(2, this.HEADER_HEIGHT + 2 + this.nSettingIndex * n, this.SCREEN_WIDTH - 3, n - 2);
        graphics.setColor(0x8080FF);
        graphics.fillRect(1, this.HEADER_HEIGHT + 1 + this.nSettingIndex * n, this.SCREEN_WIDTH - 3, n - 2);
        int n2 = 0;
        while (n2 < Dragon.SETTING_ITEMS.length) {
            graphics.setColor(0);
            graphics.drawLine(5, this.HEADER_HEIGHT + n * (n2 + 1), this.SCREEN_WIDTH, this.HEADER_HEIGHT + n * (n2 + 1));
            graphics.setFont(this.FONT_MEDIUM);
            graphics.drawString(Dragon.SETTING_ITEMS[n2], 20, this.HEADER_HEIGHT + 2 + n * n2, this.LT);
            graphics.setColor(0x404040);
            graphics.fillRect(this.SCREEN_WIDTH / 3 - 4, this.HEADER_HEIGHT + 3 + this.FONT_MEDIUM.getHeight() + n * n2, this.SCREEN_WIDTH * 2 / 3, this.FONT_MEDIUM.getHeight());
            graphics.setFont(this.FONT_MEDIUM);
            graphics.setColor(0xC0C0C0);
            graphics.drawString(Dragon.SWITCH_ITEMS[this.byGameSetting[n2] % 2], this.SCREEN_WIDTH * 2 / 3 - 4, this.HEADER_HEIGHT + 3 + this.FONT_MEDIUM.getHeight() + n * n2, this.CT);
            ++n2;
        }
        this.drawHeader(graphics, "Installazione");
    }

    protected void keyPressedAbout(int n) {
        if (n == -7 || this.getGameAction(n) == 8) {
            this.setCurrentState(-1);
        }
    }

    protected void paintAbout(Graphics graphics) {
        int n = this.FONT_MEDIUM.getHeight() + this.FONT_SMALL.getHeight() + 1;
        this.clearScreen(graphics, 0xFFFFFF);
        this.drawImageCenter(graphics, this.IMAGES[2]);
        this.drawHeader(graphics, "Intorno");
    }

    protected void keyPressedPause(int n) {
        if (this.getKeyDirection(n) == 1) {
            this.nPauseIndex = this.nPauseIndex > 1 ? --this.nPauseIndex : 5;
            this.repaint();
        } else if (this.getKeyDirection(n) == 6) {
            this.nPauseIndex = this.nPauseIndex < 5 ? ++this.nPauseIndex : 1;
            this.repaint();
        } else if (this.getKeyDirection(n) == 8 || n == -6) {
            this.doJob(this.nPauseIndex);
        } else if (n == -7) {
            this.setCurrentState(11);
        }
    }

    private void paintPause(Graphics graphics) {
        this.drawList(graphics, "Gioca&Istruzione&Punteggi piu\u2019 alti&Installazione&Intorno&Smetti", this.nPauseIndex, 1, 6, 9231100, 0x404040, 0, 0xFFFFFF, 0, 0x8080FF);
    }

    protected void keyPressedGameOver(int n) {
        if (n == -6 || this.getGameAction(n) == 8) {
            this.setCurrentState(3);
        } else if (n == -7) {
            this.initializeStage();
            this.setCurrentState(11);
        }
    }

    protected void paintGameOver(Graphics graphics) {
        this.drawAlert(graphics, this.VIEW_HEIGHT, 50, "1: " + this.nRankScore[0] + "&" + "Tu" + ": " + this.nScore, 9231100, 0xC0C0C0, 0, 0xFFFF00, 0);
    }

    protected void keyPressedDemo(int n) {
        if (n == -7) {
            this.setCurrentState(3);
        }
    }

    private void paintDemo(Graphics graphics) {
        int n = this.nHelpIndex * this.FONT_MEDIUM.getHeight();
        this.clearScreen(graphics, 9231100);
        graphics.setColor(0);
        graphics.setFont(this.FONT_MEDIUM);
        this.drawText(graphics, "This is a demo&version. The full&version is available&from you&carrier/operator", 6, 22 - n, this.LT, this.FONT_MEDIUM.getHeight());
    }

    protected void keyPressedPlaying(int n) {
        int n2 = this.getGameAction(n);
        if (n == -7) {
            this.setCurrentState(12);
        } else if (this.getKeyDirection(n) == 8) {
            System.gc();
            this.playSound(1);
            this.nDragonBullet = 18;
            if (this.nDragonFire == 1) {
                int n3 = 0;
                while (n3 < this.nDragonBullet) {
                    this.unit1 = this.unitDBullet[n3];
                    if (!this.unit1.bUsed) {
                        this.unit1.create(this.unitDragon.nX, this.unitDragon.nY);
                        this.unit1.nPattern = 100;
                        break;
                    }
                    ++n3;
                }
            } else if (this.nDragonFire == 2) {
                int n4 = 0;
                while (n4 < this.nDragonBullet) {
                    this.unit1 = this.unitDBullet[n4];
                    if (!this.unit1.bUsed) {
                        this.unit1.create(this.unitDragon.nX - 3, this.unitDragon.nY);
                        this.unit1.nPattern = 101;
                        break;
                    }
                    ++n4;
                }
                while (n4 < this.nDragonBullet) {
                    this.unit1 = this.unitDBullet[n4];
                    if (!this.unit1.bUsed) {
                        this.unit1.create(this.unitDragon.nX + 3, this.unitDragon.nY);
                        this.unit1.nPattern = 102;
                        break;
                    }
                    ++n4;
                }
            } else if (this.nDragonFire == 3) {
                int n5 = 0;
                while (n5 < this.nDragonBullet) {
                    this.unit1 = this.unitDBullet[n5];
                    if (!this.unit1.bUsed) {
                        this.unit1.create(this.unitDragon.nX, this.unitDragon.nY);
                        this.unit1.nPattern = 100;
                        break;
                    }
                    ++n5;
                }
                while (n5 < this.nDragonBullet) {
                    this.unit1 = this.unitDBullet[n5];
                    if (!this.unit1.bUsed) {
                        this.unit1.create(this.unitDragon.nX - 5, this.unitDragon.nY);
                        this.unit1.nPattern = 101;
                        break;
                    }
                    ++n5;
                }
                while (n5 < this.nDragonBullet) {
                    this.unit1 = this.unitDBullet[n5];
                    if (!this.unit1.bUsed) {
                        this.unit1.create(this.unitDragon.nX + 5, this.unitDragon.nY);
                        this.unit1.nPattern = 102;
                        break;
                    }
                    ++n5;
                }
            }
        } else if (n == 51) {
            if (this.nBombGauge >= 31 && !this.bBomb) {
                this.playSound(2);
                this.bBomb = true;
                int n6 = 0;
                while (n6 < 7) {
                    this.nBombX[n6] = this.SCREEN_WIDTH / 8 * (n6 + 1);
                    this.nBombY[n6] = this.SCREEN_HEIGHT;
                    ++n6;
                }
                n6 = 0;
                while (n6 < 20) {
                    this.unitEBullet[n6].initialize();
                    ++n6;
                }
                if (this.bBoss) {
                    if (this.unitBoss.bUsed) {
                        this.unitBoss.nLife -= 30;
                    }
                } else {
                    n6 = 0;
                    while (n6 < this.nStageUnit) {
                        this.unit1 = this.unitEnemy[n6];
                        if (this.unit1.bUsed) {
                            this.unit1.bomb();
                            this.nScore += this.unit1.nScore;
                        }
                        ++n6;
                    }
                }
            }
        } else {
            switch (this.getKeyDirection(n)) {
                case 2: {
                    this.keyFlag = 4;
                    break;
                }
                case 5: {
                    this.keyFlag = 6;
                    break;
                }
                case 1: {
                    this.keyFlag = 2;
                    break;
                }
                case 6: {
                    this.keyFlag = 8;
                }
            }
        }
    }

    private void initializeStage() {
        this.unitDragon.initialize();
        this.unitDragon.create(this.nScreenCenterX, this.SCREEN_HEIGHT - 20, 50, 10);
        this.nDragonFire = 1;
        this.nDragonBullet = 5;
        this.nScore = 0;
        this.nBombGauge = 31;
        this.initStage(1);
    }

    protected void paintPlaying(Graphics graphics) {
        int n;
        int n2;
        int n3;
        switch (this.nStage) {
            case 1: {
                graphics.setColor(182, 219, 85);
                graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                n3 = 0;
                while (n3 < this.PATTERN_1.length) {
                    if (n3 == 5 || n3 == 6 || n3 == 11 || n3 == 37 || n3 == 38) {
                        this.setClipImage(graphics, this.PATTERN_1[n3][0] - 6, this.PATTERN_1[n3][1] - this.R_Y - 6, this.IMAGES[5], 0, 0, 12, 12, this.LT);
                    } else {
                        this.setClipImage(graphics, this.PATTERN_1[n3][0] - 6, this.PATTERN_1[n3][1] - this.R_Y - 6, this.IMAGES[5], 0, 14, 12, 12, this.LT);
                    }
                    ++n3;
                }
                break;
            }
            case 2: {
                graphics.setColor(255, 255, 171);
                graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                n3 = 0;
                while (n3 < this.PATTERN_2.length) {
                    if (n3 == 0 || n3 == 2 || n3 == 4 || n3 == 6 || n3 == 13 || n3 == 15 || n3 == 18 || n3 == 19 || n3 == 22 || n3 == 23 || n3 == 24 || n3 == 26 || n3 == 28) {
                        this.setClipImage(graphics, this.PATTERN_2[n3][0] - 6, this.PATTERN_2[n3][1] - this.R_Y - 6, this.IMAGES[5], 13, 0, 12, 12, this.LT);
                    } else {
                        this.setClipImage(graphics, this.PATTERN_2[n3][0] - 6, this.PATTERN_2[n3][1] - this.R_Y - 6, this.IMAGES[5], 13, 14, 12, 12, this.LT);
                    }
                    ++n3;
                }
                break;
            }
            case 3: {
                graphics.setColor(146, 219, 255);
                graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                n3 = 0;
                while (n3 < this.PATTERN_3.length) {
                    if (n3 == 2 || n3 == 5 || n3 == 8 || n3 == 11 || n3 == 18 || n3 == 21 || n3 == 25 || n3 == 28 || n3 == 31 || n3 == 33 || n3 == 36) {
                        this.setClipImage(graphics, this.PATTERN_3[n3][0] - 6, this.PATTERN_3[n3][1] - this.R_Y - 6, this.IMAGES[5], 27, 0, 12, 12, this.LT);
                    } else {
                        this.setClipImage(graphics, this.PATTERN_3[n3][0] - 6, this.PATTERN_3[n3][1] - this.R_Y - 6, this.IMAGES[5], 27, 14, 12, 12, this.LT);
                    }
                    ++n3;
                }
                break;
            }
            case 4: {
                graphics.setColor(109, 182, 171);
                graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                n3 = 0;
                while (n3 < this.PATTERN_4.length) {
                    if (n3 == 1 || n3 == 2 || n3 == 3 || n3 == 4 || n3 == 13 || n3 == 14 || n3 == 15 || n3 == 16) {
                        this.setClipImage(graphics, this.PATTERN_4[n3][0] - 6, this.PATTERN_4[n3][1] - this.R_Y - 6, this.IMAGES[5], 40, 0, 12, 12, this.LT);
                    } else {
                        this.setClipImage(graphics, this.PATTERN_4[n3][0] - 6, this.PATTERN_4[n3][1] - this.R_Y - 6, this.IMAGES[5], 40, 14, 12, 12, this.LT);
                    }
                    ++n3;
                }
                break;
            }
            case 5: {
                graphics.setColor(0);
                graphics.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                n3 = 0;
                while (n3 < this.PATTERN_5.length) {
                    if (n3 == 1 || n3 == 4 || n3 == 5 || n3 == 9 || n3 == 12 || n3 == 16 || n3 == 17 || n3 == 19 || n3 == 20 || n3 == 22 || n3 == 25 || n3 == 26) {
                        this.setClipImage(graphics, this.PATTERN_5[n3][0] - 6, this.PATTERN_5[n3][1] - this.R_Y - 6, this.IMAGES[5], 54, 0, 12, 12, this.LT);
                    } else {
                        this.setClipImage(graphics, this.PATTERN_5[n3][0] - 6, this.PATTERN_5[n3][1] - this.R_Y - 6, this.IMAGES[5], 54, 14, 12, 12, this.LT);
                    }
                    ++n3;
                }
                break;
            }
        }
        if (this.blink < 2) {
            --this.R_Y;
        }
        ++this.blink;
        this.blink %= 3;
        if (this.R_Y <= 0) {
            this.R_Y = 640;
        }
        if (this.bBomb) {
            n3 = 0;
            while (n3 < 7) {
                int n4 = n3++;
                this.nBombY[n4] = this.nBombY[n4] - 10;
            }
            if (this.nBombY[0] < 0) {
                this.bBomb = false;
                this.nBombGauge = 0;
            }
        }
        n3 = 0;
        while (n3 < this.nDragonBullet) {
            this.unit1 = this.unitDBullet[n3];
            if (this.unit1.bUsed) {
                this.unit1.nY -= 5;
                if (this.unit1.nY < 0) {
                    this.unit1.initialize();
                }
            }
            ++n3;
        }
        if (this.bBoss) {
            if (this.unitBoss.bUsed) {
                if (this.unitBoss.nPattern == 10) {
                    if (this.unitBoss.nFrame < 5) {
                        this.unitBoss.nY += 2;
                    } else if (this.unitBoss.nFrame < 15) {
                        this.unitBoss.nX -= 2;
                    } else if (this.unitBoss.nFrame < 30) {
                        this.unitBoss.nY += 2;
                    } else if (this.unitBoss.nFrame >= 33) {
                        if (this.unitBoss.nFrame < 48) {
                            this.unitBoss.nY -= 2;
                        } else if (this.unitBoss.nFrame < 58) {
                            this.unitBoss.nX += 2;
                        } else if (this.unitBoss.nFrame < 73) {
                            this.unitBoss.nY += 2;
                        } else if (this.unitBoss.nFrame >= 76) {
                            if (this.unitBoss.nFrame < 91) {
                                this.unitBoss.nY -= 2;
                            } else if (this.unitBoss.nFrame < 101) {
                                this.unitBoss.nX += 2;
                            } else if (this.unitBoss.nFrame < 116) {
                                this.unitBoss.nY += 2;
                            } else if (this.unitBoss.nFrame >= 119) {
                                if (this.unitBoss.nFrame < 134) {
                                    this.unitBoss.nY -= 2;
                                } else if (this.unitBoss.nFrame < 144) {
                                    this.unitBoss.nX -= 2;
                                } else {
                                    this.unitBoss.nFrame = 4;
                                }
                            }
                        }
                    }
                } else if (this.unitBoss.nPattern == 11) {
                    if (this.unitBoss.nFrame < 7) {
                        this.unitBoss.nY += 2;
                    } else if (this.unitBoss.nFrame >= 10) {
                        if (this.unitBoss.nFrame < 22) {
                            this.unitBoss.nX -= 2;
                        } else if (this.unitBoss.nFrame >= 25) {
                            if (this.unitBoss.nFrame < 37) {
                                this.unitBoss.nX += 2;
                            } else if (this.unitBoss.nFrame >= 40) {
                                if (this.unitBoss.nFrame < 52) {
                                    this.unitBoss.nX += 2;
                                } else if (this.unitBoss.nFrame >= 55) {
                                    if (this.unitBoss.nFrame < 67) {
                                        this.unitBoss.nX -= 2;
                                    } else {
                                        this.unitBoss.nFrame = 6;
                                    }
                                }
                            }
                        }
                    }
                } else if (this.unitBoss.nPattern == 12) {
                    if (this.unitBoss.nFrame < 7) {
                        this.unitBoss.nY += 2;
                    } else if (this.unitBoss.nFrame >= 10) {
                        if (this.unitBoss.nFrame < 22) {
                            this.unitBoss.nX -= 2;
                        } else if (this.unitBoss.nFrame >= 25) {
                            if (this.unitBoss.nFrame < 37) {
                                this.unitBoss.nX += 2;
                            } else if (this.unitBoss.nFrame >= 40) {
                                if (this.unitBoss.nFrame < 52) {
                                    this.unitBoss.nX += 2;
                                } else if (this.unitBoss.nFrame >= 55) {
                                    if (this.unitBoss.nFrame < 67) {
                                        this.unitBoss.nX -= 2;
                                    } else if (this.unitBoss.nFrame >= 70) {
                                        if (this.unitBoss.nFrame < 82) {
                                            this.unitBoss.nX -= 2;
                                        } else if (this.unitBoss.nFrame < 102) {
                                            this.unitBoss.nY += 2;
                                        } else if (this.unitBoss.nFrame >= 105) {
                                            if (this.unitBoss.nFrame < 129) {
                                                this.unitBoss.nX += 2;
                                            } else if (this.unitBoss.nFrame >= 132) {
                                                if (this.unitBoss.nFrame < 152) {
                                                    this.unitBoss.nY -= 2;
                                                } else if (this.unitBoss.nFrame >= 155) {
                                                    if (this.unitBoss.nFrame < 167) {
                                                        this.unitBoss.nX -= 2;
                                                    } else {
                                                        this.unitBoss.nFrame = 6;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                ++this.unitBoss.nFrame;
                if (Math.abs(this.rndRand.nextInt()) % 20 == 0) {
                    n3 = 0;
                    n2 = 0;
                    while (n3 < this.nStageBullet) {
                        this.unit1 = this.unitEBullet[n3];
                        if (!this.unit1.bUsed) {
                            this.unit1.create(this.unitBoss.nX, this.unitBoss.nY);
                            this.unit1.nPattern = 100 + n2;
                            ++n2;
                        }
                        ++n3;
                    }
                }
            }
            n3 = 0;
            while (n3 < this.nStageBullet) {
                this.unit1 = this.unitEBullet[n3];
                if (this.unit1.bUsed) {
                    n = this.unitEBullet[n3].nPattern;
                    if (n == 100) {
                        this.unit1.nY += 3;
                    } else if (n == 101) {
                        --this.unit1.nX;
                        this.unit1.nY += 3;
                    } else if (n == 102) {
                        this.unit1.nX -= 2;
                        this.unit1.nY += 3;
                    } else if (n == 103) {
                        ++this.unit1.nX;
                        this.unit1.nY += 3;
                    } else if (n == 104) {
                        this.unit1.nX += 2;
                        this.unit1.nY += 3;
                    }
                    if (this.unit1.nY > this.SCREEN_HEIGHT) {
                        this.unit1.initialize();
                    }
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < this.nStageUnit) {
                int n5;
                this.unit1 = this.unitEnemy[n3];
                if (this.unit1.bUsed) {
                    n5 = Math.abs(this.rndRand.nextInt());
                    if (n5 % 20 == 0 && !this.bBonus) {
                        n2 = 0;
                        while (n2 < this.nStageBullet) {
                            this.unit2 = this.unitEBullet[n2];
                            if (!this.unit2.bUsed) {
                                this.unit2.create(this.unit1.nX, this.unit1.nY);
                                this.unit2.nPattern = 100;
                                break;
                            }
                            ++n2;
                        }
                    } else {
                        if (this.unit1.nPattern == 0) {
                            if (this.unit1.nFrame < 10) {
                                this.unit1.nY += 3;
                            } else if (this.unit1.nFrame < 35) {
                                this.unit1.nX += 3;
                            } else {
                                this.unit1.nY -= 3;
                            }
                        } else if (this.unit1.nPattern == 1) {
                            if (this.unit1.nFrame < 30) {
                                this.unit1.nX += 3;
                            } else if (this.unit1.nFrame < 34) {
                                this.unit1.nY += 3;
                            } else {
                                this.unit1.nX -= 3;
                            }
                        } else if (this.unit1.nPattern == 2) {
                            if (this.unit1.nFrame < 30) {
                                this.unit1.nX -= 3;
                            } else if (this.unit1.nFrame < 34) {
                                this.unit1.nY += 3;
                            } else {
                                this.unit1.nX += 3;
                            }
                        } else if (this.unit1.nPattern == 3) {
                            if (this.unit1.nFrame < 15) {
                                this.unit1.nY -= 3;
                            } else if (this.unit1.nFrame < 40) {
                                this.unit1.nX += 3;
                            } else {
                                this.unit1.nY += 3;
                            }
                        } else if (this.unit1.nPattern == 4) {
                            if (this.unit1.nFrame < 10) {
                                this.unit1.nY += 3;
                            } else {
                                this.unit1.nX += 2;
                                this.unit1.nY += 3;
                            }
                        } else if (this.unit1.nPattern == 5) {
                            if (this.unit1.nFrame < 10) {
                                this.unit1.nY += 3;
                            } else {
                                this.unit1.nX -= 2;
                                this.unit1.nY += 3;
                            }
                        } else if (this.unit1.nPattern == 6) {
                            if (this.unit1.nFrame < 15) {
                                this.unit1.nY += 3;
                            } else if (this.unit1.nFrame >= 20) {
                                this.unit1.nY -= 3;
                            }
                        } else if (this.unit1.nPattern == 8) {
                            this.unit1.nY += 5;
                        } else if (this.unit1.nPattern == 9) {
                            this.unit1.nY += 2;
                        }
                        ++this.unit1.nFrame;
                        if (this.unit1.nY < 0 || this.unit1.nY > this.SCREEN_HEIGHT || this.unit1.nX < 0 || this.unit1.nX > this.SCREEN_WIDTH) {
                            this.unit1.initialize();
                        }
                    }
                } else {
                    n5 = Math.abs(this.rndRand.nextInt());
                    if (n5 % 10 == 0) {
                        if (this.bBonus) {
                            if (n3 % 3 == 0) {
                                this.unit1.create(Math.abs(this.rndRand.nextInt()) % this.SCREEN_WIDTH, 0, 2 * this.nStageLife, this.nStageAttack * 2);
                                this.unit1.nPattern = 9;
                                this.unit1.nType = 3;
                                this.unit1.nItem = 2;
                                this.unit1.nScore = 2 * this.nStageScore;
                            } else {
                                this.unit1.create(Math.abs(this.rndRand.nextInt()) % this.SCREEN_WIDTH, 0, this.nStageLife, this.nStageAttack);
                                this.unit1.nPattern = 8;
                                this.unit1.nType = 2;
                                this.unit1.nItem = 2;
                                this.unit1.nScore = this.nStageScore;
                            }
                        } else {
                            n = Math.abs(this.rndRand.nextInt()) % 7;
                            if (n == 0) {
                                this.unit1.create(10, 0, this.nStageLife, this.nStageAttack);
                            } else if (n == 1) {
                                this.unit1.create(0, 10, this.nStageLife, this.nStageAttack);
                            } else if (n == 2) {
                                this.unit1.create(this.SCREEN_WIDTH, 10, this.nStageLife, this.nStageAttack);
                            } else if (n == 3) {
                                this.unit1.create(10, this.SCREEN_HEIGHT, this.nStageLife, this.nStageAttack);
                            } else if (n == 4) {
                                this.unit1.create(10, 0, this.nStageLife, this.nStageAttack);
                            } else if (n == 5) {
                                this.unit1.create(this.SCREEN_WIDTH - 10, 0, this.nStageLife, this.nStageAttack);
                            } else if (n == 6) {
                                this.unit1.create(this.nScreenCenterX, 0, this.nStageLife, this.nStageAttack);
                            }
                            this.unit1.nPattern = n;
                            n5 = Math.abs(this.rndRand.nextInt());
                            this.unit1.nType = n5 % 4;
                            this.unit1.nScore = this.nStageScore;
                            this.unit1.nItem = (n5 %= 20) == 18 ? 1 : (n5 == 19 ? 0 : 2);
                        }
                    }
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.nStageBullet) {
                this.unit1 = this.unitEBullet[n3];
                if (this.unit1.bUsed) {
                    n = this.unitEBullet[n3].nPattern;
                    this.unit1.nY += 5;
                    if (this.unit1.nY > this.SCREEN_HEIGHT) {
                        this.unit1.initialize();
                    }
                }
                ++n3;
            }
        }
        if (this.unitItem.bUsed) {
            if (this.unitItem.nPattern == 30) {
                this.unitItem.nX += 2;
                this.unitItem.nY += 2;
            } else if (this.unitItem.nPattern == 31) {
                this.unitItem.nX += 2;
                this.unitItem.nY -= 2;
            } else if (this.unitItem.nPattern == 32) {
                this.unitItem.nX -= 2;
                this.unitItem.nY -= 2;
            } else if (this.unitItem.nPattern == 33) {
                this.unitItem.nX -= 2;
                this.unitItem.nY += 2;
            }
            if (this.unitItem.nFrame < 100) {
                if (this.unitItem.nX < 0) {
                    this.unitItem.nPattern = 30;
                } else if (this.unitItem.nY < 0) {
                    this.unitItem.nPattern = 33;
                } else if (this.unitItem.nX > this.SCREEN_WIDTH) {
                    this.unitItem.nPattern = 32;
                } else if (this.unitItem.nY > this.SCREEN_HEIGHT) {
                    this.unitItem.nPattern = 31;
                }
            } else if (this.unitItem.nX < 0 || this.unitItem.nX > this.SCREEN_WIDTH || this.unitItem.nY < 0 || this.unitItem.nY > this.SCREEN_HEIGHT) {
                this.unitItem.initialize();
            }
            ++this.unitItem.nFrame;
        }
        n3 = 0;
        while (n3 < this.nDragonBullet) {
            this.unit1 = this.unitDBullet[n3];
            if (this.unit1.bUsed) {
                n2 = 0;
                while (n2 < this.nStageUnit) {
                    this.unit2 = this.unitEnemy[n2];
                    if (this.unit2.bUsed && Math.abs(this.unit1.nX - this.unit2.nX) < 6 && Math.abs(this.unit1.nY - this.unit2.nY) < 6) {
                        this.unit2.nLife -= this.unit1.nAttack;
                        this.unit1.bomb();
                        if (this.unit2.nLife <= 0) {
                            this.unit2.bomb();
                            this.nScore += this.unit2.nScore;
                            if (this.unit2.nItem != 2 && !this.unitItem.bUsed) {
                                this.unitItem.create(this.unit2.nX, this.unit2.nY);
                                this.unitItem.nItem = this.unit2.nItem;
                                this.unitItem.nPattern = 32;
                            }
                            if (this.nBombGauge < 31) {
                                this.nBombGauge += 3;
                            }
                            ++this.nClearCnt;
                        }
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        if (this.bBonus) {
            n3 = 0;
            while (n3 < this.nStageUnit) {
                this.unit1 = this.unitEnemy[n3];
                if (this.unit1.bUsed && Math.abs(this.unit1.nX - this.unitDragon.nX) < 11 && Math.abs(this.unit1.nY - this.unitDragon.nY) < 12) {
                    this.vibrate(50, 100);
                    this.playSound(5);
                    this.unitDragon.bomb();
                    break;
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < this.nStageBullet) {
                this.unit1 = this.unitEBullet[n3];
                if (this.unit1.bUsed && Math.abs(this.unit1.nX - this.unitDragon.nX) < 6 && Math.abs(this.unit1.nY - this.unitDragon.nY) < 7) {
                    this.vibrate(50, 100);
                    this.playSound(5);
                    this.unitDragon.nLife -= this.unit1.nAttack;
                    this.unit1.bomb();
                    if (this.unitDragon.nLife <= 0) {
                        this.unitDragon.bomb();
                    }
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.nStageUnit) {
                this.unit1 = this.unitEnemy[n3];
                if (this.unit1.bUsed && Math.abs(this.unit1.nX - this.unitDragon.nX) < 11 && Math.abs(this.unit1.nY - this.unitDragon.nY) < 12) {
                    this.vibrate(50, 100);
                    this.playSound(5);
                    this.unitDragon.nLife -= this.unit1.nAttack;
                    this.unit1.nLife -= this.unitDragon.nAttack;
                    if (this.unitDragon.nLife <= 0) {
                        this.unitDragon.bomb();
                    }
                    if (this.unit1.nLife <= 0) {
                        this.unit1.bomb();
                    }
                }
                ++n3;
            }
        }
        if (this.unitItem.bUsed && Math.abs(this.unitItem.nX - this.unitDragon.nX) < 11 && Math.abs(this.unitItem.nY - this.unitDragon.nY) < 12) {
            if (this.unitItem.nItem == 0) {
                this.playSound(4);
                if (this.nDragonFire < 3) {
                    ++this.nDragonFire;
                } else {
                    this.nScore += 200;
                }
            } else if (this.unitItem.nItem == 1) {
                if (this.unitDragon.nLife > 50) {
                    this.nScore += 200;
                } else {
                    this.unitDragon.nLife += this.nStageItem;
                    if (this.unitDragon.nLife > 50) {
                        this.unitDragon.nLife = 50;
                    }
                }
            }
            this.unitItem.initialize();
        }
        ++this.nFrame;
        if (this.unitDragon.bUsed) {
            switch (this.keyFlag) {
                case 4: {
                    if (this.unitDragon.nX <= 5) break;
                    this.unitDragon.nX -= 5;
                    break;
                }
                case 6: {
                    if (this.unitDragon.nX >= this.SCREEN_WIDTH - 5) break;
                    this.unitDragon.nX += 5;
                    break;
                }
                case 2: {
                    if (this.unitDragon.nY <= 5) break;
                    this.unitDragon.nY -= 5;
                    break;
                }
                case 8: {
                    if (this.unitDragon.nY >= this.SCREEN_HEIGHT - 7) break;
                    this.unitDragon.nY += 5;
                }
            }
            if (this.nDragonIndex >= 10) {
                this.setClipImage(graphics, this.unitDragon.nX - 13, this.unitDragon.nY - 15, this.IMAGES[6], 0, 0, 26, 29, this.LT);
            } else if (this.nDragonIndex >= 5) {
                this.setClipImage(graphics, this.unitDragon.nX - 13, this.unitDragon.nY - 14, this.IMAGES[6], 0, 32, 26, 27, this.LT);
            } else if (this.nDragonIndex >= 0) {
                this.setClipImage(graphics, this.unitDragon.nX - 13, this.unitDragon.nY - 15, this.IMAGES[6], 0, 62, 26, 29, this.LT);
            }
            this.nDragonIndex = this.nDragonIndex > 14 ? 0 : this.nDragonIndex + 1;
        } else if (this.unitDragon.bExplosion) {
            this.setClipImage(graphics, this.unitDragon.nX - 11, this.unitDragon.nY - 11, this.IMAGES[8], this.unitDragon.nAni * 22, 0, 22, 22, this.LT);
            ++this.unitDragon.nAni;
            if (this.unitDragon.nAni >= 3) {
                if (this.bBonus) {
                    this.unitDragon.bUsed = true;
                    this.initStage(this.nStage + 1);
                } else {
                    this.unitDragon.initialize();
                    this.bOver = true;
                    this.nFrame = 0;
                    return;
                }
            }
        }
        if (this.bBoss) {
            if (this.unitBoss.bUsed) {
                if (this.nStage == 1) {
                    graphics.drawImage(this.IMAGES[18], this.unitBoss.nX, this.unitBoss.nY, this.CC);
                } else if (this.nStage == 2) {
                    graphics.drawImage(this.IMAGES[19], this.unitBoss.nX, this.unitBoss.nY, this.CC);
                } else if (this.nStage == 3) {
                    graphics.drawImage(this.IMAGES[20], this.unitBoss.nX, this.unitBoss.nY, this.CC);
                } else if (this.nStage == 4) {
                    graphics.drawImage(this.IMAGES[21], this.unitBoss.nX, this.unitBoss.nY, this.CC);
                } else if (this.nStage == 5) {
                    graphics.drawImage(this.IMAGES[22], this.unitBoss.nX, this.unitBoss.nY, this.CC);
                }
            } else if (this.unitBoss.bExplosion) {
                this.setClipImage(graphics, this.unitDragon.nX - 5 - 11, this.unitDragon.nY + 3 - 11, this.IMAGES[8], (this.unitBoss.nAni + 1) % 3 * 22, 0, 22, 22, this.LT);
                this.setClipImage(graphics, this.unitDragon.nX - 11, this.unitDragon.nY - 11, this.IMAGES[8], (this.unitBoss.nAni + 2) % 3 * 22, 0, 22, 22, this.LT);
                this.setClipImage(graphics, this.unitDragon.nX + 6 - 11, this.unitDragon.nY - 11, this.IMAGES[8], this.unitBoss.nAni % 3 * 22, 0, 22, 22, this.LT);
                this.setClipImage(graphics, this.unitDragon.nX + 3 - 11, this.unitDragon.nY - 5 - 11, this.IMAGES[8], this.unitBoss.nAni % 3 * 22, 0, 22, 22, this.LT);
                ++this.unitBoss.nAni;
                if (this.unitBoss.nAni >= 21) {
                    this.playSound(6);
                    this.initBonus();
                    return;
                }
            }
            n3 = 0;
            while (n3 < this.nDragonBullet) {
                this.unit1 = this.unitDBullet[n3];
                if (this.unit1.bUsed) {
                    graphics.drawImage(this.IMAGES[9], this.unit1.nX, this.unit1.nY, this.CC);
                } else if (this.unit1.bExplosion) {
                    this.setClipImage(graphics, this.unit1.nX - 11, this.unit1.nY - 11, this.IMAGES[8], this.unit1.nAni * 22, 0, 22, 22, this.LT);
                    ++this.unit1.nAni;
                    if (this.unit1.nAni >= 3) {
                        this.unit1.initialize();
                    }
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < this.nStageUnit) {
                this.unit1 = this.unitEnemy[n3];
                if (this.unit1.bUsed) {
                    this.setClipImage(graphics, this.unit1.nX - 8, this.unit1.nY - 8, this.IMAGES[11], this.unit1.nType * 15, (this.nStage - 1) * 15, 15, 15, this.LT);
                } else if (this.unit1.bExplosion) {
                    this.setClipImage(graphics, this.unit1.nX - 11, this.unit1.nY - 11, this.IMAGES[8], this.unit1.nAni * 22, 0, 22, 22, this.LT);
                    ++this.unit1.nAni;
                    if (this.unit1.nAni >= 3) {
                        this.unit1.initialize();
                    }
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.nDragonBullet) {
                this.unit1 = this.unitDBullet[n3];
                if (this.unit1.bUsed) {
                    graphics.drawImage(this.IMAGES[9], this.unit1.nX, this.unit1.nY, this.CC);
                } else if (this.unit1.bExplosion) {
                    this.setClipImage(graphics, this.unit1.nX - 8, this.unit1.nY - 7, this.IMAGES[7], this.unit1.nAni * 15, 0, 15, 14, this.LT);
                    ++this.unit1.nAni;
                    if (this.unit1.nAni >= 3) {
                        this.unit1.initialize();
                    }
                }
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < this.nStageBullet) {
            this.unit1 = this.unitEBullet[n3];
            if (this.unit1.bUsed) {
                graphics.drawImage(this.IMAGES[10], this.unit1.nX, this.unit1.nY, this.CC);
            } else if (this.unit1.bExplosion) {
                this.setClipImage(graphics, this.unit1.nX - 8, this.unit1.nY - 7, this.IMAGES[7], this.unit1.nAni * 15, 0, 15, 14, this.LT);
                ++this.unit1.nAni;
                if (this.unit1.nAni >= 3) {
                    this.unit1.initialize();
                }
            }
            ++n3;
        }
        if (this.bBomb) {
            n3 = 0;
            while (n3 < 7) {
                graphics.drawImage(this.IMAGES[12], this.nBombX[n3], this.nBombY[n3], this.CC);
                ++n3;
            }
        }
        if (this.unitItem.bUsed) {
            this.setClipImage(graphics, this.unitItem.nX - 11, this.unitItem.nY - 10, this.IMAGES[13], this.unitItem.nItem * 22, 0, 22, 21, this.LT);
        }
        if (this.nStage < 5) {
            graphics.drawImage(this.IMAGES[14], 2, 2, 0);
            graphics.drawImage(this.IMAGES[14], this.SCREEN_WIDTH - 35, 2, 0);
            graphics.setColor(0);
        } else {
            graphics.drawImage(this.IMAGES[15], 2, 2, 0);
            graphics.drawImage(this.IMAGES[15], this.SCREEN_WIDTH - 35, 2, 0);
            graphics.setColor(0xFFFFFF);
        }
        graphics.fillRect(3, 3, this.unitDragon.nLife * 31 / 50, 4);
        graphics.fillRect(this.SCREEN_WIDTH - 34, 3, this.nBombGauge, 4);
        this.strScore = String.valueOf(this.nScore);
        n3 = 0;
        while (n3 < this.strScore.length()) {
            if (this.nStage < 5) {
                this.setClipImage(graphics, 40 + n3 * 7, 1, this.IMAGES[16], (this.strScore.charAt(n3) - 48) * 6, 0, 6, 10, this.LT);
            } else {
                this.setClipImage(graphics, 40 + n3 * 7, 1, this.IMAGES[17], (this.strScore.charAt(n3) - 48) * 6, 0, 6, 10, this.LT);
            }
            ++n3;
        }
        if (this.nFrame < 10) {
            if (this.bOver) {
                graphics.setColor(0);
                graphics.setFont(this.FONT_SMALL);
                graphics.drawString("FINE GIOCO", this.nScreenCenterX, 30, this.CT);
                this.playSound(3);
            } else if (this.bBonus) {
                graphics.setColor(0);
                graphics.setFont(this.FONT_SMALL);
                graphics.drawString("STADIO EXTRA", this.nScreenCenterX, 30, this.CT);
            } else if (this.bBoss) {
                graphics.setColor(0);
                graphics.setFont(this.FONT_SMALL);
                graphics.drawString("BOSS", this.nScreenCenterX, 30, this.CT);
            } else {
                if (this.nStage < 5) {
                    graphics.setColor(0);
                } else {
                    graphics.setColor(0xFFFFFF);
                }
                graphics.setFont(this.FONT_SMALL);
                graphics.drawString("STADIO " + this.nStage, this.nScreenCenterX, 30, this.CT);
            }
        } else {
            if (this.bOver) {
                this.saveData(this.nScore);
                this.setCurrentState(10);
                return;
            }
            if (this.nFrame > this.nStageClear) {
                if (this.bBonus) {
                    this.initStage(this.nStage + 1);
                    return;
                }
                if (!this.bBoss) {
                    n3 = 0;
                    while (n3 < this.nStageUnit) {
                        if (this.unitEnemy[n3].bUsed) break;
                        ++n3;
                    }
                    if (n3 == this.nStageUnit) {
                        this.initBoss();
                    }
                }
            }
        }
    }

    private void initBoss() {
        int n;
        int n2;
        int n3;
        int n4;
        this.bBonus = false;
        this.bBoss = true;
        int n5 = 0;
        while (n5 < 13) {
            this.unitEnemy[n5].initialize();
            ++n5;
        }
        this.unitBoss = this.unitEnemy[0];
        this.unitBoss.initialize();
        if (this.nStage == 1) {
            n4 = this.SCREEN_WIDTH / 2;
            n3 = 0;
            n2 = 400;
            n = 10;
            this.nStageClear = 1;
            this.nStageBullet = 5;
            this.nStageUnit = 1;
            this.nStageScore = 100;
            this.unitBoss.nPattern = 10;
        } else if (this.nStage == 2) {
            n4 = this.SCREEN_WIDTH / 2;
            n3 = 0;
            n2 = 400;
            n = 15;
            this.nStageClear = 1;
            this.nStageBullet = 5;
            this.nStageUnit = 1;
            this.nStageScore = 200;
            this.unitBoss.nPattern = 11;
        } else if (this.nStage == 3) {
            n4 = this.SCREEN_WIDTH / 2;
            n3 = 0;
            n2 = 500;
            n = 20;
            this.nStageClear = 1;
            this.nStageBullet = 5;
            this.nStageUnit = 1;
            this.nStageScore = 300;
            this.unitBoss.nPattern = 12;
        } else if (this.nStage == 4) {
            n4 = this.SCREEN_WIDTH / 2;
            n3 = 0;
            n2 = 600;
            n = 25;
            this.nStageClear = 1;
            this.nStageBullet = 5;
            this.nStageUnit = 1;
            this.nStageScore = 400;
            this.unitBoss.nPattern = 10;
        } else {
            n4 = this.SCREEN_WIDTH / 2;
            n3 = 0;
            n2 = 700;
            n = 25;
            this.nStageClear = 1;
            this.nStageBullet = 5;
            this.nStageUnit = 1;
            this.nStageScore = 500;
            this.unitBoss.nPattern = 11;
        }
        this.unitBoss.create(n4, n3, n2, n);
        this.unitBoss.nScore = this.nStageScore;
        this.nClearCnt = 0;
        this.nFrame = 0;
    }

    private void initBonus() {
        this.bBonus = true;
        this.bBoss = false;
        int n = 0;
        while (n < 13) {
            this.unitEnemy[n].initialize();
            ++n;
        }
        if (this.nStage == 1) {
            this.nStageClear = 300;
            this.nStageLife = 20;
            this.nStageAttack = 10;
            this.nStageUnit = 6;
            this.nStageScore = 10;
        } else if (this.nStage == 2) {
            this.nStageClear = 300;
            this.nStageLife = 20;
            this.nStageAttack = 10;
            this.nStageUnit = 7;
            this.nStageScore = 10;
        } else if (this.nStage == 3) {
            this.nStageClear = 300;
            this.nStageLife = 20;
            this.nStageAttack = 10;
            this.nStageUnit = 8;
            this.nStageScore = 10;
        } else if (this.nStage == 4) {
            this.nStageClear = 300;
            this.nStageLife = 20;
            this.nStageAttack = 10;
            this.nStageUnit = 9;
            this.nStageScore = 10;
        } else {
            this.nStageClear = 300;
            this.nStageLife = 20;
            this.nStageAttack = 10;
            this.nStageUnit = 10;
            this.nStageScore = 10;
        }
        this.nFrame = 0;
    }

    private void initStage(int n) {
        this.nDemoFrame = 0;
        this.nStage = n;
        if (this.nStage == 1) {
            this.nStageBullet = 5;
            this.nStageUnit = 4;
            this.nStageLife = 10;
            this.nStageAttack = 10;
            this.nStageItem = 100;
            this.nStageClear = 600;
            this.nStageScore = 10;
        } else if (this.nStage == 2) {
            this.nStageBullet = 7;
            this.nStageUnit = 6;
            this.nStageLife = 10;
            this.nStageAttack = 10;
            this.nStageItem = 80;
            this.nStageClear = 600;
            this.nStageScore = 10;
        } else if (this.nStage == 3) {
            this.nStageBullet = 9;
            this.nStageUnit = 8;
            this.nStageLife = 20;
            this.nStageAttack = 15;
            this.nStageItem = 60;
            this.nStageClear = 300;
            this.nStageScore = 20;
        } else if (this.nStage == 4) {
            this.nStageBullet = 11;
            this.nStageUnit = 10;
            this.nStageLife = 20;
            this.nStageAttack = 15;
            this.nStageItem = 60;
            this.nStageClear = 600;
            this.nStageScore = 20;
        } else {
            this.nStageBullet = 13;
            this.nStageUnit = 10;
            this.nStageLife = 30;
            this.nStageAttack = 20;
            this.nStageItem = 40;
            this.nStageClear = 600;
            this.nStageScore = 20;
        }
        this.nClearCnt = 0;
        int n2 = 0;
        while (n2 < 18) {
            this.unitDBullet[n2].initialize();
            this.unitDBullet[n2].nAttack = 10;
            ++n2;
        }
        n2 = 0;
        while (n2 < 13) {
            this.unitEnemy[n2].initialize();
            this.unitEnemy[n2].nLife = this.nStageLife;
            this.unitEnemy[n2].nAttack = this.nStageAttack;
            ++n2;
        }
        n2 = 0;
        while (n2 < 20) {
            this.unitEBullet[n2].initialize();
            this.unitEBullet[n2].nAttack = this.nStageAttack;
            ++n2;
        }
        this.bBomb = false;
        this.bBonus = false;
        this.bBoss = false;
        this.unitItem.initialize();
        this.bOver = false;
        this.nFrame = 0;
    }
}

