/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.StackElement;
import java.util.Vector;
import ral.Real;

public class CalcStack
extends Vector {
    public void clear() {
        super.removeAllElements();
    }

    public StackElement peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (StackElement)super.lastElement();
    }

    public StackElement pop() {
        if (this.isEmpty()) {
            return null;
        }
        StackElement se = this.peek();
        super.removeElementAt(super.size() - 1);
        return se;
    }

    public void push(StackElement stackElement) {
        super.addElement(stackElement);
    }

    public void push(int calcType) {
        super.addElement(new StackElement(calcType));
    }

    public void push(Real value) {
        super.addElement(new StackElement(value));
    }

    public void push(String valueString) {
        super.addElement(new StackElement(valueString));
    }

    public Real topMultiply(Real val) {
        if (!this.popTillNumber()) {
            return null;
        }
        if (this.peek().getCalcType() == 1) {
            this.push(this.pop().getValue());
        }
        this.peek().getValue().mul(val);
        return this.peek().getValue();
    }

    public Real topDivide(Real val) {
        if (!this.popTillNumber()) {
            return null;
        }
        if (this.peek().getCalcType() == 1) {
            this.push(this.pop().getValue());
        }
        this.peek().getValue().div(val);
        return this.peek().getValue();
    }

    public boolean popTillNumber() {
        StackElement top = this.peek();
        while (!this.isEmpty()) {
            if (top.isValue()) {
                return true;
            }
            this.pop();
            top = this.peek();
        }
        return false;
    }

    public void makeAllFinished() {
        for (int i = 0; i < this.size(); ++i) {
            if (((StackElement)this.elementAt(i)).getCalcType() != 1) continue;
            this.setElementAt(new StackElement(((StackElement)this.elementAt(i)).getValue()), i);
        }
    }

    private int getPrevPrio() {
        if (this.size() < 4) {
            return 0;
        }
        return this.fromEnd(3).getPriority();
    }

    public String toString(boolean displayAsArc) {
        return this.toString(null, displayAsArc);
    }

    public String toString(Real.NumberFormat format, boolean displayAsArc) {
        String ret = "";
        for (int i = 0; i < this.size(); ++i) {
            if (format == null) {
                ret = ret + ((StackElement)this.elementAt(i)).toString(format, displayAsArc) + "\n";
                continue;
            }
            ret = ret + ((StackElement)this.elementAt(i)).toString(format, displayAsArc);
            if (i >= this.size() - 1) continue;
            ret = ret + " ";
        }
        return ret;
    }

    public void evaluateEqual() {
        this.popTillNumber();
        while (this.size() > 1) {
            this.evaluateRP();
        }
        if (this.size() > 0 && this.peek().getCalcType() == 1) {
            this.push(this.pop().getValue());
        }
    }

    public void evaluateRP() {
        this.push(4);
        this.evaluate();
        this.pop();
        if (this.size() > 1 && this.fromEnd(2).getCalcType() == 3) {
            StackElement se = this.pop();
            this.pop();
            this.push(se);
        }
    }

    public void evaluatePercent() {
        if (!this.isEmpty() && this.peek().isValue()) {
            if (this.size() > 2 && this.fromEnd(3).isValue()) {
                if (this.fromEnd(2).getCalcType() == 4 || this.fromEnd(2).getCalcType() == 5) {
                    Real v2 = this.pop().getValue();
                    StackElement se = this.pop();
                    Real v1 = this.pop().getValue();
                    v2.div(100);
                    if (se.getCalcType() == 5) {
                        v2.neg();
                    }
                    v2.add(1);
                    v1.mul(v2);
                    this.push(v1);
                    return;
                }
                if (this.fromEnd(2).getCalcType() == 6) {
                    Real v2 = this.pop().getValue();
                    this.pop();
                    Real v1 = this.pop().getValue();
                    v2.div(100);
                    v1.mul(v2);
                    this.push(v1);
                    return;
                }
            }
            Real v1 = this.pop().getValue();
            v1.div(100);
            this.push(v1);
        }
    }

    public void evaluate() {
        if (this.isEmpty()) {
            return;
        }
        StackElement top = this.peek();
        switch (top.getCalcType()) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                while (this.size() >= 4 && this.getPrevPrio() >= top.getPriority()) {
                    this.pop();
                    Real v1 = this.pop().getValue();
                    StackElement se = this.pop();
                    Real v2 = this.pop().getValue();
                    this.push(this.performOperation(v2, se, v1));
                    this.push(top);
                }
                break block0;
            }
        }
    }

    private Real performOperation(Real v1, StackElement stackElement, Real v2) {
        switch (stackElement.getCalcType()) {
            case 4: {
                v1.add(v2);
                return v1;
            }
            case 5: {
                v1.sub(v2);
                return v1;
            }
            case 6: {
                v1.mul(v2);
                return v1;
            }
            case 7: {
                v1.div(v2);
                return v1;
            }
            case 8: {
                v1.pow(v2);
                return v1;
            }
        }
        return null;
    }

    public StackElement fromEnd(int num) {
        if (num < 1 || this.size() < num) {
            return null;
        }
        return (StackElement)this.elementAt(this.size() - num);
    }

    public void switchOperands() {
        int i;
        int i1 = -1;
        int i2 = -1;
        for (i = this.size() - 1; i >= 0; --i) {
            if (((StackElement)this.elementAt(i)).getCalcType() == 3) {
                return;
            }
            if (!((StackElement)this.elementAt(i)).isValue()) continue;
            i1 = i;
            break;
        }
        for (i = i1 - 1; i >= 0; --i) {
            if (!((StackElement)this.elementAt(i)).isValue()) continue;
            i2 = i;
            break;
        }
        if (i1 > 0 && i2 >= 0) {
            StackElement tmpSE = (StackElement)this.elementAt(i1);
            this.setElementAt(this.elementAt(i2), i1);
            this.setElementAt(tmpSE, i2);
        }
    }
}

