/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class EnemyManager {
    public static final int BOSS_TYPE_EGE_PLANE = 1;
    public static final int BOSS_TYPE_NORMAL_PLANE = 2;
    public static final int BOSS_TYPE_POWER_PLANE = 3;
    public static final int BOSS_TYPE_MASTER_PLANE = 4;
    public long st2 = 0L;
    long st = 0L;
    long et = 0L;
    long st3 = 0L;
    long oneStageStart = 0L;
    long twoStageStart = 0L;
    long threeStageStart = 0L;
    long fourStageStart = 0L;
    Sprite enemyTurnPlaneSprite;
    Sprite enemyCirclePlaneSprite;
    Sprite enemyHelicopterPlaneSprite;
    Sprite enemyTiedPlaneSprite;
    Sprite enemyBossEgePlaneSprite;
    Sprite enemyBossNormalPlaneSprite;
    Sprite enemyBossPowerPlaneSprite;
    Sprite enemyBossMasterPlaneSprite;
    Vector enemyPlaneVector;

    public EnemyManager(int stage) {
        this.init();
    }

    public void initStageData() {
        this.st = System.currentTimeMillis();
        this.et = 0L;
        this.st2 = this.st;
        System.gc();
    }

    private void init() {
        this.initStageData();
        this.enemyPlaneVector = new Vector();
        Image img = null;
        try {
            img = Image.createImage((String)"/enemi_3.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enemyTurnPlaneSprite = new Sprite(img, img.getWidth() / 5, img.getHeight());
        try {
            img = Image.createImage((String)"/enemi_4.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enemyCirclePlaneSprite = new Sprite(img, img.getWidth() / 8, img.getHeight());
        try {
            img = Image.createImage((String)"/enemi_1.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enemyHelicopterPlaneSprite = new Sprite(img, img.getWidth() / 2, img.getHeight());
        try {
            img = Image.createImage((String)"/enemi_2.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enemyTiedPlaneSprite = new Sprite(img, img.getWidth() / 4, img.getHeight());
        try {
            img = Image.createImage((String)"/boss_0.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enemyBossEgePlaneSprite = new Sprite(img, img.getWidth(), img.getHeight());
        try {
            img = Image.createImage((String)"/boss_1.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enemyBossNormalPlaneSprite = new Sprite(img, img.getWidth(), img.getHeight());
        try {
            img = Image.createImage((String)"/boss_2.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enemyBossPowerPlaneSprite = new Sprite(img, img.getWidth(), img.getHeight());
        try {
            img = Image.createImage((String)"/boss_3.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enemyBossMasterPlaneSprite = new Sprite(img, img.getWidth(), img.getHeight());
    }

    private void createNormalEnemyPlane() {
        Random rn = new Random();
        int x = 0;
        int y = 0;
        boolean fromLeftToRight = false;
        if (this.enemyPlaneVector.size() > 20) {
            return;
        }
        if (rn.nextInt() % 2 == 0) {
            x = 1;
            y = 1;
            fromLeftToRight = true;
            EnemyTurnBackPlane bl = new EnemyTurnBackPlane(this.enemyTurnPlaneSprite, x, y, fromLeftToRight);
            this.enemyPlaneVector.addElement(bl);
        } else if (rn.nextInt() % 3 == 0) {
            x = Util.screenWidth - 1;
            y = 1;
            fromLeftToRight = false;
            EnemyTurnBackPlane bl = new EnemyTurnBackPlane(this.enemyTurnPlaneSprite, x, y, fromLeftToRight);
            this.enemyPlaneVector.addElement(bl);
        } else if (rn.nextInt() % 5 == 0) {
            if (rn.nextInt() % 2 == 0) {
                fromLeftToRight = false;
                x = Util.screenWidth - this.enemyHelicopterPlaneSprite.getWidth() / 2 - 1;
            } else {
                fromLeftToRight = true;
                x = -this.enemyHelicopterPlaneSprite.getWidth() / 2 - 1;
            }
            y = rn.nextInt(3 * Util.screenHeight / 4);
            EnemyHelicopterPlane bl = new EnemyHelicopterPlane(this.enemyHelicopterPlaneSprite, x, y, fromLeftToRight);
            this.enemyPlaneVector.addElement(bl);
        } else {
            EnemyCirclePlaneSprite bl = new EnemyCirclePlaneSprite(this.enemyCirclePlaneSprite, Util.screenWidth / 4, y);
            this.enemyPlaneVector.addElement(bl);
        }
    }

    private void createStageOneData() {
        if (!Util.isBossScreen) {
            this.createOneStagePlane();
            if (this.et - this.st2 > 60000L) {
                EnemyBossEgePlane bl = new EnemyBossEgePlane(this.enemyBossEgePlaneSprite, Util.screenWidth / 2, 0);
                this.enemyPlaneVector.addElement(bl);
                Util.gotoBossScreen();
                this.st2 = 0L;
            }
        } else if (this.enemyPlaneVector.size() == 0) {
            Util.bulletManager.initStageData();
            if (this.et - this.st2 > 3000L) {
                Util.int_fire_bulletSelect = 1;
                Util.invincibleMode = false;
                Util.f_dunpai = false;
                Util.gotoNextStage();
            }
        } else {
            this.st2 = System.currentTimeMillis();
        }
    }

    private void createStageTwoData() {
        if (!Util.isBossScreen) {
            this.createTwoStagePlane();
            if (this.et - this.st2 > 60000L) {
                EnemyBossNormalPlane bl = new EnemyBossNormalPlane(this.enemyBossNormalPlaneSprite, Util.screenWidth / 2, 0);
                this.enemyPlaneVector.addElement(bl);
                Util.gotoBossScreen();
                this.st2 = 0L;
            }
        } else if (this.enemyPlaneVector.size() == 0) {
            Util.bulletManager.initStageData();
            if (this.et - this.st2 > 3000L) {
                Util.int_fire_bulletSelect = 1;
                Util.invincibleMode = false;
                Util.f_dunpai = false;
                Util.gotoNextStage();
            }
        } else {
            this.st2 = System.currentTimeMillis();
        }
    }

    private void createStageThreeData() {
        if (!Util.isBossScreen) {
            this.createThreeStagePlane();
            if (this.et - this.st2 > 60000L) {
                EnemyBossPowerPlane bl = new EnemyBossPowerPlane(this.enemyBossPowerPlaneSprite, Util.screenWidth / 2, 0);
                this.enemyPlaneVector.addElement(bl);
                Util.gotoBossScreen();
                this.st2 = 0L;
            }
        } else if (this.enemyPlaneVector.size() == 0) {
            Util.bulletManager.initStageData();
            if (this.et - this.st2 > 3000L) {
                Util.int_fire_bulletSelect = 1;
                Util.invincibleMode = false;
                Util.f_dunpai = false;
                Util.gotoNextStage();
            }
        } else {
            this.st2 = System.currentTimeMillis();
        }
    }

    private void createStageFourData() {
        if (!Util.isBossScreen) {
            this.createFourStagePlane();
            if (this.et - this.st2 > 60000L) {
                EnemyBossMasterPlane bl = new EnemyBossMasterPlane(this.enemyBossMasterPlaneSprite, Util.screenWidth / 2, 0);
                this.enemyPlaneVector.addElement(bl);
                Util.gotoBossScreen();
                this.st2 = 0L;
            }
        } else if (this.enemyPlaneVector.size() == 0) {
            Util.bulletManager.initStageData();
            if (this.et - this.st2 > 3000L) {
                Util.int_fire_bulletSelect = 1;
                Util.invincibleMode = false;
                Util.f_dunpai = false;
                Util.gotoNextStage();
            }
        } else {
            this.st2 = System.currentTimeMillis();
        }
    }

    public void autoCreateEnemyPlane() {
        this.et = System.currentTimeMillis();
        if (this.et - this.st < 500L) {
            return;
        }
        this.st = this.et;
        switch (Util.stage) {
            case 1: {
                this.createStageOneData();
                break;
            }
            case 2: {
                this.createStageTwoData();
                break;
            }
            case 3: {
                this.createStageThreeData();
                break;
            }
            case 4: {
                this.createStageFourData();
            }
        }
    }

    private boolean masterSkillLaserBulletDoWith(BasicBullet bl, BulletManager bulletManager, ExplosionManager explosionManager) {
        boolean haveChange = false;
        Vector bulletVector = bulletManager.bulletVector;
        int i = 0;
        while (i < bulletVector.size()) {
            BasicBullet t = (BasicBullet)bulletVector.elementAt(i);
            if (t.isEnemySendBullet() && t.masterSkillBulletType() == 0 && t.getRightBottomY() >= bl.getLeftTopY()) {
                bulletVector.removeElement(t);
                if (--i < 0) {
                    i = 0;
                }
                haveChange = true;
            }
            ++i;
        }
        int j = 0;
        while (j < this.enemyPlaneVector.size()) {
            BasicPlane plane = (BasicPlane)this.enemyPlaneVector.elementAt(j);
            if (plane.getBossType() == 0 && plane.getRightBottomY() >= bl.getLeftTopY()) {
                if (plane.changeLife(-bl.getAttach()) > 0) {
                    plane.setNeedDrawShadow(true);
                    explosionManager.createExplosion(plane.getX(), plane.getY(), 1);
                } else {
                    explosionManager.createExplosion(plane.getX(), plane.getY(), 0);
                    this.enemyPlaneVector.removeElement(plane);
                }
                haveChange = true;
                break;
            }
            ++j;
        }
        return haveChange;
    }

    public void meetCheck(BulletManager bulletManager, ExplosionManager explosionManager) {
        Vector bulletVector = bulletManager.bulletVector;
        int i = 0;
        while (i < this.enemyPlaneVector.size()) {
            BasicPlane bl = (BasicPlane)this.enemyPlaneVector.elementAt(i);
            int j = 0;
            while (j < bulletVector.size()) {
                block16: {
                    BasicBullet t;
                    block17: {
                        t = (BasicBullet)bulletVector.elementAt(j);
                        if (t.isEnemySendBullet()) break block16;
                        if (t.masterSkillBulletType() == 0) break block17;
                        switch (t.masterSkillBulletType()) {
                            case 1: {
                                if (this.masterSkillLaserBulletDoWith(t, bulletManager, explosionManager)) {
                                    j = 0;
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                        break block16;
                    }
                    if (bl.meetObject(t)) {
                        if (bl.changeLife(-t.getAttach()) > 0) {
                            bl.setNeedDrawShadow(true);
                            explosionManager.createExplosion(t.getX(), bl.getY(), 1);
                            bulletVector.removeElement(t);
                            if (--j < 0) {
                                j = 0;
                            }
                        } else {
                            if (bl.getBossType() == 0) {
                                explosionManager.createExplosion(bl.getX(), bl.getY(), 0);
                            } else {
                                explosionManager.createBossExplosion(bl.getX(), bl.getY(), bl.getWidth(), bl.getHeight());
                            }
                            Random rn = new Random();
                            if (rn.nextInt(5) == 3) {
                                int type = rn.nextInt(4);
                                if (type < 1) {
                                    type = 1;
                                }
                                if (type > 3) {
                                    type = 3;
                                }
                                Util.cloudManager.createTreasure(bl.getX(), bl.getY(), type);
                            }
                            rn = null;
                            this.enemyPlaneVector.removeElement(bl);
                            if (--i < 0) {
                                i = 0;
                            }
                            bulletVector.removeElement(t);
                            break;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void calcEnemyPlane(BulletManager blManager) {
        BasicPlane bl;
        int i = 0;
        while (i < this.enemyPlaneVector.size()) {
            bl = (BasicPlane)this.enemyPlaneVector.elementAt(i);
            bl.move();
            if (bl.canSendBullet()) {
                if (bl.getBossType() == 0) {
                    blManager.createBullet(bl.getX(), bl.getY(), true, bl.getBulletType());
                } else {
                    blManager.createBossBullet(bl.getX(), bl.getY(), bl.getBossType());
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.enemyPlaneVector.size()) {
            bl = (BasicPlane)this.enemyPlaneVector.elementAt(i);
            if (bl.canDestroySelf()) {
                this.enemyPlaneVector.removeElement(bl);
                if (--i < 0) {
                    i = 0;
                }
            }
            ++i;
        }
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.enemyPlaneVector.size()) {
            GameObject bl = (GameObject)this.enemyPlaneVector.elementAt(i);
            bl.draw(g);
            ++i;
        }
    }

    private void createOneStagePlane() {
        if (this.enemyPlaneVector.size() > 10) {
            return;
        }
        long end = System.currentTimeMillis();
        if (end - this.oneStageStart > 3000L) {
            this.oneStageStart = end;
            Random rn = new Random();
            int i = 0;
            while (i < 5) {
                EnemyTurnBackPlane bl;
                int x = 0;
                int y = 0;
                boolean fromLeftToRight = false;
                if (rn.nextInt() % 3 == 0) {
                    x = 10;
                    y = 1 - i * 20;
                    fromLeftToRight = true;
                    bl = new EnemyTurnBackPlane(this.enemyTurnPlaneSprite, x, y, fromLeftToRight);
                    this.enemyPlaneVector.addElement(bl);
                } else if (rn.nextInt() % 5 == 0) {
                    x = Util.screenWidth - 10;
                    y = 1 - i * 20;
                    fromLeftToRight = false;
                    bl = new EnemyTurnBackPlane(this.enemyTurnPlaneSprite, x, y, fromLeftToRight);
                    this.enemyPlaneVector.addElement(bl);
                }
                ++i;
            }
        }
    }

    private void createTwoStagePlane() {
        BasicPlane bl;
        if (this.enemyPlaneVector.size() > 20) {
            return;
        }
        Random rn = new Random();
        int x = 0;
        int y = 0;
        boolean fromLeftToRight = false;
        long end = System.currentTimeMillis();
        if (end - this.twoStageStart > 8000L) {
            this.twoStageStart = end;
        }
        if (rn.nextInt() % 2 == 0) {
            x = 1;
            y = 1;
            fromLeftToRight = true;
            bl = new EnemyTurnBackPlane(this.enemyTurnPlaneSprite, x, y, fromLeftToRight);
            this.enemyPlaneVector.addElement(bl);
        } else if (rn.nextInt() % 3 == 0) {
            x = Util.screenWidth - 1;
            y = 1;
            fromLeftToRight = false;
            bl = new EnemyTurnBackPlane(this.enemyTurnPlaneSprite, x, y, fromLeftToRight);
            this.enemyPlaneVector.addElement(bl);
        } else {
            bl = new EnemyCirclePlaneSprite(this.enemyCirclePlaneSprite, Util.screenWidth / 4, y);
            this.enemyPlaneVector.addElement(bl);
        }
        if ((end - this.st3) % 3L == 0L && (end - this.st3) % 7L == 0L) {
            EnemyTiedPlane pl = null;
            int i = 0;
            while (i < 2) {
                pl = i < 1 ? new EnemyTiedPlane(this.enemyTiedPlaneSprite, Util.screenWidth - 2 * this.enemyTiedPlaneSprite.getWidth(), 0, false) : new EnemyTiedPlane(this.enemyTiedPlaneSprite, Util.screenWidth - 3 * this.enemyTiedPlaneSprite.getWidth(), 10, false);
                this.enemyPlaneVector.addElement(pl);
                ++i;
            }
        }
    }

    private void createThreeStagePlane() {
        BasicPlane bl;
        if (this.enemyPlaneVector.size() > 20) {
            return;
        }
        Random rn = new Random();
        int x = 0;
        int y = 0;
        boolean fromLeftToRight = false;
        long end = System.currentTimeMillis();
        if (end - this.twoStageStart > 8000L) {
            this.twoStageStart = end;
        }
        if (rn.nextInt() % 7 == 0) {
            x = 1;
            y = 1;
            fromLeftToRight = true;
            bl = new EnemyTurnBackPlane(this.enemyTurnPlaneSprite, x, y, fromLeftToRight);
            this.enemyPlaneVector.addElement(bl);
        } else if (rn.nextInt() % 3 != 0) {
            if (rn.nextInt() % 5 == 0) {
                if (rn.nextInt() % 2 == 0) {
                    fromLeftToRight = false;
                    x = Util.screenWidth - this.enemyHelicopterPlaneSprite.getWidth() / 2 - 1;
                }
                y = rn.nextInt(3 * Util.screenHeight / 4);
                bl = new EnemyHelicopterPlane(this.enemyHelicopterPlaneSprite, x, y, fromLeftToRight);
                this.enemyPlaneVector.addElement(bl);
            } else {
                bl = new EnemyCirclePlaneSprite(this.enemyCirclePlaneSprite, Util.screenWidth / 5, y);
                this.enemyPlaneVector.addElement(bl);
            }
        }
        if (end - this.st3 > 10000L) {
            this.st3 = end;
            EnemyTiedPlane pl = null;
            int i = 0;
            while (i < 2) {
                pl = i < 1 ? new EnemyTiedPlane(this.enemyTiedPlaneSprite, (1 + i) * this.enemyTiedPlaneSprite.getWidth() + 10, i, false) : new EnemyTiedPlane(this.enemyTiedPlaneSprite, Util.screenWidth / 2 + (i - 3 + 1) * this.enemyTiedPlaneSprite.getWidth() + 10, 1 + 5 * i, false);
                this.enemyPlaneVector.addElement(pl);
                ++i;
            }
        }
    }

    private void createFourStagePlane() {
        if (this.enemyPlaneVector.size() > 20) {
            return;
        }
        Random rn = new Random();
        int x = 0;
        int y = 0;
        boolean fromLeftToRight = false;
        long end = System.currentTimeMillis();
        if (end - this.twoStageStart > 8000L) {
            this.twoStageStart = end;
        }
        if (rn.nextInt() % 7 != 0) {
            BasicPlane bl;
            if (rn.nextInt() % 3 == 0) {
                x = Util.screenWidth - 1;
                y = 1;
                fromLeftToRight = false;
                bl = new EnemyTurnBackPlane(this.enemyTurnPlaneSprite, x, y, fromLeftToRight);
                this.enemyPlaneVector.addElement(bl);
            } else if (rn.nextInt() % 5 == 0) {
                if (rn.nextInt() % 2 == 0) {
                    fromLeftToRight = false;
                    x = Util.screenWidth - this.enemyHelicopterPlaneSprite.getWidth() / 2 - 1;
                } else {
                    fromLeftToRight = true;
                    x = -this.enemyHelicopterPlaneSprite.getWidth() / 2 - 1;
                }
                y = rn.nextInt(3 * Util.screenHeight / 4);
                bl = new EnemyHelicopterPlane(this.enemyHelicopterPlaneSprite, x, y, fromLeftToRight);
                this.enemyPlaneVector.addElement(bl);
            }
        }
        if (end - this.st3 > 15000L) {
            this.st3 = end;
            EnemyTiedPlane pl = null;
            int i = 0;
            while (i < 2) {
                pl = i < 1 ? new EnemyTiedPlane(this.enemyTiedPlaneSprite, (1 + i) * this.enemyTiedPlaneSprite.getWidth() + 10, i, false) : new EnemyTiedPlane(this.enemyTiedPlaneSprite, Util.screenWidth / 2 + (i - 3 + 1) * this.enemyTiedPlaneSprite.getWidth() + 10, 1 + 5 * i, false);
                this.enemyPlaneVector.addElement(pl);
                ++i;
            }
        }
    }
}

