/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.game.Sprite;

public class EnemyCirclePlaneSprite
extends BasicPlane {
    private boolean canSendBullet = true;
    private int sendBulletFrame = 0;
    private int startX = 0;
    private long startTime = 0L;

    public EnemyCirclePlaneSprite(Sprite sprite, int x, int y) {
        try {
            this.sprite = sprite;
            this.x = x;
            this.y = y;
            this.w = sprite.getWidth();
            this.h = sprite.getHeight();
            this.life = 10;
            this.attach = 1;
            this.dx = 3;
            this.dy = 4;
            this.currentFrame = 0;
            this.endFrame = sprite.getRawFrameCount() - 1;
            this.startTime = System.currentTimeMillis();
            this.startX = x;
            this.canSendBullet = true;
            Random rn = new Random();
            this.sendBulletFrame = rn.nextInt(this.endFrame + 1) - 1;
            rn = null;
            this.bulletType = 4;
        }
        catch (Exception e) {
            Util.debug("EnemyCirclePlaneSprite---------------init die!");
        }
    }

    public void move() {
        if (!this.canMove(20L)) {
            return;
        }
        int tempWidth = Util.screenWidth - this.startX;
        if (this.getX() < Util.screenWidth / 2) {
            this.moveTo(this.getDX(), this.getDY());
        } else {
            this.moveTo(this.getDX(), -this.getDY());
        }
        int jg = tempWidth / (this.endFrame + 1);
        if (this.getX() < this.startX + jg) {
            this.currentFrame = 7;
        } else if (this.getX() >= this.startX + jg && this.getX() < this.startX + 2 * jg) {
            this.currentFrame = 6;
        } else if (this.getX() >= this.startX + 2 * jg && this.getX() < this.startX + 3 * jg) {
            this.currentFrame = 5;
        } else if (this.getX() >= this.startX + 3 * jg && this.getX() < this.startX + 4 * jg) {
            this.currentFrame = 4;
        } else if (this.getX() >= this.startX + 4 * jg && this.getX() < this.startX + 5 * jg) {
            this.currentFrame = 3;
        } else if (this.getX() >= this.startX + 5 * jg && this.getX() < this.startX + 6 * jg) {
            this.currentFrame = 2;
        } else if (this.getX() >= this.startX + 6 * jg && this.getX() < this.startX + 7 * jg) {
            this.currentFrame = 1;
        } else if (this.getX() >= this.startX + 7 * jg) {
            this.currentFrame = 0;
        }
    }

    public boolean canDestroySelf() {
        long endTime = System.currentTimeMillis();
        return endTime - this.startTime > 8000L && this.getY() <= 0;
    }

    public boolean canSendBullet() {
        if (!this.canSendBullet) {
            return false;
        }
        if (this.sendBulletFrame == this.getCurrentFrame()) {
            this.canSendBullet = false;
            return true;
        }
        return false;
    }
}

