/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class Dictionary
extends MIDlet
implements CommandListener {
    TextBox mainMenu;
    static Command QUIT_CMD = new Command("\u0412\u044b\u0445\u043e\u0434", 2, 2);
    static Command BACK_CMD = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 2);
    static Command TRANSLATE_CMD = new Command("\u041f\u0435\u0440\u0435\u0432\u043e\u0434", 4, 1);
    static final int MAX_LENGTH = 32;
    static final int MAX_FILE_SIZE = 16384;
    static final int SELECTION_LIMIT = 32;
    Volume[] volumes;
    int nVolumes;
    byte[] buf = new byte[16384];
    int prevVolumeSize;
    int prevVolumeIndex;

    public Dictionary() {
        this.mainMenu = new TextBox("\u041f\u0440\u0435\u0444\u0438\u043a\u0441 \u0441\u043b\u043e\u0432\u0430", "", 32, 0);
        this.mainMenu.addCommand(QUIT_CMD);
        this.mainMenu.addCommand(TRANSLATE_CMD);
        this.buildIndex();
    }

    protected void destroyApp(boolean bl) {
        this.mainMenu = null;
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainMenu);
        this.mainMenu.setCommandListener((CommandListener)this);
    }

    private void buildIndex() {
        int n;
        int n2;
        Object object;
        try {
            object = ((Object)((Object)this)).getClass().getResourceAsStream("/dictionary.idx");
            n2 = ((InputStream)object).read(this.buf);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            throw new Error("Failed to read index");
        }
        object = new Vector();
        for (n = 0; n < n2; ++n) {
            Volume volume = new Volume();
            int n3 = n;
            while (this.buf[n3] != 32) {
                ++n3;
            }
            volume.first = new String(this.buf, n, n3 - n);
            n = ++n3;
            while (this.buf[n] != 10) {
                ++n;
            }
            volume.last = new String(this.buf, n3, n - n3);
            ((Vector)object).addElement(volume);
        }
        this.nVolumes = ((Vector)object).size();
        this.volumes = new Volume[this.nVolumes];
        this.prevVolumeIndex = -1;
        for (n = 0; n < this.nVolumes; ++n) {
            this.volumes[n] = (Volume)((Vector)object).elementAt(n);
        }
    }

    public Vector getSelection(String string) {
        if (this.nVolumes == 0) {
            this.buildIndex();
        }
        Vector<Translation> vector = new Vector<Translation>();
        int n = this.nVolumes;
        Volume[] volumeArray = this.volumes;
        boolean bl = false;
        try {
            int n2;
            for (n2 = 0; n2 < n && volumeArray[n2].last.compareTo(string) < 0; ++n2) {
            }
            while (n2 < n) {
                int n3;
                Object object;
                if (this.prevVolumeIndex != n2) {
                    object = ((Object)((Object)this)).getClass().getResourceAsStream("dictionary." + (n2 + 1));
                    n3 = ((InputStream)object).read(this.buf);
                    this.prevVolumeIndex = n2;
                    this.prevVolumeSize = n3;
                    ((InputStream)object).close();
                } else {
                    n3 = this.prevVolumeSize;
                }
                object = volumeArray[n2].first;
                for (int i = 0; i < n3; ++i) {
                    int n4 = i;
                    while (this.buf[i] != 32) {
                        ++i;
                    }
                    String string2 = this.buf[n4] <= 57 ? ((String)object).substring(0, this.buf[n4] - 48) + new String(this.buf, n4 + 1, i - n4 - 1) : new String(this.buf, n4, i - n4);
                    n4 = ++i;
                    while (this.buf[i] != 10) {
                        ++i;
                    }
                    if (string2.compareTo(string) >= 0) {
                        if (string2.startsWith(string)) {
                            bl = true;
                        } else if (bl) {
                            return vector;
                        }
                        char[] cArray = new char[i - n4];
                        for (int j = n4; j < i; ++j) {
                            int n5 = this.buf[j];
                            cArray[j - n4] = (char)(n5 < 0 ? (n5 == -88 ? 1025 : (n5 == -72 ? 1105 : 0x400 | (n5 & 0x7F) - 48)) : n5);
                        }
                        vector.addElement(new Translation(string2, new String(cArray)));
                        if (vector.size() == 32) {
                            return vector;
                        }
                    }
                    object = string2;
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return vector;
    }

    public void showTranslation(Displayable displayable, Translation translation) {
        Alert alert = new Alert(translation.word, translation.translation, null, AlertType.INFO);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(alert, displayable);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == QUIT_CMD) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else {
            String string = this.mainMenu.getString().toLowerCase();
            if (string.length() != 0) {
                this.mainMenu.setTitle("\u041c\u0438\u043d\u0443\u0442\u043e\u0447\u043a\u0443");
                this.mainMenu.setString("\u0418\u0434\u0451\u0442 \u043f\u043e\u0438\u0441\u043a...");
                Vector vector = this.getSelection(string);
                switch (vector.size()) {
                    case 0: {
                        Alert alert = new Alert(string, "\u041d\u0435\u0442 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u043e\u0432", null, AlertType.ERROR);
                        alert.setTimeout(-2);
                        Display.getDisplay((MIDlet)this).setCurrent(alert, (Displayable)this.mainMenu);
                        break;
                    }
                    case 1: {
                        Translation translation = (Translation)vector.firstElement();
                        if (translation.word.equals(string)) {
                            this.showTranslation((Displayable)this.mainMenu, (Translation)vector.firstElement());
                            break;
                        }
                    }
                    default: {
                        new PrefixList(this, (Displayable)this.mainMenu, vector);
                    }
                }
                this.mainMenu.setTitle("\u041f\u0440\u0435\u0444\u0438\u043a\u0441 \u0441\u043b\u043e\u0432\u0430");
                this.mainMenu.setString(string);
            }
        }
    }

    class Translation {
        String word;
        String translation;

        Translation(String string, String string2) {
            this.word = string;
            this.translation = string2;
        }
    }

    class Volume {
        String first;
        String last;

        Volume() {
        }
    }
}

