/*
 * Decompiled with CFR 0.152.
 */
package com.downjoy.j2me.smspack.views;

import com.downjoy.j2me.smspack.util.RmsUtil;
import com.downjoy.j2me.smspack.util.SMSPackInfoReader;
import com.downjoy.j2me.smspack.util.SMSPackInfoVO;
import com.downjoy.j2me.smspack.util.TextAjust;
import com.downjoy.j2me.smspack.views.PayedCallback;
import java.util.Calendar;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class SMSPayCanvas
extends Canvas
implements Runnable {
    private static final int CHINA_MOBILE_TYPE = 0;
    private static final int CHINA_UNICOM_TYPE = 1;
    private static final int CHINA_TELECOM_TYPE = 2;
    private static int srcWidth = 240;
    private static int srcHeight = 320;
    private int[][] BUTTON_BOX = new int[2][4];
    private static final String[] platformName = new String[]{"Nokia", "Motorokr", "Motorola", "SonyEricsson", "Samsung", "j2me", "SunMicrosystems_wtk", "MX6", "MotoA668"};
    private String currPlatform = null;
    private static final int LEFT_SOFT_CODE = -6;
    private static final int RIGHT_SOFT_CODE = -7;
    private static final int LEFT_SOFT_CODE_MOTO1 = -21;
    private static final int RIGHT_SOFT_CODE_MOTO1 = -22;
    private static final int LEFT_SOFT_CODE_MOTO2 = 21;
    private static final int RIGHT_SOFT_CODE_MOTO2 = 22;
    private static final int LEFT_SOFT_CODE_PHILIPS = -202;
    private static final int RIGHT_SOFT_CODE_PHILIPS = -203;
    private SMSPackInfoVO smsPackInfo;
    private String stringItem = null;
    private MIDlet midlet = null;
    private Displayable gameDisplayable;
    private int topIndex = 0;
    private int bootomIndex = 0;
    private String leftCommand = "\u70b9\u64ad";
    private String rigthCommand = "\u8fd4\u56de";
    private String cpId = null;
    private String gameId = null;
    private String actionId = null;
    private String eqpId = null;
    private int fee = 0;
    private String product = null;
    private String cpMemo = null;
    private String cpTel = null;
    private String title = "\u8ba2\u8d2d";
    private PayedCallback payedCallback = null;

    public SMSPayCanvas(MIDlet midlet, Displayable gameDisplayable, String cpId, String gameId, String actionId, String eqpId, int fee, String product, String cpMemo, String cpTel) {
        this.setFullScreenMode(true);
        try {
            this.midlet = midlet;
            this.gameDisplayable = gameDisplayable;
            this.cpId = cpId;
            this.gameId = gameId;
            if (actionId == null || actionId.length() == 0) {
                actionId = "00";
            }
            if (eqpId == null || eqpId.length() == 0) {
                eqpId = "000";
            }
            this.actionId = actionId;
            this.eqpId = eqpId;
            this.fee = fee;
            this.product = product;
            this.cpMemo = cpMemo;
            this.cpTel = cpTel;
            srcWidth = this.getWidth();
            srcHeight = this.getHeight();
            this.setButtonBox();
            this.init();
            this.loadSpecKey(midlet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setButtonBox() {
        this.BUTTON_BOX[0][0] = 2;
        this.BUTTON_BOX[0][1] = srcHeight - 30;
        this.BUTTON_BOX[0][2] = 36;
        this.BUTTON_BOX[0][3] = srcHeight;
        this.BUTTON_BOX[1][0] = srcWidth - 36;
        this.BUTTON_BOX[1][1] = srcHeight - 30;
        this.BUTTON_BOX[1][2] = srcWidth;
        this.BUTTON_BOX[1][3] = srcHeight;
    }

    private void loadSpecKey(MIDlet midlet) {
        int i = 0;
        String s = null;
        try {
            s = midlet.getAppProperty("Platform");
            if (s == null) {
                s = System.getProperty("microedition.platform");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s != null) {
            String pn = null;
            String pn2 = null;
            i = 0;
            while (i < platformName.length) {
                pn = platformName[i];
                pn2 = pn.toLowerCase();
                if (s.length() >= pn2.length() && s.substring(0, pn2.length()).toLowerCase().equals(pn2)) break;
                ++i;
            }
            if (i == platformName.length) {
                i = 0;
                pn = null;
            }
            this.currPlatform = pn;
        }
    }

    private void init() throws Exception {
        this.leftCommand = "\u70b9\u64ad";
        this.rigthCommand = "\u8fd4\u56de";
        this.loadPayInfo();
    }

    private void loadPayInfo() {
        this.smsPackInfo = RmsUtil.loadFromRecordStore(this.cpId, this.gameId, this.actionId, this.eqpId, this.fee);
        if (this.smsPackInfo != null && this.smsPackInfo.isNeedConfirm()) {
            Calendar today = Calendar.getInstance();
            today.set(11, 0);
            today.set(12, 0);
            today.set(13, 0);
            today.set(14, 0);
            if (today.getTime().getTime() > this.smsPackInfo.getLastSendFreeTime()) {
                this.smsPackInfo = null;
            }
        }
        try {
            if (this.smsPackInfo == null || this.smsPackInfo != null && this.smsPackInfo.getPayedMoney() >= this.fee) {
                this.smsPackInfo = SMSPackInfoReader.getSMSPackInfo(this.cpId, this.gameId, this.actionId, this.eqpId, this.fee);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.leftCommand = "";
            this.outputInfo(ex.toString());
            return;
        }
        this.showInfo();
    }

    private void showInfo() {
        if (this.smsPackInfo.getSendedCnt() == 0) {
            this.showPayInfo();
        } else {
            this.showPayInfo2(false);
        }
    }

    private void showPayInfo() {
        if (this.smsPackInfo == null) {
            return;
        }
        StringBuffer sb = new StringBuffer("");
        sb.append(this.cpMemo);
        if (this.smsPackInfo.isNeedConfirm()) {
            sb.append("\u8d39\u7528\u4e3a").append(this.fee).append("\u5143");
        } else {
            sb.append("\n\u60a8\u9700\u53d1\u9001");
            if (this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0) {
                sb.append("1\u6761\u514d\u8d39\u77ed\u4fe1\u548c");
            }
            sb.append(this.smsPackInfo.getFeeSMSCnt()).append("\u6761\u6536\u8d39\u77ed\u4fe1(");
            sb.append(this.smsPackInfo.getFeeSMSUnitPrice()).append("\u5143/\u6761)\uff0c\u5408\u8ba1").append(this.fee).append("\u5143");
        }
        sb.append("\uff0c\u4e0d\u542b\u901a\u4fe1\u8d39\u3002");
        sb.append("\u5ba2\u670d\u7535\u8bdd\uff1a").append(this.cpTel).append("\n  ");
        sb.append(this.smsPackInfo.getFeeSMSTitle());
        this.outputInfo(sb.toString());
    }

    private void showPayInfo2(boolean wait) {
        if (this.smsPackInfo.isNeedConfirm()) {
            String num;
            if (wait) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if ((num = this.smsPackInfo.getFeeSMSNum()).startsWith("10658008")) {
                num = "10658008";
            }
            this.outputInfo("\u5c0a\u656c\u7684\u7528\u6237\uff0c\u518d\u6b21\u70b9\u64ad\u5373\u540c\u610f\u5411" + num + "\u53d1\u9001\u77ed\u4fe1\u4ee5\u786e\u8ba4\u8d2d\u4e70" + this.product + ",\u8d39\u7528\u4e3a\uff1a" + this.fee + "\u5143\uff0c\u4e0d\u542b\u901a\u4fe1\u8d39\uff0c\u8bf7\u5728\u9875\u9762\u5b8c\u6210\u8d2d\u4e70\uff0c\u8fd4\u56de\u5219\u4e0d\u6263\u8d39\u3002\u5ba2\u670d\u7535\u8bdd:" + this.cpTel);
        } else {
            int total = this.smsPackInfo.getFeeSMSCnt();
            if (this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0) {
                ++total;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u5df2\u7ecf\u53d1\u9001\u4e86" + this.smsPackInfo.getSendedCnt() + "\u6761\u77ed\u4fe1\uff0c\u8fd8\u9700\u53d1\u9001" + (total - this.smsPackInfo.getSendedCnt()) + "\u6761\u77ed\u4fe1");
            if (this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0) {
                sb.append(",\u7b2c\u4e00\u6761\u514d\u8d39\u77ed\u4fe1\u662f\u7528\u4e8e\u63a5\u6536\u514d\u8d39\u6e38\u620f\u4fe1\u606f\u7684");
            }
            sb.append("\u3002\n").append(this.smsPackInfo.getFeeSMSTitle());
            this.outputInfo(sb.toString());
        }
    }

    private void payWithSMS() {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        if (this.smsPackInfo.getFreeSMSNum() != null && this.smsPackInfo.getFreeSMSContent().length() != 0 && this.smsPackInfo.getFreeSMSContent() != null && this.smsPackInfo.getFreeSMSContent().length() != 0 && this.smsPackInfo.getLastSendFreeTime() == 0L) {
            this.outputInfo("\u6b63\u5728\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\uff0c\u8bf7\u7a0d\u5019... ...");
            if (this.sendSMS(this.smsPackInfo.getFreeSMSNum(), this.smsPackInfo.getFreeSMSContent())) {
                this.smsPackInfo.setLastSendFreeTime(System.currentTimeMillis());
                this.smsPackInfo.setSendedCnt(this.smsPackInfo.getSendedCnt() + 1);
                RmsUtil.savePayResult(this.smsPackInfo, this.cpId, this.gameId, this.actionId, this.eqpId, this.fee);
                this.showPayInfo2(true);
                this.leftCommand = "\u70b9\u64ad";
                this.rigthCommand = "\u8fd4\u56de";
            } else {
                this.leftCommand = "\u786e\u5b9a";
                this.rigthCommand = "\u8fd4\u56de";
                this.outputInfo("\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\u5931\u8d25\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u91cd\u65b0\u518d\u8bd5\uff0c\u70b9\u51fb\u201c\u8fd4\u56de\u201d\uff0c\u56de\u5230\u6e38\u620f\u3002");
            }
            this.repaint();
            return;
        }
        if (this.smsPackInfo.getPayedMoney() < this.fee) {
            this.outputInfo("\u6b63\u5728\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\uff0c\u8bf7\u7a0d\u5019... ...");
            if (this.sendSMS(this.smsPackInfo.getFeeSMSNum(), this.smsPackInfo.getFeeSMSContent())) {
                this.smsPackInfo.setPayedMoney(this.smsPackInfo.getPayedMoney() + this.smsPackInfo.getFeeSMSUnitPrice());
                this.smsPackInfo.setSendedCnt(this.smsPackInfo.getSendedCnt() + 1);
                RmsUtil.savePayResult(this.smsPackInfo, this.cpId, this.gameId, this.actionId, this.eqpId, this.fee);
                this.rigthCommand = "\u8fd4\u56de";
                if (this.smsPackInfo.getPayedMoney() == this.fee) {
                    this.leftCommand = "";
                    this.outputInfo("\u611f\u8c22\u60a8\u8d2d\u4e70" + this.product + "\uff0c\u8d39\u7528\u4e3a" + this.fee + "\u5143,\u5ba2\u670d\u7535\u8bdd:" + this.cpTel);
                } else {
                    this.leftCommand = "\u70b9\u64ad";
                    this.showPayInfo2(false);
                }
            } else {
                this.leftCommand = "\u786e\u5b9a";
                this.rigthCommand = "\u8fd4\u56de";
                this.outputInfo("\u53d1\u9001\u7b2c" + (this.smsPackInfo.getSendedCnt() + 1) + "\u6761\u77ed\u4fe1\u5931\u8d25\uff0c\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u91cd\u65b0\u518d\u8bd5\uff0c\u70b9\u51fb\u201c\u8fd4\u56de\u201d\uff0c\u56de\u5230\u6e38\u620f\u3002");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean sendSMS(String dest, String content) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getPhoneNetworkType() {
        String smsc = System.getProperty("wireless.messaging.sms.smsc");
        if (smsc != null) {
            if (smsc.startsWith("138") || smsc.startsWith("+138") || smsc.startsWith("+86138")) {
                return 0;
            }
            if (smsc.startsWith("+86130") || smsc.startsWith("0086130") || smsc.startsWith("130") || smsc.startsWith("+130")) {
                return 1;
            }
        }
        return 2;
    }

    private void outputInfo(String s) {
        this.topIndex = 0;
        this.stringItem = s;
        this.repaint();
    }

    private void callback() {
        if (this.payedCallback != null) {
            this.payedCallback.callback(this.smsPackInfo.getPayedMoney() >= this.fee);
        }
    }

    private int convertKey(int keyCode) {
        if (this.currPlatform == null) {
            return keyCode;
        }
        if (this.currPlatform.equals("Motorola")) {
            switch (keyCode) {
                case -21: 
                case 21: {
                    return -6;
                }
                case -22: 
                case 22: {
                    return -7;
                }
                case -6: {
                    return 56;
                }
            }
        }
        return keyCode;
    }

    protected void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        keyCode = this.convertKey(keyCode);
        int key = this.getGameAction(keyCode);
        switch (key) {
            case 1: {
                this.doCommandUp();
                return;
            }
            case 6: {
                this.doCommandDown();
                return;
            }
        }
        switch (keyCode) {
            case -202: 
            case -21: 
            case -6: 
            case 21: {
                this.doCommandLeft();
                break;
            }
            case -203: 
            case -22: 
            case -7: 
            case 22: {
                this.doCommandRight();
                break;
            }
            case 50: {
                this.doCommandUp();
                break;
            }
            case 56: {
                this.doCommandDown();
                break;
            }
            default: {
                System.out.println(keyCode);
            }
        }
    }

    private boolean touch_button(int x, int y, int button) {
        return x > this.BUTTON_BOX[button][0] && x < this.BUTTON_BOX[button][2] && y > this.BUTTON_BOX[button][1] && y < this.BUTTON_BOX[button][3];
    }

    protected void pointerPressed(int x, int y) {
        if (this.touch_button(x, y, 0)) {
            this.doCommandLeft();
        } else if (this.touch_button(x, y, 1)) {
            this.doCommandRight();
        }
    }

    protected void keyRepeated(int keyCode) {
        super.keyRepeated(keyCode);
        this.keyPressed(keyCode);
    }

    public void doCommandUp() {
        --this.topIndex;
        if (this.topIndex <= 0) {
            this.topIndex = 0;
        }
        this.repaint();
    }

    public void doCommandDown() {
        if (this.bootomIndex > 0) {
            ++this.topIndex;
        }
        this.repaint();
    }

    public void doCommandLeft() {
        if ("\u70b9\u64ad".equals(this.leftCommand) && this.smsPackInfo.getFeeSMSCnt() > 0) {
            this.leftCommand = "";
            this.rigthCommand = "";
            this.payWithSMS();
        } else if ("\u786e\u5b9a".equals(this.leftCommand)) {
            this.leftCommand = "\u70b9\u64ad";
            this.rigthCommand = "\u8fd4\u56de";
            this.showInfo();
        }
    }

    public void doCommandRight() {
        if ("\u8fd4\u56de".equals(this.rigthCommand)) {
            if (this.smsPackInfo.getPayedMoney() < this.fee) {
                this.leftCommand = "\u786e\u5b9a";
                this.rigthCommand = "\u9000\u51fa";
                this.outputInfo("\u60a8\u8fd8\u672a\u5b8c\u6210\u4ed8\u8d39\uff0c\u5efa\u8bae\u60a8\u7ee7\u7eed\u4ed8\u8d39\u3002");
            } else {
                this.callback();
                Display.getDisplay((MIDlet)this.midlet).setCurrent(this.gameDisplayable);
            }
        } else if ("\u9000\u51fa".equals(this.rigthCommand)) {
            this.callback();
            Display.getDisplay((MIDlet)this.midlet).setCurrent(this.gameDisplayable);
        }
    }

    public void paint(Graphics g) {
        Font font = Font.getDefaultFont();
        font = Font.getFont((int)0, (int)1, (int)0);
        g.setColor(4423868);
        g.fillRect(0, 0, srcWidth, srcHeight);
        int titleHeight = 30;
        g.setColor(255, 102, 0);
        g.fillRect(0, 0, srcWidth, titleHeight);
        g.setColor(0xFFFFFF);
        int x = 2;
        int y = (titleHeight - font.getHeight()) / 2;
        g.drawString(this.title, x, y, 0);
        g.setFont(font);
        int toolBarHeight = font.getHeight() + 8;
        x = 5;
        y = titleHeight + 5;
        int[] res = TextAjust.ajustDrawString(g, this.stringItem, font, srcWidth - 10, srcHeight - toolBarHeight - 10, this.topIndex, x, y, 5);
        this.bootomIndex = res[1];
        g.setColor(255, 102, 0);
        x = 0;
        y = srcHeight - toolBarHeight;
        g.fillRect(x, y, srcWidth, toolBarHeight);
        g.setColor(0xFFFFFF);
        x = 2;
        y = srcHeight - (toolBarHeight + font.getHeight()) / 2;
        g.drawString(this.leftCommand, x, y, 0);
        String str = "";
        if (this.topIndex > 0 && this.bootomIndex > 0) {
            str = "\u2195";
        } else if (this.topIndex > 0) {
            str = "\u2191";
        } else if (this.bootomIndex > 0) {
            str = "\u2193";
        }
        g.drawString(str, srcWidth / 2, y, 0);
        x = srcWidth - TextAjust.getStringWidth(this.rigthCommand, font) - x - 2;
        g.drawString(this.rigthCommand, x, y, 0);
    }

    public PayedCallback getPayedCallback() {
        return this.payedCallback;
    }

    public void setPayedCallback(PayedCallback payedCallback) {
        this.payedCallback = payedCallback;
    }
}

