/*
 * Decompiled with CFR 0.152.
 */
package com.game.film;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FilmScriptParse {
    private int scriptIndex = 0;
    private InputStream is;
    private ByteArrayOutputStream bos;
    private String key;
    private String[] value;
    public String[] readstr;

    public void loadFile(String file) {
        this.is = this.getClass().getResourceAsStream(file);
        this.bos = new ByteArrayOutputStream();
    }

    public boolean hasNext() {
        return this.scriptIndex <= this.readstr.length - 1;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getValue() {
        return this.value;
    }

    public void readNextLine() {
        this.analyzeStr(this.scriptIndex);
        ++this.scriptIndex;
    }

    private void analyzeStr(int index) {
        String[] str = this.splitStr(this.readstr[index], ":");
        this.key = str[0];
        this.value = this.splitStr(str[1], ",");
    }

    public void readFile() throws IOException {
        byte[] tempData = new byte[1024];
        while (this.is.read(tempData) != -1) {
            this.bos.write(tempData);
        }
        byte[] byteScript = this.bos.toByteArray();
        String str = new String(byteScript, "UTF-8");
        this.readstr = this.splitStr(str.trim(), "\r\n");
        this.bos.close();
    }

    public void close() {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.bos != null) {
                this.bos.flush();
                this.bos.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public final String[] splitStr(String source, String splitStr) {
        if (source == null || splitStr == null) {
            return null;
        }
        int startIndex = 0;
        String[] returnStrArr = null;
        while (startIndex < source.length()) {
            String[] tmp;
            int splitIndex = source.indexOf(splitStr, startIndex);
            if (splitIndex != -1) {
                if (!source.substring(startIndex, splitIndex).equals("")) {
                    if (returnStrArr == null) {
                        returnStrArr = new String[1];
                    } else {
                        tmp = new String[returnStrArr.length + 1];
                        System.arraycopy(returnStrArr, 0, tmp, 0, returnStrArr.length);
                        returnStrArr = tmp;
                    }
                    returnStrArr[returnStrArr.length - 1] = source.substring(startIndex, splitIndex);
                }
                startIndex = splitIndex + splitStr.length();
                continue;
            }
            if (source.substring(startIndex).equals("")) break;
            if (returnStrArr == null) {
                returnStrArr = new String[1];
            } else {
                tmp = new String[returnStrArr.length + 1];
                System.arraycopy(returnStrArr, 0, tmp, 0, returnStrArr.length);
                returnStrArr = tmp;
            }
            returnStrArr[returnStrArr.length - 1] = source.substring(startIndex);
            break;
        }
        return returnStrArr;
    }
}

