/*
 * Decompiled with CFR 0.152.
 */
package com.game.mission;

import com.game.attribute.Attribute;
import com.game.monster.BearMonster;
import com.game.monster.DogMonster;
import com.game.monster.FireBossMoster;
import com.game.monster.FrogMonster;
import com.game.monster.HowletMonster;
import com.game.monster.LionMonster;
import com.game.monster.MonkeyMonster;
import com.game.monster.Monster;
import com.game.monster.OrangMonster;
import com.game.monster.OstrichMonster;
import com.game.monster.PigMonster;
import com.game.monster.SheepMonster;
import com.game.monster.SnakeMonster;
import com.game.monster.SpookMonster;
import com.game.monster.SquirreMonster;
import com.game.monster.WitchKingMonster;
import com.game.rms.GameRms;
import com.game.script.ScriptParse;
import com.game.util.ArrayList;
import com.game.util.Tools;
import com.game.xrole.Role;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class Mission {
    private ScriptParse scriptParse = new ScriptParse();
    private Role player = null;
    private String[] missionFile = null;
    private Image imgMonster1 = null;
    private byte[] byteLion1 = null;
    private byte[] byteLion2 = null;
    private Image imgMonster2 = null;
    private Image bossImage = null;
    private Image imgShiZi = null;
    private byte[] byteShiZi = null;
    private byte[] bossByte = null;
    public static boolean isBoss = false;
    private String[][] monsterInfo = new String[0][];
    private byte[] byte1 = null;
    private Image img1 = null;
    private byte[] byte2 = null;
    private Image img2 = null;
    private byte[] byte3 = null;
    private Image img3 = null;
    private byte[] byte4 = null;
    private Image img4 = null;
    private byte[] byte5 = null;
    private Image img5 = null;
    private byte[] byte6 = null;
    private Image img6 = null;
    private byte[] byte7 = null;
    private Image img7 = null;
    private byte[] byte8 = null;
    private Image img8 = null;
    private byte[] byte9 = null;
    private Image img9 = null;
    private byte[] byte10 = null;
    private Image img10 = null;
    private byte[] byte11 = null;
    private Image img11 = null;
    private byte[] byte12 = null;
    private Image img12 = null;
    private Image img14 = null;
    private byte[] byte14 = null;
    private Image img15 = null;
    private byte[] byte15 = null;

    public Mission(Role player) throws IOException {
        this.player = player;
        switch (GameRms.rmsCurModel) {
            case 0: {
                this.monsterInfo = this.readMonsterInfo("/res/monster/monsterInfo1.txt");
                break;
            }
            case 1: {
                this.monsterInfo = this.readMonsterInfo("/res/monster/monsterInfo2.txt");
                break;
            }
            case 2: {
                this.monsterInfo = this.readMonsterInfo("/res/monster/monsterInfo3.txt");
            }
        }
    }

    public int getAllCount() {
        return Integer.parseInt(this.missionFile[0].substring(9, this.missionFile[0].length()));
    }

    public ScriptParse getScriptParse() {
        return this.scriptParse;
    }

    public void setScriptParse(ScriptParse scriptParse) {
        this.scriptParse = scriptParse;
    }

    public String[] readMissionFile(String file) {
        this.scriptParse.loadScriptFile(file);
        try {
            String string = this.scriptParse.readFile();
            this.missionFile = this.scriptParse.splitStr(string, "\r\n");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this.missionFile;
    }

    public ArrayList getMonsterArray(int count) {
        String[] str1 = this.scriptParse.splitStr(this.missionFile[count], ":");
        if (str1[0].equals("boss")) {
            isBoss = true;
        }
        String[] str2 = this.scriptParse.splitStr(str1[1], "|");
        ArrayList list = new ArrayList();
        for (int i = 0; i < str2.length; ++i) {
            String[] countWave = this.scriptParse.splitStr(str2[i], ",");
            int id = Integer.parseInt(countWave[0]);
            int proProbility = Integer.parseInt(countWave[2]);
            int countMonster = Integer.parseInt(countWave[1]);
            Monster littlemoster = null;
            for (int j = 0; j < countMonster; ++j) {
                littlemoster = this.getMonsterForId(id);
                littlemoster.setProbability(proProbility);
                list.add(littlemoster);
            }
        }
        return list;
    }

    private Monster getMonsterForId(int id) {
        Monster littlemoster = null;
        switch (id) {
            case 1: {
                if (this.img1 != null) break;
                this.img1 = Tools.loadImage("/res/monster/monster1.png");
                this.byte1 = Tools.loadFile("/res/monster/monster1.sprite");
                break;
            }
            case 2: {
                if (this.img2 != null) break;
                this.img2 = Tools.loadImage("/res/monster/monster2.png");
                this.byte2 = Tools.loadFile("/res/monster/monster2.sprite");
                break;
            }
            case 3: {
                if (this.img3 != null) break;
                this.img3 = Tools.loadImage("/res/monster/monster3.png");
                this.byte3 = Tools.loadFile("/res/monster/monster3.sprite");
                break;
            }
            case 4: {
                if (this.img4 != null) break;
                this.img4 = Tools.loadImage("/res/monster/monster4.png");
                this.byte4 = Tools.loadFile("/res/monster/monster4.sprite");
                break;
            }
            case 5: {
                if (this.img5 != null) break;
                this.img5 = Tools.loadImage("/res/monster/monster5.png");
                this.byte5 = Tools.loadFile("/res/monster/monster5.sprite");
                break;
            }
            case 6: {
                if (this.img6 != null) break;
                this.img6 = Tools.loadImage("/res/monster/monster6.png");
                this.byte6 = Tools.loadFile("/res/monster/monster6.sprite");
                break;
            }
            case 7: {
                if (this.img7 != null) break;
                this.img7 = Tools.loadImage("/res/monster/monster7.png");
                this.byte7 = Tools.loadFile("/res/monster/monster7.sprite");
                break;
            }
            case 8: {
                if (this.img8 != null) break;
                this.img8 = Tools.loadImage("/res/monster/monster8.png");
                this.byte8 = Tools.loadFile("/res/monster/monster8.sprite");
                break;
            }
            case 9: {
                if (this.img9 != null) break;
                this.img9 = Tools.loadImage("/res/monster/monster9.png");
                this.byte9 = Tools.loadFile("/res/monster/monster9.sprite");
                break;
            }
            case 10: {
                if (this.img10 != null) break;
                this.img10 = Tools.loadImage("/res/monster/monster10.png");
                this.byte10 = Tools.loadFile("/res/monster/monster10.sprite");
                break;
            }
            case 11: {
                if (this.img11 != null) break;
                this.img11 = Tools.loadImage("/res/monster/monster11.png");
                this.byte11 = Tools.loadFile("/res/monster/monster11.sprite");
                break;
            }
            case 12: {
                if (this.img12 != null) break;
                this.img12 = Tools.loadImage("/res/monster/monster12.png");
                this.byte12 = Tools.loadFile("/res/monster/monster12.sprite");
                break;
            }
            case 13: {
                if (this.img14 == null) {
                    this.img14 = Tools.loadImage("/res/monster/monster14.png");
                    this.byte14 = Tools.loadFile("/res/monster/monster14.sprite");
                }
            }
            case 14: {
                if (this.img15 != null) break;
                this.img15 = Tools.loadImage("/res/monster/monster15.png");
                this.byte15 = Tools.loadFile("/res/monster/monster15.sprite");
                break;
            }
            case 15: {
                if (this.imgShiZi != null) break;
                this.imgShiZi = Tools.loadImage("/res/monster/lion.png");
                this.byteShiZi = Tools.loadFile("/res/monster/lion.sprite");
            }
        }
        switch (id) {
            case 1: {
                littlemoster = new MonkeyMonster(this.byte1, this.img1, id);
                break;
            }
            case 2: {
                littlemoster = new HowletMonster(this.byte2, this.img2, id);
                break;
            }
            case 3: {
                littlemoster = new DogMonster(this.byte3, this.img3, id);
                break;
            }
            case 4: {
                littlemoster = new BearMonster(this.byte4, this.img4, id);
                break;
            }
            case 5: {
                littlemoster = new OrangMonster(this.byte5, this.img5, id);
                break;
            }
            case 6: {
                littlemoster = new SnakeMonster(this.byte6, this.img6, id);
                break;
            }
            case 7: {
                littlemoster = new PigMonster(this.byte7, this.img7, id);
                break;
            }
            case 8: {
                littlemoster = new FrogMonster(this.byte8, this.img8, id);
                break;
            }
            case 9: {
                littlemoster = new OstrichMonster(this.byte9, this.img9, id);
                break;
            }
            case 10: {
                littlemoster = new SpookMonster(this.byte10, this.img10, id);
                break;
            }
            case 11: {
                littlemoster = new SquirreMonster(this.byte11, this.img11, id);
                break;
            }
            case 12: {
                littlemoster = new SheepMonster(this.byte12, this.img12, id);
                break;
            }
            case 13: {
                littlemoster = new FireBossMoster(this.byte14, this.img14, id);
                break;
            }
            case 14: {
                littlemoster = new WitchKingMonster(this.byte15, this.img15, id);
                break;
            }
            case 15: {
                littlemoster = new LionMonster(this.byteShiZi, this.imgShiZi, id);
            }
        }
        littlemoster.player = this.player;
        Attribute arr = new Attribute();
        arr.setCurHp(Integer.parseInt(this.monsterInfo[id - 1][1]));
        arr.setSpeed(Integer.parseInt(this.monsterInfo[id - 1][4]));
        arr.setDefenceVal(Integer.parseInt(this.monsterInfo[id - 1][3]));
        littlemoster.setName(this.monsterInfo[id - 1][0]);
        littlemoster.setWorthMoney(Integer.parseInt(this.monsterInfo[id - 1][2]));
        littlemoster.setFenShu(Integer.parseInt(this.monsterInfo[id - 1][5]));
        littlemoster.setAttribute(arr);
        return littlemoster;
    }

    public String[][] readMonsterInfo(String file) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String str = null;
        byte[] bData = new byte[1024];
        while (in.read(bData) != -1) {
            out.write(bData);
        }
        byte[] monster = out.toByteArray();
        str = new String(monster, "UTF-8");
        String[] info = this.scriptParse.splitStr(str.trim(), "\r\n");
        String[][] infoTemp = new String[info.length][6];
        String[] temp = null;
        for (int i = 0; i < info.length; ++i) {
            temp = this.scriptParse.splitStr(info[i].trim(), ",");
            System.out.println("\u4fe1\u606f\uff1a" + info[i]);
            for (int j = 0; j < temp.length; ++j) {
                infoTemp[i][j] = temp[j];
            }
        }
        return infoTemp;
    }
}

