/*
 * Decompiled with CFR 0.152.
 */
package com.game.shop;

import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import com.game.util.OString;
import com.game.util.Tools;
import javax.microedition.lcdui.Image;

public class Frame {
    private static SpriteX talkFrame;
    private static Image imgButtonEnter;
    private static Image imgButtonBack;

    public static final void drawTalkFrame(Graphics2D g, String string, int x, int y, int width, int color) {
        int maxWordsInLines = width / Tools.FONT_WIDTH;
        int temp = string.length() / maxWordsInLines;
        if (string.length() % maxWordsInLines != 0) {
            ++temp;
        }
        int frameTopHeight = talkFrame.getHeight(0, 4);
        int height = temp * Tools.DEFAUL_FONT_HEIGHT + 2 * frameTopHeight + 20;
        Frame.drawFrame(g, x - Tools.FONT_WIDTH / 2, y, width + Tools.FONT_WIDTH, height);
        g.setColor(color);
        g.drawString(new OString(string, color), x + 10, y + frameTopHeight + 10, width);
    }

    public static final void drawFrame(Graphics2D g, int x, int y, int width, int height) {
        int i;
        int frameTopWidth = talkFrame.getWidth(0, 4);
        int ltAngleWidth = talkFrame.getWidth(0, 0);
        int ltAngleHeight = talkFrame.getHeight(0, 0);
        int frameHeight = talkFrame.getHeight(0, 6);
        int frameTopHeight = talkFrame.getHeight(0, 4);
        int frameLeftWidth = talkFrame.getWidth(0, 6);
        g.setColor(0xFBFFB6);
        g.fillRect(x, y, width, height);
        g.setClip(0, 0, 240, 320);
        int countWidth = (width - 2 * ltAngleWidth) / frameTopWidth;
        for (int i2 = 0; i2 <= countWidth; ++i2) {
            int tempX = x + ltAngleWidth + i2 * frameTopWidth;
            talkFrame.setFrame(4);
            if (tempX + talkFrame.getWidth() > x + width - ltAngleWidth) {
                tempX = x + width - ltAngleWidth - talkFrame.getWidth();
            }
            talkFrame.setPosition(tempX, y);
            talkFrame.paint(g);
            talkFrame.setFrame(5);
            talkFrame.setPosition(tempX, y + height);
            talkFrame.paint(g);
        }
        int countHeight = (height - 2 * ltAngleHeight) / frameHeight;
        for (i = 0; i <= countHeight; ++i) {
            int tempY = y + ltAngleHeight + i * frameHeight;
            talkFrame.setFrame(6);
            if (tempY + talkFrame.getHeight() > y + height - ltAngleHeight) {
                tempY = y + height - ltAngleHeight - talkFrame.getHeight();
            }
            talkFrame.setPosition(x, tempY);
            talkFrame.paint(g);
            talkFrame.setFrame(7);
            talkFrame.setPosition(x + width, tempY);
            talkFrame.paint(g);
        }
        for (i = 0; i < 4; ++i) {
            talkFrame.setFrame(i);
            talkFrame.setPosition(x + i % 2 * width, y + i / 2 * height);
            talkFrame.paint(g);
        }
    }

    public static void drawButton(Graphics2D g, boolean enterBool, boolean backBool) {
        if (enterBool) {
            g.drawImage(imgButtonEnter, 1, 318 - imgButtonEnter.getHeight(), 0);
        }
        if (backBool) {
            g.drawImage(imgButtonBack, 240 - imgButtonBack.getWidth() - 1, 318 - imgButtonEnter.getHeight(), 0);
        }
    }

    static {
        imgButtonEnter = Tools.loadImage("/res/map/enter.png");
        imgButtonBack = Tools.loadImage("/res/map/back.png");
        talkFrame = new SpriteX("/res/ui/shop/buyKuang.sprite", "/res/ui/shop/buyKuang.png");
    }
}

