/*
 * Decompiled with CFR 0.152.
 */
public class CAnimation {
    public boolean m_actionOver;
    public int m_pageIDNow;
    public short m_durNow;
    public int m_frameIndex;
    public int m_currActionID;
    CAnimationData m_aniData = null;
    static boolean _flag = false;

    public CAnimation(CAnimationData aniData) {
        this.m_aniData = aniData;
    }

    public CAnimation clone() {
        CAnimation anim = new CAnimation(this.m_aniData);
        return anim;
    }

    public void freeImage() {
        this.m_aniData.freeImage();
    }

    public void loadImage() {
        this.m_aniData.loadImage();
    }

    public void draw(int screenX, int screenY) {
        this.m_aniData.draw(screenX, screenY, this.m_frameIndex);
        if (!this.m_actionOver) {
            short s = this.m_durNow;
            this.m_durNow = (short)(s + 1);
            if (s >= this.m_aniData.m_frames[this.m_currActionID][(this.m_pageIDNow << 1) + 1]) {
                ++this.m_pageIDNow;
                if (this.m_pageIDNow > this.m_aniData.m_nFrame[this.m_currActionID] - 1) {
                    this.m_pageIDNow = this.m_aniData.m_nFrame[this.m_currActionID] - 1;
                    this.m_actionOver = true;
                }
                this.m_frameIndex = this.m_aniData.m_frames[this.m_currActionID][this.m_pageIDNow << 1] & 0xFFFF;
                this.m_durNow = 0;
            }
        }
    }

    public void moveFrame() {
        if (!this.m_actionOver) {
            short s = this.m_durNow;
            this.m_durNow = (short)(s + 1);
            if (s >= this.m_aniData.m_frames[this.m_currActionID][(this.m_pageIDNow << 1) + 1]) {
                ++this.m_pageIDNow;
                if (this.m_pageIDNow > this.m_aniData.m_nFrame[this.m_currActionID] - 1) {
                    this.m_pageIDNow = this.m_aniData.m_nFrame[this.m_currActionID] - 1;
                    this.m_actionOver = true;
                }
                this.m_frameIndex = this.m_aniData.m_frames[this.m_currActionID][this.m_pageIDNow << 1] & 0xFFFF;
                this.m_durNow = 0;
            }
        }
    }

    int getFrameIndex() {
        return this.m_aniData.m_frames[this.m_currActionID][this.m_pageIDNow << 1] & 0xFFFF;
    }

    public boolean setFrame(int actionID, boolean mustChange) {
        if (actionID == this.m_currActionID && !this.m_actionOver && !mustChange) {
            return false;
        }
        this.m_actionOver = false;
        this.m_currActionID = actionID;
        this.m_pageIDNow = 0;
        this.m_durNow = 0;
        this.m_frameIndex = this.m_aniData.m_frames[this.m_currActionID][this.m_pageIDNow << 1] & 0xFFFF;
        return true;
    }

    public void getFrameSprite(int[] sprite, int id) {
        this.m_aniData.getFrameSprite(sprite, this.m_frameIndex, id);
    }

    public void getFrameCol(int[] frameCol) {
        frameCol[0] = this.m_aniData.m_colData[(this.m_frameIndex << 2) + 0];
        frameCol[1] = this.m_aniData.m_colData[(this.m_frameIndex << 2) + 1];
        frameCol[2] = this.m_aniData.m_colData[(this.m_frameIndex << 2) + 2];
        frameCol[3] = this.m_aniData.m_colData[(this.m_frameIndex << 2) + 3];
    }

    public boolean IsActionOver(int startId, int endId) {
        _flag = this.m_currActionID >= startId && this.m_currActionID <= endId;
        return _flag && this.m_actionOver || !_flag;
    }

    public boolean IsLastActionOver(int startId, int endId) {
        return this.m_currActionID >= startId && this.m_currActionID <= endId && this.m_actionOver;
    }

    public boolean IsActionId(int startId, int endId) {
        return this.m_currActionID >= startId && this.m_currActionID <= endId;
    }
}

