/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;

public class LZCompress {
    static final byte[] PACK_HEAD = new byte[]{76, 74, 89, 33};
    int f = 0;
    int _v = 0;
    byte[] b = null;
    static final int N = 4096;
    static byte[] text_buf = new byte[4096];

    public LZCompress(String file) {
        this.b = this.getLZInputStream(file);
    }

    void close() {
        this.b = null;
    }

    void reset() {
        this.f = 0;
    }

    void skip(int k) {
        this.f += k;
    }

    void read(byte[] _b, int off, int len) {
        System.arraycopy(this.b, this.f, _b, off, len);
        this.f += len;
    }

    int readInt() {
        this._v = (this.b[this.f] & 0xFF) << 24 | (this.b[this.f + 1] & 0xFF) << 16 | (this.b[this.f + 2] & 0xFF) << 8 | this.b[this.f + 3] & 0xFF;
        this.f += 4;
        return this._v;
    }

    int readShort() {
        this._v = (this.b[this.f + 0] & 0xFF) << 8 | this.b[this.f + 1] & 0xFF;
        this.f += 2;
        return (short)this._v;
    }

    int readUnsignedShort() {
        this._v = (this.b[this.f + 0] & 0xFF) << 8 | this.b[this.f + 1] & 0xFF;
        this.f += 2;
        return this._v;
    }

    byte readByte() {
        this._v = this.b[this.f++] & 0xFF;
        return (byte)this._v;
    }

    String readUTF() {
        String s = null;
        try {
            this._v = (this.b[this.f + 0] & 0xFF) << 8 | this.b[this.f + 1] & 0xFF;
            this.f += 2;
            s = new String(this.b, this.f, this._v, "UTF-8");
            this.f += this._v;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public byte[] getLZInputStream(String file) {
        byte[] data = null;
        int size = 0;
        ByteArrayInputStream input = null;
        ByteArrayOutputStream output = null;
        try {
            DataInputStream in = new DataInputStream(file.getClass().getResourceAsStream(file));
            if (in != null) {
                size = in.readInt();
                data = new byte[size + 4];
                in.read(data, 4, size);
                data[0] = (byte)(size >> 24 & 0xFF);
                data[1] = (byte)(size >> 16 & 0xFF);
                data[2] = (byte)(size >> 8 & 0xFF);
                data[3] = (byte)(size & 0xFF);
                in.close();
                boolean isLZC = true;
                for (int i = 0; i < 4; ++i) {
                    if (data[4 + i] == PACK_HEAD[i]) continue;
                    isLZC = false;
                }
                if (isLZC) {
                    input = new ByteArrayInputStream(data, 8, size - 4);
                    output = new ByteArrayOutputStream();
                    this.uncompress(input, output);
                    data = null;
                    data = output.toByteArray();
                    input.close();
                    output.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Read LZMA file: " + file + "  error~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        return data;
    }

    public final int uncompress(ByteArrayInputStream in, ByteArrayOutputStream out) {
        int F = 18;
        int THRESHOLD = 2;
        int state = 0;
        int flags = 0;
        int c = 0;
        int r = 0;
        int k = 0;
        int j = 0;
        int i = 0;
        int size = 0;
        while (true) {
            if (state == 2 && k <= j) {
                c = text_buf[i + k & 0xFFF];
                r &= 0xFFF;
                LZCompress.text_buf[r++] = (byte)c;
                out.write((byte)c);
                ++k;
                ++size;
                continue;
            }
            if (((flags >>>= 1) & 0x100) == 0) {
                c = in.read();
                if (c == -1) break;
                flags = c | 0xFF00;
            }
            if ((flags & 1) == 1) {
                c = in.read();
                if (c == -1) break;
                r &= 0xFFF;
                LZCompress.text_buf[r++] = (byte)c;
                out.write((byte)c);
                ++size;
                state = 1;
                continue;
            }
            i = in.read();
            if (i == -1 || (j = in.read()) == -1) break;
            i |= (j & 0xF0) << 4;
            j = (j & 0xF) + THRESHOLD;
            k = 0;
            state = 2;
        }
        if (size == 0) {
            return -1;
        }
        return size;
    }
}

