/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public final class GameEngine {
    MyGameCanvas canvas;
    static Random rnd = new Random();
    static GameMap map;
    static GameRole[] roles;
    static int[][] scoreNote;
    public static final byte GAME_READY = 0;
    public static final byte GAME_START = 1;
    public static final byte GAME_PLAY = 2;
    public static final byte GAME_END = 3;
    public static final byte GAME_TALK = 4;
    public static final byte GAME_SKILL = 6;
    public static final byte GAME_DEAD = 7;
    public static final byte GAME_OPEN = 8;
    public static final byte GAME_CLOSE = 9;
    static byte curState;
    static byte nextState;
    static byte lastState;
    static int time;
    static int cpuAI;
    static GameRole[] roles_Ys;
    public int curRole;
    public int curStep;
    public int img_Index;
    public int img_Index2;
    static byte index;
    public static final byte SP_MOVE = 0;
    public static final byte SP_SET = 1;
    int scriptIndex;
    static int round;
    int iconIndex;
    boolean showIcon;
    int iconID;
    short[][] imgDataInterface = new short[][]{{0, 0, 120, 35}, {0, 35, 8, 8}, {0, 43, 19, 12}};
    short[][] imgDataInterface1 = new short[][]{{0, 0, 27, 27}, {27, 0, 18, 22}, {45, 0, 61, 21}, {31, 23, 5, 4}, {46, 23, 54, 4}};
    int showLeftHp;
    int showRightHp;
    int lastLeftHit;
    int lastRightHit;
    int leftHitIndex;
    int rightIndex;
    static final int hpStep = 2;
    static Vector roleShot;
    static Vector emyShot;
    static byte[][] imgDatBomb;
    static byte[][] imgDatWind;
    public static final byte EFFECT_HIT = 0;
    public static final byte EFFECT_DUST = 1;
    public static final byte EFFECT_BLOOD = 2;
    public static final byte EFFECT_BOMB = 3;
    public static final byte EFFECT_STAR = 4;
    public static final byte EFFECT_BAOQI_L = 5;
    public static final byte EFFECT_BAOQI_R = 6;
    public static final byte EFFECT_SG = 7;
    public static Vector hitEffectV;
    RecordStore db;
    private static int[][][] changeColor;
    static int[] crc_table;

    public GameEngine() {
        this.canvas = MyGameCanvas.me;
        map = new GameMap(240, 320, this);
    }

    public void rankEnd() {
        if (GameEngine.roles[0].HP <= 0 || GameEngine.roles[1].HP <= 0) {
            this.setGameState((byte)7);
            GameEngine.map.deadTime = 10;
            GameMIDlet.sleepTime = (short)200;
            if (GameEngine.roles[0].HP > GameEngine.roles[1].HP) {
                ++GameEngine.roles[0].vectorNum;
            } else {
                ++GameEngine.roles[1].vectorNum;
            }
        } else if (time <= 0) {
            if (GameEngine.roles[0].y == 320 - 30) {
                if (GameEngine.roles[1].y == 320 - 30) {
                    GameEngine.roles[0].curSpeedX = 0;
                    GameEngine.roles[0].curSpeedY = 0;
                    GameEngine.roles[1].curSpeedX = 0;
                    GameEngine.roles[1].curSpeedY = 0;
                    if (GameEngine.roles[0].HP > GameEngine.roles[1].HP) {
                        roles[0].setStatus((byte)18);
                        roles[1].setStatus((byte)20);
                    } else {
                        roles[1].setStatus((byte)18);
                        roles[0].setStatus((byte)20);
                    }
                    if (GameEngine.roles[0].HP > GameEngine.roles[1].HP) {
                        ++GameEngine.roles[0].vectorNum;
                    } else {
                        ++GameEngine.roles[1].vectorNum;
                    }
                    this.setGameState((byte)3);
                }
            }
        }
    }

    public void initYs(int step) {
        switch (step) {
            case 0: {
                Tools.removeAllImage();
                hitEffectV.removeAllElements();
                roleShot.removeAllElements();
                emyShot.removeAllElements();
                System.gc();
                break;
            }
            case 1: {
                for (int i = 0; i < roles_Ys.length; ++i) {
                    GameEngine.roles_Ys[i] = new GameRole(this, i, 0);
                    this.setRoleImage(roles_Ys[i], 0);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < roles_Ys.length; ++i) {
                    GameEngine.roles_Ys[i].isLeft = i % 2 != 0;
                    GameEngine.roles_Ys[i].x = i % 2 == 0 ? -40 : GameMap.SCREEN_WIDTH + 10;
                    GameEngine.roles_Ys[i].y = (short)(GameMap.SCREEN_HEIGHT - 30);
                }
                break;
            }
        }
    }

    public void setStepYs() {
        ++this.curStep;
    }

    public void runYs() {
        byte[] img = new byte[]{53, 54, 55, 56, 57};
        Tools.addObject(img[this.curRole], GameMap.setOffX + GameMap.SCREEN_WIDTH + 140 - this.img_Index * 28, GameMap.setOffY, 24, (byte)0, 11);
        if (this.img_Index < 5) {
            ++this.img_Index;
            this.curStep = -1;
        } else {
            if (this.curStep == -1) {
                this.curStep = 0;
            }
            if (this.curStep == 3) {
                this.img_Index += 2;
            }
        }
        if (this.curStep != 3) {
            byte[][] imgData = new byte[][]{{0, 0, 52, 31}, {0, 31, 52, 29}, {0, 60, 100, 28}, {0, 89, 76, 28}, {0, 117, 76, 30}};
            Tools.addObject(40, GameMap.setOffX - 100 - this.img_Index2 * 50, GameMap.setOffY, imgData[this.curRole], 20, (byte)0, 11);
            if (this.curStep > 0 && this.img_Index2 > -2) {
                --this.img_Index2;
            }
        }
        GameEngine.moveShot(roleShot);
        switch (this.curStep) {
            case 0: {
                if (GameEngine.roles_Ys[this.curRole].curStatus != 13) {
                    roles_Ys[this.curRole].setStatus((byte)13);
                    int n = GameEngine.roles_Ys[this.curRole].curSpeedX = GameEngine.roles_Ys[this.curRole].isLeft ? -GameEngine.roles_Ys[this.curRole].speed * 3 : GameEngine.roles_Ys[this.curRole].speed * 3;
                }
                if (GameEngine.roles_Ys[this.curRole].isLeft) {
                    if (GameEngine.roles_Ys[this.curRole].x > GameMap.SCREEN_WIDTH - 20) break;
                    GameEngine.roles_Ys[this.curRole].curSpeedX = 0;
                    this.setStepYs();
                    break;
                }
                if (GameEngine.roles_Ys[this.curRole].x < 20) break;
                GameEngine.roles_Ys[this.curRole].curSpeedX = 0;
                this.setStepYs();
                break;
            }
            case 1: {
                roles_Ys[this.curRole].setStatus((byte)28);
                break;
            }
            case 2: {
                roles_Ys[this.curRole].setStatus((byte)18);
                break;
            }
            case 3: {
                if (GameEngine.roles_Ys[this.curRole].curStatus != 13) {
                    roles_Ys[this.curRole].setStatus((byte)13);
                    int n = GameEngine.roles_Ys[this.curRole].curSpeedX = GameEngine.roles_Ys[this.curRole].isLeft ? -GameEngine.roles_Ys[this.curRole].speed * 3 : GameEngine.roles_Ys[this.curRole].speed * 3;
                }
                if (GameEngine.roles_Ys[this.curRole].isLeft) {
                    if (GameEngine.roles_Ys[this.curRole].x > -60) break;
                    this.curStep = 0;
                    this.img_Index = 0;
                    this.img_Index2 = 0;
                    if (++this.curRole != 5) break;
                    MyGameCanvas.setST((byte)30);
                    break;
                }
                if (GameEngine.roles_Ys[this.curRole].x < GameMap.SCREEN_WIDTH + 60) break;
                this.curStep = 0;
                this.img_Index = 0;
                this.img_Index2 = 0;
                if (++this.curRole != 5) break;
                MyGameCanvas.setST((byte)30);
            }
        }
    }

    public void initGame(int step) {
        switch (step) {
            case 0: {
                Tools.removeAllImage();
                hitEffectV.removeAllElements();
                roleShot.removeAllElements();
                emyShot.removeAllElements();
                System.gc();
                break;
            }
            case 1: {
                for (int i = 0; i < 2; ++i) {
                    GameEngine.roles[i] = new GameRole(this, this.canvas.roles[i], i);
                }
                this.setImage();
                break;
            }
            case 2: {
                round = 0;
                this.initRound();
            }
        }
    }

    public void setImage() {
        this.setRoleImage(roles[0], this.canvas.roleCol);
        if (GameEngine.roles[1].type == GameEngine.roles[0].type) {
            this.setRoleImage(roles[1], 0);
        } else {
            this.setRoleImage(roles[1], 0);
        }
    }

    private void setRoleImage(GameRole role, int colMode) {
        byte[] imgs = new byte[]{45, 46, 47, 48, 49};
        byte[] imgsEx = new byte[]{75, 76, 77, 78, 79};
        switch (colMode) {
            case 0: {
                role.img = imgs[role.type];
                Tools.getImage(role.img);
                break;
            }
            case 1: {
                role.img = imgsEx[role.type];
                Tools.setImage(GameEngine.getChangeImage(imgs[role.type], role.type), role.img);
            }
        }
    }

    public void ctrl(int key) {
        block0 : switch (curState) {
            case 2: {
                if (time <= 0) {
                    return;
                }
                roles[0].ctrl(key);
                switch (key) {
                    case -21: {
                        MyGameCanvas.setST((byte)16);
                        break block0;
                    }
                    case -22: {
                        MyGameCanvas.soundPlayer.stopAllMusic();
                        MyGameCanvas.setST((byte)9);
                    }
                }
            }
        }
    }

    public void ctrlRelease(int key) {
        roles[0].ctrlRelease();
    }

    public void attackJudge(GameRole role, GameRole emy) {
        if (emy.attArea[2] != 0 && role.superTime == 0 && Tools.hit(role.defendArea[0], role.defendArea[1], role.defendArea[2], role.defendArea[3], emy.attArea[0], emy.attArea[1], emy.attArea[2], emy.attArea[3])) {
            int attMode = 0;
            block0 : switch (emy.curStatus) {
                case 17: {
                    switch (emy.type) {
                        case 0: {
                            switch (emy.curIndex) {
                                default: 
                            }
                            attMode = 3;
                            break;
                        }
                        case 1: {
                            attMode = 2;
                            break;
                        }
                        case 2: {
                            switch (emy.curIndex) {
                                default: 
                            }
                            attMode = 3;
                            break;
                        }
                        case 3: {
                            attMode = 7;
                            break;
                        }
                        case 4: {
                            attMode = 1;
                        }
                    }
                    break;
                }
                case 8: {
                    block18 : switch (emy.type) {
                        case 0: {
                            switch (emy.curIndex) {
                                default: 
                            }
                            attMode = 3;
                            break;
                        }
                        case 1: {
                            switch (emy.curIndex) {
                                default: 
                            }
                            attMode = 3;
                            break;
                        }
                        case 2: {
                            attMode = 3;
                            break;
                        }
                        case 3: {
                            attMode = 7;
                            break;
                        }
                        case 4: {
                            switch (emy.curIndex) {
                                case 38: {
                                    attMode = 1;
                                    break block18;
                                }
                            }
                            attMode = 4;
                        }
                    }
                    GameEngine.map.armorTime = 3;
                    break;
                }
                case 9: {
                    block32 : switch (emy.type) {
                        case 0: {
                            if (role.canDefend()) {
                                emy.setStatus((byte)14);
                                emy.curSpeedX = 2 * (emy.isLeft ? emy.speed : -emy.speed);
                                emy.curSpeedY = -12;
                                GameEngine.map.armorTime = 3;
                                break;
                            }
                            emy.setStatus((byte)26);
                            emy.isPass = true;
                            emy.layer = 201;
                            attMode = 10;
                            role.x = emy.x + (emy.isLeft ? 10 - role.w / 2 : emy.w - 10 - role.w / 2);
                            role.y = emy.y - 10;
                            GameEngine.map.armorTime = 0;
                            GameEngine.map.blackTime = 5;
                            break;
                        }
                        case 1: {
                            switch (emy.curIndex) {
                                case 50: 
                                case 51: {
                                    attMode = 1;
                                    break block32;
                                }
                            }
                            attMode = 4;
                            break;
                        }
                        case 2: {
                            attMode = 2;
                            break;
                        }
                        case 3: {
                            switch (emy.curIndex) {
                                default: 
                            }
                            attMode = 4;
                            break;
                        }
                        case 4: {
                            attMode = 9;
                            GameEngine.map.armorTime = 3;
                        }
                    }
                    break;
                }
                case 10: {
                    switch (emy.type) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            if (role.canDefend()) {
                                emy.setStatus((byte)14);
                                emy.curSpeedX = 2 * (emy.isLeft ? emy.speed : -emy.speed);
                                emy.curSpeedY = -12;
                                GameEngine.map.armorTime = 3;
                                break;
                            }
                            emy.setStatus((byte)28);
                            emy.layer = 201;
                            GameEngine.map.armorTime = 0;
                            GameEngine.map.blackTime = 5;
                        }
                    }
                    GameEngine.map.armorTime = 3;
                    break;
                }
                case 28: {
                    switch (emy.type) {
                        case 4: {
                            switch (emy.curIndex) {
                                case 4: {
                                    attMode = 2;
                                    break block0;
                                }
                            }
                            attMode = 3;
                            break block0;
                        }
                        case 0: {
                            switch (emy.curIndex) {
                                case 22: 
                                case 45: 
                                case 46: {
                                    attMode = 7;
                                    break block0;
                                }
                            }
                            attMode = 3;
                            break block0;
                        }
                        case 1: {
                            switch (emy.curIndex) {
                                case 28: 
                                case 30: {
                                    attMode = 7;
                                    break block0;
                                }
                            }
                            attMode = 3;
                            break block0;
                        }
                        case 2: {
                            switch (emy.curIndex) {
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: 
                                case 38: 
                                case 39: {
                                    attMode = 2;
                                    break block0;
                                }
                                case 22: 
                                case 40: 
                                case 41: {
                                    attMode = 11;
                                    break block0;
                                }
                            }
                            attMode = 4;
                            break block0;
                        }
                        case 3: {
                            switch (emy.curIndex) {
                                case 13: 
                                case 14: {
                                    attMode = 7;
                                    break block0;
                                }
                            }
                            attMode = 4;
                        }
                    }
                }
            }
            role.injure(emy.attack, attMode);
            role.MPAdd(7);
            emy.MPAdd(5);
            switch (emy.type) {
                case 0: {
                    if (emy.curStatus == 10 || emy.curIndex != 18 && emy.curIndex != 22 && emy.curIndex != 27) break;
                    emy.countAtt();
                    break;
                }
                case 1: {
                    if (emy.curStatus == 10 || emy.curIndex != 19 && emy.curIndex != 22 && emy.curIndex != 25) break;
                    emy.countAtt();
                    break;
                }
                case 2: {
                    if (emy.curStatus == 10 || emy.curIndex != 19 && emy.curIndex != 22 && emy.curIndex != 26) break;
                    emy.countAtt();
                    break;
                }
                case 3: {
                    if (emy.curStatus == 10 || emy.curIndex != 20 && emy.curIndex != 23 && emy.curIndex != 26) break;
                    emy.countAtt();
                    break;
                }
                case 4: {
                    if (emy.curStatus == 10 || emy.curIndex != 23 && emy.curIndex != 28 && emy.curIndex != 33) break;
                    emy.countAtt();
                }
            }
        }
    }

    public void hitShot() {
        int[] temp;
        int i;
        int size;
        if (GameEngine.roles[1].superTime == 0) {
            size = roleShot.size();
            for (i = size - 1; i >= 0; --i) {
                temp = (int[])roleShot.elementAt(i);
                if (temp[9] == 1 || !Tools.hit(temp[0], temp[1], temp[4], temp[5], GameEngine.roles[1].defendArea[0], GameEngine.roles[1].defendArea[1], GameEngine.roles[1].defendArea[2], GameEngine.roles[1].defendArea[3])) continue;
                roles[1].injure(temp[6], 6);
                if (temp[7] != 0) {
                    temp[9] = 1;
                }
                roles[0].MPAdd(5);
                roles[1].MPAdd(7);
            }
        }
        if (GameEngine.roles[0].superTime == 0) {
            size = emyShot.size();
            for (i = size - 1; i >= 0; --i) {
                temp = (int[])emyShot.elementAt(i);
                if (temp[9] == 1 || !Tools.hit(temp[0], temp[1], temp[4], temp[5], GameEngine.roles[0].defendArea[0], GameEngine.roles[0].defendArea[1], GameEngine.roles[0].defendArea[2], GameEngine.roles[0].defendArea[3])) continue;
                roles[0].injure(temp[6], 6);
                if (temp[7] != 0) {
                    temp[9] = 1;
                }
                roles[0].MPAdd(7);
                roles[1].MPAdd(5);
            }
        }
    }

    public void runScript() {
        switch (this.scriptIndex) {
            case 0: {
                roles[0].setStatus((byte)13);
                GameEngine.roles[0].curSpeedX = GameEngine.roles[0].speed * 2;
                roles[1].setStatus((byte)13);
                GameEngine.roles[1].curSpeedX = -GameEngine.roles[1].speed * 2;
                break;
            }
            case 3: {
                GameEngine.roles[0].curSpeedX = 0;
                roles[0].setStatus((byte)16);
                GameEngine.roles[1].curSpeedX = 0;
                roles[1].setStatus((byte)16);
                break;
            }
            case 7: {
                roles[0].setStatus((byte)17);
                roles[1].setStatus((byte)17);
                break;
            }
            case 14: {
                this.setGameState((byte)1);
                return;
            }
        }
        ++this.scriptIndex;
    }

    public void setGameState(byte gameState) {
        nextState = gameState;
        index = 0;
    }

    public void runGame() {
        if (curState != nextState) {
            lastState = curState;
            curState = nextState;
        }
        switch (curState) {
            case 0: {
                this.runScript();
                roles[0].run();
                roles[1].run();
                break;
            }
            case 4: {
                roles[0].run();
                roles[1].run();
                break;
            }
            case 1: {
                roles[0].run();
                roles[1].run();
                break;
            }
            case 2: {
                boolean roleIsLeft;
                if (time > 0) {
                    --time;
                }
                if (GameEngine.map.superTime > 0) {
                    return;
                }
                GameEngine.roles[0].attack = GameEngine.roles[0].baoqiTime > 0 ? (GameEngine.roles[0].curStatus == 8 || GameEngine.roles[0].curStatus == 9 || GameEngine.roles[0].curStatus == 26 || GameEngine.roles[0].curStatus == 10 || GameEngine.roles[0].curStatus == 28 ? 5 : (GameEngine.roles[0].curStatus == 17 ? 4 : 3)) : (GameEngine.roles[0].curStatus == 8 || GameEngine.roles[0].curStatus == 9 || GameEngine.roles[0].curStatus == 26 || GameEngine.roles[0].curStatus == 10 || GameEngine.roles[0].curStatus == 28 ? 4 : (GameEngine.roles[0].curStatus == 17 ? 3 : 2));
                GameEngine.roles[1].attack = GameEngine.roles[1].baoqiTime > 0 ? (GameEngine.roles[1].curStatus == 8 || GameEngine.roles[1].curStatus == 9 || GameEngine.roles[1].curStatus == 26 || GameEngine.roles[1].curStatus == 10 || GameEngine.roles[1].curStatus == 28 ? 5 : (GameEngine.roles[1].curStatus == 17 ? 4 : 3)) : (GameEngine.roles[1].curStatus == 8 || GameEngine.roles[1].curStatus == 9 || GameEngine.roles[1].curStatus == 26 || GameEngine.roles[1].curStatus == 10 || GameEngine.roles[1].curStatus == 28 ? 4 : (GameEngine.roles[1].curStatus == 17 ? 3 : 2));
                GameEngine.roles[0].roleIsLeft = roleIsLeft = GameEngine.roles[0].x + GameEngine.roles[0].w / 2 < GameEngine.roles[1].x + GameEngine.roles[1].w / 2;
                boolean bl = GameEngine.roles[1].roleIsLeft = !roleIsLeft;
                if (GameEngine.roles[0].curStatus == 0 || GameEngine.roles[0].curStatus == 1) {
                    boolean bl2 = GameEngine.roles[0].isLeft = !roleIsLeft;
                }
                if (GameEngine.roles[1].curStatus == 0 || GameEngine.roles[1].curStatus == 1) {
                    GameEngine.roles[1].isLeft = roleIsLeft;
                }
                roles[0].dealKey();
                roles[0].run();
                roles[1].AI(roles[0]);
                roles[1].run();
                GameEngine.moveShot(roleShot);
                GameEngine.moveShot(emyShot);
                this.attackJudge(roles[0], roles[1]);
                this.attackJudge(roles[1], roles[0]);
                this.hitShot();
                this.rankEnd();
                map.MoveSrceen((GameEngine.roles[0].x + GameEngine.roles[0].w / 2 + GameEngine.roles[1].x + GameEngine.roles[1].w / 2) / 2, 0);
                System.out.println("roles[0].curs1111111111123::" + GameEngine.roles[0].curStatus);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                boolean roleIsLeft;
                GameEngine.roles[0].roleIsLeft = roleIsLeft = GameEngine.roles[0].x + GameEngine.roles[0].w / 2 < GameEngine.roles[1].x + GameEngine.roles[1].w / 2;
                GameEngine.roles[1].roleIsLeft = !roleIsLeft;
                roles[0].run();
                roles[1].run();
                if (GameEngine.roles[0].y != 320 - 30) break;
                if (GameEngine.roles[1].y != 320 - 30 || GameEngine.roles[0].curStatus != 6 && GameEngine.roles[1].curStatus != 6) break;
                if (GameEngine.roles[0].HP > GameEngine.roles[1].HP) {
                    roles[0].setStatus((byte)18);
                } else {
                    roles[1].setStatus((byte)18);
                }
                GameEngine.roles[0].curSpeedX = 0;
                GameEngine.roles[0].curSpeedY = 0;
                GameEngine.roles[1].curSpeedX = 0;
                GameEngine.roles[1].curSpeedY = 0;
                this.setGameState((byte)3);
                break;
            }
            case 3: {
                boolean roleIsLeft;
                GameEngine.roles[0].roleIsLeft = roleIsLeft = GameEngine.roles[0].x + GameEngine.roles[0].w / 2 < GameEngine.roles[1].x + GameEngine.roles[1].w / 2;
                GameEngine.roles[1].roleIsLeft = !roleIsLeft;
                roles[0].hideVision();
                roles[1].hideVision();
                roles[0].run();
                roles[1].run();
            }
        }
    }

    public void drawStart(int x, int y, int lev) {
        if (index < 10) {
            Tools.addObject(51, x + 120 - 52, y + 160, 6, (byte)0, lev);
            byte[][] imgNum = new byte[][]{{0, 0, 18, 28}, {18, 0, 24, 28}, {42, 0, 23, 28}};
            Tools.addObject(52, x + 120 + 20, y + 160, imgNum[round], 6, (byte)0, lev);
        } else if (index < 20) {
            Tools.addObject(60, x + 120, y + 160, 3, (byte)0, lev);
        }
        index = (byte)(index + 1);
        if (index == 20) {
            this.setGameState((byte)2);
        }
    }

    public void drawEnd(int x, int y, int lev) {
        Tools.addObject(12, x + 120, y + 160, 43 * (GameEngine.roles[0].HP > GameEngine.roles[1].HP ? 0 : 1), 0, 43, 43, 3, (byte)0, lev);
        if (GameEngine.roles[0].HP > GameEngine.roles[1].HP) {
            Tools.addObject(12, x + 120, y + 160, 0, 0, 47, 33, 3, (byte)0, lev);
        } else {
            Tools.addObject(12, x + 120, y + 160, 47, 0, 45, 33, 3, (byte)0, lev);
        }
        index = (byte)(index + 1);
        if (index > 10) {
            if (MyGameCanvas.mode == 2) {
                if (GameEngine.roles[0].HP > GameEngine.roles[1].HP || GameEngine.roles[0].vectorNum == 2 || round == 2) {
                    MyGameCanvas.Scroe[1] = time / 100;
                    MyGameCanvas.Scroe[3] = GameEngine.roles[1].hitNum2 > 20 ? 20 : GameEngine.roles[1].hitNum2;
                    if (GameEngine.roles[0].HP == GameEngine.roles[0].HP_MAX) {
                        MyGameCanvas.Scroe[0] = 0;
                        MyGameCanvas.Scroe[2] = 20;
                    } else {
                        MyGameCanvas.Scroe[0] = GameEngine.roles[0].HP / 20 + 1;
                        MyGameCanvas.Scroe[2] = 0;
                    }
                    if (round == 0) {
                        MyGameCanvas.Scroe[4] = MyGameCanvas.Scroe[0] + MyGameCanvas.Scroe[1] + MyGameCanvas.Scroe[2] + MyGameCanvas.Scroe[3];
                        MyGameCanvas.Scroe[5] = MyGameCanvas.Scroe[4];
                    } else {
                        MyGameCanvas.Scroe[5] = MyGameCanvas.Scroe[4];
                        MyGameCanvas.Scroe[4] = MyGameCanvas.Scroe[0] + MyGameCanvas.Scroe[1] + MyGameCanvas.Scroe[2] + MyGameCanvas.Scroe[3];
                        MyGameCanvas.Scroe[5] = MyGameCanvas.Scroe[5] + MyGameCanvas.Scroe[4];
                    }
                    ++round;
                    MyGameCanvas.setST((byte)3);
                } else {
                    for (int i = 0; i < MyGameCanvas.Scroe.length - 2; ++i) {
                        MyGameCanvas.Scroe[i] = 0;
                    }
                    ++round;
                    MyGameCanvas.setST((byte)21);
                }
            } else {
                ++round;
                MyGameCanvas.setST((byte)21);
            }
        }
    }

    public void dealEnd() {
        if (GameEngine.roles[0].vectorNum >= 2) {
            switch (MyGameCanvas.mode) {
                case 0: {
                    if (this.canvas.groupIndex >= 5) {
                        MyGameCanvas.setST((byte)25);
                        break;
                    }
                    this.canvas.setPlayers(MyGameCanvas.curIcon);
                    MyGameCanvas.setST((byte)13);
                    MyGameCanvas.vsIndex = 0;
                    break;
                }
                case 1: {
                    MyGameCanvas.setST((byte)25);
                    this.canvas.resultIndex = 0;
                    break;
                }
                case 2: {
                    MyGameCanvas.setST((byte)25);
                    this.canvas.resultIndex = 0;
                    if (MyGameCanvas.Scroe[5] <= MyMessage.H_Score) break;
                    MyMessage.H_Score = MyGameCanvas.Scroe[5];
                    this.writeDB();
                }
            }
        } else if (GameEngine.roles[1].vectorNum >= 2) {
            MyGameCanvas.setST((byte)26);
            this.canvas.resultIndex = 0;
            if (MyGameCanvas.mode == 2 && MyGameCanvas.Scroe[5] > MyMessage.H_Score) {
                MyMessage.H_Score = MyGameCanvas.Scroe[5];
                this.writeDB();
            }
        } else {
            MyGameCanvas.setST((byte)20);
            this.initRound();
        }
    }

    public void initRound() {
        hitEffectV.removeAllElements();
        roleShot.removeAllElements();
        emyShot.removeAllElements();
        for (int i = 0; i < 2; ++i) {
            roles[i].initRole();
            GameEngine.roles[i].baoqiTime = 0;
        }
        this.showLeftHp = GameEngine.roles[0].HP;
        this.showRightHp = GameEngine.roles[1].HP;
        map.adjustScreen((GameEngine.roles[0].x + GameEngine.roles[0].w / 2 + GameEngine.roles[1].x + GameEngine.roles[1].w / 2) / 2, 0);
        this.setGameState((byte)0);
        curState = nextState;
        this.scriptIndex = 0;
        time = 990;
        GameEngine.map.armorTime = 0;
        GameEngine.map.superTime = 0;
        GameMap.shakeTime = 0;
        this.showIcon = false;
    }

    public void drawGame(Graphics g) {
        g.translate(-GameMap.setOffX, -GameMap.setOffY);
        map.drawMap();
        roles[0].paint();
        roles[1].paint();
        GameEngine.drawShot(roleShot);
        GameEngine.drawShot(emyShot);
        this.drawHitEffect();
        this.drawInterface(GameMap.setOffX, GameMap.setOffY);
        switch (curState) {
            case 1: {
                this.drawStart(GameMap.setOffX, GameMap.setOffY, 2000);
                break;
            }
            case 3: {
                this.drawEnd(GameMap.setOffX, GameMap.setOffY, 2000);
            }
        }
    }

    public void showIcon(int icon) {
        this.showIcon = true;
        this.iconIndex = 0;
        this.iconID = icon;
    }

    public void hideIcon() {
        this.showIcon = false;
    }

    public void checkLeftHit() {
        boolean temp = this.lastLeftHit < GameEngine.roles[1].hitNum;
        this.lastLeftHit = GameEngine.roles[1].hitNum;
        this.leftHitIndex = temp && this.leftHitIndex == 1 ? 0 : 1;
    }

    public void checkRightHit() {
        boolean temp = this.lastRightHit < GameEngine.roles[0].hitNum;
        this.lastRightHit = GameEngine.roles[0].hitNum;
        this.rightIndex = temp && this.rightIndex == 1 ? 0 : 1;
    }

    public void drawInterface(int x, int y) {
        int i;
        byte[][] imgData;
        if (this.showLeftHp > GameEngine.roles[0].HP) {
            this.showLeftHp = Math.abs(this.showLeftHp - GameEngine.roles[0].HP) >= 2 ? (this.showLeftHp -= 2) : GameEngine.roles[0].HP;
        }
        if (this.showRightHp > GameEngine.roles[1].HP) {
            this.showRightHp = Math.abs(this.showRightHp - GameEngine.roles[1].HP) >= 2 ? (this.showRightHp -= 2) : GameEngine.roles[1].HP;
        }
        Tools.addObject(20, x, y, this.imgDataInterface[0], 20, (byte)0, 2000);
        Tools.addObject(20, x + 240, y, this.imgDataInterface[0], 24, (byte)1, 2000);
        int temp = GameMIDlet.gameIndex % 2;
        if (GameEngine.roles[0].HP < GameEngine.roles[0].HP_MAX / 3) {
            if (temp == 0) {
                Tools.addObject(20, x + 11, y + 31, 20, 36, 85 * GameEngine.roles[0].HP / GameEngine.roles[0].HP_MAX, 9, 36, (byte)0, 2000);
            }
        } else {
            Tools.addObject(20, x + 11, y + 31, 20, 36, 85 * GameEngine.roles[0].HP / GameEngine.roles[0].HP_MAX, 9, 36, (byte)0, 2000);
        }
        if (GameEngine.roles[1].HP < GameEngine.roles[1].HP_MAX / 3) {
            if (temp == 0) {
                Tools.addObject(20, x + 240 - 11, y + 31, 20, 36, 85 * GameEngine.roles[1].HP / GameEngine.roles[1].HP_MAX, 9, 40, (byte)1, 2000);
            }
        } else {
            Tools.addObject(20, x + 240 - 11, y + 31, 20, 36, 85 * GameEngine.roles[1].HP / GameEngine.roles[1].HP_MAX, 9, 40, (byte)1, 2000);
        }
        Tools.addObject(18, x + 5, y + 7, 0, GameEngine.roles[0].type * 19, 25, 19, 20, (byte)0, 2000);
        Tools.addObject(18, x + 240 - 5, y + 7, 0, GameEngine.roles[1].type * 19, 25, 19, 24, (byte)1, 2000);
        Tools.addObject(20, x + 25, y + 22, this.imgDataInterface[2], 20, (byte)0, 2000);
        Tools.addObject(20, x + 240 - 25, y + 22, this.imgDataInterface[2], 24, (byte)1, 2000);
        Tools.addObject(21, x + 27, y + 320, this.imgDataInterface1[2], 36, (byte)0, 2000);
        Tools.addObject(21, x + 240 - 27, y + 320, this.imgDataInterface1[2], 40, (byte)1, 2000);
        Tools.addObject(21, x + 28, y + 320 - 12, 46, 23, 54 * GameEngine.roles[0].MP / GameEngine.roles[0].MP_MAX, 4, 36, (byte)0, 2000);
        Tools.addObject(21, x + 240 - 28, y + 320 - 12, 46, 23, 54 * GameEngine.roles[0].MP / GameEngine.roles[0].MP_MAX, 4, 40, (byte)1, 2000);
        Tools.addObject(21, x, y + 320, this.imgDataInterface1[0], 36, (byte)0, 2000);
        Tools.addObject(21, x + 240, y + 320, this.imgDataInterface1[0], 40, (byte)0, 2000);
        if (GameEngine.roles[0].baoqiTime > 0) {
            --GameEngine.roles[0].baoqiTime;
            imgData = new byte[][]{{0, 27, 17, 15}, {39, 23, 20, 20}, {17, 23, 22, 22}, {0, 1, 24, 22}, {29, 0, 24, 23}};
            switch (GameEngine.roles[0].baoqiTime) {
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: {
                    System.out.println("baoqi");
                    Tools.addObject(0, x + 13, y + 320 - 13, imgData[99 - GameEngine.roles[0].baoqiTime], 3, (byte)0, 2000);
                }
            }
            Tools.addObject(21, x + 4, y + 320 - 3, 27, 22 - 22 * GameEngine.roles[0].baoqiTime / 100, 18, 0 + 22 * GameEngine.roles[0].baoqiTime / 100, 36, (byte)0, 2000);
        }
        if (GameEngine.roles[1].baoqiTime > 0) {
            --GameEngine.roles[1].baoqiTime;
            imgData = new byte[][]{{0, 27, 17, 15}, {39, 23, 20, 20}, {17, 23, 22, 22}, {0, 1, 24, 22}, {29, 0, 24, 23}};
            switch (GameEngine.roles[1].baoqiTime) {
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: {
                    Tools.addObject(0, x + 240 - 13, y + 320 - 13, imgData[99 - GameEngine.roles[1].baoqiTime], 3, (byte)0, 2000);
                }
            }
            Tools.addObject(21, x + 240 - 4, y + 320 - 3, 27, 22 - 22 * GameEngine.roles[1].baoqiTime / 100, 18, 0 + 22 * GameEngine.roles[1].baoqiTime / 100, 40, (byte)0, 2000);
        }
        for (i = 0; i < GameEngine.roles[0].vectorNum; ++i) {
            Tools.addObject(20, x + 87 - 13 * i, y + 13, this.imgDataInterface[1], 24, (byte)0, 2000);
        }
        for (i = 0; i < GameEngine.roles[1].vectorNum; ++i) {
            Tools.addObject(20, x + 240 - 87 + 13 * i, y + 13, this.imgDataInterface[1], 20, (byte)0, 2000);
        }
        for (i = 0; i < GameEngine.roles[0].power; ++i) {
            Tools.addObject(21, x + 8 * i + 31, y + 320 - 5, this.imgDataInterface1[3], 36, (byte)0, 2000);
        }
        for (i = 0; i < GameEngine.roles[1].power; ++i) {
            Tools.addObject(21, x + 240 - 8 * i - 31, y + 320 - 5, this.imgDataInterface1[3], 40, (byte)0, 2000);
        }
        GameEngine.drawNumber((byte)63, time / 10, x + 240 / 2 - 6 * this.getDigit(time / 10), y + 16, -1, 2000, 36);
        this.checkLeftHit();
        this.checkRightHit();
        if (GameEngine.roles[1].hitNum > 1) {
            GameEngine.drawNumber((byte)41, GameEngine.roles[1].hitNum, x + 59, y + 90, -1, 2000, 36);
            Tools.addObject(14, x, y + 90, 36, (byte)0, 2000);
            if (GameEngine.roles[1].hitNum > GameEngine.roles[1].hitNum2) {
                GameEngine.roles[1].hitNum2 = GameEngine.roles[1].hitNum;
            }
        }
        if (GameEngine.roles[0].hitNum > 1) {
            GameEngine.drawNumber((byte)41, GameEngine.roles[0].hitNum, x + 240 - 59, y + 90, -1, 2000, 40);
            Tools.addObject(14, x + 240, y + 90, 40, (byte)0, 2000);
        }
    }

    public int getDigit(int number) {
        int counter = 0;
        do {
            ++counter;
        } while ((number /= 10) > 0);
        return counter;
    }

    public static void addToVector(int x, int y, int dir, int speed, int w, int h, int att, int type, Vector shot) {
        int[] temp = new int[]{x, y, dir, speed, w, h, att, type, 0, 0};
        shot.addElement(temp);
    }

    public static final void moveShot(Vector shot) {
        int size = shot.size();
        block7: for (int i = size - 1; i >= 0; --i) {
            int[] temp = (int[])shot.elementAt(i);
            switch (temp[7]) {
                case 0: {
                    byte[] adjustX = new byte[]{0, 3, -3, 2, -2, 8, 3, 4, 4, 7, 6, 6, 7};
                    byte[] adjustDGX = new byte[]{0, -8, -11, -9, -15, -7, -5, -2, -2, -5, 0, -1, -1};
                    byte[] adjustY = new byte[]{0, 0, 1, 0, 1, 0, 0, -2, 0, -1, 0, -3, -10};
                    byte[] tempw = new byte[]{4, 9, 23, 30, 47, 46, 48, 46, 44, 42, 36, 31, 25};
                    short[] temph = new short[]{4, 9, 13, 19, 27, 26, 29, 29, 30, 29, 29, 27, 19};
                    if (temp[8] >= adjustX.length) continue block7;
                    temp[0] = temp[0] + (temp[2] == 0 ? adjustDGX[temp[8]] : adjustX[temp[8]]);
                    temp[1] = temp[1] + adjustY[temp[8]];
                    temp[4] = tempw[temp[8]];
                    temp[5] = temph[temp[8]];
                    continue block7;
                }
                default: {
                    switch (temp[2]) {
                        case 0: {
                            temp[0] = temp[0] - temp[3];
                            continue block7;
                        }
                        case 1: {
                            temp[0] = temp[0] + temp[3];
                        }
                    }
                }
            }
        }
    }

    public static final void drawShot(Vector shot) {
        int lev = 400;
        int size = shot.size();
        for (int i = 0; i < size; ++i) {
            int[] temp = (int[])shot.elementAt(i);
            int cfr_ignored_0 = temp[7];
        }
        GameEngine.shotADD_REMOVE(shot);
    }

    public static final void shotADD_REMOVE(Vector shot) {
        if (GameEngine.map.superTime > 0) {
            return;
        }
        int size = shot.size();
        block4: for (int i = size - 1; i >= 0; --i) {
            int[] temp = (int[])shot.elementAt(i);
            temp[8] = temp[8] + 1;
            switch (temp[7]) {
                case 0: {
                    if (temp[8] < 13) continue block4;
                    shot.removeElement(temp);
                    continue block4;
                }
                case 1: {
                    if (temp[8] < 6) continue block4;
                    shot.removeElement(temp);
                    continue block4;
                }
                default: {
                    if (temp[8] < 7) continue block4;
                    shot.removeElement(temp);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void drawHitEffect() {
        int size = hitEffectV.size();
        int i = size - 1;
        while (true) {
            block14: {
                void var6_14;
                if (i < 0) {
                    return;
                }
                int[] temp = (int[])hitEffectV.elementAt(i);
                int imgIndex = -1;
                byte[] motion = null;
                byte[][] byArray = null;
                byte[] adjustY = null;
                byte[] adjustX = null;
                byte[] adjustDGX = null;
                int lev = 500;
                switch (temp[3]) {
                    case 7: {
                        byte[][] byArrayArray = new byte[][]{{0, 0, 24, 28}, {24, 0, 17, 25}, {41, 0, 24, 24}, {0, 28, 37, 38}, {37, 28, 45, 47}};
                        motion = new byte[]{0, 1, 2, 3, 4};
                        Tools.addObject(11, temp[0], temp[1], byArrayArray[motion[temp[2]]], 3, (byte)0, lev);
                        temp[2] = temp[2] + 1;
                        if (temp[2] == motion.length) {
                            hitEffectV.removeElementAt(i);
                        }
                        break block14;
                    }
                    case 5: {
                        byte[][] byArrayArray = new byte[][]{{0, 0, 29, 24}, {0, 24, 31, 26}, {29, 0, 29, 24}, {33, 24, 18, 24}};
                        motion = new byte[]{0, 1, 2, 3};
                        Tools.addObject(10, temp[0], temp[1], byArrayArray[motion[temp[2]]], 40, temp[4] == 0 ? (byte)0 : 1, 2000);
                        temp[2] = temp[2] + 1;
                        if (temp[2] == motion.length) {
                            hitEffectV.removeElementAt(i);
                        }
                        break block14;
                    }
                    case 6: {
                        byte[][] byArrayArray = new byte[][]{{0, 0, 29, 24}, {0, 24, 31, 26}, {29, 0, 29, 24}, {33, 24, 18, 24}};
                        motion = new byte[]{0, 1, 2, 3};
                        Tools.addObject(10, temp[0], temp[1], byArrayArray[motion[temp[2]]], 36, temp[4] == 0 ? (byte)0 : 1, 2000);
                        temp[2] = temp[2] + 1;
                        if (temp[2] == motion.length) {
                            hitEffectV.removeElementAt(i);
                        }
                        break block14;
                    }
                    case 0: {
                        byte[][] byArrayArray = new byte[][]{{0, 0, 22, 26}, {22, 0, 37, 39}, {59, 0, 40, 39}};
                        motion = new byte[]{0, 1, 2};
                        adjustY = new byte[]{0, 9, 5};
                        adjustX = new byte[]{0, -6, -8};
                        adjustDGX = new byte[]{0, -9, -10};
                        imgIndex = 13;
                        break;
                    }
                    case 1: {
                        byte[][] byArrayArray = new byte[][]{{0, 0, 44, 13}, {0, 13, 52, 16}, {0, 29, 52, 16}};
                        motion = new byte[]{0, 1, 2};
                        adjustY = new byte[]{0, -1, -5};
                        adjustX = new byte[]{0, -4, -3};
                        adjustDGX = new byte[]{0, -4, -3};
                        imgIndex = 9;
                        break;
                    }
                    case 2: {
                        byte[][] byArrayArray = new byte[][]{{0, 0, 38, 34}, {0, 34, 48, 27}, {40, 0, 37, 27}, {48, 27, 35, 34}};
                        motion = new byte[]{0, 1, 2, 3};
                        adjustY = new byte[]{0, -14, -13, 5};
                        adjustX = new byte[]{0, -17, -19, -18};
                        adjustDGX = new byte[]{0, 7, 20, 21};
                        imgIndex = 7;
                    }
                }
                Tools.addObject(imgIndex, temp[0] + (temp[4] == 0 ? adjustX[temp[2]] : adjustDGX[temp[2]]), temp[1] + adjustY[temp[2]], (byte[])var6_14[motion[temp[2]]], 36, temp[4] == 0 ? (byte)0 : 1, temp[1] + lev);
                temp[2] = temp[2] + 1;
                if (temp[2] == motion.length) {
                    hitEffectV.removeElementAt(i);
                }
            }
            --i;
        }
    }

    public static void AddBlastEffectList(int x, int y, int type, int isMirror) {
        hitEffectV.addElement(new int[]{x, y, 0, type, isMirror});
    }

    public static void drawNumber(byte imgIndex, int number, int x, int y, int spacing, int level, int anchor) {
        int digitCounter = 0;
        int[] digits = new int[10];
        do {
            digits[digitCounter] = number % 10;
            ++digitCounter;
        } while ((number /= 10) > 0);
        int numWidth = Tools.getImage(imgIndex).getWidth() / 10;
        int numHeight = Tools.getImage(imgIndex).getHeight();
        switch (anchor) {
            case 36: {
                int i = digitCounter - 1;
                while (i >= 0) {
                    Tools.addObject(imgIndex, x, y, digits[i] * numWidth, 0, numWidth, numHeight, anchor, (byte)0, level);
                    --i;
                    x += spacing + numWidth;
                }
                break;
            }
            case 40: {
                int i = 0;
                while (i <= digitCounter - 1) {
                    Tools.addObject(imgIndex, x, y, digits[i] * numWidth, 0, numWidth, numHeight, anchor, (byte)0, level);
                    ++i;
                    x -= spacing + numWidth;
                }
                break;
            }
        }
    }

    public byte[][] readShadowData(String name) {
        DataInputStream is = new DataInputStream(this.getClass().getResourceAsStream("/dat/" + name));
        byte[][] clip = null;
        int clipLen = 0;
        try {
            clipLen = is.readShort();
            clip = new byte[clipLen][2];
            for (int i = 0; i < clipLen; ++i) {
                clip[i][0] = is.readByte();
                clip[i][1] = is.readByte();
            }
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return clip;
    }

    public byte[][] readClipData(String name) {
        DataInputStream is = new DataInputStream(this.getClass().getResourceAsStream("/dat/" + name));
        byte[][] clip = null;
        int clipLen = 0;
        try {
            clipLen = is.readShort();
            clip = new byte[clipLen][4];
            for (int i = 0; i < clipLen; ++i) {
                clip[i][0] = is.readByte();
                clip[i][1] = is.readByte();
                clip[i][2] = is.readByte();
                clip[i][3] = is.readByte();
            }
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return clip;
    }

    public byte[][] readFrameData(String name) {
        InputStream is = this.getClass().getResourceAsStream("/dat/" + name);
        DataInputStream dis = new DataInputStream(is);
        Object dat = null;
        try {
            int groupSize = 0;
            groupSize = Tools.bToi(dis.readByte());
            dat = new byte[groupSize][];
            for (int i = 0; i < ((byte[][])dat).length; ++i) {
                int num = Tools.bToi(dis.readByte());
                dat[i] = new byte[num * 5];
                for (int j = 0; j < dat[i].length; ++j) {
                    dat[i][j] = dis.readByte();
                }
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dat;
    }

    public void writeDB() {
        this.openDB();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            ((OutputStream)dos).write(MyMessage.chargeData);
            for (int i = 0; i < scoreNote.length; ++i) {
                for (int j = 0; j < scoreNote[i].length; ++j) {
                    dos.writeInt(scoreNote[i][j]);
                }
            }
            if (Http.backStrIndex == 0) {
                dos.writeInt(0);
            } else {
                dos.writeInt(MyGameCanvas.pay);
            }
            dos.writeInt(MyMessage.H_Score);
            byte[] data = baos.toByteArray();
            try {
                this.db.setRecord(1, data, 0, data.length);
            }
            catch (Exception e) {
                this.db.addRecord(data, 0, data.length);
            }
            baos.close();
            dos.close();
            this.db.closeRecordStore();
        }
        catch (Exception e) {
            try {
                this.db.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
        }
    }

    public void readDB() {
        this.openDB();
        try {
            if (this.db.getNumRecords() < 1) {
                this.db.closeRecordStore();
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(this.db.getRecord(1));
            DataInputStream dis = new DataInputStream(bais);
            dis.read(MyMessage.chargeData);
            for (int i = 0; i < scoreNote.length; ++i) {
                for (int j = 0; j < scoreNote[i].length; ++j) {
                    GameEngine.scoreNote[i][j] = dis.readInt();
                }
            }
            MyGameCanvas.pay = dis.readInt();
            MyMessage.H_Score = dis.readInt();
            bais.close();
            dis.close();
            this.db.closeRecordStore();
        }
        catch (Exception e) {
            try {
                this.db.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
            e.printStackTrace();
            return;
        }
    }

    private void openDB() {
        try {
            this.db = RecordStore.openRecordStore((String)"qw", (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void delDB() {
        try {
            this.db.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            RecordStore.deleteRecordStore((String)"qw");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Image getChangeImage(int imgIndex, int type) {
        try {
            InputStream is = "".getClass().getResourceAsStream("/images/" + Tools.FILESNAME[imgIndex] + ".png");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int ii = 0;
            while ((ii = is.read()) != -1) {
                baos.write((byte)ii);
            }
            byte[] buff = baos.toByteArray();
            GameEngine.imgConvert(buff, type);
            return Image.createImage((byte[])buff, (int)0, (int)buff.length);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static void imgConvert(byte[] content, int type) {
        try {
            int pos = 33;
            int relpos = 0;
            relpos = ((content[pos] & 0xFF) << 24 | (content[pos + 1] & 0xFF) << 16 | (content[pos + 2] & 0xFF) << 8 | content[pos + 3] & 0xFF) & 0xFFFFFFFF;
            for (int idx = pos += 8; idx < pos + relpos; idx += 3) {
                int col;
                int nextCol = col = ((content[idx] & 0xFF) << 16 | (content[idx + 1] & 0xFF) << 8 | content[idx + 2] & 0xFF) & 0xFFFFFF;
                for (int i = 0; i < changeColor[type][0].length; ++i) {
                    if (col != changeColor[type][0][i]) continue;
                    nextCol = changeColor[type][1][i];
                }
                if (nextCol != col) {
                    content[idx] = (byte)(nextCol >> 16 & 0xFF);
                    content[idx + 1] = (byte)(nextCol >> 8 & 0xFF);
                    content[idx + 2] = (byte)(nextCol & 0xFF);
                }
                if (nextCol == col) continue;
                content[idx] = (byte)(nextCol >> 16 & 0xFF);
                content[idx + 1] = (byte)(nextCol << 8 >> 16 & 0xFF);
                content[idx + 2] = (byte)(nextCol << 16 >> 16 & 0xFF);
            }
            int actpos = 41 + relpos;
            long crc = GameEngine.calc_crc(content, 37, actpos - 37);
            content[actpos] = (byte)(crc >>> 24 & 0xFFL);
            content[actpos + 1] = (byte)(crc >>> 16 & 0xFFL);
            content[actpos + 2] = (byte)(crc >>> 8 & 0xFFL);
            content[actpos + 3] = (byte)(crc & 0xFFL);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static long calc_crc(byte[] buf, int off, int len) {
        int c = -1;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        return (long)(~c) & 0xFFFFFFFFL;
    }

    static {
        roles = new GameRole[2];
        scoreNote = new int[5][1];
        curState = 0;
        nextState = 0;
        lastState = 0;
        cpuAI = 1;
        GameEngine.scoreNote[0][0] = 1;
        GameEngine.scoreNote[1][0] = 1;
        for (int i = 0; i < 5; ++i) {
            GameEngine.scoreNote[i][0] = 1;
        }
        roles_Ys = new GameRole[5];
        index = 0;
        roleShot = new Vector();
        emyShot = new Vector();
        imgDatBomb = new byte[][]{{0, 0, 44, 21}, {0, 21, 44, 26}, {0, 48, 27, 21}, {29, 48, 27, 26}, {45, 0, 13, 21}, {45, 21, 13, 26}, {57, 48, 3, 26}, {61, 53, 44, 24}, {61, 0, 84, 53}, {0, 75, 48, 36}, {49, 78, 60, 30}, {111, 85, 56, 23}};
        imgDatWind = new byte[][]{{0, 0, 35, 31}, {0, 31, 33, 63}, {35, 0, 33, 104}, {110, 0, 38, 120}, {68, 0, 42, 120}};
        hitEffectV = new Vector();
        changeColor = new int[][][]{new int[][]{{11360809, 13472089, 14728835, 15852191, 2041394, 3290958, 4018781, 5992068}, {11374889, 13484377, 14409859, 14610847, 3937567, 6103848, 7220304, 10110308}}, new int[][]{{0x484646, 0x787677, 11644847, 2695431, 3943702, 4206598, 6114064, 8480546}, {0x355939, 7571813, 10404514, 462633, 1451324, 398912, 1057373, 2243713}}, new int[][]{{12095231, 0x6B3BBB, 3281003}, {10944398, 0x55BB3B, 2321168}}, new int[][]{{0x979797, 0x727272, 0x474747}, {13450043, 10168103, 5901838}}, new int[][]{{16503607, 14846220, 14167044, 10496012, 5509121}, {0xFFFFFF, 0xA4A4A4, 4749022, 2838690, 1583959}}, new int[][]{{11568639, 4591532, 2293859}, {15269507, 9546765, 5267968}}};
        crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            GameEngine.crc_table[n] = c;
        }
    }
}

