/*
 * Decompiled with CFR 0.152.
 */
public class GameRole {
    public static final byte STATUS_STOP = 0;
    public static final byte STATUS_MOVE = 1;
    public static final byte STATUS_JUMP = 2;
    public static final byte STATUS_INJURE = 4;
    public static final byte STATUS_DOWN = 5;
    public static final byte STATUS_DEAD = 6;
    public static final byte STATUS_ATTACK1 = 7;
    public static final byte STATUS_SKILL1 = 8;
    public static final byte STATUS_SKILL2 = 9;
    public static final byte STATUS_SKILL2_2 = 26;
    public static final byte STATUS_SKILL3 = 10;
    public static final byte STATUS_SKILL3_2 = 28;
    public static final byte STATUS_DEFEND = 11;
    public static final byte STATUS_JUMP_ATT = 12;
    public static final byte STATUS_CHARGE = 13;
    public static final byte STATUS_BACK = 14;
    public static final byte STATUS_FALL = 15;
    public static final byte STATUS_ATTACK2 = 16;
    public static final byte STATUS_ATTACK3 = 17;
    public static final byte STATUS_VICTORY1 = 18;
    public static final byte STATUS_VICTORY2 = 19;
    public static final byte STATUS_LOST1 = 20;
    public static final byte STATUS_LOST2 = 21;
    public static final byte STATUS_ATTACK4 = 23;
    public static final byte STATUS_FREEZE = 24;
    public static final byte STATUS_BAOQI = 25;
    public static final byte STATUS_BEIZHUA = 27;
    public static final byte DIR_LEFT = 0;
    public static final byte DIR_RIGHT = 1;
    public static final byte AREA_ATT = 0;
    public static final byte AREA_JUMP_ATT = 1;
    public static final byte AREA_SKILL1 = 2;
    public static final byte AREA_SKILL2 = 3;
    public static final byte AREA_SKILL3 = 4;
    GameEngine engine;
    byte img;
    byte col;
    int type;
    int ID;
    int x;
    int y;
    int sx;
    int sy;
    int mx;
    int my;
    public int lx;
    public int rx;
    public int ty;
    public int by;
    public byte[] motion;
    public byte curStatus;
    public byte nextStatus;
    public int index;
    public int curIndex;
    public String name;
    public boolean isLeft;
    int w;
    int h;
    int attW;
    int attH;
    int defW;
    int defH;
    int attack;
    int defend;
    int speed;
    int HP;
    int MP;
    int HP_MAX;
    int MP_MAX;
    int respond;
    int curSpeedX;
    int curSpeedY;
    int lastSpeedX;
    int lastSpeedY;
    int ax = 0;
    int ay = 6;
    int disX;
    int disY;
    short[] attArea;
    short[] defendArea;
    int hitNum;
    int hitNum2;
    int hitNum_Index;
    int hitDelay;
    int power;
    int superTime;
    int baoqiTime;
    int vectorNum;
    int armor;
    boolean isPass;
    boolean isPassed;
    int lastAttMode;
    int layer = 200;
    public static final byte TYPE_MAX = 6;
    static byte[][][] data = new byte[6][][];
    static byte[][][] indent = new byte[6][][];
    static byte[][][] clipDat = new byte[6][][];
    static byte[][][] hurtArea = new byte[6][][];
    static byte[][][] shadow = new byte[6][][];
    static final byte COND_ATT = 0;
    static final byte COND_SKILL1 = 1;
    static final byte COND_SKILL2 = 2;
    static final byte COND_SKILL3 = 3;
    static short[][][] attCondition = new short[][][]{new short[][]{{24, -32, 30, 15}, {0, 0, 80, 50}, {0, 0, 200, 50}, {0, 0, 100, 50}}, new short[][]{{20, -29, 40, 11}, {0, 0, 80, 50}, {0, 0, 100, 50}, {0, 0, 100, 50}}, new short[][]{{28, -12, 32, 41}, {0, 0, 200, 50}, {0, 0, 150, 50}, {0, 0, 100, 60}}, new short[][]{{24, -10, 31, 40}, {0, 0, 200, 50}, {0, 0, 150, 50}, {-88, 0, 200, 100}}, new short[][]{{24, -18, 50, 9}, {0, 0, 200, 50}, {0, 0, 150, 50}, {0, 0, 100, 100}}, new short[][]{{24, -13, 50, 11}, {0, 0, 200, 50}, {0, 0, 150, 50}, {-88, 0, 200, 100}}};
    short[][] vision = new short[4][4];
    boolean showVision;
    boolean initVision;
    byte visionLx;
    byte visionRx;
    byte visionBy;
    boolean dustAdd;
    static short[][] imgDataMove = new short[][]{{0, 0, 51, 3}, {10, 4, 33, 3}, {9, 7, 36, 20}, {15, 29, 24, 15}};
    public int specialIndex;
    static byte[][] lightEffOff = new byte[][]{{-24, 69, 10, -15}, {-16, 76, 4, 9}, {-20, 72, -21, 9}, {-29, 82, 12, 3}};
    static short[][] imgDatLightEff = new short[][]{{0, 0, 83, 43}, {0, 43, 98, 61}, {0, 104, 90, 36}, {0, 140, 91, 63}};
    int lightEffIndex;
    int rotateIndex;
    boolean isJumpAtted;
    byte moveDelay;
    byte leftCount;
    byte rightCount;
    byte attCount;
    byte attDelay;
    static short[][] imgDatSkill = new short[][]{{0, 0, 24, 28}, {24, 0, 17, 25}, {41, 0, 24, 24}, {0, 28, 37, 38}, {37, 28, 45, 47}};
    static byte[][] skillOff = new byte[][]{{10, 11, 10, 11}, {21, 19, 26, 22}, {23, 23, 25, 25}, {26, 27, 28, 27}};
    int skillIndex;
    byte fireIndex;
    boolean showFire;
    byte[][] imgDatFire = new byte[][]{{0, 13, 26, 25}, {0, 38, 45, 40}, {45, 44, 39, 34}, {36, 0, 48, 38}};
    byte[][] fireOffset = new byte[][]{{24, 1, 40, -15}, {41, 42, 54, -12}, {49, 48, 69, -14}, {49, 30, 54, -14}, {34, 29, 54, -14}, {16, 23, 49, -15}};
    static byte[][] imgDatLine = new byte[][]{{0, 0, 44, 7}, {0, 8, 44, 13}, {0, 22, 44, 3}};
    boolean roleIsLeft;
    static final byte RATE_JUMPATT = 0;
    static final byte RATE_MOVE = 1;
    static final byte RATE_SKILL = 2;
    static final byte RATE_DEFEND = 3;
    static byte[][] attRate = new byte[][]{{20, 80, 20, 30}, {50, 50, 50, 50}, {80, 20, 80, 80}};
    public int waitTime = 0;

    public GameRole(GameEngine eg, int type, int ID) {
        this.engine = eg;
        this.type = type;
        this.ID = ID;
        if (clipDat[type] == null) {
            GameRole.clipDat[type] = this.engine.readClipData("r" + type + ".dat");
        }
        if (data[type] == null) {
            GameRole.data[type] = this.engine.readFrameData("f" + type + ".dat");
        }
        if (indent[type] == null) {
            GameRole.indent[type] = this.engine.readClipData("s" + type + ".dat");
        }
        if (hurtArea[type] == null) {
            GameRole.hurtArea[type] = this.engine.readClipData("h" + type + ".dat");
        }
        if (shadow[type] == null) {
            GameRole.shadow[type] = this.engine.readShadowData("sh" + type + ".dat");
        }
        switch (type) {
            case 0: {
                this.w = 37;
                this.h = 50;
                this.attack = 2;
                break;
            }
            case 1: {
                this.w = 30;
                this.h = 49;
                this.attack = 2;
                break;
            }
            case 2: {
                this.w = 31;
                this.h = 49;
                this.attack = 2;
                break;
            }
            case 3: {
                this.w = 23;
                this.h = 51;
                this.attack = 2;
                break;
            }
            case 4: {
                this.w = 24;
                this.h = 53;
                this.attack = 2;
            }
        }
        this.speed = 8;
        this.defend = 0;
        this.power = 3;
        this.HP_MAX = 200;
        this.MP_MAX = 100;
        this.superTime = 0;
        this.vectorNum = 0;
    }

    public void initRole() {
        switch (this.ID) {
            case 0: {
                this.x = GameMap.mapWidth / 2 - 120 - this.w;
                this.isLeft = false;
                break;
            }
            case 1: {
                this.x = GameMap.mapWidth / 2 + 120;
                this.isLeft = true;
            }
        }
        this.y = (short)(GameMap.SCREEN_HEIGHT - 30);
        this.nextStatus = this.curStatus = 0;
        this.HP = this.HP_MAX;
        this.armor = 10;
        this.lastAttMode = 0;
    }

    public void speedChange() {
        this.curSpeedX += this.ax;
        this.curSpeedY += this.ay;
    }

    public void getdistance() {
        this.disX = this.curSpeedX - this.ax / 2;
        this.disY = this.curSpeedY - this.ay / 2;
    }

    public void showVision(int VIndex) {
        this.showVision = true;
        this.initVision = true;
        this.visionLx = indent[this.type][VIndex][0];
        this.visionRx = indent[this.type][VIndex][1];
        this.visionBy = indent[this.type][VIndex][3];
        for (int i = 0; i < this.vision.length; ++i) {
            this.vision[i][2] = (short)VIndex;
        }
    }

    public void refreshVision(int VIndex) {
        this.vision[0][2] = (short)VIndex;
    }

    public void hideVision() {
        this.showVision = false;
    }

    public void moveVision() {
        int i;
        if (!this.showVision) {
            return;
        }
        if (this.initVision) {
            for (i = 0; i < this.vision.length; ++i) {
                this.vision[i][0] = (short)(this.x - (this.isLeft ? this.visionRx : this.visionLx));
                this.vision[i][1] = (short)(this.y + this.visionBy);
                this.vision[i][3] = (short)(!this.isLeft ? 1 : 0);
            }
            this.initVision = false;
        }
        for (i = this.vision.length - 1; i >= 0; --i) {
            if (i == 0) {
                this.vision[i][0] = (short)(this.x - (this.isLeft ? this.visionRx : this.visionLx));
                this.vision[i][1] = (short)(this.y + this.visionBy);
                this.vision[i][3] = (short)(!this.isLeft ? 1 : 0);
                continue;
            }
            this.vision[i][0] = this.vision[i - 1][0];
            this.vision[i][1] = this.vision[i - 1][1];
            this.vision[i][2] = this.vision[i - 1][2];
            this.vision[i][3] = this.vision[i - 1][3];
        }
    }

    public void drawVision() {
        if (!this.showVision) {
            return;
        }
        for (int i = this.vision.length - 1; i >= 0; --i) {
            this.drawFrame(this.vision[i][0], this.vision[i][1], this.vision[i][2], this.vision[i][3] == 0);
        }
    }

    public void move0() {
        switch (this.curStatus) {
            case 25: {
                this.motion = new byte[]{12, 12, 11, 11, 11, 11};
                this.curIndex = this.motion[this.index];
                if (this.index == 2) {
                    GameEngine.AddBlastEffectList(this.x + 10, this.y, 5, 0);
                    GameEngine.AddBlastEffectList(this.x + this.w - 10, this.y, 6, 1);
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                break;
            }
            case 27: {
                this.curIndex = 6;
                if (++this.index < 10) break;
                this.HP -= this.attack * 8;
                this.setStatus((byte)15);
                break;
            }
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 1: {
                this.motion = new byte[]{1, 2, 3, 4};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 2: {
                this.curIndex = this.curSpeedY >= 0 ? 15 : 15;
                break;
            }
            case 7: {
                this.motion = new byte[]{5, 18, 19};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)5;
                this.curSpeedX = 0;
                break;
            }
            case 16: {
                this.motion = new byte[]{20, 21, 22, 23};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 2: 
                    case 3: {
                        if (GameEngine.curState == 0) break;
                        int n = this.curSpeedX = this.isLeft ? -this.speed * 3 : this.speed * 3;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)7;
                this.curSpeedX = 0;
                break;
            }
            case 17: {
                this.motion = new byte[]{0, 24, 25, 26, 27, 28, 29, 30, 30, 30};
                this.curIndex = this.motion[this.index];
                if (this.index == 3) {
                    if (GameEngine.curState != 0) {
                        GameMap.shakeTime = (byte)20;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)2;
                this.curSpeedX = 0;
                break;
            }
            case 23: {
                break;
            }
            case 12: {
                this.motion = new byte[]{16, 17, 17};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)2);
                break;
            }
            case 13: {
                this.curIndex = 9;
                if (++this.index < 3) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.leftCount = 0;
                this.rightCount = 0;
                break;
            }
            case 14: {
                this.curIndex = 10;
                if (++this.index < 4) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.leftCount = 0;
                this.rightCount = 0;
                break;
            }
            case 8: {
                this.motion = new byte[]{31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 16 : 32), this.sy - 37, 7, 0);
                        break;
                    }
                    case 6: {
                        GameMap.shakeTime = (byte)20;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.curSpeedX = 0;
                this.setStatus((byte)0);
                break;
            }
            case 9: {
                this.motion = new byte[]{1, 9, 9, 9, 9, 9, 9, 9, 9};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 29 : 13), this.sy - 30, 7, 0);
                        break;
                    }
                    case 1: {
                        this.curSpeedX = this.isLeft ? -this.speed * 2 : this.speed * 2;
                        this.curSpeedY = 0;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.curSpeedX = 0;
                if (MyGameCanvas.gameStatus == 29) {
                    this.setStatus((byte)26);
                    break;
                }
                this.setStatus((byte)0);
                break;
            }
            case 26: {
                this.curSpeedX = 0;
                this.motion = new byte[]{49, 50, 51, 52, 53, 54};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 0: {
                        GameEngine.map.superTime = 5;
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 15 : 22), this.sy - 48, 7, 0);
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.engine.setStepYs();
                break;
            }
            case 10: {
                this.motion = new byte[]{11, 9, 9, 9, 9, 9, 9, 9, 9};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 41 : -4), this.sy - 30, 7, 0);
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 7 : 30), this.sy - 30, 7, 1);
                        break;
                    }
                    case 1: {
                        this.curSpeedX = this.isLeft ? -this.speed * 2 : this.speed * 2;
                        this.curSpeedY = 0;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                break;
            }
            case 28: {
                this.motion = new byte[]{20, 21, 22, 22, 23, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 10, 10, 10, 10};
                switch (this.index) {
                    case 0: {
                        this.curSpeedX = 0;
                        GameEngine.map.superTime = 5;
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 12 : 25), this.sy - 25, 7, 0);
                        break;
                    }
                    case 11: {
                        GameMap.shakeTime = (byte)20;
                        break;
                    }
                    case 21: {
                        this.curSpeedX = 2 * (this.isLeft ? this.speed : -this.speed);
                        this.curSpeedY = -12;
                    }
                }
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)9);
                this.engine.setStepYs();
                this.curSpeedX = 0;
                break;
            }
            case 11: {
                this.curIndex = 5;
                if (++this.index < 5) break;
                if (MyGameCanvas.isPressed(52) || MyGameCanvas.isPressed(-3)) {
                    this.setStatus((byte)1);
                    this.curSpeedX = -this.speed;
                    break;
                }
                if (MyGameCanvas.isPressed(54) || MyGameCanvas.isPressed(-4)) {
                    this.setStatus((byte)1);
                    this.curSpeedX = this.speed;
                    break;
                }
                this.setStatus((byte)0);
                break;
            }
            case 4: {
                this.curIndex = 6;
                if (++this.index < 7) break;
                this.setStatus((byte)0);
                break;
            }
            case 24: {
                this.curIndex = 6;
                this.HP -= 5;
                if (this.HP <= 0) {
                    this.HP = 0;
                    this.setStatus((byte)15);
                }
                GameEngine.AddBlastEffectList(this.x + this.w / 4 + GameRole.getRate(this.w / 2) - (this.roleIsLeft ? 0 : 36), this.y - GameRole.getRate(this.h / 4) - this.h / 4, 2, this.roleIsLeft ? 1 : 0);
                if (++this.index < 8) break;
                this.setStatus((byte)15);
                this.isPassed = true;
                break;
            }
            case 15: {
                this.curIndex = this.curSpeedY >= 0 ? 7 : 6;
                ++this.index;
                break;
            }
            case 5: {
                this.curIndex = 8;
                if (++this.index < 10) break;
                this.setStatus((byte)0);
                break;
            }
            case 6: {
                this.curIndex = 8;
                break;
            }
            case 18: {
                this.motion = new byte[]{12, 12, 13, 13, 13, 13};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)19);
                this.engine.setStepYs();
                break;
            }
            case 19: {
                this.curIndex = 13;
                break;
            }
            case 20: {
                this.motion = new byte[]{14, 14, 14, 14};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)21);
                break;
            }
            case 21: {
                this.curIndex = 14;
            }
        }
    }

    public void move1() {
        switch (this.curStatus) {
            case 25: {
                this.motion = new byte[]{13, 13, 11, 11, 11, 11};
                this.curIndex = this.motion[this.index];
                if (this.index == 2) {
                    GameEngine.AddBlastEffectList(this.x + 10, this.y, 5, 0);
                    GameEngine.AddBlastEffectList(this.x + this.w - 10, this.y, 6, 1);
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                break;
            }
            case 27: {
                this.curIndex = 6;
                if (++this.index < 10) break;
                this.HP -= this.attack * 8;
                this.setStatus((byte)15);
                break;
            }
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 1: {
                this.motion = new byte[]{1, 2, 3, 4};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 2: {
                this.curIndex = Math.abs(this.curSpeedY) < 5 ? 15 : 15;
                break;
            }
            case 7: {
                this.motion = new byte[]{18, 19, 20};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)5;
                break;
            }
            case 16: {
                this.motion = new byte[]{18, 21, 22, 23};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)7;
                break;
            }
            case 17: {
                this.motion = new byte[]{18, 21, 24, 25, 26, 27, 28, 29, 30, 31, 32, 1, 1, 1};
                this.curIndex = this.motion[this.index];
                if (this.index == 3) {
                    if (GameEngine.curState != 0) {
                        GameMap.shakeTime = (byte)20;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)5;
                break;
            }
            case 23: {
                break;
            }
            case 12: {
                this.motion = new byte[]{16, 17, 17};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)2);
                break;
            }
            case 13: {
                this.curIndex = 9;
                if (++this.index < 3) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.leftCount = 0;
                this.rightCount = 0;
                break;
            }
            case 14: {
                this.curIndex = 10;
                if (++this.index < 4) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.leftCount = 0;
                this.rightCount = 0;
                break;
            }
            case 8: {
                this.motion = new byte[]{34, 35, 36, 37, 38, 39, 40, 1};
                this.curIndex = this.motion[this.index];
                if (this.index == 5) {
                    GameMap.shakeTime = (byte)20;
                }
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 26 : 4), this.sy - 27, 7, 0);
                        break;
                    }
                    case 1: {
                        GameMap.shakeTime = (byte)20;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                break;
            }
            case 9: {
                this.motion = new byte[]{33, 18, 46, 47, 48, 49, 50, 51, 46, 47, 48, 49, 50, 51};
                this.curIndex = this.motion[this.index];
                if (this.index == 6) {
                    GameMap.shakeTime = (byte)20;
                }
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 10 : 20), this.sy - 33, 7, 0);
                        break;
                    }
                    case 3: {
                        int n = this.curSpeedX = this.isLeft ? -this.speed : this.speed;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.curSpeedX = 0;
                this.setStatus((byte)0);
                break;
            }
            case 10: {
                this.motion = new byte[]{11, 9, 9, 9, 9, 9, 9, 9, 9};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 34 : -4), this.sy - 30, 7, 0);
                        GameEngine.AddBlastEffectList(this.x + (this.isLeft ? 0 : 30), this.sy - 30, 7, 1);
                        break;
                    }
                    case 1: {
                        this.curSpeedX = this.isLeft ? -this.speed * 2 : this.speed * 2;
                        this.curSpeedY = 0;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                break;
            }
            case 28: {
                this.motion = new byte[]{34, 18, 46, 47, 48, 49, 50, 51, 46, 47, 48, 49, 50, 51, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 38, 39, 40};
                switch (this.index) {
                    case 0: {
                        this.curSpeedX = 0;
                        GameEngine.map.superTime = 5;
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 34 : 24), this.sy - 27, 7, 0);
                        break;
                    }
                    case 23: {
                        this.curSpeedX = 0;
                        GameEngine.map.superTime = 5;
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 90 : 8), this.sy - 27, 7, 0);
                        break;
                    }
                    case 2: 
                    case 16: 
                    case 24: {
                        GameMap.shakeTime = (byte)20;
                    }
                }
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.engine.setStepYs();
                break;
            }
            case 11: {
                this.curIndex = 5;
                if (++this.index < 5) break;
                if (MyGameCanvas.isPressed(52) || MyGameCanvas.isPressed(-3)) {
                    this.setStatus((byte)1);
                    this.curSpeedX = -this.speed;
                    break;
                }
                if (MyGameCanvas.isPressed(54) || MyGameCanvas.isPressed(-4)) {
                    this.setStatus((byte)1);
                    this.curSpeedX = this.speed;
                    break;
                }
                this.setStatus((byte)0);
                break;
            }
            case 4: {
                this.curIndex = 6;
                if (++this.index < 7) break;
                this.setStatus((byte)0);
                break;
            }
            case 24: {
                this.curIndex = 6;
                this.HP -= 5;
                if (this.HP <= 0) {
                    this.HP = 0;
                    this.setStatus((byte)15);
                }
                GameEngine.AddBlastEffectList(this.x + this.w / 4 + GameRole.getRate(this.w / 2) - (this.roleIsLeft ? 0 : 36), this.y - GameRole.getRate(this.h / 4) - this.h / 4, 2, this.roleIsLeft ? 1 : 0);
                if (++this.index < 8) break;
                this.setStatus((byte)15);
                this.isPassed = true;
                break;
            }
            case 15: {
                this.curIndex = this.curSpeedY >= 0 ? 7 : 6;
                ++this.index;
                break;
            }
            case 5: {
                this.curIndex = 8;
                if (++this.index < 10) break;
                this.setStatus((byte)0);
                break;
            }
            case 6: {
                this.curIndex = 8;
                break;
            }
            case 18: {
                this.motion = new byte[]{12, 12, 13, 13, 13, 13};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)19);
                this.engine.setStepYs();
                break;
            }
            case 19: {
                this.curIndex = 13;
                break;
            }
            case 20: {
                this.motion = new byte[]{33, 33, 14, 14, 14, 14};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)21);
                break;
            }
            case 21: {
                this.curIndex = 14;
            }
        }
    }

    public void move2() {
        switch (this.curStatus) {
            case 25: {
                this.motion = new byte[]{4, 4, 10, 10, 10, 10};
                this.curIndex = this.motion[this.index];
                if (this.index == 0) {
                    GameEngine.AddBlastEffectList(this.x - 10, this.y, 5, 0);
                    GameEngine.AddBlastEffectList(this.x + this.w + 10, this.y, 6, 1);
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                break;
            }
            case 27: {
                this.curIndex = 5;
                if (++this.index < 10) break;
                this.HP -= this.attack * 8;
                this.setStatus((byte)15);
                break;
            }
            case 24: {
                this.curIndex = 5;
                this.HP -= 5;
                if (this.HP <= 0) {
                    this.HP = 0;
                    this.setStatus((byte)15);
                }
                GameEngine.AddBlastEffectList(this.x + this.w / 4 + GameRole.getRate(this.w / 2) - (this.roleIsLeft ? 0 : 36), this.y - GameRole.getRate(this.h / 4) - this.h / 4, 2, this.roleIsLeft ? 1 : 0);
                if (++this.index < 8) break;
                this.setStatus((byte)15);
                this.isPassed = true;
                break;
            }
            case 0: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 1: {
                this.motion = new byte[]{1, 2, 3, 2};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 2: {
                this.curIndex = this.curSpeedY >= 0 ? 12 : 11;
                break;
            }
            case 7: {
                this.motion = new byte[]{15, 18, 19, 20, 18};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)5;
                break;
            }
            case 16: {
                this.motion = new byte[]{15, 21, 22, 23, 24};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)7;
                break;
            }
            case 17: {
                this.motion = new byte[]{15, 25, 26, 27, 28, 29, 30, 31, 32, 33};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)4;
                break;
            }
            case 23: {
                break;
            }
            case 12: {
                this.motion = new byte[]{13, 14, 14, 14};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)2);
                break;
            }
            case 13: {
                this.curIndex = 9;
                if (++this.index < 3) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.leftCount = 0;
                this.rightCount = 0;
                break;
            }
            case 14: {
                this.curIndex = 8;
                if (++this.index < 3) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.leftCount = 0;
                this.rightCount = 0;
                break;
            }
            case 8: {
                this.motion = new byte[]{15, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 46, 15};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 21 : 10), this.sy - 43, 7, 0);
                    }
                }
                if (++this.index < this.motion.length) break;
                this.curSpeedX = 0;
                this.setStatus((byte)0);
                break;
            }
            case 9: {
                this.motion = new byte[]{15, 34, 35, 36, 37, 38, 39, 40, 41, 34, 35, 36, 37, 38, 39, 40, 41, 42};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 21 : 10), this.sy - 43, 7, 0);
                    }
                }
                if (++this.index < this.motion.length) break;
                this.curSpeedX = 0;
                this.setStatus((byte)0);
                break;
            }
            case 10: {
                this.motion = new byte[]{10, 9, 9, 9, 9, 9, 9, 9, 9};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 33 : -2), this.sy - 33, 7, 0);
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 0 : 31), this.sy - 33, 7, 1);
                        break;
                    }
                    case 1: {
                        this.curSpeedX = this.isLeft ? -this.speed * 2 : this.speed * 2;
                        this.curSpeedY = 0;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                break;
            }
            case 28: {
                this.motion = new byte[]{15, 43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 46, 15, 21, 22, 23, 24, 16, 16, 16, 34, 35, 36, 37, 38, 39, 34, 35, 36, 37, 38, 39, 34, 35, 36, 37, 38, 39, 40, 41, 42};
                switch (this.index) {
                    case 0: 
                    case 21: {
                        this.curSpeedX = 0;
                        GameEngine.map.superTime = 5;
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 21 : 10), this.sy - 43, 7, 0);
                        break;
                    }
                    case 4: {
                        this.curSpeedX = this.isLeft ? -20 : 20;
                        GameMap.shakeTime = (byte)20;
                        break;
                    }
                    case 29: 
                    case 35: 
                    case 41: {
                        GameMap.shakeTime = (byte)20;
                        if (this.index != 30) break;
                        GameEngine.map.superTime = 5;
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 33 : -2), this.sy - 33, 7, 0);
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 0 : 31), this.sy - 33, 7, 1);
                    }
                }
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.engine.setStepYs();
                break;
            }
            case 11: {
                this.curIndex = 4;
                if (++this.index < 5) break;
                if (MyGameCanvas.isPressed(52) || MyGameCanvas.isPressed(-3)) {
                    this.setStatus((byte)1);
                    this.curSpeedX = -this.speed;
                    break;
                }
                if (MyGameCanvas.isPressed(54) || MyGameCanvas.isPressed(-4)) {
                    this.setStatus((byte)1);
                    this.curSpeedX = this.speed;
                    break;
                }
                this.setStatus((byte)0);
                break;
            }
            case 4: {
                this.curIndex = 5;
                if (++this.index < 5) break;
                this.setStatus((byte)0);
                break;
            }
            case 15: {
                this.curIndex = 6;
                ++this.index;
                break;
            }
            case 5: {
                this.curIndex = 7;
                if (++this.index < 10) break;
                this.setStatus((byte)0);
                break;
            }
            case 6: {
                this.curIndex = 7;
                break;
            }
            case 18: {
                this.motion = new byte[]{15, 15, 16, 16, 16, 16};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)19);
                this.engine.setStepYs();
                break;
            }
            case 19: {
                this.curIndex = 16;
                break;
            }
            case 20: {
                this.motion = new byte[]{15, 15, 17, 17, 17, 17};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)21);
                break;
            }
            case 21: {
                this.curIndex = 17;
            }
        }
    }

    public void move3() {
        switch (this.curStatus) {
            case 25: {
                this.motion = new byte[]{0, 5, 5, 5, 5, 5};
                this.curIndex = this.motion[this.index];
                if (this.index == 0) {
                    GameEngine.AddBlastEffectList(this.x - 10, this.y, 5, 0);
                    GameEngine.AddBlastEffectList(this.x + this.w + 10, this.y, 6, 1);
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                break;
            }
            case 27: {
                this.curIndex = 7;
                if (++this.index < 10) break;
                this.HP -= this.attack * 8;
                this.setStatus((byte)15);
                break;
            }
            case 24: {
                this.curIndex = 7;
                this.HP -= 5;
                if (this.HP <= 0) {
                    this.HP = 0;
                    this.setStatus((byte)15);
                }
                GameEngine.AddBlastEffectList(this.x + this.w / 4 + GameRole.getRate(this.w / 2) - (this.roleIsLeft ? 0 : 36), this.y - GameRole.getRate(this.h / 4) - this.h / 4, 2, this.roleIsLeft ? 1 : 0);
                if (++this.index < 8) break;
                this.setStatus((byte)15);
                this.isPassed = true;
                break;
            }
            case 0: {
                this.motion = new byte[]{0, 0, 46, 46};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 1: {
                this.motion = new byte[]{15, 16, 17, 18};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 2: {
                this.curIndex = this.curSpeedY >= 0 ? 10 : 11;
                break;
            }
            case 7: {
                this.motion = new byte[]{19, 20, 21, 21, 21, 21};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 1: {
                        this.drawFrame_Eff(this.sx + (this.isLeft ? 27 : 21), this.sy - 39, 38, this.isLeft);
                        break;
                    }
                    case 2: {
                        this.drawFrame_Eff(this.sx + (this.isLeft ? 6 : 42), this.sy - 30, 40, this.isLeft);
                        break;
                    }
                    case 3: {
                        this.drawFrame_Eff(this.sx + (this.isLeft ? -3 : 42), this.sy - 30, 39, this.isLeft);
                        break;
                    }
                    case 4: {
                        this.drawFrame_Eff(this.sx + (this.isLeft ? -3 : 42), this.sy - 30, 41, this.isLeft);
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)7;
                break;
            }
            case 16: {
                this.motion = new byte[]{22, 23, 21, 21, 21, 21};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 1: {
                        this.drawFrame_Eff(this.sx + (this.isLeft ? 25 : 26), this.sy - 36, 38, this.isLeft);
                        break;
                    }
                    case 2: {
                        this.drawFrame_Eff(this.sx + (this.isLeft ? 4 : 47), this.sy - 29, 40, this.isLeft);
                        break;
                    }
                    case 3: {
                        this.drawFrame_Eff(this.sx + (this.isLeft ? -8 : 47), this.sy - 29, 39, this.isLeft);
                        break;
                    }
                    case 4: {
                        this.drawFrame_Eff(this.sx + (this.isLeft ? -8 : 47), this.sy - 29, 41, this.isLeft);
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)9;
                break;
            }
            case 17: {
                this.motion = new byte[]{24, 25, 27, 26, 27, 26, 27, 26, 27, 26};
                this.curIndex = this.motion[this.index];
                if (this.index > 1) {
                    if (this.index % 2 == 0) {
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 0 : 16), this.sy - 0, 44, this.isLeft);
                    } else {
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 0 : 0), this.sy - 0, 45, this.isLeft);
                    }
                }
                if (this.index > 2) {
                    if (this.index % 2 == 0) {
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -16 : 32), this.sy + 38 - this.index * 20, 34, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 7 : 55), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 10 : 58), this.sy + 35 - this.index * 20, 43, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 13 : 61), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -7 : 41), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -10 : 38), this.sy + 35 - this.index * 20, 43, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -13 : 35), this.sy + 38 - this.index * 20, 42, this.isLeft);
                    } else {
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -16 : 16), this.sy + 38 - this.index * 20, 34, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 7 : 39), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 10 : 42), this.sy + 35 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 13 : 45), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -7 : 25), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -10 : 22), this.sy + 35 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -13 : 19), this.sy + 38 - this.index * 20, 42, this.isLeft);
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)7;
                break;
            }
            case 23: {
                this.motion = new byte[]{24, 25, 26, 27, 26, 27, 26, 27, 26, 27, 26, 27, 26, 27, 26, 27, 26, 27};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)4;
                break;
            }
            case 12: {
                this.motion = new byte[]{11, 12, 11};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)2);
                break;
            }
            case 13: {
                this.curIndex = 4;
                if (++this.index < 3) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.leftCount = 0;
                this.rightCount = 0;
                break;
            }
            case 14: {
                this.curIndex = 3;
                if (++this.index < 3) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.leftCount = 0;
                this.rightCount = 0;
                break;
            }
            case 8: {
                this.motion = new byte[]{24, 25, 27, 26, 27, 26, 27, 26, 27, 26, 27, 26, 27, 26};
                this.curIndex = this.motion[this.index];
                if (this.index == 2) {
                    GameMap.shakeTime = (byte)12;
                }
                if (this.index > 1) {
                    if (this.index % 2 == 0) {
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 0 : 16), this.sy - 0, 44, this.isLeft);
                    } else {
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 0 : 0), this.sy - 0, 45, this.isLeft);
                    }
                }
                if (this.index > 2) {
                    if (this.index % 2 == 0) {
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -16 : 32), this.sy + 38 - this.index * 20, 34, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 7 : 55), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 10 : 58), this.sy + 35 - this.index * 20, 43, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 13 : 61), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -7 : 41), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -10 : 38), this.sy + 35 - this.index * 20, 43, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -13 : 35), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -32 : 48), this.sy + 58 - this.index * 20, 34, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -9 : 71), this.sy + 58 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -6 : 74), this.sy + 55 - this.index * 20, 43, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -3 : 77), this.sy + 58 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -23 : 57), this.sy + 58 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -26 : 54), this.sy + 55 - this.index * 20, 43, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -29 : 51), this.sy + 58 - this.index * 20, 42, this.isLeft);
                    } else {
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -16 : 16), this.sy + 38 - this.index * 20, 34, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 7 : 39), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 10 : 42), this.sy + 35 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? 13 : 45), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -7 : 25), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -10 : 22), this.sy + 35 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -13 : 19), this.sy + 38 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -32 : 32), this.sy + 58 - this.index * 20, 34, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -9 : 55), this.sy + 58 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -6 : 58), this.sy + 55 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -3 : 61), this.sy + 58 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -23 : 41), this.sy + 58 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -26 : 38), this.sy + 55 - this.index * 20, 42, this.isLeft);
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -29 : 35), this.sy + 58 - this.index * 20, 42, this.isLeft);
                    }
                }
                if (++this.index < this.motion.length) break;
                this.curSpeedX = 0;
                this.setStatus((byte)0);
                break;
            }
            case 9: {
                this.motion = new byte[]{10, 4, 4, 23, 22, 20, 28, 29, 30, 31, 32, 33, 28, 29, 30, 31, 32, 33, 28, 29, 30, 31, 32, 33};
                this.curIndex = this.motion[this.index];
                if (this.index > 24) {
                    if (this.index % 2 == 0) {
                        for (int i = 0; i < 10; ++i) {
                            this.drawFrame_Eff2(this.sx + (this.isLeft ? -26 : 46), this.sy + 7 - i * 27, 36, this.isLeft);
                        }
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -36 : 36), this.sy - 0, 44, this.isLeft);
                    } else {
                        for (int i = 0; i < 10; ++i) {
                            this.drawFrame_Eff2(this.sx + (this.isLeft ? -26 : 46), this.sy + 7 - i * 27, 37, this.isLeft);
                        }
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -36 : 36), this.sy - 0, 45, this.isLeft);
                    }
                }
                switch (this.index) {
                    case 0: {
                        this.curSpeedX = this.isLeft ? -this.speed * 2 : this.speed * 2;
                        break;
                    }
                    case 3: {
                        this.curSpeedX = this.isLeft ? -this.speed * 1 : this.speed * 1;
                        break;
                    }
                    case 11: {
                        this.curSpeedX = 0;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                break;
            }
            case 10: {
                this.motion = new byte[]{5, 4, 4, 4, 4, 4, 4, 4, 4};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 43 : -6), this.sy - 36, 7, 0);
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 15 : 22), this.sy - 33, 7, 1);
                        break;
                    }
                    case 1: {
                        this.curSpeedX = this.isLeft ? -this.speed * 2 : this.speed * 2;
                        this.curSpeedY = 0;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                break;
            }
            case 28: {
                this.motion = new byte[]{10, 23, 22, 20, 28, 29, 30, 31, 32, 33, 28, 29, 30, 31, 32, 33, 28, 29, 30, 31, 32, 33, 13, 14, 13, 14, 13, 14, 13, 14, 13, 14, 13, 14, 13, 14, 13, 14, 13, 14, 13, 14};
                this.curIndex = this.motion[this.index];
                byte[][] imgData = new byte[][]{{0, 27, 17, 15}, {39, 23, 20, 20}, {17, 23, 22, 22}, {0, 1, 24, 22}, {29, 0, 24, 23}};
                if (this.index > 22) {
                    Tools.addObject(0, this.sx + (this.isLeft ? -36 : 36), this.sy - 36 - (this.index - 23) * 10, imgData[(this.index - 23) % 5], 3, (byte)0, 201);
                    Tools.addObject(0, this.sx + (this.isLeft ? -16 : 56), this.sy - 72 - (this.index - 23) * 10, imgData[(this.index - 23) % 5], 3, (byte)0, 201);
                    Tools.addObject(0, this.sx + (this.isLeft ? 0 : 72), this.sy - 64 - (this.index - 23) * 10, imgData[(this.index - 23) % 5], 3, (byte)0, 201);
                    Tools.addObject(0, this.sx + (this.isLeft ? -46 : 46), this.sy - 36 - (this.index - 23) * 10 - 100, imgData[(this.index - 23) % 5], 3, (byte)0, 201);
                    Tools.addObject(0, this.sx + (this.isLeft ? -36 : 56), this.sy - 72 - (this.index - 23) * 10 - 100, imgData[(this.index - 23) % 5], 3, (byte)0, 201);
                    Tools.addObject(0, this.sx + (this.isLeft ? -26 : 66), this.sy - 64 - (this.index - 23) * 10 - 100, imgData[(this.index - 23) % 5], 3, (byte)0, 201);
                    if (this.index % 2 == 0) {
                        for (int i = 0; i < 10; ++i) {
                            this.drawFrame_Eff2(this.sx + (this.isLeft ? -36 : 46), this.sy + 7 - i * 27, 36, this.isLeft);
                        }
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -46 : 36), this.sy - 0, 44, this.isLeft);
                    } else {
                        for (int i = 0; i < 10; ++i) {
                            this.drawFrame_Eff2(this.sx + (this.isLeft ? -36 : 46), this.sy + 7 - i * 27, 37, this.isLeft);
                        }
                        this.drawFrame_Eff2(this.sx + (this.isLeft ? -46 : 36), this.sy - 0, 45, this.isLeft);
                    }
                }
                switch (this.index) {
                    case 0: {
                        GameEngine.map.superTime = 5;
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 3 : 41), this.sy - 49, 7, 0);
                        break;
                    }
                    case 1: {
                        this.curSpeedX = this.isLeft ? -this.speed * 1 : this.speed * 1;
                        break;
                    }
                    case 9: {
                        this.curSpeedX = 0;
                        break;
                    }
                    case 22: {
                        GameMap.shakeTime = (byte)8;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.engine.setStepYs();
                break;
            }
            case 11: {
                this.curIndex = 2;
                if (++this.index < 5) break;
                if (MyGameCanvas.isPressed(52) || MyGameCanvas.isPressed(-3)) {
                    this.setStatus((byte)1);
                    this.curSpeedX = -this.speed;
                    break;
                }
                if (MyGameCanvas.isPressed(54) || MyGameCanvas.isPressed(-4)) {
                    this.setStatus((byte)1);
                    this.curSpeedX = this.speed;
                    break;
                }
                this.setStatus((byte)0);
                break;
            }
            case 4: {
                this.curIndex = 7;
                if (++this.index < 5) break;
                this.setStatus((byte)0);
                break;
            }
            case 15: {
                this.curIndex = 8;
                ++this.index;
                break;
            }
            case 5: {
                this.curIndex = 9;
                if (++this.index < 10) break;
                this.setStatus((byte)0);
                break;
            }
            case 6: {
                this.curIndex = 9;
                break;
            }
            case 18: {
                this.motion = new byte[]{13, 14};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)19);
                this.engine.setStepYs();
                break;
            }
            case 19: {
                this.curIndex = 14;
                break;
            }
            case 20: {
                this.motion = new byte[]{5, 6};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)19);
                break;
            }
            case 21: {
                this.curIndex = 6;
            }
        }
    }

    public void move4() {
        switch (this.curStatus) {
            case 25: {
                this.motion = new byte[]{0, 7, 7, 7, 7, 7};
                this.curIndex = this.motion[this.index];
                if (this.index == 0) {
                    GameEngine.AddBlastEffectList(this.x - 10, this.y, 5, 0);
                    GameEngine.AddBlastEffectList(this.x + this.w + 10, this.y, 6, 1);
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                break;
            }
            case 27: {
                this.curIndex = 4;
                if (++this.index < 10) break;
                this.HP -= this.attack * 8;
                this.setStatus((byte)15);
                break;
            }
            case 24: {
                this.curIndex = 4;
                this.HP -= 5;
                if (this.HP <= 0) {
                    this.HP = 0;
                    this.setStatus((byte)15);
                }
                GameEngine.AddBlastEffectList(this.x + this.w / 4 + GameRole.getRate(this.w / 2) - (this.roleIsLeft ? 0 : 36), this.y - GameRole.getRate(this.h / 4) - this.h / 4, 2, this.roleIsLeft ? 1 : 0);
                if (++this.index < 8) break;
                this.setStatus((byte)15);
                this.isPassed = true;
                break;
            }
            case 0: {
                this.motion = new byte[]{0, 43, 0, 43};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 1: {
                this.motion = new byte[]{0, 1, 2, 3};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 2: {
                this.curIndex = this.curSpeedY >= 0 ? 12 : 13;
                break;
            }
            case 7: {
                this.motion = new byte[]{22, 23, 24};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)6;
                break;
            }
            case 16: {
                this.motion = new byte[]{25, 26, 27, 28, 29};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)7;
                break;
            }
            case 17: {
                this.motion = new byte[]{11, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.attDelay = (byte)4;
                break;
            }
            case 23: {
                this.motion = new byte[]{17, 25, 26, 27, 28, 29, 25};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 2: {
                        this.curSpeedX = this.isLeft ? -this.speed * 2 : this.speed * 2;
                        break;
                    }
                    case 5: {
                        this.curSpeedX = 0;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.curSpeedX = 0;
                this.setStatus((byte)0);
                this.attDelay = (byte)4;
                break;
            }
            case 12: {
                this.motion = new byte[]{14, 15, 14};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)2);
                break;
            }
            case 13: {
                this.curIndex = 9;
                if (++this.index < 3) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.leftCount = 0;
                this.rightCount = 0;
                break;
            }
            case 14: {
                this.curIndex = 10;
                if (++this.index < 3) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                this.leftCount = 0;
                this.rightCount = 0;
                break;
            }
            case 8: {
                this.motion = new byte[]{30, 31, 38, 31, 38, 31, 38, 31, 38, 31, 38, 31, 38};
                this.curIndex = this.motion[this.index];
                byte[][] kl_Data = new byte[][]{{0, 0, 13, 19}, {0, 20, 13, 19}, {13, 0, 8, 8}, {15, 9, 3, 4}, {21, 0, 36, 29}, {57, 0, 26, 20}, {78, 20, 22, 16}, {86, 0, 14, 14}, {35, 30, 13, 15}, {49, 30, 8, 12}, {58, 20, 17, 17}};
                switch (this.index) {
                    case 1: {
                        GameMap.shakeTime = (byte)15;
                        Tools.addObject(34, this.sx + (this.isLeft ? -10 : 51), this.sy - 32, kl_Data[4], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -10 : 51), this.sy - 32, kl_Data[5], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        break;
                    }
                    case 2: {
                        Tools.addObject(34, this.sx + (this.isLeft ? -24 : 63), this.sy - 32, kl_Data[4], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -24 : 63), this.sy - 32, kl_Data[5], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -32 : 71), this.sy - 45, kl_Data[0], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -32 : 71), this.sy - 45, kl_Data[1], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -32 : 71), this.sy - 45, kl_Data[0], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -32 : 71), this.sy - 45, kl_Data[1], this.isLeft ? 24 : 20, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        break;
                    }
                    case 3: {
                        Tools.addObject(34, this.sx + (this.isLeft ? -26 : 67), this.sy - 45 - 4, kl_Data[0], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -26 : 67), this.sy - 45 + 4, kl_Data[1], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -34 : 75), this.sy - 45 - 4, kl_Data[0], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -34 : 75), this.sy - 45 + 4, kl_Data[1], this.isLeft ? 24 : 20, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -30 : 71), this.sy - 45, kl_Data[8], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -30 : 71), this.sy - 45 + 15, kl_Data[9], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -10 : 51), this.sy - 25, kl_Data[8], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -10 : 51), this.sy - 25 + 15, kl_Data[9], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        break;
                    }
                    case 4: {
                        Tools.addObject(34, this.sx + (this.isLeft ? -20 : 59), this.sy - 45 - 7, kl_Data[6], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -59 : 98), this.sy - 45 + 23, kl_Data[7], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -44 : 83), this.sy - 45 - 7, kl_Data[6], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -24 : 63), this.sy - 45 - 8, kl_Data[0], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -24 : 63), this.sy - 45 + 8, kl_Data[1], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -40 : 79), this.sy - 45 - 8, kl_Data[0], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -40 : 79), this.sy - 45 + 8, kl_Data[1], this.isLeft ? 24 : 20, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -32 : 71), this.sy - 45, kl_Data[8], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -32 : 71), this.sy - 45 + 15, kl_Data[9], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -55 : 94), this.sy - 40, kl_Data[0], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -55 : 94), this.sy - 40, kl_Data[1], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -55 : 94), this.sy - 40, kl_Data[0], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -55 : 94), this.sy - 40, kl_Data[1], this.isLeft ? 24 : 20, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        break;
                    }
                    case 5: {
                        Tools.addObject(34, this.sx + (this.isLeft ? -10 : 51), this.sy - 45 - 20, kl_Data[0], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -10 : 51), this.sy - 45 + 20, kl_Data[1], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -50 : 91), this.sy - 45 - 20, kl_Data[0], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -50 : 91), this.sy - 45 + 20, kl_Data[1], this.isLeft ? 24 : 20, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -30 : 71), this.sy - 45, kl_Data[10], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -41 : 82), this.sy - 40 - 7, kl_Data[6], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -80 : 121), this.sy - 40 + 23, kl_Data[7], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -65 : 106), this.sy - 40 - 7, kl_Data[6], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -45 : 86), this.sy - 40 - 8, kl_Data[0], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -45 : 86), this.sy - 40 + 8, kl_Data[1], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -61 : 102), this.sy - 40 - 8, kl_Data[0], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -61 : 102), this.sy - 40 + 8, kl_Data[1], this.isLeft ? 24 : 20, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -53 : 94), this.sy - 40, kl_Data[8], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -53 : 94), this.sy - 40 + 15, kl_Data[9], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -30 : 71), this.sy - 45, kl_Data[8], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -30 : 71), this.sy - 45 + 15, kl_Data[9], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        break;
                    }
                    case 6: {
                        Tools.addObject(34, this.sx + (this.isLeft ? -35 : 74), this.sy - 40 - 20, kl_Data[0], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -35 : 74), this.sy - 40 + 20, kl_Data[1], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -75 : 114), this.sy - 40 - 20, kl_Data[0], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -75 : 114), this.sy - 40 + 20, kl_Data[1], this.isLeft ? 24 : 20, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -55 : 94), this.sy - 40, kl_Data[10], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -12 : 51), this.sy - 38, kl_Data[0], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -12 : 51), this.sy - 38, kl_Data[1], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -12 : 51), this.sy - 38, kl_Data[0], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -12 : 51), this.sy - 38, kl_Data[1], this.isLeft ? 24 : 20, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        break;
                    }
                    case 7: {
                        Tools.addObject(34, this.sx + (this.isLeft ? 0 : 39), this.sy - 38 - 7, kl_Data[6], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -39 : 78), this.sy - 38 + 23, kl_Data[7], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -24 : 63), this.sy - 38 - 7, kl_Data[6], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -4 : 43), this.sy - 38 - 8, kl_Data[0], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -4 : 43), this.sy - 38 + 8, kl_Data[1], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -20 : 59), this.sy - 38 - 8, kl_Data[0], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -20 : 59), this.sy - 38 + 8, kl_Data[1], this.isLeft ? 24 : 20, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -10 : 51), this.sy - 38, kl_Data[8], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -10 : 51), this.sy - 38 + 15, kl_Data[9], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -30 : 71), this.sy - 45, kl_Data[8], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        Tools.addObject(34, this.sx + (this.isLeft ? -30 : 71), this.sy - 45 + 15, kl_Data[9], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                        break;
                    }
                    case 8: {
                        Tools.addObject(34, this.sx + (this.isLeft ? 8 : 31), this.sy - 38 - 20, kl_Data[0], this.isLeft ? 36 : 40, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? 8 : 31), this.sy - 38 + 20, kl_Data[1], this.isLeft ? 20 : 24, this.isLeft ? (byte)1 : 0, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -32 : 71), this.sy - 38 - 20, kl_Data[0], this.isLeft ? 40 : 36, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -32 : 71), this.sy - 38 + 20, kl_Data[1], this.isLeft ? 24 : 20, this.isLeft ? (byte)0 : 1, this.layer + 1);
                        Tools.addObject(34, this.sx + (this.isLeft ? -12 : 51), this.sy - 38, kl_Data[10], 3, this.isLeft ? (byte)1 : 0, this.layer + 2);
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                break;
            }
            case 9: {
                this.motion = new byte[]{16, 17, 18, 19, 20, 21, 17, 18, 19, 20, 21, 17, 18, 19, 20, 21, 17, 18, 19, 20, 21, 16, 16, 16, 16};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 1: {
                        this.curSpeedX = this.isLeft ? -this.speed * 2 : this.speed * 2;
                        break;
                    }
                    case 20: {
                        this.curSpeedX = 0;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                break;
            }
            case 10: {
                this.motion = new byte[]{7, 9, 9, 9, 9, 9, 9, 9, 9};
                this.curIndex = this.motion[this.index];
                switch (this.index) {
                    case 0: {
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 28 : -4), this.sy - 36, 7, 0);
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? -8 : 32), this.sy - 38, 7, 1);
                        break;
                    }
                    case 1: {
                        this.curSpeedX = this.isLeft ? -this.speed * 2 : this.speed * 2;
                        this.curSpeedY = 0;
                    }
                }
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)0);
                this.curSpeedX = 0;
                break;
            }
            case 28: {
                this.motion = new byte[]{22, 23, 24, 25, 26, 27, 28, 29, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};
                switch (this.index) {
                    case 0: {
                        this.curSpeedX = 0;
                        GameEngine.map.superTime = 5;
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 15 : 32), this.sy - 53, 7, 0);
                        break;
                    }
                    case 2: {
                        this.curSpeedX = this.isLeft ? -20 : 20;
                        break;
                    }
                    case 14: {
                        this.curSpeedX = 0;
                        break;
                    }
                    case 15: {
                        GameMap.shakeTime = (byte)10;
                        GameEngine.map.superTime = 5;
                        GameEngine.AddBlastEffectList(this.sx + (this.isLeft ? 29 : 10), this.sy - 50, 7, 0);
                        break;
                    }
                }
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)9);
                this.engine.setStepYs();
                break;
            }
            case 11: {
                this.curIndex = 11;
                if (++this.index < 5) break;
                if (MyGameCanvas.isPressed(52) || MyGameCanvas.isPressed(-3)) {
                    this.setStatus((byte)1);
                    this.curSpeedX = -this.speed;
                    break;
                }
                if (MyGameCanvas.isPressed(54) || MyGameCanvas.isPressed(-4)) {
                    this.setStatus((byte)1);
                    this.curSpeedX = this.speed;
                    break;
                }
                this.setStatus((byte)0);
                break;
            }
            case 4: {
                this.curIndex = 4;
                if (++this.index < 5) break;
                this.setStatus((byte)0);
                break;
            }
            case 15: {
                this.curIndex = 5;
                ++this.index;
                break;
            }
            case 5: {
                this.curIndex = 6;
                if (++this.index < 10) break;
                this.setStatus((byte)0);
                break;
            }
            case 6: {
                this.curIndex = 6;
                break;
            }
            case 18: {
                this.motion = new byte[]{41, 42, 41, 42};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)19);
                this.engine.setStepYs();
                break;
            }
            case 19: {
                this.curIndex = 41;
                break;
            }
            case 20: {
                this.curIndex = 7;
                if (++this.index < 2) break;
                this.setStatus((byte)21);
                break;
            }
            case 21: {
                this.curIndex = 8;
            }
        }
    }

    public void roleMove(int mx, int my) {
        GameRole emy = GameEngine.roles[this.ID == 0 ? 1 : 0];
        this.getSize(this.curIndex);
        this.y += my;
        if (this.y >= GameMap.SCREEN_HEIGHT - 30) {
            this.y = GameMap.SCREEN_HEIGHT - 30;
            this.toStopStatus();
        } else if (this.curStatus == 4) {
            this.setStatus((byte)15);
        }
        if (MyGameCanvas.gameStatus != 29) {
            this.x += mx;
            if (!this.isPass && !emy.isPass) {
                if (Tools.hit(this.x, this.y, this.w, this.h, emy.x, emy.y, emy.w, emy.h)) {
                    boolean temp = this.x + this.w / 2 < emy.x + emy.w / 2;
                    emy.push((temp ? 1 : -1) * (emy.w + this.w - (temp ? emy.x + emy.w - this.x : this.x + this.w - emy.x)) / 2);
                    this.x = temp ? emy.x - this.w : emy.x + emy.w;
                }
                this.x = (short)Math.max(GameMap.setOffX, this.x);
                this.x = (short)Math.min(this.x, GameMap.setOffX + GameMap.SCREEN_WIDTH - this.w);
            }
        } else {
            this.x += mx;
            if (this.engine.curStep == 1) {
                this.x = (short)Math.max(GameMap.setOffX + 40, this.x);
                this.x = (short)Math.min(this.x, GameMap.setOffX + GameMap.SCREEN_WIDTH - this.w - 40);
            }
        }
        this.attArea = this.getAttArea(this.type, this.curIndex);
        this.defendArea = this.getDefendArea(this.type, this.curIndex);
    }

    public void push(int mx) {
        this.x += mx;
        this.x = (short)Math.max(GameMap.setOffX, this.x);
        this.x = (short)Math.min(this.x, GameMap.setOffX + GameMap.SCREEN_WIDTH - this.w);
    }

    private void toStopStatus() {
        if (this.curStatus == 2 || this.curStatus == 12) {
            this.setStatus((byte)0);
            this.curSpeedX = 0;
            this.curSpeedY = 0;
            GameEngine.AddBlastEffectList(this.x + this.w / 2 - 22, this.y, 1, 0);
        } else if (this.curStatus == 15) {
            this.setStatus((byte)5);
            this.curSpeedX /= 2;
            this.curSpeedY = -10;
            GameEngine.AddBlastEffectList(this.x + this.w / 2 - 22, this.y, 1, 0);
            this.dustAdd = false;
        } else if (this.curStatus == 5) {
            this.curSpeedX = 0;
            this.curSpeedY = 0;
            this.hitNum = 0;
            if (!this.dustAdd) {
                this.dustAdd = true;
                GameEngine.AddBlastEffectList(this.x + this.w / 2 - 22, this.y, 1, 0);
                if (this.HP <= 0) {
                    this.setStatus((byte)6);
                }
            }
        }
    }

    public void dealKey() {
        if (!(this.curStatus != 0 && this.curStatus != 1 || this.nextStatus != 0 && this.nextStatus != 1 || MyGameCanvas.isPressed(56))) {
            if (MyGameCanvas.isPressed(53) || MyGameCanvas.isPressed(-5)) {
                this.attack();
            } else if (MyGameCanvas.isPressed(52) || MyGameCanvas.isPressed(-3)) {
                if (this.leftCount != 2) {
                    this.setStatus((byte)1);
                    this.curSpeedX = -this.speed;
                }
            } else if ((MyGameCanvas.isPressed(54) || MyGameCanvas.isPressed(-4)) && this.rightCount != 2) {
                this.setStatus((byte)1);
                this.curSpeedX = this.speed;
            }
        }
    }

    public void run() {
        byte[] skillIndex;
        if (this.superTime > 0) {
            --this.superTime;
        }
        if (this.hitDelay > 0) {
            --this.hitDelay;
            if (this.hitDelay == 0) {
                this.hitNum = 0;
            }
        }
        if (this.attDelay > 0) {
            this.attDelay = (byte)(this.attDelay - 1);
            if (this.attDelay == 0) {
                this.attCount = 0;
            }
        }
        if (this.moveDelay > 0) {
            this.moveDelay = (byte)(this.moveDelay - 1);
            if (this.moveDelay == 0) {
                this.leftCount = 0;
                this.rightCount = 0;
            }
        }
        if (this.curStatus != this.nextStatus) {
            this.curStatus = this.nextStatus;
            this.index = 0;
            if (this.curStatus == 15) {
                this.curSpeedY = -16;
                if (this.isPassed) {
                    this.curSpeedX = (this.isLeft ? this.speed : -this.speed) / 2;
                    this.isPassed = false;
                } else {
                    this.curSpeedX = (this.roleIsLeft ? -this.speed : this.speed) / 2;
                }
            }
        }
        this.ay = this.curStatus == 27 ? 0 : 6;
        this.speedChange();
        this.getdistance();
        switch (this.type) {
            case 0: {
                this.move0();
                break;
            }
            case 1: {
                this.move1();
                break;
            }
            case 2: {
                this.move2();
                break;
            }
            case 3: {
                this.move3();
                break;
            }
            case 4: {
                this.move4();
            }
        }
        this.roleMove(this.disX, this.disY);
        this.sx = this.x - (this.isLeft ? this.rx : this.lx);
        this.sy = this.y + this.by;
        this.moveVision();
        if ((this.curStatus == 8 || this.curStatus == 9 || this.curStatus == 10) && this.index == (skillIndex = new byte[]{1, 1, 1, 1, 1})[this.type]) {
            this.initSkill();
        }
    }

    public void drawMoveFrame(int x, int y, int index, int lev) {
        switch (index) {
            case 0: {
                Tools.addObject(39, x + (this.isLeft ? -19 : 4), y - 34, imgDataMove[0], 36, this.isLeft ? (byte)1 : 0, lev);
                Tools.addObject(39, x + (this.isLeft ? -5 : 8), y - 14, imgDataMove[1], 36, this.isLeft ? (byte)1 : 0, lev);
                Tools.addObject(39, x, y, imgDataMove[2], 36, this.isLeft ? (byte)1 : 0, lev);
                break;
            }
            case 1: {
                Tools.addObject(39, x, y, imgDataMove[3], 36, this.isLeft ? (byte)1 : 0, lev);
                break;
            }
            case 2: {
                Tools.addObject(39, x, y, imgDataMove[2], 36, !this.isLeft ? (byte)1 : 0, lev);
                break;
            }
            case 3: {
                Tools.addObject(39, x, y, imgDataMove[3], 36, !this.isLeft ? (byte)1 : 0, lev);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint() {
        block46: {
            byte shw = shadow[this.type][this.curIndex][1];
            int shx = this.isLeft ? this.x + this.w + shadow[this.type][this.curIndex][0] - shw : this.x - shadow[this.type][this.curIndex][0];
            GameRole.drawShadow(shx + shw / 2, GameMap.setOffY + GameMap.SCREEN_HEIGHT - 30 - 2, shw + 4, 10, 200);
            if (this.type == 4 && this.curIndex == 43) {
                Tools.addObject(50, this.sx, this.sy, 36, this.isLeft ? (byte)1 : 0, this.layer);
            } else {
                this.drawFrame(this.sx, this.sy, this.curIndex, this.isLeft);
            }
            block0 : switch (this.type) {
                case 0: {
                    switch (this.curIndex) {
                        case 9: {
                            if (this.index % 2 == 0) {
                                this.drawMoveFrame(this.sx + (this.isLeft ? 49 : -18), this.y, 0, 1000);
                                return;
                            }
                            this.drawMoveFrame(this.sx + (this.isLeft ? 55 : -12), this.y, 1, 1000);
                            return;
                        }
                        case 10: {
                            if (this.curStatus != 14) break;
                            if (this.index % 2 == 0) {
                                this.drawMoveFrame(this.sx + (this.isLeft ? -18 : 23), this.y, 2, 1000);
                                return;
                            }
                            this.drawMoveFrame(this.sx + (this.isLeft ? -12 : 29), this.y, 3, 1000);
                        }
                    }
                    return;
                }
                case 1: {
                    switch (this.curIndex) {
                        case 9: {
                            if (this.index % 2 == 0) {
                                this.drawMoveFrame(this.sx + (this.isLeft ? 49 : -18), this.y, 0, 1000);
                                return;
                            }
                            this.drawMoveFrame(this.sx + (this.isLeft ? 55 : -12), this.y, 1, 1000);
                            return;
                        }
                        case 10: {
                            if (this.curStatus != 14) break;
                            if (this.index % 2 == 0) {
                                this.drawMoveFrame(this.sx + (this.isLeft ? -18 : 23), this.y, 2, 1000);
                                return;
                            }
                            this.drawMoveFrame(this.sx + (this.isLeft ? -12 : 29), this.y, 3, 1000);
                        }
                    }
                    return;
                }
                case 2: {
                    switch (this.curIndex) {
                        case 9: {
                            if (this.index % 2 == 0) {
                                this.drawMoveFrame(this.sx + (this.isLeft ? 49 : -18), this.y, 0, 1000);
                                return;
                            }
                            this.drawMoveFrame(this.sx + (this.isLeft ? 55 : -12), this.y, 1, 1000);
                            return;
                        }
                        case 8: {
                            if (this.curStatus != 14) break;
                            if (this.index % 2 == 0) {
                                this.drawMoveFrame(this.sx + (this.isLeft ? -18 : 23), this.y, 2, 1000);
                                return;
                            }
                            this.drawMoveFrame(this.sx + (this.isLeft ? -12 : 29), this.y, 3, 1000);
                        }
                    }
                    return;
                }
                case 3: {
                    switch (this.curIndex) {
                        case 4: {
                            if (this.index % 2 == 0) {
                                this.drawMoveFrame(this.sx + (this.isLeft ? 49 : -18), this.y, 0, 1000);
                                return;
                            }
                            this.drawMoveFrame(this.sx + (this.isLeft ? 55 : -12), this.y, 1, 1000);
                            return;
                        }
                        case 3: {
                            if (this.curStatus != 14) break;
                            if (this.index % 2 == 0) {
                                this.drawMoveFrame(this.sx + (this.isLeft ? -18 : 23), this.y, 2, 1000);
                                return;
                            }
                            this.drawMoveFrame(this.sx + (this.isLeft ? -12 : 29), this.y, 3, 1000);
                            return;
                        }
                        case 10: {
                            if (this.curStatus != 9) break;
                            this.drawSkill(this.sx + (this.isLeft ? 3 : 41), this.sy - 49, 201);
                            return;
                        }
                        case 24: {
                            if (this.curStatus != 8) break;
                            this.drawSkill(this.sx + (this.isLeft ? 3 : 29), this.sy - 68, 201);
                        }
                    }
                    return;
                }
                case 4: {
                    switch (this.curIndex) {
                        case 9: {
                            if (this.index % 2 == 0) {
                                this.drawMoveFrame(this.sx + (this.isLeft ? 49 : -18), this.y, 0, 1000);
                                break block0;
                            }
                            this.drawMoveFrame(this.sx + (this.isLeft ? 55 : -12), this.y, 1, 1000);
                            break block0;
                        }
                        case 10: {
                            if (this.curStatus != 14) return;
                            if (this.index % 2 == 0) {
                                this.drawMoveFrame(this.sx + (this.isLeft ? -18 : 23), this.y, 2, 1000);
                                break block0;
                            }
                            this.drawMoveFrame(this.sx + (this.isLeft ? -12 : 29), this.y, 3, 1000);
                            break block46;
                        }
                        case 30: {
                            if (this.curStatus != 8) return;
                            this.drawSkill(this.sx + (this.isLeft ? 32 : 0), this.sy - 49, 201);
                            break block46;
                        }
                        case 16: {
                            if (this.curStatus != 9) return;
                            this.drawSkill(this.sx + (this.isLeft ? 46 : 3), this.sy - 60, 201);
                            this.drawSkill(this.sx + (this.isLeft ? 4 : 45), this.sy - 47, 201);
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void ctrl(int key) {
        switch (this.curStatus) {
            case 0: 
            case 1: {
                switch (key) {
                    case 35: {
                        this.setStatus((byte)17);
                        break;
                    }
                    case -3: 
                    case 52: {
                        this.leftCount = (byte)(this.leftCount + 1);
                        if (this.leftCount == 1) {
                            this.moveDelay = (byte)5;
                        }
                        this.leftCount = (byte)Math.min(this.leftCount, 2);
                        if (this.leftCount != 2) break;
                        this.setStatus(this.isLeft ? (byte)13 : 14);
                        this.curSpeedX = -this.speed * 2;
                        break;
                    }
                    case -4: 
                    case 54: {
                        this.rightCount = (byte)(this.rightCount + 1);
                        if (this.rightCount == 1) {
                            this.moveDelay = (byte)5;
                        }
                        this.rightCount = (byte)Math.min(this.rightCount, 2);
                        if (this.rightCount != 2) break;
                        this.setStatus(!this.isLeft ? (byte)13 : 14);
                        this.curSpeedX = this.speed * 2;
                        break;
                    }
                    case -1: 
                    case 50: {
                        this.isJumpAtted = false;
                        this.setStatus((byte)2);
                        if (MyGameCanvas.isPressed(52) || MyGameCanvas.isPressed(-3)) {
                            this.curSpeedX = -this.speed;
                        } else if (MyGameCanvas.isPressed(54) || MyGameCanvas.isPressed(-4)) {
                            this.curSpeedX = this.speed;
                        }
                        this.curSpeedY = -30;
                        break;
                    }
                    case 49: {
                        this.isJumpAtted = false;
                        this.setStatus((byte)2);
                        this.curSpeedX = -this.speed;
                        this.curSpeedY = -30;
                        break;
                    }
                    case 51: {
                        this.isJumpAtted = false;
                        this.setStatus((byte)2);
                        this.curSpeedX = this.speed;
                        this.curSpeedY = -30;
                    }
                }
                if (this.curStatus != 0) return;
                switch (key) {
                    case 55: {
                        if (this.power <= 0) break;
                        --this.power;
                        this.setStatus((byte)8);
                        this.superTime = 5;
                        return;
                    }
                    case 57: {
                        if (this.power <= 0) break;
                        --this.power;
                        this.setStatus((byte)9);
                        this.superTime = 5;
                        return;
                    }
                    case 56: {
                        if (this.power < 2) break;
                        this.power -= 2;
                        this.baoqiTime = 0;
                        this.setStatus((byte)10);
                        this.superTime = 5;
                        return;
                    }
                    case 48: {
                        if (this.power <= 0) break;
                        --this.power;
                        this.setStatus((byte)25);
                        this.baoqiTime = 100;
                    }
                }
                return;
            }
            case 2: {
                switch (key) {
                    case -5: 
                    case 53: {
                        if (this.isJumpAtted) return;
                        this.setStatus((byte)12);
                        this.isJumpAtted = true;
                    }
                }
            }
        }
    }

    public void attack() {
        switch (this.attCount) {
            case 0: {
                this.setStatus((byte)7);
                break;
            }
            case 1: {
                this.setStatus((byte)16);
                break;
            }
            case 2: {
                this.setStatus((byte)17);
            }
        }
    }

    public void cpuAttack() {
        switch (this.attCount) {
            case 0: {
                this.setStatus((byte)7);
                break;
            }
            case 1: {
                this.setStatus((byte)16);
                break;
            }
            case 2: {
                this.setStatus((byte)17);
                break;
            }
        }
    }

    public void countAtt() {
        this.attDelay = 0;
        this.attCount = (byte)((this.attCount + 1) % 3);
    }

    public boolean canDefend() {
        return (this.curStatus == 11 || this.curStatus == 1 && (this.roleIsLeft && this.curSpeedX < 0 || !this.roleIsLeft && this.curSpeedX > 0)) && this.armor > 0;
    }

    public void injure(int num, int attMode) {
        this.hideVision();
        this.attCount = 0;
        int tempX = this.x;
        if (this.curStatus == 11 || this.curStatus == 1 && (this.roleIsLeft && this.curSpeedX < 0 || !this.roleIsLeft && this.curSpeedX > 0)) {
            if (this.armor > 0) {
                --this.armor;
                this.setStatus((byte)11);
                this.index = 0;
                this.curSpeedX = 0;
            } else {
                this.HP -= num;
                if (this.HP <= 0) {
                    this.HP = 0;
                    this.setStatus((byte)15);
                } else {
                    GameEngine.map.armorTime = 2;
                    this.armor = 10;
                    this.curSpeedX = 0;
                    this.curSpeedY = 0;
                    this.index = 0;
                }
            }
            this.attPush1(tempX);
        } else {
            this.HP -= num;
            if (this.HP <= 0) {
                this.HP = 0;
                this.setStatus((byte)15);
            } else {
                switch (attMode) {
                    case 0: {
                        if (this.curStatus == 5 || this.curStatus == 15) {
                            this.setStatus((byte)15);
                        } else {
                            this.curSpeedX = 0;
                            this.curSpeedY = 0;
                            this.setStatus((byte)4);
                            this.index = 0;
                        }
                        this.attPush1(tempX);
                        break;
                    }
                    case 1: {
                        this.setStatus((byte)15);
                        this.attPush1(tempX);
                        break;
                    }
                    case 2: {
                        this.curSpeedX = 0;
                        this.curSpeedY = -16;
                        this.setStatus((byte)4);
                        this.index = 0;
                        break;
                    }
                    case 3: {
                        this.curSpeedX = 0;
                        this.curSpeedY = -5;
                        this.setStatus((byte)4);
                        this.index = 0;
                        break;
                    }
                    case 4: {
                        this.curSpeedX = 0;
                        this.curSpeedY = 0;
                        this.setStatus((byte)4);
                        this.index = 0;
                        break;
                    }
                    case 5: {
                        this.curSpeedX = 0;
                        this.curSpeedY = 0;
                        this.setStatus((byte)24);
                        this.index = 0;
                        break;
                    }
                    case 6: {
                        this.setStatus((byte)15);
                        break;
                    }
                    case 7: {
                        this.curSpeedX = 0;
                        this.curSpeedY = -40;
                        this.setStatus((byte)4);
                        this.index = 0;
                        break;
                    }
                    case 8: {
                        this.curSpeedX = 0;
                        this.curSpeedY = 6;
                        this.setStatus((byte)4);
                        this.index = 0;
                        break;
                    }
                    case 9: {
                        this.curSpeedX = 0;
                        this.curSpeedY = -5;
                        this.setStatus((byte)4);
                        this.index = 0;
                        this.attPush1(tempX);
                        break;
                    }
                    case 10: {
                        this.curSpeedX = 0;
                        this.curSpeedY = 0;
                        this.setStatus((byte)27);
                        this.index = 0;
                        break;
                    }
                    case 11: {
                        this.curSpeedX = 0;
                        this.curSpeedY = -60;
                        this.setStatus((byte)4);
                        this.index = 0;
                    }
                }
            }
            GameEngine.AddBlastEffectList(this.x + this.w / 4 + GameRole.getRate(this.w / 2) - (this.roleIsLeft ? 0 : 36), this.y - GameRole.getRate(this.h / 4) - this.h / 4, 2, this.roleIsLeft ? 1 : 0);
            this.hitDelay = 20;
            ++this.hitNum;
            this.layer = 199;
        }
        this.realTimeRefresh();
        GameEngine.AddBlastEffectList(this.x + this.w / 4 + GameRole.getRate(this.w / 2) - 12, this.y - GameRole.getRate(this.h / 2) - this.h / 4, 0, 0);
    }

    public void attPush1(int lastX) {
        int distance = this.roleIsLeft ? -this.speed : this.speed;
        this.push(distance);
        GameEngine.roles[this.ID == 0 ? 1 : 0].push(this.x - lastX - distance);
    }

    public void MPAdd(int value) {
        this.MP += value;
        if (this.MP >= this.MP_MAX) {
            if (this.power < 3) {
                ++this.power;
                this.MP -= this.MP_MAX;
            } else {
                this.MP = this.MP_MAX - 1;
            }
        }
    }

    public void MPReduce() {
        if (this.power > 0) {
            --this.power;
        } else {
            this.MP = 0;
        }
    }

    public void realTimeRefresh() {
        if (this.curStatus != this.nextStatus) {
            this.curStatus = this.nextStatus;
            this.index = 0;
            if (this.curStatus == 15) {
                this.curSpeedY = -16;
                this.curSpeedX = (this.roleIsLeft ? -this.speed : this.speed) / 2;
            }
        }
        switch (this.type) {
            case 0: {
                this.move0();
                break;
            }
            case 1: {
                this.move1();
                break;
            }
            case 2: {
                this.move2();
                break;
            }
            case 3: {
                this.move3();
                break;
            }
            case 4: {
                this.move4();
            }
        }
        this.getSize(this.curIndex);
        this.attArea = this.getAttArea(this.type, this.curIndex);
        this.defendArea = this.getDefendArea(this.type, this.curIndex);
        this.sx = this.x - (this.isLeft ? this.rx : this.lx);
        this.sy = this.y + this.by;
    }

    public void ctrlRelease() {
        this.curSpeedX = 0;
        if (!(this.curStatus != 0 && this.curStatus != 1 || this.nextStatus != 0 && this.nextStatus != 1)) {
            this.setStatus((byte)0);
            this.curSpeedX = 0;
        }
    }

    public void getSize(int cIndex) {
        if (this.type == 4 && cIndex == 43) {
            this.lx = indent[this.type][0][0];
            this.rx = indent[this.type][0][1];
            this.ty = indent[this.type][0][2];
            this.by = indent[this.type][0][3];
        } else if (this.type == 3 && cIndex == 46) {
            this.lx = 4;
            this.rx = 8;
            this.ty = -1;
            this.by = 0;
        } else {
            this.lx = indent[this.type][cIndex][0];
            this.rx = indent[this.type][cIndex][1];
            this.ty = indent[this.type][cIndex][2];
            this.by = indent[this.type][cIndex][3];
        }
    }

    public void drawFrame(int sx, int sy, int index, boolean isMirror) {
        if (index < 0) {
            return;
        }
        for (int i = 0; i < data[this.type][index].length; i += 5) {
            byte trans = (byte)(data[this.type][index][i + 4] ^ 1);
            int temp = Tools.bToi(data[this.type][index][i]);
            Tools.addObject(this.img, sx + data[this.type][index][i + (isMirror ? 3 : 1)], sy + data[this.type][index][i + 2], Tools.bToi(clipDat[this.type][temp][0]), Tools.bToi(clipDat[this.type][temp][1]), Tools.bToi(clipDat[this.type][temp][2]), Tools.bToi(clipDat[this.type][temp][3]), 36, isMirror ? trans : data[this.type][index][i + 4], this.layer);
        }
    }

    public void drawFrame_Eff(int sx, int sy, int index, boolean isMirror) {
        if (index < 0) {
            return;
        }
        for (int i = 0; i < data[this.type][index].length; i += 5) {
            byte trans = (byte)(data[this.type][index][i + 4] ^ 1);
            int temp = Tools.bToi(data[this.type][index][i]);
            Tools.addObject(this.img, sx + data[this.type][index][i + (isMirror ? 3 : 1)], sy + data[this.type][index][i + 2], Tools.bToi(clipDat[this.type][temp][0]), Tools.bToi(clipDat[this.type][temp][1]), Tools.bToi(clipDat[this.type][temp][2]), Tools.bToi(clipDat[this.type][temp][3]), isMirror ? 40 : 36, isMirror ? trans : data[this.type][index][i + 4], this.layer + 1);
        }
    }

    public void drawFrame_Eff2(int sx, int sy, int index, boolean isMirror) {
        if (index < 0) {
            return;
        }
        this.layer = this.type == 3 && (this.curIndex == 13 || this.curIndex == 14) ? 199 : 201;
        for (int i = 0; i < data[this.type][index].length; i += 5) {
            byte trans = (byte)(data[this.type][index][i + 4] ^ 1);
            int temp = Tools.bToi(data[this.type][index][i]);
            Tools.addObject(this.img, sx + data[this.type][index][i + (isMirror ? 3 : 1)], sy + data[this.type][index][i + 2], Tools.bToi(clipDat[this.type][temp][0]), Tools.bToi(clipDat[this.type][temp][1]), Tools.bToi(clipDat[this.type][temp][2]), Tools.bToi(clipDat[this.type][temp][3]), 33, isMirror ? trans : data[this.type][index][i + 4], this.layer);
        }
    }

    public static void drawShadow(int x, int y, int w, int h, int lev) {
        int tempw = w + (GameMIDlet.gameIndex % 2 == 0 ? 0 : -2);
        int temph = h + (GameMIDlet.gameIndex % 2 == 0 ? 0 : -1);
        Tools.addObject((byte)2, x - tempw / 2, y + temph / 2, tempw, temph, 0, 360, true, 36, 0x3B3B3B, lev);
    }

    public void setStatus(byte status) {
        this.nextStatus = status;
        this.isPass = false;
        this.isPassed = false;
        this.layer = 200;
    }

    public void initSkill() {
        this.skillIndex = 0;
        GameEngine.map.superTime = 6;
        this.engine.showIcon(this.type);
    }

    public void drawSkill(int x, int y, int lev) {
        byte[] motion = new byte[]{0, 1, 2, 3, 4};
        if (this.skillIndex < 5) {
            // empty if block
        }
        if (++this.skillIndex < 5) {
            Tools.addObject(11, x, y, imgDatSkill[motion[this.skillIndex]], 3, (byte)0, lev);
        }
    }

    public void drawSkillFrame(int x, int y, int index, int lev) {
        byte[] data = null;
        switch (index) {
            case 0: {
                data = new byte[]{0, 0, 0, 0, 0};
                break;
            }
            case 1: {
                data = new byte[]{1, 0, 0, 0, 0};
                break;
            }
            case 2: {
                data = new byte[]{2, 0, 0, 23, 0, 2, 23, 0, 0, 1};
                break;
            }
            case 3: {
                data = new byte[]{3, 0, 0, 25, 0, 3, 25, 0, 0, 1};
                break;
            }
            case 4: {
                data = new byte[]{3, 0, 0, 25, 0, 3, 25, 0, 0, 1};
            }
        }
        for (int i = 0; i < data.length; i += 5) {
            Tools.addObject(11, x + data[i + 1], y + data[i + 2], imgDatSkill[data[i]], 36, data[i + 4] == 0 ? (byte)0 : 1, lev);
        }
    }

    public void showFire() {
        this.showFire = true;
        this.fireIndex = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void AI(GameRole role) {
        if (this.waitTime > 0) {
            --this.waitTime;
            return;
        }
        switch (this.curStatus) {
            case 2: {
                byte[] jumpAttIndex = new byte[]{8, 36, 11, 11, 10};
                short[] tempArea = this.getAttArea(this.type, jumpAttIndex[this.type]);
                if (!Tools.hit(tempArea[0], tempArea[1], tempArea[2], tempArea[3], role.defendArea[0], role.defendArea[1], role.defendArea[2], role.defendArea[3])) return;
                int rate = GameRole.getRate(100);
                if (rate >= attRate[GameEngine.cpuAI][0]) return;
                this.ctrl(53);
                return;
            }
            case 0: 
            case 1: {
                int rate = GameRole.getRate(100);
                if (rate < attRate[GameEngine.cpuAI][3] && role.attArea[2] != 0 && Tools.hit(this.defendArea[0] - 5, this.defendArea[1], this.defendArea[2] + 10, this.defendArea[3], role.attArea[0], role.attArea[1], role.attArea[2], role.attArea[3])) {
                    if (this.HP <= role.HP) {
                        if (GameEngine.time <= 30) return;
                    }
                    this.defend();
                    return;
                }
                byte[] types = this.getAttType(role);
                if (types == null) {
                    this.randomMove(role);
                    return;
                }
                rate = GameRole.getRate(100);
                if (rate < attRate[GameEngine.cpuAI][1]) {
                    this.randomMove(role);
                    return;
                }
                byte attType = types[GameRole.getRate(types.length)];
                if (attType != 0) {
                    rate = GameRole.getRate(100);
                    if (rate < attRate[GameEngine.cpuAI][2]) {
                        this.attackRole(attType);
                        return;
                    }
                    this.randomMove(role);
                    return;
                }
                this.attackRole(attType);
            }
        }
    }

    public byte[] getAttType(GameRole role) {
        byte[] temp = new byte[4];
        int max = 0;
        for (int i = 0; i < attCondition[this.type].length; ++i) {
            if (!Tools.hit(this.isLeft ? this.x + this.w - attCondition[this.type][i][0] - attCondition[this.type][i][2] : this.x + attCondition[this.type][i][0], this.y + attCondition[this.type][i][1], attCondition[this.type][i][2], attCondition[this.type][i][3], role.defendArea[0], role.defendArea[1], role.defendArea[2], role.defendArea[3]) || i != 0 && this.power <= 0) continue;
            temp[max] = (byte)i;
            ++max;
        }
        if (max > 0) {
            byte[] temp1 = new byte[max];
            for (int i = 0; i < max; ++i) {
                temp1[i] = temp[i];
            }
            return temp1;
        }
        return null;
    }

    public void stopWait() {
        this.setStatus((byte)0);
        this.curSpeedX = 0;
    }

    public void attackRole(int attType) {
        switch (attType) {
            case 0: {
                this.cpuAttack();
                break;
            }
            case 1: {
                this.ctrl(55);
                break;
            }
            case 2: {
                this.ctrl(57);
                break;
            }
            case 3: {
                this.ctrl(56);
            }
        }
    }

    public void defend() {
        this.setStatus((byte)11);
        this.curSpeedX = 0;
        this.curSpeedY = 0;
        --this.HP;
    }

    public void randomMove(GameRole role) {
        switch (this.curStatus) {
            case 0: 
            case 1: {
                this.curSpeedX = 0;
                this.curSpeedY = 0;
                int rate = GameRole.getRate(100);
                if (rate < 10) {
                    if (role.power > 0) {
                        this.ctrl(48);
                    }
                } else if (rate < 20) {
                    this.stopWait();
                } else if (rate < 40) {
                    this.leaveRole(role);
                } else {
                    this.closeRole(role);
                }
                this.waitTime = 5;
            }
        }
    }

    public void closeRole(GameRole role) {
        int rate = GameRole.getRate(100);
        if (rate < 60) {
            this.setStatus((byte)1);
            this.curSpeedX = this.roleIsLeft ? this.speed : -this.speed;
        } else if (rate < 80) {
            this.setStatus((byte)13);
            this.curSpeedX = 2 * (this.roleIsLeft ? this.speed : -this.speed);
        } else {
            this.ctrl(!this.roleIsLeft ? 49 : 51);
        }
    }

    public void leaveRole(GameRole role) {
        int rate = GameRole.getRate(100);
        if (rate < 60) {
            this.setStatus((byte)1);
            this.curSpeedX = this.roleIsLeft ? -this.speed : this.speed;
        } else if (rate < 80) {
            this.setStatus((byte)14);
            this.curSpeedX = 2 * (this.roleIsLeft ? -this.speed : this.speed);
            this.curSpeedY = -12;
        } else {
            this.ctrl(this.roleIsLeft ? 49 : 51);
        }
    }

    public static int getRate(int max) {
        return (GameEngine.rnd.nextInt() >>> 1) % max;
    }

    public short[] getAttArea(int type, int curFrame) {
        short[] temp;
        block140: {
            temp = new short[]{0, 0, 0, 0};
            block0 : switch (type) {
                case 0: {
                    switch (curFrame) {
                        case 9: {
                            if (this.curStatus == 13) break;
                            temp = new short[]{37, 0, 16, 39};
                            break;
                        }
                        case 17: {
                            temp = new short[]{20, -26, 31, 20};
                            break;
                        }
                        case 18: {
                            temp = new short[]{25, -26, 26, 20};
                            break;
                        }
                        case 22: {
                            temp = new short[]{8, 0, 46, 50};
                            break;
                        }
                        case 27: {
                            temp = new short[]{15, -35, 49, 10};
                            break;
                        }
                        case 28: {
                            temp = new short[]{37, -30, 49, 18};
                            break;
                        }
                        case 29: {
                            temp = new short[]{49, -30, 36, 19};
                            break;
                        }
                        case 30: {
                            temp = new short[]{68, -27, 32, 28};
                            break;
                        }
                        case 38: {
                            temp = new short[]{23, -38, 51, 9};
                            break;
                        }
                        case 39: {
                            temp = new short[]{23, -29, 51, 31};
                            break;
                        }
                        case 40: {
                            temp = new short[]{26, -34, 66, 19};
                            break;
                        }
                        case 41: {
                            temp = new short[]{37, -21, 56, 28};
                            break;
                        }
                        case 42: {
                            temp = new short[]{41, -19, 61, 31};
                            break;
                        }
                        case 43: {
                            temp = new short[]{60, -24, 56, 32};
                            break;
                        }
                        case 44: {
                            temp = new short[]{82, -27, 51, 30};
                            break;
                        }
                        case 45: {
                            temp = new short[]{87, -26, 43, 36};
                            break;
                        }
                        case 46: {
                            temp = new short[]{93, -28, 39, 36};
                            break;
                        }
                        case 47: {
                            temp = new short[]{94, -18, 34, 35};
                            break;
                        }
                        case 48: {
                            temp = new short[]{116, -5, 25, 45};
                        }
                    }
                    break;
                }
                case 1: {
                    switch (curFrame) {
                        case 9: {
                            if (this.curStatus == 13) break;
                            temp = new short[]{30, 0, 23, 40};
                            break;
                        }
                        case 17: {
                            temp = new short[]{0, 0, 50, 18};
                            break;
                        }
                        case 19: {
                            temp = new short[]{26, -24, 27, 8};
                            break;
                        }
                        case 22: {
                            temp = new short[]{26, -32, 27, 7};
                            break;
                        }
                        case 25: {
                            temp = new short[]{30, -21, 23, 10};
                            break;
                        }
                        case 27: {
                            temp = new short[]{35, 0, 18, 6};
                            break;
                        }
                        case 28: {
                            temp = new short[]{36, 0, 19, 43};
                            break;
                        }
                        case 29: {
                            temp = new short[]{34, 0, 47, 28};
                            break;
                        }
                        case 30: {
                            temp = new short[]{86, 0, 19, 41};
                        }
                        case 31: {
                            temp = new short[]{62, 0, 19, 29};
                            break;
                        }
                        case 35: {
                            temp = new short[]{23, -20, 44, 27};
                            break;
                        }
                        case 36: {
                            temp = new short[]{23, -19, 52, 25};
                            break;
                        }
                        case 37: {
                            temp = new short[]{30, -20, 56, 25};
                            break;
                        }
                        case 38: {
                            temp = new short[]{61, -19, 39, 25};
                            break;
                        }
                        case 39: {
                            temp = new short[]{53, -17, 47, 25};
                            break;
                        }
                        case 40: {
                            temp = new short[]{74, -18, 45, 25};
                            break;
                        }
                        case 41: {
                            temp = new short[]{109, -18, 40, 25};
                            break;
                        }
                        case 42: {
                            temp = new short[]{109, -18, 40, 25};
                            break;
                        }
                        case 43: {
                            temp = new short[]{124, -19, 30, 25};
                            break;
                        }
                        case 44: {
                            temp = new short[]{136, -21, 18, 22};
                            break;
                        }
                        case 46: {
                            temp = new short[]{27, -17, 28, 30};
                            break;
                        }
                        case 47: {
                            temp = new short[]{15, -24, 32, 32};
                            break;
                        }
                        case 48: {
                            temp = new short[]{21, -20, 41, 22};
                            break;
                        }
                        case 49: {
                            temp = new short[]{26, -5, 32, 31};
                            break;
                        }
                        case 50: {
                            temp = new short[]{27, -19, 34, 30};
                            break;
                        }
                        case 51: {
                            temp = new short[]{26, -13, 35, 23};
                        }
                    }
                    break;
                }
                case 2: {
                    switch (curFrame) {
                        case 9: {
                            if (this.curStatus == 13) break;
                            temp = new short[]{19, 0, 39, 40};
                            break;
                        }
                        case 14: {
                            temp = new short[]{16, 0, 29, 20};
                            break;
                        }
                        case 19: {
                            temp = new short[]{26, -12, 26, 18};
                            break;
                        }
                        case 22: {
                            if (this.curStatus == 28) {
                                temp = new short[]{22, -21, 60, 32};
                                break;
                            }
                            temp = new short[]{22, -21, 30, 32};
                            break;
                        }
                        case 26: {
                            temp = new short[]{16, -10, 38, 45};
                            break;
                        }
                        case 27: {
                            temp = new short[]{35, -10, 30, 41};
                            break;
                        }
                        case 28: {
                            temp = new short[]{42, -6, 36, 44};
                            break;
                        }
                        case 29: {
                            temp = new short[]{47, -2, 41, 46};
                            break;
                        }
                        case 30: {
                            temp = new short[]{56, -4, 43, 40};
                            break;
                        }
                        case 31: {
                            temp = new short[]{67, -3, 33, 48};
                            break;
                        }
                        case 32: {
                            temp = new short[]{81, -5, 23, 32};
                            break;
                        }
                        case 33: {
                            temp = new short[]{82, -8, 22, 43};
                            break;
                        }
                        case 34: {
                            temp = new short[]{-4, 0, 38, 48};
                            break;
                        }
                        case 35: {
                            temp = new short[]{-9, 0, 50, 54};
                            break;
                        }
                        case 36: {
                            temp = new short[]{-16, 0, 62, 67};
                            break;
                        }
                        case 37: {
                            temp = new short[]{-23, 0, 66, 66};
                            break;
                        }
                        case 38: {
                            temp = new short[]{-4, 0, 38, 49};
                        }
                        case 39: {
                            temp = new short[]{-9, 0, 50, 54};
                            break;
                        }
                        case 40: {
                            temp = new short[]{-16, 0, 62, 66};
                        }
                        case 41: {
                            temp = new short[]{-23, 0, 66, 66};
                            break;
                        }
                        case 47: {
                            temp = new short[]{2, -30, 63, 6};
                            break;
                        }
                        case 48: {
                            temp = new short[]{5, -24, 73, 17};
                            break;
                        }
                        case 49: {
                            temp = new short[]{12, -22, 77, 16};
                            break;
                        }
                        case 50: {
                            temp = new short[]{-1, -18, 76, 17};
                            break;
                        }
                        case 51: {
                            temp = new short[]{12, -11, 99, 15};
                            break;
                        }
                        case 52: {
                            temp = new short[]{37, -18, 79, 19};
                            break;
                        }
                        case 53: {
                            temp = new short[]{38, -29, 78, 6};
                            break;
                        }
                        case 54: {
                            temp = new short[]{38, -18, 81, 16};
                            break;
                        }
                        case 55: {
                            temp = new short[]{35, -21, 74, 14};
                            break;
                        }
                        case 56: {
                            temp = new short[]{39, -24, 71, 11};
                            break;
                        }
                        case 57: {
                            temp = new short[]{32, -24, 75, 10};
                            break;
                        }
                        case 58: {
                            temp = new short[]{38, -7, 64, 27};
                            break;
                        }
                        case 59: {
                            temp = new short[]{27, -16, 78, 18};
                            break;
                        }
                        case 60: {
                            temp = new short[]{36, -17, 74, 18};
                            break;
                        }
                        case 61: {
                            temp = new short[]{41, -25, 85, 9};
                            break;
                        }
                        case 62: {
                            temp = new short[]{6, -24, 84, 10};
                        }
                    }
                    break;
                }
                case 3: {
                    switch (curFrame) {
                        case 13: 
                        case 14: {
                            if (this.curStatus != 9 && this.curStatus != 28) break;
                            temp = new short[]{23, 0, 46, 200};
                            break;
                        }
                        case 26: 
                        case 27: {
                            if (this.curStatus == 17) {
                                temp = new short[]{0, 0, 63, 100};
                            }
                            if (this.curStatus != 8) break;
                            temp = new short[]{0, 0, 79, 200};
                            break;
                        }
                        case 4: {
                            if (this.curStatus == 13) break;
                            temp = new short[]{0, 0, 32, 48};
                            break;
                        }
                        case 12: {
                            temp = new short[]{-5, 0, 48, 17};
                            break;
                        }
                        case 20: {
                            temp = new short[]{20, -37, 19, 11};
                            break;
                        }
                        case 23: {
                            temp = new short[]{20, -32, 22, 14};
                            break;
                        }
                        case 30: {
                            temp = new short[]{21, -28, 29, 12};
                            break;
                        }
                        case 32: {
                            temp = new short[]{7, -31, 34, 22};
                            break;
                        }
                        case 34: {
                            temp = new short[]{-20, 0, 63, 65};
                            break;
                        }
                        case 36: 
                        case 37: {
                            temp = new short[]{-11, 0, 46, 41};
                        }
                    }
                    break;
                }
                case 4: {
                    switch (curFrame) {
                        case 31: {
                            if (this.curStatus == 8) {
                                switch (this.index) {
                                    case 2: {
                                        temp = new short[]{4, -6, 47, 51};
                                        break block0;
                                    }
                                    case 4: {
                                        temp = new short[]{22, -55, 35, 46};
                                        break block0;
                                    }
                                    case 6: {
                                        temp = new short[]{35, -6, 83, 77};
                                        break block0;
                                    }
                                    case 8: {
                                        temp = new short[]{33, -18, 35, 45};
                                    }
                                }
                                break block0;
                            }
                            break block140;
                        }
                        case 38: {
                            if (this.curStatus == 8) {
                                switch (this.index) {
                                    case 3: {
                                        temp = new short[]{0, -7, 84, 59};
                                        break block0;
                                    }
                                    case 5: {
                                        temp = new short[]{48, -16, 59, 59};
                                        break block0;
                                    }
                                    case 7: {
                                        temp = new short[]{39, 0, 98, 89};
                                        break block0;
                                    }
                                    case 9: {
                                        temp = new short[]{29, 0, 54, 78};
                                    }
                                }
                                break block0;
                            }
                            break block140;
                        }
                        case 9: {
                            if (this.curStatus != 13) {
                                temp = new short[]{0, 0, 36, 53};
                                break block0;
                            }
                            break block140;
                        }
                        case 15: {
                            temp = new short[]{-4, -23, 43, 19};
                            break block0;
                        }
                        case 23: {
                            temp = new short[]{24, -5, 20, 25};
                            break block0;
                        }
                        case 28: {
                            temp = new short[]{24, -25, 23, 16};
                            break block0;
                        }
                        case 32: {
                            temp = new short[]{22, -21, 31, 52};
                            break block0;
                        }
                        case 33: {
                            temp = new short[]{13, 5, 44, 59};
                            break block0;
                        }
                        case 34: {
                            temp = new short[]{-13, 2, 82, 85};
                            break block0;
                        }
                        case 35: {
                            temp = new short[]{-14, -8, 82, 62};
                            break block0;
                        }
                        case 17: {
                            temp = new short[]{-23, -27, 73, 8};
                            break block0;
                        }
                        case 18: {
                            temp = new short[]{-20, -26, 56, 7};
                            break block0;
                        }
                        case 19: {
                            temp = new short[]{-22, -28, 54, 9};
                            break block0;
                        }
                        case 20: {
                            temp = new short[]{-17, -31, 68, 10};
                            break block0;
                        }
                        case 21: {
                            temp = new short[]{4, -36, 44, 8};
                        }
                    }
                }
            }
        }
        return new short[]{(short)(this.isLeft ? this.x + this.w - temp[0] - temp[2] : this.x + temp[0]), (short)(this.y + temp[1]), temp[2], temp[3]};
    }

    public short[] getDefendArea(int type, int curFrame) {
        byte[] temp = hurtArea[type][curFrame];
        return new short[]{(short)(this.isLeft ? this.x + this.w - temp[0] - temp[2] : this.x + temp[0]), (short)(this.y + temp[1]), temp[2], temp[3]};
    }
}

