/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public abstract class GameObject {
    int x = 0;
    int y = 0;
    int w = 0;
    int h = 0;
    int life = 0;
    int attach = 0;
    int dx = 0;
    int dy = 0;
    Sprite sprite = null;
    int currentFrame = 0;
    int endFrame = 0;

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getLife() {
        return this.life;
    }

    public int getAttach() {
        return this.attach;
    }

    public int getDX() {
        return this.dx;
    }

    public int getDY() {
        return this.dy;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public int getEndFrame() {
        return this.endFrame;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getLeftTopX() {
        return this.x - this.getWidth() / 2;
    }

    public int getLeftTopY() {
        return this.y - this.getHeight() / 2;
    }

    public int getRightBottomX() {
        return this.x + this.getWidth() / 2;
    }

    public int getRightBottomY() {
        return this.y + this.getHeight() / 2;
    }

    public abstract void move();

    public void moveTo(int offx, int offy) {
        this.x += offx;
        this.y += offy;
    }

    public void gotoNextFrame() {
        ++this.currentFrame;
        if (this.currentFrame >= this.endFrame) {
            this.currentFrame = this.endFrame;
        }
    }

    public int changeLife(int offLife) {
        this.life += offLife;
        return this.life;
    }

    public abstract boolean canDestroySelf();

    public void draw(Graphics g) {
        this.sprite.setFrame(this.getCurrentFrame());
        this.sprite.setPosition(this.getLeftTopX(), this.getLeftTopY());
        this.sprite.paint(g);
    }

    public boolean meetObject(GameObject other) {
        int otherLX = other.getLeftTopX();
        int otherLY = other.getLeftTopY();
        int otherRX = other.getRightBottomX();
        int otherRY = other.getRightBottomY();
        int selfLX = this.getLeftTopX();
        int selfLY = this.getLeftTopY();
        int selfRX = this.getRightBottomX();
        int selfRY = this.getRightBottomY();
        if (otherLX >= selfLX && otherLX <= selfRX && otherLY >= selfLY && otherLY <= selfRY) {
            return true;
        }
        if (otherRX >= selfLX && otherRX <= selfRX && otherRY >= selfLY && otherRY <= selfRY) {
            return true;
        }
        if (selfLX >= otherLX && selfLX <= otherRX) {
            if (selfLY >= otherLY && selfLY <= otherRY) {
                return true;
            }
            if (selfRY >= otherLY && selfRY <= otherRY) {
                return true;
            }
        } else if (selfRX >= otherLX && selfRX <= otherRX) {
            if (selfLY >= otherLY && selfLY <= otherRY) {
                return true;
            }
            if (selfRY >= otherLY && selfRY <= otherRY) {
                return true;
            }
        }
        return false;
    }
}

