/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameInf;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer {
    public String pType;
    public final String[] mediaType = new String[]{"audio/x-wav", "audio/midi", "audio/mpeg", "audio/amr"};
    private int a;
    public byte[][] sound_data;

    public SoundPlayer(String string) {
        this.pType = string;
        this.a = -1;
    }

    public void setSound(int n, String string) {
        this.sound_data = GameInf.getStream(this.sound_data, string);
        for (int i = 0; i < this.sound_data.length; ++i) {
            if (i == n) continue;
            this.sound_data[i] = null;
        }
    }

    public InputStream getInputStream(int n) {
        try {
            if (this.a == n) {
                return null;
            }
            this.a = n;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.sound_data[n]);
            return byteArrayInputStream;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Player createPlayer(InputStream inputStream, String string, int n) {
        Player player;
        if (inputStream != null) {
            try {
                if (string.equals("mid")) {
                    player = Manager.createPlayer((InputStream)inputStream, (String)this.mediaType[1]);
                } else if (string.equals("wav")) {
                    player = Manager.createPlayer((InputStream)inputStream, (String)this.mediaType[0]);
                } else if (string.equals("mp3")) {
                    player = Manager.createPlayer((InputStream)inputStream, (String)this.mediaType[2]);
                } else if (string.equals("amr")) {
                    player = Manager.createPlayer((InputStream)inputStream, (String)this.mediaType[3]);
                } else {
                    return null;
                }
                player.realize();
            }
            catch (Exception exception) {
                return null;
            }
        } else {
            return null;
        }
        player.setLoopCount(n);
        return player;
    }

    public void setVolumControl(Player player, int n) {
        if (n > 0) {
            VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
            volumeControl.setLevel(n * 20);
            return;
        }
        VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
        volumeControl.setLevel(n * 20);
        this.stopSound(player);
    }

    public void setVolumControlAndPlay(Player player, int n) {
        if (n > 0) {
            VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
            volumeControl.setLevel(n * 20);
            this.playSound(player);
            return;
        }
        VolumeControl volumeControl = (VolumeControl)player.getControl("VolumeControl");
        volumeControl.setLevel(n * 20);
        this.stopSound(player);
    }

    public void setLoopCount(Player player, int n) {
        player.setLoopCount(n);
    }

    public int getSoundPlayID() {
        return this.a;
    }

    public boolean isPlayStoped(Player player) {
        return player.getState() == 300;
    }

    public void playSound(Player player) {
        try {
            if (player.getState() != 400) {
                player.start();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void pauseSound(Player player) {
        try {
            if (player.getState() == 400) {
                player.stop();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void stopSound(Player player) {
        try {
            if (player.getState() == 400) {
                player.stop();
            }
            if (!this.pType.equals("NOKIA")) {
                player.deallocate();
            }
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }

    public void closeSound(Player player) {
        try {
            if (player.getState() == 400) {
                player.stop();
            }
            if (!this.pType.equals("NOKIA")) {
                player.deallocate();
            }
            this.a = -1;
            player.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

