/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.game.Sprite;

public class EnemyTurnBackPlane
extends BasicPlane {
    private boolean fromLeftDirectEnter = false;
    private boolean canSendBullet = true;
    private int sendBulletFrame = 0;

    public EnemyTurnBackPlane(Sprite sprite, int x, int y, boolean fromLeftDirectEnter) {
        try {
            this.sprite = sprite;
            this.x = x;
            this.y = y;
            this.w = sprite.getWidth();
            this.h = sprite.getHeight();
            this.life = 2;
            this.attach = 1;
            this.dx = 3;
            this.dy = 10;
            this.currentFrame = 0;
            this.endFrame = sprite.getRawFrameCount() - 1;
            this.fromLeftDirectEnter = fromLeftDirectEnter;
            this.canSendBullet = true;
            Random rn = new Random();
            this.sendBulletFrame = rn.nextInt(this.endFrame + 1) - 1;
            rn = null;
            this.bulletType = 10;
        }
        catch (Exception e) {
            Util.debug("EnemyTurnBackPlane---------------init die!");
        }
    }

    private void fromLeftToRightMove() {
        if (this.getX() < Util.screenWidth / 4) {
            this.moveTo(0, this.getDY());
        } else {
            this.moveTo(0, -this.getDY());
        }
        this.moveTo(this.getDX(), 0);
        if (this.getX() >= Util.screenWidth / 2) {
            this.setPosition(Util.screenWidth / 2, this.getY());
        }
        int jg = Util.screenWidth / 2 / (this.endFrame + 1);
        if (this.getX() < jg) {
            this.currentFrame = 0;
        } else if (this.getX() >= jg && this.getX() < jg * 2) {
            this.currentFrame = 1;
        } else if (this.getX() >= jg * 2 && this.getX() < jg * 3) {
            this.currentFrame = 2;
        } else if (this.getX() >= jg * 3 && this.getX() < jg * 4) {
            this.currentFrame = 3;
        } else if (this.getX() >= jg * 4) {
            this.currentFrame = 4;
        }
    }

    private void fromRightToLeftMove() {
        if (this.getX() < 3 * Util.screenWidth / 4) {
            this.moveTo(0, -this.getDY());
        } else {
            this.moveTo(0, this.getDY());
        }
        this.moveTo(-this.getDX(), 0);
        if (this.getX() <= Util.screenWidth / 2) {
            this.setPosition(Util.screenWidth / 2, this.getY());
        }
        int jg = Util.screenWidth / 2 / (this.endFrame + 1);
        int centerX = Util.screenWidth / 2;
        if (this.getX() < centerX + jg) {
            this.currentFrame = 4;
        } else if (this.getX() >= centerX + jg && this.getX() < centerX + jg * 2) {
            this.currentFrame = 3;
        } else if (this.getX() >= centerX + jg * 2 && this.getX() < centerX + jg * 3) {
            this.currentFrame = 2;
        } else if (this.getX() >= centerX + jg * 3 && this.getX() < centerX + jg * 4) {
            this.currentFrame = 1;
        } else if (this.getX() >= centerX + jg * 4) {
            this.currentFrame = 0;
        }
    }

    public boolean canSendBullet() {
        if (!this.canSendBullet) {
            return false;
        }
        if (this.sendBulletFrame == this.getCurrentFrame()) {
            this.canSendBullet = false;
            return true;
        }
        return false;
    }

    public void move() {
        if (!this.canMove(35L)) {
            return;
        }
        if (this.fromLeftDirectEnter) {
            this.fromLeftToRightMove();
        } else {
            this.fromRightToLeftMove();
        }
    }

    public boolean canDestroySelf() {
        return this.getCurrentFrame() >= this.getEndFrame() && this.getY() <= 0;
    }
}

