/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class PlayerManager {
    public static final int PLAYER_FLY_NORMAL = 0;
    public static final int PLAYER_FLY_LEFT = 1;
    public static final int PLAYER_FLY_RIGHT = 2;
    private BasicPlayer currentPlayer = null;
    public static final int MASTER_SKILL_LASER = 1;
    public static final int MASTER_SKILL_CONCUSSION = 2;
    Vector masterSkillVector = new Vector();
    private boolean playerDied = false;
    public int playerLifeCount = 3;
    private boolean playerStealth = false;
    public int playerMasterSkillFireCount = 3;
    long start = 0L;
    long end = 0L;
    Image imghp = null;
    Image imghpmore = null;
    Image imgsp = null;
    Image imgwudi = null;

    public BasicPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    public PlayerManager(int playerType) {
        this.initPlayer(playerType);
        try {
            this.imghp = Image.createImage((String)"/shield.png");
            this.imghpmore = Image.createImage((String)"/shieldmore.png");
            this.imgsp = Image.createImage((String)"/star.png");
            this.imgwudi = Image.createImage((String)"/wudi.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initStageData() {
        this.playerDied = false;
        this.playerLifeCount = 3;
        this.playerMasterSkillFireCount = 3;
        this.masterSkillVector.removeAllElements();
    }

    private void initPlayer(int playerType) {
        String playerFile = null;
        switch (playerType) {
            case 1: {
                playerFile = "/plane.png";
                break;
            }
            case 2: {
                playerFile = "/plane.png";
                break;
            }
            case 3: {
                playerFile = "/plane.png";
            }
        }
        try {
            Image img = Image.createImage((String)playerFile);
            Sprite playerSprite = new Sprite(img, img.getWidth() / 3, img.getHeight());
            Util.player = this.currentPlayer = new PlayerOne(playerSprite, (Util.screenWidth - playerSprite.getWidth()) / 2, Util.screenHeight - playerSprite.getHeight() - 5);
        }
        catch (Exception ex) {
            Util.debug("initPlayer----------------die!");
        }
    }

    public void masterSkillFire(int masterSkillType) {
        if (this.playerDied) {
            return;
        }
        if (this.masterSkillVector.size() > 0) {
            return;
        }
        switch (masterSkillType) {
            case 1: {
                if (this.playerMasterSkillFireCount <= 0) break;
                --this.playerMasterSkillFireCount;
                int i = 0;
                while (i <= 4) {
                    MasterSkillLaserPlane bl = new MasterSkillLaserPlane(this.currentPlayer.sprite, i * Util.screenWidth / 4, Util.screenHeight - 2);
                    this.masterSkillVector.addElement(bl);
                    ++i;
                }
                break;
            }
        }
    }

    public void calcPlayer(BulletManager blManager) {
        BasicPlane bl;
        if (this.playerDied) {
            this.end = System.currentTimeMillis();
            if (this.end - this.start > 1000L) {
                this.playerDied = false;
                this.start = this.end;
                return;
            }
        }
        if (this.playerStealth) {
            this.end = System.currentTimeMillis();
            if (this.end - this.start > 3000L) {
                this.playerStealth = false;
                this.currentPlayer.setStealthMode(false);
                this.start = this.end;
                return;
            }
        }
        int i = 0;
        while (i < this.masterSkillVector.size()) {
            bl = (BasicPlane)this.masterSkillVector.elementAt(i);
            bl.move();
            if (bl.canSendBullet()) {
                blManager.createMasterSkillBullet(bl.getX(), bl.getY(), bl.getBulletType());
            }
            ++i;
        }
        i = 0;
        while (i < this.masterSkillVector.size()) {
            bl = (BasicPlane)this.masterSkillVector.elementAt(i);
            if (bl.canDestroySelf()) {
                this.masterSkillVector.removeElement(bl);
                if (--i < 0) {
                    i = 0;
                }
            }
            ++i;
        }
        this.meetCheck(blManager);
        if (!this.playerDied && Util.cloudManager != null) {
            Util.cloudManager.meetTreasureCheck(this.getCurrentPlayer());
        }
    }

    private void meetCheck(BulletManager blManager) {
        if (this.playerDied || this.playerStealth) {
            return;
        }
        if (Util.invincibleMode) {
            return;
        }
        Vector bulletVector = blManager.bulletVector;
        int i = 0;
        while (i < bulletVector.size()) {
            BasicBullet bt = (BasicBullet)bulletVector.elementAt(i);
            if (bt.isEnemySendBullet() && this.currentPlayer.meetObject(bt)) {
                Util.explosionManager.createExplosion(this.currentPlayer.getX(), this.currentPlayer.getY(), 2);
                bulletVector.removeElement(bt);
                if (--i < 0) {
                    i = 0;
                }
                this.playerDied = true;
                --this.playerLifeCount;
                if (this.playerLifeCount <= 0) {
                    Util.gotoGameOver();
                } else {
                    this.playerStealth = true;
                    this.currentPlayer.setStealthMode(true);
                    this.start = System.currentTimeMillis();
                }
                return;
            }
            ++i;
        }
        Vector enemyPlaneVector = Util.enemyManager.enemyPlaneVector;
        int i2 = 0;
        while (i2 < enemyPlaneVector.size()) {
            BasicPlane pl = (BasicPlane)enemyPlaneVector.elementAt(i2);
            if (this.currentPlayer.meetObject(pl)) {
                Util.explosionManager.createExplosion(this.currentPlayer.getX(), this.currentPlayer.getY(), 2);
                this.playerDied = true;
                --this.playerLifeCount;
                if (this.playerLifeCount <= 0) {
                    Util.gotoGameOver();
                } else {
                    this.playerStealth = true;
                    this.currentPlayer.setStealthMode(true);
                    this.start = System.currentTimeMillis();
                }
                return;
            }
            ++i2;
        }
    }

    public void moveTo(int dx, int dy) {
        if (this.currentPlayer != null) {
            this.currentPlayer.moveTo(dx, dy);
        }
    }

    public void setPlayerFlyMode(int flyMode) {
        if (this.currentPlayer != null) {
            this.currentPlayer.setFlyMode(flyMode);
        }
    }

    public void fire(int int_fire_bulletSelect) {
        if (this.playerDied) {
            return;
        }
        if (int_fire_bulletSelect == 1) {
            Util.bulletManager.createBullet(this.currentPlayer.getX(), this.currentPlayer.getY(), false, 1);
        } else if (int_fire_bulletSelect == 2) {
            Util.bulletManager.createBullet(this.currentPlayer.getX(), this.currentPlayer.getY(), false, 6);
        }
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.playerLifeCount) {
            g.drawImage(this.imghp, i * (1 + this.imghp.getWidth()), Util.screenHeight - this.imghp.getHeight() * 2 - 5, 20);
            ++i;
        }
        i = 0;
        while (i < this.playerMasterSkillFireCount) {
            g.drawImage(this.imgsp, i * (1 + this.imgsp.getWidth()), Util.screenHeight - this.imgsp.getHeight(), 20);
            ++i;
        }
        if (Util.f_dunpai) {
            g.drawImage(this.imgwudi, 0, Util.screenHeight - this.imghp.getHeight() - this.imgsp.getHeight() - this.imgwudi.getHeight() * 2, 20);
        }
        i = 0;
        while (i < this.masterSkillVector.size()) {
            BasicPlane bl = (BasicPlane)this.masterSkillVector.elementAt(i);
            bl.draw(g);
            ++i;
        }
        if (this.playerDied) {
            return;
        }
        if (this.currentPlayer != null) {
            this.currentPlayer.draw(g);
        }
    }
}

