/*
 * Decompiled with CFR 0.152.
 */
package com;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class SmsConfig {
    public static String addMenu;
    public static String addMenuLink;
    public static String[] logos;
    public static short[] logoTime;
    public static String aboutus;
    static byte mode;
    public static String[] smsCommands;
    public static String smsPrefix;
    public static String smsPhoneNum;
    public static String smsMsg;
    public static int price;
    public static int[] bgcolor;
    public static int[] delay;
    public static int sendTimes;
    public static int cpid;
    public static String machineNo;
    public static String gameId;
    public static String channelId;
    public static final int N73 = 12;
    public static final int N7370 = 13;
    public static final int N95 = 46;
    public static final int K790 = 5;
    static String sub;

    public static void readConfig(String cfgFile) {
        String file = SmsConfig.readUTFFile(cfgFile);
        addMenu = SmsConfig.getStrProperty(file, "addMenu");
        addMenuLink = SmsConfig.getStrProperty(file, "addMenuLink");
        logos = SmsConfig.getStrArrProperty(file, "logo");
        logoTime = SmsConfig.getShortArrProperty(file, "logoTime");
        aboutus = SmsConfig.getSubString(file, "aboutus:", "aboutusEnd");
        mode = SmsConfig.getByteProperty(file, "mode");
        smsCommands = SmsConfig.getStrArrProperty(file, "smsCommand");
        smsPrefix = SmsConfig.getStrProperty(file, "smsPrefix");
        smsPhoneNum = SmsConfig.getStrProperty(file, "smsPhoneNum");
        smsMsg = SmsConfig.getStrProperty(file, "smsMsg");
        gameId = SmsConfig.getStrProperty(file, "gameId");
        channelId = SmsConfig.getStrProperty(file, "channelId");
        price = Integer.parseInt(SmsConfig.getStrProperty(file, "price"));
        bgcolor = SmsConfig.splitStrToIntArr(SmsConfig.getStrProperty(file, "logoBgColor"), ",");
        delay = SmsConfig.splitStrToIntArr(SmsConfig.getStrProperty(file, "logoTime"), ",");
        sendTimes = Integer.parseInt(SmsConfig.getStrProperty(file, "sendTimes"));
        cpid = Integer.parseInt(SmsConfig.getStrProperty(file, "cpid"));
    }

    public static void readSubChannels(String subfile) {
        sub = SmsConfig.readUTFFile(subfile);
    }

    public static String getSendCommand(int type, String No) {
        String cmd = null;
        Object tel_number = null;
        if (mode == 1) {
            StringBuffer bf = new StringBuffer();
            bf.append(smsPrefix);
            bf.append("D");
            bf.append(gameId);
            bf.append(channelId);
            bf.append(machineNo + "S");
            bf.append(No);
            if (type < 10) {
                bf.append("0" + type);
            } else {
                bf.append(type);
            }
            if (sub != null && !sub.equals("")) {
                bf.append(sub);
            }
            cmd = bf.toString();
            bf = null;
        } else if (smsCommands != null) {
            cmd = smsCommands[0];
        }
        return cmd;
    }

    public static String readUTFFile(String path) {
        if (path == null || path.equals("")) {
            return null;
        }
        String returnStr = null;
        byte[] fileBytes = SmsConfig.getBytesFromFileEx(path);
        if (fileBytes == null) {
            System.out.println(path + "\u6587\u4ef6\u4e0d\u5b58\u5728");
            return null;
        }
        if (fileBytes.length > 3 && fileBytes[0] == -17 && fileBytes[1] == -69 && fileBytes[2] == -65) {
            try {
                returnStr = new String(fileBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                returnStr = new String(fileBytes, "ISO8859-1");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return returnStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFileEx(String filePath) {
        if (filePath == null || filePath.equals("")) {
            return null;
        }
        byte[] returnBytes = null;
        InputStream is = null;
        try {
            is = new SmsConfig().getClass().getResourceAsStream(filePath);
            int fileLen = 0;
            fileLen = is.available();
            if (fileLen <= 0) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] readBytes = new byte[4096];
                int len = 0;
                while ((len = is.read(readBytes)) != -1) {
                    bos.write(readBytes, 0, len);
                }
                returnBytes = bos.toByteArray();
            } else {
                returnBytes = new byte[fileLen];
                is.read(returnBytes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            is = null;
        }
        return returnBytes;
    }

    public static String getStrProperty(String str, String name) {
        if (str == null || name == null || str.equals("") || name.equals("")) {
            return null;
        }
        String[] propArr = SmsConfig.splitStr(str, "\r\n");
        for (int i = 0; propArr != null && i < propArr.length; ++i) {
            if (propArr[i] == null || propArr[i].equals("") || !propArr[i].startsWith(name + "=")) continue;
            return propArr[i].substring((name + "=").length());
        }
        return null;
    }

    public static String[] getStrArrProperty(String str, String name) {
        return SmsConfig.splitStr(SmsConfig.getStrProperty(str, name), ",");
    }

    public static String[] splitStr(String source, String splitStr) {
        if (source == null || splitStr == null) {
            return null;
        }
        int startIndex = 0;
        String[] returnStrArr = null;
        while (startIndex < source.length()) {
            String[] tmp;
            int splitIndex = source.indexOf(splitStr, startIndex);
            if (splitIndex != -1) {
                if (!source.substring(startIndex, splitIndex).equals("")) {
                    if (returnStrArr == null) {
                        returnStrArr = new String[1];
                    } else {
                        tmp = new String[returnStrArr.length + 1];
                        System.arraycopy(returnStrArr, 0, tmp, 0, returnStrArr.length);
                        returnStrArr = tmp;
                    }
                    returnStrArr[returnStrArr.length - 1] = source.substring(startIndex, splitIndex);
                }
                startIndex = splitIndex + splitStr.length();
                continue;
            }
            if (source.substring(startIndex).equals("")) break;
            if (returnStrArr == null) {
                returnStrArr = new String[1];
            } else {
                tmp = new String[returnStrArr.length + 1];
                System.arraycopy(returnStrArr, 0, tmp, 0, returnStrArr.length);
                returnStrArr = tmp;
            }
            returnStrArr[returnStrArr.length - 1] = source.substring(startIndex);
            break;
        }
        return returnStrArr;
    }

    public static short[] getShortArrProperty(String str, String name) {
        return SmsConfig.splitStrToShortArr(SmsConfig.getStrProperty(str, name), ",");
    }

    public static short[] splitStrToShortArr(String source, String splitStr) {
        short[] returnArr = null;
        int[] tmp = SmsConfig.splitStrToIntArr(source, splitStr);
        if (tmp != null) {
            returnArr = new short[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                returnArr[i] = (short)tmp[i];
            }
        }
        return returnArr;
    }

    public static String[] getStrLineArr(String str, String startStr, String endStr) {
        String[] returnArr = null;
        String roleNameStr = SmsConfig.getSubString(str, startStr, endStr);
        if (roleNameStr == null) {
            return null;
        }
        returnArr = SmsConfig.splitStr(roleNameStr, "\r\n");
        return returnArr;
    }

    public static String getSubString(String source, String startStr, String endStr) {
        if (source == null || source.equals("")) {
            return null;
        }
        String needStr = null;
        int start = -1;
        start = startStr != null ? source.indexOf(startStr) : 0;
        if (start > -1) {
            if (endStr != null) {
                int end = source.indexOf(endStr, start);
                if (end > -1) {
                    needStr = startStr != null ? source.substring(start + startStr.length(), end) : source.substring(0, end);
                    return needStr;
                }
            } else {
                needStr = startStr != null ? source.substring(start + startStr.length()) : source;
                return needStr;
            }
        }
        return null;
    }

    public static byte getByteProperty(String str, String name) {
        return SmsConfig.str2byte(SmsConfig.getStrProperty(str, name));
    }

    public static int[] splitStrToIntArr(String source, String splitStr) {
        if (source == null || source.equals("")) {
            return null;
        }
        String[] tmpArr = SmsConfig.splitStr(source, splitStr);
        int[] returnIntArr = null;
        if (tmpArr != null) {
            returnIntArr = new int[tmpArr.length];
            for (int i = 0; i < tmpArr.length; ++i) {
                returnIntArr[i] = SmsConfig.str2int(tmpArr[i]);
            }
        }
        return returnIntArr;
    }

    public static byte str2byte(String str) {
        if (str == null || str.equals("")) {
            return 0;
        }
        byte returnValue = 0;
        try {
            returnValue = str.startsWith("0x") || str.startsWith("0X") ? Byte.parseByte(str.substring(2), 16) : Byte.parseByte(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnValue;
    }

    public static int str2int(String str) {
        if (str == null || str.equals("")) {
            return 0;
        }
        int returnValue = 0;
        try {
            returnValue = str.startsWith("0x") || str.startsWith("0X") ? Integer.parseInt(str.substring(2), 16) : Integer.parseInt(str);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnValue;
    }

    static {
        price = 1;
        machineNo = "05";
    }
}

