/*
 * Decompiled with CFR 0.152.
 */
package com.Tools;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.ToneControl;
import javax.microedition.media.control.VolumeControl;

public class CSSoundPlayer
implements PlayerListener {
    public static final byte C4 = 60;
    public static final byte D4 = 62;
    public static final byte E4 = 64;
    public static final byte F4 = 65;
    public static final byte G4 = 67;
    public static final byte A4 = 69;
    public static final byte B4 = 71;
    public static final byte C4_H = 61;
    public static final byte D4_H = 63;
    public static final byte F4_H = 66;
    public static final byte G4_H = 68;
    public static final byte A4_H = 70;
    public static final byte[] OCTACHORD = new byte[]{60, 62, 64, 65, 67, 69, 71};
    public static final byte[] OCTACHORD_FULL = new byte[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    public static final byte tempo = 30;
    public static final byte d = 8;
    public static final byte rest = -1;
    public static final byte[] SampleMusic = new byte[]{-2, 1, -3, 30, -5, 0, 64, 8, 62, 8, 60, 8, 64, 8, 64, 8, 64, 8, 64, 8, -1, 8, -6, 0, -7, 0, 62, 8, 62, 8, 62, 8, -1, 8, 64, 8, 67, 8, 67, 8, -1, 8, -7, 0, 62, 8, 62, 8, 64, 8, 62, 8, 60, 8};
    public static final String TYPE_WAV = "audio/x-wav";
    public static final String TYPE_AU = "audio/basic";
    public static final String TYPE_MP3 = "audio/mpeg";
    public static final String TYPE_MIDI = "audio/midi";
    public static final String TYPE_TONE_SEQ = "audio/x-tone-seq";
    private Player player;
    private VolumeControl vc;
    private ToneControl tc;

    public static final void playTone(byte note, int duration, int volume) {
        try {
            Manager.playTone((int)note, (int)duration, (int)volume);
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public CSSoundPlayer() {
    }

    public CSSoundPlayer(String filename, String type, int loop) {
        try {
            InputStream is = this.getClass().getResourceAsStream(filename);
            if (is == null) {
                System.out.println("Error Loading Sound File : " + filename);
            } else {
                this.player = Manager.createPlayer((InputStream)is, (String)type);
                this.player.addPlayerListener((PlayerListener)this);
                this.player.stop();
                this.player.realize();
                this.player.prefetch();
                this.player.setLoopCount(loop);
                this.vc = (VolumeControl)this.player.getControl("VolumeControl");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public CSSoundPlayer(byte[] tone, int loop) {
        try {
            this.player = Manager.createPlayer((String)"device://tone");
            this.player.addPlayerListener((PlayerListener)this);
            this.player.stop();
            this.player.realize();
            this.player.setLoopCount(loop);
            this.vc = (VolumeControl)this.player.getControl("VolumeControl");
            this.tc = (ToneControl)this.player.getControl("ToneControl");
            this.tc.setSequence(tone);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public final Player getPlayer() {
        return this.player;
    }

    public final void replay() {
        this.pause();
        try {
            if (this.player != null && this.tc != null && this.player.getState() == 200) {
                this.player.setMediaTime(-1L);
                this.player.start();
            } else if (this.player != null && this.player.getState() == 300) {
                this.player.setMediaTime(-1L);
                this.player.start();
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public final void play() {
        try {
            if (this.player != null && this.tc != null && this.player.getState() == 200) {
                this.player.start();
            } else if (this.player != null && this.player.getState() == 300) {
                this.player.start();
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public final void pause() {
        try {
            if (this.player != null && this.player.getState() == 400) {
                this.player.stop();
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public final void resume() {
        try {
            if (this.player != null) {
                this.player.start();
            }
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public final void destroy() {
        try {
            if (this.player != null) {
                this.pause();
                this.player.stop();
                this.player.close();
                this.player = null;
            }
            if (this.tc != null) {
                this.tc = null;
            }
            if (this.vc != null) {
                this.vc = null;
            }
            System.gc();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }

    public final void setVolume(int level) {
        if (this.vc != null) {
            this.vc.setLevel(level);
        }
    }

    public final boolean isPlaying() {
        return this.player != null && this.player.getState() == 400;
    }

    public final void playerUpdate(Player player, String event, Object eventData) {
        if (event == "volumeChanged") {
            System.out.println("Volume Changed : " + this.vc.getLevel());
        }
    }
}

