/*
 * Decompiled with CFR 0.152.
 */
package com.game.Logic;

import com.game.GameMain;
import com.game.data.ComboGoods;
import com.game.data.Equipment;
import com.game.data.Goods;
import com.game.data.Loadsrc;
import com.game.data.Medicine;
import com.game.data.MissionGoods;
import com.game.data.Trick;
import com.game.rms.ContorStream;
import com.game.role.Property;
import com.game.tishi.TipBean;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class Pack {
    public static final int EQUIPMENTMAX = 1270;
    public static final byte GOODSMAX = 99;
    private Vector[] equipmentContor;
    public static Equipment[] equipment;
    public static Medicine[] medicine;
    public static Trick[] trick;
    public static MissionGoods[] missionGoods;
    public static ComboGoods[] comboGoods;
    private int moneyhas;
    GameMain gameMain;

    public static ComboGoods[] getComboGoods() {
        return comboGoods;
    }

    public Pack() {
        this.init();
    }

    public Pack(GameMain gameMain) {
        this.gameMain = gameMain;
        this.init();
    }

    public void addinit() {
        for (int i = 0; i < medicine.length; ++i) {
            Pack.medicine[i].number = 4;
        }
    }

    private void init() {
        trick = Loadsrc.loadTrick();
        missionGoods = Loadsrc.loadMissionGoods();
        medicine = Loadsrc.loadMedicine();
        comboGoods = Loadsrc.loadComboGoods();
        equipment = Loadsrc.loadEquipment();
        this.equipmentContor = new Vector[6];
    }

    public final boolean addGoods(Goods goods, int number) {
        if (this.isPackfully(goods, number)) {
            return false;
        }
        switch (goods.type) {
            case 1: {
                Equipment tem = (Equipment)goods;
                int[] equ = new int[]{tem.id, tem.wrGrade, tem.prefixID, tem.preLev, tem.wrought};
                if (this.equipmentContor[tem.goodType] == null) {
                    this.equipmentContor[tem.goodType] = new Vector(1, 1);
                    this.equipmentContor[tem.goodType].addElement(equ);
                    break;
                }
                this.equipmentContor[tem.goodType].addElement(equ);
                break;
            }
            case 0: {
                this.conterGoods(medicine, goods.id, number);
                break;
            }
            case 2: {
                this.conterGoods(missionGoods, goods.id, number);
                break;
            }
            case 3: {
                this.conterGoods(Pack.getComboGoods(), goods.id, number);
            }
        }
        return true;
    }

    public final boolean addGoods(int id, int type, int number) {
        return this.addGoods(Pack.getGoods(type, id), number);
    }

    public final boolean addGoods(int id, int type, int grade, int preNum, int perlev, int wrought) {
        Equipment equi = Equipment.getEquipment(id, type, grade, preNum, perlev, wrought);
        return this.addGoods(equi, 1);
    }

    public int getEQMentIndex(Equipment equipment) {
        for (int i = 0; i < this.equipmentContor[equipment.goodType].size(); ++i) {
            int[] equ = (int[])this.equipmentContor[equipment.goodType].elementAt(i);
            if (equ[0] != equipment.id || equ[1] != equipment.wrGrade || equ[2] != equipment.prefixID || equ[3] != equipment.preLev || equ[4] != equipment.wrought) continue;
            return i;
        }
        return -1;
    }

    public int[] getEQMentID(int type) {
        int a = 0;
        for (int i = 0; i < equipment.length; ++i) {
            if (Pack.equipment[i].goodType != type) continue;
            ++a;
        }
        if (a > 0) {
            int[] id = new int[a];
            a = 0;
            for (int i = 0; i < equipment.length; ++i) {
                if (Pack.equipment[i].goodType != type) continue;
                id[a] = Pack.equipment[i].id;
                ++a;
            }
            return id;
        }
        return null;
    }

    public final boolean removeGoods(Goods goods, int num) {
        if (goods.number <= 0 && goods.type != 1) {
            return false;
        }
        switch (goods.type) {
            case 1: {
                Equipment tem = (Equipment)goods;
                if (this.equipmentContor[tem.goodType].size() == 1) {
                    this.equipmentContor[tem.goodType] = null;
                } else {
                    int index = this.getEQMentIndex(tem);
                    if (index >= 0) {
                        this.equipmentContor[tem.goodType].removeElementAt(index);
                    } else {
                        GameMain.systemPrintln("\u79fb\u9664\u88c5\u5907\u51fa\u9519\uff01\uff01\uff01\uff01\uff01");
                    }
                }
                return true;
            }
            case 0: {
                this.conterGoods(medicine, goods.id, -num);
                return true;
            }
            case 2: {
                this.conterGoods(missionGoods, goods.id, -num);
                return true;
            }
            case 3: {
                this.conterGoods(Pack.getComboGoods(), goods.id, -num);
                return true;
            }
        }
        return false;
    }

    public final boolean removeGoods(int id, int type, int number) {
        return this.removeGoods(Pack.getGoods(type, id), number);
    }

    public final boolean removeGoods(int id, int type, int grade, int preNum, int perlev, int wrought) {
        int[] tem = new int[]{id, grade, preNum, perlev, wrought, 0, 0};
        return this.equipmentContor[type].removeElement(tem);
    }

    private final void conterGoods(Goods[] goods, int id, int num) {
        for (int i = 0; i < goods.length; ++i) {
            if (goods[i].id != id) continue;
            goods[i].number += num;
            if (num <= 0) continue;
            this.completeMission();
        }
    }

    public final int checkEquipmentNumber(int id, int type, int grade, int preNum, int perlev, int wrought) {
        Vector tem = this.equipmentContor[type];
        if (tem == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < tem.size(); ++i) {
            int[] equ = (int[])tem.elementAt(i);
            if (equ[0] != id || equ[1] != grade || equ[2] != preNum || equ[3] != perlev || equ[4] != wrought) continue;
            ++count;
        }
        return count;
    }

    public final int checkEquipmentNumber(Equipment equipment) {
        Vector tem = this.equipmentContor[equipment.goodType];
        if (tem == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < tem.size(); ++i) {
            int[] equ = (int[])tem.elementAt(i);
            if (equ[0] != equipment.id || equ[1] != equipment.wrGrade || equ[2] != equipment.prefixID || equ[3] != equipment.preLev || equ[4] != equipment.wrought) continue;
            ++count;
        }
        return count;
    }

    public final int getEquipmentIndex(int type, int index) {
        int tem = index;
        for (int i = 0; i < type; ++i) {
            tem -= this.equipmentContor[i] == null ? 0 : this.equipmentContor[i].size();
        }
        if (tem < 0) {
            tem = 0;
        }
        return tem;
    }

    private final Equipment getPackEquipment(Vector ve, int id, int lev, int pix, int pixlev, int wrought) {
        for (int i = 0; i < ve.size(); ++i) {
            int[] equ = (int[])ve.elementAt(i);
            if (equ[0] != id || equ[1] != lev || equ[2] != pix || equ[3] != pixlev || equ[4] != wrought) continue;
            for (int j = 0; j < equipment.length; ++j) {
                if (Pack.equipment[j].id != id) continue;
                return equipment[j].getEquipment(lev, pix, pixlev, wrought);
            }
        }
        return null;
    }

    public final Equipment getPackEquipment(int type, int id, int lev, int pix, int pixlev, int wrought) {
        return this.getPackEquipment(this.equipmentContor[type], id, lev, pix, pixlev, wrought);
    }

    public final Equipment getPackEquipment(int type, int id) {
        return this.getPackEquipment(type, id, 0, -1, 0, 0);
    }

    public int getMoney() {
        return this.moneyhas;
    }

    public void setMoney(int money) {
        this.moneyhas = money;
    }

    public void addMoney(int money) {
        this.moneyhas += money;
    }

    public final String useMedicine(Property property, Goods goods) {
        if (goods == null) {
            return "\u4f7f\u7528\u53d1\u751f\u9519\u8bef";
        }
        Medicine med = (Medicine)goods;
        if (med.userType == 1) {
            return "\u53ea\u80fd\u5728\u6218\u6597\u573a\u666f\u4e2d\u4f7f\u7528\uff01";
        }
        switch (med.goodType) {
            case 0: {
                if (property.getCurrenHp() < property.getMax_hp()) {
                    property.addHp(property.getMax_hp() * med.value / 100);
                    this.removeGoods(goods, 1);
                    return "\u4f7f\u7528\u6210\u529f";
                }
                return "\u8840\u5df2\u6ee1\uff0c\u4f7f\u7528\u5931\u8d25";
            }
            case 1: {
                if (property.getCurrenMp() < property.getMax_mp()) {
                    property.addMp(property.getMax_mp() * med.value / 100);
                    this.removeGoods(goods, 1);
                    return "\u4f7f\u7528\u6210\u529f";
                }
                return "\u7075\u529b\u5df2\u6ee1\uff0c\u4f7f\u7528\u5931\u8d25";
            }
            case 3: {
                switch (med.spice) {
                    case 5: {
                        Property.intiProperty(property);
                        this.removeGoods(goods, 1);
                        return "\u4f7f\u7528\u6210\u529f \u5c5e\u6027\u70b9\u5df2\u91cd\u7f6e";
                    }
                    case 4: {
                        property.resetTrickPoint();
                        this.removeGoods(goods, 1);
                        return "\u4f7f\u7528\u6210\u529f \u6280\u80fd\u70b9\u5df2\u91cd\u7f6e";
                    }
                    case 3: {
                        return "\u4e0d\u80fd\u4f7f\u7528\uff01";
                    }
                }
            }
        }
        return "\u4e0d\u80fd\u4f7f\u7528\uff01";
    }

    public final int useEquipment(Equipment equip, int index, int posIndex, Property property) {
        if (equip.grade > property.getGrade()) {
            if (GameMain.unlevequ > 0) {
                if (equip.pId > 0 && equip.pId != property.roleID) {
                    return 0;
                }
                GameMain.saveMsg();
                this.showTip(new String[]{"\u5df2\u4f7f\u75281\u6b21\u6d88\u9664\u88c5\u5907\u7b49\u7ea7\u9650\u5b9a\uff0c\u8fd8\u5269" + --GameMain.unlevequ + "\u6b21"});
                Equipment tem = null;
                tem = equip.goodType == 5 ? property.addPmenf(equip, posIndex) : property.addEquipment(equip, posIndex);
                if (tem == null) {
                    equip.isUse = true;
                    property.equipProperty(equip);
                    if (equip.goodType != 5) {
                        this.removeGoods(equip, 0);
                    }
                } else {
                    property.untilProperty(tem);
                    property.equipProperty(equip);
                    equip.isUse = true;
                    tem.isUse = false;
                    if (equip.goodType != 5) {
                        this.removeGoods(equip, 0);
                        this.addGoods(tem, index);
                    }
                }
                return 2;
            }
            return 1;
        }
        if (equip.pId > 0 && equip.pId != property.roleID) {
            return 0;
        }
        Equipment tem = null;
        tem = equip.goodType == 5 ? property.addPmenf(equip, posIndex) : property.addEquipment(equip, posIndex);
        if (tem == null) {
            equip.isUse = true;
            property.equipProperty(equip);
            if (equip.goodType != 5) {
                this.removeGoods(equip, 0);
            }
        } else {
            property.untilProperty(tem);
            property.equipProperty(equip);
            equip.isUse = true;
            tem.isUse = false;
            if (equip.goodType != 5) {
                this.removeGoods(equip, 0);
                this.addGoods(tem, index);
            }
        }
        return 2;
    }

    public final int useEquipment(Equipment equip, Property property, int posIndex) {
        return this.useEquipment(equip, this.getEQMentIndex(equip), posIndex, property);
    }

    public final int useEquipment(Equipment equip, Property property) {
        return this.useEquipment(equip, this.getEQMentIndex(equip), equip.goodType, property);
    }

    public boolean untilEquipment(int type, int posIndex, Property property) {
        Equipment tem = null;
        tem = type == 5 ? property.addPmenf(null, posIndex) : property.addEquipment(null, posIndex);
        property.untilProperty(tem);
        tem.isUse = false;
        if (tem.goodType != 5) {
            this.addGoods(tem, 0);
        }
        return true;
    }

    public boolean untilEquipmentF(int id, Property property) {
        for (int i = 0; i < property.getPmenf().length; ++i) {
            if (property.getPmenf()[i] == null || property.getPmenf()[i].id != id) continue;
            return this.untilEquipment(5, i, property);
        }
        return false;
    }

    public final Trick[] getYTrick(Property property) {
        return property.trick;
    }

    public final int gradeTrick(Property property, int index) {
        Trick tem = property.getTrick(index);
        if (tem.grade >= 3) {
            return 2;
        }
        return 0;
    }

    private final Equipment[] getEquipment(Vector equcont) {
        Vector<Equipment> tem = new Vector<Equipment>(5, 2);
        if (equcont == null) {
            return null;
        }
        block0: for (int i = 0; i < equcont.size(); ++i) {
            int[] equ = (int[])equcont.elementAt(i);
            for (int j = 0; j < equipment.length; ++j) {
                if (equ[0] != Pack.equipment[j].id) continue;
                if (Pack.equipment[j].goodType == 5) {
                    tem.addElement(equipment[j]);
                    continue block0;
                }
                tem.addElement(equipment[j].getEquipment(equ[1], equ[2], equ[3], equ[4]));
                continue block0;
            }
        }
        if (tem.size() == 0) {
            return null;
        }
        Equipment[] eq = new Equipment[tem.size()];
        for (int i = 0; i < tem.size(); ++i) {
            eq[i] = (Equipment)tem.elementAt(i);
        }
        return eq;
    }

    public Equipment[] getEquipment(int type) {
        return this.getEquipment(this.equipmentContor[type]);
    }

    private final void getGoods(Vector ve, Goods[] goods) {
        for (int i = 0; i < goods.length; ++i) {
            if (goods[i].number <= 0) continue;
            ve.addElement(goods[i].getGoods(goods[i].number));
        }
    }

    public final Medicine[] getFightMedicine() {
        Goods[] goods = this.getGoodsS(0);
        if (goods == null) {
            return null;
        }
        Vector<Goods> tem = new Vector<Goods>(5, 1);
        for (int i = 0; i < goods.length; ++i) {
            if (goods[i].userRestrained == 0 && goods[i].userRestrained == 3) continue;
            tem.addElement(goods[i]);
        }
        Medicine[] med = new Medicine[tem.size()];
        for (int i = 0; i < med.length; ++i) {
            med[i] = (Medicine)tem.elementAt(i);
        }
        return med;
    }

    private final Goods[] getGoodsS(int etype) {
        Vector tem = new Vector(5, 2);
        switch (etype) {
            case 0: {
                this.getGoods(tem, medicine);
                break;
            }
            case 1: {
                return this.getAllEquipment();
            }
            case 2: {
                this.getGoods(tem, missionGoods);
                break;
            }
            case 3: {
                this.getGoods(tem, Pack.getComboGoods());
            }
        }
        if (tem.size() == 0) {
            return null;
        }
        Goods[] temGoods = new Goods[tem.size()];
        for (int i = 0; i < temGoods.length; ++i) {
            temGoods[i] = (Goods)tem.elementAt(i);
        }
        return temGoods;
    }

    public final Goods[] getPackGoods(int type) {
        return this.getGoodsS(type);
    }

    private static final Goods getGoods(Goods[] goods, int id) {
        for (int i = 0; i < goods.length; ++i) {
            if (goods[i].id != id) continue;
            return goods[i];
        }
        return null;
    }

    public static final Goods getGoods(int type, int id) {
        switch (type) {
            case 3: {
                return Pack.getGoods(Pack.getComboGoods(), id);
            }
            case 0: {
                return Pack.getGoods(medicine, id);
            }
            case 2: {
                return Pack.getGoods(missionGoods, id);
            }
            case 1: {
                return Pack.getGoods(equipment, id);
            }
        }
        return null;
    }

    public final boolean dropGoods(Goods goods, int num) {
        if (goods.couldDrop()) {
            this.removeGoods(goods, num);
            return true;
        }
        return false;
    }

    public final Equipment getThisEquipment(int type, int posIndex, Property property) {
        if (type == 5) {
            return property.getPmenf(posIndex);
        }
        return property.getEquipment(posIndex);
    }

    private static final void sort(int[][] eq) {
        for (int i = 0; i < eq.length; ++i) {
            for (int j = eq.length - 1; j > i; --j) {
                int[] tem;
                if (eq[j][2] != 0) continue;
                if (eq[j][0] > eq[i][0]) {
                    tem = eq[i];
                    eq[i] = eq[j];
                    eq[j] = tem;
                    continue;
                }
                if (eq[j][0] != eq[i][0] || eq[j][1] <= eq[i][1]) continue;
                tem = eq[i];
                eq[i] = eq[j];
                eq[j] = tem;
            }
        }
    }

    public final Goods getPackGoods(int type, int id) {
        Goods[] good = this.getGoodsS(type);
        if (good == null) {
            return null;
        }
        for (int i = 0; i < good.length; ++i) {
            if (good[i].id != id) continue;
            return good[i];
        }
        return null;
    }

    private final Equipment[] getAllEquipment() {
        Equipment[][] tem = new Equipment[5][];
        int len = 0;
        for (int i = 0; i < tem.length; ++i) {
            tem[i] = this.getEquipment(this.equipmentContor[i]);
            if (tem[i] == null) continue;
            len += tem[i].length;
        }
        if (len == 0) {
            return null;
        }
        Equipment[] tem6 = new Equipment[len];
        int a = 0;
        for (int i = 0; i < tem.length; ++i) {
            if (tem[i] == null) continue;
            for (int j = 0; j < tem[i].length; ++j) {
                tem6[a + j] = tem[i][j];
            }
            a += tem[i].length;
        }
        return tem6;
    }

    public final Goods[] getComboGoodsCouldSell(int subType) {
        return this.getPackGoods(3);
    }

    public final Goods[] getShopComboGoods(int subType) {
        return this.getShopGoods(3);
    }

    public final Goods[] getEquipmentCouldSell(int[] type) {
        Equipment[][] tem = new Equipment[type.length][];
        int len = 0;
        for (int i = 0; i < tem.length; ++i) {
            tem[i] = this.getEquipment(this.equipmentContor[type[i]]);
            if (tem[i] == null) continue;
            len += tem[i].length;
        }
        if (len == 0) {
            return null;
        }
        Goods[] tem6 = new Equipment[len];
        int a = 0;
        for (int i = 0; i < tem.length; ++i) {
            if (tem[i] == null) continue;
            for (int j = 0; j < tem[i].length; ++j) {
                tem6[a + j] = tem[i][j];
            }
            a += tem[i].length;
        }
        return this.addGoodsArr(tem6, null);
    }

    public Goods[] getShopEquipment(int[] type) {
        Vector<Equipment> tem = new Vector<Equipment>(5, 2);
        block0: for (int i = 0; i < equipment.length; ++i) {
            for (int j = 0; j < type.length; ++j) {
                if (Pack.equipment[i].goodType != type[j] || !equipment[i].couldBuy()) continue;
                tem.addElement(equipment[i].getEquipment(0, -1, 0, 0));
                continue block0;
            }
        }
        if (tem.size() == 0) {
            return null;
        }
        Goods[] eq = new Equipment[tem.size()];
        for (int i = 0; i < tem.size(); ++i) {
            eq[i] = (Equipment)tem.elementAt(i);
        }
        return this.addGoodsArr(eq, null);
    }

    private Goods[] addGoodsArr(Goods[] goods1, Goods[] goods2) {
        if (goods1 == null && goods2 == null) {
            return null;
        }
        if (goods1 == null) {
            return goods2;
        }
        if (goods2 == null) {
            return goods1;
        }
        Goods[] good = new Goods[goods1.length + goods2.length];
        for (int i = 0; i < good.length; ++i) {
            good[i] = i <= goods1.length - 1 ? goods1[i] : goods2[i - goods1.length];
        }
        return good;
    }

    public final Goods[] getShopGoods(int type) {
        switch (type) {
            case 3: {
                return this.getShopGoods(Pack.getComboGoods());
            }
            case 0: {
                return this.addGoodsArr(this.getShopGoods(medicine), null);
            }
            case 2: {
                return this.getShopGoods(missionGoods);
            }
            case 1: {
                return this.getShopGoods(equipment);
            }
        }
        return null;
    }

    private final Goods[] getShopGoods(Goods[] goods) {
        Vector<Goods> tem = new Vector<Goods>(6, 1);
        for (int i = 0; i < goods.length; ++i) {
            switch (goods[i].contor) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    tem.addElement(goods[i].getGoods(0));
                }
            }
        }
        if (tem.size() == 0) {
            return null;
        }
        Goods[] med = new Goods[tem.size()];
        for (int i = 0; i < med.length; ++i) {
            med[i] = (Goods)tem.elementAt(i);
        }
        return med;
    }

    public static final Trick getTrick(int id) {
        for (int i = 0; i < trick.length; ++i) {
            if (Pack.trick[i].id != id) continue;
            return trick[i];
        }
        return null;
    }

    public static Trick[] getTrick() {
        return trick;
    }

    public final void clearData() {
        this.equipmentContor = null;
        this.equipmentContor = new Vector[6];
        Pack.clearGood(comboGoods);
        Pack.clearGood(equipment);
        Pack.clearGood(medicine);
        Pack.clearGood(missionGoods);
    }

    private static final void clearGood(Goods[] goods) {
        for (int i = 0; i < goods.length; ++i) {
            goods[i].number = 0;
        }
    }

    public final void destroy() {
        comboGoods = null;
        equipment = null;
        medicine = null;
        missionGoods = null;
        trick = null;
        for (int i = 0; i < this.equipmentContor.length; ++i) {
            if (this.equipmentContor[i] == null) continue;
            this.equipmentContor[i].removeAllElements();
            this.equipmentContor[i] = null;
        }
        this.equipmentContor = null;
        System.gc();
    }

    public final boolean isPackfully(Goods goods, int num) {
        switch (goods.type) {
            case 0: 
            case 2: 
            case 3: {
                return goods.number + num > 99;
            }
            case 1: {
                int len = 0;
                for (int i = 0; i < this.equipmentContor.length; ++i) {
                    if (this.equipmentContor[i] == null) continue;
                    len += this.equipmentContor[i].size();
                }
                return len + num >= 1270;
            }
        }
        return false;
    }

    private static final int[][] getEquipmentContor(Vector ve) {
        if (ve == null) {
            return null;
        }
        int[][] tem = new int[ve.size()][];
        for (int i = 0; i < ve.size(); ++i) {
            int[] tem1;
            tem[i] = tem1 = (int[])ve.elementAt(i);
        }
        return tem;
    }

    private static final Vector setEquipmentContor(int[][] data) {
        if (data == null) {
            return null;
        }
        Vector<int[]> tem = new Vector<int[]>(5, 1);
        for (int i = 0; i < data.length; ++i) {
            tem.addElement(data[i]);
        }
        return tem;
    }

    public static final void setPackData(DataInputStream dis, Pack pack) {
        try {
            for (int i = 0; i < pack.equipmentContor.length; ++i) {
                pack.equipmentContor[i] = Pack.setEquipmentContor(ContorStream.toByte2Array(dis));
            }
            int len = dis.readByte();
            for (int i = 0; i < len; ++i) {
                short id = dis.readShort();
                System.out.println("id:" + id);
                ((Equipment)Pack.getGoods((int)1, (int)id)).isUse = dis.readBoolean();
            }
            ContorStream.toByte1GoodsArray(dis, 0, pack);
            ContorStream.toByte1GoodsArray(dis, 3, pack);
            ContorStream.toByte1GoodsArray(dis, 2, pack);
            pack.setMoney(dis.readInt());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void getPackData(DataOutputStream dos, Pack pack) {
        try {
            for (int i = 0; i < pack.equipmentContor.length; ++i) {
                ContorStream.to2ArrayByte(dos, Pack.getEquipmentContor(pack.equipmentContor[i]));
            }
            int[] id = pack.getEQMentID(5);
            dos.writeByte(id.length);
            for (int i = 0; i < id.length; ++i) {
                Equipment goods = (Equipment)Pack.getGoods(1, id[i]);
                dos.writeShort(goods.id);
                dos.writeBoolean(goods.isUse);
                System.out.println("id:" + goods.id + "isUse:" + goods.isUse);
            }
            ContorStream.to1GoodsArrayByte(dos, pack.getPackGoods(0));
            ContorStream.to1GoodsArrayByte(dos, pack.getPackGoods(3));
            ContorStream.to1GoodsArrayByte(dos, pack.getPackGoods(2));
            dos.writeInt(pack.getMoney());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public int getPackGoodsNum(int type, int id) {
        Goods goods = this.getPackGoods(type, id);
        if (goods == null) {
            return 0;
        }
        return goods.number;
    }

    public void completeMission() {
    }

    private void showTip(String[] str) {
        TipBean tishiBean = new TipBean();
        tishiBean.setTipMessage(str);
        tishiBean.setTipType((byte)1);
        tishiBean.setPalyerType((byte)2);
        this.gameMain.mapManager.setTip(tishiBean);
    }
}

