/*
 * Decompiled with CFR 0.152.
 */
package com.game.Logic;

import com.game.map.MapManager;
import com.game.rms.ContorStream;
import com.game.role.Player;
import com.game.role.Property;
import com.util.Tools;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class Team {
    private Player[] teamPlayer;
    private int leader;
    private Vector propertys;
    private int[] fightTeamList;
    private static final int FIGHTNUMBER = 3;
    private int[] teamList;

    public final void setDefaultTeam(MapManager mapManager) {
        Player player = new Player(mapManager, 10);
        player.loadPlayer();
        player.property = Property.createProperty(10);
        this.inTeam(player);
    }

    public final Player getLeader() {
        if (this.teamPlayer != null) {
            return this.teamPlayer[0];
        }
        return null;
    }

    public final void inTeam(Player player) {
        if (this.teamPlayer == null) {
            this.teamPlayer = new Player[1];
            this.leader = player.getRoleID();
            this.teamPlayer[0] = player;
            if (this.propertys == null) {
                this.propertys = new Vector(1, 1);
                this.propertys.addElement(player.property);
            } else {
                this.setPropertys(player.property);
            }
            this.inFight(this.leader);
        } else {
            int index = this.getTeamPlayerIndex(player);
            if (index < 0) {
                Player[] tem = this.teamPlayer;
                this.teamPlayer = new Player[this.teamPlayer.length + 1];
                System.arraycopy(tem, 0, this.teamPlayer, 0, tem.length);
                this.teamPlayer[this.teamPlayer.length - 1] = player;
                this.setPropertys(player.property);
                this.inFight(player.getRoleID());
            }
        }
        this.teamList = this.getTeamList1();
    }

    public final void setPropertys(Property property) {
        int index = this.propertys.indexOf(property);
        if (index == -1) {
            this.propertys.addElement(property);
        } else {
            Property tem = (Property)this.propertys.elementAt(index);
            Property property2 = property;
        }
    }

    public final void addAllPropertys() {
        for (int i = 0; i < this.teamPlayer.length; ++i) {
            this.setPropertys(this.teamPlayer[i].property);
        }
    }

    private final int getTeamPlayerIndex(Player player) {
        int count = -1;
        for (int i = 0; i < this.teamPlayer.length; ++i) {
            if (this.teamPlayer[i].getRoleID() != player.getRoleID()) continue;
            count = i;
        }
        return count;
    }

    private final int getTeamPlayerIndex(int roleID) {
        int count = -1;
        for (int i = 0; i < this.teamPlayer.length; ++i) {
            if (this.teamPlayer[i].getRoleID() != roleID) continue;
            count = i;
        }
        return count;
    }

    private final int getFightIndex(int roleID) {
        int count = -1;
        for (int i = 0; i < this.fightTeamList.length; ++i) {
            if (this.fightTeamList[i] != roleID) continue;
            count = i;
        }
        return count;
    }

    public final Property getProperty(int roleID) {
        if (this.propertys == null) {
            return null;
        }
        for (int i = 0; i < this.propertys.size(); ++i) {
            Property tem = (Property)this.propertys.elementAt(i);
            if (tem.roleID != roleID) continue;
            return tem;
        }
        return null;
    }

    public final int getSize() {
        return this.teamPlayer.length;
    }

    public final void outTeam(int roleID) {
        if (this.teamPlayer != null) {
            int index = this.getTeamPlayerIndex(roleID);
            if (index < 0) {
                return;
            }
            this.outFight(roleID);
            if (this.teamPlayer.length == 1) {
                this.teamPlayer = null;
                return;
            }
            this.teamPlayer[index] = null;
            this.resetSrot();
            Player[] tem = this.teamPlayer;
            this.teamPlayer = new Player[this.teamPlayer.length - 1];
            System.arraycopy(tem, 0, this.teamPlayer, 0, tem.length - 1);
        }
    }

    private final void resetSrot() {
        for (int i = 0; i < this.teamPlayer.length; ++i) {
            if (this.teamPlayer[i] != null && this.leader == this.teamPlayer[i].getRoleID() && i != 0) {
                Player tem = this.teamPlayer[0];
                this.teamPlayer[0] = this.teamPlayer[i];
                this.teamPlayer[i] = tem;
            }
            if (this.teamPlayer[i] != null || i == this.teamPlayer.length - 1) continue;
            this.teamPlayer[i] = this.teamPlayer[i + 1];
            this.teamPlayer[i + 1] = null;
        }
        this.leader = this.teamPlayer[0].getRoleID();
    }

    public final void inFight(int roleID) {
        if (this.fightTeamList != null && this.fightTeamList.length == 3) {
            return;
        }
        if (this.fightTeamList == null) {
            this.fightTeamList = new int[1];
            this.fightTeamList[0] = roleID;
        } else {
            int index = this.getFightIndex(roleID);
            if (index < 0) {
                this.fightTeamList = Tools.eXPandArray(this.fightTeamList, 1);
                this.fightTeamList[this.fightTeamList.length - 1] = roleID;
            }
        }
        this.resetFightList();
    }

    public final void inAllFight() {
        this.fightTeamList = null;
        int[] tem = this.getTeamList();
        if (tem.length > 3) {
            this.fightTeamList = new int[3];
            for (int i = 0; i < 3; ++i) {
                this.fightTeamList[i] = tem[i];
            }
        } else {
            this.fightTeamList = this.getTeamList();
        }
        this.resetFightList();
    }

    public final void outFight(int roleID) {
        if (this.fightTeamList.length == 1) {
            this.fightTeamList = null;
            return;
        }
        int index = this.getFightIndex(roleID);
        if (index < 0) {
            return;
        }
        this.fightTeamList[index] = -1;
        this.resetFightList();
        this.fightTeamList = Tools.eXPandArray(this.fightTeamList, -1);
    }

    public final int getFightNumber() {
        return this.fightTeamList.length;
    }

    private final void resetFightList() {
        int i;
        for (i = 0; i < this.fightTeamList.length; ++i) {
            if (this.fightTeamList[i] != -1 || i == this.fightTeamList.length - 1) continue;
            this.fightTeamList[i] = this.fightTeamList[i + 1];
            this.fightTeamList[i + 1] = -1;
        }
        if (this.fightTeamList.length >= 3) {
            for (i = 0; i < this.fightTeamList.length; ++i) {
                if (this.fightTeamList[i] != this.leader) continue;
                int tem = this.fightTeamList[i];
                this.fightTeamList[i] = this.fightTeamList[1];
                this.fightTeamList[1] = tem;
                break;
            }
        }
    }

    public final int[] getTeamList() {
        return this.teamList;
    }

    public final void setLeader(int roleID) {
        this.leader = roleID;
        this.resetSrot();
        this.outFight(this.fightTeamList[this.fightTeamList.length - 1]);
        this.inFight(roleID);
    }

    public final int getLeaderID() {
        return this.leader;
    }

    public final void removePlayer() {
        this.teamList = this.getTeamList1();
        this.addAllPropertys();
        this.teamPlayer = null;
    }

    public final void addPlayerToTeamList(MapManager mapManager) {
        this.teamPlayer = new Player[this.teamList.length];
        for (int i = 0; i < this.teamList.length; ++i) {
            Player player = new Player(mapManager, this.teamList[i]);
            player.property = this.getProperty(this.teamList[i]);
            this.teamPlayer[i] = player;
        }
        this.teamPlayer[0].loadPlayer();
    }

    private final int[] getTeamList1() {
        int[] tem = new int[this.teamPlayer.length];
        for (int i = 0; i < this.teamPlayer.length; ++i) {
            tem[i] = this.teamPlayer[i].getRoleID();
        }
        return tem;
    }

    public static final void getTeam(DataOutputStream dos, Team team) {
        try {
            dos.writeByte(team.propertys.size());
            for (int i = 0; i < team.propertys.size(); ++i) {
                Property.getProperty(dos, (Property)team.propertys.elementAt(i));
            }
            ContorStream.to1ArrayByte(dos, team.getTeamList());
            ContorStream.to1ArrayByte(dos, team.fightTeamList);
            dos.writeShort(team.getLeader().getX());
            dos.writeShort(team.getLeader().getY());
            dos.writeByte(team.getLeader().dir);
            dos.writeInt(team.leader);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void setTeam(MapManager mapManager, DataInputStream dis, Team team) {
        try {
            int len = dis.readByte();
            team.propertys = new Vector();
            for (int i = 0; i < len; ++i) {
                Property property = new Property();
                Property.setProperty(dis, property);
                team.propertys.addElement(property);
            }
            team.teamList = ContorStream.toByte1Array(dis);
            team.addPlayerToTeamList(mapManager);
            team.fightTeamList = null;
            team.fightTeamList = ContorStream.toByte1Array(dis);
            MapManager.tempPlayerX = dis.readShort();
            MapManager.tempPlayerY = dis.readShort();
            MapManager.tempPlayerDir = dis.readByte();
            team.leader = dis.readInt();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public final void destroy() {
        this.teamPlayer = null;
        if (this.propertys != null) {
            this.propertys.removeAllElements();
        }
        this.propertys = null;
        this.fightTeamList = null;
    }

    public final int[] getFightTeamList() {
        return this.fightTeamList;
    }
}

