/*
 * Decompiled with CFR 0.152.
 */
package com.game.data;

import com.game.Logic.Pack;
import com.game.data.Data;
import com.game.role.Property;

public class Trick
extends Data {
    public static final int MAXGRADE = 3;
    public static final int AIM = 1;
    public static final int CAST = 2;
    public int[][] buff;
    public static final int TYPEONE = 0;
    public static final int TYPECOLONY = 1;
    public static final int TYPEGROUP = 2;
    public int trickArea = 0;
    public int aimNumber;
    public static final int TRICKACT = 1;
    public static final int TRICKFUZHU = 2;
    public static final int MEDTRICK = 3;
    public static final int ELEMENTFENG = 1;
    public static final int ELEMENTSHUI = 2;
    public static final int ELEMENTHUO = 3;
    public static final int ELEMENTTU = 4;
    public static final int ELEMENTNONE = 0;
    public int elementType = 0;
    public int speciID;
    public int value;
    int maxSkill;
    public int currenSkill;
    public int nextID;
    public int expendMp;
    public int grade;

    public static String getElement(int element) {
        switch (element) {
            case 0: {
                break;
            }
            case 1: {
                return "\u5143\u7d20\uff1a\u81ea\u7136\u7cfb\u3002";
            }
            case 2: {
                return "\u5143\u7d20\uff1a\u6c34\u7cfb\u3002";
            }
            case 3: {
                return "\u5143\u7d20\uff1a\u706b\u7cfb\u3002";
            }
            case 4: {
                return "\u5143\u7d20\uff1a\u65e0\u3002";
            }
        }
        return "\u5143\u7d20\uff1a\u65e0\u3002";
    }

    public static String getArea(int type) {
        switch (type) {
            case 0: {
                return "\u5355\u4f53\u3002";
            }
            case 1: {
                return "\u53cc\u4f53\u3002";
            }
            case 2: {
                return "\u5168\u4f53\u3002";
            }
        }
        return "";
    }

    public static String getType(int type) {
        switch (type) {
            case 1: {
                return "\u653b\u51fb\u578b\u6280\u80fd\u3002";
            }
            case 2: {
                return "\u8f85\u52a9\u578b\u6280\u80fd\u3002";
            }
            case 3: {
                return "\u653b\u51fb\u8f85\u52a9\u578b\u6280\u80fd\u3002";
            }
        }
        return "";
    }

    public static String getGrade(int grade) {
        switch (grade) {
            case 1: {
                return "\u521d\u7ea7";
            }
            case 2: {
                return "\u4e2d\u7ea7";
            }
            case 3: {
                return "\u9ad8\u7ea7";
            }
        }
        return "";
    }

    public String getExplain(Property p) {
        StringBuffer sb = new StringBuffer();
        int g = p.getTrickGrade(this.id);
        if (g > 0 && g < 3) {
            sb.append("\u719f\u7ec3\u5ea6:" + this.currenSkill + "/" + this.maxSkill + "\n");
        }
        sb.append("\u7c7b\u578b:" + Trick.getType(this.type) + "\n");
        sb.append("\u8303\u56f4:" + Trick.getArea(this.trickArea) + "\n");
        sb.append("\u6280\u80fd" + Trick.getElement(this.elementType) + "\n");
        sb.append("\u6d88\u8017\u7075\u529b:" + this.expendMp + "\n");
        if (this.value > 0) {
            sb.append("\u57fa\u672c\u6548\u679c\u503c:" + this.value + "\n");
        }
        Trick trick = Pack.getTrick(this.id);
        sb.append(trick.explain);
        return sb.toString();
    }

    private final String getExplain() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + "(" + Trick.getGrade(this.grade) + ")" + "\uff1a\n");
        sb.append("\u8303\u56f4:" + Trick.getArea(this.trickArea) + "\n");
        sb.append("\u6280\u80fd" + Trick.getElement(this.elementType) + "\n");
        sb.append("\u6d88\u8017\u7075\u529b:" + this.expendMp + "\n");
        if (this.value > 0) {
            sb.append("\u57fa\u672c\u6548\u679c\u503c:" + this.value + "\n");
        }
        sb.append(this.explain);
        return sb.toString();
    }

    private final String getExplainA() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name + "(" + Trick.getGrade(this.grade) + ")" + "\uff1a\n");
        sb.append("\u8303\u56f4:" + Trick.getArea(this.trickArea) + "\n");
        sb.append("\u6280\u80fd" + Trick.getElement(this.elementType) + "\n");
        sb.append("\u6d88\u8017\u7075\u529b:" + this.expendMp + "\n");
        if (this.value > 0) {
            sb.append("\u57fa\u672c\u6548\u679c\u503c:" + this.value + "\n");
        }
        sb.append(this.explain);
        return sb.toString();
    }

    public final void addCurrenSkill(int skill) {
        if (this.grade <= 0) {
            return;
        }
        if (this.grade < 2) {
            this.currenSkill += skill;
        }
    }

    public final int getAimNumber() {
        if (this.grade <= 0) {
            return 0;
        }
        return this.aimNumber;
    }

    public final int getHurt(Property p) {
        int a = p.getAptitude() * 2 + p.getElf();
        int b = a * this.value * this.grade;
        return b / 1500 + this.value;
    }

    public final Trick getSJTick() {
        if (this.nextID != 0 && this.currenSkill >= this.maxSkill) {
            return Pack.getTrick(this.nextID).getTick(0);
        }
        return null;
    }

    public final Trick getTick(int currenSkill) {
        Trick trick = new Trick();
        trick.id = this.id;
        trick.name = this.name;
        trick.type = this.type;
        trick.explain = this.getExplain();
        trick.elementType = this.elementType;
        trick.iconIndex = this.iconIndex;
        trick.fontColor = this.fontColor;
        trick.buff = this.buff;
        trick.grade = this.grade;
        trick.expendMp = this.expendMp;
        trick.value = this.value;
        trick.currenSkill = currenSkill;
        trick.maxSkill = this.maxSkill;
        trick.trickArea = this.trickArea;
        trick.aimNumber = this.aimNumber;
        trick.nextID = this.nextID;
        trick.speciID = this.speciID;
        trick.trickArea = this.trickArea;
        return trick;
    }
}

