/*
 * Decompiled with CFR 0.152.
 */
package com.game.fight;

import com.MainCanvas;
import com.game.GameMain;
import com.game.Logic.Pack;
import com.game.data.Data;
import com.game.data.Goods;
import com.game.fight.Buff;
import com.game.fight.FightLogic;
import com.game.fight.FightManager;
import com.game.fight.Hero;
import com.game.lib.MyClip;
import com.game.map.ui.lib.Menu;
import com.game.map.ui.lib.MenuListener;
import com.util.Tools;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FightUI
implements MenuListener {
    private FightManager fightManager;
    private FightLogic logic;
    private Pack pack;
    private Data[] data;
    int state;
    static final int MENU = 10;
    static final int ACT = 0;
    static final int RUN = 1;
    static final int SELECT = 11;
    Hero[] enemy;
    private int[][] gezi;
    private int col;
    private int rows;
    private int currenCol;
    private int currenRows;
    private int pageSize;
    private int currenPage;
    private Vector resLog;
    private int[] ppp;
    private int number;
    private Image[] img1;
    private boolean isShop;
    private MyClip hand;
    int selectIndex;
    private Menu menu;
    private Image buffIcon;
    private Image stateFrame;
    private Image bloodFrame;
    private Image num;
    private Hero currenPlayer;
    private Hero[] currenFangz;
    private Hero[] player;

    FightUI(FightManager fightManager, int state) {
        this.fightManager = fightManager;
        this.logic = fightManager.logic;
        this.pack = fightManager.gameMain.getPack();
        this.player = this.logic.getHero(1);
        this.enemy = this.logic.getHero(2);
        this.currenPlayer = this.player[0];
        this.currenFangz = this.player;
        this.num = Tools.loadImage("/res/ui/num4.png");
        this.intiUI(state, this.selectIndex);
    }

    FightUI(FightManager fightManager) {
        this(fightManager, 10);
    }

    void intiUI(int state, int selectIndex) {
        this.state = state;
        this.currenFangz = this.player;
        switch (state) {
            case 10: {
                if (this.menu == null) {
                    this.menu = new Menu(this, new String[]{"\u653b\u51fb", "\u6280\u80fd", "\u9053\u5177", "\u9003\u8dd1", "\u5546\u57ce", "\u9632\u5fa1"}, 1);
                }
                this.setSelectIndex(selectIndex);
            }
        }
    }

    private void setGezi() {
        this.gezi = null;
        this.currenPage = 0;
        this.currenCol = 0;
        this.currenRows = 0;
        this.rows = 0;
        this.col = 0;
        this.pageSize = 0;
        this.col = 2;
        this.rows = 4;
        this.gezi = new int[this.col][this.rows];
        for (int i = 0; i < this.col; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                this.gezi[i][j] = 0;
            }
        }
        if (this.data != null) {
            this.pageSize = Tools.returnNum(this.data.length, this.col * this.rows);
        }
    }

    private final void back() {
        if (this.resLog != null && this.resLog.size() > 0) {
            int[] tem = (int[])this.resLog.elementAt(this.resLog.size() - 1);
            this.selectIndex = tem[2];
            this.player[this.selectIndex].def = false;
            this.player[this.selectIndex].contor = null;
            this.player[this.selectIndex].removeBuff(this.player[this.selectIndex].getBuff(33));
            if (this.player[this.selectIndex].medice != null) {
                this.pack.addGoods(this.player[this.selectIndex].medice, 1);
                this.player[this.selectIndex].medice = null;
            }
            this.intiUI(tem[0], tem[1]);
            this.resLog.removeElement(tem);
        }
    }

    private final void addResLog(int state, int selectIndex, int posIndex) {
        if (this.resLog == null) {
            this.resLog = new Vector(1, 1);
            this.resLog.addElement(new int[]{state, selectIndex, posIndex});
        } else {
            this.resLog.addElement(new int[]{state, selectIndex, posIndex});
        }
    }

    public boolean keyPressedItem(int key) {
        if (!this.isShop && key == 18) {
            this.back();
            return false;
        }
        switch (this.state) {
            case 10: {
                if (this.menu == null) break;
                this.menu.keyPressedItem(key);
                break;
            }
            case 11: {
                this.keySelect(key);
            }
        }
        return false;
    }

    private final void keyShop(int key) {
        switch (key) {
            case 15: {
                if (this.number <= 0) break;
                --this.number;
                break;
            }
            case 16: {
                if (!this.couldAddNumber(false, this.number, (Goods)this.data[this.getSelectIndex()])) break;
                ++this.number;
                break;
            }
            case 18: {
                this.isShop = false;
                this.number = 0;
                break;
            }
            case 17: 
            case 19: {
                if (this.number <= 0) break;
            }
        }
    }

    private final void keySelect(int key) {
        switch (key) {
            case 14: {
                this.selectIndex = this.logic.getSelectIndex(this.currenFangz, this.selectIndex, 1);
                break;
            }
            case 13: {
                this.selectIndex = this.logic.getSelectIndex(this.currenFangz, this.selectIndex, 0);
                break;
            }
            case 19: {
                this.itemContor(this.selectIndex);
            }
        }
    }

    private void drawShopNumber(Graphics g, boolean sell) {
        if (this.ppp == null) {
            this.ppp = new int[3];
        }
        if (this.img1 == null) {
            this.img1 = new Image[]{Tools.loadImage("/res/ui/danwei.png"), Tools.loadImage("/res/ui/item.png"), Tools.loadImage("/res/ui/num4.png"), Tools.loadImage("/res/ui/or.png"), Tools.loadImage("/res/ui/yunbao.png")};
        }
        int hh = 110;
        int ww = 120;
        int xx = 240 - ww >> 1;
        int yy = 320 - hh - 40 >> 1;
        Goods good = (Goods)this.data[this.getSelectIndex()];
        int pr = good.price;
        GameMain.frame.drawmFrameForNormalLine(g, xx, yy, ww, hh);
        Tools.ImageClip(g, this.img1[3], xx + ww - 5 - this.img1[3].getWidth() / 2, yy + hh - 5 - this.img1[3].getHeight(), this.img1[3].getWidth() / 2, this.img1[3].getHeight(), 1, 1);
        Tools.ImageClip(g, this.img1[3], xx + 5, yy + hh - 5 - this.img1[3].getHeight(), this.img1[3].getWidth() / 2, this.img1[3].getHeight(), 0, 1);
        yy += 15;
        for (int i = 0; i < 3; ++i) {
            Tools.ImageClip(g, this.img1[0], xx + 35, yy, this.img1[0].getWidth() / 3, this.img1[0].getHeight(), i, 1);
            Tools.drawNum(g, this.img1[2], this.ppp[i], xx + 55 + this.img1[0].getWidth() / 3, yy + 2, 11);
            yy += 12;
        }
        if (this.number > 0) {
            Tools.ImageClip(g, this.img1[1], xx + ww / 2 - 10 - this.img1[1].getWidth() / 2, yy, this.img1[1].getWidth() / 2, this.img1[1].getHeight(), 0, 1);
        }
        if (!sell && !this.couldAddNumber(sell, this.number, good) && this.number == 0) {
            g.setColor(0xFFFFFF);
            g.drawString("\u4f59\u989d\u4e0d\u8db3\uff01", xx + (ww - g.getFont().stringWidth("\u4f59\u989d\u4e0d\u8db3\uff01")) / 2, yy + 2, 0);
        } else {
            xx = Tools.drawNum(g, this.img1[2], this.number, xx + ww / 2, yy + 2, 11);
        }
        if (this.couldAddNumber(sell, this.number, good)) {
            Tools.ImageClip(g, this.img1[1], xx + 10, yy, this.img1[1].getWidth() / 2, this.img1[1].getHeight(), 1, 1);
        }
        g.drawImage(this.img1[4], 100, yy + 20, 0);
        Tools.drawNum(g, this.img1[2], this.pack.getMoney(), 120, yy + 20, 11);
    }

    private boolean couldAddNumber(boolean sell, int number, Goods goods) {
        if (sell) {
            if (number < goods.number) {
                return true;
            }
            if (number == 0) {
                return true;
            }
        }
        return false;
    }

    private final void itemContor(int index) {
        this.currenPlayer.setContor(index);
        this.selectIndex = this.currenPlayer.posIndex;
        this.currenPlayer.setOperateLog(this.resLog);
        int[] tem = (int[])this.resLog.elementAt(this.resLog.size() - 1);
        if (tem[0] != 10) {
            this.resLog.removeElement(tem);
        }
        this.currenFangz = this.player;
        this.state = 10;
        this.selectIndex = this.logic.execContor(this.player, this.selectIndex);
        if (this.selectIndex != -1) {
            this.setIndex(10, 0);
        } else {
            this.selectIndex = 0;
        }
    }

    final void setSelectIndex(int selectIndex) {
        switch (this.state) {
            case 10: {
                this.menu.setSelectIndex(selectIndex);
                break;
            }
            default: {
                if (selectIndex == 0) {
                    this.currenRows = 0;
                    this.currenCol = 0;
                    this.currenPage = 0;
                    break;
                }
                int tem = selectIndex % (this.col * this.rows);
                this.currenPage = selectIndex / (this.col * this.rows);
                this.currenCol = tem / this.rows;
                this.currenRows = tem % this.rows;
            }
        }
    }

    private final int getSelectIndex() {
        return this.currenRows + this.currenCol * this.rows + this.rows * this.col * this.currenPage;
    }

    public boolean keyRepeatedItem(int key) {
        return false;
    }

    public boolean pointerPressedItem(int x, int y) {
        return false;
    }

    public void logic() {
    }

    public void paint(Graphics g) {
        switch (this.state) {
            case 10: {
                if (this.menu != null) {
                    this.menu.paint(g);
                }
                this.drawHand(g);
                break;
            }
            case 11: {
                this.drawHand(g);
            }
        }
    }

    private final void drawHand(Graphics g) {
        if (this.hand == null) {
            this.hand = new MyClip(Tools.loadImage("/res/fight/hand1.png"), 4, 0, -1);
            this.hand.setSpace(100);
            this.hand.paly();
        }
        int x = this.currenFangz[this.selectIndex].getHeadX() + (this.currenFangz[this.selectIndex].getHeadWidth() - this.hand.getWidth()) / 2;
        this.hand.setPos(x, this.currenFangz[this.selectIndex].getHeadY() - this.hand.getHeight() - 5);
        this.hand.paint(g);
        this.showPanle(g, this.currenFangz[this.selectIndex], 3, 320 - this.fightManager.frameHeight + 10);
    }

    private static final void drawTiao(Graphics g, Image img, int x, int y, int w, int bNumber, int endNumber) {
        if (img != null) {
            int numberW = img.getWidth() / 11;
            int numberH = img.getHeight();
            int x1 = x + FightUI.renturnNumX(bNumber, endNumber, numberW, w);
            int a = Tools.drawNum(g, img, bNumber, x1, y, 11);
            Tools.ImageClip(g, img, a, y, numberW, numberH, 0, 10, 20);
            Tools.drawNum(g, img, endNumber, a + numberW, y, 11);
        }
    }

    private static final int renturnNumX(int num1, int num2, int w, int w1) {
        int len = Integer.toString(num1).length();
        int len1 = Integer.toString(num2).length();
        int x = w1 - (len * w + len1 * w + w) >> 1;
        return x;
    }

    private final void showPanle(Graphics g, Hero hero, int x, int y) {
        g.setColor(0xFFFFFF);
        g.drawString(hero.property.name, x, y - 9, 0);
        if (this.stateFrame == null) {
            this.stateFrame = Tools.loadImage("/res/fight/stateFrame.png");
        }
        int stateFrameX = x + 100;
        int stateFrameY = y + 15;
        int stateFrameW = (this.stateFrame.getWidth() + 2) * 5;
        if (hero.type == 2) {
            // empty if block
        }
        g.drawString("\u751f\u547d", x, y + 9, 0);
        g.drawString("\u9b54\u6cd5", x, y + Tools.DEFAULFONT_HEIGHT + 10, 0);
        FightUI.drawTiao(g, this.num, x, y + 15, 130, hero.property.getCurrenHp(), hero.property.getMax_hp());
        FightUI.drawTiao(g, this.num, x, y + 36, 130, hero.property.getCurrenMp(), hero.property.getMax_mp());
        g.drawString("\u7b49\u7ea7", x + 70, y - 9, 0);
        Tools.drawNum(g, this.num, hero.property.getGrade(), x + 110, y - 4, 11);
        Vector buff = this.getBuff(hero.buffCollection);
        if (buff == null) {
            return;
        }
        if (this.buffIcon == null) {
            this.buffIcon = Tools.loadImage("/res/fight/buffIcon.png");
        }
        for (int i = 0; i < buff.size(); ++i) {
            Buff tem = (Buff)buff.elementAt(i);
            int ri = i % 5;
            int buffx = stateFrameX + this.stateFrame.getWidth() / 2 + ri * (this.stateFrame.getWidth() + 2);
            int ci = i / 5;
            int buffy = stateFrameY + this.stateFrame.getHeight() / 2 + ci * (this.stateFrame.getHeight() + 5);
            if (tem.iconIndex < 0) continue;
            if (tem.durativeBout == 1) {
                if (System.currentTimeMillis() - tem.time <= 600L) continue;
                Tools.ImageClip(g, this.buffIcon, buffx, buffy, 10, 10, 0, tem.iconIndex, 3);
                if (System.currentTimeMillis() - tem.time <= 1000L) continue;
                tem.time = System.currentTimeMillis();
                continue;
            }
            Tools.ImageClip(g, this.buffIcon, buffx, buffy, 10, 10, 0, tem.iconIndex, 3);
        }
    }

    private final Vector getBuff(Vector buff) {
        if (buff == null) {
            return null;
        }
        Vector<Buff> tem1 = new Vector<Buff>(1, 1);
        for (int i = 0; i < buff.size(); ++i) {
            Buff tem = (Buff)buff.elementAt(i);
            if (tem.iconIndex == -1) continue;
            tem1.addElement(tem);
        }
        return tem1;
    }

    private final Image[] returnImgAr(Image blood, Image blood_col) {
        if (this.bloodFrame == null) {
            this.bloodFrame = Tools.loadImage("/res/ui/blood_frame.png");
        }
        Image[] tem = new Image[]{this.bloodFrame, blood, blood_col, this.num};
        return tem;
    }

    public void destroy() {
        this.data = null;
        this.pack = null;
        this.logic = null;
        if (this.menu != null) {
            this.menu.destroy();
        }
        this.menu = null;
        this.pack = null;
        this.enemy = null;
        this.gezi = null;
        this.player = null;
        this.currenPlayer = null;
        this.currenFangz = null;
        this.fightManager = null;
        System.gc();
    }

    public final void itemMenu(int index) {
        MainCanvas.setKeyRender(false);
        this.currenPlayer = this.logic.getSelectHero(1, this.selectIndex);
        switch (index) {
            case 0: {
                this.addResLog(this.state, index, this.selectIndex);
                this.currenPlayer.setContor(0, 0, 0);
                this.currenFangz = this.enemy;
                this.selectIndex = this.logic.execContor(this.currenFangz, -1);
                this.state = 11;
                break;
            }
            case 1: {
                if (Tools.getProbability(40)) {
                    this.fightManager.setTipString(new String[]{"\u9003\u8dd1\u6210\u529f\uff01"});
                    this.fightManager.tipType = 3;
                    break;
                }
                this.fightManager.setTipString(new String[]{"\u9003\u8dd1\u5931\u8d25\uff01"});
                this.fightManager.tipType = 1;
            }
        }
        MainCanvas.setKeyRender(true);
    }

    void setTa() {
        this.currenPlayer.setContor(0, -1, 0);
        this.currenPlayer.setContor(0);
        this.selectIndex = this.logic.execContor(this.player, this.selectIndex);
    }

    private final void setIndex(int state, int index) {
        if (this.fightManager != null) {
            if (this.player[this.selectIndex].log != null) {
                int[] tem;
                if (this.player[this.selectIndex].log.size() > index && (tem = (int[])this.player[this.selectIndex].log.elementAt(index))[0] == state) {
                    this.setSelectIndex(tem[1]);
                    this.selectIndex = tem[2];
                }
            } else {
                this.setSelectIndex(0);
            }
        }
    }

    final void creal() {
        if (this.resLog != null) {
            this.resLog.removeAllElements();
        }
        this.resLog = null;
        this.selectIndex = 0;
        this.gezi = null;
        this.currenPage = 0;
        this.currenCol = 0;
        this.currenRows = 0;
        this.rows = 0;
        this.col = 0;
        this.pageSize = 0;
        this.state = 0;
    }
}

