/*
 * Decompiled with CFR 0.152.
 */
package com.game.fight.speci;

import com.game.fight.speci.Event;
import com.game.fight.speci.SpeciEventListener;
import com.game.lib.Layer;
import com.game.lib.MySprite;
import com.game.map.trigger.Trianger;
import com.util.Tools;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class Speci
implements Layer {
    private MySprite sprite;
    private int[][] action;
    private int actionSize;
    private SpeciEventListener eventListener;
    private int[][] position;
    private static final int ACTION = 0;
    private static final int PLAYERTYPE = 1;
    private static final int PLAYERWAY = 2;
    private int currenPoint;
    public boolean visble = true;
    public static final int ONEPLAYER = 1;
    public static final int ONEPLAYERDISAPP = 2;
    public static final int LOOPPLAYER = -1;
    public static final int NEXT = 0;
    public static final int PER = 1;
    private Vector event;
    private int eventIndex;
    private Event currenEvent;
    private boolean isRemove;
    private boolean isMove;
    private int count = 0;
    private Trianger triMto;
    private static final String X = "x";
    private static final String Y = "y";
    private static final String F = "f";
    private static final String FLAST = "fLast";
    private static final String FFRIST = "fFrist";
    private static final String MOVE = "move";
    private static final String MTO = "mto";
    private static final String ACT = "act";
    private static final String GRE = ">";
    private static final String LES = "<";
    private static final String EQU = "=";
    private static final String AND = "&";
    private static final String COM = ",";

    public Speci(MySprite sprite) {
        this.sprite = sprite;
    }

    public Speci(Speci speci) {
        this(speci, speci.sprite, speci.eventListener);
    }

    public Speci(Speci speci, MySprite sprite, SpeciEventListener eventListener) {
        this.copySpeci(speci, sprite, eventListener);
    }

    public final void setListener(SpeciEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public final void addPositions(int x, int y) {
        if (this.position == null) {
            this.position = new int[1][];
            this.position[0] = new int[]{x, y};
        } else {
            this.position = Tools.eXPandArray(this.position, 1);
            this.position[this.position.length - 1] = new int[]{x, y};
        }
    }

    public void addAction(int action, int type, int playerWay) {
        if (this.action == null) {
            this.action = new int[][]{{action, type, playerWay}};
        } else {
            this.action = Tools.eXPandArray(this.action, 1);
            this.action[this.action.length - 1] = new int[]{action, type, playerWay};
        }
        ++this.actionSize;
        this.setCurrenAction();
    }

    private final void copySpeci(Speci speci, MySprite sprite, SpeciEventListener eventListener) {
        this.sprite = sprite;
        this.eventListener = eventListener;
        this.setAction(speci.action);
    }

    public final void setAction(int[][] action) {
        this.actionSize = action.length;
        this.action = new int[this.actionSize][];
        for (int i = 0; i < this.actionSize; ++i) {
            int[] tem = new int[action[i].length];
            for (int j = 0; j < tem.length; ++j) {
                tem[j] = action[i][j];
            }
            this.action[i] = tem;
        }
        this.setCurrenAction();
    }

    public final void next() {
        ++this.currenPoint;
        if (this.currenPoint > this.actionSize) {
            this.currenPoint = 0;
        }
        this.setCurrenAction();
    }

    public final void setCurrenActionPoint(int currenPoint) {
        this.currenPoint = currenPoint;
        this.setCurrenAction();
    }

    public final int getCurrenPoint() {
        return this.currenPoint;
    }

    private final void setCurrenAction() {
        if (this.currenPoint >= this.action.length) {
            return;
        }
        this.sprite.setAction(this.action[this.currenPoint][0]);
        if (this.action[this.currenPoint][2] == 1) {
            this.sprite.setFrame(this.sprite.getSequenceLength() - 1);
        }
    }

    public void paint(Graphics g) {
        if (this.visble) {
            this.playerFrame();
            if (this.position != null) {
                for (int i = 0; i < this.position.length; ++i) {
                    this.sprite.setPosition(this.position[i][0], this.position[i][1]);
                    this.sprite.paint(g);
                }
            } else {
                this.sprite.paint(g);
            }
        }
    }

    private final void playerFrame() {
        this.itemEvent();
        switch (this.action[this.currenPoint][2]) {
            case 0: {
                this.itemNext();
                break;
            }
            case 1: {
                this.itemPer();
            }
        }
    }

    public final void addEve(String eventCode, int bingAction, int eventID) {
        Event tem = new Event();
        tem.eventCode = eventCode;
        tem.bingAction = bingAction;
        tem.eventID = eventID;
        if (this.event == null) {
            this.event = new Vector();
            this.currenEvent = tem;
        }
        this.event.addElement(tem);
    }

    private final void itemEvent() {
        if (this.currenEvent != null && this.currenEvent.bingAction == this.currenPoint && this.parseCondtion(this.currenEvent.eventCode)) {
            ++this.eventIndex;
            this.eventListener.itemEvent(this.currenEvent.eventID);
            this.currenEvent.bingAction = -1;
            this.currenEvent = null;
            if (this.eventIndex < this.event.size()) {
                this.currenEvent = (Event)this.event.elementAt(this.eventIndex);
            }
            this.clearEventState();
            System.gc();
        }
    }

    private final void itemNext() {
        switch (this.action[this.currenPoint][1]) {
            case 1: {
                if (this.sprite.getFrame() < this.sprite.getSequenceLength() - 1) break;
                return;
            }
            case 2: {
                if (this.sprite.getFrame() < this.sprite.getSequenceLength() - 1) break;
                if (this.currenPoint >= this.actionSize - 1) {
                    this.isRemove = true;
                    this.visble = false;
                } else {
                    this.next();
                }
                return;
            }
        }
        this.sprite.updateNext();
    }

    private final void itemPer() {
        switch (this.action[this.currenPoint][1]) {
            case 1: {
                if (this.sprite.getFrame() > 0) break;
                if (this.currenPoint >= this.actionSize - 1) {
                    this.sprite.setAction(0);
                    this.visble = false;
                }
                return;
            }
            case 2: {
                if (this.sprite.getFrame() > 0) break;
                if (this.currenPoint >= this.actionSize - 1) {
                    this.isRemove = true;
                    this.sprite.setAction(0);
                    this.visble = false;
                } else {
                    this.next();
                }
                return;
            }
        }
        this.sprite.updatePrev();
    }

    private final void clearEventState() {
        this.isMove = false;
        this.count = 0;
    }

    private final boolean parseCondtion(String condtion) {
        String[] str = Tools.splitStr(condtion, AND);
        for (int i = 0; i < str.length; ++i) {
            if (str[i].startsWith(X)) {
                if (!this.parseSymbol(str[i].substring(1), this.sprite.getX())) continue;
                ++this.count;
                continue;
            }
            if (str[i].startsWith(Y)) {
                if (!this.parseSymbol(str[i].substring(1), this.sprite.getY())) continue;
                ++this.count;
                continue;
            }
            if (str[i].startsWith(F)) {
                if (!this.parseSymbol(str[i].substring(1), this.sprite.getFrame())) continue;
                ++this.count;
                continue;
            }
            if (str[i].startsWith(MOVE)) {
                if (!this.parseSymbol(str[i].substring(4), 0) || this.isMove) continue;
                this.isMove = true;
                ++this.count;
                continue;
            }
            if (!this.isMove && str[i].startsWith(MTO)) {
                String[] tem = Tools.splitStr(str[i].substring(4), COM);
                if (this.triMto == null) {
                    this.triMto = new Trianger();
                    this.triMto.setCoil(Tools.str2int(tem[0]), Tools.str2int(tem[1]));
                    this.triMto.setCurren(this.sprite.getX(), this.sprite.getY());
                    this.triMto.setSpeed(15, 15);
                    this.triMto.setIntcre(this.triMto.returnTanAngle());
                }
                switch (this.triMto.resWay) {
                    case -5: {
                        if (this.sprite.getX() > Tools.str2int(tem[0])) break;
                        ++this.count;
                        this.isMove = true;
                        break;
                    }
                    case 5: {
                        if (this.sprite.getX() < Tools.str2int(tem[0])) break;
                        ++this.count;
                        this.isMove = true;
                    }
                }
                this.sprite.move(this.triMto.getCurrenX(), this.triMto.getCurrenY());
                continue;
            }
            if (!str[i].startsWith(ACT) || this.sprite.getCollidesWidth(0) <= 0) continue;
            ++this.count;
        }
        return this.count >= str.length;
    }

    private boolean parseSymbol(String sym, int value) {
        if (sym.startsWith(GRE)) {
            if (sym.startsWith(EQU, 1) ? value >= Tools.str2int(sym.substring(2)) : value > Tools.str2int(sym.substring(1))) {
                return true;
            }
        } else if (sym.startsWith(LES)) {
            if (sym.startsWith(GRE, 1) ? value != Tools.str2int(sym.substring(2)) : (sym.startsWith(EQU, 1) ? value <= Tools.str2int(sym.substring(2)) : value < Tools.str2int(sym.substring(1)))) {
                return true;
            }
        } else if (sym.startsWith(EQU)) {
            if (sym.startsWith(EQU, 1)) {
                if (sym.substring(2).equals(FLAST) ? value >= this.sprite.getSequenceLength() - 1 : (sym.substring(2).equals(FFRIST) ? value == this.sprite.getSequenceLength() - 1 : value == Tools.str2int(sym.substring(2)))) {
                    return true;
                }
            } else {
                String[] tem = Tools.splitStr(sym.substring(1), COM);
                this.sprite.move(Tools.str2int(tem[0]), Tools.str2int(tem[1]));
                return true;
            }
        }
        return false;
    }

    public final void setX(int x) {
        this.sprite.setX(x);
    }

    public final void setY(int y) {
        this.sprite.setY(y);
    }

    public final void setPosition(int x, int y) {
        this.sprite.setPosition(x, y);
    }

    public final int getX() {
        return this.sprite.getX();
    }

    public final int getY() {
        return this.sprite.getY();
    }

    public final int getWidth() {
        return this.sprite.getWidth();
    }

    public final int getHeight() {
        return this.sprite.getHeight();
    }

    public final void setVisbale(boolean visible) {
        this.sprite.setVisbale(visible);
    }

    public final boolean isVisbale() {
        return this.sprite.isVisbale();
    }

    public final boolean getEnabled() {
        return this.sprite.getEnabled();
    }

    public final void setEnabled(boolean enabled) {
        this.sprite.setEnabled(enabled);
    }

    public final int getType() {
        return -1;
    }

    public final boolean isRemove() {
        return this.isRemove;
    }
}

