/*
 * Decompiled with CFR 0.152.
 */
package com.game.film;

import com.MainCanvas;
import com.game.GameMain;
import com.game.fight.FightManager;
import com.game.film.Film;
import com.game.film.FilmScriptParse;
import com.game.lib.MySprite;
import com.game.map.MapManager;
import com.game.role.Npc;
import com.game.role.Player;
import com.game.role.Property;
import com.game.tishi.TipBean;
import com.util.ATextBox;
import com.util.Tools;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class FilmPlayer {
    public static final int FILM_START = 0;
    public static final int FILM_END = 1;
    public static final int DRAW_NONE = 0;
    public static final int DRAW_FLASHSCREEN = 1;
    public static final int DRAW_INTERLUDER = 2;
    public static final int DRAW_FACE = 3;
    public static final int DO_LOGIC = 0;
    public static final int DO_ACTION = 1;
    public static final int DO_PAINT = 2;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_PLAYER_WALK = 1;
    public static final int ACTION_ADDNPC = 2;
    public static final int ACTION_ROLESTOP = 3;
    public static final int ACTION_TIP = 4;
    public static final int ACTION_MOVEWINDOW = 5;
    public static final int ACTION_ROLETURN = 8;
    public static final int ACTION_BIND_FILM = 10;
    public static final int ACTION_ADD_FELLOW = 11;
    public static final int ACTION_REMOVE_FELLOW = 12;
    public static final int ACTION_SET_FACE = 15;
    public static final int ACTION_TALK = 16;
    public static final int ACTION_GO_TO_SCENE = 17;
    public static final int ACTION_GO_TO_FIGHT = 18;
    public static final int ACTION_RELEASE_FILM = 19;
    public static final int ACTION_SET_INTERLUDER = 20;
    public static final int ACTION_ADD_ALL_NPC = 21;
    public static final int ACTION_ACCEPT_MAIN_MISSION = 22;
    public static final int ACTION_NPC_WALK = 23;
    public static final int ACTION_HIDE_ROLE = 35;
    public static final int ACTION_SET_WINDOW = 36;
    public static final int ACTION_BLACK_SCREEN = 38;
    public static final int ACTION_HIDE_ALL_ROLE = 40;
    public static final int ACTION_SET_ALL_FACE = 42;
    public static final int ACTION_SET_PLAYER_POS = 47;
    public static final int ACTION_DELAY = 48;
    public static final int ACTION_OVER_MISSION = 49;
    public static final int ACTION_NPCS_WALK = 50;
    public static final int ACTION_ROLES_TURN = 51;
    public static final int ACTION_REPAINT_BLACK = 53;
    public static final int ACTION_SET_NPCS_POS = 54;
    public static final int ACTION_SHOW_NPCS = 55;
    public static final int ACTION_FIGHT_BOSS = 63;
    public static final int ACTION_BACK_MENU = 77;
    public static final int UPDATE_NONE = 0;
    public static final int UPDATE_PLAYER_WALK = 1;
    public static final int UPDATE_PLAYER_WALK_TO_DEST = 2;
    public static final int UPDATE_WHO_PLAYER_WALK = 3;
    public static final int UPDATE_WHO_PLAYER_WALK_DEST = 4;
    public static final int UPDATE_NPC_WALK = 5;
    public static final int UPDATE_DRAW_FACE = 17;
    public static final int UPDATE_NPCS_WALK = 20;
    public static final int MAXTIME = 500;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int NORTH = 4;
    public static final int EASTSOUTH = 5;
    public static final int EASTNORTH = 6;
    public static final int WESTSOUTH = 7;
    public static final int WESTNORTH = 8;
    public static int blackScreen;
    private FilmScriptParse filmParse;
    private MapManager mapManager;
    private Vector npcVec;
    private int npcIndex;
    private Player[] playerAry;
    private int playerCount;
    private int logicState = 0;
    private int drawState = 0;
    private int actionState = 0;
    public int filmState = 0;
    public int updateState = 0;
    public int drawAlwaysState = 0;
    private int time;
    private Player playerTmp;
    private Npc[] npcTmp;
    private int px;
    private int py;
    private int[][] moveAry;
    private int[][] moveAry1;
    private ATextBox aTextBox;
    public Npc xiepusa;
    public Npc qiling;
    private MySprite shui;
    private MySprite dun;
    private MySprite zua;
    public MySprite qiankun;
    public MySprite zhiliao;
    public MySprite guangzhu;
    public MySprite huoguang;
    public MySprite zhuzi;
    private boolean t;
    private int delay = 1;
    private int stop;
    private int pre;

    public void destory() {
        if (this.npcVec != null) {
            for (int i = 0; i < this.npcVec.size(); ++i) {
                ((Npc)this.npcVec.elementAt(i)).setVisbale(false);
            }
        }
    }

    public FilmPlayer(MapManager mapManager, int scriptID) {
        this.mapManager = mapManager;
        this.filmParse = new FilmScriptParse(scriptID);
        this.npcVec = new Vector();
        this.playerAry = new Player[3];
        this.npcTmp = new Npc[2];
    }

    public boolean inti(int num) {
        return true;
    }

    public boolean keyRepeatedItem(int key) {
        return false;
    }

    public boolean pointerPressedItem(int x, int y) {
        return false;
    }

    public void logic() throws IOException {
        if (this.mapManager.isShowTalk) {
            return;
        }
        if (this.mapManager.isShowTip) {
            return;
        }
        switch (this.logicState) {
            case 0: {
                this.ZeroTime();
                if (this.filmParse.hasNext()) {
                    this.filmParse.readNextLine();
                    this.dealKey(this.filmParse.getKey());
                    break;
                }
                this.filmState = 1;
                this.filmParse.close();
                break;
            }
            case 1: {
                this.doActionUpDate();
                switch (this.actionState) {
                    case 1: {
                        this.playerWalkTo();
                        break;
                    }
                    case 2: {
                        this.addNpc(Integer.parseInt(this.filmParse.getValue()[0]), Integer.parseInt(this.filmParse.getValue()[1]), Integer.parseInt(this.filmParse.getValue()[2]), Integer.parseInt(this.filmParse.getValue()[3]), Integer.parseInt(this.filmParse.getValue()[4]), this.filmParse.getValue()[5], Integer.parseInt(this.filmParse.getValue()[6]), Integer.parseInt(this.filmParse.getValue()[7]));
                        break;
                    }
                    case 3: {
                        this.roleStop(Integer.parseInt(this.filmParse.getValue()[0]), Integer.parseInt(this.filmParse.getValue()[1]));
                        break;
                    }
                    case 4: {
                        this.showTip(this.filmParse.getValue());
                        break;
                    }
                    case 5: {
                        this.moveWindow(Integer.parseInt(this.filmParse.getValue()[0]), Integer.parseInt(this.filmParse.getValue()[1]), Integer.parseInt(this.filmParse.getValue()[2]), Integer.parseInt(this.filmParse.getValue()[3]));
                        break;
                    }
                    case 8: {
                        this.roleTurn(Integer.parseInt(this.filmParse.getValue()[0]), Integer.parseInt(this.filmParse.getValue()[1]), Integer.parseInt(this.filmParse.getValue()[2]));
                        break;
                    }
                    case 10: {
                        int tmp = Integer.parseInt(this.filmParse.getValue()[0]);
                        this.bindFilm(tmp);
                        break;
                    }
                    case 11: {
                        this.addFellow(Integer.parseInt(this.filmParse.getValue()[0]), Integer.parseInt(this.filmParse.getValue()[1]), Integer.parseInt(this.filmParse.getValue()[2]), Integer.parseInt(this.filmParse.getValue()[3]));
                        break;
                    }
                    case 12: {
                        this.removeFellow(Integer.parseInt(this.filmParse.getValue()[0]));
                        break;
                    }
                    case 15: {
                        this.setFace(Integer.parseInt(this.filmParse.getValue()[0]), Integer.parseInt(this.filmParse.getValue()[1]), Integer.parseInt(this.filmParse.getValue()[2]));
                        this.actionState = 0;
                        this.logicState = 2;
                        this.updateState = 17;
                        this.drawState = 3;
                        break;
                    }
                    case 17: {
                        this.goToScene(Integer.parseInt(this.filmParse.getValue()[0]));
                        break;
                    }
                    case 18: {
                        this.mapManager.gameMain.insertFight();
                        this.logicState = 0;
                        break;
                    }
                    case 19: {
                        this.releaseFilm();
                    }
                    case 16: {
                        this.setTalk(Integer.parseInt(this.filmParse.getValue()[0]));
                        break;
                    }
                    case 20: {
                        String str2 = "";
                        String[] strTmp = this.filmParse.getValue();
                        String[] str1 = Tools.splitStr(strTmp[0].trim(), "|");
                        if (str1.length == 1) {
                            this.setInterluder(str1[0]);
                            break;
                        }
                        for (int i = 0; i < str1.length; ++i) {
                            str2 = str2 + str1[i] + "\n";
                        }
                        this.setInterluder(str2);
                        break;
                    }
                    case 21: {
                        this.addAllNpc(Integer.parseInt(this.filmParse.getValue()[0]));
                        break;
                    }
                    case 22: {
                        this.logicState = 0;
                        break;
                    }
                    case 49: {
                        this.logicState = 0;
                        break;
                    }
                    case 23: {
                        this.npcWalkTo(Integer.parseInt(this.filmParse.getValue()[0]));
                        break;
                    }
                    case 50: {
                        this.npcsWalkTo();
                        break;
                    }
                    case 35: {
                        this.hideRole(Integer.parseInt(this.filmParse.getValue()[0]));
                        break;
                    }
                    case 36: {
                        MapManager.winX = Integer.parseInt(this.filmParse.getValue()[0]);
                        MapManager.winY = Integer.parseInt(this.filmParse.getValue()[1]);
                        this.logicState = 0;
                        break;
                    }
                    case 38: {
                        blackScreen = 1;
                        this.logicState = 0;
                        break;
                    }
                    case 40: {
                        int[] ii = new int[this.filmParse.getValue().length];
                        for (int i = 0; i < ii.length; ++i) {
                            ii[i] = Integer.parseInt(this.filmParse.getValue()[i]);
                        }
                        this.hideAllRole(ii);
                        break;
                    }
                    case 42: {
                        String[] s_ary = this.filmParse.getValue();
                        int[][] data = new int[s_ary.length][3];
                        for (int i = 0; i < s_ary.length; ++i) {
                            String[] s_ary1 = Tools.splitStr(s_ary[i], "|");
                            for (int j = 0; j < s_ary1.length; ++j) {
                                data[i][j] = Integer.parseInt(s_ary1[j]);
                            }
                        }
                        this.setAllFace(data);
                        this.actionState = 0;
                        this.logicState = 2;
                        this.updateState = 17;
                        this.drawState = 3;
                        break;
                    }
                    case 47: {
                        this.mapManager.player1.setPosition(Integer.parseInt(this.filmParse.getValue()[0]), Integer.parseInt(this.filmParse.getValue()[1]));
                        this.logicState = 0;
                        break;
                    }
                    case 48: {
                        if (this.time <= Integer.parseInt(this.filmParse.getValue()[0])) break;
                        this.logicState = 0;
                        break;
                    }
                    case 51: {
                        String[] v = this.filmParse.getValue();
                        for (int i = 0; i < v.length; ++i) {
                            String[] h = Tools.splitStr(v[i], "|");
                            this.roleTurn(Integer.parseInt(h[0]), Integer.parseInt(h[1]), Integer.parseInt(h[2]));
                        }
                        this.logicState = 0;
                        break;
                    }
                    case 53: {
                        this.mapManager.deCount = 0;
                        this.logicState = 0;
                        break;
                    }
                    case 54: {
                        this.setNpcsPos();
                        break;
                    }
                    case 55: {
                        this.showNpcs();
                        break;
                    }
                    case 63: {
                        this.goFightBoss(Integer.parseInt(this.filmParse.getValue()[0]), Integer.parseInt(this.filmParse.getValue()[1]));
                        this.logicState = 0;
                        break;
                    }
                    case 77: {
                        MainCanvas.intiGame = 2;
                        MainCanvas.changeState(1);
                        this.logicState = 0;
                        break;
                    }
                }
                break;
            }
            case 2: {
                this.doPaintUpDate();
            }
        }
    }

    public void paint(Graphics g) {
        this.doAlwaysPaint(g);
        switch (this.drawState) {
            case 1: {
                String[] tmp = this.filmParse.getValue();
                this.drawFlashScreen(g, Tools.str2int(tmp[0]), Tools.str2int(tmp[1]), Tools.str2int(tmp[2]));
                if (this.time != 10) break;
                this.logicState = 0;
                break;
            }
            case 2: {
                this.t = this.drawInterluder(g);
                if (this.time < 500 || !this.t) break;
                this.aTextBox.destroy();
                this.logicState = 0;
                break;
            }
            case 3: {
                this.drawFace(g);
                break;
            }
        }
    }

    private void dealKey(String key) {
        if (key.equals("draw_flash_screen")) {
            this.drawState = 1;
            this.logicState = 2;
            this.actionState = 0;
            return;
        }
        if (key.equals("set_interluder")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 20;
            return;
        }
        if (key.equals("player_walk_to")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 1;
            return;
        }
        if (key.equals("add_npc")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 2;
        } else if (key.equals("role_stop")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 3;
        } else if (key.equals("tip")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 4;
        } else if (key.equals("move_window")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 5;
        } else if (key.equals("role_turn")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 8;
        } else if (key.equals("bind_film")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 10;
        } else if (key.equals("add_fellow")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 11;
        } else if (key.equals("remove_fellow")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 12;
        } else if (key.equals("set_face")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 15;
        } else if (key.equals("set_talk")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 16;
        } else if (key.equals("go_to_sence")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 17;
        } else if (key.equals("release_film")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 19;
        } else if (key.equals("add_all_npc")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 21;
        } else if (key.equals("accept_main_mission")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 22;
        } else if (key.equals("npc_walk")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 23;
        } else if (key.equals("set_window")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 36;
        } else if (key.equals("black_screen")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 38;
        } else if (key.equals("hide_all_role")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 40;
        } else if (key.equals("set_all_face")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 42;
        } else if (key.equals("set_player_pos")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 47;
        } else if (key.equals("delay")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 48;
        } else if (key.equals("over_mission")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 49;
        } else if (key.equals("npcs_walk")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 50;
        } else if (key.equals("roles_turn")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 51;
        } else if (key.equals("repaint_black")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 53;
        } else if (key.equals("set_npcs_pos")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 54;
        } else if (key.equals("show_npcs")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 55;
        } else if (key.equals("go_to_fight")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 18;
        } else if (key.equals("fight_boss")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 63;
        } else if (key.equals("back_menu")) {
            this.drawState = 0;
            this.logicState = 1;
            this.actionState = 77;
        }
    }

    private void increaseTime() {
        ++this.time;
        if (this.time > 500) {
            this.time = 0;
        }
    }

    private void ZeroTime() {
        this.time = 0;
    }

    private void doActionUpDate() {
        this.ActionAlwaysUpDate();
        switch (this.updateState) {
            case 1: {
                this.playerWalkUpDate();
                break;
            }
            case 2: {
                this.playerWalkToDestUpDate();
                break;
            }
            case 3: {
                this.whoPlayerWalkToUpdate();
                break;
            }
            case 4: {
                this.whoPlayerWalkToDestUpdate();
                break;
            }
            case 5: {
                this.npcWalkToUpdate();
                break;
            }
            case 20: {
                this.npcsWalkUpdate();
            }
        }
    }

    private void ActionAlwaysUpDate() {
        this.increaseTime();
        this.npcUpDate();
        this.playerUpDate();
        if (this.zhuzi != null) {
            this.zhuzi.nextFrame();
        }
        if (this.qiling != null && this.stop == 0 && this.time % this.delay == 0) {
            this.qiling.nextFrame();
        }
        if (this.xiepusa != null) {
            this.xiepusa.nextFrame();
        }
        if (this.shui != null) {
            this.shui.nextFrame();
        }
        if (this.pre == 0) {
            if (this.dun != null) {
                this.dun.nextFrame();
            }
        } else if (this.dun != null) {
            this.dun.prevFrame();
        }
        if (this.zua != null) {
            this.zua.nextFrame();
        }
        if (this.zhiliao != null) {
            this.zhiliao.nextFrame();
        }
        if (this.qiankun != null) {
            this.qiankun.nextFrame();
        }
        if (this.huoguang != null) {
            this.huoguang.nextFrame();
        }
    }

    private void doPaintUpDate() {
        this.paintAlwaysUpDate();
        switch (this.updateState) {
            case 17: {
                if (this.zhiliao != null) {
                    this.zhiliao.nextFrame();
                }
                if (this.qiankun == null) break;
                this.qiankun.nextFrame();
            }
        }
    }

    private void paintAlwaysUpDate() {
        this.increaseTime();
        if (this.huoguang != null) {
            this.huoguang.nextFrame();
        }
        if (this.qiankun != null) {
            this.qiankun.nextFrame();
        }
    }

    private void npcUpDate() {
    }

    private void playerUpDate() {
        for (int i = 0; i < this.playerAry.length; ++i) {
            if (this.playerAry[i] == null) continue;
            this.playerAry[i].logic();
        }
    }

    private void playerWalkUpDate() {
        this.mapManager.player1.logic();
        this.mapManager.player1.setState((byte)5);
        if (this.mapManager.player1.loopMove(this.moveAry)) {
            this.logicState = 0;
            this.updateState = 0;
        }
    }

    private void playerWalkToDestUpDate() {
        int destX = Integer.parseInt(this.filmParse.getValue()[0]);
        int destY = Integer.parseInt(this.filmParse.getValue()[1]);
        this.mapManager.player1.logic();
        this.mapManager.player1.setState((byte)5);
        if (this.mapManager.player1.judgeXMove(this.px, this.py, destX, destY)) {
            if (this.mapManager.player1.moveToDest(this.px, this.py, destX, destY, 0)) {
                this.logicState = 0;
                this.updateState = 0;
            }
        } else if (this.mapManager.player1.moveToDest(this.px, this.py, destX, destY, 1)) {
            this.logicState = 0;
            this.updateState = 0;
        }
    }

    private void drawFace(Graphics g) {
        int i;
        this.mapManager.player1.draw(g);
        for (i = 0; i < this.npcVec.size(); ++i) {
            ((Npc)this.npcVec.elementAt(i)).draw(g);
        }
        for (i = 0; i < this.playerAry.length; ++i) {
            if (this.playerAry[i] == null) continue;
            this.playerAry[i].draw(g);
        }
        if (this.time > 10) {
            if (this.mapManager.player1.getIsFace()) {
                this.mapManager.player1.setIsFace(false, -1);
            }
            for (i = 0; i < this.playerAry.length; ++i) {
                if (this.playerAry[i] == null || !this.playerAry[i].getIsFace()) continue;
                this.playerAry[i].setIsFace(false, -1);
            }
            for (i = 0; i < this.npcVec.size(); ++i) {
                if (!((Npc)this.npcVec.elementAt(i)).getIsFace()) continue;
                ((Npc)this.npcVec.elementAt(i)).setIsFace(false, -1);
            }
            this.actionState = 0;
            this.logicState = 0;
            this.drawState = 0;
            this.updateState = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyPressedItem(int key) {
        switch (this.logicState) {
            case 2: {
                switch (this.drawState) {
                    case 2: {
                        if (key != 19 || !this.t) return;
                        this.aTextBox.destroy();
                        this.logicState = 0;
                    }
                }
                return;
            }
        }
    }

    private void addNpc(int type, int id, int px, int py, int dir, String imgName, int xF, int yF) {
        Npc npc = null;
        switch (type) {
            case 0: {
                npc = new Npc(this.mapManager, id, px, py, dir, 0, Tools.loadImage("/res/npc/" + imgName), xF, yF, null, null, 0, 0, null);
                break;
            }
            case 1: {
                String[] tmp = Tools.splitStr(imgName, "|");
                npc = new Npc(this.mapManager, id, px, py, dir, 0, tmp[0], tmp[1], null, null, 0, 0, null);
                break;
            }
            case 2: {
                String[] tmp1 = Tools.splitStr(imgName, "|");
                npc = new Npc(this.mapManager, id, px, py, dir, 0, tmp1[0], tmp1[1], null, null, 0, 0, null, 0);
                npc.setAction(0);
            }
        }
        this.mapManager.map.tiled.addMapElement(npc);
        this.npcVec.addElement(npc);
        this.logicState = 0;
    }

    private void setAllRoleStop() {
        int i;
        if (this.mapManager.player1 != null) {
            this.mapManager.player1.setState((byte)4);
        }
        for (i = 0; i < this.playerAry.length; ++i) {
            if (this.playerAry[i] == null) continue;
            this.playerAry[i].setState((byte)4);
        }
        for (i = 0; i < this.npcVec.size(); ++i) {
            int id;
            if (this.npcVec.elementAt(i) == null || (id = ((Npc)this.npcVec.elementAt(i)).getRoleID()) == 7 || id == 8 || id == 19 || id == 22 || id == 28 || id == 29 || id == 32 || id == 33) continue;
            ((Npc)this.npcVec.elementAt(i)).setState((byte)4);
        }
    }

    private void roleStop(int type, int id) {
        switch (type) {
            case 0: {
                if (id == 10) {
                    this.mapManager.player1.setState((byte)4);
                    break;
                }
                for (int i = 0; i < this.playerAry.length; ++i) {
                    if (this.playerAry[i] == null || this.playerAry[i].getRoleID() != id) continue;
                    this.playerAry[i].setState((byte)4);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.npcVec.size(); ++i) {
                    if (((Npc)this.npcVec.elementAt(i)).getRoleID() != id) continue;
                    ((Npc)this.npcVec.elementAt(i)).setState((byte)4);
                }
                break;
            }
        }
        this.logicState = 0;
    }

    private void showTip(String[] str) {
        TipBean tishiBean = new TipBean();
        tishiBean.setTipMessage(str);
        tishiBean.setTipType((byte)1);
        tishiBean.setPalyerType((byte)2);
        this.mapManager.setTip(tishiBean);
        this.logicState = 0;
    }

    private void playerWalkTo() {
        String[] sTmp = this.filmParse.getValue();
        Object iTmp = new int[sTmp.length][];
        for (int i = 0; i < sTmp.length; ++i) {
            iTmp[i] = Tools.getIKeyValue(sTmp[i], "|");
        }
        this.moveAry = iTmp;
        sTmp = null;
        iTmp = null;
        this.updateState = 1;
        this.actionState = 0;
    }

    private boolean drawInterluder(Graphics g) {
        int pre = g.getColor();
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.setColor(pre);
        return this.aTextBox.drawShadowLine(g, 0xFFFFFF, -16777216);
    }

    private void drawFlashScreen(Graphics g, int color1, int color2, int speed) {
        int preColor = g.getColor();
        if (this.time % speed == 0) {
            g.setColor(color1);
            g.fillRect(0, 0, 240, 320);
            g.setColor(preColor);
        } else {
            g.setColor(color2);
            g.fillRect(0, 0, 240, 320);
            g.setColor(preColor);
        }
    }

    private void moveWindow(int endX, int endY, int speed, int direction) {
        switch (direction) {
            case 1: {
                if (MapManager.winX < endX) {
                    this.mapManager.moveWindows(speed, 0);
                    if (MapManager.winX < this.mapManager.getMapWidth() - 240) break;
                    this.logicState = 0;
                    break;
                }
                this.logicState = 0;
                break;
            }
            case 3: {
                if (MapManager.winX > endX) {
                    this.mapManager.moveWindows(-speed, 0);
                    break;
                }
                this.logicState = 0;
                break;
            }
            case 4: {
                if (MapManager.winY > endY) {
                    this.mapManager.moveWindows(0, -speed);
                    break;
                }
                this.logicState = 0;
                break;
            }
            case 2: {
                if (MapManager.winY < endY) {
                    this.mapManager.moveWindows(0, speed);
                    if (MapManager.winY < this.mapManager.getMapHeight() - 320) break;
                    this.logicState = 0;
                    break;
                }
                this.logicState = 0;
                break;
            }
            case 6: {
                if (MapManager.winX < endX) {
                    if (MapManager.winY > endY) {
                        this.mapManager.moveWindows(speed, -speed);
                        break;
                    }
                }
                this.logicState = 0;
                break;
            }
            case 5: {
                if (MapManager.winX < endX) {
                    if (MapManager.winY < endY) {
                        this.mapManager.moveWindows(speed, speed);
                        break;
                    }
                }
                this.logicState = 0;
                break;
            }
            case 8: {
                if (MapManager.winX > endX) {
                    if (MapManager.winY > endY) {
                        this.mapManager.moveWindows(-speed, -speed);
                        break;
                    }
                }
                this.logicState = 0;
                break;
            }
            case 7: {
                if (MapManager.winX > endX) {
                    if (MapManager.winY < endY) {
                        this.mapManager.moveWindows(-speed, speed);
                        break;
                    }
                }
                this.logicState = 0;
            }
        }
    }

    private void roleTurn(int id, int RoleType, int dir) {
        switch (RoleType) {
            case 0: {
                if (id == 10) {
                    this.mapManager.player1.changeDir(dir);
                    break;
                }
                for (int i = 0; i < this.playerAry.length; ++i) {
                    if (this.playerAry[i] == null || this.playerAry[i].getRoleID() != id) continue;
                    this.playerAry[i].changeDir(dir);
                }
                break;
            }
            case 1: {
                if (this.mapManager.getCurrentMapNpc(id) != null) {
                    this.mapManager.getCurrentMapNpc(id).changeDir(dir);
                    break;
                }
                for (int i = 0; i < this.npcVec.size(); ++i) {
                    if (((Npc)this.npcVec.elementAt(i)).getRoleID() != id) continue;
                    ((Npc)this.npcVec.elementAt(i)).changeDir(dir);
                }
                break;
            }
        }
        this.logicState = 0;
    }

    private void bindFilm(int id) {
        Film tmp = Film.createFilm(id);
        Player cfr_ignored_0 = this.mapManager.player1;
        Player.film = tmp;
        this.logicState = 0;
        System.gc();
    }

    private void addFellow(int id, int px, int py, int dir) {
        Player tmp = new Player(this.mapManager, id);
        tmp.loadPlayer();
        tmp.property = Property.createProperty(id);
        tmp.setPosition(px, py);
        tmp.changeDir(dir);
        this.playerAry[this.playerCount] = tmp;
        ++this.playerCount;
        this.mapManager.map.tiled.addMapElement(tmp);
        this.logicState = 0;
    }

    private void removeFellow(int id) {
        Player tmp = null;
        for (int i = 0; i < this.playerAry.length; ++i) {
            if (this.playerAry[i] == null || this.playerAry[i].getRoleID() != id) continue;
            tmp = this.playerAry[i];
            this.playerAry[i] = null;
        }
        tmp.untilPlayer();
        this.mapManager.map.tiled.removeMapElement(tmp);
        for (int j = this.playerAry.length - 1; j >= 0; --j) {
            for (int k = this.playerAry.length - 1; k > 0; --k) {
                if (this.playerAry[k] == null) continue;
                Player tmp1 = this.playerAry[k];
                this.playerAry[k] = this.playerAry[k - 1];
                this.playerAry[k - 1] = tmp1;
            }
        }
        for (int g = 0; g < this.playerAry.length; ++g) {
            if (this.playerAry[g] != null) continue;
            this.playerCount = g;
        }
        this.logicState = 0;
    }

    private void whoPlayerWalkToUpdate() {
        this.playerTmp.logic();
        this.playerTmp.setState((byte)5);
        if (this.playerTmp.loopMove(new int[][]{{130, 100}, {200, 100}})) {
            this.updateState = 0;
            this.logicState = 0;
        }
    }

    private void whoPlayerWalkToDestUpdate() {
        this.playerTmp.logic();
        this.playerTmp.setState((byte)5);
        if (this.playerTmp.judgeXMove(this.px, this.py, 10, 10)) {
            if (this.playerTmp.moveToDest(this.px, this.py, 10, 10, 0)) {
                this.logicState = 0;
                this.updateState = 0;
            }
        } else if (this.playerTmp.moveToDest(this.px, this.py, 15, 10, 1)) {
            this.logicState = 0;
            this.updateState = 0;
        }
    }

    private void setFace(int id, int RoleType, int faceType) {
        switch (RoleType) {
            case 0: {
                if (id == 10) {
                    this.mapManager.player1.setIsFace(true, faceType);
                    break;
                }
                for (int i = 0; i < this.playerAry.length; ++i) {
                    if (this.playerAry[i] == null || this.playerAry[i].getRoleID() != id) continue;
                    this.playerTmp = this.playerAry[i];
                }
                this.playerTmp.setIsFace(true, faceType);
                break;
            }
            case 1: {
                for (int i = 0; i < this.npcVec.size(); ++i) {
                    if (((Npc)this.npcVec.elementAt(i)).getRoleID() != id) continue;
                    ((Npc)this.npcVec.elementAt(i)).setIsFace(true, faceType);
                    GameMain.systemPrintln("jj:" + ((Npc)this.npcVec.elementAt(i)).getRoleID());
                }
                break;
            }
        }
    }

    private void setAllFace(int[][] data) {
        for (int i = 0; i < data.length; ++i) {
            this.setFace(data[i][0], data[i][1], data[i][2]);
        }
    }

    private void goToScene(int id) {
        MapManager.currenMapID = id;
        this.mapManager.gameMain.switchMap();
        this.mapManager.setState(1, -1);
        this.logicState = 0;
    }

    private void releaseFilm() {
        Player cfr_ignored_0 = this.mapManager.player1;
        Player.film = null;
        this.logicState = 0;
        System.gc();
    }

    private void setTalk(int id) {
        this.setAllRoleStop();
        this.mapManager.initTalk(id);
        this.logicState = 0;
    }

    private void setInterluder(String str) {
        this.aTextBox = new ATextBox();
        this.aTextBox.setATextBox(str, Tools.defaultFont, 20, 20, 200, 280);
        this.logicState = 2;
        this.drawState = 2;
        this.actionState = 0;
    }

    private void doAlwaysPaint(Graphics g) {
    }

    private void addAllNpc(int id) {
        Npc[] npc = Npc.loadFilmNpc(this.mapManager, id);
        for (int i = 0; i < npc.length; ++i) {
            this.npcVec.addElement(npc[i]);
            this.mapManager.layer.addend(npc[i]);
        }
        this.logicState = 0;
    }

    private void npcWalkTo(int id) {
        for (int i = 0; i < this.npcVec.size(); ++i) {
            if (((Npc)this.npcVec.elementAt(i)).getRoleID() != id) continue;
            this.npcTmp[0] = (Npc)this.npcVec.elementAt(i);
        }
        String[] s_1 = this.filmParse.getValue();
        int[][] i_1 = new int[s_1.length][2];
        for (int i = 1; i < s_1.length; ++i) {
            String[] s_2 = Tools.splitStr(s_1[i], "|");
            for (int j = 0; j < s_2.length; ++j) {
                i_1[i][j] = Integer.parseInt(s_2[j]);
            }
        }
        this.moveAry = i_1;
        this.updateState = 5;
        this.actionState = 0;
    }

    private void npcWalkToUpdate() {
        this.npcTmp[0].updateNext();
        this.npcTmp[0].setState((byte)5);
        if (this.npcTmp[0].loopMoveAry(this.moveAry)) {
            this.updateState = 0;
            this.logicState = 0;
        }
    }

    private void hideRole(int id) {
        if (id == 10) {
            this.mapManager.player1.setVisbale(false);
        } else {
            if (this.mapManager.npc != null) {
                for (int i = 0; i < this.mapManager.npc.length; ++i) {
                    if (this.mapManager.npc[i].getRoleID() != id) continue;
                    this.mapManager.npc[i].setVisbale(false);
                }
            }
            for (int j = 0; j < this.playerAry.length; ++j) {
                if (this.playerAry[j] == null || this.playerAry[j].getRoleID() != id) continue;
                this.playerAry[j].setVisbale(false);
            }
            for (int k = 0; k < this.npcVec.size(); ++k) {
                if (((Npc)this.npcVec.elementAt(k)).getRoleID() != id) continue;
                ((Npc)this.npcVec.elementAt(k)).setVisbale(false);
            }
        }
        this.logicState = 0;
    }

    private void hideAllRole(int[] aryid) {
        int j;
        int i;
        if (this.mapManager.npc != null) {
            for (i = 0; i < aryid.length; ++i) {
                for (j = 0; j < this.mapManager.npc.length; ++j) {
                    if (this.mapManager.npc[j].getRoleID() != aryid[i]) continue;
                    this.mapManager.npc[j].setVisbale(false);
                }
            }
        }
        if (this.npcVec.size() != 0) {
            for (i = 0; i < aryid.length; ++i) {
                for (j = 0; j < this.npcVec.size(); ++j) {
                    if (((Npc)this.npcVec.elementAt(j)).getRoleID() != aryid[i]) continue;
                    ((Npc)this.npcVec.elementAt(j)).setVisbale(false);
                }
            }
        }
        this.logicState = 0;
    }

    private void npcsWalkTo() {
        String[] v;
        int i;
        String[] val = this.filmParse.getValue();
        String sub1 = val[0];
        String sub2 = val[1];
        int id1 = 0;
        int id2 = 0;
        String[] tmp1 = Tools.splitStr(sub1, "#");
        String[] tmp2 = Tools.splitStr(sub2, "#");
        id1 = Integer.parseInt(tmp1[0]);
        id2 = Integer.parseInt(tmp2[0]);
        int[][] itmp1 = new int[tmp1.length - 1][2];
        int[][] itmp2 = new int[tmp2.length - 1][2];
        for (i = 1; i < tmp1.length; ++i) {
            v = Tools.splitStr(tmp1[i], "|");
            itmp1[i - 1][0] = Integer.parseInt(v[0]);
            itmp1[i - 1][1] = Integer.parseInt(v[1]);
        }
        for (i = 1; i < tmp2.length; ++i) {
            v = Tools.splitStr(tmp2[i], "|");
            itmp2[i - 1][0] = Integer.parseInt(v[0]);
            itmp2[i - 1][1] = Integer.parseInt(v[1]);
        }
        for (i = 0; i < this.npcVec.size(); ++i) {
            if (((Npc)this.npcVec.elementAt(i)).getRoleID() == id1) {
                this.npcTmp[0] = (Npc)this.npcVec.elementAt(i);
                continue;
            }
            if (((Npc)this.npcVec.elementAt(i)).getRoleID() != id2) continue;
            this.npcTmp[1] = (Npc)this.npcVec.elementAt(i);
        }
        this.moveAry = itmp1;
        this.moveAry1 = itmp2;
        for (i = 0; i < itmp1.length; ++i) {
        }
        for (i = 0; i < itmp2.length; ++i) {
        }
        this.updateState = 20;
        this.actionState = 0;
    }

    private void npcsWalkUpdate() {
        this.npcTmp[0].updateNext();
        this.npcTmp[1].updateNext();
        this.npcTmp[0].setState((byte)5);
        this.npcTmp[1].setState((byte)5);
        if (this.npcTmp[0].loopMoveAry(this.moveAry) & this.npcTmp[1].loopMoveAry(this.moveAry1)) {
            this.npcTmp[0].endloop = false;
            this.npcTmp[1].endloop = false;
            this.updateState = 0;
            this.logicState = 0;
        }
    }

    private void setNpcsPos() {
        String[] tmp = this.filmParse.getValue();
        for (int i = 0; i < tmp.length; ++i) {
            String[] tmp1 = Tools.splitStr(tmp[i], "|");
            for (int j = 0; j < this.npcVec.size(); ++j) {
                if (((Npc)this.npcVec.elementAt(j)).getRoleID() != Integer.parseInt(tmp1[0])) continue;
                ((Npc)this.npcVec.elementAt(j)).setPosition(Integer.parseInt(tmp1[1]), Integer.parseInt(tmp1[2]));
            }
        }
        this.logicState = 0;
    }

    private void showNpcs() {
        String[] tmp = this.filmParse.getValue();
        for (int i = 0; i < tmp.length; ++i) {
            for (int j = 0; j < this.npcVec.size(); ++j) {
                if (((Npc)this.npcVec.elementAt(j)).getRoleID() != Integer.parseInt(tmp[i])) continue;
                ((Npc)this.npcVec.elementAt(j)).setVisbale(true);
            }
            for (int k = 0; k < this.mapManager.npc.length; ++k) {
                if (this.mapManager.npc[k].getRoleID() != Integer.parseInt(tmp[i])) continue;
                this.mapManager.npc[k].setVisbale(true);
            }
        }
        this.logicState = 0;
    }

    private void goFightBoss(int id, int level) {
        FightManager.addEnemy(id, level);
        this.mapManager.gameMain.insertFight();
    }

    public Vector getNpcVec() {
        return this.npcVec;
    }

    public Player[] getPlayerAry() {
        return this.playerAry;
    }
}

