/*
 * Decompiled with CFR 0.152.
 */
package com.game.film;

import com.game.GameMain;
import com.util.Tools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FilmScriptParse {
    private InputStream is;
    private ByteArrayOutputStream bos;
    private String key;
    private String[] value;
    private int readValue;
    public String readstr;

    public FilmScriptParse(int scriptID) {
        this.is = this.getClass().getResourceAsStream("/res/film/script" + scriptID + ".txt");
        this.bos = new ByteArrayOutputStream();
    }

    public boolean hasNext() {
        return this.readValue != -1;
    }

    public String getKey() {
        return this.key;
    }

    public String[] getValue() {
        return this.value;
    }

    public void readNextLine() throws IOException {
        while ((this.readValue = this.is.read()) != -1 && this.readValue != 13) {
            this.bos.write(this.readValue);
        }
        byte[] b = this.bos.toByteArray();
        this.bos.reset();
        String tmp = new String(b, "UTF-8");
        this.readstr = tmp.trim();
        if (this.readstr.equals("")) {
            return;
        }
        GameMain.systemPrintln(this.readstr);
        this.analyzeStr();
    }

    public void close() {
        try {
            this.is.close();
            this.bos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void analyzeStr() {
        String[] str = Tools.splitStr(this.readstr, ":");
        if (str.length < 2) {
            this.key = str[0];
            this.value = null;
        } else {
            this.key = str[0];
            this.value = Tools.splitStr(str[1], ",");
        }
    }
}

