/*
 * Decompiled with CFR 0.152.
 */
package com.game.lib;

import com.game.lib.MySprite;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public abstract class LoadData {
    public static final int SPX_HEADER = 1397772888;
    public static final int SPX_VERSION = 33;
    public static final int SPX_BYTE_SEQUENCE_JAVA = 1;

    public static final void loadSprite(MySprite mySprite, String spxName, Image image) {
        try {
            int j;
            int offset;
            int length;
            int i;
            InputStream is = spxName.getClass().getResourceAsStream(spxName);
            DataInputStream data = new DataInputStream(is);
            int header = data.readInt();
            if (header != 1397772888) {
                throw new Exception("invalid SpriteX format\n");
            }
            byte version = data.readByte();
            if (version != 33) {
                throw new Exception("version no matching\n");
            }
            byte byteSequence = data.readByte();
            if (byteSequence != 1) {
                throw new Exception("byte sequence error\n");
            }
            mySprite.tileCount = data.readInt();
            mySprite.tileData = new int[mySprite.tileCount][4];
            for (i = 0; i < mySprite.tileCount; ++i) {
                mySprite.tileData[i][0] = data.readInt();
                mySprite.tileData[i][1] = data.readInt();
                mySprite.tileData[i][2] = data.readInt();
                mySprite.tileData[i][3] = data.readInt();
            }
            mySprite.frameCount = data.readInt();
            mySprite.frameData = new int[mySprite.frameCount][];
            for (i = 0; i < mySprite.frameCount; ++i) {
                int frameTileCount = data.readInt();
                int collisionCount = data.readInt();
                int referencePointCount = data.readInt();
                length = 8 + frameTileCount * 4 + collisionCount * 4 + referencePointCount * 2;
                mySprite.frameData[i] = new int[length];
                mySprite.frameData[i][0] = length;
                mySprite.frameData[i][1] = frameTileCount;
                mySprite.frameData[i][2] = collisionCount;
                mySprite.frameData[i][3] = referencePointCount;
                mySprite.frameData[i][4] = data.readInt();
                mySprite.frameData[i][5] = data.readInt();
                mySprite.frameData[i][6] = data.readInt();
                mySprite.frameData[i][7] = data.readInt();
                offset = 8;
                for (j = 0; j < frameTileCount; ++j) {
                    mySprite.frameData[i][0 + offset] = data.readInt();
                    mySprite.frameData[i][1 + offset] = data.readInt();
                    mySprite.frameData[i][2 + offset] = data.readInt();
                    mySprite.frameData[i][3 + offset] = data.readInt();
                    offset += 4;
                }
                for (j = 0; j < collisionCount; ++j) {
                    mySprite.frameData[i][0 + offset] = data.readInt();
                    mySprite.frameData[i][1 + offset] = data.readInt();
                    mySprite.frameData[i][2 + offset] = data.readInt();
                    mySprite.frameData[i][3 + offset] = data.readInt();
                    offset += 4;
                }
                for (j = 0; j < referencePointCount; ++j) {
                    mySprite.frameData[i][0 + offset] = data.readInt();
                    mySprite.frameData[i][1 + offset] = data.readInt();
                    offset += 2;
                }
            }
            mySprite.actionCount = data.readInt();
            mySprite.actionData = new int[mySprite.actionCount][];
            for (i = 0; i < mySprite.actionCount; ++i) {
                int sequenceLength = data.readInt();
                byte delay = data.readByte();
                length = delay == 1 ? 4 + sequenceLength * 2 : 4 + sequenceLength;
                mySprite.actionData[i] = new int[length];
                mySprite.actionData[i][0] = length;
                mySprite.actionData[i][1] = sequenceLength;
                mySprite.actionData[i][2] = delay;
                mySprite.actionData[i][3] = data.readInt();
                offset = 4;
                if (delay == 1) {
                    for (j = 0; j < sequenceLength; ++j) {
                        mySprite.actionData[i][offset] = data.readInt();
                        mySprite.actionData[i][offset + 1] = data.readInt();
                        offset += 2;
                    }
                    continue;
                }
                for (j = 0; j < sequenceLength; ++j) {
                    mySprite.actionData[i][offset] = data.readInt();
                    ++offset;
                }
            }
            mySprite.setImage(image);
            mySprite.visbale = true;
            mySprite.nullSprite = false;
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final void untilSprite(MySprite mySprite) {
        mySprite.actionData = null;
        mySprite.image = null;
        mySprite.frameData = null;
        mySprite.tileData = null;
        mySprite.nullSprite = true;
        System.gc();
    }

    public static final void loadSprite(MySprite mySprite, byte[] data1, Image image) {
        try {
            int j;
            int offset;
            int length;
            int i;
            ByteArrayInputStream bais = new ByteArrayInputStream(data1);
            DataInputStream data = new DataInputStream(bais);
            int header = data.readInt();
            if (header != 1397772888) {
                throw new Exception("invalid SpriteX format\n");
            }
            byte version = data.readByte();
            if (version != 33) {
                throw new Exception("version no matching\n");
            }
            byte byteSequence = data.readByte();
            if (byteSequence != 1) {
                throw new Exception("byte sequence error\n");
            }
            mySprite.tileCount = data.readInt();
            mySprite.tileData = new int[mySprite.tileCount][4];
            for (i = 0; i < mySprite.tileCount; ++i) {
                mySprite.tileData[i][0] = data.readInt();
                mySprite.tileData[i][1] = data.readInt();
                mySprite.tileData[i][2] = data.readInt();
                mySprite.tileData[i][3] = data.readInt();
            }
            mySprite.frameCount = data.readInt();
            mySprite.frameData = new int[mySprite.frameCount][];
            for (i = 0; i < mySprite.frameCount; ++i) {
                int frameTileCount = data.readInt();
                int collisionCount = data.readInt();
                int referencePointCount = data.readInt();
                length = 8 + frameTileCount * 4 + collisionCount * 4 + referencePointCount * 2;
                mySprite.frameData[i] = new int[length];
                mySprite.frameData[i][0] = length;
                mySprite.frameData[i][1] = frameTileCount;
                mySprite.frameData[i][2] = collisionCount;
                mySprite.frameData[i][3] = referencePointCount;
                mySprite.frameData[i][4] = data.readInt();
                mySprite.frameData[i][5] = data.readInt();
                mySprite.frameData[i][6] = data.readInt();
                mySprite.frameData[i][7] = data.readInt();
                offset = 8;
                for (j = 0; j < frameTileCount; ++j) {
                    mySprite.frameData[i][0 + offset] = data.readInt();
                    mySprite.frameData[i][1 + offset] = data.readInt();
                    mySprite.frameData[i][2 + offset] = data.readInt();
                    mySprite.frameData[i][3 + offset] = data.readInt();
                    offset += 4;
                }
                for (j = 0; j < collisionCount; ++j) {
                    mySprite.frameData[i][0 + offset] = data.readInt();
                    mySprite.frameData[i][1 + offset] = data.readInt();
                    mySprite.frameData[i][2 + offset] = data.readInt();
                    mySprite.frameData[i][3 + offset] = data.readInt();
                    offset += 4;
                }
                for (j = 0; j < referencePointCount; ++j) {
                    mySprite.frameData[i][0 + offset] = data.readInt();
                    mySprite.frameData[i][1 + offset] = data.readInt();
                    offset += 2;
                }
            }
            mySprite.actionCount = data.readInt();
            mySprite.actionData = new int[mySprite.actionCount][];
            for (i = 0; i < mySprite.actionCount; ++i) {
                int sequenceLength = data.readInt();
                byte delay = data.readByte();
                length = delay == 1 ? 4 + sequenceLength * 2 : 4 + sequenceLength;
                mySprite.actionData[i] = new int[length];
                mySprite.actionData[i][0] = length;
                mySprite.actionData[i][1] = sequenceLength;
                mySprite.actionData[i][2] = delay;
                mySprite.actionData[i][3] = data.readInt();
                offset = 4;
                if (delay == 1) {
                    for (j = 0; j < sequenceLength; ++j) {
                        mySprite.actionData[i][offset] = data.readInt();
                        mySprite.actionData[i][offset + 1] = data.readInt();
                        offset += 2;
                    }
                    continue;
                }
                for (j = 0; j < sequenceLength; ++j) {
                    mySprite.actionData[i][offset] = data.readInt();
                    ++offset;
                }
            }
            mySprite.setImage(image);
            mySprite.visbale = true;
            data.close();
            bais.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static final void copySprite(MySprite oldSprite, MySprite newSprite) {
        int length;
        int i;
        newSprite.actionCount = oldSprite.actionCount;
        newSprite.frameCount = oldSprite.frameCount;
        newSprite.tileCount = oldSprite.tileCount;
        newSprite.actionData = new int[newSprite.actionCount][];
        newSprite.frameData = new int[newSprite.frameCount][];
        newSprite.tileData = new int[newSprite.tileCount][];
        for (i = 0; i < newSprite.actionCount; ++i) {
            length = oldSprite.actionData[i][0];
            newSprite.actionData[i] = new int[length];
            System.arraycopy(oldSprite.actionData[i], 0, newSprite.actionData[i], 0, length);
        }
        for (i = 0; i < newSprite.frameCount; ++i) {
            length = oldSprite.frameData[i][0];
            newSprite.frameData[i] = new int[length];
            System.arraycopy(oldSprite.frameData[i], 0, newSprite.frameData[i], 0, length);
        }
        for (i = 0; i < newSprite.tileCount; ++i) {
            length = 4;
            newSprite.tileData[i] = new int[length];
            System.arraycopy(oldSprite.tileData[i], 0, newSprite.tileData[i], 0, length);
        }
        newSprite.actionIndex = oldSprite.actionIndex;
        newSprite.sequenceIndex = oldSprite.sequenceIndex;
        newSprite.image = oldSprite.image;
        newSprite.x = oldSprite.x;
        newSprite.y = oldSprite.y;
        newSprite.visbale = oldSprite.visbale;
        newSprite.lastTime = oldSprite.lastTime;
        newSprite.firstUpdate = oldSprite.firstUpdate;
        newSprite.disableUpdate = oldSprite.disableUpdate;
    }
}

