/*
 * Decompiled with CFR 0.152.
 */
package com.game.lib;

import com.game.lib.MyTiledLayer;
import com.game.map.MapManager;
import com.game.role.Role;
import javax.microedition.lcdui.Graphics;

public class MainPit {
    int state = 0;
    long ttime;
    private int begin_x = 0;
    private int begin_y = 9;
    private int end_x = 0;
    private int end_y = 0;
    public int mWidth = 20;
    public int mHeight = 20;
    private short[][] data;
    private int openListLength = 0;
    private int closeListLength = 0;
    private boolean[][] closeList;
    private int[][][] openList;
    int count = 0;

    public MainPit(MyTiledLayer mt) {
        this.mWidth = mt.cols;
        this.mHeight = mt.rows;
        this.data = mt.buildingArrary;
    }

    public void setEndXY(int x, int y, int x1, int y1) {
        this.begin_x = x;
        this.begin_y = y;
        this.end_x = x1;
        this.end_y = y1;
    }

    private void addInCloseList(int x, int y) {
        this.closeList[y][x] = true;
        ++this.closeListLength;
    }

    private void addInOpenList(int x, int y) {
        this.openList[y][x][0] = 1;
        ++this.openListLength;
    }

    private void removeFromOpenList(int x, int y) {
        this.openList[y][x][0] = 0;
        --this.openListLength;
    }

    private boolean isBalk(int x, int y) {
        if (x < 0 || x >= this.mWidth || y < 0 || y >= this.mHeight) {
            return true;
        }
        if (this.closeList[y][x]) {
            return true;
        }
        return this.data[y][x] > 0;
    }

    private void setFather(int x, int y, int f) {
        this.openList[y][x][4] = f;
    }

    private void getGHF(int x, int y, int tx, int ty) {
        this.openList[y][x][1] = this.getG(x, y);
        this.openList[y][x][2] = this.getH(x, y, tx, ty);
        this.openList[y][x][3] = this.openList[y][x][1] + this.openList[y][x][3];
    }

    private int getG(int x, int y) {
        switch (this.openList[y][x][4]) {
            default: {
                return this.data[y][x];
            }
            case 1: {
                return this.openList[y - 1][x][1] + this.data[y][x];
            }
            case 2: {
                return this.openList[y + 1][x][1] + this.data[y][x];
            }
            case 3: {
                return this.openList[y][x - 1][1] + this.data[y][x];
            }
            case 4: 
        }
        return this.openList[y][x + 1][1] + this.data[y][x];
    }

    private int getH(int x, int y, int tx, int ty) {
        return Math.abs(x - tx) + Math.abs(y - ty);
    }

    private final void AAsterisk_t(int ttx, int tty, int tx, int ty) {
        if (ttx == tx && tty == ty || this.openListLength == 0) {
            return;
        }
        this.removeFromOpenList(ttx, tty);
        this.addInCloseList(ttx, tty);
        if (!this.isBalk(ttx + 1, tty)) {
            if (this.openList[tty][ttx + 1][0] == 0) {
                this.addInOpenList(ttx + 1, tty);
                this.setFather(ttx + 1, tty, 3);
                this.getGHF(ttx + 1, tty, tx, ty);
            } else if (this.openList[tty][ttx + 1][0] == 1 && this.openList[tty][ttx][1] + this.data[tty][ttx + 1] < this.openList[tty][ttx + 1][1]) {
                this.setFather(ttx + 1, tty, 3);
                this.getGHF(ttx + 1, tty, tx, ty);
            }
        }
        if (!this.isBalk(ttx - 1, tty)) {
            if (this.openList[tty][ttx - 1][0] == 0) {
                this.addInOpenList(ttx - 1, tty);
                this.setFather(ttx - 1, tty, 4);
                this.getGHF(ttx - 1, tty, tx, ty);
            } else if (this.openList[tty][ttx - 1][0] == 1 && this.openList[tty][ttx][1] + this.data[tty][ttx - 1] < this.openList[tty][ttx - 1][1]) {
                this.setFather(ttx - 1, tty, 4);
                this.getGHF(ttx - 1, tty, tx, ty);
            }
        }
        if (!this.isBalk(ttx, tty + 1)) {
            if (this.openList[tty + 1][ttx][0] == 0) {
                this.addInOpenList(ttx, tty + 1);
                this.setFather(ttx, tty + 1, 1);
                this.getGHF(ttx, tty + 1, tx, ty);
            } else if (this.openList[tty + 1][ttx][0] == 1 && this.openList[tty][ttx][1] + this.data[tty + 1][ttx] < this.openList[tty + 1][ttx][1]) {
                this.setFather(ttx, tty + 1, 1);
                this.getGHF(ttx, tty + 1, tx, ty);
            }
        }
        if (!this.isBalk(ttx, tty - 1)) {
            if (this.openList[tty - 1][ttx][0] == 0) {
                this.addInOpenList(ttx, tty - 1);
                this.setFather(ttx, tty - 1, 2);
                this.getGHF(ttx, tty - 1, tx, ty);
            } else if (this.openList[tty - 1][ttx][0] == 1 && this.openList[tty][ttx][1] + this.data[tty - 1][ttx] < this.openList[tty - 1][ttx][1]) {
                this.setFather(ttx, tty - 1, 2);
                this.getGHF(ttx, tty - 1, tx, ty);
            }
        }
        int bx = ttx;
        int by = tty;
        int minf = 255;
        for (int i = 0; i < this.mHeight; ++i) {
            for (int j = 0; j < this.mWidth; ++j) {
                if (this.openList[i][j][0] != 1 || minf <= this.openList[i][j][3]) continue;
                minf = this.openList[i][j][3];
                bx = j;
                by = i;
            }
        }
        this.AAsterisk_t(bx, by, tx, ty);
    }

    public final void AAsterisk(int bx, int by, int tx, int ty) {
        this.closeList = null;
        this.openList = null;
        this.closeList = new boolean[this.mHeight][this.mWidth];
        this.openList = new int[this.mHeight][this.mWidth][5];
        this.closeListLength = 0;
        this.openListLength = 0;
        for (int i = 0; i < this.mHeight; ++i) {
            for (int j = 0; j < this.mWidth; ++j) {
                this.openList[i][j][0] = 0;
                this.openList[i][j][1] = this.data[i][j];
                this.openList[i][j][2] = Math.abs(i - ty) + Math.abs(j - tx);
                this.openList[i][j][3] = this.openList[i][j][1] + this.openList[i][j][2];
                this.openList[i][j][4] = 0;
            }
        }
        this.addInOpenList(bx, by);
        if (!this.isBalk(bx + 1, by)) {
            this.addInOpenList(bx + 1, by);
            this.setFather(bx + 1, by, 3);
            this.getGHF(bx + 1, by, tx, ty);
        }
        if (!this.isBalk(bx - 1, by)) {
            this.addInOpenList(bx - 1, by);
            this.setFather(bx - 1, by, 4);
            this.getGHF(bx - 1, by, tx, ty);
        }
        if (!this.isBalk(bx, by + 1)) {
            this.addInOpenList(bx, by + 1);
            this.setFather(bx, by + 1, 1);
            this.getGHF(bx, by + 1, tx, ty);
        }
        if (!this.isBalk(bx, by - 1)) {
            this.addInOpenList(bx, by - 1);
            this.setFather(bx, by - 1, 2);
            this.getGHF(bx, by - 1, tx, ty);
        }
        this.removeFromOpenList(bx, by);
        this.addInCloseList(bx, by);
        int ttx = bx;
        int tty = by;
        int minf = 255;
        for (int i = 0; i < this.mHeight; ++i) {
            for (int j = 0; j < this.mWidth; ++j) {
                if (this.openList[i][j][0] != 1 || minf <= this.openList[i][j][3]) continue;
                minf = this.openList[i][j][3];
                ttx = j;
                tty = i;
            }
        }
        this.AAsterisk_t(ttx, tty, tx, ty);
    }

    public void showOpenList() {
        for (int i = 0; i < this.mHeight; ++i) {
            for (int j = 0; j < this.mWidth; ++j) {
            }
        }
    }

    public void showCloseList() {
        for (int i = 0; i < this.mHeight; ++i) {
            for (int j = 0; j < this.mWidth; ++j) {
            }
        }
    }

    public void logic(Role player) {
        if (this.end_x == this.begin_x && this.end_y == this.begin_y) {
            return;
        }
        switch (this.openList[this.end_y][this.end_x][4]) {
            case 1: {
                ++this.count;
                player.changeDir(1);
                player.move(0, -4);
                player.updateNext();
                if (this.count < 4) break;
                this.count = 0;
                --this.end_y;
                break;
            }
            case 2: {
                ++this.count;
                player.changeDir(0);
                player.move(0, 4);
                if (this.count < 4) break;
                this.count = 0;
                ++this.end_y;
                break;
            }
            case 3: {
                ++this.count;
                player.changeDir(2);
                player.move(-4, 0);
                if (this.count < 4) break;
                this.count = 0;
                --this.end_x;
                break;
            }
            case 4: {
                ++this.count;
                player.changeDir(3);
                player.move(4, 0);
                if (this.count < 4) break;
                this.count = 0;
                ++this.end_x;
                break;
            }
        }
    }

    public void showfather(Graphics g, int x, int y) {
        if (x == this.begin_x && y == this.begin_y) {
            return;
        }
        g.setColor(0xFF0000);
        g.fillRect(x * 16 - MapManager.winX, y * 16 - MapManager.winY, 16, 16);
        switch (this.openList[y][x][4]) {
            case 1: {
                this.showfather(g, x, y - 1);
                break;
            }
            case 2: {
                this.showfather(g, x, y + 1);
                break;
            }
            case 3: {
                this.showfather(g, x - 1, y);
                break;
            }
            case 4: {
                this.showfather(g, x + 1, y);
                break;
            }
        }
    }
}

