/*
 * Decompiled with CFR 0.152.
 */
package com.game.lib;

import com.game.lib.LoadData;
import com.game.lib.MyLayer;
import com.game.lib.MyTiledLayer;
import com.util.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MySprite
extends MyLayer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    static final int FRAME_HEADER_SIZE = 8;
    static final int FRAME_TILE_COUNT_BIT = 1;
    static final int FRAME_COLLISION_COUNT_BIT = 2;
    static final int FRAME_REFERENCE_POINT_COUNT_BIT = 3;
    static final int FRAME_TOP_POS_BIT = 4;
    static final int FRAME_BOTTOM_POS_BIT = 5;
    static final int FRAME_LEFT_POS_BIT = 6;
    static final int FRAME_RIGHT_POS_BIT = 7;
    static final int ACTION_HEADER_SIZE = 4;
    static final int ACTION_SEQUENCE_LENGTH_BIT = 1;
    static final int ACTION_SEQUENCE_DELAY_BIT = 2;
    static final int ACTION_TRANSFORM_BIT = 3;
    static final int COLLISION_INTERSECT = 1;
    static final int COLLISION_INCLUSION = 2;
    private static final int INVERTED_AXES = 4;
    static final int[][] TRANSFORM_TABLE = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 0, 3, 2, 5, 4, 7, 6}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 2, 1, 0, 7, 6, 5, 4}, {4, 6, 5, 7, 0, 2, 1, 3}, {5, 7, 4, 6, 1, 3, 0, 2}, {6, 4, 7, 5, 2, 0, 3, 1}, {7, 5, 6, 4, 3, 1, 2, 0}};
    int[][] actionData;
    int actionCount;
    int[][] frameData;
    int frameCount;
    int[][] tileData;
    int tileCount;
    int actionIndex;
    int sequenceIndex;
    Image image;
    long lastTime;
    boolean firstUpdate;
    boolean disableUpdate;
    boolean nullSprite;
    int originOffsetX;
    int originOffsetY;
    public int speciType;
    private int number;
    private byte type = 0;
    static final byte READFILEMODE = 0;
    static final byte MANUALMODE = 1;
    static final byte SEQUENCE = 0;
    static final byte SPACETIME = 1;
    static final byte COLLIDES = 2;
    private int currenFrame;
    private int transform;
    private int index;
    public boolean isCollides;
    private int anchor = 20;

    public MySprite(String spxName, Image image) {
        LoadData.loadSprite(this, spxName, image);
    }

    public MySprite(byte[] data, Image image) {
        LoadData.loadSprite(this, data, image);
    }

    public MySprite(String spxName, String imageName, int speciType) {
        LoadData.loadSprite(this, spxName, Tools.loadImage(imageName));
        this.speciType = speciType;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public MySprite() {
    }

    public MySprite(String spxName, String imageName) {
        LoadData.loadSprite(this, spxName, Tools.loadImage(imageName));
    }

    public MySprite(MySprite spx) {
        LoadData.copySprite(spx, this);
    }

    public MySprite(Image image, int widthFrame, int heightFrame) {
        this.type = 1;
        this.image = image;
        this.width = widthFrame;
        this.height = heightFrame;
        this.frameCount = image.getWidth() / this.width * (image.getHeight() / this.height);
        this.actionData = new int[3][];
    }

    public void setImage1(Image image) {
        this.image = image;
        try {
            this.frameCount = image.getWidth() / this.width * (image.getHeight() / this.height);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setImage1(Image image, int widthFrame, int heightFrame, int currenFrame) {
        this.image = image;
        this.width = widthFrame;
        this.height = heightFrame;
        this.currenFrame = currenFrame;
    }

    private final boolean isEnableUpdate() {
        return !this.disableUpdate;
    }

    final void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
    }

    final Image getImage() {
        return this.image;
    }

    public final void setAction(int actionIndex) {
        if (this.type != 0 || this.nullSprite) {
            return;
        }
        if (actionIndex < 0 || actionIndex >= this.actionCount) {
            throw new IndexOutOfBoundsException();
        }
        if (actionIndex != this.actionIndex) {
            this.actionIndex = actionIndex;
            this.sequenceIndex = 0;
            this.firstUpdate = false;
        }
    }

    public final int getAction() {
        return this.actionIndex;
    }

    public final int getActionCount() {
        return this.actionCount;
    }

    public void setFrame(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.getSequenceLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.sequenceIndex = sequenceIndex;
        this.index = 0;
        this.firstUpdate = false;
    }

    public final void setSequence(int[] sequence) {
        if (this.nullSprite) {
            return;
        }
        this.actionData[0] = sequence;
        this.frameCount = sequence.length;
    }

    public final void setSpaceTime(int[] spaceTime) {
        if (this.nullSprite) {
            return;
        }
        this.actionData[1] = spaceTime;
    }

    public final int getFrame() {
        return this.sequenceIndex;
    }

    public final void setTransform(int transform) {
        if (this.nullSprite) {
            return;
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        if (this.type != 0) {
            this.transform = transform;
            return;
        }
        this.actionData[this.actionIndex][3] = transform;
    }

    private final int getTransform() {
        if (this.nullSprite) {
            return 0;
        }
        return this.actionData[this.actionIndex][3];
    }

    public final void nextFrame() {
        if (this.nullSprite) {
            return;
        }
        if (this.type != 0 && this.actionData[0] != null) {
            this.index = (this.index + 1) % this.getSequenceLength();
            this.sequenceIndex = this.actionData[0][this.index];
            this.firstUpdate = false;
            return;
        }
        this.sequenceIndex = (this.sequenceIndex + 1) % this.getSequenceLength();
        this.firstUpdate = false;
    }

    public final void prevFrame() {
        if (this.nullSprite) {
            return;
        }
        if (this.type != 0 && this.actionData[0] != null) {
            this.index = this.index == 0 ? this.getSequenceLength() - 1 : --this.index;
            this.sequenceIndex = this.actionData[0][this.index];
            this.firstUpdate = false;
            return;
        }
        this.sequenceIndex = this.sequenceIndex == 0 ? this.getSequenceLength() - 1 : --this.sequenceIndex;
        this.firstUpdate = false;
    }

    private final void update(long time, int type) {
        if (!this.isEnableUpdate() || this.nullSprite) {
            return;
        }
        if (this.isDelay()) {
            int dms;
            if (!this.firstUpdate) {
                this.firstUpdate = true;
                this.lastTime = time;
            }
            if (time - this.lastTime >= (long)(dms = this.getDelayTime())) {
                if (type == 0) {
                    this.nextFrame();
                } else {
                    this.prevFrame();
                }
                this.lastTime = time;
            }
        }
    }

    public final void updateNext() {
        if (!this.isEnableUpdate() || this.nullSprite) {
            return;
        }
        this.update(System.currentTimeMillis(), 0);
    }

    public final boolean updateNext(int playerNumber) {
        if (this.getFrame() >= this.getSequenceLength() - 1 || this.nullSprite) {
            return true;
        }
        if (!this.isEnableUpdate()) {
            return true;
        }
        this.update(System.currentTimeMillis(), 0);
        return false;
    }

    public final void updatePrev() {
        if (!this.isEnableUpdate() || this.nullSprite) {
            return;
        }
        this.update(System.currentTimeMillis(), 1);
    }

    public final boolean updatePrev(int playerNumber) {
        if (this.nullSprite) {
            return true;
        }
        if (this.getFrame() <= 0) {
            return true;
        }
        if (!this.isEnableUpdate()) {
            return true;
        }
        this.update(System.currentTimeMillis(), 1);
        return false;
    }

    private final int getSequenceFrame(int actionIndex, int sequenceIndex) {
        if (this.type != 0 || this.nullSprite) {
            return 0;
        }
        if (this.isDelay()) {
            return this.actionData[actionIndex][4 + sequenceIndex * 2];
        }
        return this.actionData[actionIndex][4 + sequenceIndex];
    }

    private final int getSequenceFrame() {
        if (this.type != 0 || this.nullSprite) {
            return -1;
        }
        if (this.isDelay()) {
            return this.actionData[this.actionIndex][4 + this.sequenceIndex * 2];
        }
        return this.actionData[this.actionIndex][4 + this.sequenceIndex];
    }

    public final int getSequenceLength() {
        if (this.type != 0 || this.nullSprite) {
            return this.frameCount;
        }
        return this.actionData[this.actionIndex][1];
    }

    private final boolean isDelay() {
        if (this.type != 0) {
            return this.actionData[1] != null;
        }
        return this.actionData[this.actionIndex][2] == 1;
    }

    private final int getDelayTime() {
        if (this.type != 0) {
            return this.actionData[1][this.index];
        }
        return this.actionData[this.actionIndex][4 + this.sequenceIndex * 2 + 1];
    }

    final int getReferencePointX(int index) {
        if (this.nullSprite) {
            return 0;
        }
        int frameIndex = this.getSequenceFrame();
        int frameTileCount = this.frameData[frameIndex][1];
        int frameCollisionCount = this.frameData[frameIndex][2];
        int offset = 8 + frameTileCount * 4 + frameCollisionCount * 4 + index * 2;
        int refX = this.frameData[frameIndex][offset];
        int refY = this.frameData[frameIndex][offset + 1];
        return this.getTransformedReferenceX(refX, refY, this.getTransform()) + this.x;
    }

    final int getReferencePointY(int index) {
        if (this.nullSprite) {
            return 0;
        }
        int frameIndex = this.getSequenceFrame();
        int frameTileCount = this.frameData[frameIndex][1];
        int frameCollisionCount = this.frameData[frameIndex][2];
        int offset = 8 + frameTileCount * 4 + frameCollisionCount * 4 + index * 2;
        int refX = this.frameData[frameIndex][offset];
        int refY = this.frameData[frameIndex][offset + 1];
        return this.getTransformedReferenceY(refX, refY, this.getTransform()) + this.y;
    }

    final int getReferencePointCount(int frameIndex) {
        if (this.nullSprite) {
            return 0;
        }
        if (frameIndex < 0 && frameIndex >= this.frameCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int frameReferencePointCount = this.frameData[frameIndex][3];
        return frameReferencePointCount;
    }

    final int getReferencePointCount() {
        if (this.nullSprite) {
            return 0;
        }
        int frameIndex = this.getSequenceFrame();
        return this.getReferencePointCount(frameIndex);
    }

    int getTransformedReferenceX(int x, int y, int transform) {
        int t_x = 0;
        switch (transform) {
            case 0: {
                t_x = x;
                break;
            }
            case 2: {
                t_x = -x;
            }
        }
        return t_x;
    }

    int getTransformedReferenceY(int x, int y, int transform) {
        int t_y = 0;
        switch (transform) {
            case 0: {
                t_y = y;
                break;
            }
            case 2: {
                t_y = y;
            }
        }
        return t_y;
    }

    private final int getCollidesX(int frame, int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (index < 0 || index >= this.frameData[frame][2]) {
            return 0;
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4;
        return this.frameData[frame][offset] + this.x;
    }

    private final int getCollidesY(int frame, int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (index < 0 || index >= this.frameData[frame][2]) {
            return 0;
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 1;
        return this.frameData[frame][offset] + this.y;
    }

    private final int getCollidesWidth(int frame, int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (index < 0 || index >= this.frameData[frame][2]) {
            return 0;
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 2;
        return this.frameData[frame][offset];
    }

    private final int getCollidesHeight(int frame, int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (index < 0 || index >= this.frameData[frame][2]) {
            return 0;
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 3;
        return this.frameData[frame][offset];
    }

    public final void defaultCollides(int x, int y, int width, int height) {
        if (this.nullSprite) {
            return;
        }
        int[] tem = new int[]{x, y, width, height};
        this.actionData[2] = tem;
    }

    public final int getCollidesX(int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (this.type != 0) {
            if (this.actionData[2] != null) {
                return this.actionData[2][0] + this.x;
            }
            return this.x;
        }
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesX(frameIndex, index);
    }

    public final int getCollideX(int actionIndex, int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (this.type != 0) {
            if (this.actionData[2] != null) {
                return this.actionData[2][0] + this.x;
            }
            return this.x;
        }
        int frameIndex = this.getSequenceFrame(actionIndex, 0);
        return this.getCollidesX(frameIndex, index);
    }

    public final int getCollidesY(int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (this.type != 0) {
            if (this.actionData[2] != null) {
                return this.actionData[2][1] + this.y;
            }
            return this.y;
        }
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesY(frameIndex, index);
    }

    public final int getCollideY(int actionIndex, int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (this.type != 0) {
            if (this.actionData[2] != null) {
                return this.actionData[2][1] + this.y;
            }
            return this.y;
        }
        int frameIndex = this.getSequenceFrame(actionIndex, 0);
        return this.getCollidesY(frameIndex, index);
    }

    public final int getCollidesWidth(int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (this.type != 0) {
            if (this.actionData[2] != null) {
                return this.actionData[2][2];
            }
            return this.width;
        }
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesWidth(frameIndex, index);
    }

    public final int getCollideWidth(int actionIndex, int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (this.type != 0) {
            if (this.actionData[2] != null) {
                return this.actionData[2][2];
            }
            return this.width;
        }
        int frameIndex = this.getSequenceFrame(actionIndex, 0);
        return this.getCollidesWidth(frameIndex, index);
    }

    public final int getCollideHeight(int actionIndex, int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (this.type != 0) {
            if (this.actionData[2] != null) {
                return this.actionData[2][3];
            }
            return this.height;
        }
        int frameIndex = this.getSequenceFrame(actionIndex, 0);
        return this.getCollidesHeight(frameIndex, index);
    }

    public final int getCollidesHeight(int index) {
        if (this.nullSprite) {
            return 0;
        }
        if (this.type != 0) {
            if (this.actionData[2] != null) {
                return this.actionData[2][3];
            }
            return this.height;
        }
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesHeight(frameIndex, index);
    }

    protected final int getCollidesCount(int index) {
        if (this.type != 0 || this.nullSprite) {
            return 1;
        }
        return this.frameData[index][2];
    }

    protected final int getCollidesCount() {
        if (this.type != 0 || this.nullSprite) {
            return 1;
        }
        return this.frameData[this.getSequenceFrame()][2];
    }

    public final boolean collidesWith(MySprite spx, int spxCollides, int thisCollides, int type) {
        if (!spx.visbale || spx.nullSprite) {
            return false;
        }
        int x1 = spx.getCollidesX(spxCollides);
        int y1 = spx.getCollidesY(spxCollides);
        int width1 = spx.getCollidesWidth(spxCollides);
        int height1 = spx.getCollidesHeight(spxCollides);
        return this.collidesWith(x1, y1, width1, height1, thisCollides, type);
    }

    public final boolean collidesWith(Image image, int x, int y, int collides, int type) {
        return this.collidesWith(x, y, image.getWidth(), image.getHeight(), collides, type);
    }

    public final boolean collidesWith(Image image, int x, int y, int collides, int type, int frame) {
        if (frame != 0) {
            return this.collidesWith(x, y, image.getWidth() / frame, image.getHeight(), collides, type);
        }
        return this.collidesWith(x, y, image.getWidth(), image.getHeight(), collides, type);
    }

    private final boolean collidesWith(int x, int y, int width, int height, int collides, int type) {
        if (!this.enabled || this.nullSprite) {
            return false;
        }
        int x1 = this.getCollidesX(collides);
        int y1 = this.getCollidesY(collides);
        int w1 = this.getCollidesWidth(collides);
        int h1 = this.getCollidesHeight(collides);
        if (type == 1) {
            return MySprite.intersectRect(x1, y1, w1, h1, x, y, width, height);
        }
        if (type == 2) {
            return MySprite.inclusionRect(x1, y1, w1, h1, x, y, width, height);
        }
        throw new ArithmeticException();
    }

    public final boolean collidesWith(MySprite spx) {
        if (this.getCollidesCount() == 0 || spx.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(spx, 0, 0, 1);
    }

    public final boolean collidesWith(Image image, int x, int y) {
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(image, x, y, 0, 1);
    }

    public final boolean collidesWith(int x, int y, int width, int height) {
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(x, y, width, height, 0, 1);
    }

    public final int getRefPixelX() {
        if (this.nullSprite) {
            return 0;
        }
        int frameIndex = this.getSequenceFrame();
        int dx = 0;
        dx = frameIndex == -1 ? this.x : this.getFrameLeftPos();
        return dx + (this.getWidth() >> 1);
    }

    public final int getRefPixelY() {
        if (this.nullSprite) {
            return 0;
        }
        int frameIndex = this.getSequenceFrame();
        int dy = 0;
        dy = frameIndex == -1 ? this.x : this.getFrameTopPos();
        return dy + (this.getHeight() >> 1);
    }

    public final int getRefPixelX0() {
        if (this.nullSprite) {
            return 0;
        }
        int frameIndex = this.getSequenceFrame(0, 0);
        int dx = 0;
        dx = frameIndex == -1 ? this.x : this.getFrameLeftPos(0, 0);
        return dx + (this.getWidth(0, 0) >> 1);
    }

    public final int getRefPixelY0() {
        if (this.nullSprite) {
            return 0;
        }
        int frameIndex = this.getSequenceFrame();
        int dy = 0;
        dy = frameIndex == -1 ? this.x : this.getFrameTopPos(0, 0);
        return dy + (this.getHeight(0, 0) >> 1);
    }

    public final boolean collidesWith(MyTiledLayer t, int type) {
        if (this.nullSprite || !this.enabled || !this.visbale) {
            this.isCollides = false;
            return false;
        }
        this.cccc(t, 1, type);
        return this.collidesWith(t, 0, type);
    }

    private final void cccc(MyTiledLayer t, int index, int type) {
        int x1 = this.getCollidesX(index);
        int y1 = this.getCollidesY(index);
        int w1 = this.getCollidesWidth(index);
        int h1 = this.getCollidesHeight(index);
        for (int i = t.startY; i < t.numRows; ++i) {
            for (int j = t.startX; j < t.numCols; ++j) {
                if (t.getCell(j, i, type) == 0) continue;
                if (MySprite.intersectRect(x1, y1, w1, h1, j * 12, i * 12, 12, 12)) {
                    this.isCollides = true;
                    return;
                }
                this.isCollides = false;
            }
        }
    }

    public final boolean collidesWith(MyTiledLayer t, int index, int type) {
        if (this.nullSprite || !this.enabled || !this.visbale) {
            this.isCollides = false;
            return false;
        }
        int x1 = this.getCollidesX(index);
        int y1 = this.getCollidesY(index);
        int w1 = this.getCollidesWidth(index);
        int h1 = this.getCollidesHeight(index);
        for (int i = t.startY; i < t.numRows; ++i) {
            for (int j = t.startX; j < t.numCols; ++j) {
                if (t.getCell(j, i, type) == 0 || !MySprite.intersectRect(x1, y1, w1, h1, j * 12, i * 12, 12, 12)) continue;
                this.isCollides = true;
                return true;
            }
        }
        return false;
    }

    public final int[] collidesWith1(MyTiledLayer t, int type) {
        if (this.nullSprite || !this.enabled || !this.visbale) {
            this.isCollides = false;
            return null;
        }
        this.cccc(t, 1, type);
        return this.collidesWith1(t, 0, type);
    }

    public final int[] collidesWith1(MyTiledLayer t, int index, int type) {
        if (this.nullSprite || !this.enabled || !this.visbale) {
            this.isCollides = false;
            return null;
        }
        int x1 = this.getCollidesX(index);
        int y1 = this.getCollidesY(index);
        int w1 = this.getCollidesWidth(index);
        int h1 = this.getCollidesHeight(index);
        for (int i = t.startY; i < t.numRows; ++i) {
            for (int j = t.startX; j < t.numCols; ++j) {
                if (t.getCell(j, i, type) == 0 || !MySprite.intersectRect(x1, y1, w1, h1, j * 12, i * 12, 12, 12)) continue;
                this.isCollides = true;
                return new int[]{j * 12, i * 12, 12, 12};
            }
        }
        return null;
    }

    public static boolean intersectRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 + height2 >= y1 && y2 <= y1 + height1 && x2 + width2 >= x1 && x2 <= x1 + width1;
    }

    public static boolean inclusionRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 >= y1 && y2 + height2 <= y1 + height1 && x2 >= x1 && x2 + width2 <= x1 + width1;
    }

    public final void originOffset(int x, int y) {
        this.originOffsetX = x;
        this.originOffsetY = y;
    }

    public final void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    private final int getFrameTopPos() {
        return this.frameData[this.getSequenceFrame()][4] + this.y;
    }

    private final int getFrameBottomPos() {
        return this.frameData[this.getSequenceFrame()][5] + this.y;
    }

    private final int getFrameLeftPos() {
        return this.frameData[this.getSequenceFrame()][6] + this.x;
    }

    private final int getFrameRightPos() {
        return this.frameData[this.getSequenceFrame()][7] + this.x;
    }

    public final int getWidth() {
        if (this.type != 0 || this.nullSprite) {
            return this.width;
        }
        return this.getFrameRightPos() - this.getFrameLeftPos();
    }

    public final int getHeight() {
        if (this.type != 0 || this.nullSprite) {
            return this.height;
        }
        return this.getFrameBottomPos() - this.getFrameTopPos();
    }

    private final int getFrameTopPos(int actionIndex, int frameIndex) {
        return this.frameData[this.getSequenceFrame(actionIndex, frameIndex)][4] + this.y;
    }

    private final int getFrameBottomPos(int actionIndex, int frameIndex) {
        return this.frameData[this.getSequenceFrame(actionIndex, frameIndex)][5] + this.y;
    }

    private final int getFrameLeftPos(int actionIndex, int frameIndex) {
        return this.frameData[this.getSequenceFrame(actionIndex, frameIndex)][6] + this.x;
    }

    private final int getFrameRightPos(int actionIndex, int frameIndex) {
        return this.frameData[this.getSequenceFrame(actionIndex, frameIndex)][7] + this.x;
    }

    public final int getWidth(int actionIndex, int frameIndex) {
        if (this.type != 0 || this.nullSprite) {
            return this.width;
        }
        return this.getFrameRightPos(actionIndex, frameIndex) - this.getFrameLeftPos(actionIndex, frameIndex);
    }

    public final int getHeight(int actionIndex, int frameIndex) {
        if (this.type != 0 || this.nullSprite) {
            return this.height;
        }
        return this.getFrameBottomPos(actionIndex, frameIndex) - this.getFrameTopPos(actionIndex, frameIndex);
    }

    private final void paint(Graphics g, int x, int y) {
        x -= this.originOffsetX;
        y -= this.originOffsetY;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int actionTransform = this.getTransform();
        if (actionTransform == 0) {
            int frameIndex = this.getSequenceFrame();
            int tileCount1 = this.frameData[frameIndex][1];
            int offset = 8;
            for (int i = 0; i < tileCount1; ++i) {
                int tileIndex = this.frameData[frameIndex][0 + offset];
                int dx = this.frameData[frameIndex][1 + offset] + x;
                int dy = this.frameData[frameIndex][2 + offset] + y;
                this.transform = this.frameData[frameIndex][3 + offset];
                int tx = this.tileData[tileIndex][0];
                int ty = this.tileData[tileIndex][1];
                int tw = this.tileData[tileIndex][2];
                int th = this.tileData[tileIndex][3];
                if (MySprite.intersectRect(dx, dy, tw, th, clipX, clipY, clipWidth, clipHeight)) {
                    switch (this.speciType) {
                        case 1: {
                            Tools.drawNum(g, this.image, this.number, dx, dy, 10, 3);
                            break;
                        }
                        case 2: {
                            Tools.ImageClip(g, this.image, dx, dy, this.width, this.height, this.transform, this.currenFrame, 3);
                            break;
                        }
                        default: {
                            MySprite.drawRegion(g, this.image, tx, ty, tw, th, this.transform, dx, dy, 20);
                        }
                    }
                }
                offset += 4;
            }
        } else {
            int frameIndex = this.getSequenceFrame();
            int tileCount1 = this.frameData[frameIndex][1];
            int offset = 8;
            for (int i = 0; i < tileCount1; ++i) {
                int tileIndex = this.frameData[frameIndex][0 + offset];
                int dx = this.frameData[frameIndex][1 + offset] + x;
                int dy = this.frameData[frameIndex][2 + offset] + y;
                this.transform = this.frameData[frameIndex][3 + offset];
                int tx = this.tileData[tileIndex][0];
                int ty = this.tileData[tileIndex][1];
                int tw = this.tileData[tileIndex][2];
                int th = this.tileData[tileIndex][3];
                int cx = x - dx;
                int cy = y - dy;
                this.transform = TRANSFORM_TABLE[this.transform][actionTransform];
                switch (actionTransform) {
                    case 0: {
                        break;
                    }
                    case 5: {
                        dx = x - (th - cy);
                        dy = y - cx;
                        break;
                    }
                    case 3: {
                        dx = x - (tw - cx);
                        dy = y - (th - cy);
                        break;
                    }
                    case 6: {
                        dx = x - cy;
                        dy = y - (tw - cx);
                        break;
                    }
                    case 2: {
                        dx = x - (tw - cx);
                        break;
                    }
                    case 7: {
                        dx = x - (th - cy);
                        dy = y - (tw - cx);
                        break;
                    }
                    case 1: {
                        dy = y - (th - cy);
                        break;
                    }
                    case 4: {
                        dx = x - cy;
                        dy = y - cx;
                    }
                }
                if (MySprite.intersectRect(dx, dy, tw, th, clipX, clipY, clipWidth, clipHeight)) {
                    switch (this.speciType) {
                        case 1: {
                            Tools.drawNum(g, this.image, this.number, dx, dy, 10, 3);
                            break;
                        }
                        case 2: {
                            Tools.ImageClip(g, this.image, dx, dy, this.width, this.height, 0, this.currenFrame, 3);
                            break;
                        }
                        default: {
                            MySprite.drawRegion(g, this.image, tx, ty, tw, th, this.transform, dx, dy, 20);
                        }
                    }
                }
                offset += 4;
            }
        }
    }

    public final void paint(Graphics g) {
        if (this.nullSprite || !this.visbale) {
            return;
        }
        switch (this.type) {
            case 0: {
                this.paint(g, this.x, this.y);
                break;
            }
            case 1: {
                this.paint1(g);
            }
        }
    }

    public final void setAnchor(int anchor) {
        this.anchor = anchor;
    }

    private final void paint1(Graphics g) {
        Tools.ImageClip(g, this.image, this.x, this.y, this.width, this.height, this.transform, this.sequenceIndex, this.anchor);
    }

    static final void drawRegionMIDP1(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        if (g == null || src == null) {
            throw new NullPointerException();
        }
        if (!MySprite.checkAnchor(anchor, 64)) {
            throw new IllegalArgumentException();
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        if (width < 0 || height < 0 || x_src < 0 || y_src < 0 || x_src + width > src.getWidth() || y_src + height > src.getHeight()) {
            throw new IllegalArgumentException();
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if ((4 & transform) != 0) {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    y_dest -= width;
                }
                if ((anchor & 8) != 0) {
                    x_dest -= height;
                }
                if ((anchor & 1) != 0) {
                    x_dest -= height / 2;
                }
                if ((anchor & 2) != 0) {
                    y_dest -= width / 2;
                }
            }
            g.clipRect(x_dest, y_dest, height, width);
        } else {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    y_dest -= height;
                }
                if ((anchor & 8) != 0) {
                    x_dest -= width;
                }
                if ((anchor & 1) != 0) {
                    x_dest -= width / 2;
                }
                if ((anchor & 2) != 0) {
                    y_dest -= height / 2;
                }
            }
            g.clipRect(x_dest, y_dest, width, height);
        }
        int x_offset = 0;
        int y_offset = 0;
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        switch (transform) {
            case 0: {
                g.drawImage(src, x_dest - x_src, y_dest - y_src, 20);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                return;
            }
            case 5: {
                x_offset = srcHeight - (y_src + height);
                y_offset = x_src;
                break;
            }
            case 3: {
                x_offset = srcWidth - (x_src + width);
                y_offset = srcHeight - (y_src + height);
                break;
            }
            case 6: {
                x_offset = y_src;
                y_offset = srcWidth - (x_src + width);
                break;
            }
            case 2: {
                x_offset = srcWidth - (x_src + width);
                y_offset = y_src;
                break;
            }
            case 7: {
                x_offset = srcHeight - (y_src + height);
                y_offset = srcWidth - (x_src + width);
                break;
            }
            case 1: {
                x_offset = x_src;
                y_offset = srcHeight - (y_src + height);
                break;
            }
            case 4: {
                x_offset = y_src;
                y_offset = x_src;
            }
        }
        x_dest -= x_offset;
        y_dest -= y_offset;
        int clipX1 = g.getClipX();
        int clipY1 = g.getClipY();
        int clipX2 = g.getClipX() + g.getClipWidth();
        int clipY2 = g.getClipY() + g.getClipHeight();
        if ((4 & transform) != 0) {
            int temp = srcWidth;
            srcWidth = srcHeight;
            srcHeight = temp;
        }
        int src_start_x = Math.max(0, clipX1 - x_dest);
        int src_start_y = Math.max(0, clipY1 - y_dest);
        int dest_start_x = Math.max(clipX1, x_dest);
        int dest_start_y = Math.max(clipY1, y_dest);
        int dest_right = x_dest + srcWidth;
        int dest_bottom = y_dest + srcHeight;
        int copy_width = srcWidth - src_start_x;
        int copy_height = srcHeight - src_start_y;
        copy_width -= Math.max(0, dest_right - clipX2);
        copy_height -= Math.max(0, dest_bottom - clipY2);
        int px = 0;
        int py = 0;
        for (int i = 0; i < copy_height; ++i) {
            for (int j = 0; j < copy_width; ++j) {
                switch (transform) {
                    case 5: {
                        px = src_start_y + i;
                        py = srcWidth - 1 - j - src_start_x;
                        break;
                    }
                    case 3: {
                        px = srcWidth - 1 - j - src_start_x;
                        py = srcHeight - 1 - i - src_start_y;
                        break;
                    }
                    case 6: {
                        px = srcHeight - 1 - i - src_start_y;
                        py = src_start_x + j;
                        break;
                    }
                    case 2: {
                        px = srcWidth - 1 - j - src_start_x;
                        py = src_start_y + i;
                        break;
                    }
                    case 7: {
                        px = srcHeight - 1 - i - src_start_y;
                        py = srcWidth - 1 - j - src_start_x;
                        break;
                    }
                    case 1: {
                        px = src_start_x + j;
                        py = srcHeight - 1 - i - src_start_y;
                        break;
                    }
                    case 4: {
                        px = src_start_y + i;
                        py = src_start_x + j;
                    }
                }
                g.setClip(dest_start_x + j, dest_start_y + i, 1, 1);
                g.drawImage(src, dest_start_x + j - px, dest_start_y + i - py, 20);
            }
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    private static final boolean checkAnchor(int anchor, int illegal_vpos) {
        int n;
        boolean right;
        if (anchor == 0) {
            return true;
        }
        boolean bl = right = anchor > 0 && anchor < 128 && (anchor & illegal_vpos) == 0;
        if (right) {
            n = anchor & 0x72;
            boolean bl2 = right = n != 0 && (n & n - 1) == 0;
        }
        if (right) {
            n = anchor & 0xD;
            right = n != 0 && (n & n - 1) == 0;
        }
        return right;
    }

    public static final void drawRegion(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        g.drawRegion(src, x_src, y_src, width, height, transform, x_dest, y_dest, anchor);
    }
}

