/*
 * Decompiled with CFR 0.152.
 */
package com.game.lib;

import com.game.lib.MyLayer;
import com.game.lib.MySprite;
import com.game.map.MapManager;
import com.util.Tools;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MyTiledLayer
extends MyLayer {
    int rows;
    int cols;
    public static final byte CELL_WIDTH = 12;
    public static final byte CELL_HEIGHT = 12;
    public static final byte TERRA = 1;
    public static final byte COVERING = 2;
    public static final byte BUILDING = 3;
    public static final int DATAMODE = 1;
    public static final int MAPMODE = 2;
    private Image image;
    short[][] buildingArrary;
    short[][] coveringArrary;
    short[][] terraArrary;
    short[][] data;
    private int numX;
    private int numY;
    private int type;
    private int elementSize;
    private LayerData[] element;
    private Vector treeaElement;
    private int winx;
    private int winy;
    private int mode = 0;
    private int xa;
    private int ya;
    int startX;
    int startY;
    int numRows;
    int numCols;

    public MyTiledLayer(int cols, int rows, Image image) {
        this(cols, rows, image, null);
        this.type = 2;
        this.layerType = 1;
    }

    public MyTiledLayer(int cols, int rows, Image image, short[][] data) {
        this.cols = cols;
        this.rows = rows;
        this.image = image;
        this.width = cols * 12;
        this.height = rows * 12;
        this.numX = 21;
        this.numY = 31;
        this.data = data;
        this.type = 1;
    }

    private final void addData(MySprite sprite, boolean isPlayerFlash) {
        if (this.element.length > this.elementSize) {
            this.element[this.elementSize] = this.getLayerData(sprite, isPlayerFlash);
        } else {
            LayerData[] tem = this.element;
            this.element = new LayerData[this.element.length + 1];
            System.arraycopy(tem, 0, this.element, 0, tem.length);
            this.element[this.element.length - 1] = this.getLayerData(sprite, isPlayerFlash);
        }
    }

    private final LayerData getLayerData(MySprite sprite, boolean isFlash) {
        LayerData ld = new LayerData();
        ld.sprite = sprite;
        ld.isPlayerFlash = isFlash;
        return ld;
    }

    public final void addMapTerraElement(MySprite sprite) {
        if (this.treeaElement == null) {
            this.treeaElement = new Vector(1, 1);
        }
        this.treeaElement.addElement(sprite);
    }

    public final void addMapElement(MySprite sprite, boolean isFlash) {
        if (this.element == null) {
            this.element = new LayerData[1];
            this.element[0] = this.getLayerData(sprite, isFlash);
        } else {
            this.addData(sprite, isFlash);
        }
        ++this.elementSize;
    }

    public final void addMapElement(MySprite sprite) {
        this.addMapElement(sprite, false);
    }

    public final void removeMapElement(MySprite sprite) {
        if (this.element != null) {
            int index = 0;
            for (int i = 0; i < this.element.length; ++i) {
                if (!this.element[i].sprite.equals(sprite)) continue;
                index = i;
                break;
            }
            if (index < 0) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            int j = this.elementSize - index - 1;
            if (j > 0) {
                System.arraycopy(this.element, index + 1, this.element, index, j);
            }
            --this.elementSize;
            this.element[this.elementSize] = null;
        }
    }

    public final void setArraryData(short[][] arrary, byte type) {
        switch (type) {
            case 1: {
                this.terraArrary = arrary;
                break;
            }
            case 3: {
                this.buildingArrary = arrary;
                break;
            }
            case 2: {
                this.coveringArrary = arrary;
                break;
            }
            default: {
                this.data = arrary;
            }
        }
    }

    public final void setWindows(int x, int y) {
        this.winx = x;
        this.winy = y;
    }

    public final void setMode(int mode) {
        this.mode = mode;
    }

    public final void paint(Graphics g) {
        if (this.mode == 0) {
            this.setWindows(MapManager.winX, MapManager.winY);
        }
        this.startX = this.winx / 12;
        this.startY = this.winy / 12;
        if (this.startY < 0) {
            this.startY = 0;
        }
        if (this.startX < 0) {
            this.startX = 0;
        }
        this.numRows = this.startY + this.numY > this.rows ? this.rows : this.startY + this.numY;
        int n = this.numCols = this.startX + this.numX > this.cols ? this.cols : this.startX + this.numX;
        if (!this.visbale) {
            return;
        }
        switch (this.type) {
            case 1: {
                this.drawArraryMap(g, this.data);
                break;
            }
            case 2: {
                this.drawArraryMap(g, this.terraArrary);
                this.drawArraryMap(g, this.buildingArrary);
                if (this.treeaElement != null) {
                    for (int i = 0; i < this.treeaElement.size(); ++i) {
                        ((MySprite)this.treeaElement.elementAt(i)).paint(g);
                    }
                }
                this.drawCovering(g);
            }
        }
    }

    private final void drawArraryMap(Graphics g, short[][] arraryData) {
        if (!this.visbale) {
            return;
        }
        this.xa = this.startX * 12;
        this.ya = this.startY * 12;
        for (int i = this.startY; i < this.numRows; ++i) {
            for (int j = this.startX; j < this.numCols; ++j) {
                if (arraryData[i][j] > 0) {
                    Tools.ImageClip(g, this.image, this.xa, this.ya, 12, 12, 0, arraryData[i][j] - 1, 0);
                }
                this.xa += 12;
            }
            this.xa = this.startX * 12;
            this.ya += 12;
        }
        g.setClip(this.winx, this.winy, 240, 320);
    }

    private static final void turnElement(LayerData[] element, int elementSize) {
        for (int i = 0; i < elementSize; ++i) {
            MySprite object1 = element[i].sprite;
            for (int j = elementSize - 1; j > i; --j) {
                MySprite object2 = element[j].sprite;
                if (object1.getY() + object1.getHeight() <= object2.getY() + object2.getHeight()) continue;
                LayerData tem = element[j];
                element[j] = element[i];
                element[i] = tem;
            }
        }
    }

    private final void drawCovering(Graphics g) {
        int i;
        if (this.element != null) {
            MyTiledLayer.turnElement(this.element, this.elementSize);
            if (this.coveringArrary != null) {
                for (i = this.startY; i < this.numRows; ++i) {
                    for (int j = this.startX; j < this.numCols; ++j) {
                        if (this.coveringArrary[i][j] == 0) continue;
                        for (int k = 0; k < this.elementSize; ++k) {
                            MySprite tem = this.element[k].sprite;
                            if (tem.mark == 1) continue;
                            int x1 = tem.getCollidesX(0);
                            int y1 = tem.getCollidesY(0);
                            int w1 = tem.getCollidesWidth(0);
                            int h1 = tem.getCollidesHeight(0);
                            int x2 = tem.getCollidesX(1);
                            int y2 = tem.getCollidesY(1);
                            int w2 = tem.getCollidesWidth(1);
                            int h2 = tem.getCollidesHeight(1);
                            if (MySprite.intersectRect(x1, y1, w1, h1, j * 12, i * 12, 12, 12)) {
                                tem.mark = 1;
                                continue;
                            }
                            if (MySprite.intersectRect(x2, y2, w2, h2, j * 12, i * 12, 12, 12)) {
                                try {
                                    if (y1 <= i * 12 || this.buildingArrary[i + 1][j] != 0 || tem.isCollides) continue;
                                    tem.mark = 1;
                                }
                                catch (Exception ex) {}
                                continue;
                            }
                            if (!(tem.isCollides || MySprite.intersectRect(x2, y2, w2, h2, j * 12, i * 12, 12, 12) || this.element[k].isPlayerFlash)) {
                                tem.mark = (byte)2;
                                continue;
                            }
                            if (!tem.isCollides || MySprite.intersectRect(tem.getX(), tem.getY(), tem.getWidth(), tem.getHeight(), j * 12, i * 12, 12, 12) || this.element[k].isPlayerFlash) continue;
                            tem.mark = (byte)3;
                        }
                    }
                }
            }
            if (this.element != null) {
                for (i = 0; i < this.elementSize; ++i) {
                    MySprite tem = this.element[i].sprite;
                    if (tem.mark == 3 && !this.element[i].isPlayerFlash) {
                        for (int j = i + 1; j < this.elementSize; ++j) {
                            if (this.element[j].sprite.mark == 1) continue;
                            this.element[j].sprite.mark = 0;
                        }
                        tem.mark = 0;
                        continue;
                    }
                    if (this.element[i].isPlayerFlash) {
                        tem.updateNext();
                    }
                    if (tem.mark != 1 && tem.mark != 2) continue;
                    tem.paint(g);
                }
            }
        }
        if (this.coveringArrary != null) {
            this.drawArraryMap(g, this.coveringArrary);
        }
        if (this.element != null) {
            for (i = 0; i < this.elementSize; ++i) {
                MySprite tem = this.element[i].sprite;
                if (this.element[i].isPlayerFlash) {
                    tem.updateNext();
                }
                if (tem.mark == 0) {
                    tem.paint(g);
                }
                if (tem.mark != 1 && tem.mark != 2) continue;
                tem.mark = 0;
            }
        }
    }

    public final int getCell(int col, int row, int type) {
        if (col < 0 || col >= this.cols || row < 0 || row >= this.rows) {
            return 1;
        }
        switch (type) {
            case 1: {
                return this.terraArrary[row][col];
            }
            case 3: {
                return this.buildingArrary[row][col];
            }
            case 2: {
                return this.coveringArrary[row][col];
            }
        }
        return this.data[row][col];
    }

    public void destroy() {
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    class LayerData {
        MySprite sprite;
        boolean isPlayerFlash;

        LayerData() {
        }
    }
}

