/*
 * Decompiled with CFR 0.152.
 */
package com.game.map;

import com.game.lib.ActionSprite;
import com.game.lib.MyLayerManager;
import com.game.lib.MySprite;
import com.game.lib.MyTiledLayer;
import com.util.Tools;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public final class Map {
    private int mapID;
    public MyTiledLayer tiled;
    protected int mapWidth;
    protected int mapHeight;
    private static String[][] fileName = new String[][]{{"zhushinei.bin", "\u5927\u6bbf"}, {"zuixinyewai.bin", "\u8349\u57301"}, {"zuixinyewai.bin", "\u8349\u57302"}, {"zuixinyewai.bin", "\u8349\u57303"}, {"moku.bin", "\u9b54\u6d1e"}};
    public static final int dasitu = 36;
    public static final int dasitu1 = 37;
    public ActionSprite[] actionSprite;
    private int spriteIndex;
    private final String[][] file = new String[][]{{"wuDing", "tingDing", "ta"}, {"hudieA", "denglong", "huopen", "luoye", "dengzhu", "qizhi", "yuA", "denglongzhu", "huomiao", "mao", "zoudongdemao", "yuB", "hudieB"}, {"fangzi", "qitiantai", "mofangzi", "pingfeng"}};

    private Map() {
        this.actionSprite = new ActionSprite[17];
    }

    public static final Map createMap(int mapID, MyLayerManager layer) {
        try {
            InputStream is = "".getClass().getResourceAsStream("/res/map/data/" + fileName[mapID - 1][0]);
            if (is == null) {
                throw new IOException("\u8be5\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            byte[] data = new byte[is.available()];
            is.read(data);
            is.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            data = null;
            DataInputStream di = new DataInputStream(bis);
            Map map = new Map();
            di.readByte();
            map.mapID = mapID;
            di.readUTF();
            int cols = di.readShort();
            int rows = di.readShort();
            Image mapImage = Image.createImage((String)("/res/map/image/" + di.readUTF()));
            map.tiled = new MyTiledLayer(cols, rows, mapImage);
            int dlen = di.readByte();
            for (int i = 0; i < dlen; ++i) {
                map.addMapElements(layer, di.readByte(), di.readByte(), di.readShort() - 500, di.readShort() - 500, di.readBoolean(), di.readShort());
            }
            if (di.readBoolean()) {
                // empty if block
            }
            int len = di.readByte();
            short[][] terraArrary = new short[rows][cols];
            short[][] buildingArrary = new short[rows][cols];
            short[][] coveringArrary = null;
            if (len > 2) {
                coveringArrary = new short[rows][cols];
            }
            for (int i = 0; i < len; ++i) {
                for (int j = 0; j < rows; ++j) {
                    block10: for (int k = 0; k < cols; ++k) {
                        switch (i) {
                            case 0: {
                                terraArrary[j][k] = di.readShort();
                                continue block10;
                            }
                            case 1: {
                                buildingArrary[j][k] = di.readShort();
                                continue block10;
                            }
                            case 2: {
                                coveringArrary[j][k] = di.readShort();
                            }
                        }
                    }
                }
            }
            map.tiled.setArraryData(terraArrary, (byte)1);
            map.tiled.setArraryData(buildingArrary, (byte)3);
            if (coveringArrary != null) {
                map.tiled.setArraryData(coveringArrary, (byte)2);
            }
            map.mapWidth = cols * 12;
            map.mapHeight = rows * 12;
            di.close();
            bis.close();
            terraArrary = null;
            buildingArrary = null;
            coveringArrary = null;
            mapImage = null;
            Runtime.getRuntime().gc();
            return map;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private final void addMapElements(MyLayerManager layermanger, int type, int posType, int x, int y, boolean isTan, short fileIndex) {
        String path = "/res/map/element/";
        Image img = null;
        int temx = x;
        int temy = y;
        if (posType == 1) {
            temx = x * 12;
            temy = y * 12;
        }
        switch (type) {
            case 0: {
                img = Tools.loadImage(path + this.file[0][fileIndex] + ".png");
                MySprite dingl = new MySprite(img, img.getWidth(), img.getHeight());
                dingl.setPosition(temx, temy);
                layermanger.addend(dingl);
                if (!isTan) break;
                dingl = null;
                dingl = new MySprite(img, img.getWidth(), img.getHeight());
                dingl.setTransform(2);
                dingl.setPosition(temx + dingl.getWidth(), temy);
                layermanger.addend(dingl);
                break;
            }
            case 1: {
                img = this.file[1][fileIndex].equals("yuB") ? Tools.loadImage(path + "yuA" + ".png") : (this.file[1][fileIndex].equals("hudieB") ? Tools.loadImage(path + "hudieA" + ".png") : Tools.loadImage(path + this.file[1][fileIndex] + ".png"));
                ActionSprite din = new ActionSprite(path + this.file[1][fileIndex] + ".andyliu", img);
                din.setPosition(temx, temy);
                din.classid = fileIndex;
                if (this.file[1][fileIndex].equals("denglongzhu")) {
                    din.setPosition(temx, temy - (din.getCollideY(0, 0) - din.getY()));
                }
                this.actionSprite[this.spriteIndex] = din;
                ++this.spriteIndex;
                this.tiled.addMapElement(din, true);
                break;
            }
            case 2: {
                img = Tools.loadImage(path + this.file[2][fileIndex] + ".png");
                MySprite di = new MySprite(img, img.getWidth(), img.getHeight());
                di.setPosition(temx, temy);
                this.tiled.addMapTerraElement(di);
                if (!isTan) break;
                di = null;
                di = new MySprite(img, img.getWidth(), img.getHeight());
                di.setTransform(2);
                di.setPosition(temx + di.getWidth(), temy);
                this.tiled.addMapTerraElement(di);
            }
        }
    }

    public final int getMapID() {
        return this.mapID;
    }

    public final String getMapName() {
        return fileName[this.mapID - 1][1];
    }
}

