/*
 * Decompiled with CFR 0.152.
 */
package com.game.map;

import com.IScreen;
import com.MainCanvas;
import com.game.GameMain;
import com.game.fight.FightManager;
import com.game.film.Film;
import com.game.film.FilmManager;
import com.game.film.FilmTrigger;
import com.game.film.TriggerListener;
import com.game.lib.MyLayerManager;
import com.game.lib.MyTiledLayer;
import com.game.map.Map;
import com.game.map.switchPoint.SwitchPoint;
import com.game.map.switchPoint.SwitchPointListener;
import com.game.map.trigger.EmenyTrigger;
import com.game.map.ui.UIManager;
import com.game.role.Npc;
import com.game.role.Player;
import com.game.talk.TalkBean;
import com.game.talk.TalkListenerEx;
import com.game.talk.TalkManagerEx;
import com.game.tishi.TipBean;
import com.game.tishi.TipListener;
import com.game.tishi.TipManager;
import com.util.Propertys;
import com.util.Tools;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MapManager
implements IScreen,
SwitchPointListener,
TipListener,
TriggerListener,
TalkListenerEx {
    public static int winX;
    public static int winY;
    public static int tempPlayerX;
    public static int tempPlayerY;
    public static int tempPlayerDir;
    public static final int SHOWMAP = 1;
    public static final int SHOWUI = 2;
    public static final int SHOWFLASH = 3;
    public static final int FRAMEMAX = 100;
    public int state = 1;
    public boolean isShowTip;
    public boolean isShowTalk;
    public static boolean isShowMapName;
    public Map map;
    public GameMain gameMain;
    public static int currenMapID;
    public Player player1;
    public SwitchPoint[] point;
    public Npc[] npc;
    private FilmTrigger filmTrigger;
    private FilmManager fm;
    private TalkManagerEx talkScreen;
    public static int weatherState;
    public static int weatherDegreen;
    public static int weatherVal;
    private long curtime;
    private int frameCtr;
    private EmenyTrigger[] trigger;
    private int EffectIndex;
    private boolean Transition = true;
    private int TransitionTimer;
    private int weatherFrame;
    private boolean iseffctOK;
    private Image imgbtn;
    private UIManager uiManager;
    public static boolean isMounts;
    public MyLayerManager layer;
    public TipManager tip;
    public static int tmpstate;
    public int deCount;
    private String[] fightsence = new String[]{"", "caodi.bin", "caodi.bin", "caodi.bin", "caodi.bin"};

    public MapManager(GameMain gameMain) {
        this.gameMain = gameMain;
    }

    public void setPlayer() {
        if (tempPlayerX != 0) {
            this.player1.setPosition(tempPlayerX, tempPlayerY);
            this.player1.changeDir(tempPlayerDir);
            this.player1.setState((byte)4);
        }
    }

    public void resetWindowXY(Player p) {
        if (!p.isVisbale()) {
            return;
        }
        winX = p.getX() - 120;
        winY = p.getY() - 160;
        if (p.getX() + p.getWidth() > winX + 240) {
            winX = p.getX() - 120;
        }
        if (p.getY() + p.getHeight() > winY + 320) {
            winY = p.getY() - 160;
        }
        if (240 > this.map.mapWidth) {
            winX = -240 + this.map.mapWidth >> 1;
        } else {
            if (winX < 0) {
                winX = 0;
            }
            if (winX + 240 > this.map.mapWidth) {
                winX = this.map.mapWidth - 240;
            }
        }
        if (320 > this.map.mapHeight) {
            winY = -320 + this.map.mapHeight >> 1;
        } else {
            if (winY < 0) {
                winY = 0;
            }
            if (winY + 320 > this.map.mapHeight) {
                winY = this.map.mapHeight - 320;
            }
        }
        if (p.getX() + p.getWidth() > winX + 240) {
            winX = p.getX() - 120;
        }
        if (p.getY() + p.getHeight() > winY + 320) {
            winY = p.getY() - 160;
        }
        if (240 > this.map.mapWidth) {
            winX = -240 + this.map.mapWidth >> 1;
        } else {
            if (winX < 0) {
                winX = 0;
            }
            if (winX + 240 > this.map.mapWidth) {
                winX = this.map.mapWidth - 240;
            }
        }
        if (320 > this.map.mapHeight) {
            winY = -320 + this.map.mapHeight >> 1;
        } else {
            if (winY < 0) {
                winY = 0;
            }
            if (winY + 320 > this.map.mapHeight) {
                winY = this.map.mapHeight - 320;
            }
        }
    }

    public void setWindows(int winx, int winy) {
        winX = winx;
        if (winx < 0 && this.map.mapWidth - 240 > 0) {
            winX = 0;
        }
        if (winx > this.map.mapWidth - 240 && this.map.mapWidth - 240 > 0) {
            winX = this.map.mapWidth - 240;
        }
        winY = winy;
        if (winy < 0 && this.map.mapHeight - 320 > 0) {
            winY = 0;
        }
        if (winy > this.map.mapHeight - 320 && this.map.mapHeight - 320 > 0) {
            winY = this.map.mapHeight - 320;
        }
    }

    public void moveWindows(int speedx, int speedy) {
        if ((winX < this.map.mapWidth - 240 || speedx < 0) && (winX += speedx) < 0) {
            winX = 0;
        }
        if ((winY < this.map.mapHeight - 320 || speedy < 0) && (winY += speedy) < 0) {
            winY = 0;
        }
        this.setWindows(winX, winY);
    }

    public boolean inti(int num) {
        switch (num) {
            case 0: {
                if (GameMain.isReadGame) {
                    this.gameMain.readGame(this);
                    GameMain.readMsg();
                    GameMain.isSetPos = true;
                    GameMain.isReadGame = false;
                } else {
                    this.gameMain.newGame(this);
                }
                this.player1 = this.gameMain.team.getLeader();
                this.setPlayer();
                this.npc = Npc.loadNpc(this, currenMapID);
                this.filmTrigger = new FilmTrigger(this);
                this.filmTrigger.setListener(this);
                if (currenMapID != 36 && currenMapID != 37) {
                    Image switchImage = Tools.loadImage("/res/map/misc/point.png");
                    this.point = SwitchPoint.loadPonit(this, switchImage, currenMapID);
                    switchImage = null;
                } else {
                    this.point = SwitchPoint.loadWordmapPonit(this, currenMapID);
                }
                for (int i = 0; i < this.point.length; ++i) {
                    this.point[i].setListen(this);
                }
                this.imgbtn = Tools.loadImage("/res/ui/words.png");
                return false;
            }
            case 1: {
                this.layer = new MyLayerManager();
                this.map = Map.createMap(currenMapID, this.layer);
                this.loadMapInfo();
                this.resetWindowXY(this.player1);
                return false;
            }
            case 2: {
                int i;
                this.map.tiled.addMapElement(this.player1);
                if (this.npc != null) {
                    for (i = 0; i < this.npc.length; ++i) {
                        this.map.tiled.addMapElement(this.npc[i]);
                    }
                }
                if (this.point != null) {
                    for (i = 0; i < this.point.length; ++i) {
                        this.map.tiled.addMapElement(this.point[i]);
                    }
                }
                this.layer.append(this.map.tiled);
                this.curtime = System.currentTimeMillis();
                this.trigger = EmenyTrigger.loadEmeny(this, currenMapID);
                if (this.trigger != null) {
                    for (i = 0; i < this.trigger.length; ++i) {
                        if (this.gameMain.emenyViewState[this.trigger[i].id] == 1) {
                            this.trigger[i].setVisbale(false);
                        }
                        this.layer.addend(this.trigger[i]);
                    }
                }
                this.EffectIndex = Tools.getRand(3);
                if (GameMain.isMusic) {
                    MainCanvas.openMusic("/res/map.mid");
                }
                return true;
            }
        }
        return true;
    }

    private void initEmeny(int mapid) {
    }

    public boolean keyPressedItem(int key) {
        if (this.isShowTip) {
            return this.tip.keyPressedItem(key);
        }
        if (this.isShowTalk && this.talkScreen != null) {
            return this.talkScreen.keyPressedItem(key);
        }
        switch (this.state) {
            case 1: {
                int i;
                switch (key) {
                    case 10: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 17: {
                        this.setState(2, 0);
                        break;
                    }
                    case 18: {
                        break;
                    }
                    case 12: {
                        MainCanvas.setAllRender(true);
                        break;
                    }
                    case 11: {
                        return false;
                    }
                }
                if (!isMounts && this.player1.keyPressedItem(key)) {
                    GameMain.systemPrintln("state" + this.state);
                    return false;
                }
                if (this.npc != null) {
                    for (i = 0; i < this.npc.length; ++i) {
                        if (this.npc[i] == null || !this.npc[i].isVisbale() || !this.npc[i].keyPressedItem(key)) continue;
                        return true;
                    }
                }
                if (this.point == null) break;
                for (i = 0; i < this.point.length; ++i) {
                    if (this.point[i] == null || !this.point[i].isVisbale() || isMounts || !this.point[i].key(key, this.player1)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                this.uiManager.keyPressedItem(key);
                break;
            }
            case 3: {
                this.fm.keyPressedItem(key);
            }
        }
        return false;
    }

    public boolean keyRepeatedItem(int key) {
        switch (this.state) {
            case 1: {
                if (isMounts || !this.player1.keyRepeatedItem(key)) break;
                return false;
            }
            case 2: {
                if (this.uiManager == null) break;
                this.uiManager.keyRepeatedItem(key);
            }
        }
        return false;
    }

    public boolean pointerPressedItem(int x, int y) {
        return false;
    }

    public void logic() {
        int i;
        this.frameCtr = this.frameCtr >= 500 ? 0 : ++this.frameCtr;
        if (this.npc != null) {
            for (i = 0; i < this.npc.length; ++i) {
                if (this.frameCtr % 3 != 0) continue;
                this.npc[i].nextFrame();
            }
        }
        if (!isMounts && this.player1 != null) {
            this.player1.logic();
        }
        if (this.npc != null) {
            for (i = 0; i < this.npc.length; ++i) {
                if (this.npc[i] == null || !this.npc[i].isVisbale()) continue;
                this.npc[i].logic();
            }
        }
        if (this.isShowTip) {
            this.tip.logic();
        }
        if (this.isShowTalk && this.talkScreen != null) {
            this.talkScreen.logic();
        }
        switch (this.state) {
            case 1: {
                int i2;
                try {
                    if (Player.film != null) {
                        this.filmTrigger.logic();
                    }
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
                if (this.Transition) {
                    ++this.TransitionTimer;
                }
                for (i2 = 0; i2 < this.point.length; ++i2) {
                    if (isMounts || !this.point[i2].logic(this.player1)) continue;
                    return;
                }
                if (this.trigger == null || this.isShowTip || this.isShowTalk) break;
                for (i2 = 0; i2 < this.trigger.length; ++i2) {
                    if (this.gameMain.emenyViewState[this.trigger[i2].id] == 1) {
                        this.trigger[i2].setVisbale(false);
                        continue;
                    }
                    this.trigger[i2].setVisbale(true);
                    this.trigger[i2].logic();
                }
                break;
            }
            case 3: {
                for (i = 0; i < this.point.length; ++i) {
                    this.point[i].nextFrame();
                }
                if (this.trigger != null) {
                    for (i = 0; i < this.trigger.length; ++i) {
                        this.trigger[i].setVisbale(false);
                    }
                }
                if (this.Transition) {
                    ++this.TransitionTimer;
                }
                this.fm.logic();
            }
        }
    }

    public MyTiledLayer returnTiled() {
        return this.map.tiled;
    }

    public void paint(Graphics g) {
        Tools.clearScreenOrClip(g, 0);
        switch (this.state) {
            case 1: {
                this.drawMapScreen(g);
                this.ScreenEffect(g);
                break;
            }
            case 2: {
                this.drawMapScreen(g);
                if (this.uiManager == null) break;
                this.uiManager.paint(g);
                break;
            }
            case 3: {
                this.drawMapScreen(g);
                this.ScreenEffect(g);
                if (this.fm == null) break;
                this.fm.paint(g);
            }
        }
        if (this.isShowTip) {
            this.tip.paint(g);
            if (this.fm != null) {
                if (Player.film.scriptID == 2) {
                    if (this.fm.getPlayer().qiankun != null) {
                        this.fm.getPlayer().qiankun.nextFrame();
                    }
                    if (this.fm.getPlayer().zhiliao != null) {
                        this.fm.getPlayer().zhiliao.nextFrame();
                    }
                    if (this.fm.getPlayer().huoguang != null) {
                        this.fm.getPlayer().huoguang.nextFrame();
                    }
                }
            }
            return;
        }
        if (this.isShowTalk && this.deCount > 16) {
            this.drawFlashSpecific(g);
            if (this.talkScreen != null) {
                this.talkScreen.paint(g);
            }
        }
    }

    private final void drawMapScreen(Graphics g) {
        int i;
        this.layer.setViewWindow(winX, winY);
        this.layer.paint(g);
        if (this.point != null) {
            for (i = 0; i < this.point.length; ++i) {
                if (this.point[i] == null || !this.point[i].isVisbale()) continue;
                this.point[i].draw(g);
            }
        }
        if (this.npc != null) {
            for (i = 0; i < this.npc.length; ++i) {
                if (this.npc[i] == null || !this.npc[i].isVisbale()) continue;
                this.npc[i].draw(g);
            }
        }
        if (this.state != 3 && !this.isShowTalk && !this.isShowTip) {
            g.drawRegion(this.imgbtn, 0, 0, this.imgbtn.getWidth(), this.imgbtn.getHeight() / 2, 0, 0, 320 - this.imgbtn.getHeight() / 2, 0);
        }
        this.player1.draw(g);
        if (isShowMapName) {
            GameMain.frame.drawmFrameForMapName(g, this.map.getMapName(), 0, 0, 0xFFFFFF);
        }
    }

    public final void drawFlashSpecific(Graphics g) {
        block22: {
            block23: {
                int i;
                if (this.fm != null && !this.fm.getPlayer().getNpcVec().isEmpty()) {
                    for (i = 0; i < this.fm.getPlayer().getNpcVec().size(); ++i) {
                        int id;
                        if (this.frameCtr % 3 == 0) {
                            ((Npc)this.fm.getPlayer().getNpcVec().elementAt(i)).nextFrame();
                        }
                        if ((id = ((Npc)this.fm.getPlayer().getNpcVec().elementAt(i)).getRoleID()) == 7 || id == 8 || id == 19 || id == 22 || id == 28 || id == 29 || id == 32 || id == 33) continue;
                        ((Npc)this.fm.getPlayer().getNpcVec().elementAt(i)).draw(g);
                    }
                }
                if (this.fm != null) {
                    for (i = 0; i < this.fm.getPlayer().getPlayerAry().length; ++i) {
                        if (this.fm.getPlayer().getPlayerAry()[i] == null) continue;
                        this.fm.getPlayer().getPlayerAry()[i].draw(g);
                    }
                }
                if (this.fm != null) {
                    if (Player.film.scriptID == 1) {
                        if (this.fm.getPlayer().qiling != null) {
                            this.fm.getPlayer().qiling.nextFrame();
                        }
                        if (this.fm.getPlayer().xiepusa != null) {
                            this.fm.getPlayer().xiepusa.nextFrame();
                        }
                    }
                }
                if (this.fm == null) break block22;
                if (Player.film.scriptID == 15) break block23;
                if (Player.film.scriptID != 1) break block22;
            }
            if (this.fm.getPlayer().zhuzi != null) {
                this.fm.getPlayer().zhuzi.nextFrame();
            }
        }
        if (this.fm != null) {
            if (Player.film.scriptID == 2) {
                if (this.fm.getPlayer().qiankun != null) {
                    this.fm.getPlayer().qiankun.nextFrame();
                }
                if (this.fm.getPlayer().zhiliao != null) {
                    this.fm.getPlayer().zhiliao.nextFrame();
                }
                if (this.fm.getPlayer().huoguang != null) {
                    this.fm.getPlayer().huoguang.nextFrame();
                }
            }
        }
        if (this.fm != null) {
            if (Player.film.scriptID == 15) {
                if (this.fm.getPlayer().qiling != null) {
                    this.fm.getPlayer().qiling.nextFrame();
                }
                if (this.fm.getPlayer().xiepusa != null) {
                    this.fm.getPlayer().xiepusa.nextFrame();
                }
            }
        }
    }

    public int getMapWidth() {
        return this.map.mapWidth;
    }

    public int getMapHeight() {
        return this.map.mapHeight;
    }

    public void destroy() {
        if (!GameMain.isSetPos) {
            tempPlayerY = 0;
            tempPlayerX = 0;
            tempPlayerDir = 0;
            winY = 0;
            winX = 0;
        } else if (MainCanvas.intiGame != 3) {
            tempPlayerX = this.player1.getX();
            tempPlayerY = this.player1.getY();
            tempPlayerDir = this.player1.dir;
        }
        MainCanvas.untilMusic();
        this.gameMain.team.removePlayer();
        this.layer = null;
        System.gc();
    }

    public void switchResponseItem() {
        this.gameMain.switchMap();
    }

    public final void setTip(TipBean tipBean) {
        if (this.tip == null) {
            this.tip = new TipManager();
            this.tip.setTipBean(tipBean);
            this.tip.setTipListener(this);
            this.isShowTip = true;
        }
        MainCanvas.setKeyRepeatedRender(false);
    }

    public final void setTipString(String[] str) {
        TipBean tishiBean = new TipBean();
        tishiBean.setTipMessage(str);
        this.setTip(tishiBean);
    }

    public void returnTipItem() {
        this.destoryTip();
    }

    public void setNpcFace(int npcID, int faceType, int talktype) {
        switch (talktype) {
            case 0: 
            case 1: 
            case 2: {
                if (npcID == 1000) {
                    this.player1.setIsFace(true, faceType);
                    return;
                }
                if (this.player1.getRoleID() == npcID) {
                    this.player1.setIsFace(true, faceType);
                    break;
                }
                if (this.npc == null) break;
                for (int i = 0; i < this.npc.length; ++i) {
                    if (this.npc[i] == null || !this.npc[i].isVisbale() || this.npc[i].getRoleID() != npcID) continue;
                    this.npc[i].setIsFace(true, faceType);
                    return;
                }
                break;
            }
            case 3: 
            case 4: {
                int i;
                if (npcID == 1000) {
                    this.player1.setIsFace(true, faceType);
                    return;
                }
                if (this.player1.getRoleID() == npcID) {
                    this.player1.setIsFace(true, faceType);
                    break;
                }
                Vector vec = this.fm.getPlayer().getNpcVec();
                Player[] ary = this.fm.getPlayer().getPlayerAry();
                for (i = 0; i < vec.size(); ++i) {
                    if (((Npc)vec.elementAt(i)).getRoleID() != npcID) continue;
                    ((Npc)vec.elementAt(i)).setIsFace(true, faceType);
                }
                for (int j = 0; j < ary.length; ++j) {
                    if (ary[j] == null || ary[j].getRoleID() != npcID) continue;
                    ary[j].setIsFace(true, faceType);
                }
                if (this.npc == null) break;
                for (i = 0; i < this.npc.length; ++i) {
                    if (this.npc[i] == null || !this.npc[i].isVisbale() || this.npc[i].getRoleID() != npcID) continue;
                    this.npc[i].setIsFace(true, faceType);
                    return;
                }
                break;
            }
        }
    }

    public void destroyNpcFace(int npcID) {
        GameMain.systemPrintln("npcID" + npcID + "faceType");
        if (npcID == 1000) {
            this.player1.setIsFace(false, 0);
            return;
        }
        if (this.player1.getRoleID() == npcID) {
            this.player1.setIsFace(false, 0);
        } else if (this.npc != null) {
            for (int i = 0; i < this.npc.length; ++i) {
                if (this.npc[i] == null || !this.npc[i].isVisbale() || this.npc[i].getRoleID() != npcID) continue;
                this.npc[i].setIsFace(false, 0);
                return;
            }
        }
        if (this.fm != null) {
            Vector vec = this.fm.getPlayer().getNpcVec();
            Player[] ary = this.fm.getPlayer().getPlayerAry();
            for (int i = 0; i < vec.size(); ++i) {
                if (((Npc)vec.elementAt(i)).getRoleID() != npcID) continue;
                ((Npc)vec.elementAt(i)).setIsFace(false, 0);
            }
            for (int j = 0; j < ary.length; ++j) {
                if (ary[j] == null || ary[j].getRoleID() != npcID) continue;
                ary[j].setIsFace(false, 0);
            }
        }
    }

    public boolean checkSence() {
        if (Player.film != null) {
            if (currenMapID == Player.film.senceID) {
                return true;
            }
        }
        if (Player.film != null) {
            if (Player.film.senceID == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean checkRect() {
        if (Player.film != null) {
            if (Player.film.rect == null) {
                return true;
            }
            if (!isMounts) {
                return this.player1.getX() > Player.film.rect[0] & this.player1.getX() < Player.film.rect[2] & this.player1.getY() > Player.film.rect[1] & this.player1.getY() < Player.film.rect[3];
            }
            return false;
        }
        return true;
    }

    public boolean checkLevel() {
        if (Player.film != null) {
            if (Player.film.level == 0) {
                return true;
            }
            return this.player1.property.getGrade() >= Player.film.level;
        }
        return true;
    }

    public boolean checkGetMission() {
        if (Player.film != null) {
            if (Player.mainMissionID == Player.film.getMissionID) {
                return true;
            }
        }
        if (Player.film != null) {
            if (Player.film.getMissionID == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean checkCompleteMission() {
        return true;
    }

    public final void backMap() {
        if (this.uiManager != null) {
            this.uiManager.destroy();
            this.uiManager = null;
        }
        if (tmpstate == 3) {
            this.state = 3;
            GameMain.systemPrintln("return to flash");
            tmpstate = -1;
        } else {
            this.state = TalkBean.type == 3 ? 3 : 1;
        }
        MainCanvas.setAllRender(true);
        MainCanvas.setKeyRender(true);
        MainCanvas.setKeyRepeatedRender(true);
        Runtime.getRuntime().gc();
    }

    public boolean checkPack() {
        return true;
    }

    public void setState(int state, int subState) {
        switch (state) {
            case 2: {
                MainCanvas.setAllRender(false);
                this.uiManager = new UIManager(this);
                this.uiManager.setState(subState);
                this.uiManager.intiUI(subState);
                MainCanvas.setAllRender(true);
            }
        }
        this.state = state;
    }

    public void bindFilm(int id) {
        Player.film = Film.createFilm(id);
    }

    public Film getFilm() {
        return null;
    }

    public void initTalk(int talkId) {
        this.talkScreen = new TalkManagerEx(this.gameMain);
        this.talkScreen.setListener(this);
        this.talkScreen.setTalkBean(TalkBean.createTalkBean("/res/data/talk/talk" + talkId + ".txt"), this.state, talkId);
        this.isShowTalk = true;
        if (this.isShowTip) {
            this.isShowTip = false;
            if (this.tip != null) {
                this.tip.destroy();
                this.tip = null;
            }
        }
        MainCanvas.setKeyRepeatedRender(false);
    }

    public void returnTalkItem(int state, int subState) {
        if (subState >= 0 && state == 1) {
            this.setState(2, subState);
        } else if (state == 3 && subState < 0) {
            GameMain.systemPrintln("return flash");
            this.setState(3, subState);
        } else if (state == 3 && subState > 0) {
            tmpstate = 3;
            this.setState(2, subState);
        } else if (state == 2 && subState < 0) {
            this.state = 2;
        } else {
            this.setState(1, subState);
        }
        this.player1.setIsFace(false, 0);
        this.destoryTalk();
        MainCanvas.setKeyRepeatedRender(true);
    }

    public void destoryTalk() {
        if (this.talkScreen != null) {
            this.talkScreen.destroy();
            this.talkScreen = null;
        }
        this.isShowTalk = false;
    }

    public void initFilmManager() {
        this.fm = new FilmManager(this, Player.film);
    }

    public void destoryFilmManager() {
        GameMain.systemPrintln("destoryFilmManager");
        this.setState(1, -1);
        this.fm.destory();
        this.fm = null;
        System.gc();
    }

    public Npc getCurrentMapNpc(int id) {
        if (this.npc == null) {
            return null;
        }
        for (int i = 0; i < this.npc.length; ++i) {
            if (this.npc[i].getRoleID() != id) continue;
            return this.npc[i];
        }
        return null;
    }

    private boolean drawBuff(Graphics g) {
        ++this.deCount;
        int preCole = g.getColor();
        if (this.deCount >= 10) {
            if (this.deCount < 13) {
                this.Transition = true;
            }
            return true;
        }
        g.setColor(0);
        g.fillRect(0, 0, 240, this.deCount * 32);
        g.fillRect(0, 320 - this.deCount * 32, 240, 320);
        g.setColor(preCole);
        return false;
    }

    public void destoryTip() {
        this.isShowTip = false;
        this.tip.destroy();
        this.tip = null;
        Runtime.getRuntime().gc();
        MainCanvas.setKeyRepeatedRender(true);
    }

    public void setTipString(String[] str, byte type) {
    }

    public void ScreenEffect(Graphics g) {
        ++this.deCount;
        int preCole = g.getColor();
        if (this.deCount >= 10) {
            if (this.deCount < 13) {
                this.Transition = true;
            }
        } else {
            g.setColor(0);
            g.fillRect(0, 0, 240, 320);
            g.setColor(preCole);
        }
        g.setColor(0);
        switch (this.EffectIndex) {
            case 0: {
                if (!this.Transition) break;
                for (int j = 20; j >= 0; --j) {
                    for (int i = 15; i >= 0; --i) {
                        g.fillRect(i * 16 + this.TransitionTimer, j * 16 + this.TransitionTimer, 16 - (this.TransitionTimer << 1), 16 - (this.TransitionTimer << 1));
                    }
                }
                if (this.TransitionTimer << 1 < 16) break;
                this.TransitionTimer = 0;
                this.Transition = false;
                this.iseffctOK = true;
                break;
            }
            case 1: {
                if (!this.Transition) break;
                for (int j = 20; j >= 0; --j) {
                    for (int i = 15; i >= 0; --i) {
                        g.fillRect(i * 16 + this.TransitionTimer, j * 16, 16 - (this.TransitionTimer << 1), 320);
                    }
                }
                if (this.TransitionTimer << 1 < 16) break;
                this.TransitionTimer = 0;
                this.Transition = false;
                this.iseffctOK = true;
                break;
            }
            case 2: {
                if (!this.Transition) break;
                for (int j = 20; j >= 0; --j) {
                    for (int i = 15; i >= 0; --i) {
                        g.fillRect(i * 16, j * 16 + this.TransitionTimer, 240, 16 - (this.TransitionTimer << 1));
                    }
                }
                if (this.TransitionTimer << 1 < 16) break;
                this.TransitionTimer = 0;
                this.Transition = false;
                this.iseffctOK = true;
            }
        }
    }

    public void hideAnimal() {
        for (int i = 0; i < this.map.actionSprite.length; ++i) {
            if (this.map.actionSprite[i] == null) continue;
            switch (this.map.actionSprite[i].classid) {
                case 0: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.map.actionSprite[i].setVisbale(false);
                }
            }
        }
    }

    public void loadMapInfo() {
        this.changeWeather();
        Propertys ps = Propertys.loadPropertys("/res/data/mapinfo.txt");
        int val = ps.getIntProperts("w" + currenMapID);
        block0 : switch (val) {
            case 0: {
                weatherState = 1000;
                break;
            }
            case 1: {
                switch (weatherDegreen) {
                    case 0: {
                        weatherState = 1000;
                        break;
                    }
                    case 1: {
                        weatherVal = weatherState = 1001;
                        this.hideAnimal();
                        break;
                    }
                    case 2: {
                        weatherState = weatherState == 1000 ? 1001 : 1002;
                        weatherVal = weatherState;
                        this.hideAnimal();
                    }
                }
                break;
            }
            case 2: {
                switch (weatherDegreen) {
                    case 0: {
                        weatherState = 1000;
                        break block0;
                    }
                    case 1: {
                        weatherVal = weatherState = 1004;
                        this.hideAnimal();
                        break block0;
                    }
                    case 2: {
                        weatherState = weatherState == 1000 ? 1004 : 1005;
                        weatherVal = weatherState;
                        this.hideAnimal();
                    }
                }
            }
        }
        int sence = ps.getIntProperts("f" + currenMapID);
        if (sence == 0) {
            return;
        }
        FightManager.setBack(this.fightsence[sence]);
    }

    private void changeWeather() {
        int val = Tools.getRand(0, 100);
        if (val <= 20) {
            weatherDegreen = Tools.getRand(0, 2);
        }
    }

    private void pointPox(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 40, 50, 90);
        g.setColor(0xFFFFFF);
        g.drawString("X:" + String.valueOf(this.player1.getX()), 0, 50, 0);
        g.drawString("Y:" + String.valueOf(this.player1.getY()), 0, 70, 0);
        g.drawString("WX:" + String.valueOf(winX), 0, 80, 0);
        g.drawString("WY:" + String.valueOf(winY), 0, 90, 0);
    }

    static {
        isShowMapName = true;
        currenMapID = 5;
    }
}

