/*
 * Decompiled with CFR 0.152.
 */
package com.game.map.trigger;

import com.game.fight.FightManager;
import com.game.lib.MySprite;
import com.game.map.MapManager;
import com.game.map.trigger.Trianger;
import com.util.Propertys;
import com.util.Tools;

public class EmenyTrigger
extends MySprite {
    public static final int MAXNUM = 15;
    private static final int RUNMOVE = 0;
    private static final int CHASE = 1;
    private static final int FIGHT = 2;
    private static final int RETURN = 3;
    private int state;
    private MapManager mapManager;
    private Trianger tri;
    private int filmX;
    private int filmY;
    private int speed;
    private boolean node = true;
    private int dir;
    public int id;
    private int[] emenyid;
    private int[] emenylevel = new int[3];
    private final int view;

    public EmenyTrigger(MapManager mapManager, int x, int y, int id, int[] emenyid, int levelmin, int levelmax) {
        super(Tools.loadImage("/res/map/eff/effect2.png"), 15, 20);
        this.view = 40;
        this.mapManager = mapManager;
        this.tri = new Trianger();
        this.setPosition(x, y);
        this.speed = 3;
        this.filmX = x;
        this.filmY = y;
        this.id = id;
        this.emenyid = emenyid;
        for (int i = 0; i < this.emenylevel.length; ++i) {
            int fraction = Tools.getRand(-7, 1);
            int levl = mapManager.player1.property.getGrade() + fraction;
            this.emenylevel[i] = levl <= levelmin ? levelmin : (levl >= levelmax ? levelmax : levl);
        }
    }

    public void logic() {
        this.nextFrame();
        switch (this.state) {
            case 0: {
                this.autoMove(10);
                if (!this.mapManager.player1.isVisbale() || Trianger.returnR(Math.abs(this.mapManager.player1.getX() - this.getX()), Math.abs(this.mapManager.player1.getY() - this.getY())) > 40 || !this.isVisbale()) break;
                this.state = 1;
                break;
            }
            case 1: {
                this.tri.setCoil(this.mapManager.player1.getX(), this.mapManager.player1.getY() + this.mapManager.player1.getHeight() - this.getHeight());
                this.tri.setCurren(this.getX(), this.getY());
                this.tri.setSpeed(this.speed + 5, this.speed + 5);
                this.tri.setIntcre(this.tri.returnTanAngle());
                this.move(this.tri.getCurrenX(), this.tri.getCurrenY());
                if (this.mapManager.player1.collidesWith(this)) {
                    this.mapManager.gameMain.emenyViewState[this.id] = 1;
                    this.state = 2;
                    this.initGuaiWu();
                    this.mapManager.gameMain.insertFight();
                }
                if (!MapManager.isMounts) break;
                this.state = 3;
                break;
            }
            case 2: {
                this.initGuaiWu();
                this.mapManager.gameMain.insertFight();
                break;
            }
            case 3: {
                if (Trianger.returnR(this.filmX - this.getX(), this.filmY - this.getY()) <= 10) {
                    this.setPosition(this.filmX, this.filmY);
                    this.state = 0;
                    return;
                }
                this.tri.setCoil(this.filmX, this.filmY);
                this.tri.setCurren(this.getX(), this.getY());
                this.tri.setSpeed(this.speed + 2, this.speed + 2);
                this.tri.setIntcre(this.tri.returnTanAngle());
                this.move(this.tri.getCurrenX(), this.tri.getCurrenY());
                if (!this.mapManager.player1.collidesWith(this, 0, 1, 1)) break;
                this.state = 2;
            }
        }
    }

    private void autoMove(int distance) {
        switch (this.dir) {
            case 0: {
                if (this.node) {
                    this.move(this.speed, 0);
                } else {
                    this.move(-this.speed, 0);
                }
                if (Math.abs(this.getX() - this.filmX) > distance) {
                    this.node = false;
                }
                if (this.getX() > this.filmX) break;
                this.node = true;
                this.dir = Tools.getRand(4);
                break;
            }
            case 1: {
                if (this.node) {
                    this.move(-this.speed, 0);
                } else {
                    this.move(this.speed, 0);
                }
                if (Math.abs(this.getX() - this.filmX) > distance) {
                    this.node = false;
                }
                if (this.getX() < this.filmX) break;
                this.node = true;
                this.dir = Tools.getRand(4);
                break;
            }
            case 2: {
                if (this.node) {
                    this.move(0, -this.speed);
                } else {
                    this.move(0, this.speed);
                }
                if (Math.abs(this.getY() - this.filmY) > distance) {
                    this.node = false;
                }
                if (this.getY() < this.filmY) break;
                this.node = true;
                this.dir = Tools.getRand(4);
                break;
            }
            case 3: {
                if (this.node) {
                    this.move(0, this.speed);
                } else {
                    this.move(0, -this.speed);
                }
                if (Math.abs(this.getY() - this.filmY) > distance) {
                    this.node = false;
                }
                if (this.getY() > this.filmY) break;
                this.node = true;
                this.dir = Tools.getRand(4);
            }
        }
    }

    public void initGuaiWu() {
        int num = 0;
        if (this.mapManager.gameMain.team.getSize() == 1) {
            num = 1;
        } else if (this.mapManager.gameMain.team.getSize() >= 2) {
            num = Tools.getRand(1, 3);
        }
        for (int i = 0; i < num; ++i) {
            FightManager.addEnemy(this.emenyid[Tools.getRand(0, this.emenyid.length - 1)], this.emenylevel[i]);
        }
    }

    public static final EmenyTrigger[] loadEmeny(MapManager mapManager, int mapid) {
        EmenyTrigger[] tmp = null;
        try {
            Propertys ps = Propertys.loadPropertys("/res/emeny/" + mapid + ".txt");
            int count = ps.getIntProperts("count");
            if (count == 0) {
                return null;
            }
            tmp = new EmenyTrigger[count];
            int[] idrange = ps.getIntPropertsArrary("id");
            int[] levelrange = ps.getIntPropertsArrary("level");
            for (int i = 0; i < tmp.length; ++i) {
                int[] itmp = ps.getIntPropertsArrary("e" + i);
                tmp[i] = new EmenyTrigger(mapManager, itmp[0], itmp[1], itmp[2], idrange, levelrange[0], levelrange[1]);
            }
            return tmp;
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

