/*
 * Decompiled with CFR 0.152.
 */
package com.game.map.ui;

import com.game.map.MapManager;
import com.util.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Frame {
    private Image conterA;
    private Image[] lineA;
    private static Image back;
    private static Image backC;
    private static Image backB;
    private Image select;
    public static final int APTH = -1;
    public static final int DEFAULTFRAMECOLOR = 793449;

    public Frame() {
        back = Tools.loadImage("/res/ui/frame/black_mask.png");
        this.select = Tools.loadImage("/res/ui/item.png");
    }

    public void destroy() {
        back = null;
    }

    public final void drawmFrameForBigFrame(Graphics g, int x, int y, int w, int h) {
        int precolor = g.getColor();
        g.setColor(0);
        g.fillRect(x, y, w, h);
        g.setColor(0xFFFFFF);
        g.drawRect(x + 1, y + 1, w - 3, h - 3);
        g.setColor(precolor);
    }

    public final void drawmFrameForNormal(Graphics g, int x, int y, int w, int h, int color, Image back) {
        this.drawmFrameEx(g, x, y, w, h, color, back, this.conterA, true, true, true, true, this.lineA[0], this.lineA[1], this.lineA[2], this.lineA[3]);
    }

    public final void drawmFrameForNormal(Graphics g, int x, int y, int w, int h, boolean leftTopConner, boolean rightTopConner, boolean leftBoottomConner, boolean rightBottomConner) {
        int precolor = g.getColor();
        g.setColor(0);
        g.fillRect(x, y, w, h);
        g.setColor(16292113);
        g.drawRect(x, y, w, h);
        g.setColor(precolor);
    }

    public final void drawmFrameForNormalLine(Graphics g, int x, int y, int w, int h) {
        int precolor = g.getColor();
        g.setColor(793449);
        g.fillRect(x, y, w, h);
        g.setColor(16292113);
        g.drawRect(x, y, w - 2, h - 2);
        g.setColor(precolor);
    }

    public final void drawmFrameForMapName(Graphics g, String str, int x, int y, int color) {
        int w = Tools.defaultFont.stringWidth(str);
        int frameWidth = w + 20;
        int frameHeight = Tools.DEFAULFONT_HEIGHT + 8;
        int strX = x + 10;
        int strY = y + 4;
        int precolor = g.getColor();
        g.setColor(793449);
        g.fillRect(x, y, frameWidth, frameHeight);
        g.setColor(16292113);
        g.drawRect(x, y, frameWidth, frameHeight);
        g.setColor(0xFFFFFF);
        g.drawString(str, strX, strY, 20);
        g.setColor(precolor);
    }

    private void drawmFrameEx(Graphics g, int x, int y, int w, int h, int backRGB, Image backImg, Image conner, boolean connerLT, boolean connerRT, boolean connerLB, boolean connerRB, Image lineT, Image lineB, Image lineL, Image lineR) {
        int i;
        int xCount = 0;
        int yCount = 0;
        g.setClip(x, y, w, h);
        if (backImg != null) {
            xCount = w / backImg.getWidth() + 1;
            yCount = h / backImg.getHeight() + 1;
            for (i = 0; i < xCount; ++i) {
                for (int j = 0; j < yCount; ++j) {
                    g.drawImage(backImg, x + i * backImg.getWidth(), y + j * backImg.getHeight(), 0);
                }
            }
        } else {
            g.setColor(backRGB);
            g.fillRect(x, y, w, h);
        }
        if (lineT != null) {
            if (lineT.getWidth() >= w) {
                g.drawImage(lineT, x - (lineT.getWidth() - w) / 2, y, 0);
            } else {
                xCount = w / lineT.getWidth() + 1;
                for (i = 0; i < xCount; ++i) {
                    g.drawImage(lineT, x + i * lineT.getWidth(), y, 0);
                }
            }
        }
        if (lineB != null) {
            if (lineB.getWidth() >= w) {
                g.drawImage(lineB, x - (lineB.getWidth() - w) / 2, y + h - lineB.getHeight() + 1, 0);
            } else {
                xCount = w / lineB.getWidth() + 1;
                for (i = 0; i < xCount; ++i) {
                    g.drawImage(lineB, x + i * lineB.getWidth(), y + h - lineB.getHeight(), 0);
                }
            }
        } else if (lineT != null) {
            if (lineT.getWidth() >= w) {
                g.drawImage(lineT, x - (lineT.getWidth() - w) / 2, y + h - lineT.getHeight() + 1, 0);
            } else {
                xCount = w / lineT.getWidth() + 1;
                for (i = 0; i < xCount; ++i) {
                    g.drawImage(lineT, x + i * lineT.getWidth(), y + h - lineT.getHeight(), 0);
                }
            }
        }
        if (lineL != null) {
            yCount = h / lineL.getHeight() + 1;
            for (i = 0; i < yCount; ++i) {
                g.drawImage(lineL, x, y + i * lineL.getHeight(), 0);
            }
        }
        if (lineR != null) {
            yCount = h / lineR.getHeight() + 1;
            for (i = 0; i < yCount; ++i) {
                g.drawImage(lineR, x - lineR.getWidth() + w, y + i * lineR.getHeight(), 0);
            }
        } else if (lineL != null) {
            for (i = 0; i < yCount; ++i) {
                g.drawImage(lineL, x - lineL.getWidth() + w, y + i * lineL.getHeight(), 0);
            }
        }
        if (conner != null) {
            xCount = conner.getWidth() >> 2;
            yCount = conner.getHeight();
            if (connerLT) {
                Tools.ImageClip(g, conner, x, y, xCount, yCount, 1, 1);
            }
            if (connerLB) {
                Tools.ImageClip(g, conner, x, y + h - yCount, xCount, yCount, 3, 1);
            }
            if (connerRT) {
                Tools.ImageClip(g, conner, x + w - xCount, y, xCount, yCount, 0, 1);
            }
            if (connerRB) {
                Tools.ImageClip(g, conner, x + w - xCount, y + h - yCount, xCount, yCount, 2, 1);
            }
        }
        g.setClip(0, 0, 240, 320);
    }

    public static final void drawBackMask(Graphics g) {
        for (int i = 0; i < 20; ++i) {
            for (int j = -1; j < 15; ++j) {
                g.drawImage(back, j * back.getWidth(), i * back.getHeight(), 20);
            }
        }
    }

    public static final void drawBackMaskSpecific(Graphics g) {
        if (back == null) {
            back = Tools.loadImage("/res/ui/frame/black_mask.png");
        }
        for (int i = 0; i < 20; ++i) {
            for (int j = -1; j < 15; ++j) {
                g.drawImage(back, j * back.getWidth() + MapManager.winX, i * back.getHeight() + MapManager.winY, 20);
            }
        }
    }

    public final void drawBackMaskWithFrame(Graphics g, int x, int y, int w, int h) {
        if (back == null) {
            back = Tools.loadImage("/res/ui/frame/black_mask.png");
        }
        this.drawmFrameForNormal(g, x, y, w, h, 0, back);
    }

    public final void drawLine(Graphics g, int x, int y, int w, int h) {
        int precolor = g.getColor();
        g.setColor(16292113);
        g.drawLine(x, y, x + w, y);
        g.setColor(precolor);
    }

    public final void drawmFrame1(Graphics g, int x, int y, int w, int h, int RGB) {
        this.drawmFrameForNormalLine(g, x, y, w, h);
    }

    public final void drawFrameRoundConner(Graphics g, int x, int y, int w, int h) {
        int precolor = g.getColor();
        g.setColor(0);
        g.fillRect(x, y, w, h);
        g.setColor(16292113);
        g.drawRect(x, y, w, h);
        g.setColor(precolor);
    }

    public final void drawSelectFrameEx(Graphics g, String caption, String[] str, int x, int y, int color, int selectIndex) {
        int seW;
        int seH = Tools.DEFAULFONT_HEIGHT + 12;
        int[] tem = new int[str.length];
        for (int i = 0; i < str.length; ++i) {
            tem[i] = Tools.defaultFont.stringWidth(str[i]) + 14;
        }
        for (int i = 0; i < tem.length; ++i) {
            for (int j = tem.length - 1; j > i; --j) {
                if (tem[j] <= tem[i]) continue;
                seW = tem[i];
                tem[i] = tem[j];
                tem[j] = seW;
            }
        }
        seW = tem[0] + 10;
        int kH = str.length * seH + 12;
        int kW = seW + 12;
        int kX = x + 10 - (kW >> 1);
        int kY = y - (kH >> 1);
        int selX = kX + 5;
        int selY = kY + 5;
        this.drawmFrameForNormalLine(g, kX, kY, kW, kH);
        if (caption != null) {
            this.drawmFrameForNormalLine(g, kX, kY - seH, kW, seH);
            g.setColor(color);
            g.drawString(caption, kX + (kW - g.getFont().stringWidth(caption)) / 2, kY - seH + (seH - g.getFont().getHeight()) / 2, 20);
        }
        Tools.ImageClip(g, this.select, selX, selY + 5 + selectIndex * seH + (Tools.DEFAULFONT_HEIGHT - this.select.getHeight()) / 2, this.select.getWidth() >> 1, this.select.getHeight(), 1, 1);
        g.setColor(color);
        for (int i = 0; i < tem.length; ++i) {
            int tiX = selX + 10 + (seW - Tools.defaultFont.stringWidth(str[i]) >> 1);
            g.drawString(str[i], tiX, selY + 5 + i * seH, 20);
        }
    }

    public final void drawFrameString(Graphics g, String str, int x, int y, int w, int h, int wordColor) {
        int w1 = Tools.defaultFont.stringWidth(str);
        int addX = w - w1 >> 1;
        int addY = h - Tools.defaultFont.getHeight() >> 1;
        this.drawmFrameForNormalLine(g, x, y, w, h);
        g.setColor(wordColor);
        g.drawString(str, x + addX, y + addY, 20);
    }

    public final void drawFrameString(Graphics g, String str, int x, int y, int width, int color) {
        int strW = width - 16;
        int col = Tools.getStringCol(str, strW + 5);
        int frameX = x - (width >> 1);
        int frameHeight = col * Tools.DEFAULFONT_HEIGHT + 6;
        int frameY = y - (frameHeight >> 1);
        int strX = col == 1 ? frameX + (width - Tools.defaultFont.stringWidth(str) >> 1) : frameX + 10;
        int strY = frameY + 3;
        this.drawmFrameForNormalLine(g, frameX, frameY, width, frameHeight);
        Tools.drawString(g, str, strX, strY, strW + 5, frameHeight, color, 0);
    }

    public final int drawPageFrameString(Graphics g, String str, int x, int y, int w, int h, int color, int currenPage) {
        int strW = w - 16;
        int strH = h - 10;
        int strX = x + 8;
        int strY = y + 5;
        this.drawmFrameForNormalLine(g, x, y, w, h);
        int col = Tools.getStringLines(str, strW, Tools.SPACE_LFONT_WIDTH);
        int pageSize = Tools.returnNum(strH, Tools.SPACE_LFONT_HEIGHT);
        int page = Tools.returnNum(col, pageSize);
        Tools.drawString(g, str, strX, strY, strW, strH, color, pageSize, currenPage);
        return page;
    }

    public final int[] drawBottomSelect(Graphics g, String[] selecstr, int x, int y, int width, int height, int selectcolor, int index, int curPage, Image point) {
        int num;
        int selectCount = selecstr.length;
        int pageCount = selectCount / 3;
        int pageListCountMax = 3;
        int pageListCountMin = selectCount % 3;
        int selectItemH = Tools.DEFAULFONT_HEIGHT + 3;
        this.drawmFrameForNormalLine(g, x, y, width, height);
        g.setColor(0xFFFFFF);
        y += 8;
        x += 5;
        try {
            for (int i = 0; i < pageListCountMax; ++i) {
                g.drawString(selecstr[i + 3 * curPage], x + (point != null ? point.getWidth() : 0) + 5, y + i * selectItemH, 20);
            }
            num = pageListCountMax;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            for (int i = 0; i < pageListCountMin; ++i) {
            }
            num = pageListCountMin;
        }
        if (point != null) {
            g.drawImage(point, x + 4, y + index * selectItemH, 20);
        }
        return new int[]{pageCount, num};
    }
}

