/*
 * Decompiled with CFR 0.152.
 */
package com.game.map.ui;

import com.MainCanvas;
import com.game.GameMain;
import com.game.data.Goods;
import com.game.data.Medicine;
import com.game.lib.MySprite;
import com.game.map.MapManager;
import com.game.map.ui.UI;
import com.game.map.ui.lib.Menu;
import com.game.map.ui.lib.MenuListener;
import com.game.map.ui.lib.UIList;
import com.game.map.ui.lib.UITitle;
import com.game.role.Property;
import com.game.tishi.TipBean;
import com.game.tishi.TipListener;
import com.game.tishi.TipManager;
import com.menu.HelpAboutMenu;
import com.menu.UIRestore;
import com.util.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class UIManager
extends UI
implements MenuListener,
TipListener {
    private UIList list;
    private UITitle title;
    Image[] img;
    public static final byte UI_MENU = 0;
    public static final byte UI_PACK = 1;
    static final byte UI_SELECT = 2;
    public static final byte UI_ATTRIB = 3;
    public static final byte UI_ADDPOINT = 4;
    public static final byte UI_SYSTEM_RES = 16;
    public static final byte UI_SHOW_TALK = 25;
    public static final byte UI_SHOP_MSG = 26;
    public static final byte UI_SHOP_PANEL = 27;
    public static final byte UI_SHOP_SHENGMI = 28;
    public static final byte UI_SHOP_JIANLI = 29;
    public static final byte UI_SHOP_HECHEN = 30;
    public static final byte UI_SYSTEM_HELP = 40;
    public static final byte UI_BACKMENU = 41;
    private MapManager mapManager;
    private boolean showHelp;
    private String strHelp;
    private int strHelpLen;
    private int moveX;
    private TipManager tip;
    private boolean isShowTip;
    private Goods[] combGoods;
    private HelpAboutMenu help;
    private UIRestore uiRestore;
    private Image button;
    private Image money;
    private Image moneyNumber;
    private MySprite icon;
    private MySprite icon1;
    private int itemIndex;
    private int number;
    private int[] ppp;
    private Image danwei;
    private Image lr;
    private Image num;
    private Image or;
    int repeatTime;
    private String[] rest;
    Image clipImg;
    private int temDot;
    private int temDotAdd;
    private int[][] prData;
    int[] pList;
    Property currPro;
    boolean isSelectPeople;
    boolean isShop;
    private Menu menu;
    private Image sysMenu;
    private Image upDownChoose;
    private int x;
    private int y;
    private int w;
    private int h;
    private int keyMenuIndex;
    private int keySubIndex;
    int moveY = 0;
    boolean useSucc;

    private final void setTextIntro(String help) {
        this.strHelp = help;
        if (this.strHelp == null) {
            this.showHelp = false;
            return;
        }
        this.showHelp = true;
        this.strHelpLen = Tools.defaultFont.stringWidth(this.strHelp);
        this.moveX = 0;
    }

    private void drawRectBar(Graphics g, int x, int y, int w, int h, int inColor, int outColor, int height) {
        g.setColor(inColor);
        g.fillRect(x, y, w, h);
        g.setColor(outColor);
        UIManager.drawRectEx(g, x, y, w - 1, h, height, outColor);
    }

    private void drawTextHelp(Graphics g, int w, int x, int y) {
        g.setColor(65280);
        g.setFont(Tools.defaultFont);
        if (this.moveX >= w + this.strHelpLen) {
            this.moveX = 0;
        }
        g.setClip(x, y, w, Tools.defaultFont.getHeight());
        g.drawString(this.strHelp, x + w - this.moveX, y, 20);
        g.setClip(0, 0, 240, 320);
        this.moveX += 3;
    }

    public UIManager(MapManager mapManager, byte state) {
        super(mapManager.gameMain, state);
        this.mapManager = mapManager;
        this.addRecord(mapManager.state, state);
    }

    public UIManager(MapManager mapManager) {
        this(mapManager, 0);
    }

    public final String useMedicine(Property property, Goods goods) {
        Medicine med = (Medicine)goods;
        switch (med.goodType) {
            case 0: {
                if (property.getCurrenHp() >= property.getMax_hp()) {
                    return "\u8840\u5df2\u6ee1\uff0c\u4e0d\u80fd\u4f7f\u7528\uff01";
                }
                return "\u4f7f\u7528\u540e\u52a0\u8840\uff1a" + (property.getMax_hp() - property.getCurrenHp() > property.getMax_hp() * med.value / 100 ? property.getMax_hp() * med.value / 100 : property.getMax_hp() - property.getCurrenHp());
            }
            case 1: {
                if (property.getCurrenMp() >= property.getMax_mp()) {
                    return "\u7075\u529b\u5df2\u6ee1\uff0c\u4e0d\u80fd\u4f7f\u7528\uff01";
                }
                return "\u4f7f\u7528\u540e\u52a0\u7075\u529b\uff1a" + (property.getMax_mp() - property.getCurrenMp() > property.getMax_mp() * med.value / 100 ? property.getMax_mp() * med.value / 100 : property.getMax_mp() - property.getCurrenMp());
            }
            case 3: {
                switch (med.spice) {
                    case 5: {
                        return "\u4f7f\u7528\u540e\u5c5e\u6027\u70b9\u91cd\u7f6e";
                    }
                    case 4: {
                        return "\u4f7f\u7528\u540e\u6280\u80fd\u70b9\u91cd\u7f6e";
                    }
                    case 3: {
                        return "\u53ea\u80fd\u5728\u6218\u6597\u573a\u666f\u4e2d\u4f7f\u7528\uff01";
                    }
                }
            }
        }
        return "\u4e0d\u80fd\u4f7f\u7528\uff01";
    }

    public boolean keyPressedItem(int key) {
        this.repeatTime = 0;
        if (this.isShowTip) {
            this.tip.keyPressedItem(key);
            return true;
        }
        block0 : switch (this.getState()) {
            case 3: {
                if (this.isSelectPeople) {
                    this.keyPeopleSelect(key);
                    this.setAddPoint();
                }
                return true;
            }
            case 4: {
                this.isSelectPeople = false;
                if (this.list != null) {
                    this.list.setKeyEnable(true);
                }
                this.keyAddPoint(key);
                return true;
            }
            case 0: {
                if (key == 18) {
                    this.backInto();
                    return true;
                }
                return this.menu != null && this.menu.keyPressedItem(key) > 0;
            }
            case 1: {
                return false;
            }
            case 29: {
                if (key == 18) {
                    this.intiUI(27);
                    return true;
                }
                this.list.keyPressedItem(key);
                break;
            }
            case 28: {
                if (!this.isShop && key == 18) {
                    this.intiUI(27);
                    return true;
                }
                if (this.isShop) {
                    this.keyShopNumber(key, false, false);
                    break;
                }
                if (this.list == null || this.list.keyPressedItem(key) < 0) break;
                this.isShop = true;
                this.list.setKeyEnable(false);
                break;
            }
            case 27: {
                return false;
            }
            case 16: {
                this.keyRES(key);
                return false;
            }
            case 40: {
                if (this.help == null || this.help.keypressed(key) <= 0) break;
                this.intiUI(0, this.keyMenuIndex);
                this.help.destroy();
                this.help = null;
                break;
            }
            case 41: {
                switch (key) {
                    case 17: {
                        System.out.println("a");
                        MainCanvas.intiGame = 2;
                        MainCanvas.changeState(1);
                        break block0;
                    }
                    case 18: {
                        System.out.println("b");
                        this.backInto();
                    }
                }
            }
        }
        return false;
    }

    private void keyShopNumber(int key, boolean sell, boolean isRepeat) {
        switch (key) {
            case 15: {
                if (this.number <= 0) break;
                --this.number;
                break;
            }
            case 16: {
                break;
            }
            case 17: 
            case 19: {
                break;
            }
            case 18: {
                if (isRepeat) {
                    return;
                }
                this.isShop = false;
                this.number = 0;
                this.list.setKeyEnable(true);
            }
        }
    }

    private void drawShopNumber(Graphics g, boolean sell) {
        if (this.ppp == null) {
            this.ppp = new int[3];
        }
        if (this.img == null) {
            this.img = new Image[]{Tools.loadImage("/res/ui/danwei.png"), Tools.loadImage("/res/ui/item.png"), Tools.loadImage("/res/ui/num4.png"), Tools.loadImage("/res/ui/or.png")};
        }
        int hh = 110;
        int ww = 120;
        int xx = 240 - ww >> 1;
        int yy = 320 - hh - 40 >> 1;
        int pr = this.list.getData()[this.list.getSelectIndex()].price;
        GameMain.frame.drawmFrameForNormalLine(g, xx, yy, ww, hh);
        Tools.ImageClip(g, this.img[3], xx + ww - 5 - this.img[3].getWidth() / 2, yy + hh - 5 - this.img[3].getHeight(), this.img[3].getWidth() / 2, this.img[3].getHeight(), 1, 1);
        Tools.ImageClip(g, this.img[3], xx + 5, yy + hh - 5 - this.img[3].getHeight(), this.img[3].getWidth() / 2, this.img[3].getHeight(), 0, 1);
        yy += 15;
        for (int i = 0; i < 3; ++i) {
            Tools.ImageClip(g, this.img[0], xx + 35, yy, this.img[0].getWidth() / 3, this.img[0].getHeight(), i, 1);
            Tools.drawNum(g, this.img[2], this.ppp[i], xx + 55 + this.img[0].getWidth() / 3, yy + 2, 11);
            yy += this.img[0].getHeight() + 5;
        }
        this.y += 10;
        if (this.number > 0) {
            Tools.ImageClip(g, this.img[1], xx + ww / 2 - 10 - this.img[1].getWidth() / 2, yy, this.img[1].getWidth() / 2, this.img[1].getHeight(), 0, 1);
        } else {
            xx = Tools.drawNum(g, this.img[2], this.number, xx + ww / 2, yy + 2, 11);
        }
    }

    public static void drawRectEx(Graphics g, int x, int y, int w, int h, int height, int color1) {
        g.setColor(color1);
        for (int i = 0; i < height; ++i) {
            g.drawLine(x, y + i, x + w, y + i);
            g.drawLine(x, y + h - i, x + w, y + h - i);
        }
    }

    public int keyPeopleSelect(int key) {
        switch (key) {
            case 15: {
                --this.keyMenuIndex;
                if (this.keyMenuIndex < 0) {
                    this.keyMenuIndex = this.pList.length - 1;
                }
                this.currPro = this.gameMian.team.getProperty(this.pList[this.keyMenuIndex]);
                return 1;
            }
            case 16: {
                ++this.keyMenuIndex;
                if (this.keyMenuIndex >= this.pList.length) {
                    this.keyMenuIndex = 0;
                }
                this.currPro = this.gameMian.team.getProperty(this.pList[this.keyMenuIndex]);
                return 1;
            }
            case 17: 
            case 19: {
                return 0;
            }
            case 18: {
                this.back();
            }
        }
        return 0;
    }

    private final void attribLogic(int index, int add) {
        int[] nArray = this.prData[index];
        nArray[0] = nArray[0] + add;
        this.temDot -= add;
        this.temDotAdd += add;
        switch (index + 1) {
            case 1: {
                this.prData[index][1] = Property.gethpMax(this.prData[index][0]);
                this.prData[4][1] = Property.getDodge(this.prData[4][0], this.prData[3][0], this.prData[0][0]);
                this.prData[4][2] = Property.getCrit(this.prData[4][0], this.prData[2][0], this.prData[3][0], this.prData[1][0]);
                break;
            }
            case 2: {
                this.prData[index][1] = Property.getmpMax(this.prData[index][0]);
                this.prData[4][1] = Property.getDodge(this.prData[4][0], this.prData[3][0], this.prData[0][0]);
                this.prData[4][2] = Property.getCrit(this.prData[4][0], this.prData[2][0], this.prData[3][0], this.prData[1][0]);
                break;
            }
            case 3: {
                this.prData[index][1] = Property.getAct(this.prData[index][0], this.prData[3][0], this.prData[4][0]);
                this.prData[4][1] = Property.getDodge(this.prData[4][0], this.prData[3][0], this.prData[0][0]);
                this.prData[4][2] = Property.getCrit(this.prData[4][0], this.prData[2][0], this.prData[3][0], this.prData[1][0]);
                break;
            }
            case 4: {
                this.prData[2][1] = Property.getAct(this.prData[2][0], this.prData[3][0], this.prData[4][0]);
                this.prData[index][1] = Property.getDefo(this.prData[index][0]);
                this.prData[4][1] = Property.getDodge(this.prData[4][0], this.prData[3][0], this.prData[0][0]);
                this.prData[4][2] = Property.getCrit(this.prData[4][0], this.prData[2][0], this.prData[3][0], this.prData[1][0]);
                break;
            }
            case 5: {
                this.prData[2][1] = Property.getAct(this.prData[2][0], this.prData[3][0], this.prData[4][0]);
                this.prData[index][1] = Property.getDodge(this.prData[4][0], this.prData[3][0], this.prData[0][0]);
                this.prData[index][2] = Property.getCrit(this.prData[4][0], this.prData[2][0], this.prData[3][0], this.prData[1][0]);
            }
        }
    }

    private final void addPointOK() {
        if (this.temDotAdd > 0) {
            this.currPro.setProperPoint(this.temDot);
            for (int i = 0; i < this.prData.length; ++i) {
                this.currPro.setProper(i + 1, 0, this.prData[i][0]);
            }
            this.temDotAdd = 0;
            this.setAddPoint();
            this.setTipString(new String[]{"\u52a0\u70b9\u6210\u529f!"}, (byte)1);
        }
    }

    private void addPoint() {
        if (!this.isSelectPeople && this.temDot != 0 && this.temDotAdd < this.currPro.getProperPoint()) {
            this.attribLogic(this.keySubIndex, 1);
        }
    }

    private void removePoint() {
        if (!(this.isSelectPeople || this.prData[this.keySubIndex][0] <= this.currPro.getProper(this.keySubIndex + 1, 0) || this.temDot == 0 && this.temDotAdd <= 0)) {
            this.attribLogic(this.keySubIndex, -1);
        }
    }

    public int keyAddPoint(int key) {
        switch (key) {
            case 15: {
                this.removePoint();
                return 2;
            }
            case 16: {
                this.addPoint();
                return 2;
            }
            case 13: {
                --this.keySubIndex;
                if (this.keySubIndex < 0) {
                    this.keySubIndex = 4;
                }
                return 1;
            }
            case 14: {
                ++this.keySubIndex;
                if (this.keySubIndex > 4) {
                    this.keySubIndex = 0;
                }
                return 1;
            }
            case 17: 
            case 19: {
                this.addPointOK();
                return 3;
            }
            case 18: {
                this.isSelectPeople = true;
                this.keySubIndex = 0;
                this.temDot = 0;
                this.temDotAdd = 0;
                this.setAddPoint();
                this.back();
            }
        }
        return 0;
    }

    private void keyUseMedcine(int key) {
        switch (key) {
            case 17: 
            case 19: {
                String str = this.pack.useMedicine(this.currPro, this.list.getData()[this.list.getSelectIndex()]);
                if (str == null) {
                    this.setTipString(new String[]{"\u4f7f\u7528\u5931\u8d25\uff01"}, (byte)1);
                } else {
                    if (str.startsWith("\u4f7f\u7528\u6210\u529f")) {
                        this.useSucc = true;
                    }
                    this.setTipString(new String[]{str}, (byte)1);
                }
                return;
            }
            case 18: {
                this.isSelectPeople = true;
                if (this.list != null) {
                    this.list.setKeyEnable(false);
                }
                this.keySubIndex = 0;
            }
        }
    }

    public void keyRES(int key) {
        if (this.uiRestore.keypressed(key) > 0) {
            this.uiRestore.destroy();
            this.backInto();
        }
    }

    private void delCombGoods(int index, Goods newGoods) {
        if (this.combGoods == null) {
            this.combGoods = new Goods[3];
        }
        for (int i = 0; i < this.combGoods.length; ++i) {
            this.combGoods[i] = null;
        }
        this.keyMenuIndex = 0;
        if (newGoods != null) {
            this.keyMenuIndex = index;
            this.combGoods[index] = newGoods;
            this.pack.removeGoods(newGoods, 1);
        }
    }

    private void uiWrouthBack() {
        this.showHelp = false;
        this.strHelp = null;
        for (int i = 0; i < this.combGoods.length; ++i) {
            if (this.combGoods[i] == null) continue;
            this.pack.addGoods(this.combGoods[i], 1);
        }
        this.delCombGoods(0, null);
        this.lastState = -1;
        this.back();
    }

    public void keyUiWrouth(int key) {
        switch (key) {
            case 14: {
                this.keyMenuIndex = (this.keyMenuIndex + 1) % 3;
                break;
            }
            case 13: {
                if (this.keyMenuIndex == 0) {
                    this.keyMenuIndex = 3;
                }
                this.keyMenuIndex = (this.keyMenuIndex - 1) % 3;
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 19: {
                this.showHelp = false;
                this.strHelp = null;
                break;
            }
            case 18: {
                this.uiWrouthBack();
                break;
            }
        }
    }

    public void keySystem(int key) {
        block0 : switch (key) {
            case 14: {
                this.keyMenuIndex = (this.keyMenuIndex + 1) % 5;
                break;
            }
            case 13: {
                if (this.keyMenuIndex == 0) {
                    this.keyMenuIndex = 5;
                }
                this.keyMenuIndex = (this.keyMenuIndex - 1) % 5;
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 18: {
                this.back();
                break;
            }
            case 19: {
                switch (this.keyMenuIndex) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        break block0;
                    }
                    case 3: {
                        break block0;
                    }
                    case 4: {
                        MainCanvas.intiGame = 2;
                        MainCanvas.changeState(1);
                    }
                }
            }
        }
    }

    public boolean keyRepeatedItem(int key) {
        ++this.repeatTime;
        if (this.repeatTime < 10) {
            return false;
        }
        switch (this.getState()) {
            case 3: {
                switch (key) {
                    case 15: {
                        this.removePoint();
                        return true;
                    }
                    case 16: {
                        this.addPoint();
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean pointerPressedItem(int x, int y) {
        return false;
    }

    private final void drawRestoe(Graphics g) {
        if (this.uiRestore != null) {
            this.uiRestore.paint(g);
        }
    }

    public static int returnImageIndex(int roleid) {
        int Imageid = 0;
        if (roleid == 20) {
            Imageid = 1;
        } else if (roleid == 23) {
            Imageid = 2;
        }
        return Imageid;
    }

    private void setAddPoint() {
        this.clipImg = Tools.loadImage("/res/ui/addPoint.png");
        this.temDot = this.currPro.getProperPoint();
        this.temDotAdd = 0;
        Property tempr = this.currPro;
        this.prData = new int[][]{{tempr.getProper(1, 0), tempr.getProper(1, 3)}, {tempr.getProper(2, 0), tempr.getProper(2, 3)}, {tempr.getProper(3, 0), tempr.getProper(3, 2)}, {tempr.getProper(4, 0), tempr.getProper(4, 2)}, {tempr.getProper(5, 0), tempr.getProper(5, 4), tempr.getProper(5, 2)}};
        MainCanvas.setKeyRepeatedRender(true);
    }

    private void setPeople() {
        this.pList = this.gameMian.team.getTeamList();
        GameMain.systemPrintln(this.pList + "plistplist");
        if (this.keyMenuIndex >= this.pList.length) {
            this.keyMenuIndex = 0;
        }
        this.isSelectPeople = true;
        this.currPro = this.gameMian.team.getProperty(this.pList[this.keyMenuIndex]);
        this.img = new Image[15];
        this.img[0] = null;
        this.img[1] = Tools.loadImage("/res/ui/name.png");
        this.img[2] = null;
        this.img[3] = Tools.loadImage("/res/ui/num4.png");
        this.img[4] = Tools.loadImage("/res/ui/item.png");
        this.img[5] = Tools.loadImage("/res/ui/attrib.png");
        this.img[6] = Tools.loadImage("/res/ui/exp.png");
        this.img[8] = Tools.loadImage("/res/ui/grade.png");
        this.img[9] = null;
        this.img[10] = null;
        this.img[11] = null;
        this.img[12] = null;
        this.img[13] = null;
        this.img[14] = null;
        switch (this.getState()) {
            case 3: 
            case 4: {
                this.img[7] = Tools.loadImage("/res/ui/ptd.png");
            }
        }
    }

    private void drawAddPoint(Graphics g, int y) {
        int xx = 10;
        g.drawImage(this.img[7], 20, y += 10, 0);
        Tools.drawNum(g, this.img[3], this.temDot, 20 + this.img[7].getWidth(), y + 2, 11);
        y += this.img[7].getHeight() + 1;
        int hh = this.clipImg.getHeight() / 5;
        if (this.keySubIndex == 0 && !this.isSelectPeople) {
            Tools.ImageClip(g, this.img[4], xx - (this.img[4].getWidth() >> 1), y + (hh - this.img[4].getHeight()) / 2, this.img[4].getWidth() >> 1, this.img[4].getHeight(), 1, 1);
        }
        Tools.ImageClip(g, this.clipImg, xx, y, this.clipImg.getWidth(), hh, 0, 0);
        Tools.drawNum(g, this.img[3], this.prData[0][0], xx += this.clipImg.getWidth() + 5, y + 2, 11);
        xx = 125;
        if (this.keySubIndex == 1 && !this.isSelectPeople) {
            Tools.ImageClip(g, this.img[4], xx - (this.img[4].getWidth() >> 1), y + (hh - this.img[4].getHeight()) / 2, this.img[4].getWidth() >> 1, this.img[4].getHeight(), 1, 1);
        }
        Tools.ImageClip(g, this.clipImg, xx, y, this.clipImg.getWidth(), hh, 1, 0);
        Tools.drawNum(g, this.img[3], this.prData[1][0], xx += this.clipImg.getWidth() + 5, y + 2, 11);
        xx = 10;
        y += this.clipImg.getHeight() / 5 + 1;
        if (this.keySubIndex == 2 && !this.isSelectPeople) {
            Tools.ImageClip(g, this.img[4], xx - (this.img[4].getWidth() >> 1), y + (hh - this.img[4].getHeight()) / 2, this.img[4].getWidth() >> 1, this.img[4].getHeight(), 1, 1);
        }
        Tools.ImageClip(g, this.clipImg, xx, y, this.clipImg.getWidth(), hh, 2, 0);
        Tools.drawNum(g, this.img[3], this.prData[2][0], xx += this.clipImg.getWidth() + 5, y + 2, 11);
        xx = 125;
        if (this.keySubIndex == 3 && !this.isSelectPeople) {
            Tools.ImageClip(g, this.img[4], xx - (this.img[4].getWidth() >> 1), y + (hh - this.img[4].getHeight()) / 2, this.img[4].getWidth() >> 1, this.img[4].getHeight(), 1, 1);
        }
        Tools.ImageClip(g, this.clipImg, xx, y, this.clipImg.getWidth(), hh, 3, 0);
        Tools.drawNum(g, this.img[3], this.prData[3][0], xx += this.clipImg.getWidth() + 5, y + 2, 11);
        xx = 10;
        y += this.clipImg.getHeight() / 5 + 1;
        if (this.keySubIndex == 4 && !this.isSelectPeople) {
            Tools.ImageClip(g, this.img[4], xx - (this.img[4].getWidth() >> 1), y + (hh - this.img[4].getHeight()) / 2, this.img[4].getWidth() >> 1, this.img[4].getHeight(), 1, 1);
        }
        Tools.ImageClip(g, this.clipImg, xx, y, this.clipImg.getWidth(), hh, 4, 0);
        Tools.drawNum(g, this.img[3], this.prData[4][0], xx += this.clipImg.getWidth() + 5, y + 2, 11);
        GameMain.frame.drawLine(g, 10, y + 2 + hh, 220, 1);
        xx = 10;
        y += 5 + hh;
        hh = this.img[5].getHeight() / 6;
        Tools.ImageClip(g, this.img[5], xx, y, this.img[5].getWidth(), hh, 0, 0);
        Tools.drawNum(g, this.img[3], this.prData[0][1], xx += this.img[5].getWidth(), y + 3, 11);
        xx = 125;
        Tools.ImageClip(g, this.img[5], xx, y, this.img[5].getWidth(), hh, 1, 0);
        Tools.drawNum(g, this.img[3], this.prData[1][1], xx += this.img[5].getWidth(), y + 3, 11);
        xx = 10;
        Tools.ImageClip(g, this.img[5], xx, y += 1 + hh, this.img[5].getWidth(), hh, 2, 0);
        Tools.drawNum(g, this.img[3], this.prData[2][1], xx += this.img[5].getWidth(), y + 3, 11);
        xx = 125;
        Tools.ImageClip(g, this.img[5], xx, y, this.img[5].getWidth(), hh, 3, 0);
        Tools.drawNum(g, this.img[3], this.prData[3][1], xx += this.img[5].getWidth(), y + 3, 11);
        xx = 10;
        Tools.ImageClip(g, this.img[5], xx, y += 1 + hh, this.img[5].getWidth(), hh, 4, 0);
        Tools.drawNum(g, this.img[3], this.prData[4][1], xx += this.img[5].getWidth(), y + 3, 11);
        xx = 125;
        Tools.ImageClip(g, this.img[5], xx, y, this.img[5].getWidth(), hh, 5, 0);
        Tools.drawNum(g, this.img[3], this.prData[4][2], xx += this.img[5].getWidth(), y + 3, 11);
    }

    public static int drawMoveSelect(Graphics g, int x1, int x2, int y, Image item, int move) {
        if (++move % 12 < 6) {
            Tools.ImageClip(g, item, x1, y, item.getWidth() >> 1, item.getHeight(), 0, 1);
            Tools.ImageClip(g, item, x2, y, item.getWidth() >> 1, item.getHeight(), 1, 1);
        } else {
            Tools.ImageClip(g, item, x1 - 5, y, item.getWidth() >> 1, item.getHeight(), 0, 1);
            Tools.ImageClip(g, item, x2 + 5, y, item.getWidth() >> 1, item.getHeight(), 1, 1);
        }
        return move;
    }

    private int drawPeopleSelect(Graphics g, int y, boolean exp) {
        int xx = 10;
        int yy = y;
        if (this.isSelectPeople) {
            this.moveX = UIManager.drawMoveSelect(g, xx, xx + this.img[1].getWidth() + this.img[4].getWidth() / 2, yy, this.img[4], this.moveX);
        }
        Tools.ImageClip(g, this.img[1], (xx += 10 + this.img[4].getWidth() / 2) - 10, yy, this.img[1].getWidth(), this.img[1].getHeight(), UIManager.returnImageIndex(this.pList[this.keyMenuIndex]), 1);
        if (exp) {
            g.drawImage(this.img[8], xx - 10, yy + this.img[1].getHeight() + 10, 0);
            Tools.drawNum(g, this.img[3], this.currPro.getGrade(), xx + this.img[8].getWidth() - 10, yy + this.img[1].getHeight() + 12, 11);
        }
        Tools.ImageClip(g, this.img[5], (xx -= 80) + this.img[4].getWidth() / 2 + this.img[1].getWidth() + 10, yy += 40, this.img[5].getWidth(), this.img[5].getHeight() / 6, 0, 0);
        Tools.drawNum(g, this.img[3], this.currPro.getCurrenHp(), this.currPro.getMax_hp(), xx + this.img[4].getWidth() / 2 + this.img[1].getWidth() + this.img[5].getWidth() + 10, yy + 3, 11, 10);
        Tools.ImageClip(g, this.img[5], xx + this.img[4].getWidth() / 2 + this.img[1].getWidth() + 10, yy + this.img[5].getHeight() / 6 + 5, this.img[5].getWidth(), this.img[5].getHeight() / 6, 1, 0);
        Tools.drawNum(g, this.img[3], this.currPro.getCurrenMp(), this.currPro.getMax_mp(), xx + this.img[4].getWidth() / 2 + this.img[1].getWidth() + this.img[5].getWidth() + 10, yy + 6 + this.img[3].getHeight() + 5, 11, 10);
        g.drawImage(this.img[6], xx + this.img[4].getWidth() / 2 + this.img[1].getWidth() + 10, yy + this.img[5].getHeight() / 6 * 2 + 11, 0);
        Tools.drawNum(g, this.img[3], this.currPro.getCurrenExp(), this.currPro.getMaxExp(), xx + this.img[4].getWidth() / 2 + this.img[1].getWidth() + 10 + this.img[6].getWidth() + 5, yy + this.img[5].getHeight() / 6 * 2 + 14, 11, 10);
        return y + 25 + 5;
    }

    public void paint(Graphics g) {
        switch (this.getState()) {
            case 0: {
                this.menu.paint(g);
                if (this.isShowTip) {
                    this.tip.paint(g);
                }
                return;
            }
            case 3: {
                GameMain.frame.drawmFrameForBigFrame(g, 0, 0, 240, 320);
                this.drawPeopleSelect(g, 10, true);
                this.drawButton(g, true, true);
                break;
            }
            case 4: {
                GameMain.frame.drawmFrameForBigFrame(g, 0, 0, 240, 320);
                this.drawAddPoint(g, 0);
                this.drawButton(g, true, true);
                break;
            }
            case 16: {
                GameMain.frame.drawmFrameForBigFrame(g, 0, 0, 240, 320);
                this.drawRestoe(g);
                break;
            }
            case 40: {
                this.help.paint(g);
                break;
            }
            case 41: {
                this.drawExit(g);
                break;
            }
            case 1: {
                GameMain.frame.drawmFrameForBigFrame(g, 0, 0, 240, 320);
                this.title.paint(g);
                this.list.paint(g);
                this.drawButton(g, true, true);
                break;
            }
            case 26: {
                GameMain.frame.drawmFrameForBigFrame(g, 0, 0, 240, 320);
                this.title.paint(g);
                this.list.paint(g);
                this.drawButton(g, true, true);
                break;
            }
            case 29: {
                GameMain.frame.drawmFrameForBigFrame(g, 0, 0, 240, 320);
                this.title.paint(g);
                this.list.paint(g);
                this.drawButton(g, true, true);
                break;
            }
            case 28: {
                GameMain.frame.drawmFrameForBigFrame(g, 0, 0, 240, 320);
                this.title.paint(g);
                this.list.paint(g);
                if (this.isShop) {
                    this.drawShopNumber(g, false);
                }
                this.drawButton(g, true, true);
            }
        }
        if (this.isShowTip) {
            this.tip.paint(g);
        }
        if (this.showHelp) {
            int yy = 290 - Tools.DEFAULFONT_HEIGHT - 10;
            this.drawRectBar(g, 3, yy, 234, Tools.DEFAULFONT_HEIGHT + 10, 793449, 5651509, 5);
            this.drawTextHelp(g, 230, 5, yy + 5);
        }
    }

    public void drawUiWrouth(Graphics g) {
        g.drawImage(this.img[0], this.title.getX() + 10, this.title.getY() + this.title.getHeight(), 0);
        int hh = 27;
        int space = 1;
        int frameY = this.title.getY() + this.title.getHeight() + 3 + this.img[0].getHeight();
        for (int i = 0; i < 3; ++i) {
            GameMain.frame.drawFrameRoundConner(g, this.title.getX() + 10, frameY + i * (space + hh), this.title.getWidth() - 20, hh);
            if (i == this.keyMenuIndex) {
                Tools.ImageClip(g, this.upDownChoose, this.title.getX() + 20, frameY + i * (hh + space) + (hh - this.upDownChoose.getHeight()) / 2, this.upDownChoose.getWidth() / 2, this.upDownChoose.getHeight(), 1, 1);
            }
            if (this.combGoods[i] == null) continue;
            g.setColor(this.combGoods[i].fontColor);
            g.drawString(this.combGoods[i].type == 1 ? this.combGoods[i].allName() : this.combGoods[i].name, this.title.getX() + 30, frameY + i * (space + hh) + (hh - g.getFont().getHeight()) / 2, 0);
        }
    }

    public void drawUiSysther(Graphics g) {
        int hh = 27;
        int space = 1;
        int frameY = this.title.getY() + this.title.getHeight() + this.img[0].getHeight() / 3 - 10;
        g.drawString("\u653e\u7f6e\u88c5\u5907\u3001\u6750\u6599\u3001\u6750\u6599", this.title.getX() + 20, frameY, 0);
        for (int i = 0; i < 3; ++i) {
            GameMain.frame.drawFrameRoundConner(g, this.title.getX() + 10, frameY + i * (space + hh) + this.img[0].getHeight() / 3 + 5, this.title.getWidth() - 20, hh);
            if (i == this.keyMenuIndex) {
                Tools.ImageClip(g, this.upDownChoose, this.title.getX() + 20, frameY + i * (space + hh) + this.img[0].getHeight() / 3 + 5 + (hh - this.upDownChoose.getHeight()) / 2, this.upDownChoose.getWidth() / 2, this.upDownChoose.getHeight(), 1, 1);
            }
            if (this.combGoods[i] == null) continue;
            g.setColor(this.combGoods[i].fontColor);
            g.drawString(this.combGoods[i].type == 1 ? this.combGoods[i].allName() : this.combGoods[i].name, this.title.getX() + 30 + 30, frameY + i * (space + hh) + this.img[0].getHeight() / 3 + 5 + (hh - g.getFont().getHeight()) / 2, 0);
        }
    }

    public void destroy() {
        if (this.title != null) {
            this.title.destory();
            this.title = null;
        }
        if (this.list != null) {
            this.list.destory();
            this.list = null;
        }
        if (this.menu != null) {
            this.menu = null;
        }
        this.showHelp = false;
        this.strHelp = null;
    }

    private void reIntiUI() {
        this.intiUI(this.getState(), this.title != null ? this.title.getSelectIndex() : 0);
    }

    void intiUI(int state, int selectIndex) {
        this.setState(state);
        int width = 0;
        this.showHelp = false;
        this.strHelp = null;
        if (this.title != null) {
            this.title.destory();
            this.title = null;
        }
        if (this.list != null) {
            this.list.destory();
            this.list = null;
        }
        if (this.menu != null) {
            this.menu = null;
            MainCanvas.setKeyRepeatedRender(true);
        }
        switch (state) {
            case 0: {
                this.menu = new Menu(this, new String[]{"\u5c5e\u6027", "\u88c5\u5907", "\u7269\u54c1", "\u6280\u80fd", "\u4efb\u52a1", "\u7cfb\u7edf"}, 0);
                this.menu.setSelectIndex(selectIndex);
                return;
            }
            case 1: {
                this.list = new UIList();
                this.title = new UITitle();
                width = 230;
                this.title.setBound(5, 5, width, 30);
                this.title.setTitle(Tools.loadImage("/res/ui/packTitle.png"), 0, 4, 0);
                this.title.setSelectIndex(selectIndex);
                this.title.setShowType(3);
                this.list.setBound(this.title.getX(), this.title.getY() + this.title.getHeight() + 8, this.title.getWidth(), 144);
                this.list.bingGoods(this.pack.getPackGoods(selectIndex), selectIndex, 1, 0);
                break;
            }
            case 3: {
                this.title = new UITitle();
                width = 230;
                this.title.setBound(5, 5, width, 30);
                this.title.setTitle(Tools.loadImage("/res/ui/titleText.png"), 0, 10, 1);
                this.title.setSelectIndex(4);
                this.setPeople();
                this.setAddPoint();
                break;
            }
            case 4: {
                this.title = new UITitle();
                width = 230;
                this.title.setBound(5, 5, width, 30);
                this.title.setTitle(Tools.loadImage("/res/ui/titleText.png"), 0, 10, 1);
                this.title.setSelectIndex(4);
                this.setPeople();
                this.setAddPoint();
                break;
            }
            case 28: {
                this.number = 0;
                this.isShop = false;
                this.list = new UIList();
                this.title = new UITitle();
                width = 230;
                this.title.setBound(5, 5, width, 30);
                this.title.setTitle(Tools.loadImage("/res/ui/shop.png"), 0, 3, 1);
                this.title.setSelectIndex(1);
                this.list.setBound(this.title.getX(), this.title.getY() + this.title.getHeight() + 8, this.title.getWidth(), 144);
                this.list.bingGoods(this.pack.getShopGoods(3), 3, 28, 0);
                break;
            }
            case 16: {
                this.uiRestore = new UIRestore(this.gameMian, this);
                this.uiRestore.init(selectIndex);
                break;
            }
            case 29: {
                break;
            }
            case 40: {
                this.help = new HelpAboutMenu(this.mapManager.gameMain);
                this.help.init(1);
                break;
            }
        }
    }

    public void intiUI(int state) {
        this.keyMenuIndex = 0;
        this.intiUI(state, 0);
    }

    private void initEQMent() {
        this.pList = this.gameMian.team.getTeamList();
        if (this.keyMenuIndex >= this.pList.length) {
            this.keyMenuIndex = 0;
        }
        this.isSelectPeople = true;
        this.currPro = this.gameMian.team.getProperty(this.pList[this.keyMenuIndex]);
        this.list.initEquipment(this.currPro, UIManager.returnImageIndex(this.pList[this.keyMenuIndex]));
    }

    private final void drawMoney(Graphics g, int y) {
        if (this.money == null) {
            this.money = Tools.loadImage("/res/ui/yuanbao.png");
        }
        if (this.moneyNumber == null) {
            this.moneyNumber = Tools.loadImage("/res/ui/num4.png");
        }
        int len = Integer.toString(this.pack.getMoney()).length();
        int xx = 240 - len * this.moneyNumber.getWidth() / 11 - this.money.getWidth() >> 1;
        g.drawImage(this.money, xx, y, 0);
        Tools.drawNum(g, this.moneyNumber, this.pack.getMoney(), xx + this.money.getWidth() + 5, y + (this.money.getHeight() - this.moneyNumber.getHeight()) / 2, 11);
    }

    private final void drawButton(Graphics g, boolean left, boolean right) {
        if (this.button == null) {
            this.button = Tools.loadImage("/res/ui/button.png");
        }
        if (left) {
            Tools.ImageClip(g, this.button, 5, 315, this.button.getWidth() >> 1, this.button.getHeight(), 0, 0, 36);
        }
        if (right) {
            Tools.ImageClip(g, this.button, 235, 315, this.button.getWidth() >> 1, this.button.getHeight(), 0, 1, 40);
        }
    }

    public void itemMenu(int index) {
        this.addRecord(0, index);
        switch (index) {
            case 0: {
                this.backInto();
                break;
            }
            case 1: {
                this.nextState = 3;
                this.nextStateSelectIndex = 0;
                this.intiUI(3);
                break;
            }
            case 2: {
                this.intiUI(4);
                break;
            }
            case 3: {
                this.intiUI(16);
                break;
            }
            case 4: {
                this.currPro = this.gameMian.team.getProperty(10);
                this.currPro.setHp(this.currPro.getMax_hp());
                this.setTipString(new String[]{"\u4f60\u7684\u72b6\u6001\u5df2\u6062\u590d"}, (byte)1);
                break;
            }
            case 5: {
                this.intiUI(40);
                break;
            }
            case 6: {
                this.setState(41);
            }
        }
    }

    void backInto() {
        this.mapManager.backMap();
    }

    public final void setTip(TipBean tipBean) {
        this.destoryTip();
        this.tip = new TipManager();
        this.tip.setTipBean(tipBean);
        this.tip.setTipListener(this);
        this.isShowTip = true;
        MainCanvas.setKeyRepeatedRender(false);
    }

    public final void destoryTip() {
        if (this.tip != null) {
            this.tip.destroy();
            this.tip = null;
        }
        this.isShowTip = false;
        MainCanvas.setKeyRepeatedRender(true);
    }

    public final void setTipString(String[] str, byte type) {
        TipBean tishiBean = new TipBean();
        tishiBean.setTipMessage(str);
        tishiBean.tipType = type;
        this.setTip(tishiBean);
    }

    private void dealCommontipReturn() {
        this.destoryTip();
    }

    public void returnTipItem() {
        if (this.tip.getType() == 1) {
            this.dealCommontipReturn();
            return;
        }
        block0 : switch (this.getState()) {
            case 1: {
                switch (this.title.getSelectIndex()) {
                    default: {
                        switch (this.tip.getItemIndex()) {
                            case 0: {
                                if (this.pack.dropGoods(this.list.getData()[this.list.getSelectIndex()], 1)) {
                                    this.setTipString(new String[]{"\u4e22\u5f03\u6210\u529f\uff01"}, (byte)1);
                                    this.intiUI(1, this.title.getSelectIndex());
                                } else {
                                    this.setTipString(new String[]{"\u4e0d\u80fd\u4e22\u5f03\uff01"}, (byte)1);
                                }
                                return;
                            }
                        }
                        break block0;
                    }
                    case 0: {
                        switch (this.tip.getItemIndex()) {
                            case 0: {
                                break block0;
                            }
                            case 1: {
                                if (this.pack.dropGoods(this.list.getData()[this.list.getSelectIndex()], 1)) {
                                    this.setTipString(new String[]{"\u4e22\u5f03\u6210\u529f\uff01"}, (byte)1);
                                    this.intiUI(1, this.title.getSelectIndex());
                                } else {
                                    this.setTipString(new String[]{"\u4e0d\u80fd\u4e22\u5f03\uff01"}, (byte)1);
                                }
                                return;
                            }
                        }
                        break block0;
                    }
                    case 1: {
                        if (this.tip.getNumber() == 3) {
                            switch (this.tip.getItemIndex()) {
                                case 1: {
                                    return;
                                }
                                case 2: {
                                    if (this.pack.dropGoods(this.list.getData()[this.list.getSelectIndex()], 1)) {
                                        this.setTipString(new String[]{"\u4e22\u5f03\u6210\u529f\uff01"}, (byte)1);
                                        this.intiUI(1, this.title.getSelectIndex());
                                    } else {
                                        this.setTipString(new String[]{"\u4e22\u5f03\u5931\u8d25\uff01"}, (byte)1);
                                    }
                                    return;
                                }
                            }
                            break block0;
                        }
                        if (this.tip.getNumber() != 2) break block0;
                        switch (this.tip.getItemIndex()) {
                            case 0: {
                                this.destoryTip();
                                return;
                            }
                            case 1: {
                                if (this.pack.dropGoods(this.list.getData()[this.list.getSelectIndex()], 1)) {
                                    this.setTipString(new String[]{"\u4e22\u5f03\u6210\u529f\uff01"}, (byte)1);
                                    this.intiUI(1, this.title.getSelectIndex());
                                } else {
                                    this.setTipString(new String[]{"\u4e22\u5f03\u5931\u8d25\uff01"}, (byte)1);
                                }
                                return;
                            }
                        }
                        break block0;
                    }
                    case 3: 
                }
                if (this.tip.getNumber() == 3) {
                    switch (this.tip.getItemIndex()) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            if (this.pack.dropGoods(this.list.getData()[this.list.getSelectIndex()], 1)) {
                                this.setTipString(new String[]{"\u4e22\u5f03\u6210\u529f\uff01"}, (byte)1);
                                this.intiUI(1, this.title.getSelectIndex());
                            } else {
                                this.setTipString(new String[]{"\u4e0d\u80fd\u4e22\u5f03\uff01"}, (byte)1);
                            }
                            return;
                        }
                    }
                    break;
                }
                if (this.tip.getNumber() != 2) break;
                switch (this.tip.getItemIndex()) {
                    case 0: {
                        if (this.pack.dropGoods(this.list.getData()[this.list.getSelectIndex()], 1)) {
                            this.setTipString(new String[]{"\u4e22\u5f03\u6210\u529f\uff01"}, (byte)1);
                            this.intiUI(1, this.title.getSelectIndex());
                        } else {
                            this.setTipString(new String[]{"\u4e0d\u80fd\u4e22\u5f03\uff01"}, (byte)1);
                        }
                        return;
                    }
                }
            }
        }
        this.destoryTip();
    }

    public void initTalk(int id) {
    }

    private void drawExit(Graphics g) {
        int preColor = g.getColor();
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        g.setColor(0xFFFFFF);
        int w = Tools.defaultFont.stringWidth("\u662f\u5426\u9000\u51fa");
        g.drawString("\u786e\u8ba4\u9000\u51fa", (240 - w) / 2 + 3, 160, 0);
        g.drawString("\u662f", 6, 320 - Tools.DEFAULFONT_HEIGHT, 0);
        g.drawString("\u5426", 240 - Tools.defaultFont.stringWidth("\u5426") - 3 - 3, 320 - Tools.DEFAULFONT_HEIGHT, 0);
        g.setColor(preColor);
    }
}

