/*
 * Decompiled with CFR 0.152.
 */
package com.game.map.ui.lib;

import com.game.lib.MyClip;
import com.game.map.ui.lib.Component;
import com.util.MathFP;
import com.util.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScrollBar
extends Component {
    private int space;
    private int moveY;
    private int moveSpeed;
    private int barCount;
    private MyClip scrollPoint = new MyClip(Tools.loadImage("/res/ui/scrollPoint.png"), 0, 2, 0);
    private Image optionBar = Tools.loadImage("/res/ui/optionBar.png");
    private Image bar = Tools.loadImage("/res/ui/bar.png");
    private int barx;
    private int bary;

    public ScrollBar() {
        this.width = this.scrollPoint.getWidth();
    }

    public void setValues(int x, int y, int height) {
        this.x = x;
        this.y = y;
        this.space = height - (this.scrollPoint.getHeight() << 1);
        this.barx = x - (this.bar.getWidth() - this.optionBar.getWidth() >> 1) - this.optionBar.getWidth();
        this.bary = y + this.scrollPoint.getHeight();
        this.barCount = Tools.returnNum(this.space, this.bar.getHeight()) + 1;
    }

    public void setValues(int value) {
        this.moveSpeed = MathFP.div(MathFP.toFP(this.space - this.optionBar.getHeight()), MathFP.toFP(value == 1 ? 1 : value - 1));
    }

    public void setBarMove(int index) {
        this.moveY = MathFP.toInt(MathFP.mul(MathFP.toFP(index), this.moveSpeed));
    }

    private final void paint(Graphics g, int color) {
        g.setClip(this.x - this.bar.getWidth(), this.bary, this.bar.getWidth(), this.space);
        for (int i = 0; i < this.barCount; ++i) {
            g.drawImage(this.bar, this.x - this.bar.getWidth(), this.bary + this.bar.getHeight() * i, 20);
        }
        Tools.clearClip(g);
        this.scrollPoint.setPos(this.x - this.scrollPoint.getWidth(), this.y);
        this.scrollPoint.setHeightCurrenFrame(0);
        this.scrollPoint.paint(g);
        this.scrollPoint.setPos(this.x - this.scrollPoint.getWidth(), this.y + this.space + this.scrollPoint.getHeight());
        this.scrollPoint.setHeightCurrenFrame(1);
        this.scrollPoint.paint(g);
        g.drawImage(this.optionBar, this.barx, this.bary + this.moveY, 20);
    }

    public boolean isVisble() {
        return this.visble;
    }

    public void setVisble(boolean visble) {
        this.visble = visble;
    }

    public void paint(Graphics g) {
        if (this.visble) {
            this.paint(g, 0);
        }
    }

    public int keyPressedItem(int key) {
        return 0;
    }
}

