/*
 * Decompiled with CFR 0.152.
 */
package com.game.rms;

import com.game.rms.ContorStream;
import javax.microedition.rms.RecordStore;

public final class GameRms {
    private static final String RECORDNAME = "record";
    public static final byte SEND = 1;
    private static final byte GAME = 2;
    private static final String GAMENAME = "game";

    private static final void writeRMS(byte[] data, String recordName, int index) {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)recordName, (boolean)true);
            if (rs.getNumRecords() < index) {
                for (int i = 1; i < index; ++i) {
                    byte[] tem = null;
                    try {
                        tem = rs.getRecord(i);
                    }
                    catch (Exception ex) {
                        tem = null;
                    }
                    if (tem == null) {
                        rs.addRecord(new byte[]{0}, 0, 1);
                        continue;
                    }
                    if (tem.length < 1) continue;
                }
                rs.addRecord(data, 0, data.length);
            } else {
                rs.setRecord(index, data, 0, data.length);
            }
            rs.closeRecordStore();
            rs = null;
        }
        catch (Exception ex) {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                    rs = null;
                }
                ex.printStackTrace();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
    }

    private static final byte[] readRMS(String recordName, int index) {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)recordName, (boolean)true);
            String[] tem = RecordStore.listRecordStores();
            if (tem == null && rs.getNumRecords() < index) {
                return null;
            }
            byte[] data = null;
            try {
                data = rs.getRecord(index);
            }
            catch (Exception ex) {
                data = null;
            }
            rs.closeRecordStore();
            if (data == null) {
                return null;
            }
            if (data.length == 1) {
                return null;
            }
            return data;
        }
        catch (Exception ex) {
            try {
                if (rs != null) {
                    rs = null;
                }
                ex.printStackTrace();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            return null;
        }
    }

    public static final void writeRecord(byte[] data, int index) {
        try {
            GameRms.writeRMS(data, RECORDNAME, index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final byte[] readRecord(int index) {
        try {
            return GameRms.readRMS(RECORDNAME, index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final String[] readGameName() {
        byte[] data = GameRms.readRecord(2);
        String[] tem = null;
        if (data == null) {
            tem = new String[3];
            for (int i = 0; i < tem.length; ++i) {
                tem[i] = "\u6ca1\u6709\u5b58\u6863";
            }
        } else {
            tem = ContorStream.toByte1StrArray(data);
        }
        return tem;
    }

    public static final void writeGameName(String[] data) {
        GameRms.writeRecord(ContorStream.to1StrArrayByte(data), 2);
    }

    public static final void writeGameData(byte[] data, int index) {
        try {
            GameRms.writeRMS(data, GAMENAME, index + 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final byte[] readGameData(int index) {
        try {
            return GameRms.readRMS(GAMENAME, index + 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

