/*
 * Decompiled with CFR 0.152.
 */
package com.game.role;

import com.IScreen;
import com.game.GameMain;
import com.game.lib.LoadData;
import com.game.lib.MyClip;
import com.game.lib.MySprite;
import com.game.map.MapManager;
import com.util.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class Role
extends MySprite
implements IScreen {
    int roleID;
    MapManager mapManager;
    public static final byte MOVE = 5;
    public static final byte STOP = 4;
    public static final byte TALK = 7;
    public static final byte READYTALK = 6;
    private byte actionState = (byte)4;
    int speed = 6;
    public static final int DOWN = 0;
    public static final int UP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public int dir;
    public int xFrameNum;
    public int yFrameNum;
    protected int curX;
    protected int curY;
    static final byte ACTION = 0;
    static final byte FRAME = 1;
    static final byte DIRSTOP = 1;
    static final byte DIRMOVE = 2;
    private int[][] dirData;
    private int[] keyState = new int[]{-1, -1, -1, -1, -1};
    private MyClip face;
    protected boolean isFace;
    private boolean collidesOn_off = true;

    Role(MapManager mapManager, String spx, String image) {
        this(mapManager);
        LoadData.loadSprite((MySprite)this, spx, Tools.loadImage(image));
    }

    Role(MapManager mapManager) {
        this.dirData = new int[][]{{0, 0, 1}, {0, 2, 3}, {0, 4, 5}, {0, 6, 7}};
        this.mapManager = mapManager;
    }

    Role() {
        this.dirData = new int[][]{{0, 0, 1}, {0, 2, 3}, {0, 4, 5}, {0, 6, 7}};
    }

    Role(MapManager mapManager, Image image, int frameWidth, int frameHeight) {
        super(image, frameWidth, frameHeight);
        this.dirData = new int[][]{{1, -1, -1}, {1, -1, -1}, {1, -1, -1}, {1, -1, -1}};
        this.mapManager = mapManager;
    }

    void loadRole(String spx, String image) {
        LoadData.loadSprite((MySprite)this, spx, Tools.loadImage(image));
    }

    public final void changeDir(int dir) {
        this.changeDir(dir, (byte)1);
    }

    public final void changeDir(int dir, byte type) {
        this.dir = dir;
        if (this.dirData[dir][0] == 0) {
            this.setAction(this.dirData[dir][type]);
        } else if (this.dirData[dir][1] == 1 && this.dirData[dir][1] != -1) {
            this.setFrame(this.dirData[dir][type]);
        }
    }

    public final void setDirData(int[][] dirData) {
        this.dirData = dirData;
    }

    public final void setDirData(int dir, int stopFrame) {
        this.dirData[dir][1] = stopFrame;
    }

    public final void activation() {
        this.setEnabled(true);
        this.setVisbale(true);
    }

    public final void noActivation() {
        this.setEnabled(false);
        this.setVisbale(false);
    }

    public final byte getState() {
        return this.actionState;
    }

    public final void setState(byte state) {
        this.actionState = state;
        switch (state) {
            case 4: {
                this.changeDir(this.dir);
                this.setIsFace(false, 0);
                break;
            }
            case 7: {
                this.changeDir(this.dir);
                this.setIsFace(false, 0);
                break;
            }
            case 6: {
                this.changeDir(this.dir);
                this.setIsFace(true, 0);
                break;
            }
            case 5: {
                this.changeDir(this.dir, (byte)2);
                this.setIsFace(false, 0);
                break;
            }
            default: {
                this.setIsFace(false, 0);
            }
        }
    }

    public final void setRoleMove(int dir) {
        if (this.keyState[dir] != 0) {
            this.changKeyState(dir);
            this.keyState[dir] = 0;
            this.changeDir(dir);
            this.setState((byte)5);
        }
    }

    private final void changKeyState(int index) {
        for (int i = 0; i < this.keyState.length; ++i) {
            if (i == index) continue;
            this.keyState[i] = -1;
        }
    }

    public void draw(Graphics g) {
        if (this.isFace && this.face != null) {
            this.face.setPos(this.getX() + 3 - MapManager.winX, this.getY() - this.face.getHeight() - MapManager.winY);
            this.face.paint(g);
        }
    }

    public abstract void moveRole(int var1);

    abstract void roleLogic();

    public void logic() {
        if (!this.getEnabled()) {
            return;
        }
        if (this.dirData[this.dir][0] != 1) {
            this.updateNext();
        }
        this.roleLogic();
    }

    public final boolean keyRepeatedItem(int key) {
        if (!this.getEnabled()) {
            return false;
        }
        switch (key) {
            case 15: {
                this.setRoleMove(2);
                this.moveRole(2);
                break;
            }
            case 14: {
                this.setRoleMove(0);
                this.moveRole(0);
                break;
            }
            case 13: {
                this.setRoleMove(1);
                this.moveRole(1);
                break;
            }
            case 16: {
                this.setRoleMove(3);
                this.moveRole(3);
                break;
            }
            case -2: {
                if (this.keyState[4] == 0) break;
                this.changKeyState(4);
                this.keyState[4] = 0;
                this.setState((byte)4);
            }
        }
        return false;
    }

    private final boolean moveDown(int value) {
        if (value >= this.mapManager.getMapHeight()) {
            return true;
        }
        this.move(0, this.speed);
        int[] tem = this.collidesHose();
        if (tem != null && this.collidesOn_off) {
            int aa = this.getCollidesY(0) + this.getCollidesHeight(0);
            int bb = aa - this.getY();
            this.setPosition(this.getX(), tem[1] - bb);
            return true;
        }
        return false;
    }

    private final boolean moveUp(int value) {
        if (value <= 0) {
            return true;
        }
        this.move(0, -this.speed);
        int[] tem = this.collidesHose();
        if (tem != null && this.collidesOn_off) {
            int aa = this.getCollidesY(0) - this.getY() - 1;
            this.setPosition(this.getX(), tem[1] + tem[3] - aa);
            return true;
        }
        return false;
    }

    private final boolean moveLeft(int value) {
        if (value <= 0) {
            return true;
        }
        this.move(-this.speed, 0);
        int[] tem = this.collidesHose();
        if (tem != null && this.collidesOn_off) {
            int aa = this.getCollidesX(0) - this.getX();
            this.setPosition(tem[0] + tem[2] - aa, this.getY());
            return true;
        }
        return false;
    }

    private final boolean moveRight(int value) {
        int aa = this.getCollidesX(0) + this.getCollidesWidth(0);
        int bb = aa - this.getX();
        if (value >= this.mapManager.getMapWidth()) {
            this.setPosition(this.mapManager.getMapWidth() - bb, this.getY());
        } else {
            this.move(this.speed, 0);
        }
        int[] tem = this.collidesHose();
        if (tem != null && this.collidesOn_off) {
            this.setPosition(tem[0] - bb, this.getY());
            return true;
        }
        return false;
    }

    final boolean moveRole1(int dir) {
        switch (dir) {
            case 0: {
                return this.moveDown(this.getCollidesY(0) + this.getCollidesHeight(0));
            }
            case 1: {
                return this.moveUp(this.getCollidesY(0) - 10);
            }
            case 2: {
                return this.moveLeft(this.getCollidesX(0));
            }
            case 3: {
                return this.moveRight(this.getCollidesX(0) + this.getCollidesWidth(0));
            }
        }
        return false;
    }

    final boolean moveMounts(int dir) {
        switch (dir) {
            case 0: {
                return this.moveDown(this.getCollidesY(0) + this.getCollidesHeight(0));
            }
            case 1: {
                return this.moveUp(this.getCollidesY(0));
            }
            case 2: {
                return this.moveLeft(this.getCollidesX(0));
            }
            case 3: {
                return this.moveRight(this.getCollidesX(0) + this.getCollidesWidth(0));
            }
        }
        return false;
    }

    abstract int[] collidesHose();

    public void setIsFace(boolean isFace, int faceType) {
        this.isFace = isFace;
        if (isFace) {
            int faceImg = faceType;
            this.face = new MyClip(Tools.loadImage("/res/npc/face/" + faceImg + ".png"), 3, 0, -1);
            this.face.setSpace(100);
            this.face.paly();
        } else {
            this.face = null;
        }
    }

    public int getMapNumX() {
        switch (this.dir) {
            case 0: 
            case 1: 
            case 2: {
                return this.getX() / 12;
            }
            case 3: {
                return (this.getX() + this.getWidth()) / 12;
            }
        }
        return 0;
    }

    public int getMapNumY() {
        switch (this.dir) {
            case 0: {
                return (this.getCollidesY(0) + this.getCollidesHeight(0)) / 12;
            }
            case 1: 
            case 2: 
            case 3: {
                return this.getCollidesY(0) / 12;
            }
        }
        return 0;
    }

    public void setCollidesOn_off(boolean collidesOn_off) {
        this.collidesOn_off = collidesOn_off;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public abstract int getRoleID();

    public boolean moveToDest(int px, int py, int destX, int destY, int moveType) {
        this.curX = this.getMapNumX();
        this.curY = this.getMapNumY();
        GameMain.systemPrintln(this.curX + "," + this.curY);
        switch (moveType) {
            case 0: {
                if (this.curX != destX) {
                    if (this.collidesHose() != null) {
                        if (px < destX) {
                            this.roundMoveX(destY, 0);
                            break;
                        }
                        this.roundMoveX(destY, 1);
                        break;
                    }
                    GameMain.systemPrintln(" 1 if");
                    if (this.curX < destX) {
                        this.move(this.speed, 0);
                        break;
                    }
                    this.move(-this.speed, 0);
                    break;
                }
                if (this.curY == destY) break;
                if (this.collidesHose() != null) {
                    if (py > destY) {
                        this.roundMoveY(destX, 0);
                        break;
                    }
                    this.roundMoveY(destX, 1);
                    break;
                }
                if (this.curY < destY) {
                    this.move(0, this.speed);
                    break;
                }
                this.move(0, -this.speed);
                break;
            }
            case 1: {
                if (this.curY != destY) {
                    if (this.collidesHose() != null) {
                        if (py > destY) {
                            this.roundMoveY(destX, 0);
                            break;
                        }
                        this.roundMoveY(destX, 1);
                        break;
                    }
                    GameMain.systemPrintln(" 1 if");
                    if (this.curY < destY) {
                        this.move(0, this.speed);
                        break;
                    }
                    this.move(0, -this.speed);
                    break;
                }
                if (this.curX == destX) break;
                if (this.collidesHose() != null) {
                    if (px < destX) {
                        this.roundMoveX(destY, 0);
                        break;
                    }
                    this.roundMoveX(destY, 1);
                    break;
                }
                if (this.curX < destX) {
                    this.move(this.speed, 0);
                    break;
                }
                this.move(-this.speed, 0);
            }
        }
        return this.curX == destX && this.curY == destY;
    }

    private void roundMoveX(int dy, int type) {
        switch (type) {
            case 0: {
                if (this.getMapNumY() > dy) {
                    this.move(0, -this.speed);
                    if (this.collidesHose() != null) {
                        return;
                    }
                    if (this.mapManager.map.tiled.getCell(this.getMapNumX() + 1, this.getMapNumY(), 3) != 0) {
                        return;
                    }
                    this.move(this.speed, 0);
                    break;
                }
                this.move(0, this.speed);
                if (this.collidesHose() != null) {
                    return;
                }
                if (this.mapManager.map.tiled.getCell(this.getMapNumX() + 1, this.getMapNumY(), 3) != 0) {
                    return;
                }
                this.move(this.speed, 0);
                break;
            }
            case 1: {
                if (this.getMapNumY() > dy) {
                    this.move(0, -this.speed);
                    if (this.collidesHose() != null) {
                        return;
                    }
                    if (this.mapManager.map.tiled.getCell(this.getMapNumX() - 1, this.getMapNumY(), 3) != 0) {
                        return;
                    }
                    this.move(-this.speed, 0);
                    break;
                }
                this.move(0, this.speed);
                if (this.collidesHose() != null) {
                    return;
                }
                if (this.mapManager.map.tiled.getCell(this.getMapNumX() - 1, this.getMapNumY(), 3) != 0) {
                    return;
                }
                this.move(-this.speed, 0);
            }
        }
    }

    private void roundMoveY(int dx, int type) {
        switch (type) {
            case 0: {
                if (this.getMapNumX() <= dx + 1) {
                    this.move(this.speed, 0);
                    if (this.collidesHose() != null) {
                        return;
                    }
                    if (this.mapManager.map.tiled.getCell(this.getMapNumX(), this.getMapNumY() - 1, 3) != 0) {
                        return;
                    }
                    this.move(0, -this.speed);
                    break;
                }
                this.move(-this.speed, 0);
                if (this.collidesHose() != null) {
                    return;
                }
                if (this.mapManager.map.tiled.getCell(this.getMapNumX(), this.getMapNumY() - 1, 3) != 0) {
                    return;
                }
                this.move(0, -this.speed);
                break;
            }
            case 1: {
                if (this.getMapNumX() <= dx + 1) {
                    this.move(this.speed, 0);
                    if (this.collidesHose() != null) {
                        return;
                    }
                    if (this.mapManager.map.tiled.getCell(this.getMapNumX(), this.getMapNumY() + 1, 3) != 0) {
                        return;
                    }
                    this.move(0, this.speed);
                    break;
                }
                this.move(-this.speed, 0);
                if (this.collidesHose() != null) {
                    return;
                }
                if (this.mapManager.map.tiled.getCell(this.getMapNumX(), this.getMapNumY() + 1, 3) != 0) {
                    return;
                }
                this.move(0, this.speed);
            }
        }
    }

    public boolean judgeXMove(int px, int py, int dx, int dy) {
        return Math.abs(px - dx) > Math.abs(py - dy);
    }

    public boolean getIsFace() {
        return this.isFace;
    }
}

