/*
 * Decompiled with CFR 0.152.
 */
package com.menu;

import com.MainCanvas;
import com.game.GameMain;
import com.game.map.ui.lib.UITitle;
import com.game.rms.GameRms;
import com.game.tishi.TipListener;
import com.menu.Menu;
import com.util.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class UIRestore {
    private GameMain gameMain;
    private int type;
    String[] rest;
    UITitle title;
    private TipListener tipListener;
    private int keyMenuIndex;
    private Image button;
    private boolean isMenu;

    public UIRestore() {
        this.isMenu = true;
    }

    public UIRestore(GameMain gameMain, TipListener tipListener) {
        this.gameMain = gameMain;
        this.tipListener = tipListener;
    }

    public UIRestore(GameMain gameMain) {
        this.gameMain = gameMain;
    }

    public void init(int type) {
        this.type = type;
        int width = 230;
        this.title = new UITitle();
        this.title.setBound(5, 5, width, 30);
        this.title.setTitle(Tools.loadImage("/res/ui/titleText.png"), 0, 10, 1);
        this.rest = GameRms.readGameName();
    }

    public void paint(Graphics g) {
        if (this.isMenu) {
            GameMain.frame.drawmFrameForBigFrame(g, 0, 0, 240, 320);
        }
        g.setFont(Tools.defaultFont);
        int frameX = this.title.getX() + 10;
        int frameY = this.title.getHeight() + this.title.getY();
        int hh = Tools.DEFAULFONT_HEIGHT + 10;
        int space = 5;
        this.title.paint(g);
        for (int i = 0; i < this.rest.length; ++i) {
            GameMain.frame.drawFrameRoundConner(g, frameX, frameY + i * (space + hh), this.title.getWidth() - 20, hh);
            if (i == this.keyMenuIndex) {
                g.setColor(15851107);
            } else {
                g.setColor(0xFFFFFF);
            }
            int xx = (this.title.getWidth() - Tools.defaultFont.stringWidth(this.rest[i])) / 2;
            g.drawString(this.rest[i], frameX + xx - 10, frameY + i * (space + hh) + 5, 0);
        }
        this.drawButton(g, true, true);
    }

    public final void destroy() {
        this.rest = null;
        System.gc();
    }

    public int keypressed(int key) {
        switch (key) {
            case 14: {
                this.keyMenuIndex = (this.keyMenuIndex + 1) % 3;
                break;
            }
            case 13: {
                if (this.keyMenuIndex == 0) {
                    this.keyMenuIndex = 3;
                }
                this.keyMenuIndex = (this.keyMenuIndex - 1) % 3;
                break;
            }
            case 17: 
            case 19: {
                if (this.type == 0) {
                    this.gameMain.saveGame(this.keyMenuIndex);
                    this.rest[this.keyMenuIndex] = Tools.getTime();
                    GameRms.writeGameName(this.rest);
                    if (this.tipListener == null) break;
                    this.tipListener.setTipString(new String[]{"\u4fdd\u5b58\u6210\u529f"}, (byte)1);
                    break;
                }
                if (this.rest[this.keyMenuIndex].equals("\u6ca1\u6709\u5b58\u6863")) break;
                GameMain.isReadGame = true;
                GameMain.resIndex = this.keyMenuIndex;
                if (this.isMenu) {
                    MainCanvas.intiGame = 1;
                    MainCanvas.changeState(2);
                    Menu.state = 1;
                    break;
                }
                this.gameMain.switchMap();
                break;
            }
            case 18: {
                return 1;
            }
        }
        return -1;
    }

    private final void drawButton(Graphics g, boolean left, boolean right) {
        if (this.button == null) {
            this.button = Tools.loadImage("/res/ui/button.png");
        }
        if (left) {
            Tools.ImageClip(g, this.button, 5, 315, this.button.getWidth() >> 1, this.button.getHeight(), 0, 0, 36);
        }
        if (right) {
            Tools.ImageClip(g, this.button, 235, 315, this.button.getWidth() >> 1, this.button.getHeight(), 0, 1, 40);
        }
    }
}

