/*
 * Decompiled with CFR 0.152.
 */
package com.util;

import com.game.GameMain;
import com.game.lib.MyTiledLayer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Random;
import java.util.TimeZone;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Tools {
    public static final int SCREEN_WIDTH = 240;
    public static final int SCREEN_HEIGHT = 320;
    public static final int G_LT = 20;
    public static final int G_RT = 24;
    public static final int G_LB = 36;
    public static final int G_RB = 40;
    public static final int G_LV = 6;
    public static final int G_RV = 10;
    public static final int G_TH = 17;
    public static final int G_BH = 33;
    public static final int G_HV = 3;
    public static final Font defaultFont = Font.getFont((int)0, (int)0, (int)8);
    public static final int DEFAULFONT_HEIGHT = defaultFont.getHeight() + 3;
    public static final int SPACE_LFONT_WIDTH = defaultFont.stringWidth("\u963f") + 5;
    public static final int SPACE_LFONT_HEIGHT = DEFAULFONT_HEIGHT + 2;
    public static final int defaultColor = 0xFFFFFF;
    public static final int selectColor = 15851107;
    private static final Random random = new Random();
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int WEATHER_NONE = 1000;
    public static final int RAIN = 1001;
    public static final int RAINWITHLIGHTNING = 1002;
    public static final int LIGHTNING = 1003;
    public static final int SNOW = 1004;
    public static final int HEAVY_SNOW = 1005;

    public static final boolean getProbability(int probability) {
        int tem1;
        int rand = Tools.getRand(1, 100);
        int tem = Tools.getRand(rand * 100);
        return tem <= (tem1 = rand * probability);
    }

    public static final int getRand(int range) {
        return (random.nextInt() & Integer.MAX_VALUE) % range;
    }

    public static final int getRand(int min, int max) {
        return Tools.getRand(max - min + 1) + min;
    }

    public static final int getRand(int[] num) {
        return num[Tools.getRand(0, num.length - 1)];
    }

    public static final Image loadImage(String path) {
        Image img = null;
        if (path == null) {
            return null;
        }
        try {
            img = Image.createImage((String)path);
        }
        catch (Exception ex) {
            GameMain.systemPrintln(path + "\u5a11???\u3129????");
        }
        return img;
    }

    public static final void drawLine(Graphics g, int color, int x, int y, int x1, int y1, int height) {
        int i;
        g.setColor(color);
        if (x == x1) {
            for (i = 0; i < height; ++i) {
                g.drawLine(x + i, y, x1 + i, y1);
            }
        }
        if (y == y1) {
            for (i = 0; i < height; ++i) {
                g.drawLine(x, y + i, x1, y1 + i);
            }
        }
    }

    public static final String getTime() {
        TimeZone t = TimeZone.getDefault();
        Calendar c = Calendar.getInstance(t);
        StringBuffer sb = new StringBuffer();
        sb.append(c.get(2) + 1);
        sb.append("/");
        sb.append(c.get(5) + "  ");
        sb.append(c.get(11));
        sb.append(":");
        sb.append(c.get(12));
        return sb.toString();
    }

    public static final void clearScreen(Graphics g, int color) {
        g.setColor(color);
        g.fillRect(0, 0, 240, 320);
    }

    public static final void clearClip(Graphics g) {
        g.setClip(0, 0, 240, 320);
    }

    public static final void clearScreenOrClip(Graphics g, int color) {
        g.setColor(color);
        g.fillRect(0, 0, 240, 320);
        g.setClip(0, 0, 240, 320);
    }

    public static final int returnItemIndex(int itemIndex, int number, int type) {
        switch (type) {
            case 0: {
                itemIndex = itemIndex - 1 < 0 && number > 0 ? number - 1 : --itemIndex;
                return itemIndex;
            }
            case 1: {
                return (itemIndex + 1) % number;
            }
        }
        return 0;
    }

    public static final int returnNum(int num, int num1) {
        return num % num1 != 0 ? num / num1 + 1 : num / num1;
    }

    public static int drawStringA(Graphics g, String str, int x, int y, int w, int h, int line) {
        int strHeight = g.getFont().getHeight();
        int strWidth = g.getFont().stringWidth("\u963f");
        int len = str.length();
        int wordsInLines = w / strWidth;
        int lines = len / wordsInLines + 1;
        if (len % wordsInLines == 0) {
            --lines;
        }
        for (int i = 0; i < lines; ++i) {
            g.drawSubstring(str, wordsInLines * i, wordsInLines + wordsInLines * i > len ? len - wordsInLines * i : wordsInLines, x, y + strHeight * i, 20);
        }
        return line + lines;
    }

    public static final int drawString(Graphics g, String str, int x, int y, int w, int h, int RGP, int move) {
        g.setClip(x, y, w, h);
        g.setColor(RGP);
        int hc = 0;
        int len = str.length();
        int i = 0;
        char c = '\u0000';
        int count = 0;
        for (int j = 0; j < len; j += c == '\n' ? i + 1 : i) {
            while ((c = str.charAt(i + j)) != '\n' && defaultFont.substringWidth(str, j, i + 1) < w && ++i + j < len) {
            }
            g.drawSubstring(str, j, i, x, y + DEFAULFONT_HEIGHT * count - move, 20);
            i = 0;
            if (++count <= h / DEFAULFONT_HEIGHT) continue;
            hc = 1;
        }
        if (hc == 1) {
            hc = h / DEFAULFONT_HEIGHT * DEFAULFONT_HEIGHT + (count - h / DEFAULFONT_HEIGHT) * DEFAULFONT_HEIGHT;
        }
        Tools.clearClip(g);
        return hc;
    }

    public static final void drawStringShadow(Graphics g, int preColor, int backColor, String str, int x, int y, int w, int h, int move) {
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        Tools.drawString(g, str, x, y, w, h, backColor, move);
        Tools.drawString(g, str, x - 1, y, w, h, backColor, move);
        Tools.drawString(g, str, x + 1, y, w, h, backColor, move);
        Tools.drawString(g, str, x, y + 1, w, h, backColor, move);
        Tools.drawString(g, str, x, y - 1, w, h, backColor, move);
        Tools.drawString(g, str, x + 1, y - 1, w, h, backColor, move);
        Tools.drawString(g, str, x - 1, y - 1, w, h, backColor, move);
        Tools.drawString(g, str, x + 1, y + 1, w, h, backColor, move);
        Tools.drawString(g, str, x - 1, y + 1, w, h, backColor, move);
        Tools.drawString(g, str, x, y, w, h, preColor, move);
    }

    public static final int drawString(Graphics g, String str, int x, int y, int w, int h, int[] RGP, int move) {
        g.setClip(x, y, w, h);
        int line = -1;
        int hc = 0;
        int len = str.length();
        int i = 0;
        char c = '\u0000';
        int count = 0;
        for (int j = 0; j < len; j += c == '\n' ? i + 1 : i) {
            block5: {
                do {
                    if ((c = str.charAt(i + j)) == '\n') {
                        if (++line > RGP.length - 1) {
                            line = 0;
                        }
                        g.setColor(RGP[line]);
                        break block5;
                    }
                    if (defaultFont.substringWidth(str, j, i + 1) >= w) break block5;
                } while (++i + j < len);
                line = 0;
            }
            g.drawSubstring(str, j, i, x, y + DEFAULFONT_HEIGHT * count - move, 20);
            i = 0;
            if (++count <= h / DEFAULFONT_HEIGHT) continue;
            hc = 1;
        }
        if (hc == 1) {
            hc = h / DEFAULFONT_HEIGHT * DEFAULFONT_HEIGHT + (count - h / DEFAULFONT_HEIGHT) * DEFAULFONT_HEIGHT;
        }
        Tools.clearClip(g);
        return hc;
    }

    public static final int drawString(Graphics g, String[] str, int x, int y, int w, int h, int[] RGP, int move) {
        g.setClip(x, y, w, h);
        int line = 0;
        int hc = 0;
        for (int i = 0; i < str.length; ++i) {
            g.setColor(RGP[i]);
            line = Tools.drawStringA(g, str[i], x, y + line * g.getFont().getHeight() - move, w, h, line);
        }
        if (line > h / DEFAULFONT_HEIGHT) {
            hc = 1;
        }
        if (hc == 1) {
            hc = h / DEFAULFONT_HEIGHT * DEFAULFONT_HEIGHT + (line - h / DEFAULFONT_HEIGHT) * DEFAULFONT_HEIGHT;
        }
        Tools.clearClip(g);
        return hc;
    }

    public static int getStringLen(String s) {
        int a = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.substring(i, i + 1).equals("#") || s.substring(i, i + 1).equals("$")) continue;
            ++a;
        }
        return a;
    }

    public static final void drawString(Graphics g, String str, int x, int y, int w, int h, int RGP, int pageSize, int currenPage) {
        int j1;
        g.setClip(x, y, w, h);
        g.setColor(RGP);
        int len = str.length();
        int j = 0;
        int wordsInLines = w / SPACE_LFONT_WIDTH;
        int lineMax = h / SPACE_LFONT_HEIGHT;
        for (j1 = 0; j1 < len && j != currenPage * pageSize * wordsInLines; ++j1, ++j) {
            String s = str.substring(j1, j1 + 1);
            if (s.equals("#")) {
                g.setColor(0xFF0000);
                --j;
                continue;
            }
            if (!s.equals("$")) continue;
            g.setColor(RGP);
            --j;
        }
        j = j1;
        for (int i = 0; i < lineMax; ++i) {
            for (int k = j += i == 0 ? 0 : wordsInLines; k < j + wordsInLines; ++k) {
                if (k + 1 > str.length()) {
                    Tools.clearClip(g);
                    return;
                }
                String s = str.substring(k, k + 1);
                if (s.equals("#")) {
                    g.setColor(0xFF0000);
                    ++j;
                    continue;
                }
                if (s.equals("$")) {
                    g.setColor(RGP);
                    ++j;
                    continue;
                }
                g.drawSubstring(str, k, 1, x + (k - j) * SPACE_LFONT_WIDTH, y + SPACE_LFONT_HEIGHT * i, 20);
            }
        }
        Tools.clearClip(g);
    }

    public static int getStringLines(String str, int w, int fontW) {
        int strWidth = fontW;
        int len = Tools.getStringLen(str);
        int wordsInLines = w / strWidth;
        int lines = len / wordsInLines + 1;
        if (len % wordsInLines == 0) {
            --lines;
        }
        return lines;
    }

    public static final int getStringCol(String str, int w) {
        int len = str.length();
        int j = 0;
        int i = 0;
        char c = '\u0000';
        int count = 0;
        while (j < len) {
            do {
                int num = 0;
                c = str.charAt(i + j);
                if (c == '\n') break;
                if (str.charAt(i + j) != '#' && str.charAt(i + j) != '$') continue;
                ++num;
            } while (defaultFont.substringWidth(str, j, i + 1) < w && ++i + j < len);
            j += c == '\n' ? i + 1 : i;
            i = 0;
            ++count;
        }
        return count;
    }

    public static final String int2str(int num) {
        return Integer.toString(num);
    }

    public static final int str2int(String str) {
        if (str == null || str.equals("")) {
            return 0;
        }
        int returnValue = 0;
        try {
            returnValue = str.startsWith("0x") || str.startsWith("0X") ? Integer.parseInt(str.substring(2), 16) : Integer.parseInt(str);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnValue;
    }

    public static final int[] getIKeyValue(String source, String splitFormat) {
        String[] tmpArr = Tools.splitStr(source, splitFormat);
        int[] returnIntArr = null;
        if (tmpArr != null) {
            returnIntArr = new int[tmpArr.length];
            for (int i = 0; i < tmpArr.length; ++i) {
                returnIntArr[i] = Tools.str2int(tmpArr[i]);
            }
        }
        tmpArr = null;
        return returnIntArr;
    }

    public static final void ImageClip(Graphics g, Image img, int x, int y, int frameWidth, int frameHeight, int transform, int currenFrame, int anchor) {
        int temSequenceIndex = currenFrame + 1;
        int twframe = img.getWidth() / frameWidth;
        int curtyFrame = temSequenceIndex % twframe == 0 ? temSequenceIndex / twframe - 1 : temSequenceIndex / twframe;
        int curtxFrame = currenFrame - curtyFrame * twframe;
        int tx = curtxFrame * frameWidth;
        int ty = curtyFrame * frameHeight;
        g.drawRegion(img, tx, ty, frameWidth, frameHeight, transform, x, y, anchor);
    }

    public static final void ImageClip(Graphics g, Image img, int x, int y, int frameWidth, int frameHeight, int currenFrame, int type) {
        g.setClip(x, y, frameWidth, frameHeight);
        switch (type) {
            case 0: {
                g.drawImage(img, x, y - currenFrame * frameHeight, 0);
                break;
            }
            case 1: {
                g.drawImage(img, x - currenFrame * frameWidth, y, 0);
                break;
            }
            case 2: {
                int twframe = img.getWidth() / frameWidth;
                g.drawImage(img, x - currenFrame % twframe * frameWidth, y - currenFrame / twframe * frameHeight, 0);
            }
        }
        g.setClip(0, 0, 240, 320);
    }

    public static final int drawNum(Graphics g, Image img1, int score, int x, int y, int fram) {
        int len = Integer.toString(score).length();
        int drawX = x + 2;
        int frameWidth = img1.getWidth() / fram;
        int frameHeight = img1.getHeight();
        for (int j = len; j > 0; --j) {
            int i = score % Tools.pow(10, j) / (j - 1 >= 1 ? Tools.pow(10, j - 1) : 1);
            Tools.ImageClip(g, img1, drawX, y, frameWidth, frameHeight, 0, i, 0);
            drawX += img1.getWidth() / fram;
        }
        return drawX;
    }

    public static final int drawNum(Graphics g, Image img1, int score, int x, int y, int fram, int anchor) {
        int j;
        int len = Integer.toString(score).length();
        int frameWidth = img1.getWidth() / fram;
        int imgWidth = (score < 0 ? len - 1 : len) * frameWidth;
        int drawX = x;
        int drawY = y;
        int frameHeight = img1.getHeight();
        switch (anchor) {
            case 20: {
                break;
            }
            case 40: {
                drawX = x - imgWidth;
                drawY = y - frameHeight;
                break;
            }
            case 3: {
                drawX = x - imgWidth / 2 + 1;
                drawY = y - (frameHeight >> 1);
            }
        }
        int tem = Math.abs(score);
        int n = j = score < 0 ? len - 1 : len;
        while (j > 0) {
            int i = tem % Tools.pow(10, j) / (j - 1 >= 1 ? Tools.pow(10, j - 1) : 1);
            Tools.ImageClip(g, img1, drawX, drawY, frameWidth, frameHeight, 0, i, 0);
            drawX += frameWidth;
            --j;
        }
        return drawX + (imgWidth >> 1);
    }

    public static final int drawNum(Graphics g, Image img1, int score, int score1, int x, int y, int fram, int indexfram) {
        int drawX = Tools.drawNum(g, img1, score, x, y, fram);
        int frameWidth = img1.getWidth() / fram;
        int frameHeight = img1.getHeight();
        Tools.ImageClip(g, img1, drawX, y, frameWidth, frameHeight, 0, indexfram, 0);
        drawX += img1.getWidth() / fram - 4;
        drawX = Tools.drawNum(g, img1, score1, drawX, y, fram);
        return drawX;
    }

    public static final MyTiledLayer getFightBack(String fileName) {
        try {
            InputStream is = "".getClass().getResourceAsStream("/res/fight/data/" + fileName);
            if (is == null) {
                throw new IOException("\u8be5\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
            byte[] data = new byte[is.available()];
            is.read(data);
            is.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            data = null;
            DataInputStream di = new DataInputStream(bis);
            di.readByte();
            di.readUTF();
            int cols = di.readShort();
            int rows = di.readShort();
            Image mapImage = Image.createImage((String)("/res/map/image/" + di.readUTF()));
            MyTiledLayer tiled = new MyTiledLayer(cols, rows, mapImage);
            di.readByte();
            di.readBoolean();
            int len = di.readByte();
            short[][] terraArrary = new short[rows][cols];
            short[][] buildingArrary = new short[rows][cols];
            short[][] coveringArrary = null;
            if (len > 2) {
                coveringArrary = new short[rows][cols];
            }
            for (int i = 0; i < len; ++i) {
                for (int j = 0; j < rows; ++j) {
                    block9: for (int k = 0; k < cols; ++k) {
                        switch (i) {
                            case 0: {
                                terraArrary[j][k] = di.readShort();
                                continue block9;
                            }
                            case 1: {
                                buildingArrary[j][k] = di.readShort();
                                continue block9;
                            }
                            case 2: {
                                coveringArrary[j][k] = di.readShort();
                            }
                        }
                    }
                }
            }
            tiled.setArraryData(terraArrary, (byte)1);
            tiled.setArraryData(buildingArrary, (byte)3);
            if (coveringArrary != null) {
                tiled.setArraryData(coveringArrary, (byte)2);
            }
            tiled.setPosition(0, 0);
            di.close();
            bis.close();
            terraArrary = null;
            buildingArrary = null;
            mapImage = null;
            Runtime.getRuntime().gc();
            return tiled;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final MyTiledLayer getMap(String fileName) {
        InputStream is = fileName.getClass().getResourceAsStream(fileName);
        if (is == null) {
            return null;
        }
        try {
            byte[] data1 = new byte[is.available()];
            is.read(data1);
            is.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(data1);
            data1 = null;
            DataInputStream di = new DataInputStream(bis);
            int cols = di.readShort();
            int rows = di.readShort();
            short[][] data = new short[rows][cols];
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    data[i][j] = di.readShort();
                }
            }
            byte[] imgData = new byte[di.readInt()];
            di.read(imgData);
            Image img = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
            MyTiledLayer map = new MyTiledLayer(cols, rows, img, data);
            img = null;
            imgData = null;
            data = null;
            di.close();
            bis.close();
            Runtime.getRuntime().gc();
            return map;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final int[][] eXPandArray(int[][] oldArray, int expandBy) {
        int[][] newArray = new int[oldArray.length + expandBy][];
        System.arraycopy(oldArray, 0, newArray, 0, expandBy == -1 ? oldArray.length - 1 : oldArray.length);
        return newArray;
    }

    public static final int[] eXPandArray(int[] oldArray, int expandBy) {
        int[] newArray = new int[oldArray.length + expandBy];
        System.arraycopy(oldArray, 0, newArray, 0, expandBy == -1 ? oldArray.length - 1 : oldArray.length);
        return newArray;
    }

    public static final String[] splitStr(String source, String splitStr) {
        if (source == null || splitStr == null) {
            return null;
        }
        int startIndex = 0;
        String[] returnStrArr = null;
        while (startIndex < source.length()) {
            String[] tmp;
            int splitIndex = source.indexOf(splitStr, startIndex);
            if (splitIndex != -1) {
                if (!source.substring(startIndex, splitIndex).equals("")) {
                    if (returnStrArr == null) {
                        returnStrArr = new String[1];
                    } else {
                        tmp = new String[returnStrArr.length + 1];
                        System.arraycopy(returnStrArr, 0, tmp, 0, returnStrArr.length);
                        returnStrArr = tmp;
                    }
                    returnStrArr[returnStrArr.length - 1] = source.substring(startIndex, splitIndex);
                }
                startIndex = splitIndex + splitStr.length();
                continue;
            }
            if (source.substring(startIndex).equals("")) break;
            if (returnStrArr == null) {
                returnStrArr = new String[1];
            } else {
                tmp = new String[returnStrArr.length + 1];
                System.arraycopy(returnStrArr, 0, tmp, 0, returnStrArr.length);
                returnStrArr = tmp;
            }
            returnStrArr[returnStrArr.length - 1] = source.substring(startIndex);
            break;
        }
        return returnStrArr;
    }

    public static final Object getArraryInt(String src) {
        if (src.equals("n")) {
            return null;
        }
        String[] tem = Tools.splitStr(src, "&");
        if (tem != null) {
            if (tem.length == 1) {
                String[] tem1 = Tools.splitStr(src, "|");
                int[] otem = new int[tem1.length];
                for (int i = 0; i < otem.length; ++i) {
                    otem[i] = Integer.parseInt(tem1[i]);
                }
                return otem;
            }
            int[][] atem = new int[tem.length][];
            for (int k = 0; k < tem.length; ++k) {
                String[] tem2 = Tools.splitStr(tem[k], "|");
                atem[k] = new int[tem2.length];
                for (int j = 0; j < tem2.length; ++j) {
                    atem[k][j] = Integer.parseInt(tem2[j]);
                }
            }
            return atem;
        }
        return null;
    }

    public static final int pow(int a, int b) {
        int temp = a;
        if (b == 0) {
            return 1;
        }
        if (b == 1) {
            return a;
        }
        if (b > 1) {
            for (int i = 0; i < b - 1; ++i) {
                a *= temp;
            }
        }
        return a;
    }

    private static final int renturnNumX(int num1, int num2, int w, int w1) {
        int len = Integer.toString(num1).length();
        int len1 = Integer.toString(num2).length();
        int x = w1 - (len * w + len1 * w + w) >> 2;
        return x *= 3;
    }
}

