/*
 * Decompiled with CFR 0.152.
 */
package com.game.util;

import com.game.sprite.RectPoint;
import com.game.util.ArrayList;
import com.game.util.MathFP;
import com.game.util.OString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Random;
import java.util.TimeZone;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public final class Tools {
    private static final String[] PATHS = new String[]{"/res/", "/res/ui/", "/res/map/resource/", "/res/mode/", "/res/map/data/", "/res/script/", "/res/nopage/"};
    private static final String[] RESPATHS = new String[]{"", "ui_", "map_resource_", "mode_", "map_data_", "script_"};
    private static final String[] FILE_TYPE = new String[]{"png", "sprite", "bin", "mid"};
    private static final Random random = new Random();
    public static final int DEFAUL_COLOR = 0xFFFFFF;
    private static final Font DEFAUL_FONT = Font.getFont((int)0, (int)0, (int)8);
    public static final int DEFAUL_FONT_HEIGHT = DEFAUL_FONT.getHeight();
    public static final int FONT_WIDTH = DEFAUL_FONT.charWidth('\u4f60');
    public static final int EN_FONT_WIDTH = DEFAUL_FONT.charWidth('a');
    public static final byte RES = 0;
    public static final byte RES_UI = 1;
    public static final byte RES_MAP_RESOURCE = 2;
    public static final byte RES_MODE = 3;
    public static final byte RES_MAP_DATA = 4;
    public static final byte RES_SCRIPT = 5;
    public static final byte RES_NOPAGE = 6;
    public static final byte PNG = 0;
    public static final byte SPRITE = 1;
    public static final byte BIN = 2;
    public static final byte MID = 3;
    public static final byte NOTTYPE = -1;
    private static int ranInt2;
    private static String[] title;
    private static byte[][] dataList;
    static byte[] HEADChunk;
    static byte[] IENDChunk;

    public static final String getDirectory(byte dir, String fileName, byte fileType) {
        return Tools.getDirectory(dir, fileName, fileType, true);
    }

    public static final String getDirectory(byte dir, String fileName, byte fileType, boolean isResData) {
        StringBuffer sb = new StringBuffer();
        sb.append(isResData ? RESPATHS[dir] : PATHS[dir]);
        sb.append(fileName);
        if (fileType != -1) {
            sb.append(".");
            sb.append(FILE_TYPE[fileType]);
        }
        return sb.toString();
    }

    public static final Font getFont() {
        return DEFAUL_FONT;
    }

    public static final boolean getProbability(int probability) {
        int tem1;
        int rand = Tools.getRand(1, 100);
        int tem = Tools.getRand(rand * 100);
        return tem <= (tem1 = rand * probability);
    }

    public static final void setSeed(long seed) {
        random.setSeed(seed);
    }

    public static final int getRand(int range) {
        return Tools.getRand(0, range);
    }

    public static final int getRand(int min, int max) {
        int ranInt = Math.abs(random.nextInt()) % (max + 1 - min);
        return ranInt + min;
    }

    public static final int getRand(int[] num) {
        return num[Tools.getRand(0, num.length - 1)];
    }

    public static final int getRandHurt(int hurt) {
        int ranInt1 = Tools.getRand(90, 110);
        while (ranInt1 == ranInt2) {
            ranInt1 = Tools.getRand(90, 110);
        }
        hurt = hurt * ranInt1 / 100;
        ranInt2 = ranInt1;
        if (hurt <= 0) {
            hurt = Tools.getRand(1, 10);
        }
        return hurt;
    }

    public static final void loadResData(String path) {
        try {
            int i;
            ByteArrayInputStream bais = new ByteArrayInputStream(Tools.loadFile(path, false));
            DataInputStream dis = new DataInputStream(bais);
            int len = dis.readShort();
            title = new String[len];
            int[] fileSize = new int[len];
            dataList = new byte[len][];
            for (i = 0; i < len; ++i) {
                Tools.title[i] = dis.readUTF();
                fileSize[i] = dis.readInt();
            }
            for (i = 0; i < len; ++i) {
                Tools.dataList[i] = new byte[fileSize[i]];
                dis.read(dataList[i], 0, fileSize[i]);
            }
            dis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static final byte[] getData(String key) {
        for (int i = 0; i < title.length; ++i) {
            if (!title[i].equals(key)) continue;
            return dataList[i];
        }
        return null;
    }

    public static final byte[] loadFile(String path) {
        return Tools.loadFile(path, true);
    }

    public static final InputStream loadFileStream(String path) {
        return new ByteArrayInputStream(Tools.loadFile(path));
    }

    public static final byte[] loadFile(String path, boolean isResData) {
        try {
            InputStream inStream = path.getClass().getResourceAsStream(path);
            if (inStream == null) {
                throw new IOException(path + "\ufffd\u013c\ufffd\ufffd\u04b2\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            byte[] data = new byte[inStream.available()];
            inStream.read(data);
            inStream.close();
            return data;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final DataInputStream convertStream(byte[] data) {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        return new DataInputStream(bais);
    }

    public static final void writeRMS(byte[] data, String recordName, int index) {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)recordName, (boolean)true);
            if (rs.getNumRecords() < index) {
                for (int i = 1; i < index; ++i) {
                    byte[] tem = null;
                    try {
                        tem = rs.getRecord(i);
                    }
                    catch (Exception ex) {
                        tem = null;
                    }
                    if (tem == null) {
                        rs.addRecord(new byte[]{0}, 0, 1);
                        continue;
                    }
                    if (tem.length < 1) continue;
                }
                rs.addRecord(data, 0, data.length);
            } else {
                rs.setRecord(index, data, 0, data.length);
            }
            rs.closeRecordStore();
            rs = null;
        }
        catch (Exception ex) {
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                    rs = null;
                }
                ex.printStackTrace();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }
    }

    public static final DataInputStream readRMS(String recordName, int index) {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)recordName, (boolean)true);
            String[] tem = RecordStore.listRecordStores();
            if (tem == null && rs.getNumRecords() < index) {
                return null;
            }
            byte[] data = null;
            try {
                data = rs.getRecord(index);
            }
            catch (Exception ex) {
                data = null;
            }
            rs.closeRecordStore();
            if (data == null) {
                return null;
            }
            if (data.length == 1) {
                return null;
            }
            return Tools.convertStream(data);
        }
        catch (Exception ex) {
            try {
                if (rs != null) {
                    rs = null;
                }
                ex.printStackTrace();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
            return null;
        }
    }

    public static final String getTime() {
        Calendar c = Calendar.getInstance(TimeZone.getDefault());
        StringBuffer sb = new StringBuffer();
        sb.append(c.get(1));
        sb.append("-");
        sb.append(c.get(2) + 1);
        sb.append("-");
        sb.append(c.get(5));
        sb.append(" ");
        sb.append(c.get(11));
        sb.append(":");
        sb.append(c.get(12));
        return sb.toString();
    }

    public static final int returnItemIndex(int itemIndex, int number, int type) {
        switch (type) {
            case 0: {
                itemIndex = itemIndex - 1 < 0 && number > 0 ? number - 1 : --itemIndex;
                return itemIndex;
            }
            case 1: {
                return (itemIndex + 1) % number;
            }
        }
        return 0;
    }

    public static final int pow(int a, int b) {
        int temp = a;
        if (b == 0) {
            return 1;
        }
        if (b == 1) {
            return a;
        }
        if (b > 1) {
            for (int i = 0; i < b - 1; ++i) {
                a *= temp;
            }
        }
        return a;
    }

    public static final int getNumberLenght(int number) {
        int len = 1;
        int tem = Math.abs(number);
        while (tem > 9) {
            tem /= 10;
            ++len;
        }
        return len;
    }

    public static final int getTiaoWidth(int ctw, int endNumber, int bNumber) {
        if (bNumber < endNumber && endNumber != bNumber && endNumber > 0) {
            ctw = MathFP.toInt(MathFP.mul(MathFP.div(MathFP.toFP(ctw), MathFP.toFP(endNumber)), MathFP.toFP(bNumber)));
        }
        return ctw;
    }

    public static final int[][] exPandArray(int[][] oldArray, int expandBy) {
        int[][] newArray = new int[oldArray.length + expandBy][];
        System.arraycopy(oldArray, 0, newArray, 0, expandBy == -1 ? oldArray.length - 1 : oldArray.length);
        return newArray;
    }

    public static final int[] exPandArray(int[] oldArray, int expandBy) {
        int[] newArray = new int[oldArray.length + expandBy];
        System.arraycopy(oldArray, 0, newArray, 0, expandBy == -1 ? oldArray.length - 1 : oldArray.length);
        return newArray;
    }

    public static final byte[] exPandArray(byte[] oldArray, int expandBy) {
        byte[] newArray = new byte[oldArray.length + expandBy];
        System.arraycopy(oldArray, 0, newArray, 0, expandBy == -1 ? oldArray.length - 1 : oldArray.length);
        return newArray;
    }

    public static final boolean intersectRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 + height2 > y1 && y2 < y1 + height1 && x2 + width2 > x1 && x2 < x1 + width1;
    }

    public static boolean intersectRect(RectPoint rect1, RectPoint rect2) {
        return Tools.intersectRect(rect1.x, rect1.y, rect1.w, rect1.h, rect2.x, rect2.y, rect2.w, rect2.h);
    }

    public static boolean intersectRect(RectPoint rect1, int x2, int y2, int width2, int height2) {
        return Tools.intersectRect(rect1.x, rect1.y, rect1.w, rect1.h, x2, y2, width2, height2);
    }

    public static final int str2int(String str) {
        if (str == null || str.equals("")) {
            return 0;
        }
        if (str.equals("true")) {
            return 1;
        }
        if (str.equals("false")) {
            return 0;
        }
        int returnValue = 0;
        try {
            returnValue = str.startsWith("0x") || str.startsWith("0X") ? Integer.parseInt(str.substring(2), 16) : Integer.parseInt(str);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return returnValue;
    }

    public static final int[] getIntKeyValue(String source, char splitFormat) {
        String[] tmpArr = Tools.split(source, splitFormat);
        int[] returnIntArr = null;
        if (tmpArr != null) {
            returnIntArr = new int[tmpArr.length];
            for (int i = 0; i < tmpArr.length; ++i) {
                returnIntArr[i] = Tools.str2int(tmpArr[i]);
            }
        }
        tmpArr = null;
        return returnIntArr;
    }

    public static final int getStringWidth(String str) {
        return DEFAUL_FONT.stringWidth(str);
    }

    public static final int getLine(OString str, int width) {
        int j = 0;
        int line = 1;
        int len = str.length();
        int lw = 0;
        while (j < len) {
            char c = str.charAt(j);
            if (c == '\n') {
                lw = 0;
                ++line;
                ++j;
                continue;
            }
            lw += Tools.getCharWidth(c);
            if (++j >= len) continue;
            c = str.charAt(j);
            if (lw <= width && lw + Tools.getCharWidth(c) <= width) continue;
            lw = 0;
            ++line;
        }
        return line;
    }

    public static final int getCharWidth(char c) {
        int width = 0;
        width = Tools.isChinese(c) ? FONT_WIDTH : EN_FONT_WIDTH;
        return width;
    }

    private static final boolean isChinese(char c) {
        return c >= '\u0100' || c < '\u0000';
    }

    public static final String[] split(String value, char delimiter) {
        char[] valueChars = value.toCharArray();
        int lastIndex = 0;
        ArrayList strings = null;
        for (int i = 0; i < valueChars.length; ++i) {
            char c = valueChars[i];
            if (c != delimiter) continue;
            if (strings == null) {
                strings = new ArrayList();
            }
            strings.add(new String(valueChars, lastIndex, i - lastIndex));
            lastIndex = i + 1;
        }
        if (strings == null) {
            return new String[]{value};
        }
        strings.add(new String(valueChars, lastIndex, valueChars.length - lastIndex));
        return (String[])strings.toArray(new String[strings.size()]);
    }

    public static final Image loadImage(String path) {
        return Tools.loadImage(path, true);
    }

    public static final Image loadImage(String path, boolean isPage) {
        return Tools.createImage(path, false, isPage);
    }

    private static final Image createImage(String path, boolean readPng, boolean isPage) {
        try {
            byte[] data = Tools.loadFile(path, isPage);
            if (data == null) {
                return null;
            }
            if (readPng) {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.write(HEADChunk);
                dos.write(data);
                dis.close();
                dos.write(IENDChunk);
                data = baos.toByteArray();
                baos.close();
            }
            return Image.createImage((byte[])data, (int)0, (int)data.length);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static {
        HEADChunk = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        IENDChunk = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    }
}

